// 'use client';

// import Link, { LinkProps } from 'next/link';
// import { usePathname, useRouter } from 'next/navigation';
// import { useState, useEffect } from 'react';
// import { LogOutIcon, MoonIcon, SunIcon, SearchIcon, MenuIcon } from 'lucide-react';
// import clsx from 'clsx';
// import { useAuth } from '@/context/AuthContext';
// import { motion, MotionProps } from 'framer-motion';

// const navItems = [
//   { name: 'Dashboard', path: '/dashboard' },
//   { name: 'Products', path: '/products' },
//   { name: 'Quality Processes', path: '/quality-processes' },
//   { name: 'Documents', path: '/documents' },
//   { name: 'Audits', path: '/audits' },
// ];

// const MotionLink = motion.create<LinkProps>(props => <Link {...props} />) as unknown as React.ComponentType<MotionProps & React.ComponentProps<typeof Link>>;

// interface NavbarProps {
//   onMobileToggle: () => void;
// }

// export default function Navbar({ onMobileToggle }: NavbarProps) {
//   const [darkMode, setDarkMode] = useState(false);
//   const [search, setSearch] = useState('');
//   const pathname = usePathname();
//   const { logout } = useAuth();
//   const router = useRouter();

//   useEffect(() => {
//     const stored = localStorage.getItem('dark-mode');
//     if (stored === 'true') {
//       setDarkMode(true);
//       document.documentElement.classList.add('dark');
//     }
//   }, []);

//   useEffect(() => {
//     document.documentElement.classList.toggle('dark', darkMode);
//     localStorage.setItem('dark-mode', darkMode.toString());
//   }, [darkMode]);

//   const handleSearch = () => {
//     if (search.trim()) {
//       router.push(`/search?q=${encodeURIComponent(search)}`);
//       setSearch('');
//     }
//   };

//   const handleLogout = () => {
//     logout();
//     router.push('/login');
//   };

//   return (
//     <nav className="sticky top-0 z-30 px-4 sm:px-6 py-3 bg-green-600 dark:bg-gray-800 text-white shadow-md">
//       <div className="max-w-7xl mx-auto flex items-center justify-between gap-4 flex-wrap">
//         <div className="flex items-center gap-4">
//           <button
//             className="lg:hidden p-2 rounded-md hover:bg-green-700"
//             onClick={onMobileToggle}
//           >
//             <MenuIcon className="w-6 h-6" />
//           </button>
//           <div className="text-xl sm:text-2xl font-bold">QMS System</div>
//         </div>

//         <div className="flex items-center gap-4 flex-1 justify-end">
//           {/* Search bar */}
//           <div className="relative flex items-center bg-white/10 rounded-md px-2 py-1 w-full max-w-xs sm:max-w-sm">
//             <input
//               type="text"
//               value={search}
//               onChange={(e) => setSearch(e.target.value)}
//               onKeyPress={(e) => e.key === 'Enter' && handleSearch()}
//               placeholder="Search..."
//               className="flex-1 bg-transparent outline-none text-white placeholder-white/70 text-sm pr-8"
//             />
//             <button
//               onClick={handleSearch}
//               className="absolute right-2 text-white hover:text-green-200"
//             >
//               <SearchIcon className="w-4 h-4" />
//             </button>
//           </div>

//           <div className="hidden lg:flex items-center gap-4">
//             {navItems.map((item) => (
//               <MotionLink
//                 key={item.path}
//                 href={item.path}
//                 className={clsx(
//                   'text-sm lg:text-base transition-colors hover:text-green-200',
//                   pathname === item.path ? 'text-white font-semibold' : 'text-green-100'
//                 )}
//                 whileHover={{ scale: 1.05 }}
//                 whileTap={{ scale: 0.95 }}
//               >
//                 {item.name}
//               </MotionLink>
//             ))}
//           </div>

//           <motion.button
//             whileHover={{ scale: 1.05 }}
//             whileTap={{ scale: 0.95 }}
//             onClick={() => setDarkMode(!darkMode)}
//             className="p-2 rounded-md hover:bg-green-700"
//           >
//             {darkMode ? (
//               <SunIcon className="w-5 h-5 text-yellow-400" />
//             ) : (
//               <MoonIcon className="w-5 h-5 text-white" />
//             )}
//           </motion.button>

//           <motion.button
//             whileHover={{ scale: 1.05 }}
//             whileTap={{ scale: 0.95 }}
//             onClick={handleLogout}
//             className="flex items-center gap-2 text-red-300 hover:text-red-100"
//           >
//             <LogOutIcon className="w-5 h-5" />
//             <span className="hidden sm:inline text-sm">Logout</span>
//           </motion.button>
//         </div>
//       </div>
//     </nav>
//   );
// }