'use client';

import QmsCard from "../components/QmsCard";

export default function Dashboard() {
  return (
    <div className="flex min-h-screen bg-gray-100">
      <main className="flex-1 w-full px-4 py-2 sm:px-5 sm:py-3">
        <h1 className="text-2xl sm:text-3xl font-bold text-gray-800 mb-2 sm:mb-3">
          Welcome to Quality Management System
        </h1>

        <p className="text-gray-600 text-base sm:text-lg mb-4 sm:mb-6">
          This system is designed to comply with ISO 13485:2016 standards for medical devices.
        </p>

        <div className="grid gap-4 sm:gap-6 grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 animate-fade-in-up">
          <QmsCard
            title="Products"
            description="Manage medical device products and specifications"
            href="/products"
            count={42}
          />
          <QmsCard
            title="Quality Processes"
            description="View and manage SOPs, CAPA, Deviations"
            href="/quality-processes"
            count={18}
          />
          <QmsCard
            title="Audits"
            description="Track internal and external audit logs"
            href="/audits"
            count={9}
          />
          <QmsCard
            title="Documents"
            description="Access QMS-related documents and templates"
            href="/documents"
            count={76}
          />
        </div>
      </main>
    </div>
  );
}
