export const highlightMatch = (label: string, term: string) => {
  if (!term) return label;

  const regex = new RegExp(`(${term})`, 'gi');
  const parts = label.split(regex);

  return parts.map((part, index) =>
    part.toLowerCase() === term.toLowerCase() ? (
      <span key={index} className="bg-green-300 dark:bg-green-600 rounded-sm px-0.5">
        {part}
      </span>
    ) : (
      <span key={index}>{part}</span>
    )
  );
};
