/**
 * @license React
 * react-dom-profiling.development.js
 *
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

/*
 Modernizr 3.0.0pre (Custom Build) | MIT
*/
"use strict";
"production" !== process.env.NODE_ENV &&
  (function () {
    function findHook(fiber, id) {
      for (fiber = fiber.memoizedState; null !== fiber && 0 < id; )
        (fiber = fiber.next), id--;
      return fiber;
    }
    function copyWithSetImpl(obj, path, index, value) {
      if (index >= path.length) return value;
      var key = path[index],
        updated = isArrayImpl(obj) ? obj.slice() : assign({}, obj);
      updated[key] = copyWithSetImpl(obj[key], path, index + 1, value);
      return updated;
    }
    function copyWithRename(obj, oldPath, newPath) {
      if (oldPath.length !== newPath.length)
        console.warn("copyWithRename() expects paths of the same length");
      else {
        for (var i = 0; i < newPath.length - 1; i++)
          if (oldPath[i] !== newPath[i]) {
            console.warn(
              "copyWithRename() expects paths to be the same except for the deepest key"
            );
            return;
          }
        return copyWithRenameImpl(obj, oldPath, newPath, 0);
      }
    }
    function copyWithRenameImpl(obj, oldPath, newPath, index) {
      var oldKey = oldPath[index],
        updated = isArrayImpl(obj) ? obj.slice() : assign({}, obj);
      index + 1 === oldPath.length
        ? ((updated[newPath[index]] = updated[oldKey]),
          isArrayImpl(updated)
            ? updated.splice(oldKey, 1)
            : delete updated[oldKey])
        : (updated[oldKey] = copyWithRenameImpl(
            obj[oldKey],
            oldPath,
            newPath,
            index + 1
          ));
      return updated;
    }
    function copyWithDeleteImpl(obj, path, index) {
      var key = path[index],
        updated = isArrayImpl(obj) ? obj.slice() : assign({}, obj);
      if (index + 1 === path.length)
        return (
          isArrayImpl(updated) ? updated.splice(key, 1) : delete updated[key],
          updated
        );
      updated[key] = copyWithDeleteImpl(obj[key], path, index + 1);
      return updated;
    }
    function shouldSuspendImpl() {
      return !1;
    }
    function shouldErrorImpl() {
      return null;
    }
    function warnInvalidHookAccess() {
      console.error(
        "Do not call Hooks inside useEffect(...), useMemo(...), or other built-in Hooks. You can only call Hooks at the top level of your React function. For more information, see https://react.dev/link/rules-of-hooks"
      );
    }
    function warnInvalidContextAccess() {
      console.error(
        "Context can only be read while React is rendering. In classes, you can read it in the render method or getDerivedStateFromProps. In function components, you can read it directly in the function body, but not inside Hooks like useReducer() or useMemo()."
      );
    }
    function noop() {}
    function warnForMissingKey() {}
    function setToSortedString(set) {
      var array = [];
      set.forEach(function (value) {
        array.push(value);
      });
      return array.sort().join(", ");
    }
    function createFiber(tag, pendingProps, key, mode) {
      return new FiberNode(tag, pendingProps, key, mode);
    }
    function scheduleRoot(root, element) {
      root.context === emptyContextObject &&
        (updateContainerImpl(root.current, 2, element, root, null, null),
        flushSyncWork$1());
    }
    function scheduleRefresh(root, update) {
      if (null !== resolveFamily) {
        var staleFamilies = update.staleFamilies;
        update = update.updatedFamilies;
        flushPendingEffects();
        scheduleFibersWithFamiliesRecursively(
          root.current,
          update,
          staleFamilies
        );
        flushSyncWork$1();
      }
    }
    function setRefreshHandler(handler) {
      resolveFamily = handler;
    }
    function isValidContainer(node) {
      return !(
        !node ||
        (1 !== node.nodeType && 9 !== node.nodeType && 11 !== node.nodeType)
      );
    }
    function getNearestMountedFiber(fiber) {
      var node = fiber,
        nearestMounted = fiber;
      if (fiber.alternate) for (; node.return; ) node = node.return;
      else {
        fiber = node;
        do
          (node = fiber),
            0 !== (node.flags & 4098) && (nearestMounted = node.return),
            (fiber = node.return);
        while (fiber);
      }
      return 3 === node.tag ? nearestMounted : null;
    }
    function getSuspenseInstanceFromFiber(fiber) {
      if (13 === fiber.tag) {
        var suspenseState = fiber.memoizedState;
        null === suspenseState &&
          ((fiber = fiber.alternate),
          null !== fiber && (suspenseState = fiber.memoizedState));
        if (null !== suspenseState) return suspenseState.dehydrated;
      }
      return null;
    }
    function getActivityInstanceFromFiber(fiber) {
      if (31 === fiber.tag) {
        var activityState = fiber.memoizedState;
        null === activityState &&
          ((fiber = fiber.alternate),
          null !== fiber && (activityState = fiber.memoizedState));
        if (null !== activityState) return activityState.dehydrated;
      }
      return null;
    }
    function assertIsMounted(fiber) {
      if (getNearestMountedFiber(fiber) !== fiber)
        throw Error("Unable to find node on an unmounted component.");
    }
    function findCurrentFiberUsingSlowPath(fiber) {
      var alternate = fiber.alternate;
      if (!alternate) {
        alternate = getNearestMountedFiber(fiber);
        if (null === alternate)
          throw Error("Unable to find node on an unmounted component.");
        return alternate !== fiber ? null : fiber;
      }
      for (var a = fiber, b = alternate; ; ) {
        var parentA = a.return;
        if (null === parentA) break;
        var parentB = parentA.alternate;
        if (null === parentB) {
          b = parentA.return;
          if (null !== b) {
            a = b;
            continue;
          }
          break;
        }
        if (parentA.child === parentB.child) {
          for (parentB = parentA.child; parentB; ) {
            if (parentB === a) return assertIsMounted(parentA), fiber;
            if (parentB === b) return assertIsMounted(parentA), alternate;
            parentB = parentB.sibling;
          }
          throw Error("Unable to find node on an unmounted component.");
        }
        if (a.return !== b.return) (a = parentA), (b = parentB);
        else {
          for (var didFindChild = !1, _child = parentA.child; _child; ) {
            if (_child === a) {
              didFindChild = !0;
              a = parentA;
              b = parentB;
              break;
            }
            if (_child === b) {
              didFindChild = !0;
              b = parentA;
              a = parentB;
              break;
            }
            _child = _child.sibling;
          }
          if (!didFindChild) {
            for (_child = parentB.child; _child; ) {
              if (_child === a) {
                didFindChild = !0;
                a = parentB;
                b = parentA;
                break;
              }
              if (_child === b) {
                didFindChild = !0;
                b = parentB;
                a = parentA;
                break;
              }
              _child = _child.sibling;
            }
            if (!didFindChild)
              throw Error(
                "Child was not found in either parent set. This indicates a bug in React related to the return pointer. Please file an issue."
              );
          }
        }
        if (a.alternate !== b)
          throw Error(
            "Return fibers should always be each others' alternates. This error is likely caused by a bug in React. Please file an issue."
          );
      }
      if (3 !== a.tag)
        throw Error("Unable to find node on an unmounted component.");
      return a.stateNode.current === a ? fiber : alternate;
    }
    function findCurrentHostFiberImpl(node) {
      var tag = node.tag;
      if (5 === tag || 26 === tag || 27 === tag || 6 === tag) return node;
      for (node = node.child; null !== node; ) {
        tag = findCurrentHostFiberImpl(node);
        if (null !== tag) return tag;
        node = node.sibling;
      }
      return null;
    }
    function traverseVisibleHostChildren(
      child,
      searchWithinHosts,
      fn,
      a,
      b,
      c
    ) {
      for (; null !== child; ) {
        if (
          (5 === child.tag && fn(child, a, b, c)) ||
          ((22 !== child.tag || null === child.memoizedState) &&
            (searchWithinHosts || 5 !== child.tag) &&
            traverseVisibleHostChildren(
              child.child,
              searchWithinHosts,
              fn,
              a,
              b,
              c
            ))
        )
          return !0;
        child = child.sibling;
      }
      return !1;
    }
    function getFragmentParentHostFiber(fiber) {
      for (fiber = fiber.return; null !== fiber; ) {
        if (3 === fiber.tag || 5 === fiber.tag) return fiber;
        fiber = fiber.return;
      }
      return null;
    }
    function getInstanceFromHostFiber(fiber) {
      switch (fiber.tag) {
        case 5:
          return fiber.stateNode;
        case 3:
          return fiber.stateNode.containerInfo;
        default:
          throw Error("Expected to find a host node. This is a bug in React.");
      }
    }
    function findNextSibling(child) {
      searchTarget = child;
      return !0;
    }
    function isFiberContainedBy(maybeChild, maybeParent) {
      maybeParent = maybeParent.return;
      if (maybeParent === maybeChild || maybeParent === maybeChild.alternate)
        return !0;
      for (; null !== maybeParent && maybeParent !== maybeChild; ) {
        if (
          !(
            (5 !== maybeParent.tag && 3 !== maybeParent.tag) ||
            (maybeParent.return !== maybeChild &&
              maybeParent.return !== maybeChild.alternate)
          )
        )
          return !0;
        maybeParent = maybeParent.return;
      }
      return !1;
    }
    function isFiberPrecedingCheck(child, target, boundary) {
      return child === boundary
        ? !0
        : child === target
          ? ((searchTarget = child), !0)
          : !1;
    }
    function isFiberFollowingCheck(child, target, boundary) {
      return child === boundary
        ? ((searchBoundary = child), !1)
        : child === target
          ? (null !== searchBoundary && (searchTarget = child), !0)
          : !1;
    }
    function getParentForFragmentAncestors(inst) {
      if (null === inst) return null;
      do inst = null === inst ? null : inst.return;
      while (inst && 5 !== inst.tag && 27 !== inst.tag && 3 !== inst.tag);
      return inst ? inst : null;
    }
    function getLowestCommonAncestor(instA, instB, getParent) {
      for (var depthA = 0, tempA = instA; tempA; tempA = getParent(tempA))
        depthA++;
      tempA = 0;
      for (var tempB = instB; tempB; tempB = getParent(tempB)) tempA++;
      for (; 0 < depthA - tempA; ) (instA = getParent(instA)), depthA--;
      for (; 0 < tempA - depthA; ) (instB = getParent(instB)), tempA--;
      for (; depthA--; ) {
        if (instA === instB || (null !== instB && instA === instB.alternate))
          return instA;
        instA = getParent(instA);
        instB = getParent(instB);
      }
      return null;
    }
    function getIteratorFn(maybeIterable) {
      if (null === maybeIterable || "object" !== typeof maybeIterable)
        return null;
      maybeIterable =
        (MAYBE_ITERATOR_SYMBOL && maybeIterable[MAYBE_ITERATOR_SYMBOL]) ||
        maybeIterable["@@iterator"];
      return "function" === typeof maybeIterable ? maybeIterable : null;
    }
    function getComponentNameFromType(type) {
      if (null == type) return null;
      if ("function" === typeof type)
        return type.$$typeof === REACT_CLIENT_REFERENCE
          ? null
          : type.displayName || type.name || null;
      if ("string" === typeof type) return type;
      switch (type) {
        case REACT_FRAGMENT_TYPE:
          return "Fragment";
        case REACT_PROFILER_TYPE:
          return "Profiler";
        case REACT_STRICT_MODE_TYPE:
          return "StrictMode";
        case REACT_SUSPENSE_TYPE:
          return "Suspense";
        case REACT_SUSPENSE_LIST_TYPE:
          return "SuspenseList";
        case REACT_ACTIVITY_TYPE:
          return "Activity";
        case REACT_VIEW_TRANSITION_TYPE:
          return "ViewTransition";
      }
      if ("object" === typeof type)
        switch (
          ("number" === typeof type.tag &&
            console.error(
              "Received an unexpected object in getComponentNameFromType(). This is likely a bug in React. Please file an issue."
            ),
          type.$$typeof)
        ) {
          case REACT_PORTAL_TYPE:
            return "Portal";
          case REACT_CONTEXT_TYPE:
            return type.displayName || "Context";
          case REACT_CONSUMER_TYPE:
            return (type._context.displayName || "Context") + ".Consumer";
          case REACT_FORWARD_REF_TYPE:
            var innerType = type.render;
            type = type.displayName;
            type ||
              ((type = innerType.displayName || innerType.name || ""),
              (type = "" !== type ? "ForwardRef(" + type + ")" : "ForwardRef"));
            return type;
          case REACT_MEMO_TYPE:
            return (
              (innerType = type.displayName || null),
              null !== innerType
                ? innerType
                : getComponentNameFromType(type.type) || "Memo"
            );
          case REACT_LAZY_TYPE:
            innerType = type._payload;
            type = type._init;
            try {
              return getComponentNameFromType(type(innerType));
            } catch (x) {}
        }
      return null;
    }
    function getComponentNameFromOwner(owner) {
      return "number" === typeof owner.tag
        ? getComponentNameFromFiber(owner)
        : "string" === typeof owner.name
          ? owner.name
          : null;
    }
    function getComponentNameFromFiber(fiber) {
      var type = fiber.type;
      switch (fiber.tag) {
        case 31:
          return "Activity";
        case 24:
          return "Cache";
        case 9:
          return (type._context.displayName || "Context") + ".Consumer";
        case 10:
          return type.displayName || "Context";
        case 18:
          return "DehydratedFragment";
        case 11:
          return (
            (fiber = type.render),
            (fiber = fiber.displayName || fiber.name || ""),
            type.displayName ||
              ("" !== fiber ? "ForwardRef(" + fiber + ")" : "ForwardRef")
          );
        case 7:
          return "Fragment";
        case 26:
        case 27:
        case 5:
          return type;
        case 4:
          return "Portal";
        case 3:
          return "Root";
        case 6:
          return "Text";
        case 16:
          return getComponentNameFromType(type);
        case 8:
          return type === REACT_STRICT_MODE_TYPE ? "StrictMode" : "Mode";
        case 22:
          return "Offscreen";
        case 12:
          return "Profiler";
        case 21:
          return "Scope";
        case 13:
          return "Suspense";
        case 19:
          return "SuspenseList";
        case 25:
          return "TracingMarker";
        case 30:
          return "ViewTransition";
        case 1:
        case 0:
        case 14:
        case 15:
          if ("function" === typeof type)
            return type.displayName || type.name || null;
          if ("string" === typeof type) return type;
          break;
        case 29:
          type = fiber._debugInfo;
          if (null != type)
            for (var i = type.length - 1; 0 <= i; i--)
              if ("string" === typeof type[i].name) return type[i].name;
          if (null !== fiber.return)
            return getComponentNameFromFiber(fiber.return);
      }
      return null;
    }
    function resolveDispatcher() {
      var dispatcher = ReactSharedInternals.H;
      null === dispatcher &&
        console.error(
          "Invalid hook call. Hooks can only be called inside of the body of a function component. This could happen for one of the following reasons:\n1. You might have mismatching versions of React and the renderer (such as React DOM)\n2. You might be breaking the Rules of Hooks\n3. You might have more than one copy of React in the same app\nSee https://react.dev/link/invalid-hook-call for tips about how to debug and fix this problem."
        );
      return dispatcher;
    }
    function setSrcObject(domElement, tag, value) {
      function cleanUp() {
        URL.revokeObjectURL(url);
        domElement.removeEventListener(loadEvent, cleanUp);
        domElement.removeEventListener("error", cleanUp);
      }
      var url = URL.createObjectURL(value),
        loadEvent = "img" === tag ? "load" : "loadstart";
      domElement.addEventListener(loadEvent, cleanUp);
      domElement.addEventListener("error", cleanUp);
      domElement.setAttribute("src", url);
    }
    function createCursor(defaultValue) {
      return { current: defaultValue };
    }
    function pop(cursor, fiber) {
      0 > index$jscomp$0
        ? console.error("Unexpected pop.")
        : (fiber !== fiberStack[index$jscomp$0] &&
            console.error("Unexpected Fiber popped."),
          (cursor.current = valueStack[index$jscomp$0]),
          (valueStack[index$jscomp$0] = null),
          (fiberStack[index$jscomp$0] = null),
          index$jscomp$0--);
    }
    function push(cursor, value, fiber) {
      index$jscomp$0++;
      valueStack[index$jscomp$0] = cursor.current;
      fiberStack[index$jscomp$0] = fiber;
      cursor.current = value;
    }
    function requiredContext(c) {
      null === c &&
        console.error(
          "Expected host context to exist. This error is likely caused by a bug in React. Please file an issue."
        );
      return c;
    }
    function pushHostContainer(fiber, nextRootInstance) {
      push(rootInstanceStackCursor, nextRootInstance, fiber);
      push(contextFiberStackCursor, fiber, fiber);
      push(contextStackCursor, null, fiber);
      var nextRootContext = nextRootInstance.nodeType;
      switch (nextRootContext) {
        case 9:
        case 11:
          nextRootContext = 9 === nextRootContext ? "#document" : "#fragment";
          nextRootInstance = (nextRootInstance =
            nextRootInstance.documentElement)
            ? (nextRootInstance = nextRootInstance.namespaceURI)
              ? getOwnHostContext(nextRootInstance)
              : HostContextNamespaceNone
            : HostContextNamespaceNone;
          break;
        default:
          if (
            ((nextRootContext = nextRootInstance.tagName),
            (nextRootInstance = nextRootInstance.namespaceURI))
          )
            (nextRootInstance = getOwnHostContext(nextRootInstance)),
              (nextRootInstance = getChildHostContextProd(
                nextRootInstance,
                nextRootContext
              ));
          else
            switch (nextRootContext) {
              case "svg":
                nextRootInstance = HostContextNamespaceSvg;
                break;
              case "math":
                nextRootInstance = HostContextNamespaceMath;
                break;
              default:
                nextRootInstance = HostContextNamespaceNone;
            }
      }
      nextRootContext = nextRootContext.toLowerCase();
      nextRootContext = updatedAncestorInfoDev(null, nextRootContext);
      nextRootContext = {
        context: nextRootInstance,
        ancestorInfo: nextRootContext
      };
      pop(contextStackCursor, fiber);
      push(contextStackCursor, nextRootContext, fiber);
    }
    function popHostContainer(fiber) {
      pop(contextStackCursor, fiber);
      pop(contextFiberStackCursor, fiber);
      pop(rootInstanceStackCursor, fiber);
    }
    function getHostContext() {
      return requiredContext(contextStackCursor.current);
    }
    function pushHostContext(fiber) {
      null !== fiber.memoizedState &&
        push(hostTransitionProviderCursor, fiber, fiber);
      var context = requiredContext(contextStackCursor.current);
      var type = fiber.type;
      var nextContext = getChildHostContextProd(context.context, type);
      type = updatedAncestorInfoDev(context.ancestorInfo, type);
      nextContext = { context: nextContext, ancestorInfo: type };
      context !== nextContext &&
        (push(contextFiberStackCursor, fiber, fiber),
        push(contextStackCursor, nextContext, fiber));
    }
    function popHostContext(fiber) {
      contextFiberStackCursor.current === fiber &&
        (pop(contextStackCursor, fiber), pop(contextFiberStackCursor, fiber));
      hostTransitionProviderCursor.current === fiber &&
        (pop(hostTransitionProviderCursor, fiber),
        (HostTransitionContext._currentValue = NotPendingTransition));
    }
    function disabledLog() {}
    function disableLogs() {
      if (0 === disabledDepth) {
        prevLog = console.log;
        prevInfo = console.info;
        prevWarn = console.warn;
        prevError = console.error;
        prevGroup = console.group;
        prevGroupCollapsed = console.groupCollapsed;
        prevGroupEnd = console.groupEnd;
        var props = {
          configurable: !0,
          enumerable: !0,
          value: disabledLog,
          writable: !0
        };
        Object.defineProperties(console, {
          info: props,
          log: props,
          warn: props,
          error: props,
          group: props,
          groupCollapsed: props,
          groupEnd: props
        });
      }
      disabledDepth++;
    }
    function reenableLogs() {
      disabledDepth--;
      if (0 === disabledDepth) {
        var props = { configurable: !0, enumerable: !0, writable: !0 };
        Object.defineProperties(console, {
          log: assign({}, props, { value: prevLog }),
          info: assign({}, props, { value: prevInfo }),
          warn: assign({}, props, { value: prevWarn }),
          error: assign({}, props, { value: prevError }),
          group: assign({}, props, { value: prevGroup }),
          groupCollapsed: assign({}, props, { value: prevGroupCollapsed }),
          groupEnd: assign({}, props, { value: prevGroupEnd })
        });
      }
      0 > disabledDepth &&
        console.error(
          "disabledDepth fell below zero. This is a bug in React. Please file an issue."
        );
    }
    function formatOwnerStack(error) {
      var prevPrepareStackTrace = Error.prepareStackTrace;
      Error.prepareStackTrace = void 0;
      error = error.stack;
      Error.prepareStackTrace = prevPrepareStackTrace;
      error.startsWith("Error: react-stack-top-frame\n") &&
        (error = error.slice(29));
      prevPrepareStackTrace = error.indexOf("\n");
      -1 !== prevPrepareStackTrace &&
        (error = error.slice(prevPrepareStackTrace + 1));
      prevPrepareStackTrace = error.indexOf("react_stack_bottom_frame");
      -1 !== prevPrepareStackTrace &&
        (prevPrepareStackTrace = error.lastIndexOf(
          "\n",
          prevPrepareStackTrace
        ));
      if (-1 !== prevPrepareStackTrace)
        error = error.slice(0, prevPrepareStackTrace);
      else return "";
      return error;
    }
    function describeBuiltInComponentFrame(name) {
      if (void 0 === prefix)
        try {
          throw Error();
        } catch (x) {
          var match = x.stack.trim().match(/\n( *(at )?)/);
          prefix = (match && match[1]) || "";
          suffix =
            -1 < x.stack.indexOf("\n    at")
              ? " (<anonymous>)"
              : -1 < x.stack.indexOf("@")
                ? "@unknown:0:0"
                : "";
        }
      return "\n" + prefix + name + suffix;
    }
    function describeNativeComponentFrame(fn, construct) {
      if (!fn || reentry) return "";
      var frame = componentFrameCache.get(fn);
      if (void 0 !== frame) return frame;
      reentry = !0;
      frame = Error.prepareStackTrace;
      Error.prepareStackTrace = void 0;
      var previousDispatcher = null;
      previousDispatcher = ReactSharedInternals.H;
      ReactSharedInternals.H = null;
      disableLogs();
      try {
        var RunInRootFrame = {
          DetermineComponentFrameRoot: function () {
            try {
              if (construct) {
                var Fake = function () {
                  throw Error();
                };
                Object.defineProperty(Fake.prototype, "props", {
                  set: function () {
                    throw Error();
                  }
                });
                if ("object" === typeof Reflect && Reflect.construct) {
                  try {
                    Reflect.construct(Fake, []);
                  } catch (x) {
                    var control = x;
                  }
                  Reflect.construct(fn, [], Fake);
                } else {
                  try {
                    Fake.call();
                  } catch (x$0) {
                    control = x$0;
                  }
                  fn.call(Fake.prototype);
                }
              } else {
                try {
                  throw Error();
                } catch (x$1) {
                  control = x$1;
                }
                (Fake = fn()) &&
                  "function" === typeof Fake.catch &&
                  Fake.catch(function () {});
              }
            } catch (sample) {
              if (sample && control && "string" === typeof sample.stack)
                return [sample.stack, control.stack];
            }
            return [null, null];
          }
        };
        RunInRootFrame.DetermineComponentFrameRoot.displayName =
          "DetermineComponentFrameRoot";
        var namePropDescriptor = Object.getOwnPropertyDescriptor(
          RunInRootFrame.DetermineComponentFrameRoot,
          "name"
        );
        namePropDescriptor &&
          namePropDescriptor.configurable &&
          Object.defineProperty(
            RunInRootFrame.DetermineComponentFrameRoot,
            "name",
            { value: "DetermineComponentFrameRoot" }
          );
        var _RunInRootFrame$Deter =
            RunInRootFrame.DetermineComponentFrameRoot(),
          sampleStack = _RunInRootFrame$Deter[0],
          controlStack = _RunInRootFrame$Deter[1];
        if (sampleStack && controlStack) {
          var sampleLines = sampleStack.split("\n"),
            controlLines = controlStack.split("\n");
          for (
            _RunInRootFrame$Deter = namePropDescriptor = 0;
            namePropDescriptor < sampleLines.length &&
            !sampleLines[namePropDescriptor].includes(
              "DetermineComponentFrameRoot"
            );

          )
            namePropDescriptor++;
          for (
            ;
            _RunInRootFrame$Deter < controlLines.length &&
            !controlLines[_RunInRootFrame$Deter].includes(
              "DetermineComponentFrameRoot"
            );

          )
            _RunInRootFrame$Deter++;
          if (
            namePropDescriptor === sampleLines.length ||
            _RunInRootFrame$Deter === controlLines.length
          )
            for (
              namePropDescriptor = sampleLines.length - 1,
                _RunInRootFrame$Deter = controlLines.length - 1;
              1 <= namePropDescriptor &&
              0 <= _RunInRootFrame$Deter &&
              sampleLines[namePropDescriptor] !==
                controlLines[_RunInRootFrame$Deter];

            )
              _RunInRootFrame$Deter--;
          for (
            ;
            1 <= namePropDescriptor && 0 <= _RunInRootFrame$Deter;
            namePropDescriptor--, _RunInRootFrame$Deter--
          )
            if (
              sampleLines[namePropDescriptor] !==
              controlLines[_RunInRootFrame$Deter]
            ) {
              if (1 !== namePropDescriptor || 1 !== _RunInRootFrame$Deter) {
                do
                  if (
                    (namePropDescriptor--,
                    _RunInRootFrame$Deter--,
                    0 > _RunInRootFrame$Deter ||
                      sampleLines[namePropDescriptor] !==
                        controlLines[_RunInRootFrame$Deter])
                  ) {
                    var _frame =
                      "\n" +
                      sampleLines[namePropDescriptor].replace(
                        " at new ",
                        " at "
                      );
                    fn.displayName &&
                      _frame.includes("<anonymous>") &&
                      (_frame = _frame.replace("<anonymous>", fn.displayName));
                    "function" === typeof fn &&
                      componentFrameCache.set(fn, _frame);
                    return _frame;
                  }
                while (1 <= namePropDescriptor && 0 <= _RunInRootFrame$Deter);
              }
              break;
            }
        }
      } finally {
        (reentry = !1),
          (ReactSharedInternals.H = previousDispatcher),
          reenableLogs(),
          (Error.prepareStackTrace = frame);
      }
      sampleLines = (sampleLines = fn ? fn.displayName || fn.name : "")
        ? describeBuiltInComponentFrame(sampleLines)
        : "";
      "function" === typeof fn && componentFrameCache.set(fn, sampleLines);
      return sampleLines;
    }
    function describeFiber(fiber, childFiber) {
      switch (fiber.tag) {
        case 26:
        case 27:
        case 5:
          return describeBuiltInComponentFrame(fiber.type);
        case 16:
          return describeBuiltInComponentFrame("Lazy");
        case 13:
          return fiber.child !== childFiber && null !== childFiber
            ? describeBuiltInComponentFrame("Suspense Fallback")
            : describeBuiltInComponentFrame("Suspense");
        case 19:
          return describeBuiltInComponentFrame("SuspenseList");
        case 0:
        case 15:
          return describeNativeComponentFrame(fiber.type, !1);
        case 11:
          return describeNativeComponentFrame(fiber.type.render, !1);
        case 1:
          return describeNativeComponentFrame(fiber.type, !0);
        case 31:
          return describeBuiltInComponentFrame("Activity");
        case 30:
          return describeBuiltInComponentFrame("ViewTransition");
        default:
          return "";
      }
    }
    function getStackByFiberInDevAndProd(workInProgress) {
      try {
        var info = "",
          previous = null;
        do {
          info += describeFiber(workInProgress, previous);
          var debugInfo = workInProgress._debugInfo;
          if (debugInfo)
            for (var i = debugInfo.length - 1; 0 <= i; i--) {
              var entry = debugInfo[i];
              if ("string" === typeof entry.name) {
                var JSCompiler_temp_const = info;
                a: {
                  var name = entry.name,
                    env = entry.env,
                    location = entry.debugLocation;
                  if (null != location) {
                    var childStack = formatOwnerStack(location),
                      idx = childStack.lastIndexOf("\n"),
                      lastLine =
                        -1 === idx ? childStack : childStack.slice(idx + 1);
                    if (-1 !== lastLine.indexOf(name)) {
                      var JSCompiler_inline_result = "\n" + lastLine;
                      break a;
                    }
                  }
                  JSCompiler_inline_result = describeBuiltInComponentFrame(
                    name + (env ? " [" + env + "]" : "")
                  );
                }
                info = JSCompiler_temp_const + JSCompiler_inline_result;
              }
            }
          previous = workInProgress;
          workInProgress = workInProgress.return;
        } while (workInProgress);
        return info;
      } catch (x) {
        return "\nError generating stack: " + x.message + "\n" + x.stack;
      }
    }
    function describeFunctionComponentFrameWithoutLineNumber(fn) {
      return (fn = fn ? fn.displayName || fn.name : "")
        ? describeBuiltInComponentFrame(fn)
        : "";
    }
    function getCurrentFiberOwnerNameInDevOrNull() {
      if (null === current) return null;
      var owner = current._debugOwner;
      return null != owner ? getComponentNameFromOwner(owner) : null;
    }
    function getCurrentFiberStackInDev() {
      if (null === current) return "";
      var workInProgress = current;
      try {
        var info = "";
        6 === workInProgress.tag && (workInProgress = workInProgress.return);
        switch (workInProgress.tag) {
          case 26:
          case 27:
          case 5:
            info += describeBuiltInComponentFrame(workInProgress.type);
            break;
          case 13:
            info += describeBuiltInComponentFrame("Suspense");
            break;
          case 19:
            info += describeBuiltInComponentFrame("SuspenseList");
            break;
          case 31:
            info += describeBuiltInComponentFrame("Activity");
            break;
          case 30:
            info += describeBuiltInComponentFrame("ViewTransition");
            break;
          case 0:
          case 15:
          case 1:
            workInProgress._debugOwner ||
              "" !== info ||
              (info += describeFunctionComponentFrameWithoutLineNumber(
                workInProgress.type
              ));
            break;
          case 11:
            workInProgress._debugOwner ||
              "" !== info ||
              (info += describeFunctionComponentFrameWithoutLineNumber(
                workInProgress.type.render
              ));
        }
        for (; workInProgress; )
          if ("number" === typeof workInProgress.tag) {
            var fiber = workInProgress;
            workInProgress = fiber._debugOwner;
            var debugStack = fiber._debugStack;
            if (workInProgress && debugStack) {
              var formattedStack = formatOwnerStack(debugStack);
              "" !== formattedStack && (info += "\n" + formattedStack);
            }
          } else if (null != workInProgress.debugStack) {
            var ownerStack = workInProgress.debugStack;
            (workInProgress = workInProgress.owner) &&
              ownerStack &&
              (info += "\n" + formatOwnerStack(ownerStack));
          } else break;
        var JSCompiler_inline_result = info;
      } catch (x) {
        JSCompiler_inline_result =
          "\nError generating stack: " + x.message + "\n" + x.stack;
      }
      return JSCompiler_inline_result;
    }
    function runWithFiberInDEV(fiber, callback, arg0, arg1, arg2, arg3, arg4) {
      var previousFiber = current;
      setCurrentFiber(fiber);
      try {
        return null !== fiber && fiber._debugTask
          ? fiber._debugTask.run(
              callback.bind(null, arg0, arg1, arg2, arg3, arg4)
            )
          : callback(arg0, arg1, arg2, arg3, arg4);
      } finally {
        setCurrentFiber(previousFiber);
      }
      throw Error(
        "runWithFiberInDEV should never be called in production. This is a bug in React."
      );
    }
    function setCurrentFiber(fiber) {
      ReactSharedInternals.getCurrentStack =
        null === fiber ? null : getCurrentFiberStackInDev;
      isRendering = !1;
      current = fiber;
    }
    function typeName(value) {
      return (
        ("function" === typeof Symbol &&
          Symbol.toStringTag &&
          value[Symbol.toStringTag]) ||
        value.constructor.name ||
        "Object"
      );
    }
    function willCoercionThrow(value) {
      try {
        return testStringCoercion(value), !1;
      } catch (e) {
        return !0;
      }
    }
    function testStringCoercion(value) {
      return "" + value;
    }
    function checkAttributeStringCoercion(value, attributeName) {
      if (willCoercionThrow(value))
        return (
          console.error(
            "The provided `%s` attribute is an unsupported type %s. This value must be coerced to a string before using it here.",
            attributeName,
            typeName(value)
          ),
          testStringCoercion(value)
        );
    }
    function checkCSSPropertyStringCoercion(value, propName) {
      if (willCoercionThrow(value))
        return (
          console.error(
            "The provided `%s` CSS property is an unsupported type %s. This value must be coerced to a string before using it here.",
            propName,
            typeName(value)
          ),
          testStringCoercion(value)
        );
    }
    function checkFormFieldValueStringCoercion(value) {
      if (willCoercionThrow(value))
        return (
          console.error(
            "Form field values (value, checked, defaultValue, or defaultChecked props) must be strings, not %s. This value must be coerced to a string before using it here.",
            typeName(value)
          ),
          testStringCoercion(value)
        );
    }
    function injectInternals(internals) {
      if ("undefined" === typeof __REACT_DEVTOOLS_GLOBAL_HOOK__) return !1;
      var hook = __REACT_DEVTOOLS_GLOBAL_HOOK__;
      if (hook.isDisabled) return !0;
      if (!hook.supportsFiber)
        return (
          console.error(
            "The installed version of React DevTools is too old and will not work with the current version of React. Please update React DevTools. https://react.dev/link/react-devtools"
          ),
          !0
        );
      try {
        (rendererID = hook.inject(internals)), (injectedHook = hook);
      } catch (err) {
        console.error("React instrumentation encountered an error: %s.", err);
      }
      return hook.checkDCE ? !0 : !1;
    }
    function setIsStrictModeForDevtools(newIsStrictMode) {
      "function" === typeof log$1 &&
        unstable_setDisableYieldValue(newIsStrictMode);
      if (injectedHook && "function" === typeof injectedHook.setStrictMode)
        try {
          injectedHook.setStrictMode(rendererID, newIsStrictMode);
        } catch (err) {
          hasLoggedError ||
            ((hasLoggedError = !0),
            console.error(
              "React instrumentation encountered an error: %s",
              err
            ));
        }
    }
    function clz32Fallback(x) {
      x >>>= 0;
      return 0 === x ? 32 : (31 - ((log(x) / LN2) | 0)) | 0;
    }
    function getHighestPriorityLanes(lanes) {
      var pendingSyncLanes = lanes & 42;
      if (0 !== pendingSyncLanes) return pendingSyncLanes;
      switch (lanes & -lanes) {
        case 1:
          return 1;
        case 2:
          return 2;
        case 4:
          return 4;
        case 8:
          return 8;
        case 16:
          return 16;
        case 32:
          return 32;
        case 64:
          return 64;
        case 128:
          return 128;
        case 256:
        case 512:
        case 1024:
        case 2048:
        case 4096:
        case 8192:
        case 16384:
        case 32768:
        case 65536:
        case 131072:
        case 262144:
        case 524288:
        case 1048576:
        case 2097152:
          return lanes & 4194048;
        case 4194304:
        case 8388608:
        case 16777216:
        case 33554432:
          return lanes & 62914560;
        case 67108864:
          return 67108864;
        case 134217728:
          return 134217728;
        case 268435456:
          return 268435456;
        case 536870912:
          return 536870912;
        case 1073741824:
          return 0;
        default:
          return (
            console.error(
              "Should have found matching lanes. This is a bug in React."
            ),
            lanes
          );
      }
    }
    function getNextLanes(root, wipLanes, rootHasPendingCommit) {
      var pendingLanes = root.pendingLanes;
      if (0 === pendingLanes) return 0;
      var nextLanes = 0,
        suspendedLanes = root.suspendedLanes,
        pingedLanes = root.pingedLanes;
      root = root.warmLanes;
      var nonIdlePendingLanes = pendingLanes & 134217727;
      0 !== nonIdlePendingLanes
        ? ((pendingLanes = nonIdlePendingLanes & ~suspendedLanes),
          0 !== pendingLanes
            ? (nextLanes = getHighestPriorityLanes(pendingLanes))
            : ((pingedLanes &= nonIdlePendingLanes),
              0 !== pingedLanes
                ? (nextLanes = getHighestPriorityLanes(pingedLanes))
                : rootHasPendingCommit ||
                  ((rootHasPendingCommit = nonIdlePendingLanes & ~root),
                  0 !== rootHasPendingCommit &&
                    (nextLanes =
                      getHighestPriorityLanes(rootHasPendingCommit)))))
        : ((nonIdlePendingLanes = pendingLanes & ~suspendedLanes),
          0 !== nonIdlePendingLanes
            ? (nextLanes = getHighestPriorityLanes(nonIdlePendingLanes))
            : 0 !== pingedLanes
              ? (nextLanes = getHighestPriorityLanes(pingedLanes))
              : rootHasPendingCommit ||
                ((rootHasPendingCommit = pendingLanes & ~root),
                0 !== rootHasPendingCommit &&
                  (nextLanes = getHighestPriorityLanes(rootHasPendingCommit))));
      return 0 === nextLanes
        ? 0
        : 0 !== wipLanes &&
            wipLanes !== nextLanes &&
            0 === (wipLanes & suspendedLanes) &&
            ((suspendedLanes = nextLanes & -nextLanes),
            (rootHasPendingCommit = wipLanes & -wipLanes),
            suspendedLanes >= rootHasPendingCommit ||
              (32 === suspendedLanes && 0 !== (rootHasPendingCommit & 4194048)))
          ? wipLanes
          : nextLanes;
    }
    function checkIfRootIsPrerendering(root, renderLanes) {
      return (
        0 ===
        (root.pendingLanes &
          ~(root.suspendedLanes & ~root.pingedLanes) &
          renderLanes)
      );
    }
    function computeExpirationTime(lane, currentTime) {
      switch (lane) {
        case 1:
        case 2:
        case 4:
        case 8:
        case 64:
          return currentTime + 250;
        case 16:
        case 32:
        case 128:
        case 256:
        case 512:
        case 1024:
        case 2048:
        case 4096:
        case 8192:
        case 16384:
        case 32768:
        case 65536:
        case 131072:
        case 262144:
        case 524288:
        case 1048576:
        case 2097152:
          return currentTime + 5e3;
        case 4194304:
        case 8388608:
        case 16777216:
        case 33554432:
          return -1;
        case 67108864:
        case 134217728:
        case 268435456:
        case 536870912:
        case 1073741824:
          return -1;
        default:
          return (
            console.error(
              "Should have found matching lanes. This is a bug in React."
            ),
            -1
          );
      }
    }
    function claimNextTransitionLane() {
      var lane = nextTransitionLane;
      nextTransitionLane <<= 1;
      0 === (nextTransitionLane & 4194048) && (nextTransitionLane = 256);
      return lane;
    }
    function claimNextRetryLane() {
      var lane = nextRetryLane;
      nextRetryLane <<= 1;
      0 === (nextRetryLane & 62914560) && (nextRetryLane = 4194304);
      return lane;
    }
    function createLaneMap(initial) {
      for (var laneMap = [], i = 0; 31 > i; i++) laneMap.push(initial);
      return laneMap;
    }
    function markRootUpdated$1(root, updateLane) {
      root.pendingLanes |= updateLane;
      root.indicatorLanes |= updateLane & 4194048;
      268435456 !== updateLane &&
        ((root.suspendedLanes = 0),
        (root.pingedLanes = 0),
        (root.warmLanes = 0));
    }
    function markRootFinished(
      root,
      finishedLanes,
      remainingLanes,
      spawnedLane,
      updatedLanes,
      suspendedRetryLanes
    ) {
      var previouslyPendingLanes = root.pendingLanes;
      root.pendingLanes = remainingLanes;
      root.suspendedLanes = 0;
      root.pingedLanes = 0;
      root.warmLanes = 0;
      root.indicatorLanes &= remainingLanes;
      root.expiredLanes &= remainingLanes;
      root.entangledLanes &= remainingLanes;
      root.errorRecoveryDisabledLanes &= remainingLanes;
      root.shellSuspendCounter = 0;
      var entanglements = root.entanglements,
        expirationTimes = root.expirationTimes,
        hiddenUpdates = root.hiddenUpdates;
      for (
        remainingLanes = previouslyPendingLanes & ~remainingLanes;
        0 < remainingLanes;

      ) {
        var index = 31 - clz32(remainingLanes),
          lane = 1 << index;
        entanglements[index] = 0;
        expirationTimes[index] = -1;
        var hiddenUpdatesForLane = hiddenUpdates[index];
        if (null !== hiddenUpdatesForLane)
          for (
            hiddenUpdates[index] = null, index = 0;
            index < hiddenUpdatesForLane.length;
            index++
          ) {
            var update = hiddenUpdatesForLane[index];
            null !== update && (update.lane &= -536870913);
          }
        remainingLanes &= ~lane;
      }
      0 !== spawnedLane && markSpawnedDeferredLane(root, spawnedLane, 0);
      0 !== suspendedRetryLanes &&
        0 === updatedLanes &&
        0 !== root.tag &&
        (root.suspendedLanes |=
          suspendedRetryLanes & ~(previouslyPendingLanes & ~finishedLanes));
    }
    function markSpawnedDeferredLane(root, spawnedLane, entangledLanes) {
      root.pendingLanes |= spawnedLane;
      root.suspendedLanes &= ~spawnedLane;
      var spawnedLaneIndex = 31 - clz32(spawnedLane);
      root.entangledLanes |= spawnedLane;
      root.entanglements[spawnedLaneIndex] =
        root.entanglements[spawnedLaneIndex] |
        1073741824 |
        (entangledLanes & 4194090);
    }
    function markRootEntangled(root, entangledLanes) {
      var rootEntangledLanes = (root.entangledLanes |= entangledLanes);
      for (root = root.entanglements; rootEntangledLanes; ) {
        var index = 31 - clz32(rootEntangledLanes),
          lane = 1 << index;
        (lane & entangledLanes) | (root[index] & entangledLanes) &&
          (root[index] |= entangledLanes);
        rootEntangledLanes &= ~lane;
      }
    }
    function getBumpedLaneForHydration(root, renderLanes) {
      var renderLane = renderLanes & -renderLanes;
      renderLane =
        0 !== (renderLane & 42)
          ? 1
          : getBumpedLaneForHydrationByLane(renderLane);
      return 0 !== (renderLane & (root.suspendedLanes | renderLanes))
        ? 0
        : renderLane;
    }
    function getBumpedLaneForHydrationByLane(lane) {
      switch (lane) {
        case 2:
          lane = 1;
          break;
        case 8:
          lane = 4;
          break;
        case 32:
          lane = 16;
          break;
        case 256:
        case 512:
        case 1024:
        case 2048:
        case 4096:
        case 8192:
        case 16384:
        case 32768:
        case 65536:
        case 131072:
        case 262144:
        case 524288:
        case 1048576:
        case 2097152:
        case 4194304:
        case 8388608:
        case 16777216:
        case 33554432:
          lane = 128;
          break;
        case 268435456:
          lane = 134217728;
          break;
        default:
          lane = 0;
      }
      return lane;
    }
    function addFiberToLanesMap(root, fiber, lanes) {
      if (isDevToolsPresent)
        for (root = root.pendingUpdatersLaneMap; 0 < lanes; ) {
          var index = 31 - clz32(lanes),
            lane = 1 << index;
          root[index].add(fiber);
          lanes &= ~lane;
        }
    }
    function movePendingFibersToMemoized(root, lanes) {
      if (isDevToolsPresent)
        for (
          var pendingUpdatersLaneMap = root.pendingUpdatersLaneMap,
            memoizedUpdaters = root.memoizedUpdaters;
          0 < lanes;

        ) {
          var index = 31 - clz32(lanes);
          root = 1 << index;
          index = pendingUpdatersLaneMap[index];
          0 < index.size &&
            (index.forEach(function (fiber) {
              var alternate = fiber.alternate;
              (null !== alternate && memoizedUpdaters.has(alternate)) ||
                memoizedUpdaters.add(fiber);
            }),
            index.clear());
          lanes &= ~root;
        }
    }
    function lanesToEventPriority(lanes) {
      lanes &= -lanes;
      return 0 !== DiscreteEventPriority && DiscreteEventPriority < lanes
        ? 0 !== ContinuousEventPriority && ContinuousEventPriority < lanes
          ? 0 !== (lanes & 134217727)
            ? DefaultEventPriority
            : IdleEventPriority
          : ContinuousEventPriority
        : DiscreteEventPriority;
    }
    function resolveUpdatePriority() {
      var updatePriority = ReactDOMSharedInternals.p;
      if (0 !== updatePriority) return updatePriority;
      updatePriority = window.event;
      return void 0 === updatePriority
        ? DefaultEventPriority
        : getEventPriority(updatePriority.type);
    }
    function runWithPriority(priority, fn) {
      var previousPriority = ReactDOMSharedInternals.p;
      try {
        return (ReactDOMSharedInternals.p = priority), fn();
      } finally {
        ReactDOMSharedInternals.p = previousPriority;
      }
    }
    function detachDeletedInstance(node) {
      delete node[internalInstanceKey];
      delete node[internalPropsKey];
      delete node[internalEventHandlersKey];
      delete node[internalEventHandlerListenersKey];
      delete node[internalEventHandlesSetKey];
    }
    function getClosestInstanceFromNode(targetNode) {
      var targetInst = targetNode[internalInstanceKey];
      if (targetInst) return targetInst;
      for (var parentNode = targetNode.parentNode; parentNode; ) {
        if (
          (targetInst =
            parentNode[internalContainerInstanceKey] ||
            parentNode[internalInstanceKey])
        ) {
          parentNode = targetInst.alternate;
          if (
            null !== targetInst.child ||
            (null !== parentNode && null !== parentNode.child)
          )
            for (
              targetNode = getParentHydrationBoundary(targetNode);
              null !== targetNode;

            ) {
              if ((parentNode = targetNode[internalInstanceKey]))
                return parentNode;
              targetNode = getParentHydrationBoundary(targetNode);
            }
          return targetInst;
        }
        targetNode = parentNode;
        parentNode = targetNode.parentNode;
      }
      return null;
    }
    function getInstanceFromNode(node) {
      if (
        (node = node[internalInstanceKey] || node[internalContainerInstanceKey])
      ) {
        var tag = node.tag;
        if (
          5 === tag ||
          6 === tag ||
          13 === tag ||
          31 === tag ||
          26 === tag ||
          27 === tag ||
          3 === tag
        )
          return node;
      }
      return null;
    }
    function getNodeFromInstance(inst) {
      var tag = inst.tag;
      if (5 === tag || 26 === tag || 27 === tag || 6 === tag)
        return inst.stateNode;
      throw Error("getNodeFromInstance: Invalid argument.");
    }
    function getResourcesFromRoot(root) {
      var resources = root[internalRootNodeResourcesKey];
      resources ||
        (resources = root[internalRootNodeResourcesKey] =
          { hoistableStyles: new Map(), hoistableScripts: new Map() });
      return resources;
    }
    function markNodeAsHoistable(node) {
      node[internalHoistableMarker] = !0;
    }
    function registerTwoPhaseEvent(registrationName, dependencies) {
      registerDirectEvent(registrationName, dependencies);
      registerDirectEvent(registrationName + "Capture", dependencies);
    }
    function registerDirectEvent(registrationName, dependencies) {
      registrationNameDependencies[registrationName] &&
        console.error(
          "EventRegistry: More than one plugin attempted to publish the same registration name, `%s`.",
          registrationName
        );
      registrationNameDependencies[registrationName] = dependencies;
      var lowerCasedName = registrationName.toLowerCase();
      possibleRegistrationNames[lowerCasedName] = registrationName;
      "onDoubleClick" === registrationName &&
        (possibleRegistrationNames.ondblclick = registrationName);
      for (
        registrationName = 0;
        registrationName < dependencies.length;
        registrationName++
      )
        allNativeEvents.add(dependencies[registrationName]);
    }
    function checkControlledValueProps(tagName, props) {
      hasReadOnlyValue[props.type] ||
        props.onChange ||
        props.onInput ||
        props.readOnly ||
        props.disabled ||
        null == props.value ||
        ("select" === tagName
          ? console.error(
              "You provided a `value` prop to a form field without an `onChange` handler. This will render a read-only field. If the field should be mutable use `defaultValue`. Otherwise, set `onChange`."
            )
          : console.error(
              "You provided a `value` prop to a form field without an `onChange` handler. This will render a read-only field. If the field should be mutable use `defaultValue`. Otherwise, set either `onChange` or `readOnly`."
            ));
      props.onChange ||
        props.readOnly ||
        props.disabled ||
        null == props.checked ||
        console.error(
          "You provided a `checked` prop to a form field without an `onChange` handler. This will render a read-only field. If the field should be mutable use `defaultChecked`. Otherwise, set either `onChange` or `readOnly`."
        );
    }
    function isAttributeNameSafe(attributeName) {
      if (hasOwnProperty.call(validatedAttributeNameCache, attributeName))
        return !0;
      if (hasOwnProperty.call(illegalAttributeNameCache, attributeName))
        return !1;
      if (VALID_ATTRIBUTE_NAME_REGEX.test(attributeName))
        return (validatedAttributeNameCache[attributeName] = !0);
      illegalAttributeNameCache[attributeName] = !0;
      console.error("Invalid attribute name: `%s`", attributeName);
      return !1;
    }
    function pushMutationContext() {
      var prev = viewTransitionMutationContext;
      viewTransitionMutationContext = !1;
      return prev;
    }
    function popMutationContext(prev) {
      viewTransitionMutationContext && (rootMutationContext = !0);
      viewTransitionMutationContext = prev;
    }
    function getValueForAttributeOnCustomComponent(node, name, expected) {
      if (isAttributeNameSafe(name)) {
        if (!node.hasAttribute(name)) {
          switch (typeof expected) {
            case "symbol":
            case "object":
              return expected;
            case "function":
              return expected;
            case "boolean":
              if (!1 === expected) return expected;
          }
          return void 0 === expected ? void 0 : null;
        }
        node = node.getAttribute(name);
        if ("" === node && !0 === expected) return !0;
        checkAttributeStringCoercion(expected, name);
        return node === "" + expected ? expected : node;
      }
    }
    function setValueForAttribute(node, name, value) {
      if (isAttributeNameSafe(name))
        if (null === value) node.removeAttribute(name);
        else {
          switch (typeof value) {
            case "undefined":
            case "function":
            case "symbol":
              node.removeAttribute(name);
              return;
            case "boolean":
              var prefix = name.toLowerCase().slice(0, 5);
              if ("data-" !== prefix && "aria-" !== prefix) {
                node.removeAttribute(name);
                return;
              }
          }
          checkAttributeStringCoercion(value, name);
          node.setAttribute(name, "" + value);
        }
    }
    function setValueForKnownAttribute(node, name, value) {
      if (null === value) node.removeAttribute(name);
      else {
        switch (typeof value) {
          case "undefined":
          case "function":
          case "symbol":
          case "boolean":
            node.removeAttribute(name);
            return;
        }
        checkAttributeStringCoercion(value, name);
        node.setAttribute(name, "" + value);
      }
    }
    function setValueForNamespacedAttribute(node, namespace, name, value) {
      if (null === value) node.removeAttribute(name);
      else {
        switch (typeof value) {
          case "undefined":
          case "function":
          case "symbol":
          case "boolean":
            node.removeAttribute(name);
            return;
        }
        checkAttributeStringCoercion(value, name);
        node.setAttributeNS(namespace, name, "" + value);
      }
    }
    function getToStringValue(value) {
      switch (typeof value) {
        case "bigint":
        case "boolean":
        case "number":
        case "string":
        case "undefined":
          return value;
        case "object":
          return checkFormFieldValueStringCoercion(value), value;
        default:
          return "";
      }
    }
    function isCheckable(elem) {
      var type = elem.type;
      return (
        (elem = elem.nodeName) &&
        "input" === elem.toLowerCase() &&
        ("checkbox" === type || "radio" === type)
      );
    }
    function trackValueOnNode(node, valueField, currentValue) {
      var descriptor = Object.getOwnPropertyDescriptor(
        node.constructor.prototype,
        valueField
      );
      if (
        !node.hasOwnProperty(valueField) &&
        "undefined" !== typeof descriptor &&
        "function" === typeof descriptor.get &&
        "function" === typeof descriptor.set
      ) {
        var get = descriptor.get,
          set = descriptor.set;
        Object.defineProperty(node, valueField, {
          configurable: !0,
          get: function () {
            return get.call(this);
          },
          set: function (value) {
            checkFormFieldValueStringCoercion(value);
            currentValue = "" + value;
            set.call(this, value);
          }
        });
        Object.defineProperty(node, valueField, {
          enumerable: descriptor.enumerable
        });
        return {
          getValue: function () {
            return currentValue;
          },
          setValue: function (value) {
            checkFormFieldValueStringCoercion(value);
            currentValue = "" + value;
          },
          stopTracking: function () {
            node._valueTracker = null;
            delete node[valueField];
          }
        };
      }
    }
    function track(node) {
      if (!node._valueTracker) {
        var valueField = isCheckable(node) ? "checked" : "value";
        node._valueTracker = trackValueOnNode(
          node,
          valueField,
          "" + node[valueField]
        );
      }
    }
    function trackHydrated(node, initialValue, initialChecked) {
      if (node._valueTracker) return !1;
      if (isCheckable(node)) {
        var valueField = "checked";
        initialValue = "" + initialChecked;
      } else valueField = "value";
      initialChecked = "" + node[valueField];
      node._valueTracker = trackValueOnNode(node, valueField, initialValue);
      return initialChecked !== initialValue;
    }
    function updateValueIfChanged(node) {
      if (!node) return !1;
      var tracker = node._valueTracker;
      if (!tracker) return !0;
      var lastValue = tracker.getValue();
      var value = "";
      node &&
        (value = isCheckable(node)
          ? node.checked
            ? "true"
            : "false"
          : node.value);
      node = value;
      return node !== lastValue ? (tracker.setValue(node), !0) : !1;
    }
    function getActiveElement(doc) {
      doc = doc || ("undefined" !== typeof document ? document : void 0);
      if ("undefined" === typeof doc) return null;
      try {
        return doc.activeElement || doc.body;
      } catch (e) {
        return doc.body;
      }
    }
    function escapeSelectorAttributeValueInsideDoubleQuotes(value) {
      return value.replace(
        escapeSelectorAttributeValueInsideDoubleQuotesRegex,
        function (ch) {
          return "\\" + ch.charCodeAt(0).toString(16) + " ";
        }
      );
    }
    function validateInputProps(element, props) {
      void 0 === props.checked ||
        void 0 === props.defaultChecked ||
        didWarnCheckedDefaultChecked ||
        (console.error(
          "%s contains an input of type %s with both checked and defaultChecked props. Input elements must be either controlled or uncontrolled (specify either the checked prop, or the defaultChecked prop, but not both). Decide between using a controlled or uncontrolled input element and remove one of these props. More info: https://react.dev/link/controlled-components",
          getCurrentFiberOwnerNameInDevOrNull() || "A component",
          props.type
        ),
        (didWarnCheckedDefaultChecked = !0));
      void 0 === props.value ||
        void 0 === props.defaultValue ||
        didWarnValueDefaultValue$1 ||
        (console.error(
          "%s contains an input of type %s with both value and defaultValue props. Input elements must be either controlled or uncontrolled (specify either the value prop, or the defaultValue prop, but not both). Decide between using a controlled or uncontrolled input element and remove one of these props. More info: https://react.dev/link/controlled-components",
          getCurrentFiberOwnerNameInDevOrNull() || "A component",
          props.type
        ),
        (didWarnValueDefaultValue$1 = !0));
    }
    function updateInput(
      element,
      value,
      defaultValue,
      lastDefaultValue,
      checked,
      defaultChecked,
      type,
      name
    ) {
      element.name = "";
      null != type &&
      "function" !== typeof type &&
      "symbol" !== typeof type &&
      "boolean" !== typeof type
        ? (checkAttributeStringCoercion(type, "type"), (element.type = type))
        : element.removeAttribute("type");
      if (null != value)
        if ("number" === type) {
          if ((0 === value && "" === element.value) || element.value != value)
            element.value = "" + getToStringValue(value);
        } else
          element.value !== "" + getToStringValue(value) &&
            (element.value = "" + getToStringValue(value));
      else
        ("submit" !== type && "reset" !== type) ||
          element.removeAttribute("value");
      null != value
        ? setDefaultValue(element, type, getToStringValue(value))
        : null != defaultValue
          ? setDefaultValue(element, type, getToStringValue(defaultValue))
          : null != lastDefaultValue && element.removeAttribute("value");
      null == checked &&
        null != defaultChecked &&
        (element.defaultChecked = !!defaultChecked);
      null != checked &&
        (element.checked =
          checked &&
          "function" !== typeof checked &&
          "symbol" !== typeof checked);
      null != name &&
      "function" !== typeof name &&
      "symbol" !== typeof name &&
      "boolean" !== typeof name
        ? (checkAttributeStringCoercion(name, "name"),
          (element.name = "" + getToStringValue(name)))
        : element.removeAttribute("name");
    }
    function setDefaultValue(node, type, value) {
      ("number" === type && getActiveElement(node.ownerDocument) === node) ||
        node.defaultValue === "" + value ||
        (node.defaultValue = "" + value);
    }
    function validateOptionProps(element, props) {
      null == props.value &&
        ("object" === typeof props.children && null !== props.children
          ? React.Children.forEach(props.children, function (child) {
              null == child ||
                "string" === typeof child ||
                "number" === typeof child ||
                "bigint" === typeof child ||
                didWarnInvalidChild ||
                ((didWarnInvalidChild = !0),
                console.error(
                  "Cannot infer the option value of complex children. Pass a `value` prop or use a plain string as children to <option>."
                ));
            })
          : null == props.dangerouslySetInnerHTML ||
            didWarnInvalidInnerHTML ||
            ((didWarnInvalidInnerHTML = !0),
            console.error(
              "Pass a `value` prop if you set dangerouslyInnerHTML so React knows which value should be selected."
            )));
      null == props.selected ||
        didWarnSelectedSetOnOption ||
        (console.error(
          "Use the `defaultValue` or `value` props on <select> instead of setting `selected` on <option>."
        ),
        (didWarnSelectedSetOnOption = !0));
    }
    function getDeclarationErrorAddendum() {
      var ownerName = getCurrentFiberOwnerNameInDevOrNull();
      return ownerName
        ? "\n\nCheck the render method of `" + ownerName + "`."
        : "";
    }
    function updateOptions(node, multiple, propValue, setDefaultSelected) {
      node = node.options;
      if (multiple) {
        multiple = {};
        for (var i = 0; i < propValue.length; i++)
          multiple["$" + propValue[i]] = !0;
        for (propValue = 0; propValue < node.length; propValue++)
          (i = multiple.hasOwnProperty("$" + node[propValue].value)),
            node[propValue].selected !== i && (node[propValue].selected = i),
            i && setDefaultSelected && (node[propValue].defaultSelected = !0);
      } else {
        propValue = "" + getToStringValue(propValue);
        multiple = null;
        for (i = 0; i < node.length; i++) {
          if (node[i].value === propValue) {
            node[i].selected = !0;
            setDefaultSelected && (node[i].defaultSelected = !0);
            return;
          }
          null !== multiple || node[i].disabled || (multiple = node[i]);
        }
        null !== multiple && (multiple.selected = !0);
      }
    }
    function validateSelectProps(element, props) {
      for (element = 0; element < valuePropNames.length; element++) {
        var propName = valuePropNames[element];
        if (null != props[propName]) {
          var propNameIsArray = isArrayImpl(props[propName]);
          props.multiple && !propNameIsArray
            ? console.error(
                "The `%s` prop supplied to <select> must be an array if `multiple` is true.%s",
                propName,
                getDeclarationErrorAddendum()
              )
            : !props.multiple &&
              propNameIsArray &&
              console.error(
                "The `%s` prop supplied to <select> must be a scalar value if `multiple` is false.%s",
                propName,
                getDeclarationErrorAddendum()
              );
        }
      }
      void 0 === props.value ||
        void 0 === props.defaultValue ||
        didWarnValueDefaultValue ||
        (console.error(
          "Select elements must be either controlled or uncontrolled (specify either the value prop, or the defaultValue prop, but not both). Decide between using a controlled or uncontrolled select element and remove one of these props. More info: https://react.dev/link/controlled-components"
        ),
        (didWarnValueDefaultValue = !0));
    }
    function validateTextareaProps(element, props) {
      void 0 === props.value ||
        void 0 === props.defaultValue ||
        didWarnValDefaultVal ||
        (console.error(
          "%s contains a textarea with both value and defaultValue props. Textarea elements must be either controlled or uncontrolled (specify either the value prop, or the defaultValue prop, but not both). Decide between using a controlled or uncontrolled textarea and remove one of these props. More info: https://react.dev/link/controlled-components",
          getCurrentFiberOwnerNameInDevOrNull() || "A component"
        ),
        (didWarnValDefaultVal = !0));
      null != props.children &&
        null == props.value &&
        console.error(
          "Use the `defaultValue` or `value` props instead of setting children on <textarea>."
        );
    }
    function updateTextarea(element, value, defaultValue) {
      if (
        null != value &&
        ((value = "" + getToStringValue(value)),
        value !== element.value && (element.value = value),
        null == defaultValue)
      ) {
        element.defaultValue !== value && (element.defaultValue = value);
        return;
      }
      element.defaultValue =
        null != defaultValue ? "" + getToStringValue(defaultValue) : "";
    }
    function findNotableNode(node, indent) {
      return void 0 === node.serverProps &&
        0 === node.serverTail.length &&
        1 === node.children.length &&
        3 < node.distanceFromLeaf &&
        node.distanceFromLeaf > 15 - indent
        ? findNotableNode(node.children[0], indent)
        : node;
    }
    function indentation(indent) {
      return "  " + "  ".repeat(indent);
    }
    function added(indent) {
      return "+ " + "  ".repeat(indent);
    }
    function removed(indent) {
      return "- " + "  ".repeat(indent);
    }
    function describeFiberType(fiber) {
      switch (fiber.tag) {
        case 26:
        case 27:
        case 5:
          return fiber.type;
        case 16:
          return "Lazy";
        case 31:
          return "Activity";
        case 13:
          return "Suspense";
        case 19:
          return "SuspenseList";
        case 0:
        case 15:
          return (fiber = fiber.type), fiber.displayName || fiber.name || null;
        case 11:
          return (
            (fiber = fiber.type.render), fiber.displayName || fiber.name || null
          );
        case 1:
          return (fiber = fiber.type), fiber.displayName || fiber.name || null;
        default:
          return null;
      }
    }
    function describeTextNode(content, maxLength) {
      return needsEscaping.test(content)
        ? ((content = JSON.stringify(content)),
          content.length > maxLength - 2
            ? 8 > maxLength
              ? '{"..."}'
              : "{" + content.slice(0, maxLength - 7) + '..."}'
            : "{" + content + "}")
        : content.length > maxLength
          ? 5 > maxLength
            ? '{"..."}'
            : content.slice(0, maxLength - 3) + "..."
          : content;
    }
    function describeTextDiff(clientText, serverProps, indent) {
      var maxLength = 120 - 2 * indent;
      if (null === serverProps)
        return added(indent) + describeTextNode(clientText, maxLength) + "\n";
      if ("string" === typeof serverProps) {
        for (
          var firstDiff = 0;
          firstDiff < serverProps.length &&
          firstDiff < clientText.length &&
          serverProps.charCodeAt(firstDiff) ===
            clientText.charCodeAt(firstDiff);
          firstDiff++
        );
        firstDiff > maxLength - 8 &&
          10 < firstDiff &&
          ((clientText = "..." + clientText.slice(firstDiff - 8)),
          (serverProps = "..." + serverProps.slice(firstDiff - 8)));
        return (
          added(indent) +
          describeTextNode(clientText, maxLength) +
          "\n" +
          removed(indent) +
          describeTextNode(serverProps, maxLength) +
          "\n"
        );
      }
      return (
        indentation(indent) + describeTextNode(clientText, maxLength) + "\n"
      );
    }
    function objectName(object) {
      return Object.prototype.toString
        .call(object)
        .replace(/^\[object (.*)\]$/, function (m, p0) {
          return p0;
        });
    }
    function describeValue(value, maxLength) {
      switch (typeof value) {
        case "string":
          return (
            (value = JSON.stringify(value)),
            value.length > maxLength
              ? 5 > maxLength
                ? '"..."'
                : value.slice(0, maxLength - 4) + '..."'
              : value
          );
        case "object":
          if (null === value) return "null";
          if (isArrayImpl(value)) return "[...]";
          if (value.$$typeof === REACT_ELEMENT_TYPE)
            return (maxLength = getComponentNameFromType(value.type))
              ? "<" + maxLength + ">"
              : "<...>";
          var name = objectName(value);
          if ("Object" === name) {
            name = "";
            maxLength -= 2;
            for (var propName in value)
              if (value.hasOwnProperty(propName)) {
                var jsonPropName = JSON.stringify(propName);
                jsonPropName !== '"' + propName + '"' &&
                  (propName = jsonPropName);
                maxLength -= propName.length - 2;
                jsonPropName = describeValue(
                  value[propName],
                  15 > maxLength ? maxLength : 15
                );
                maxLength -= jsonPropName.length;
                if (0 > maxLength) {
                  name += "" === name ? "..." : ", ...";
                  break;
                }
                name +=
                  ("" === name ? "" : ",") + propName + ":" + jsonPropName;
              }
            return "{" + name + "}";
          }
          return "Blob" === name || "File" === name
            ? name + ":" + value.type
            : name;
        case "function":
          return (maxLength = value.displayName || value.name)
            ? "function " + maxLength
            : "function";
        default:
          return String(value);
      }
    }
    function describePropValue(value, maxLength) {
      return "string" !== typeof value || needsEscaping.test(value)
        ? "{" + describeValue(value, maxLength - 2) + "}"
        : value.length > maxLength - 2
          ? 5 > maxLength
            ? '"..."'
            : '"' + value.slice(0, maxLength - 5) + '..."'
          : '"' + value + '"';
    }
    function describeExpandedElement(type, props, rowPrefix) {
      var remainingRowLength = 120 - rowPrefix.length - type.length,
        properties = [],
        propName;
      for (propName in props)
        if (props.hasOwnProperty(propName) && "children" !== propName) {
          var propValue = describePropValue(
            props[propName],
            120 - rowPrefix.length - propName.length - 1
          );
          remainingRowLength -= propName.length + propValue.length + 2;
          properties.push(propName + "=" + propValue);
        }
      return 0 === properties.length
        ? rowPrefix + "<" + type + ">\n"
        : 0 < remainingRowLength
          ? rowPrefix + "<" + type + " " + properties.join(" ") + ">\n"
          : rowPrefix +
            "<" +
            type +
            "\n" +
            rowPrefix +
            "  " +
            properties.join("\n" + rowPrefix + "  ") +
            "\n" +
            rowPrefix +
            ">\n";
    }
    function describePropertiesDiff(clientObject, serverObject, indent) {
      var properties = "",
        remainingServerProperties = assign({}, serverObject),
        propName;
      for (propName in clientObject)
        if (clientObject.hasOwnProperty(propName)) {
          delete remainingServerProperties[propName];
          var maxLength = 120 - 2 * indent - propName.length - 2,
            clientPropValue = describeValue(clientObject[propName], maxLength);
          serverObject.hasOwnProperty(propName)
            ? ((maxLength = describeValue(serverObject[propName], maxLength)),
              (properties +=
                added(indent) + propName + ": " + clientPropValue + "\n"),
              (properties +=
                removed(indent) + propName + ": " + maxLength + "\n"))
            : (properties +=
                added(indent) + propName + ": " + clientPropValue + "\n");
        }
      for (var _propName in remainingServerProperties)
        remainingServerProperties.hasOwnProperty(_propName) &&
          ((clientObject = describeValue(
            remainingServerProperties[_propName],
            120 - 2 * indent - _propName.length - 2
          )),
          (properties +=
            removed(indent) + _propName + ": " + clientObject + "\n"));
      return properties;
    }
    function describeElementDiff(type, clientProps, serverProps, indent) {
      var content = "",
        serverPropNames = new Map();
      for (propName$jscomp$0 in serverProps)
        serverProps.hasOwnProperty(propName$jscomp$0) &&
          serverPropNames.set(
            propName$jscomp$0.toLowerCase(),
            propName$jscomp$0
          );
      if (1 === serverPropNames.size && serverPropNames.has("children"))
        content += describeExpandedElement(
          type,
          clientProps,
          indentation(indent)
        );
      else {
        for (var _propName2 in clientProps)
          if (
            clientProps.hasOwnProperty(_propName2) &&
            "children" !== _propName2
          ) {
            var maxLength$jscomp$0 =
                120 - 2 * (indent + 1) - _propName2.length - 1,
              serverPropName = serverPropNames.get(_propName2.toLowerCase());
            if (void 0 !== serverPropName) {
              serverPropNames.delete(_propName2.toLowerCase());
              var propName$jscomp$0 = clientProps[_propName2];
              serverPropName = serverProps[serverPropName];
              var clientPropValue = describePropValue(
                propName$jscomp$0,
                maxLength$jscomp$0
              );
              maxLength$jscomp$0 = describePropValue(
                serverPropName,
                maxLength$jscomp$0
              );
              "object" === typeof propName$jscomp$0 &&
              null !== propName$jscomp$0 &&
              "object" === typeof serverPropName &&
              null !== serverPropName &&
              "Object" === objectName(propName$jscomp$0) &&
              "Object" === objectName(serverPropName) &&
              (2 < Object.keys(propName$jscomp$0).length ||
                2 < Object.keys(serverPropName).length ||
                -1 < clientPropValue.indexOf("...") ||
                -1 < maxLength$jscomp$0.indexOf("..."))
                ? (content +=
                    indentation(indent + 1) +
                    _propName2 +
                    "={{\n" +
                    describePropertiesDiff(
                      propName$jscomp$0,
                      serverPropName,
                      indent + 2
                    ) +
                    indentation(indent + 1) +
                    "}}\n")
                : ((content +=
                    added(indent + 1) +
                    _propName2 +
                    "=" +
                    clientPropValue +
                    "\n"),
                  (content +=
                    removed(indent + 1) +
                    _propName2 +
                    "=" +
                    maxLength$jscomp$0 +
                    "\n"));
            } else
              content +=
                indentation(indent + 1) +
                _propName2 +
                "=" +
                describePropValue(clientProps[_propName2], maxLength$jscomp$0) +
                "\n";
          }
        serverPropNames.forEach(function (propName) {
          if ("children" !== propName) {
            var maxLength = 120 - 2 * (indent + 1) - propName.length - 1;
            content +=
              removed(indent + 1) +
              propName +
              "=" +
              describePropValue(serverProps[propName], maxLength) +
              "\n";
          }
        });
        content =
          "" === content
            ? indentation(indent) + "<" + type + ">\n"
            : indentation(indent) +
              "<" +
              type +
              "\n" +
              content +
              indentation(indent) +
              ">\n";
      }
      type = serverProps.children;
      clientProps = clientProps.children;
      if (
        "string" === typeof type ||
        "number" === typeof type ||
        "bigint" === typeof type
      ) {
        serverPropNames = "";
        if (
          "string" === typeof clientProps ||
          "number" === typeof clientProps ||
          "bigint" === typeof clientProps
        )
          serverPropNames = "" + clientProps;
        content += describeTextDiff(serverPropNames, "" + type, indent + 1);
      } else if (
        "string" === typeof clientProps ||
        "number" === typeof clientProps ||
        "bigint" === typeof clientProps
      )
        content =
          null == type
            ? content + describeTextDiff("" + clientProps, null, indent + 1)
            : content + describeTextDiff("" + clientProps, void 0, indent + 1);
      return content;
    }
    function describeSiblingFiber(fiber, indent) {
      var type = describeFiberType(fiber);
      if (null === type) {
        type = "";
        for (fiber = fiber.child; fiber; )
          (type += describeSiblingFiber(fiber, indent)),
            (fiber = fiber.sibling);
        return type;
      }
      return indentation(indent) + "<" + type + ">\n";
    }
    function describeNode(node, indent) {
      var skipToNode = findNotableNode(node, indent);
      if (
        skipToNode !== node &&
        (1 !== node.children.length || node.children[0] !== skipToNode)
      )
        return (
          indentation(indent) + "...\n" + describeNode(skipToNode, indent + 1)
        );
      skipToNode = "";
      var debugInfo = node.fiber._debugInfo;
      if (debugInfo)
        for (var i = 0; i < debugInfo.length; i++) {
          var serverComponentName = debugInfo[i].name;
          "string" === typeof serverComponentName &&
            ((skipToNode +=
              indentation(indent) + "<" + serverComponentName + ">\n"),
            indent++);
        }
      debugInfo = "";
      i = node.fiber.pendingProps;
      if (6 === node.fiber.tag)
        (debugInfo = describeTextDiff(i, node.serverProps, indent)), indent++;
      else if (
        ((serverComponentName = describeFiberType(node.fiber)),
        null !== serverComponentName)
      )
        if (void 0 === node.serverProps) {
          debugInfo = indent;
          var maxLength = 120 - 2 * debugInfo - serverComponentName.length - 2,
            content = "";
          for (propName in i)
            if (i.hasOwnProperty(propName) && "children" !== propName) {
              var propValue = describePropValue(i[propName], 15);
              maxLength -= propName.length + propValue.length + 2;
              if (0 > maxLength) {
                content += " ...";
                break;
              }
              content += " " + propName + "=" + propValue;
            }
          debugInfo =
            indentation(debugInfo) +
            "<" +
            serverComponentName +
            content +
            ">\n";
          indent++;
        } else
          null === node.serverProps
            ? ((debugInfo = describeExpandedElement(
                serverComponentName,
                i,
                added(indent)
              )),
              indent++)
            : "string" === typeof node.serverProps
              ? console.error(
                  "Should not have matched a non HostText fiber to a Text node. This is a bug in React."
                )
              : ((debugInfo = describeElementDiff(
                  serverComponentName,
                  i,
                  node.serverProps,
                  indent
                )),
                indent++);
      var propName = "";
      i = node.fiber.child;
      for (
        serverComponentName = 0;
        i && serverComponentName < node.children.length;

      )
        (maxLength = node.children[serverComponentName]),
          maxLength.fiber === i
            ? ((propName += describeNode(maxLength, indent)),
              serverComponentName++)
            : (propName += describeSiblingFiber(i, indent)),
          (i = i.sibling);
      i &&
        0 < node.children.length &&
        (propName += indentation(indent) + "...\n");
      i = node.serverTail;
      null === node.serverProps && indent--;
      for (node = 0; node < i.length; node++)
        (serverComponentName = i[node]),
          (propName =
            "string" === typeof serverComponentName
              ? propName +
                (removed(indent) +
                  describeTextNode(serverComponentName, 120 - 2 * indent) +
                  "\n")
              : propName +
                describeExpandedElement(
                  serverComponentName.type,
                  serverComponentName.props,
                  removed(indent)
                ));
      return skipToNode + debugInfo + propName;
    }
    function describeDiff(rootNode) {
      try {
        return "\n\n" + describeNode(rootNode, 0);
      } catch (x) {
        return "";
      }
    }
    function describeAncestors(ancestor, child, props) {
      for (var fiber = child, node = null, distanceFromLeaf = 0; fiber; )
        fiber === ancestor && (distanceFromLeaf = 0),
          (node = {
            fiber: fiber,
            children: null !== node ? [node] : [],
            serverProps:
              fiber === child ? props : fiber === ancestor ? null : void 0,
            serverTail: [],
            distanceFromLeaf: distanceFromLeaf
          }),
          distanceFromLeaf++,
          (fiber = fiber.return);
      return null !== node ? describeDiff(node).replaceAll(/^[+-]/gm, ">") : "";
    }
    function updatedAncestorInfoDev(oldInfo, tag) {
      var ancestorInfo = assign({}, oldInfo || emptyAncestorInfoDev),
        info = { tag: tag };
      -1 !== inScopeTags.indexOf(tag) &&
        ((ancestorInfo.aTagInScope = null),
        (ancestorInfo.buttonTagInScope = null),
        (ancestorInfo.nobrTagInScope = null));
      -1 !== buttonScopeTags.indexOf(tag) &&
        (ancestorInfo.pTagInButtonScope = null);
      -1 !== specialTags.indexOf(tag) &&
        "address" !== tag &&
        "div" !== tag &&
        "p" !== tag &&
        ((ancestorInfo.listItemTagAutoclosing = null),
        (ancestorInfo.dlItemTagAutoclosing = null));
      ancestorInfo.current = info;
      "form" === tag && (ancestorInfo.formTag = info);
      "a" === tag && (ancestorInfo.aTagInScope = info);
      "button" === tag && (ancestorInfo.buttonTagInScope = info);
      "nobr" === tag && (ancestorInfo.nobrTagInScope = info);
      "p" === tag && (ancestorInfo.pTagInButtonScope = info);
      "li" === tag && (ancestorInfo.listItemTagAutoclosing = info);
      if ("dd" === tag || "dt" === tag)
        ancestorInfo.dlItemTagAutoclosing = info;
      "#document" === tag || "html" === tag
        ? (ancestorInfo.containerTagInScope = null)
        : ancestorInfo.containerTagInScope ||
          (ancestorInfo.containerTagInScope = info);
      null !== oldInfo ||
      ("#document" !== tag && "html" !== tag && "body" !== tag)
        ? !0 === ancestorInfo.implicitRootScope &&
          (ancestorInfo.implicitRootScope = !1)
        : (ancestorInfo.implicitRootScope = !0);
      return ancestorInfo;
    }
    function isTagValidWithParent(tag, parentTag, implicitRootScope) {
      switch (parentTag) {
        case "select":
          return (
            "hr" === tag ||
            "option" === tag ||
            "optgroup" === tag ||
            "script" === tag ||
            "template" === tag ||
            "#text" === tag
          );
        case "optgroup":
          return "option" === tag || "#text" === tag;
        case "option":
          return "#text" === tag;
        case "tr":
          return (
            "th" === tag ||
            "td" === tag ||
            "style" === tag ||
            "script" === tag ||
            "template" === tag
          );
        case "tbody":
        case "thead":
        case "tfoot":
          return (
            "tr" === tag ||
            "style" === tag ||
            "script" === tag ||
            "template" === tag
          );
        case "colgroup":
          return "col" === tag || "template" === tag;
        case "table":
          return (
            "caption" === tag ||
            "colgroup" === tag ||
            "tbody" === tag ||
            "tfoot" === tag ||
            "thead" === tag ||
            "style" === tag ||
            "script" === tag ||
            "template" === tag
          );
        case "head":
          return (
            "base" === tag ||
            "basefont" === tag ||
            "bgsound" === tag ||
            "link" === tag ||
            "meta" === tag ||
            "title" === tag ||
            "noscript" === tag ||
            "noframes" === tag ||
            "style" === tag ||
            "script" === tag ||
            "template" === tag
          );
        case "html":
          if (implicitRootScope) break;
          return "head" === tag || "body" === tag || "frameset" === tag;
        case "frameset":
          return "frame" === tag;
        case "#document":
          if (!implicitRootScope) return "html" === tag;
      }
      switch (tag) {
        case "h1":
        case "h2":
        case "h3":
        case "h4":
        case "h5":
        case "h6":
          return (
            "h1" !== parentTag &&
            "h2" !== parentTag &&
            "h3" !== parentTag &&
            "h4" !== parentTag &&
            "h5" !== parentTag &&
            "h6" !== parentTag
          );
        case "rp":
        case "rt":
          return -1 === impliedEndTags.indexOf(parentTag);
        case "caption":
        case "col":
        case "colgroup":
        case "frameset":
        case "frame":
        case "tbody":
        case "td":
        case "tfoot":
        case "th":
        case "thead":
        case "tr":
          return null == parentTag;
        case "head":
          return implicitRootScope || null === parentTag;
        case "html":
          return (
            (implicitRootScope && "#document" === parentTag) ||
            null === parentTag
          );
        case "body":
          return (
            (implicitRootScope &&
              ("#document" === parentTag || "html" === parentTag)) ||
            null === parentTag
          );
      }
      return !0;
    }
    function findInvalidAncestorForTag(tag, ancestorInfo) {
      switch (tag) {
        case "address":
        case "article":
        case "aside":
        case "blockquote":
        case "center":
        case "details":
        case "dialog":
        case "dir":
        case "div":
        case "dl":
        case "fieldset":
        case "figcaption":
        case "figure":
        case "footer":
        case "header":
        case "hgroup":
        case "main":
        case "menu":
        case "nav":
        case "ol":
        case "p":
        case "section":
        case "summary":
        case "ul":
        case "pre":
        case "listing":
        case "table":
        case "hr":
        case "xmp":
        case "h1":
        case "h2":
        case "h3":
        case "h4":
        case "h5":
        case "h6":
          return ancestorInfo.pTagInButtonScope;
        case "form":
          return ancestorInfo.formTag || ancestorInfo.pTagInButtonScope;
        case "li":
          return ancestorInfo.listItemTagAutoclosing;
        case "dd":
        case "dt":
          return ancestorInfo.dlItemTagAutoclosing;
        case "button":
          return ancestorInfo.buttonTagInScope;
        case "a":
          return ancestorInfo.aTagInScope;
        case "nobr":
          return ancestorInfo.nobrTagInScope;
      }
      return null;
    }
    function findAncestor(parent, tagName) {
      for (; parent; ) {
        switch (parent.tag) {
          case 5:
          case 26:
          case 27:
            if (parent.type === tagName) return parent;
        }
        parent = parent.return;
      }
      return null;
    }
    function validateDOMNesting(childTag, ancestorInfo) {
      ancestorInfo = ancestorInfo || emptyAncestorInfoDev;
      var parentInfo = ancestorInfo.current;
      ancestorInfo = (parentInfo = isTagValidWithParent(
        childTag,
        parentInfo && parentInfo.tag,
        ancestorInfo.implicitRootScope
      )
        ? null
        : parentInfo)
        ? null
        : findInvalidAncestorForTag(childTag, ancestorInfo);
      ancestorInfo = parentInfo || ancestorInfo;
      if (!ancestorInfo) return !0;
      var ancestorTag = ancestorInfo.tag;
      ancestorInfo = String(!!parentInfo) + "|" + childTag + "|" + ancestorTag;
      if (didWarn[ancestorInfo]) return !1;
      didWarn[ancestorInfo] = !0;
      var ancestor = (ancestorInfo = current)
          ? findAncestor(ancestorInfo.return, ancestorTag)
          : null,
        ancestorDescription =
          null !== ancestorInfo && null !== ancestor
            ? describeAncestors(ancestor, ancestorInfo, null)
            : "",
        tagDisplayName = "<" + childTag + ">";
      parentInfo
        ? ((parentInfo = ""),
          "table" === ancestorTag &&
            "tr" === childTag &&
            (parentInfo +=
              " Add a <tbody>, <thead> or <tfoot> to your code to match the DOM tree generated by the browser."),
          console.error(
            "In HTML, %s cannot be a child of <%s>.%s\nThis will cause a hydration error.%s",
            tagDisplayName,
            ancestorTag,
            parentInfo,
            ancestorDescription
          ))
        : console.error(
            "In HTML, %s cannot be a descendant of <%s>.\nThis will cause a hydration error.%s",
            tagDisplayName,
            ancestorTag,
            ancestorDescription
          );
      ancestorInfo &&
        ((childTag = ancestorInfo.return),
        null === ancestor ||
          null === childTag ||
          (ancestor === childTag &&
            childTag._debugOwner === ancestorInfo._debugOwner) ||
          runWithFiberInDEV(ancestor, function () {
            console.error(
              "<%s> cannot contain a nested %s.\nSee this log for the ancestor stack trace.",
              ancestorTag,
              tagDisplayName
            );
          }));
      return !1;
    }
    function validateTextNesting(childText, parentTag, implicitRootScope) {
      if (implicitRootScope || isTagValidWithParent("#text", parentTag, !1))
        return !0;
      implicitRootScope = "#text|" + parentTag;
      if (didWarn[implicitRootScope]) return !1;
      didWarn[implicitRootScope] = !0;
      var ancestor = (implicitRootScope = current)
        ? findAncestor(implicitRootScope, parentTag)
        : null;
      implicitRootScope =
        null !== implicitRootScope && null !== ancestor
          ? describeAncestors(
              ancestor,
              implicitRootScope,
              6 !== implicitRootScope.tag ? { children: null } : null
            )
          : "";
      /\S/.test(childText)
        ? console.error(
            "In HTML, text nodes cannot be a child of <%s>.\nThis will cause a hydration error.%s",
            parentTag,
            implicitRootScope
          )
        : console.error(
            "In HTML, whitespace text nodes cannot be a child of <%s>. Make sure you don't have any extra whitespace between tags on each line of your source code.\nThis will cause a hydration error.%s",
            parentTag,
            implicitRootScope
          );
      return !1;
    }
    function setTextContent(node, text) {
      if (text) {
        var firstChild = node.firstChild;
        if (
          firstChild &&
          firstChild === node.lastChild &&
          3 === firstChild.nodeType
        ) {
          firstChild.nodeValue = text;
          return;
        }
      }
      node.textContent = text;
    }
    function camelize(string) {
      return string.replace(hyphenPattern, function (_, character) {
        return character.toUpperCase();
      });
    }
    function setValueForStyle(style, styleName, value) {
      var isCustomProperty = 0 === styleName.indexOf("--");
      isCustomProperty ||
        (-1 < styleName.indexOf("-")
          ? (warnedStyleNames.hasOwnProperty(styleName) &&
              warnedStyleNames[styleName]) ||
            ((warnedStyleNames[styleName] = !0),
            console.error(
              "Unsupported style property %s. Did you mean %s?",
              styleName,
              camelize(styleName.replace(msPattern, "ms-"))
            ))
          : badVendoredStyleNamePattern.test(styleName)
            ? (warnedStyleNames.hasOwnProperty(styleName) &&
                warnedStyleNames[styleName]) ||
              ((warnedStyleNames[styleName] = !0),
              console.error(
                "Unsupported vendor-prefixed style property %s. Did you mean %s?",
                styleName,
                styleName.charAt(0).toUpperCase() + styleName.slice(1)
              ))
            : !badStyleValueWithSemicolonPattern.test(value) ||
              (warnedStyleValues.hasOwnProperty(value) &&
                warnedStyleValues[value]) ||
              ((warnedStyleValues[value] = !0),
              console.error(
                'Style property values shouldn\'t contain a semicolon. Try "%s: %s" instead.',
                styleName,
                value.replace(badStyleValueWithSemicolonPattern, "")
              )),
        "number" === typeof value &&
          (isNaN(value)
            ? warnedForNaNValue ||
              ((warnedForNaNValue = !0),
              console.error(
                "`NaN` is an invalid value for the `%s` css style property.",
                styleName
              ))
            : isFinite(value) ||
              warnedForInfinityValue ||
              ((warnedForInfinityValue = !0),
              console.error(
                "`Infinity` is an invalid value for the `%s` css style property.",
                styleName
              ))));
      null == value || "boolean" === typeof value || "" === value
        ? isCustomProperty
          ? style.setProperty(styleName, "")
          : "float" === styleName
            ? (style.cssFloat = "")
            : (style[styleName] = "")
        : isCustomProperty
          ? style.setProperty(styleName, value)
          : "number" !== typeof value ||
              0 === value ||
              unitlessNumbers.has(styleName)
            ? "float" === styleName
              ? (style.cssFloat = value)
              : (checkCSSPropertyStringCoercion(value, styleName),
                (style[styleName] = ("" + value).trim()))
            : (style[styleName] = value + "px");
    }
    function setValueForStyles(node, styles, prevStyles) {
      if (null != styles && "object" !== typeof styles)
        throw Error(
          "The `style` prop expects a mapping from style properties to values, not a string. For example, style={{marginRight: spacing + 'em'}} when using JSX."
        );
      styles && Object.freeze(styles);
      node = node.style;
      if (null != prevStyles) {
        if (styles) {
          var expandedUpdates = {};
          if (prevStyles)
            for (var key in prevStyles)
              if (prevStyles.hasOwnProperty(key) && !styles.hasOwnProperty(key))
                for (
                  var longhands = shorthandToLonghand[key] || [key], i = 0;
                  i < longhands.length;
                  i++
                )
                  expandedUpdates[longhands[i]] = key;
          for (var _key in styles)
            if (
              styles.hasOwnProperty(_key) &&
              (!prevStyles || prevStyles[_key] !== styles[_key])
            )
              for (
                key = shorthandToLonghand[_key] || [_key], longhands = 0;
                longhands < key.length;
                longhands++
              )
                expandedUpdates[key[longhands]] = _key;
          _key = {};
          for (var key$jscomp$0 in styles)
            for (
              key = shorthandToLonghand[key$jscomp$0] || [key$jscomp$0],
                longhands = 0;
              longhands < key.length;
              longhands++
            )
              _key[key[longhands]] = key$jscomp$0;
          key$jscomp$0 = {};
          for (var _key2 in expandedUpdates)
            if (
              ((key = expandedUpdates[_key2]),
              (longhands = _key[_key2]) &&
                key !== longhands &&
                ((i = key + "," + longhands), !key$jscomp$0[i]))
            ) {
              key$jscomp$0[i] = !0;
              i = console;
              var value = styles[key];
              i.error.call(
                i,
                "%s a style property during rerender (%s) when a conflicting property is set (%s) can lead to styling bugs. To avoid this, don't mix shorthand and non-shorthand properties for the same value; instead, replace the shorthand with separate values.",
                null == value || "boolean" === typeof value || "" === value
                  ? "Removing"
                  : "Updating",
                key,
                longhands
              );
            }
        }
        for (var styleName in prevStyles)
          !prevStyles.hasOwnProperty(styleName) ||
            (null != styles && styles.hasOwnProperty(styleName)) ||
            (0 === styleName.indexOf("--")
              ? node.setProperty(styleName, "")
              : "float" === styleName
                ? (node.cssFloat = "")
                : (node[styleName] = ""),
            (viewTransitionMutationContext = !0));
        for (var _styleName in styles)
          (_key2 = styles[_styleName]),
            styles.hasOwnProperty(_styleName) &&
              prevStyles[_styleName] !== _key2 &&
              (setValueForStyle(node, _styleName, _key2),
              (viewTransitionMutationContext = !0));
      } else
        for (expandedUpdates in styles)
          styles.hasOwnProperty(expandedUpdates) &&
            setValueForStyle(node, expandedUpdates, styles[expandedUpdates]);
    }
    function isCustomElement(tagName) {
      if (-1 === tagName.indexOf("-")) return !1;
      switch (tagName) {
        case "annotation-xml":
        case "color-profile":
        case "font-face":
        case "font-face-src":
        case "font-face-uri":
        case "font-face-format":
        case "font-face-name":
        case "missing-glyph":
          return !1;
        default:
          return !0;
      }
    }
    function getAttributeAlias(name) {
      return aliases.get(name) || name;
    }
    function validateProperty$1(tagName, name) {
      if (
        hasOwnProperty.call(warnedProperties$1, name) &&
        warnedProperties$1[name]
      )
        return !0;
      if (rARIACamel$1.test(name)) {
        tagName = "aria-" + name.slice(4).toLowerCase();
        tagName = ariaProperties.hasOwnProperty(tagName) ? tagName : null;
        if (null == tagName)
          return (
            console.error(
              "Invalid ARIA attribute `%s`. ARIA attributes follow the pattern aria-* and must be lowercase.",
              name
            ),
            (warnedProperties$1[name] = !0)
          );
        if (name !== tagName)
          return (
            console.error(
              "Invalid ARIA attribute `%s`. Did you mean `%s`?",
              name,
              tagName
            ),
            (warnedProperties$1[name] = !0)
          );
      }
      if (rARIA$1.test(name)) {
        tagName = name.toLowerCase();
        tagName = ariaProperties.hasOwnProperty(tagName) ? tagName : null;
        if (null == tagName) return (warnedProperties$1[name] = !0), !1;
        name !== tagName &&
          (console.error(
            "Unknown ARIA attribute `%s`. Did you mean `%s`?",
            name,
            tagName
          ),
          (warnedProperties$1[name] = !0));
      }
      return !0;
    }
    function validateProperties$2(type, props) {
      var invalidProps = [],
        key;
      for (key in props)
        validateProperty$1(type, key) || invalidProps.push(key);
      props = invalidProps
        .map(function (prop) {
          return "`" + prop + "`";
        })
        .join(", ");
      1 === invalidProps.length
        ? console.error(
            "Invalid aria prop %s on <%s> tag. For details, see https://react.dev/link/invalid-aria-props",
            props,
            type
          )
        : 1 < invalidProps.length &&
          console.error(
            "Invalid aria props %s on <%s> tag. For details, see https://react.dev/link/invalid-aria-props",
            props,
            type
          );
    }
    function validateProperty(tagName, name, value, eventRegistry) {
      if (hasOwnProperty.call(warnedProperties, name) && warnedProperties[name])
        return !0;
      var lowerCasedName = name.toLowerCase();
      if ("onfocusin" === lowerCasedName || "onfocusout" === lowerCasedName)
        return (
          console.error(
            "React uses onFocus and onBlur instead of onFocusIn and onFocusOut. All React events are normalized to bubble, so onFocusIn and onFocusOut are not needed/supported by React."
          ),
          (warnedProperties[name] = !0)
        );
      if (
        "function" === typeof value &&
        (("form" === tagName && "action" === name) ||
          ("input" === tagName && "formAction" === name) ||
          ("button" === tagName && "formAction" === name))
      )
        return !0;
      if (null != eventRegistry) {
        tagName = eventRegistry.possibleRegistrationNames;
        if (eventRegistry.registrationNameDependencies.hasOwnProperty(name))
          return !0;
        eventRegistry = tagName.hasOwnProperty(lowerCasedName)
          ? tagName[lowerCasedName]
          : null;
        if (null != eventRegistry)
          return (
            console.error(
              "Invalid event handler property `%s`. Did you mean `%s`?",
              name,
              eventRegistry
            ),
            (warnedProperties[name] = !0)
          );
        if (EVENT_NAME_REGEX.test(name))
          return (
            console.error(
              "Unknown event handler property `%s`. It will be ignored.",
              name
            ),
            (warnedProperties[name] = !0)
          );
      } else if (EVENT_NAME_REGEX.test(name))
        return (
          INVALID_EVENT_NAME_REGEX.test(name) &&
            console.error(
              "Invalid event handler property `%s`. React events use the camelCase naming convention, for example `onClick`.",
              name
            ),
          (warnedProperties[name] = !0)
        );
      if (rARIA.test(name) || rARIACamel.test(name)) return !0;
      if ("innerhtml" === lowerCasedName)
        return (
          console.error(
            "Directly setting property `innerHTML` is not permitted. For more information, lookup documentation on `dangerouslySetInnerHTML`."
          ),
          (warnedProperties[name] = !0)
        );
      if ("aria" === lowerCasedName)
        return (
          console.error(
            "The `aria` attribute is reserved for future use in React. Pass individual `aria-` attributes instead."
          ),
          (warnedProperties[name] = !0)
        );
      if (
        "is" === lowerCasedName &&
        null !== value &&
        void 0 !== value &&
        "string" !== typeof value
      )
        return (
          console.error(
            "Received a `%s` for a string attribute `is`. If this is expected, cast the value to a string.",
            typeof value
          ),
          (warnedProperties[name] = !0)
        );
      if ("number" === typeof value && isNaN(value))
        return (
          console.error(
            "Received NaN for the `%s` attribute. If this is expected, cast the value to a string.",
            name
          ),
          (warnedProperties[name] = !0)
        );
      if (possibleStandardNames.hasOwnProperty(lowerCasedName)) {
        if (
          ((lowerCasedName = possibleStandardNames[lowerCasedName]),
          lowerCasedName !== name)
        )
          return (
            console.error(
              "Invalid DOM property `%s`. Did you mean `%s`?",
              name,
              lowerCasedName
            ),
            (warnedProperties[name] = !0)
          );
      } else if (name !== lowerCasedName)
        return (
          console.error(
            "React does not recognize the `%s` prop on a DOM element. If you intentionally want it to appear in the DOM as a custom attribute, spell it as lowercase `%s` instead. If you accidentally passed it from a parent component, remove it from the DOM element.",
            name,
            lowerCasedName
          ),
          (warnedProperties[name] = !0)
        );
      switch (name) {
        case "dangerouslySetInnerHTML":
        case "children":
        case "style":
        case "suppressContentEditableWarning":
        case "suppressHydrationWarning":
        case "defaultValue":
        case "defaultChecked":
        case "innerHTML":
        case "ref":
          return !0;
        case "innerText":
        case "textContent":
          return !0;
      }
      switch (typeof value) {
        case "boolean":
          switch (name) {
            case "autoFocus":
            case "checked":
            case "multiple":
            case "muted":
            case "selected":
            case "contentEditable":
            case "spellCheck":
            case "draggable":
            case "value":
            case "autoReverse":
            case "externalResourcesRequired":
            case "focusable":
            case "preserveAlpha":
            case "allowFullScreen":
            case "async":
            case "autoPlay":
            case "controls":
            case "default":
            case "defer":
            case "disabled":
            case "disablePictureInPicture":
            case "disableRemotePlayback":
            case "formNoValidate":
            case "hidden":
            case "loop":
            case "noModule":
            case "noValidate":
            case "open":
            case "playsInline":
            case "readOnly":
            case "required":
            case "reversed":
            case "scoped":
            case "seamless":
            case "itemScope":
            case "capture":
            case "download":
            case "inert":
              return !0;
            default:
              lowerCasedName = name.toLowerCase().slice(0, 5);
              if ("data-" === lowerCasedName || "aria-" === lowerCasedName)
                return !0;
              value
                ? console.error(
                    'Received `%s` for a non-boolean attribute `%s`.\n\nIf you want to write it to the DOM, pass a string instead: %s="%s" or %s={value.toString()}.',
                    value,
                    name,
                    name,
                    value,
                    name
                  )
                : console.error(
                    'Received `%s` for a non-boolean attribute `%s`.\n\nIf you want to write it to the DOM, pass a string instead: %s="%s" or %s={value.toString()}.\n\nIf you used to conditionally omit it with %s={condition && value}, pass %s={condition ? value : undefined} instead.',
                    value,
                    name,
                    name,
                    value,
                    name,
                    name,
                    name
                  );
              return (warnedProperties[name] = !0);
          }
        case "function":
        case "symbol":
          return (warnedProperties[name] = !0), !1;
        case "string":
          if ("false" === value || "true" === value) {
            switch (name) {
              case "checked":
              case "selected":
              case "multiple":
              case "muted":
              case "allowFullScreen":
              case "async":
              case "autoPlay":
              case "controls":
              case "default":
              case "defer":
              case "disabled":
              case "disablePictureInPicture":
              case "disableRemotePlayback":
              case "formNoValidate":
              case "hidden":
              case "loop":
              case "noModule":
              case "noValidate":
              case "open":
              case "playsInline":
              case "readOnly":
              case "required":
              case "reversed":
              case "scoped":
              case "seamless":
              case "itemScope":
              case "inert":
                break;
              default:
                return !0;
            }
            console.error(
              "Received the string `%s` for the boolean attribute `%s`. %s Did you mean %s={%s}?",
              value,
              name,
              "false" === value
                ? "The browser will interpret it as a truthy value."
                : 'Although this works, it will not work as expected if you pass the string "false".',
              name,
              value
            );
            warnedProperties[name] = !0;
          }
      }
      return !0;
    }
    function warnUnknownProperties(type, props, eventRegistry) {
      var unknownProps = [],
        key;
      for (key in props)
        validateProperty(type, key, props[key], eventRegistry) ||
          unknownProps.push(key);
      props = unknownProps
        .map(function (prop) {
          return "`" + prop + "`";
        })
        .join(", ");
      1 === unknownProps.length
        ? console.error(
            "Invalid value for prop %s on <%s> tag. Either remove it from the element, or pass a string or number value to keep it in the DOM. For details, see https://react.dev/link/attribute-behavior ",
            props,
            type
          )
        : 1 < unknownProps.length &&
          console.error(
            "Invalid values for props %s on <%s> tag. Either remove them from the element, or pass a string or number value to keep them in the DOM. For details, see https://react.dev/link/attribute-behavior ",
            props,
            type
          );
    }
    function sanitizeURL(url) {
      return isJavaScriptProtocol.test("" + url)
        ? "javascript:throw new Error('React has blocked a javascript: URL as a security precaution.')"
        : url;
    }
    function noop$1() {}
    function getEventTarget(nativeEvent) {
      nativeEvent = nativeEvent.target || nativeEvent.srcElement || window;
      nativeEvent.correspondingUseElement &&
        (nativeEvent = nativeEvent.correspondingUseElement);
      return 3 === nativeEvent.nodeType ? nativeEvent.parentNode : nativeEvent;
    }
    function restoreStateOfTarget(target) {
      var internalInstance = getInstanceFromNode(target);
      if (internalInstance && (target = internalInstance.stateNode)) {
        var props = target[internalPropsKey] || null;
        a: switch (
          ((target = internalInstance.stateNode), internalInstance.type)
        ) {
          case "input":
            updateInput(
              target,
              props.value,
              props.defaultValue,
              props.defaultValue,
              props.checked,
              props.defaultChecked,
              props.type,
              props.name
            );
            internalInstance = props.name;
            if ("radio" === props.type && null != internalInstance) {
              for (props = target; props.parentNode; ) props = props.parentNode;
              checkAttributeStringCoercion(internalInstance, "name");
              props = props.querySelectorAll(
                'input[name="' +
                  escapeSelectorAttributeValueInsideDoubleQuotes(
                    "" + internalInstance
                  ) +
                  '"][type="radio"]'
              );
              for (
                internalInstance = 0;
                internalInstance < props.length;
                internalInstance++
              ) {
                var otherNode = props[internalInstance];
                if (otherNode !== target && otherNode.form === target.form) {
                  var otherProps = otherNode[internalPropsKey] || null;
                  if (!otherProps)
                    throw Error(
                      "ReactDOMInput: Mixing React and non-React radio inputs with the same `name` is not supported."
                    );
                  updateInput(
                    otherNode,
                    otherProps.value,
                    otherProps.defaultValue,
                    otherProps.defaultValue,
                    otherProps.checked,
                    otherProps.defaultChecked,
                    otherProps.type,
                    otherProps.name
                  );
                }
              }
              for (
                internalInstance = 0;
                internalInstance < props.length;
                internalInstance++
              )
                (otherNode = props[internalInstance]),
                  otherNode.form === target.form &&
                    updateValueIfChanged(otherNode);
            }
            break a;
          case "textarea":
            updateTextarea(target, props.value, props.defaultValue);
            break a;
          case "select":
            (internalInstance = props.value),
              null != internalInstance &&
                updateOptions(target, !!props.multiple, internalInstance, !1);
        }
      }
    }
    function batchedUpdates$2(fn, a, b) {
      if (isInsideEventHandler) return fn(a, b);
      isInsideEventHandler = !0;
      try {
        var JSCompiler_inline_result = fn(a);
        return JSCompiler_inline_result;
      } finally {
        if (
          ((isInsideEventHandler = !1),
          null !== restoreTarget || null !== restoreQueue)
        )
          if (
            (flushSyncWork$1(),
            restoreTarget &&
              ((a = restoreTarget),
              (fn = restoreQueue),
              (restoreQueue = restoreTarget = null),
              restoreStateOfTarget(a),
              fn))
          )
            for (a = 0; a < fn.length; a++) restoreStateOfTarget(fn[a]);
      }
    }
    function getListener(inst, registrationName) {
      var stateNode = inst.stateNode;
      if (null === stateNode) return null;
      var props = stateNode[internalPropsKey] || null;
      if (null === props) return null;
      stateNode = props[registrationName];
      a: switch (registrationName) {
        case "onClick":
        case "onClickCapture":
        case "onDoubleClick":
        case "onDoubleClickCapture":
        case "onMouseDown":
        case "onMouseDownCapture":
        case "onMouseMove":
        case "onMouseMoveCapture":
        case "onMouseUp":
        case "onMouseUpCapture":
        case "onMouseEnter":
          (props = !props.disabled) ||
            ((inst = inst.type),
            (props = !(
              "button" === inst ||
              "input" === inst ||
              "select" === inst ||
              "textarea" === inst
            )));
          inst = !props;
          break a;
        default:
          inst = !1;
      }
      if (inst) return null;
      if (stateNode && "function" !== typeof stateNode)
        throw Error(
          "Expected `" +
            registrationName +
            "` listener to be a function, instead got a value of `" +
            typeof stateNode +
            "` type."
        );
      return stateNode;
    }
    function getData() {
      if (fallbackText) return fallbackText;
      var start,
        startValue = startText,
        startLength = startValue.length,
        end,
        endValue = "value" in root ? root.value : root.textContent,
        endLength = endValue.length;
      for (
        start = 0;
        start < startLength && startValue[start] === endValue[start];
        start++
      );
      var minEnd = startLength - start;
      for (
        end = 1;
        end <= minEnd &&
        startValue[startLength - end] === endValue[endLength - end];
        end++
      );
      return (fallbackText = endValue.slice(start, 1 < end ? 1 - end : void 0));
    }
    function getEventCharCode(nativeEvent) {
      var keyCode = nativeEvent.keyCode;
      "charCode" in nativeEvent
        ? ((nativeEvent = nativeEvent.charCode),
          0 === nativeEvent && 13 === keyCode && (nativeEvent = 13))
        : (nativeEvent = keyCode);
      10 === nativeEvent && (nativeEvent = 13);
      return 32 <= nativeEvent || 13 === nativeEvent ? nativeEvent : 0;
    }
    function functionThatReturnsTrue() {
      return !0;
    }
    function functionThatReturnsFalse() {
      return !1;
    }
    function createSyntheticEvent(Interface) {
      function SyntheticBaseEvent(
        reactName,
        reactEventType,
        targetInst,
        nativeEvent,
        nativeEventTarget
      ) {
        this._reactName = reactName;
        this._targetInst = targetInst;
        this.type = reactEventType;
        this.nativeEvent = nativeEvent;
        this.target = nativeEventTarget;
        this.currentTarget = null;
        for (var propName in Interface)
          Interface.hasOwnProperty(propName) &&
            ((reactName = Interface[propName]),
            (this[propName] = reactName
              ? reactName(nativeEvent)
              : nativeEvent[propName]));
        this.isDefaultPrevented = (
          null != nativeEvent.defaultPrevented
            ? nativeEvent.defaultPrevented
            : !1 === nativeEvent.returnValue
        )
          ? functionThatReturnsTrue
          : functionThatReturnsFalse;
        this.isPropagationStopped = functionThatReturnsFalse;
        return this;
      }
      assign(SyntheticBaseEvent.prototype, {
        preventDefault: function () {
          this.defaultPrevented = !0;
          var event = this.nativeEvent;
          event &&
            (event.preventDefault
              ? event.preventDefault()
              : "unknown" !== typeof event.returnValue &&
                (event.returnValue = !1),
            (this.isDefaultPrevented = functionThatReturnsTrue));
        },
        stopPropagation: function () {
          var event = this.nativeEvent;
          event &&
            (event.stopPropagation
              ? event.stopPropagation()
              : "unknown" !== typeof event.cancelBubble &&
                (event.cancelBubble = !0),
            (this.isPropagationStopped = functionThatReturnsTrue));
        },
        persist: function () {},
        isPersistent: functionThatReturnsTrue
      });
      return SyntheticBaseEvent;
    }
    function modifierStateGetter(keyArg) {
      var nativeEvent = this.nativeEvent;
      return nativeEvent.getModifierState
        ? nativeEvent.getModifierState(keyArg)
        : (keyArg = modifierKeyToProp[keyArg])
          ? !!nativeEvent[keyArg]
          : !1;
    }
    function getEventModifierState() {
      return modifierStateGetter;
    }
    function isFallbackCompositionEnd(domEventName, nativeEvent) {
      switch (domEventName) {
        case "keyup":
          return -1 !== END_KEYCODES.indexOf(nativeEvent.keyCode);
        case "keydown":
          return nativeEvent.keyCode !== START_KEYCODE;
        case "keypress":
        case "mousedown":
        case "focusout":
          return !0;
        default:
          return !1;
      }
    }
    function getDataFromCustomEvent(nativeEvent) {
      nativeEvent = nativeEvent.detail;
      return "object" === typeof nativeEvent && "data" in nativeEvent
        ? nativeEvent.data
        : null;
    }
    function getNativeBeforeInputChars(domEventName, nativeEvent) {
      switch (domEventName) {
        case "compositionend":
          return getDataFromCustomEvent(nativeEvent);
        case "keypress":
          if (nativeEvent.which !== SPACEBAR_CODE) return null;
          hasSpaceKeypress = !0;
          return SPACEBAR_CHAR;
        case "textInput":
          return (
            (domEventName = nativeEvent.data),
            domEventName === SPACEBAR_CHAR && hasSpaceKeypress
              ? null
              : domEventName
          );
        default:
          return null;
      }
    }
    function getFallbackBeforeInputChars(domEventName, nativeEvent) {
      if (isComposing)
        return "compositionend" === domEventName ||
          (!canUseCompositionEvent &&
            isFallbackCompositionEnd(domEventName, nativeEvent))
          ? ((domEventName = getData()),
            (fallbackText = startText = root = null),
            (isComposing = !1),
            domEventName)
          : null;
      switch (domEventName) {
        case "paste":
          return null;
        case "keypress":
          if (
            !(
              nativeEvent.ctrlKey ||
              nativeEvent.altKey ||
              nativeEvent.metaKey
            ) ||
            (nativeEvent.ctrlKey && nativeEvent.altKey)
          ) {
            if (nativeEvent.char && 1 < nativeEvent.char.length)
              return nativeEvent.char;
            if (nativeEvent.which)
              return String.fromCharCode(nativeEvent.which);
          }
          return null;
        case "compositionend":
          return useFallbackCompositionData && "ko" !== nativeEvent.locale
            ? null
            : nativeEvent.data;
        default:
          return null;
      }
    }
    function isTextInputElement(elem) {
      var nodeName = elem && elem.nodeName && elem.nodeName.toLowerCase();
      return "input" === nodeName
        ? !!supportedInputTypes[elem.type]
        : "textarea" === nodeName
          ? !0
          : !1;
    }
    function isEventSupported(eventNameSuffix) {
      if (!canUseDOM) return !1;
      eventNameSuffix = "on" + eventNameSuffix;
      var isSupported = eventNameSuffix in document;
      isSupported ||
        ((isSupported = document.createElement("div")),
        isSupported.setAttribute(eventNameSuffix, "return;"),
        (isSupported = "function" === typeof isSupported[eventNameSuffix]));
      return isSupported;
    }
    function createAndAccumulateChangeEvent(
      dispatchQueue,
      inst,
      nativeEvent,
      target
    ) {
      restoreTarget
        ? restoreQueue
          ? restoreQueue.push(target)
          : (restoreQueue = [target])
        : (restoreTarget = target);
      inst = accumulateTwoPhaseListeners(inst, "onChange");
      0 < inst.length &&
        ((nativeEvent = new SyntheticEvent(
          "onChange",
          "change",
          null,
          nativeEvent,
          target
        )),
        dispatchQueue.push({ event: nativeEvent, listeners: inst }));
    }
    function runEventInBatch$1(dispatchQueue) {
      processDispatchQueue(dispatchQueue, 0);
    }
    function getInstIfValueChanged(targetInst) {
      var targetNode = getNodeFromInstance(targetInst);
      if (updateValueIfChanged(targetNode)) return targetInst;
    }
    function getTargetInstForChangeEvent(domEventName, targetInst) {
      if ("change" === domEventName) return targetInst;
    }
    function stopWatchingForValueChange() {
      activeElement$1 &&
        (activeElement$1.detachEvent("onpropertychange", handlePropertyChange),
        (activeElementInst$1 = activeElement$1 = null));
    }
    function handlePropertyChange(nativeEvent) {
      if (
        "value" === nativeEvent.propertyName &&
        getInstIfValueChanged(activeElementInst$1)
      ) {
        var dispatchQueue = [];
        createAndAccumulateChangeEvent(
          dispatchQueue,
          activeElementInst$1,
          nativeEvent,
          getEventTarget(nativeEvent)
        );
        batchedUpdates$2(runEventInBatch$1, dispatchQueue);
      }
    }
    function handleEventsForInputEventPolyfill(
      domEventName,
      target,
      targetInst
    ) {
      "focusin" === domEventName
        ? (stopWatchingForValueChange(),
          (activeElement$1 = target),
          (activeElementInst$1 = targetInst),
          activeElement$1.attachEvent("onpropertychange", handlePropertyChange))
        : "focusout" === domEventName && stopWatchingForValueChange();
    }
    function getTargetInstForInputEventPolyfill(domEventName) {
      if (
        "selectionchange" === domEventName ||
        "keyup" === domEventName ||
        "keydown" === domEventName
      )
        return getInstIfValueChanged(activeElementInst$1);
    }
    function getTargetInstForClickEvent(domEventName, targetInst) {
      if ("click" === domEventName) return getInstIfValueChanged(targetInst);
    }
    function getTargetInstForInputOrChangeEvent(domEventName, targetInst) {
      if ("input" === domEventName || "change" === domEventName)
        return getInstIfValueChanged(targetInst);
    }
    function is(x, y) {
      return (x === y && (0 !== x || 1 / x === 1 / y)) || (x !== x && y !== y);
    }
    function shallowEqual(objA, objB) {
      if (objectIs(objA, objB)) return !0;
      if (
        "object" !== typeof objA ||
        null === objA ||
        "object" !== typeof objB ||
        null === objB
      )
        return !1;
      var keysA = Object.keys(objA),
        keysB = Object.keys(objB);
      if (keysA.length !== keysB.length) return !1;
      for (keysB = 0; keysB < keysA.length; keysB++) {
        var currentKey = keysA[keysB];
        if (
          !hasOwnProperty.call(objB, currentKey) ||
          !objectIs(objA[currentKey], objB[currentKey])
        )
          return !1;
      }
      return !0;
    }
    function getLeafNode(node) {
      for (; node && node.firstChild; ) node = node.firstChild;
      return node;
    }
    function getNodeForCharacterOffset(root, offset) {
      var node = getLeafNode(root);
      root = 0;
      for (var nodeEnd; node; ) {
        if (3 === node.nodeType) {
          nodeEnd = root + node.textContent.length;
          if (root <= offset && nodeEnd >= offset)
            return { node: node, offset: offset - root };
          root = nodeEnd;
        }
        a: {
          for (; node; ) {
            if (node.nextSibling) {
              node = node.nextSibling;
              break a;
            }
            node = node.parentNode;
          }
          node = void 0;
        }
        node = getLeafNode(node);
      }
    }
    function containsNode(outerNode, innerNode) {
      return outerNode && innerNode
        ? outerNode === innerNode
          ? !0
          : outerNode && 3 === outerNode.nodeType
            ? !1
            : innerNode && 3 === innerNode.nodeType
              ? containsNode(outerNode, innerNode.parentNode)
              : "contains" in outerNode
                ? outerNode.contains(innerNode)
                : outerNode.compareDocumentPosition
                  ? !!(outerNode.compareDocumentPosition(innerNode) & 16)
                  : !1
        : !1;
    }
    function getActiveElementDeep(containerInfo) {
      containerInfo =
        null != containerInfo &&
        null != containerInfo.ownerDocument &&
        null != containerInfo.ownerDocument.defaultView
          ? containerInfo.ownerDocument.defaultView
          : window;
      for (
        var element = getActiveElement(containerInfo.document);
        element instanceof containerInfo.HTMLIFrameElement;

      ) {
        try {
          var JSCompiler_inline_result =
            "string" === typeof element.contentWindow.location.href;
        } catch (err) {
          JSCompiler_inline_result = !1;
        }
        if (JSCompiler_inline_result) containerInfo = element.contentWindow;
        else break;
        element = getActiveElement(containerInfo.document);
      }
      return element;
    }
    function hasSelectionCapabilities(elem) {
      var nodeName = elem && elem.nodeName && elem.nodeName.toLowerCase();
      return (
        nodeName &&
        (("input" === nodeName &&
          ("text" === elem.type ||
            "search" === elem.type ||
            "tel" === elem.type ||
            "url" === elem.type ||
            "password" === elem.type)) ||
          "textarea" === nodeName ||
          "true" === elem.contentEditable)
      );
    }
    function constructSelectEvent(
      dispatchQueue,
      nativeEvent,
      nativeEventTarget
    ) {
      var doc =
        nativeEventTarget.window === nativeEventTarget
          ? nativeEventTarget.document
          : 9 === nativeEventTarget.nodeType
            ? nativeEventTarget
            : nativeEventTarget.ownerDocument;
      mouseDown ||
        null == activeElement ||
        activeElement !== getActiveElement(doc) ||
        ((doc = activeElement),
        "selectionStart" in doc && hasSelectionCapabilities(doc)
          ? (doc = { start: doc.selectionStart, end: doc.selectionEnd })
          : ((doc = (
              (doc.ownerDocument && doc.ownerDocument.defaultView) ||
              window
            ).getSelection()),
            (doc = {
              anchorNode: doc.anchorNode,
              anchorOffset: doc.anchorOffset,
              focusNode: doc.focusNode,
              focusOffset: doc.focusOffset
            })),
        (lastSelection && shallowEqual(lastSelection, doc)) ||
          ((lastSelection = doc),
          (doc = accumulateTwoPhaseListeners(activeElementInst, "onSelect")),
          0 < doc.length &&
            ((nativeEvent = new SyntheticEvent(
              "onSelect",
              "select",
              null,
              nativeEvent,
              nativeEventTarget
            )),
            dispatchQueue.push({ event: nativeEvent, listeners: doc }),
            (nativeEvent.target = activeElement))));
    }
    function makePrefixMap(styleProp, eventName) {
      var prefixes = {};
      prefixes[styleProp.toLowerCase()] = eventName.toLowerCase();
      prefixes["Webkit" + styleProp] = "webkit" + eventName;
      prefixes["Moz" + styleProp] = "moz" + eventName;
      return prefixes;
    }
    function getVendorPrefixedEventName(eventName) {
      if (prefixedEventNames[eventName]) return prefixedEventNames[eventName];
      if (!vendorPrefixes[eventName]) return eventName;
      var prefixMap = vendorPrefixes[eventName],
        styleProp;
      for (styleProp in prefixMap)
        if (prefixMap.hasOwnProperty(styleProp) && styleProp in style)
          return (prefixedEventNames[eventName] = prefixMap[styleProp]);
      return eventName;
    }
    function registerSimpleEvent(domEventName, reactName) {
      topLevelEventsToReactNames.set(domEventName, reactName);
      registerTwoPhaseEvent(reactName, [domEventName]);
    }
    function getViewTransitionName(props, instance) {
      if (null != props.name && "auto" !== props.name) return props.name;
      if (null !== instance.autoName) return instance.autoName;
      props = pendingEffectsRoot.identifierPrefix;
      var globalClientId = globalClientIdCounter$1++;
      props = "_" + props + "t_" + globalClientId.toString(32) + "_";
      return (instance.autoName = props);
    }
    function getClassNameByType(classByType) {
      if (null == classByType || "string" === typeof classByType)
        return classByType;
      var className = null,
        activeTypes = pendingTransitionTypes;
      if (null !== activeTypes)
        for (var i = 0; i < activeTypes.length; i++) {
          var match = classByType[activeTypes[i]];
          if (null != match) {
            if ("none" === match) return "none";
            className = null == className ? match : className + (" " + match);
          }
        }
      return null == className ? classByType.default : className;
    }
    function getViewTransitionClassName(defaultClass, eventClass) {
      defaultClass = getClassNameByType(defaultClass);
      eventClass = getClassNameByType(eventClass);
      return null == eventClass
        ? "auto" === defaultClass
          ? null
          : defaultClass
        : "auto" === eventClass
          ? null
          : eventClass;
    }
    function getArrayKind(array) {
      for (var kind = EMPTY_ARRAY, i = 0; i < array.length; i++) {
        var value = array[i];
        if ("object" === typeof value && null !== value)
          if (
            isArrayImpl(value) &&
            2 === value.length &&
            "string" === typeof value[0]
          ) {
            if (kind !== EMPTY_ARRAY && kind !== ENTRIES_ARRAY)
              return COMPLEX_ARRAY;
            kind = ENTRIES_ARRAY;
          } else return COMPLEX_ARRAY;
        else {
          if (
            "function" === typeof value ||
            ("string" === typeof value && 50 < value.length) ||
            (kind !== EMPTY_ARRAY && kind !== PRIMITIVE_ARRAY)
          )
            return COMPLEX_ARRAY;
          kind = PRIMITIVE_ARRAY;
        }
      }
      return kind;
    }
    function addObjectToProperties(object, properties, indent, prefix) {
      for (var key in object)
        hasOwnProperty.call(object, key) &&
          "_" !== key[0] &&
          addValueToProperties(key, object[key], properties, indent, prefix);
    }
    function addValueToProperties(
      propertyName,
      value,
      properties,
      indent,
      prefix
    ) {
      switch (typeof value) {
        case "object":
          if (null === value) {
            value = "null";
            break;
          } else {
            if (value.$$typeof === REACT_ELEMENT_TYPE) {
              var typeName = getComponentNameFromType(value.type) || "\u2026",
                key = value.key;
              value = value.props;
              var propsKeys = Object.keys(value),
                propsLength = propsKeys.length;
              if (null == key && 0 === propsLength) {
                value = "<" + typeName + " />";
                break;
              }
              if (
                3 > indent ||
                (1 === propsLength &&
                  "children" === propsKeys[0] &&
                  null == key)
              ) {
                value = "<" + typeName + " \u2026 />";
                break;
              }
              properties.push([
                prefix + "\u00a0\u00a0".repeat(indent) + propertyName,
                "<" + typeName
              ]);
              null !== key &&
                addValueToProperties(
                  "key",
                  key,
                  properties,
                  indent + 1,
                  prefix
                );
              propertyName = !1;
              for (var propKey in value)
                "children" === propKey
                  ? null != value.children &&
                    (!isArrayImpl(value.children) ||
                      0 < value.children.length) &&
                    (propertyName = !0)
                  : hasOwnProperty.call(value, propKey) &&
                    "_" !== propKey[0] &&
                    addValueToProperties(
                      propKey,
                      value[propKey],
                      properties,
                      indent + 1,
                      prefix
                    );
              properties.push([
                "",
                propertyName ? ">\u2026</" + typeName + ">" : "/>"
              ]);
              return;
            }
            typeName = Object.prototype.toString.call(value);
            typeName = typeName.slice(8, typeName.length - 1);
            if ("Array" === typeName)
              if (
                ((propKey = getArrayKind(value)),
                propKey === PRIMITIVE_ARRAY || propKey === EMPTY_ARRAY)
              ) {
                value = JSON.stringify(value);
                break;
              } else if (propKey === ENTRIES_ARRAY) {
                properties.push([
                  prefix + "\u00a0\u00a0".repeat(indent) + propertyName,
                  ""
                ]);
                for (
                  propertyName = 0;
                  propertyName < value.length;
                  propertyName++
                )
                  (typeName = value[propertyName]),
                    addValueToProperties(
                      typeName[0],
                      typeName[1],
                      properties,
                      indent + 1,
                      prefix
                    );
                return;
              }
            if ("Promise" === typeName) {
              if ("fulfilled" === value.status) {
                if (
                  ((typeName = properties.length),
                  addValueToProperties(
                    propertyName,
                    value.value,
                    properties,
                    indent,
                    prefix
                  ),
                  properties.length > typeName)
                ) {
                  properties = properties[typeName];
                  properties[1] =
                    "Promise<" + (properties[1] || "Object") + ">";
                  return;
                }
              } else if (
                "rejected" === value.status &&
                ((typeName = properties.length),
                addValueToProperties(
                  propertyName,
                  value.reason,
                  properties,
                  indent,
                  prefix
                ),
                properties.length > typeName)
              ) {
                properties = properties[typeName];
                properties[1] = "Rejected Promise<" + properties[1] + ">";
                return;
              }
              properties.push([
                "\u00a0\u00a0".repeat(indent) + propertyName,
                "Promise"
              ]);
              return;
            }
            "Object" === typeName &&
              (propKey = Object.getPrototypeOf(value)) &&
              "function" === typeof propKey.constructor &&
              (typeName = propKey.constructor.name);
            properties.push([
              prefix + "\u00a0\u00a0".repeat(indent) + propertyName,
              "Object" === typeName ? (3 > indent ? "" : "\u2026") : typeName
            ]);
            3 > indent &&
              addObjectToProperties(value, properties, indent + 1, prefix);
            return;
          }
        case "function":
          value = "" === value.name ? "() => {}" : value.name + "() {}";
          break;
        case "string":
          value =
            value === OMITTED_PROP_ERROR ? "\u2026" : JSON.stringify(value);
          break;
        case "undefined":
          value = "undefined";
          break;
        case "boolean":
          value = value ? "true" : "false";
          break;
        default:
          value = String(value);
      }
      properties.push([
        prefix + "\u00a0\u00a0".repeat(indent) + propertyName,
        value
      ]);
    }
    function addObjectDiffToProperties(prev, next, properties, indent) {
      var isDeeplyEqual = !0;
      for (key in prev)
        key in next ||
          (properties.push([
            REMOVED + "\u00a0\u00a0".repeat(indent) + key,
            "\u2026"
          ]),
          (isDeeplyEqual = !1));
      for (var _key in next)
        if (_key in prev) {
          var key = prev[_key];
          var nextValue = next[_key];
          if (key !== nextValue) {
            if (0 === indent && "children" === _key)
              (isDeeplyEqual = "\u00a0\u00a0".repeat(indent) + _key),
                properties.push(
                  [REMOVED + isDeeplyEqual, "\u2026"],
                  [ADDED + isDeeplyEqual, "\u2026"]
                );
            else {
              if (!(3 <= indent))
                if (
                  "object" === typeof key &&
                  "object" === typeof nextValue &&
                  null !== key &&
                  null !== nextValue &&
                  key.$$typeof === nextValue.$$typeof
                )
                  if (nextValue.$$typeof === REACT_ELEMENT_TYPE) {
                    if (
                      key.type === nextValue.type &&
                      key.key === nextValue.key
                    ) {
                      key =
                        getComponentNameFromType(nextValue.type) || "\u2026";
                      isDeeplyEqual = "\u00a0\u00a0".repeat(indent) + _key;
                      key = "<" + key + " \u2026 />";
                      properties.push(
                        [REMOVED + isDeeplyEqual, key],
                        [ADDED + isDeeplyEqual, key]
                      );
                      isDeeplyEqual = !1;
                      continue;
                    }
                  } else {
                    var prevKind = Object.prototype.toString.call(key),
                      nextKind = Object.prototype.toString.call(nextValue);
                    if (
                      prevKind === nextKind &&
                      ("[object Object]" === nextKind ||
                        "[object Array]" === nextKind)
                    ) {
                      prevKind = [
                        UNCHANGED + "\u00a0\u00a0".repeat(indent) + _key,
                        "[object Array]" === nextKind ? "Array" : ""
                      ];
                      properties.push(prevKind);
                      nextKind = properties.length;
                      addObjectDiffToProperties(
                        key,
                        nextValue,
                        properties,
                        indent + 1
                      )
                        ? nextKind === properties.length &&
                          (prevKind[1] =
                            "Referentially unequal but deeply equal objects. Consider memoization.")
                        : (isDeeplyEqual = !1);
                      continue;
                    }
                  }
                else if (
                  "function" === typeof key &&
                  "function" === typeof nextValue &&
                  key.name === nextValue.name &&
                  key.length === nextValue.length &&
                  ((prevKind = Function.prototype.toString.call(key)),
                  (nextKind = Function.prototype.toString.call(nextValue)),
                  prevKind === nextKind)
                ) {
                  key =
                    "" === nextValue.name
                      ? "() => {}"
                      : nextValue.name + "() {}";
                  properties.push([
                    UNCHANGED + "\u00a0\u00a0".repeat(indent) + _key,
                    key +
                      " Referentially unequal function closure. Consider memoization."
                  ]);
                  continue;
                }
              addValueToProperties(_key, key, properties, indent, REMOVED);
              addValueToProperties(_key, nextValue, properties, indent, ADDED);
            }
            isDeeplyEqual = !1;
          }
        } else
          properties.push([
            ADDED + "\u00a0\u00a0".repeat(indent) + _key,
            "\u2026"
          ]),
            (isDeeplyEqual = !1);
      return isDeeplyEqual;
    }
    function setCurrentTrackFromLanes(lanes) {
      currentTrack =
        lanes & 127
          ? "Blocking"
          : lanes & 4194176
            ? "Transition"
            : lanes & 62914560
              ? "Suspense"
              : lanes & 2080374784
                ? "Idle"
                : "Other";
    }
    function logComponentTrigger(fiber, startTime, endTime, trigger) {
      supportsUserTiming &&
        ((reusableComponentOptions.start = startTime),
        (reusableComponentOptions.end = endTime),
        (reusableComponentDevToolDetails.color = "warning"),
        (reusableComponentDevToolDetails.tooltipText = trigger),
        (reusableComponentDevToolDetails.properties = null),
        (fiber = fiber._debugTask)
          ? fiber.run(
              performance.measure.bind(
                performance,
                trigger,
                reusableComponentOptions
              )
            )
          : performance.measure(trigger, reusableComponentOptions));
    }
    function logComponentReappeared(fiber, startTime, endTime) {
      logComponentTrigger(fiber, startTime, endTime, "Reconnect");
    }
    function logComponentRender(
      fiber,
      startTime,
      endTime,
      wasHydrated,
      committedLanes
    ) {
      var name = getComponentNameFromFiber(fiber);
      if (null !== name && supportsUserTiming) {
        var alternate = fiber.alternate,
          selfTime = fiber.actualDuration;
        if (null === alternate || alternate.child !== fiber.child)
          for (var child = fiber.child; null !== child; child = child.sibling)
            selfTime -= child.actualDuration;
        wasHydrated =
          0.5 > selfTime
            ? wasHydrated
              ? "tertiary-light"
              : "primary-light"
            : 10 > selfTime
              ? wasHydrated
                ? "tertiary"
                : "primary"
              : 100 > selfTime
                ? wasHydrated
                  ? "tertiary-dark"
                  : "primary-dark"
                : "error";
        if ((selfTime = fiber._debugTask)) {
          var props = fiber.memoizedProps;
          if (
            null !== props &&
            null !== alternate &&
            alternate.memoizedProps !== props &&
            ((child = [resuableChangedPropsEntry]),
            (props = addObjectDiffToProperties(
              alternate.memoizedProps,
              props,
              child,
              0
            )),
            1 < child.length)
          ) {
            props &&
            !alreadyWarnedForDeepEquality &&
            0 === (alternate.lanes & committedLanes) &&
            100 < fiber.actualDuration
              ? ((alreadyWarnedForDeepEquality = !0),
                (child[0] = reusableDeeplyEqualPropsEntry),
                (reusableComponentDevToolDetails.color = "warning"),
                (reusableComponentDevToolDetails.tooltipText =
                  DEEP_EQUALITY_WARNING))
              : ((reusableComponentDevToolDetails.color = wasHydrated),
                (reusableComponentDevToolDetails.tooltipText = name));
            reusableComponentDevToolDetails.properties = child;
            reusableComponentOptions.start = startTime;
            reusableComponentOptions.end = endTime;
            selfTime.run(
              performance.measure.bind(
                performance,
                "\u200b" + name,
                reusableComponentOptions
              )
            );
            return;
          }
          selfTime.run(
            console.timeStamp.bind(
              console,
              name,
              startTime,
              endTime,
              COMPONENTS_TRACK,
              void 0,
              wasHydrated
            )
          );
        } else
          console.timeStamp(
            name,
            startTime,
            endTime,
            COMPONENTS_TRACK,
            void 0,
            wasHydrated
          );
      }
    }
    function logComponentErrored(fiber, startTime, endTime, errors) {
      if (supportsUserTiming) {
        var name = getComponentNameFromFiber(fiber);
        if (null !== name) {
          for (
            var debugTask = null, properties = [], i = 0;
            i < errors.length;
            i++
          ) {
            var capturedValue = errors[i];
            null == debugTask &&
              null !== capturedValue.source &&
              (debugTask = capturedValue.source._debugTask);
            capturedValue = capturedValue.value;
            properties.push([
              "Error",
              "object" === typeof capturedValue &&
              null !== capturedValue &&
              "string" === typeof capturedValue.message
                ? String(capturedValue.message)
                : String(capturedValue)
            ]);
          }
          null !== fiber.key &&
            addValueToProperties("key", fiber.key, properties, 0, "");
          null !== fiber.memoizedProps &&
            addObjectToProperties(fiber.memoizedProps, properties, 0, "");
          null == debugTask && (debugTask = fiber._debugTask);
          fiber = {
            start: startTime,
            end: endTime,
            detail: {
              devtools: {
                color: "error",
                track: COMPONENTS_TRACK,
                tooltipText:
                  13 === fiber.tag
                    ? "Hydration failed"
                    : "Error boundary caught an error",
                properties: properties
              }
            }
          };
          debugTask
            ? debugTask.run(
                performance.measure.bind(performance, "\u200b" + name, fiber)
              )
            : performance.measure("\u200b" + name, fiber);
        }
      }
    }
    function logComponentEffect(fiber, startTime, endTime, selfTime, errors) {
      if (null !== errors) {
        if (supportsUserTiming) {
          var name = getComponentNameFromFiber(fiber);
          if (null !== name) {
            selfTime = [];
            for (var i = 0; i < errors.length; i++) {
              var error = errors[i].value;
              selfTime.push([
                "Error",
                "object" === typeof error &&
                null !== error &&
                "string" === typeof error.message
                  ? String(error.message)
                  : String(error)
              ]);
            }
            null !== fiber.key &&
              addValueToProperties("key", fiber.key, selfTime, 0, "");
            null !== fiber.memoizedProps &&
              addObjectToProperties(fiber.memoizedProps, selfTime, 0, "");
            startTime = {
              start: startTime,
              end: endTime,
              detail: {
                devtools: {
                  color: "error",
                  track: COMPONENTS_TRACK,
                  tooltipText: "A lifecycle or effect errored",
                  properties: selfTime
                }
              }
            };
            (fiber = fiber._debugTask)
              ? fiber.run(
                  performance.measure.bind(
                    performance,
                    "\u200b" + name,
                    startTime
                  )
                )
              : performance.measure("\u200b" + name, startTime);
          }
        }
      } else
        (name = getComponentNameFromFiber(fiber)),
          null !== name &&
            supportsUserTiming &&
            ((errors =
              1 > selfTime
                ? "secondary-light"
                : 100 > selfTime
                  ? "secondary"
                  : 500 > selfTime
                    ? "secondary-dark"
                    : "error"),
            (fiber = fiber._debugTask)
              ? fiber.run(
                  console.timeStamp.bind(
                    console,
                    name,
                    startTime,
                    endTime,
                    COMPONENTS_TRACK,
                    void 0,
                    errors
                  )
                )
              : console.timeStamp(
                  name,
                  startTime,
                  endTime,
                  COMPONENTS_TRACK,
                  void 0,
                  errors
                ));
    }
    function logSuspendedRenderPhase(startTime, endTime, lanes) {
      supportsUserTiming &&
        console.timeStamp(
          "Prewarm",
          startTime,
          endTime,
          currentTrack,
          LANES_TRACK_GROUP,
          (lanes & 738197653) === lanes ? "tertiary-dark" : "primary-dark"
        );
    }
    function logSuspendedWithDelayPhase(startTime, endTime, lanes) {
      supportsUserTiming &&
        console.timeStamp(
          "Suspended",
          startTime,
          endTime,
          currentTrack,
          LANES_TRACK_GROUP,
          (lanes & 738197653) === lanes ? "tertiary-dark" : "primary-dark"
        );
    }
    function logRecoveredRenderPhase(
      startTime,
      endTime,
      lanes,
      recoverableErrors,
      hydrationFailed
    ) {
      if (supportsUserTiming) {
        lanes = [];
        for (var i = 0; i < recoverableErrors.length; i++) {
          var error = recoverableErrors[i].value;
          lanes.push([
            "Recoverable Error",
            "object" === typeof error &&
            null !== error &&
            "string" === typeof error.message
              ? String(error.message)
              : String(error)
          ]);
        }
        performance.measure("Recovered", {
          start: startTime,
          end: endTime,
          detail: {
            devtools: {
              color: "primary-dark",
              track: currentTrack,
              trackGroup: LANES_TRACK_GROUP,
              tooltipText: hydrationFailed
                ? "Hydration Failed"
                : "Recovered after Error",
              properties: lanes
            }
          }
        });
      }
    }
    function logErroredRenderPhase(startTime, endTime) {
      supportsUserTiming &&
        console.timeStamp(
          "Errored",
          startTime,
          endTime,
          currentTrack,
          LANES_TRACK_GROUP,
          "error"
        );
    }
    function logCommitErrored(startTime, endTime, errors, passive) {
      if (supportsUserTiming) {
        for (var properties = [], i = 0; i < errors.length; i++) {
          var error = errors[i].value;
          properties.push([
            "Error",
            "object" === typeof error &&
            null !== error &&
            "string" === typeof error.message
              ? String(error.message)
              : String(error)
          ]);
        }
        performance.measure("Errored", {
          start: startTime,
          end: endTime,
          detail: {
            devtools: {
              color: "error",
              track: currentTrack,
              trackGroup: LANES_TRACK_GROUP,
              tooltipText: passive
                ? "Remaining Effects Errored"
                : "Commit Errored",
              properties: properties
            }
          }
        });
      }
    }
    function finishQueueingConcurrentUpdates() {
      for (
        var endIndex = concurrentQueuesIndex,
          i = (concurrentlyUpdatedLanes = concurrentQueuesIndex = 0);
        i < endIndex;

      ) {
        var fiber = concurrentQueues[i];
        concurrentQueues[i++] = null;
        var queue = concurrentQueues[i];
        concurrentQueues[i++] = null;
        var update = concurrentQueues[i];
        concurrentQueues[i++] = null;
        var lane = concurrentQueues[i];
        concurrentQueues[i++] = null;
        if (null !== queue && null !== update) {
          var pending = queue.pending;
          null === pending
            ? (update.next = update)
            : ((update.next = pending.next), (pending.next = update));
          queue.pending = update;
        }
        0 !== lane && markUpdateLaneFromFiberToRoot(fiber, update, lane);
      }
    }
    function enqueueUpdate$1(fiber, queue, update, lane) {
      concurrentQueues[concurrentQueuesIndex++] = fiber;
      concurrentQueues[concurrentQueuesIndex++] = queue;
      concurrentQueues[concurrentQueuesIndex++] = update;
      concurrentQueues[concurrentQueuesIndex++] = lane;
      concurrentlyUpdatedLanes |= lane;
      fiber.lanes |= lane;
      fiber = fiber.alternate;
      null !== fiber && (fiber.lanes |= lane);
    }
    function enqueueConcurrentHookUpdate(fiber, queue, update, lane) {
      enqueueUpdate$1(fiber, queue, update, lane);
      return getRootForUpdatedFiber(fiber);
    }
    function enqueueConcurrentRenderForLane(fiber, lane) {
      enqueueUpdate$1(fiber, null, null, lane);
      return getRootForUpdatedFiber(fiber);
    }
    function markUpdateLaneFromFiberToRoot(sourceFiber, update, lane) {
      sourceFiber.lanes |= lane;
      var alternate = sourceFiber.alternate;
      null !== alternate && (alternate.lanes |= lane);
      for (var isHidden = !1, parent = sourceFiber.return; null !== parent; )
        (parent.childLanes |= lane),
          (alternate = parent.alternate),
          null !== alternate && (alternate.childLanes |= lane),
          22 === parent.tag &&
            ((sourceFiber = parent.stateNode),
            null === sourceFiber ||
              sourceFiber._visibility & OffscreenVisible ||
              (isHidden = !0)),
          (sourceFiber = parent),
          (parent = parent.return);
      return 3 === sourceFiber.tag
        ? ((parent = sourceFiber.stateNode),
          isHidden &&
            null !== update &&
            ((isHidden = 31 - clz32(lane)),
            (sourceFiber = parent.hiddenUpdates),
            (alternate = sourceFiber[isHidden]),
            null === alternate
              ? (sourceFiber[isHidden] = [update])
              : alternate.push(update),
            (update.lane = lane | 536870912)),
          parent)
        : null;
    }
    function getRootForUpdatedFiber(sourceFiber) {
      if (nestedUpdateCount > NESTED_UPDATE_LIMIT)
        throw (
          ((nestedPassiveUpdateCount = nestedUpdateCount = 0),
          (rootWithPassiveNestedUpdates = rootWithNestedUpdates = null),
          Error(
            "Maximum update depth exceeded. This can happen when a component repeatedly calls setState inside componentWillUpdate or componentDidUpdate. React limits the number of nested updates to prevent infinite loops."
          ))
        );
      nestedPassiveUpdateCount > NESTED_PASSIVE_UPDATE_LIMIT &&
        ((nestedPassiveUpdateCount = 0),
        (rootWithPassiveNestedUpdates = null),
        console.error(
          "Maximum update depth exceeded. This can happen when a component calls setState inside useEffect, but useEffect either doesn't have a dependency array, or one of the dependencies changes on every render."
        ));
      null === sourceFiber.alternate &&
        0 !== (sourceFiber.flags & 4098) &&
        warnAboutUpdateOnNotYetMountedFiberInDEV(sourceFiber);
      for (var node = sourceFiber, parent = node.return; null !== parent; )
        null === node.alternate &&
          0 !== (node.flags & 4098) &&
          warnAboutUpdateOnNotYetMountedFiberInDEV(sourceFiber),
          (node = parent),
          (parent = node.return);
      return 3 === node.tag ? node.stateNode : null;
    }
    function resolveFunctionForHotReloading(type) {
      if (null === resolveFamily) return type;
      var family = resolveFamily(type);
      return void 0 === family ? type : family.current;
    }
    function resolveForwardRefForHotReloading(type) {
      if (null === resolveFamily) return type;
      var family = resolveFamily(type);
      return void 0 === family
        ? null !== type &&
          void 0 !== type &&
          "function" === typeof type.render &&
          ((family = resolveFunctionForHotReloading(type.render)),
          type.render !== family)
          ? ((family = { $$typeof: REACT_FORWARD_REF_TYPE, render: family }),
            void 0 !== type.displayName &&
              (family.displayName = type.displayName),
            family)
          : type
        : family.current;
    }
    function isCompatibleFamilyForHotReloading(fiber, element) {
      if (null === resolveFamily) return !1;
      var prevType = fiber.elementType;
      element = element.type;
      var needsCompareFamilies = !1,
        $$typeofNextType =
          "object" === typeof element && null !== element
            ? element.$$typeof
            : null;
      switch (fiber.tag) {
        case 1:
          "function" === typeof element && (needsCompareFamilies = !0);
          break;
        case 0:
          "function" === typeof element
            ? (needsCompareFamilies = !0)
            : $$typeofNextType === REACT_LAZY_TYPE &&
              (needsCompareFamilies = !0);
          break;
        case 11:
          $$typeofNextType === REACT_FORWARD_REF_TYPE
            ? (needsCompareFamilies = !0)
            : $$typeofNextType === REACT_LAZY_TYPE &&
              (needsCompareFamilies = !0);
          break;
        case 14:
        case 15:
          $$typeofNextType === REACT_MEMO_TYPE
            ? (needsCompareFamilies = !0)
            : $$typeofNextType === REACT_LAZY_TYPE &&
              (needsCompareFamilies = !0);
          break;
        default:
          return !1;
      }
      return needsCompareFamilies &&
        ((fiber = resolveFamily(prevType)),
        void 0 !== fiber && fiber === resolveFamily(element))
        ? !0
        : !1;
    }
    function markFailedErrorBoundaryForHotReloading(fiber) {
      null !== resolveFamily &&
        "function" === typeof WeakSet &&
        (null === failedBoundaries && (failedBoundaries = new WeakSet()),
        failedBoundaries.add(fiber));
    }
    function scheduleFibersWithFamiliesRecursively(
      fiber,
      updatedFamilies,
      staleFamilies
    ) {
      var alternate = fiber.alternate,
        child = fiber.child,
        sibling = fiber.sibling,
        tag = fiber.tag,
        type = fiber.type,
        candidateType = null;
      switch (tag) {
        case 0:
        case 15:
        case 1:
          candidateType = type;
          break;
        case 11:
          candidateType = type.render;
      }
      if (null === resolveFamily)
        throw Error("Expected resolveFamily to be set during hot reload.");
      var needsRender = !1;
      type = !1;
      null !== candidateType &&
        ((candidateType = resolveFamily(candidateType)),
        void 0 !== candidateType &&
          (staleFamilies.has(candidateType)
            ? (type = !0)
            : updatedFamilies.has(candidateType) &&
              (1 === tag ? (type = !0) : (needsRender = !0))));
      null !== failedBoundaries &&
        (failedBoundaries.has(fiber) ||
          (null !== alternate && failedBoundaries.has(alternate))) &&
        (type = !0);
      type && (fiber._debugNeedsRemount = !0);
      if (type || needsRender)
        (alternate = enqueueConcurrentRenderForLane(fiber, 2)),
          null !== alternate && scheduleUpdateOnFiber(alternate, fiber, 2);
      null === child ||
        type ||
        scheduleFibersWithFamiliesRecursively(
          child,
          updatedFamilies,
          staleFamilies
        );
      null !== sibling &&
        scheduleFibersWithFamiliesRecursively(
          sibling,
          updatedFamilies,
          staleFamilies
        );
    }
    function FiberNode(tag, pendingProps, key, mode) {
      this.tag = tag;
      this.key = key;
      this.sibling =
        this.child =
        this.return =
        this.stateNode =
        this.type =
        this.elementType =
          null;
      this.index = 0;
      this.refCleanup = this.ref = null;
      this.pendingProps = pendingProps;
      this.dependencies =
        this.memoizedState =
        this.updateQueue =
        this.memoizedProps =
          null;
      this.mode = mode;
      this.subtreeFlags = this.flags = 0;
      this.deletions = null;
      this.childLanes = this.lanes = 0;
      this.alternate = null;
      this.actualDuration = -0;
      this.actualStartTime = -1.1;
      this.treeBaseDuration = this.selfBaseDuration = -0;
      this._debugTask =
        this._debugStack =
        this._debugOwner =
        this._debugInfo =
          null;
      this._debugNeedsRemount = !1;
      this._debugHookTypes = null;
      hasBadMapPolyfill ||
        "function" !== typeof Object.preventExtensions ||
        Object.preventExtensions(this);
    }
    function shouldConstruct(Component) {
      Component = Component.prototype;
      return !(!Component || !Component.isReactComponent);
    }
    function createWorkInProgress(current, pendingProps) {
      var workInProgress = current.alternate;
      null === workInProgress
        ? ((workInProgress = createFiber(
            current.tag,
            pendingProps,
            current.key,
            current.mode
          )),
          (workInProgress.elementType = current.elementType),
          (workInProgress.type = current.type),
          (workInProgress.stateNode = current.stateNode),
          (workInProgress._debugOwner = current._debugOwner),
          (workInProgress._debugStack = current._debugStack),
          (workInProgress._debugTask = current._debugTask),
          (workInProgress._debugHookTypes = current._debugHookTypes),
          (workInProgress.alternate = current),
          (current.alternate = workInProgress))
        : ((workInProgress.pendingProps = pendingProps),
          (workInProgress.type = current.type),
          (workInProgress.flags = 0),
          (workInProgress.subtreeFlags = 0),
          (workInProgress.deletions = null),
          (workInProgress.actualDuration = -0),
          (workInProgress.actualStartTime = -1.1));
      workInProgress.flags = current.flags & 65011712;
      workInProgress.childLanes = current.childLanes;
      workInProgress.lanes = current.lanes;
      workInProgress.child = current.child;
      workInProgress.memoizedProps = current.memoizedProps;
      workInProgress.memoizedState = current.memoizedState;
      workInProgress.updateQueue = current.updateQueue;
      pendingProps = current.dependencies;
      workInProgress.dependencies =
        null === pendingProps
          ? null
          : {
              lanes: pendingProps.lanes,
              firstContext: pendingProps.firstContext,
              _debugThenableState: pendingProps._debugThenableState
            };
      workInProgress.sibling = current.sibling;
      workInProgress.index = current.index;
      workInProgress.ref = current.ref;
      workInProgress.refCleanup = current.refCleanup;
      workInProgress.selfBaseDuration = current.selfBaseDuration;
      workInProgress.treeBaseDuration = current.treeBaseDuration;
      workInProgress._debugInfo = current._debugInfo;
      workInProgress._debugNeedsRemount = current._debugNeedsRemount;
      switch (workInProgress.tag) {
        case 0:
        case 15:
          workInProgress.type = resolveFunctionForHotReloading(current.type);
          break;
        case 1:
          workInProgress.type = resolveFunctionForHotReloading(current.type);
          break;
        case 11:
          workInProgress.type = resolveForwardRefForHotReloading(current.type);
      }
      return workInProgress;
    }
    function resetWorkInProgress(workInProgress, renderLanes) {
      workInProgress.flags &= 65011714;
      var current = workInProgress.alternate;
      null === current
        ? ((workInProgress.childLanes = 0),
          (workInProgress.lanes = renderLanes),
          (workInProgress.child = null),
          (workInProgress.subtreeFlags = 0),
          (workInProgress.memoizedProps = null),
          (workInProgress.memoizedState = null),
          (workInProgress.updateQueue = null),
          (workInProgress.dependencies = null),
          (workInProgress.stateNode = null),
          (workInProgress.selfBaseDuration = 0),
          (workInProgress.treeBaseDuration = 0))
        : ((workInProgress.childLanes = current.childLanes),
          (workInProgress.lanes = current.lanes),
          (workInProgress.child = current.child),
          (workInProgress.subtreeFlags = 0),
          (workInProgress.deletions = null),
          (workInProgress.memoizedProps = current.memoizedProps),
          (workInProgress.memoizedState = current.memoizedState),
          (workInProgress.updateQueue = current.updateQueue),
          (workInProgress.type = current.type),
          (renderLanes = current.dependencies),
          (workInProgress.dependencies =
            null === renderLanes
              ? null
              : {
                  lanes: renderLanes.lanes,
                  firstContext: renderLanes.firstContext,
                  _debugThenableState: renderLanes._debugThenableState
                }),
          (workInProgress.selfBaseDuration = current.selfBaseDuration),
          (workInProgress.treeBaseDuration = current.treeBaseDuration));
      return workInProgress;
    }
    function createFiberFromTypeAndProps(
      type,
      key,
      pendingProps,
      owner,
      mode,
      lanes
    ) {
      var fiberTag = 0,
        resolvedType = type;
      if ("function" === typeof type)
        shouldConstruct(type) && (fiberTag = 1),
          (resolvedType = resolveFunctionForHotReloading(resolvedType));
      else if ("string" === typeof type)
        (fiberTag = getHostContext()),
          (fiberTag = isHostHoistableType(type, pendingProps, fiberTag)
            ? 26
            : "html" === type || "head" === type || "body" === type
              ? 27
              : 5);
      else
        a: switch (type) {
          case REACT_ACTIVITY_TYPE:
            return (
              (key = createFiber(31, pendingProps, key, mode)),
              (key.elementType = REACT_ACTIVITY_TYPE),
              (key.lanes = lanes),
              key
            );
          case REACT_FRAGMENT_TYPE:
            return createFiberFromFragment(
              pendingProps.children,
              mode,
              lanes,
              key
            );
          case REACT_STRICT_MODE_TYPE:
            fiberTag = 8;
            mode |= StrictLegacyMode;
            mode |= StrictEffectsMode;
            break;
          case REACT_PROFILER_TYPE:
            return (
              (type = pendingProps),
              (owner = mode),
              "string" !== typeof type.id &&
                console.error(
                  'Profiler must specify an "id" of type `string` as a prop. Received the type `%s` instead.',
                  typeof type.id
                ),
              (key = createFiber(12, type, key, owner | ProfileMode)),
              (key.elementType = REACT_PROFILER_TYPE),
              (key.lanes = lanes),
              (key.stateNode = { effectDuration: 0, passiveEffectDuration: 0 }),
              key
            );
          case REACT_SUSPENSE_TYPE:
            return (
              (key = createFiber(13, pendingProps, key, mode)),
              (key.elementType = REACT_SUSPENSE_TYPE),
              (key.lanes = lanes),
              key
            );
          case REACT_SUSPENSE_LIST_TYPE:
            return (
              (key = createFiber(19, pendingProps, key, mode)),
              (key.elementType = REACT_SUSPENSE_LIST_TYPE),
              (key.lanes = lanes),
              key
            );
          case REACT_LEGACY_HIDDEN_TYPE:
          case REACT_VIEW_TRANSITION_TYPE:
            return (
              (type = mode | SuspenseyImagesMode),
              (key = createFiber(30, pendingProps, key, type)),
              (key.elementType = REACT_VIEW_TRANSITION_TYPE),
              (key.lanes = lanes),
              (key.stateNode = {
                autoName: null,
                paired: null,
                clones: null,
                ref: null
              }),
              key
            );
          default:
            if ("object" === typeof type && null !== type)
              switch (type.$$typeof) {
                case REACT_CONTEXT_TYPE:
                  fiberTag = 10;
                  break a;
                case REACT_CONSUMER_TYPE:
                  fiberTag = 9;
                  break a;
                case REACT_FORWARD_REF_TYPE:
                  fiberTag = 11;
                  resolvedType = resolveForwardRefForHotReloading(resolvedType);
                  break a;
                case REACT_MEMO_TYPE:
                  fiberTag = 14;
                  break a;
                case REACT_LAZY_TYPE:
                  fiberTag = 16;
                  resolvedType = null;
                  break a;
              }
            pendingProps = "";
            if (
              void 0 === type ||
              ("object" === typeof type &&
                null !== type &&
                0 === Object.keys(type).length)
            )
              pendingProps +=
                " You likely forgot to export your component from the file it's defined in, or you might have mixed up default and named imports.";
            null === type
              ? (resolvedType = "null")
              : isArrayImpl(type)
                ? (resolvedType = "array")
                : void 0 !== type && type.$$typeof === REACT_ELEMENT_TYPE
                  ? ((resolvedType =
                      "<" +
                      (getComponentNameFromType(type.type) || "Unknown") +
                      " />"),
                    (pendingProps =
                      " Did you accidentally export a JSX literal instead of a component?"))
                  : (resolvedType = typeof type);
            (fiberTag = owner ? getComponentNameFromOwner(owner) : null) &&
              (pendingProps +=
                "\n\nCheck the render method of `" + fiberTag + "`.");
            fiberTag = 29;
            pendingProps = Error(
              "Element type is invalid: expected a string (for built-in components) or a class/function (for composite components) but got: " +
                (resolvedType + "." + pendingProps)
            );
            resolvedType = null;
        }
      key = createFiber(fiberTag, pendingProps, key, mode);
      key.elementType = type;
      key.type = resolvedType;
      key.lanes = lanes;
      key._debugOwner = owner;
      return key;
    }
    function createFiberFromElement(element, mode, lanes) {
      mode = createFiberFromTypeAndProps(
        element.type,
        element.key,
        element.props,
        element._owner,
        mode,
        lanes
      );
      mode._debugOwner = element._owner;
      mode._debugStack = element._debugStack;
      mode._debugTask = element._debugTask;
      return mode;
    }
    function createFiberFromFragment(elements, mode, lanes, key) {
      elements = createFiber(7, elements, key, mode);
      elements.lanes = lanes;
      return elements;
    }
    function createFiberFromText(content, mode, lanes) {
      content = createFiber(6, content, null, mode);
      content.lanes = lanes;
      return content;
    }
    function createFiberFromDehydratedFragment(dehydratedNode) {
      var fiber = createFiber(18, null, null, NoMode);
      fiber.stateNode = dehydratedNode;
      return fiber;
    }
    function createFiberFromPortal(portal, mode, lanes) {
      mode = createFiber(
        4,
        null !== portal.children ? portal.children : [],
        portal.key,
        mode
      );
      mode.lanes = lanes;
      mode.stateNode = {
        containerInfo: portal.containerInfo,
        pendingChildren: null,
        implementation: portal.implementation
      };
      return mode;
    }
    function createCapturedValueAtFiber(value, source) {
      if ("object" === typeof value && null !== value) {
        var existing = CapturedStacks.get(value);
        if (void 0 !== existing) return existing;
        source = {
          value: value,
          source: source,
          stack: getStackByFiberInDevAndProd(source)
        };
        CapturedStacks.set(value, source);
        return source;
      }
      return {
        value: value,
        source: source,
        stack: getStackByFiberInDevAndProd(source)
      };
    }
    function pushTreeFork(workInProgress, totalChildren) {
      warnIfNotHydrating();
      forkStack[forkStackIndex++] = treeForkCount;
      forkStack[forkStackIndex++] = treeForkProvider;
      treeForkProvider = workInProgress;
      treeForkCount = totalChildren;
    }
    function pushTreeId(workInProgress, totalChildren, index) {
      warnIfNotHydrating();
      idStack[idStackIndex++] = treeContextId;
      idStack[idStackIndex++] = treeContextOverflow;
      idStack[idStackIndex++] = treeContextProvider;
      treeContextProvider = workInProgress;
      var baseIdWithLeadingBit = treeContextId;
      workInProgress = treeContextOverflow;
      var baseLength = 32 - clz32(baseIdWithLeadingBit) - 1;
      baseIdWithLeadingBit &= ~(1 << baseLength);
      index += 1;
      var length = 32 - clz32(totalChildren) + baseLength;
      if (30 < length) {
        var numberOfOverflowBits = baseLength - (baseLength % 5);
        length = (
          baseIdWithLeadingBit &
          ((1 << numberOfOverflowBits) - 1)
        ).toString(32);
        baseIdWithLeadingBit >>= numberOfOverflowBits;
        baseLength -= numberOfOverflowBits;
        treeContextId =
          (1 << (32 - clz32(totalChildren) + baseLength)) |
          (index << baseLength) |
          baseIdWithLeadingBit;
        treeContextOverflow = length + workInProgress;
      } else
        (treeContextId =
          (1 << length) | (index << baseLength) | baseIdWithLeadingBit),
          (treeContextOverflow = workInProgress);
    }
    function pushMaterializedTreeId(workInProgress) {
      warnIfNotHydrating();
      null !== workInProgress.return &&
        (pushTreeFork(workInProgress, 1), pushTreeId(workInProgress, 1, 0));
    }
    function popTreeContext(workInProgress) {
      for (; workInProgress === treeForkProvider; )
        (treeForkProvider = forkStack[--forkStackIndex]),
          (forkStack[forkStackIndex] = null),
          (treeForkCount = forkStack[--forkStackIndex]),
          (forkStack[forkStackIndex] = null);
      for (; workInProgress === treeContextProvider; )
        (treeContextProvider = idStack[--idStackIndex]),
          (idStack[idStackIndex] = null),
          (treeContextOverflow = idStack[--idStackIndex]),
          (idStack[idStackIndex] = null),
          (treeContextId = idStack[--idStackIndex]),
          (idStack[idStackIndex] = null);
    }
    function getSuspendedTreeContext() {
      warnIfNotHydrating();
      return null !== treeContextProvider
        ? { id: treeContextId, overflow: treeContextOverflow }
        : null;
    }
    function restoreSuspendedTreeContext(workInProgress, suspendedContext) {
      warnIfNotHydrating();
      idStack[idStackIndex++] = treeContextId;
      idStack[idStackIndex++] = treeContextOverflow;
      idStack[idStackIndex++] = treeContextProvider;
      treeContextId = suspendedContext.id;
      treeContextOverflow = suspendedContext.overflow;
      treeContextProvider = workInProgress;
    }
    function warnIfNotHydrating() {
      isHydrating ||
        console.error(
          "Expected to be hydrating. This is a bug in React. Please file an issue."
        );
    }
    function buildHydrationDiffNode(fiber, distanceFromLeaf) {
      if (null === fiber.return) {
        if (null === hydrationDiffRootDEV)
          hydrationDiffRootDEV = {
            fiber: fiber,
            children: [],
            serverProps: void 0,
            serverTail: [],
            distanceFromLeaf: distanceFromLeaf
          };
        else {
          if (hydrationDiffRootDEV.fiber !== fiber)
            throw Error(
              "Saw multiple hydration diff roots in a pass. This is a bug in React."
            );
          hydrationDiffRootDEV.distanceFromLeaf > distanceFromLeaf &&
            (hydrationDiffRootDEV.distanceFromLeaf = distanceFromLeaf);
        }
        return hydrationDiffRootDEV;
      }
      var siblings = buildHydrationDiffNode(
        fiber.return,
        distanceFromLeaf + 1
      ).children;
      if (0 < siblings.length && siblings[siblings.length - 1].fiber === fiber)
        return (
          (siblings = siblings[siblings.length - 1]),
          siblings.distanceFromLeaf > distanceFromLeaf &&
            (siblings.distanceFromLeaf = distanceFromLeaf),
          siblings
        );
      distanceFromLeaf = {
        fiber: fiber,
        children: [],
        serverProps: void 0,
        serverTail: [],
        distanceFromLeaf: distanceFromLeaf
      };
      siblings.push(distanceFromLeaf);
      return distanceFromLeaf;
    }
    function warnIfHydrating() {
      isHydrating &&
        console.error(
          "We should not be hydrating here. This is a bug in React. Please file a bug."
        );
    }
    function warnNonHydratedInstance(fiber, rejectedCandidate) {
      didSuspendOrErrorDEV ||
        ((fiber = buildHydrationDiffNode(fiber, 0)),
        (fiber.serverProps = null),
        null !== rejectedCandidate &&
          ((rejectedCandidate =
            describeHydratableInstanceForDevWarnings(rejectedCandidate)),
          fiber.serverTail.push(rejectedCandidate)));
    }
    function throwOnHydrationMismatch(fiber) {
      var fromText =
          1 < arguments.length && void 0 !== arguments[1] ? arguments[1] : !1,
        diff = "",
        diffRoot = hydrationDiffRootDEV;
      null !== diffRoot &&
        ((hydrationDiffRootDEV = null), (diff = describeDiff(diffRoot)));
      queueHydrationError(
        createCapturedValueAtFiber(
          Error(
            "Hydration failed because the server rendered " +
              (fromText ? "text" : "HTML") +
              " didn't match the client. As a result this tree will be regenerated on the client. This can happen if a SSR-ed Client Component used:\n\n- A server/client branch `if (typeof window !== 'undefined')`.\n- Variable input such as `Date.now()` or `Math.random()` which changes each time it's called.\n- Date formatting in a user's locale which doesn't match the server.\n- External changing data without sending a snapshot of it along with the HTML.\n- Invalid HTML tag nesting.\n\nIt can also happen if the client has a browser extension installed which messes with the HTML before React loaded.\n\nhttps://react.dev/link/hydration-mismatch" +
              diff
          ),
          fiber
        )
      );
      throw HydrationMismatchException;
    }
    function prepareToHydrateHostInstance(fiber) {
      var didHydrate = fiber.stateNode;
      var type = fiber.type,
        props = fiber.memoizedProps;
      didHydrate[internalInstanceKey] = fiber;
      didHydrate[internalPropsKey] = props;
      validatePropertiesInDevelopment(type, props);
      switch (type) {
        case "dialog":
          listenToNonDelegatedEvent("cancel", didHydrate);
          listenToNonDelegatedEvent("close", didHydrate);
          break;
        case "iframe":
        case "object":
        case "embed":
          listenToNonDelegatedEvent("load", didHydrate);
          break;
        case "video":
        case "audio":
          for (type = 0; type < mediaEventTypes.length; type++)
            listenToNonDelegatedEvent(mediaEventTypes[type], didHydrate);
          break;
        case "source":
          listenToNonDelegatedEvent("error", didHydrate);
          break;
        case "img":
        case "image":
        case "link":
          listenToNonDelegatedEvent("error", didHydrate);
          listenToNonDelegatedEvent("load", didHydrate);
          break;
        case "details":
          listenToNonDelegatedEvent("toggle", didHydrate);
          break;
        case "input":
          checkControlledValueProps("input", props);
          listenToNonDelegatedEvent("invalid", didHydrate);
          validateInputProps(didHydrate, props);
          break;
        case "option":
          validateOptionProps(didHydrate, props);
          break;
        case "select":
          checkControlledValueProps("select", props);
          listenToNonDelegatedEvent("invalid", didHydrate);
          validateSelectProps(didHydrate, props);
          break;
        case "textarea":
          checkControlledValueProps("textarea", props),
            listenToNonDelegatedEvent("invalid", didHydrate),
            validateTextareaProps(didHydrate, props);
      }
      type = props.children;
      ("string" !== typeof type &&
        "number" !== typeof type &&
        "bigint" !== typeof type) ||
      didHydrate.textContent === "" + type ||
      !0 === props.suppressHydrationWarning ||
      checkForUnmatchedText(didHydrate.textContent, type)
        ? (null != props.popover &&
            (listenToNonDelegatedEvent("beforetoggle", didHydrate),
            listenToNonDelegatedEvent("toggle", didHydrate)),
          null != props.onScroll &&
            listenToNonDelegatedEvent("scroll", didHydrate),
          null != props.onScrollEnd &&
            (listenToNonDelegatedEvent("scrollend", didHydrate),
            listenToNonDelegatedEvent("scroll", didHydrate)),
          null != props.onClick && (didHydrate.onclick = noop$1),
          (didHydrate = !0))
        : (didHydrate = !1);
      didHydrate || throwOnHydrationMismatch(fiber, !0);
    }
    function popToNextHostParent(fiber) {
      for (hydrationParentFiber = fiber.return; hydrationParentFiber; )
        switch (hydrationParentFiber.tag) {
          case 5:
          case 31:
          case 13:
            rootOrSingletonContext = !1;
            return;
          case 27:
          case 3:
            rootOrSingletonContext = !0;
            return;
          default:
            hydrationParentFiber = hydrationParentFiber.return;
        }
    }
    function popHydrationState(fiber) {
      if (fiber !== hydrationParentFiber) return !1;
      if (!isHydrating)
        return popToNextHostParent(fiber), (isHydrating = !0), !1;
      var tag = fiber.tag,
        JSCompiler_temp;
      if ((JSCompiler_temp = 3 !== tag && 27 !== tag)) {
        if ((JSCompiler_temp = 5 === tag))
          (JSCompiler_temp = fiber.type),
            (JSCompiler_temp =
              !("form" !== JSCompiler_temp && "button" !== JSCompiler_temp) ||
              shouldSetTextContent(fiber.type, fiber.memoizedProps));
        JSCompiler_temp = !JSCompiler_temp;
      }
      if (JSCompiler_temp && nextHydratableInstance) {
        for (JSCompiler_temp = nextHydratableInstance; JSCompiler_temp; ) {
          var diffNode = buildHydrationDiffNode(fiber, 0),
            description =
              describeHydratableInstanceForDevWarnings(JSCompiler_temp);
          diffNode.serverTail.push(description);
          JSCompiler_temp =
            "Suspense" === description.type
              ? getNextHydratableInstanceAfterHydrationBoundary(JSCompiler_temp)
              : getNextHydratable(JSCompiler_temp.nextSibling);
        }
        throwOnHydrationMismatch(fiber);
      }
      popToNextHostParent(fiber);
      if (13 === tag) {
        fiber = fiber.memoizedState;
        fiber = null !== fiber ? fiber.dehydrated : null;
        if (!fiber)
          throw Error(
            "Expected to have a hydrated suspense instance. This error is likely caused by a bug in React. Please file an issue."
          );
        nextHydratableInstance =
          getNextHydratableInstanceAfterHydrationBoundary(fiber);
      } else if (31 === tag) {
        fiber = fiber.memoizedState;
        fiber = null !== fiber ? fiber.dehydrated : null;
        if (!fiber)
          throw Error(
            "Expected to have a hydrated suspense instance. This error is likely caused by a bug in React. Please file an issue."
          );
        nextHydratableInstance =
          getNextHydratableInstanceAfterHydrationBoundary(fiber);
      } else
        27 === tag
          ? ((tag = nextHydratableInstance),
            isSingletonScope(fiber.type)
              ? ((fiber = previousHydratableOnEnteringScopedSingleton),
                (previousHydratableOnEnteringScopedSingleton = null),
                (nextHydratableInstance = fiber))
              : (nextHydratableInstance = tag))
          : (nextHydratableInstance = hydrationParentFiber
              ? getNextHydratable(fiber.stateNode.nextSibling)
              : null);
      return !0;
    }
    function resetHydrationState() {
      nextHydratableInstance = hydrationParentFiber = null;
      didSuspendOrErrorDEV = isHydrating = !1;
    }
    function upgradeHydrationErrorsToRecoverable() {
      var queuedErrors = hydrationErrors;
      null !== queuedErrors &&
        (null === workInProgressRootRecoverableErrors
          ? (workInProgressRootRecoverableErrors = queuedErrors)
          : workInProgressRootRecoverableErrors.push.apply(
              workInProgressRootRecoverableErrors,
              queuedErrors
            ),
        (hydrationErrors = null));
      return queuedErrors;
    }
    function queueHydrationError(error) {
      null === hydrationErrors
        ? (hydrationErrors = [error])
        : hydrationErrors.push(error);
    }
    function emitPendingHydrationWarnings() {
      var diffRoot = hydrationDiffRootDEV;
      if (null !== diffRoot) {
        hydrationDiffRootDEV = null;
        for (var diff = describeDiff(diffRoot); 0 < diffRoot.children.length; )
          diffRoot = diffRoot.children[0];
        runWithFiberInDEV(diffRoot.fiber, function () {
          console.error(
            "A tree hydrated but some attributes of the server rendered HTML didn't match the client properties. This won't be patched up. This can happen if a SSR-ed Client Component used:\n\n- A server/client branch `if (typeof window !== 'undefined')`.\n- Variable input such as `Date.now()` or `Math.random()` which changes each time it's called.\n- Date formatting in a user's locale which doesn't match the server.\n- External changing data without sending a snapshot of it along with the HTML.\n- Invalid HTML tag nesting.\n\nIt can also happen if the client has a browser extension installed which messes with the HTML before React loaded.\n\n%s%s",
            "https://react.dev/link/hydration-mismatch",
            diff
          );
        });
      }
    }
    function resetContextDependencies() {
      lastContextDependency = currentlyRenderingFiber$1 = null;
      isDisallowedContextReadInDEV = !1;
    }
    function pushProvider(providerFiber, context, nextValue) {
      push(valueCursor, context._currentValue, providerFiber);
      context._currentValue = nextValue;
      push(rendererCursorDEV, context._currentRenderer, providerFiber);
      void 0 !== context._currentRenderer &&
        null !== context._currentRenderer &&
        context._currentRenderer !== rendererSigil &&
        console.error(
          "Detected multiple renderers concurrently rendering the same context provider. This is currently unsupported."
        );
      context._currentRenderer = rendererSigil;
    }
    function popProvider(context, providerFiber) {
      context._currentValue = valueCursor.current;
      var currentRenderer = rendererCursorDEV.current;
      pop(rendererCursorDEV, providerFiber);
      context._currentRenderer = currentRenderer;
      pop(valueCursor, providerFiber);
    }
    function scheduleContextWorkOnParentPath(
      parent,
      renderLanes,
      propagationRoot
    ) {
      for (; null !== parent; ) {
        var alternate = parent.alternate;
        (parent.childLanes & renderLanes) !== renderLanes
          ? ((parent.childLanes |= renderLanes),
            null !== alternate && (alternate.childLanes |= renderLanes))
          : null !== alternate &&
            (alternate.childLanes & renderLanes) !== renderLanes &&
            (alternate.childLanes |= renderLanes);
        if (parent === propagationRoot) break;
        parent = parent.return;
      }
      parent !== propagationRoot &&
        console.error(
          "Expected to find the propagation root when scheduling context work. This error is likely caused by a bug in React. Please file an issue."
        );
    }
    function propagateContextChanges(
      workInProgress,
      contexts,
      renderLanes,
      forcePropagateEntireTree
    ) {
      var fiber = workInProgress.child;
      null !== fiber && (fiber.return = workInProgress);
      for (; null !== fiber; ) {
        var list = fiber.dependencies;
        if (null !== list) {
          var nextFiber = fiber.child;
          list = list.firstContext;
          a: for (; null !== list; ) {
            var dependency = list;
            list = fiber;
            for (var i = 0; i < contexts.length; i++)
              if (dependency.context === contexts[i]) {
                list.lanes |= renderLanes;
                dependency = list.alternate;
                null !== dependency && (dependency.lanes |= renderLanes);
                scheduleContextWorkOnParentPath(
                  list.return,
                  renderLanes,
                  workInProgress
                );
                forcePropagateEntireTree || (nextFiber = null);
                break a;
              }
            list = dependency.next;
          }
        } else if (18 === fiber.tag) {
          nextFiber = fiber.return;
          if (null === nextFiber)
            throw Error(
              "We just came from a parent so we must have had a parent. This is a bug in React."
            );
          nextFiber.lanes |= renderLanes;
          list = nextFiber.alternate;
          null !== list && (list.lanes |= renderLanes);
          scheduleContextWorkOnParentPath(
            nextFiber,
            renderLanes,
            workInProgress
          );
          nextFiber = null;
        } else nextFiber = fiber.child;
        if (null !== nextFiber) nextFiber.return = fiber;
        else
          for (nextFiber = fiber; null !== nextFiber; ) {
            if (nextFiber === workInProgress) {
              nextFiber = null;
              break;
            }
            fiber = nextFiber.sibling;
            if (null !== fiber) {
              fiber.return = nextFiber.return;
              nextFiber = fiber;
              break;
            }
            nextFiber = nextFiber.return;
          }
        fiber = nextFiber;
      }
    }
    function propagateParentContextChanges(
      current,
      workInProgress,
      renderLanes,
      forcePropagateEntireTree
    ) {
      current = null;
      for (
        var parent = workInProgress, isInsidePropagationBailout = !1;
        null !== parent;

      ) {
        if (!isInsidePropagationBailout)
          if (0 !== (parent.flags & 524288)) isInsidePropagationBailout = !0;
          else if (0 !== (parent.flags & 262144)) break;
        if (10 === parent.tag) {
          var currentParent = parent.alternate;
          if (null === currentParent)
            throw Error("Should have a current fiber. This is a bug in React.");
          currentParent = currentParent.memoizedProps;
          if (null !== currentParent) {
            var context = parent.type;
            objectIs(parent.pendingProps.value, currentParent.value) ||
              (null !== current
                ? current.push(context)
                : (current = [context]));
          }
        } else if (parent === hostTransitionProviderCursor.current) {
          currentParent = parent.alternate;
          if (null === currentParent)
            throw Error("Should have a current fiber. This is a bug in React.");
          currentParent.memoizedState.memoizedState !==
            parent.memoizedState.memoizedState &&
            (null !== current
              ? current.push(HostTransitionContext)
              : (current = [HostTransitionContext]));
        }
        parent = parent.return;
      }
      null !== current &&
        propagateContextChanges(
          workInProgress,
          current,
          renderLanes,
          forcePropagateEntireTree
        );
      workInProgress.flags |= 262144;
    }
    function checkIfContextChanged(currentDependencies) {
      for (
        currentDependencies = currentDependencies.firstContext;
        null !== currentDependencies;

      ) {
        if (
          !objectIs(
            currentDependencies.context._currentValue,
            currentDependencies.memoizedValue
          )
        )
          return !0;
        currentDependencies = currentDependencies.next;
      }
      return !1;
    }
    function prepareToReadContext(workInProgress) {
      currentlyRenderingFiber$1 = workInProgress;
      lastContextDependency = null;
      workInProgress = workInProgress.dependencies;
      null !== workInProgress && (workInProgress.firstContext = null);
    }
    function readContext(context) {
      isDisallowedContextReadInDEV &&
        console.error(
          "Context can only be read while React is rendering. In classes, you can read it in the render method or getDerivedStateFromProps. In function components, you can read it directly in the function body, but not inside Hooks like useReducer() or useMemo()."
        );
      return readContextForConsumer(currentlyRenderingFiber$1, context);
    }
    function readContextDuringReconciliation(consumer, context) {
      null === currentlyRenderingFiber$1 && prepareToReadContext(consumer);
      return readContextForConsumer(consumer, context);
    }
    function readContextForConsumer(consumer, context) {
      var value = context._currentValue;
      context = { context: context, memoizedValue: value, next: null };
      if (null === lastContextDependency) {
        if (null === consumer)
          throw Error(
            "Context can only be read while React is rendering. In classes, you can read it in the render method or getDerivedStateFromProps. In function components, you can read it directly in the function body, but not inside Hooks like useReducer() or useMemo()."
          );
        lastContextDependency = context;
        consumer.dependencies = {
          lanes: 0,
          firstContext: context,
          _debugThenableState: null
        };
        consumer.flags |= 524288;
      } else lastContextDependency = lastContextDependency.next = context;
      return value;
    }
    function createCache() {
      return {
        controller: new AbortControllerLocal(),
        data: new Map(),
        refCount: 0
      };
    }
    function retainCache(cache) {
      cache.controller.signal.aborted &&
        console.warn(
          "A cache instance was retained after it was already freed. This likely indicates a bug in React."
        );
      cache.refCount++;
    }
    function releaseCache(cache) {
      cache.refCount--;
      0 > cache.refCount &&
        console.warn(
          "A cache instance was released after it was already freed. This likely indicates a bug in React."
        );
      0 === cache.refCount &&
        scheduleCallback$2(NormalPriority, function () {
          cache.controller.abort();
        });
    }
    function queueTransitionTypes(root, transitionTypes) {
      if (0 !== (root.pendingLanes & 4194048)) {
        var queued = root.transitionTypes;
        null === queued && (queued = root.transitionTypes = []);
        for (root = 0; root < transitionTypes.length; root++) {
          var transitionType = transitionTypes[root];
          -1 === queued.indexOf(transitionType) && queued.push(transitionType);
        }
      }
    }
    function claimQueuedTransitionTypes(root) {
      var claimed = root.transitionTypes;
      root.transitionTypes = null;
      return claimed;
    }
    function startUpdateTimerByLane(lane, method) {
      var JSCompiler_temp;
      (JSCompiler_temp = 0 !== (lane & 3)) ||
        (JSCompiler_temp = 0 !== (lane & 60));
      if (JSCompiler_temp)
        0 > blockingUpdateTime &&
          ((blockingUpdateTime = now()),
          (blockingUpdateTask = createTask(method)),
          (executionContext & (RenderContext | CommitContext)) !== NoContext &&
            (blockingSpawnedUpdate = !0),
          (lane = resolveEventTimeStamp()),
          (method = resolveEventType()),
          lane !== blockingEventTime || method !== blockingEventType
            ? (blockingEventIsRepeat = !1)
            : null !== method && (blockingSpawnedUpdate = !0),
          (blockingEventTime = lane),
          (blockingEventType = method));
      else if (
        0 !== (lane & 4194048) &&
        0 > transitionUpdateTime &&
        ((transitionUpdateTime = now()),
        (transitionUpdateTask = createTask(method)),
        0 > transitionStartTime)
      ) {
        lane = resolveEventTimeStamp();
        method = resolveEventType();
        if (lane !== transitionEventTime || method !== transitionEventType)
          transitionEventIsRepeat = !1;
        transitionEventTime = lane;
        transitionEventType = method;
      }
    }
    function pushNestedEffectDurations() {
      var prevEffectDuration = profilerEffectDuration;
      profilerEffectDuration = 0;
      return prevEffectDuration;
    }
    function popNestedEffectDurations(prevEffectDuration) {
      var elapsedTime = profilerEffectDuration;
      profilerEffectDuration = prevEffectDuration;
      return elapsedTime;
    }
    function bubbleNestedEffectDurations(prevEffectDuration) {
      var elapsedTime = profilerEffectDuration;
      profilerEffectDuration += prevEffectDuration;
      return elapsedTime;
    }
    function resetComponentEffectTimers() {
      componentEffectEndTime = componentEffectStartTime = -1.1;
    }
    function pushComponentEffectStart() {
      var prevEffectStart = componentEffectStartTime;
      componentEffectStartTime = -1.1;
      return prevEffectStart;
    }
    function popComponentEffectStart(prevEffectStart) {
      0 <= prevEffectStart && (componentEffectStartTime = prevEffectStart);
    }
    function pushComponentEffectDuration() {
      var prevEffectDuration = componentEffectDuration;
      componentEffectDuration = -0;
      return prevEffectDuration;
    }
    function popComponentEffectDuration(prevEffectDuration) {
      0 <= prevEffectDuration && (componentEffectDuration = prevEffectDuration);
    }
    function pushComponentEffectErrors() {
      var prevErrors = componentEffectErrors;
      componentEffectErrors = null;
      return prevErrors;
    }
    function startProfilerTimer(fiber) {
      profilerStartTime = now();
      0 > fiber.actualStartTime && (fiber.actualStartTime = profilerStartTime);
    }
    function stopProfilerTimerIfRunningAndRecordDuration(fiber) {
      if (0 <= profilerStartTime) {
        var elapsedTime = now() - profilerStartTime;
        fiber.actualDuration += elapsedTime;
        fiber.selfBaseDuration = elapsedTime;
        profilerStartTime = -1;
      }
    }
    function stopProfilerTimerIfRunningAndRecordIncompleteDuration(fiber) {
      if (0 <= profilerStartTime) {
        var elapsedTime = now() - profilerStartTime;
        fiber.actualDuration += elapsedTime;
        profilerStartTime = -1;
      }
    }
    function recordEffectDuration() {
      if (0 <= profilerStartTime) {
        var endTime = now(),
          elapsedTime = endTime - profilerStartTime;
        profilerStartTime = -1;
        profilerEffectDuration += elapsedTime;
        componentEffectDuration += elapsedTime;
        componentEffectEndTime = endTime;
      }
    }
    function recordEffectError(errorInfo) {
      null === componentEffectErrors && (componentEffectErrors = []);
      componentEffectErrors.push(errorInfo);
      null === commitErrors && (commitErrors = []);
      commitErrors.push(errorInfo);
    }
    function startEffectTimer() {
      profilerStartTime = now();
      0 > componentEffectStartTime &&
        (componentEffectStartTime = profilerStartTime);
    }
    function transferActualDuration(fiber) {
      for (var child = fiber.child; child; )
        (fiber.actualDuration += child.actualDuration), (child = child.sibling);
    }
    function entangleAsyncAction(transition, thenable) {
      if (null === currentEntangledListeners) {
        var entangledListeners = (currentEntangledListeners = []);
        currentEntangledPendingCount = 0;
        currentEntangledLane = requestTransitionLane();
        currentEntangledActionThenable = {
          status: "pending",
          value: void 0,
          then: function (resolve) {
            entangledListeners.push(resolve);
          }
        };
        needsIsomorphicIndicator = !0;
        ensureScheduleIsScheduled();
      }
      currentEntangledPendingCount++;
      thenable.then(pingEngtangledActionScope, pingEngtangledActionScope);
      return thenable;
    }
    function pingEngtangledActionScope() {
      if (
        0 === --currentEntangledPendingCount &&
        (-1 < transitionUpdateTime || (transitionStartTime = -1.1),
        (entangledTransitionTypes = null),
        0 === pendingEntangledRoots && stopIsomorphicDefaultIndicator(),
        null !== currentEntangledListeners)
      ) {
        null !== currentEntangledActionThenable &&
          (currentEntangledActionThenable.status = "fulfilled");
        var listeners = currentEntangledListeners;
        currentEntangledListeners = null;
        currentEntangledLane = 0;
        currentEntangledActionThenable = null;
        needsIsomorphicIndicator = !1;
        for (var i = 0; i < listeners.length; i++) (0, listeners[i])();
      }
    }
    function chainThenableValue(thenable, result) {
      var listeners = [],
        thenableWithOverride = {
          status: "pending",
          value: null,
          reason: null,
          then: function (resolve) {
            listeners.push(resolve);
          }
        };
      thenable.then(
        function () {
          thenableWithOverride.status = "fulfilled";
          thenableWithOverride.value = result;
          for (var i = 0; i < listeners.length; i++) (0, listeners[i])(result);
        },
        function (error) {
          thenableWithOverride.status = "rejected";
          thenableWithOverride.reason = error;
          for (error = 0; error < listeners.length; error++)
            (0, listeners[error])(void 0);
        }
      );
      return thenableWithOverride;
    }
    function registerDefaultIndicator(onDefaultTransitionIndicator) {
      void 0 === isomorphicDefaultTransitionIndicator
        ? (isomorphicDefaultTransitionIndicator = onDefaultTransitionIndicator)
        : isomorphicDefaultTransitionIndicator !==
            onDefaultTransitionIndicator &&
          ((isomorphicDefaultTransitionIndicator = null),
          stopIsomorphicDefaultIndicator());
    }
    function stopIsomorphicDefaultIndicator() {
      if (null !== pendingIsomorphicIndicator) {
        var cleanup = pendingIsomorphicIndicator;
        pendingIsomorphicIndicator = null;
        cleanup();
      }
    }
    function releaseIsomorphicIndicator() {
      0 === --pendingEntangledRoots && stopIsomorphicDefaultIndicator();
    }
    function startScheduledGesture(
      root,
      gestureTimeline,
      gestureOptions,
      transitionTypes
    ) {
      if (gestureOptions && null != gestureOptions.rangeStart)
        var JSCompiler_temp = gestureOptions.rangeStart;
      else {
        JSCompiler_temp = gestureTimeline.currentTime;
        if (null === JSCompiler_temp)
          throw Error(
            "Cannot start a gesture with a disconnected AnimationTimeline."
          );
        JSCompiler_temp =
          "number" === typeof JSCompiler_temp
            ? JSCompiler_temp
            : JSCompiler_temp.value;
      }
      gestureOptions =
        gestureOptions && null != gestureOptions.rangeEnd
          ? gestureOptions.rangeEnd
          : 50 > JSCompiler_temp
            ? 100
            : 0;
      for (root = root.pendingGestures; null !== root; ) {
        if (root.provider === gestureTimeline) {
          root.count++;
          root.rangeStart = JSCompiler_temp;
          root.rangeEnd = gestureOptions;
          if (null !== transitionTypes)
            for (
              gestureTimeline = root.types,
                null === gestureTimeline && (gestureTimeline = root.types = []),
                JSCompiler_temp = 0;
              JSCompiler_temp < transitionTypes.length;
              JSCompiler_temp++
            )
              (gestureOptions = transitionTypes[JSCompiler_temp]),
                -1 === gestureTimeline.indexOf(gestureOptions) &&
                  gestureTimeline.push(gestureOptions);
          return root;
        }
        root = root.next;
        if (null === root) break;
      }
      return null;
    }
    function deleteScheduledGesture(root, gesture) {
      null === gesture.prev
        ? (root.pendingGestures === gesture &&
            ((root.pendingGestures = gesture.next),
            null === root.pendingGestures && (root.pendingLanes &= -65)),
          root.stoppingGestures === gesture &&
            (root.stoppingGestures = gesture.next))
        : ((gesture.prev.next = gesture.next),
          null !== gesture.next && (gesture.next.prev = gesture.prev),
          (gesture.prev = null),
          (gesture.next = null));
    }
    function stopCompletedGestures(root) {
      var gesture = root.stoppingGestures;
      for (root.stoppingGestures = null; null !== gesture; )
        null !== gesture.running &&
          (gesture.running.skipTransition(), (gesture.running = null)),
          (root = gesture.next),
          (gesture.next = null),
          (gesture.prev = null),
          (gesture = root);
    }
    function chainGestureCancellation(root, scheduledGesture, prevCancel) {
      return function () {
        if (
          null !== scheduledGesture &&
          (scheduledGesture.count--, 0 === scheduledGesture.count)
        ) {
          deleteScheduledGesture(root, scheduledGesture);
          var runningTransition = scheduledGesture.running;
          if (null !== runningTransition) {
            var pendingLanesExcludingGestureLane = root.pendingLanes & -65;
            0 !== (pendingLanesExcludingGestureLane & 124) ||
            0 !== (pendingLanesExcludingGestureLane & 4194048)
              ? ((runningTransition = root.stoppingGestures),
                null !== runningTransition &&
                  ((scheduledGesture.next = runningTransition),
                  (runningTransition.prev = scheduledGesture)),
                (root.stoppingGestures = scheduledGesture))
              : ((scheduledGesture.running = null),
                runningTransition.skipTransition());
          }
        }
        null !== prevCancel && prevCancel();
      };
    }
    function peekCacheFromPool() {
      var cacheResumedFromPreviousRender = resumedCache.current;
      return null !== cacheResumedFromPreviousRender
        ? cacheResumedFromPreviousRender
        : workInProgressRoot.pooledCache;
    }
    function pushTransition(offscreenWorkInProgress, prevCachePool) {
      null === prevCachePool
        ? push(resumedCache, resumedCache.current, offscreenWorkInProgress)
        : push(resumedCache, prevCachePool.pool, offscreenWorkInProgress);
    }
    function getSuspendedCache() {
      var cacheFromPool = peekCacheFromPool();
      return null === cacheFromPool
        ? null
        : { parent: CacheContext._currentValue, pool: cacheFromPool };
    }
    function createThenableState() {
      return { didWarnAboutUncachedPromise: !1, thenables: [] };
    }
    function isThenableResolved(thenable) {
      thenable = thenable.status;
      return "fulfilled" === thenable || "rejected" === thenable;
    }
    function trackUsedThenable(thenableState, thenable, index) {
      null !== ReactSharedInternals.actQueue &&
        (ReactSharedInternals.didUsePromise = !0);
      var trackedThenables = thenableState.thenables;
      index = trackedThenables[index];
      void 0 === index
        ? trackedThenables.push(thenable)
        : index !== thenable &&
          (thenableState.didWarnAboutUncachedPromise ||
            ((thenableState.didWarnAboutUncachedPromise = !0),
            console.error(
              "A component was suspended by an uncached promise. Creating promises inside a Client Component or hook is not yet supported, except via a Suspense-compatible library or framework."
            )),
          thenable.then(noop$1, noop$1),
          (thenable = index));
      switch (thenable.status) {
        case "fulfilled":
          return thenable.value;
        case "rejected":
          throw (
            ((thenableState = thenable.reason),
            checkIfUseWrappedInAsyncCatch(thenableState),
            thenableState)
          );
        default:
          if ("string" === typeof thenable.status)
            thenable.then(noop$1, noop$1);
          else {
            thenableState = workInProgressRoot;
            if (
              null !== thenableState &&
              100 < thenableState.shellSuspendCounter
            )
              throw Error(
                "An unknown Component is an async Client Component. Only Server Components can be async at the moment. This error is often caused by accidentally adding `'use client'` to a module that was originally written for the server."
              );
            thenableState = thenable;
            thenableState.status = "pending";
            thenableState.then(
              function (fulfilledValue) {
                if ("pending" === thenable.status) {
                  var fulfilledThenable = thenable;
                  fulfilledThenable.status = "fulfilled";
                  fulfilledThenable.value = fulfilledValue;
                }
              },
              function (error) {
                if ("pending" === thenable.status) {
                  var rejectedThenable = thenable;
                  rejectedThenable.status = "rejected";
                  rejectedThenable.reason = error;
                }
              }
            );
          }
          switch (thenable.status) {
            case "fulfilled":
              return thenable.value;
            case "rejected":
              throw (
                ((thenableState = thenable.reason),
                checkIfUseWrappedInAsyncCatch(thenableState),
                thenableState)
              );
          }
          suspendedThenable = thenable;
          needsToResetSuspendedThenableDEV = !0;
          throw SuspenseException;
      }
    }
    function getSuspendedThenable() {
      if (null === suspendedThenable)
        throw Error(
          "Expected a suspended thenable. This is a bug in React. Please file an issue."
        );
      var thenable = suspendedThenable;
      suspendedThenable = null;
      needsToResetSuspendedThenableDEV = !1;
      return thenable;
    }
    function checkIfUseWrappedInAsyncCatch(rejectedReason) {
      if (
        rejectedReason === SuspenseException ||
        rejectedReason === SuspenseActionException
      )
        throw Error(
          "Hooks are not supported inside an async component. This error is often caused by accidentally adding `'use client'` to a module that was originally written for the server."
        );
    }
    function pushDebugInfo(debugInfo) {
      var previousDebugInfo = currentDebugInfo;
      null != debugInfo &&
        (currentDebugInfo =
          null === previousDebugInfo
            ? debugInfo
            : previousDebugInfo.concat(debugInfo));
      return previousDebugInfo;
    }
    function validateFragmentProps(element, fiber, returnFiber) {
      for (var keys = Object.keys(element.props), i = 0; i < keys.length; i++) {
        var key = keys[i];
        if ("children" !== key && "key" !== key && "ref" !== key) {
          null === fiber &&
            ((fiber = createFiberFromElement(element, returnFiber.mode, 0)),
            (fiber._debugInfo = currentDebugInfo),
            (fiber.return = returnFiber));
          runWithFiberInDEV(
            fiber,
            function (erroredKey) {
              console.error(
                "Invalid prop `%s` supplied to `React.Fragment`. React.Fragment can only have `key`, `ref`, and `children` props.",
                erroredKey
              );
            },
            key
          );
          break;
        }
      }
    }
    function unwrapThenable(thenable) {
      var index = thenableIndexCounter$1;
      thenableIndexCounter$1 += 1;
      null === thenableState$1 && (thenableState$1 = createThenableState());
      return trackUsedThenable(thenableState$1, thenable, index);
    }
    function coerceRef(workInProgress, element) {
      element = element.props.ref;
      workInProgress.ref = void 0 !== element ? element : null;
    }
    function throwOnInvalidObjectType(returnFiber, newChild) {
      if (newChild.$$typeof === REACT_LEGACY_ELEMENT_TYPE)
        throw Error(
          'A React Element from an older version of React was rendered. This is not supported. It can happen if:\n- Multiple copies of the "react" package is used.\n- A library pre-bundled an old copy of "react" or "react/jsx-runtime".\n- A compiler tries to "inline" JSX instead of using the runtime.'
        );
      returnFiber = Object.prototype.toString.call(newChild);
      throw Error(
        "Objects are not valid as a React child (found: " +
          ("[object Object]" === returnFiber
            ? "object with keys {" + Object.keys(newChild).join(", ") + "}"
            : returnFiber) +
          "). If you meant to render a collection of children, use an array instead."
      );
    }
    function warnOnFunctionType(returnFiber, invalidChild) {
      var parentName = getComponentNameFromFiber(returnFiber) || "Component";
      ownerHasFunctionTypeWarning[parentName] ||
        ((ownerHasFunctionTypeWarning[parentName] = !0),
        (invalidChild =
          invalidChild.displayName || invalidChild.name || "Component"),
        3 === returnFiber.tag
          ? console.error(
              "Functions are not valid as a React child. This may happen if you return %s instead of <%s /> from render. Or maybe you meant to call this function rather than return it.\n  root.render(%s)",
              invalidChild,
              invalidChild,
              invalidChild
            )
          : console.error(
              "Functions are not valid as a React child. This may happen if you return %s instead of <%s /> from render. Or maybe you meant to call this function rather than return it.\n  <%s>{%s}</%s>",
              invalidChild,
              invalidChild,
              parentName,
              invalidChild,
              parentName
            ));
    }
    function warnOnSymbolType(returnFiber, invalidChild) {
      var parentName = getComponentNameFromFiber(returnFiber) || "Component";
      ownerHasSymbolTypeWarning[parentName] ||
        ((ownerHasSymbolTypeWarning[parentName] = !0),
        (invalidChild = String(invalidChild)),
        3 === returnFiber.tag
          ? console.error(
              "Symbols are not valid as a React child.\n  root.render(%s)",
              invalidChild
            )
          : console.error(
              "Symbols are not valid as a React child.\n  <%s>%s</%s>",
              parentName,
              invalidChild,
              parentName
            ));
    }
    function createChildReconciler(shouldTrackSideEffects) {
      function deleteChild(returnFiber, childToDelete) {
        if (shouldTrackSideEffects) {
          var deletions = returnFiber.deletions;
          null === deletions
            ? ((returnFiber.deletions = [childToDelete]),
              (returnFiber.flags |= 16))
            : deletions.push(childToDelete);
        }
      }
      function deleteRemainingChildren(returnFiber, currentFirstChild) {
        if (!shouldTrackSideEffects) return null;
        for (; null !== currentFirstChild; )
          deleteChild(returnFiber, currentFirstChild),
            (currentFirstChild = currentFirstChild.sibling);
        return null;
      }
      function mapRemainingChildren(currentFirstChild) {
        for (var existingChildren = new Map(); null !== currentFirstChild; )
          null !== currentFirstChild.key
            ? existingChildren.set(currentFirstChild.key, currentFirstChild)
            : existingChildren.set(currentFirstChild.index, currentFirstChild),
            (currentFirstChild = currentFirstChild.sibling);
        return existingChildren;
      }
      function useFiber(fiber, pendingProps) {
        fiber = createWorkInProgress(fiber, pendingProps);
        fiber.index = 0;
        fiber.sibling = null;
        return fiber;
      }
      function placeChild(newFiber, lastPlacedIndex, newIndex) {
        newFiber.index = newIndex;
        if (!shouldTrackSideEffects)
          return (newFiber.flags |= 1048576), lastPlacedIndex;
        newIndex = newFiber.alternate;
        if (null !== newIndex)
          return (
            (newIndex = newIndex.index),
            newIndex < lastPlacedIndex
              ? ((newFiber.flags |= 67108866), lastPlacedIndex)
              : newIndex
          );
        newFiber.flags |= 67108866;
        return lastPlacedIndex;
      }
      function placeSingleChild(newFiber) {
        shouldTrackSideEffects &&
          null === newFiber.alternate &&
          (newFiber.flags |= 67108866);
        return newFiber;
      }
      function updateTextNode(returnFiber, current, textContent, lanes) {
        if (null === current || 6 !== current.tag)
          return (
            (current = createFiberFromText(
              textContent,
              returnFiber.mode,
              lanes
            )),
            (current.return = returnFiber),
            (current._debugOwner = returnFiber),
            (current._debugTask = returnFiber._debugTask),
            (current._debugInfo = currentDebugInfo),
            current
          );
        current = useFiber(current, textContent);
        current.return = returnFiber;
        current._debugInfo = currentDebugInfo;
        return current;
      }
      function updateElement(returnFiber, current, element, lanes) {
        var elementType = element.type;
        if (elementType === REACT_FRAGMENT_TYPE)
          return (
            (current = updateFragment(
              returnFiber,
              current,
              element.props.children,
              lanes,
              element.key
            )),
            coerceRef(current, element),
            validateFragmentProps(element, current, returnFiber),
            current
          );
        if (
          null !== current &&
          (current.elementType === elementType ||
            isCompatibleFamilyForHotReloading(current, element) ||
            ("object" === typeof elementType &&
              null !== elementType &&
              elementType.$$typeof === REACT_LAZY_TYPE &&
              callLazyInitInDEV(elementType) === current.type))
        )
          return (
            (current = useFiber(current, element.props)),
            coerceRef(current, element),
            (current.return = returnFiber),
            (current._debugOwner = element._owner),
            (current._debugInfo = currentDebugInfo),
            current
          );
        current = createFiberFromElement(element, returnFiber.mode, lanes);
        coerceRef(current, element);
        current.return = returnFiber;
        current._debugInfo = currentDebugInfo;
        return current;
      }
      function updatePortal(returnFiber, current, portal, lanes) {
        if (
          null === current ||
          4 !== current.tag ||
          current.stateNode.containerInfo !== portal.containerInfo ||
          current.stateNode.implementation !== portal.implementation
        )
          return (
            (current = createFiberFromPortal(portal, returnFiber.mode, lanes)),
            (current.return = returnFiber),
            (current._debugInfo = currentDebugInfo),
            current
          );
        current = useFiber(current, portal.children || []);
        current.return = returnFiber;
        current._debugInfo = currentDebugInfo;
        return current;
      }
      function updateFragment(returnFiber, current, fragment, lanes, key) {
        if (null === current || 7 !== current.tag)
          return (
            (current = createFiberFromFragment(
              fragment,
              returnFiber.mode,
              lanes,
              key
            )),
            (current.return = returnFiber),
            (current._debugOwner = returnFiber),
            (current._debugTask = returnFiber._debugTask),
            (current._debugInfo = currentDebugInfo),
            current
          );
        current = useFiber(current, fragment);
        current.return = returnFiber;
        current._debugInfo = currentDebugInfo;
        return current;
      }
      function createChild(returnFiber, newChild, lanes) {
        if (
          ("string" === typeof newChild && "" !== newChild) ||
          "number" === typeof newChild ||
          "bigint" === typeof newChild
        )
          return (
            (newChild = createFiberFromText(
              "" + newChild,
              returnFiber.mode,
              lanes
            )),
            (newChild.return = returnFiber),
            (newChild._debugOwner = returnFiber),
            (newChild._debugTask = returnFiber._debugTask),
            (newChild._debugInfo = currentDebugInfo),
            newChild
          );
        if ("object" === typeof newChild && null !== newChild) {
          switch (newChild.$$typeof) {
            case REACT_ELEMENT_TYPE:
              return (
                (lanes = createFiberFromElement(
                  newChild,
                  returnFiber.mode,
                  lanes
                )),
                coerceRef(lanes, newChild),
                (lanes.return = returnFiber),
                (returnFiber = pushDebugInfo(newChild._debugInfo)),
                (lanes._debugInfo = currentDebugInfo),
                (currentDebugInfo = returnFiber),
                lanes
              );
            case REACT_PORTAL_TYPE:
              return (
                (newChild = createFiberFromPortal(
                  newChild,
                  returnFiber.mode,
                  lanes
                )),
                (newChild.return = returnFiber),
                (newChild._debugInfo = currentDebugInfo),
                newChild
              );
            case REACT_LAZY_TYPE:
              var _prevDebugInfo = pushDebugInfo(newChild._debugInfo);
              newChild = callLazyInitInDEV(newChild);
              returnFiber = createChild(returnFiber, newChild, lanes);
              currentDebugInfo = _prevDebugInfo;
              return returnFiber;
          }
          if (
            isArrayImpl(newChild) ||
            getIteratorFn(newChild) ||
            "function" === typeof newChild[ASYNC_ITERATOR]
          )
            return (
              (lanes = createFiberFromFragment(
                newChild,
                returnFiber.mode,
                lanes,
                null
              )),
              (lanes.return = returnFiber),
              (lanes._debugOwner = returnFiber),
              (lanes._debugTask = returnFiber._debugTask),
              (returnFiber = pushDebugInfo(newChild._debugInfo)),
              (lanes._debugInfo = currentDebugInfo),
              (currentDebugInfo = returnFiber),
              lanes
            );
          if ("function" === typeof newChild.then)
            return (
              (_prevDebugInfo = pushDebugInfo(newChild._debugInfo)),
              (returnFiber = createChild(
                returnFiber,
                unwrapThenable(newChild),
                lanes
              )),
              (currentDebugInfo = _prevDebugInfo),
              returnFiber
            );
          if (newChild.$$typeof === REACT_CONTEXT_TYPE)
            return createChild(
              returnFiber,
              readContextDuringReconciliation(returnFiber, newChild),
              lanes
            );
          throwOnInvalidObjectType(returnFiber, newChild);
        }
        "function" === typeof newChild &&
          warnOnFunctionType(returnFiber, newChild);
        "symbol" === typeof newChild && warnOnSymbolType(returnFiber, newChild);
        return null;
      }
      function updateSlot(returnFiber, oldFiber, newChild, lanes) {
        var key = null !== oldFiber ? oldFiber.key : null;
        if (
          ("string" === typeof newChild && "" !== newChild) ||
          "number" === typeof newChild ||
          "bigint" === typeof newChild
        )
          return null !== key
            ? null
            : updateTextNode(returnFiber, oldFiber, "" + newChild, lanes);
        if ("object" === typeof newChild && null !== newChild) {
          switch (newChild.$$typeof) {
            case REACT_ELEMENT_TYPE:
              return newChild.key === key
                ? ((key = pushDebugInfo(newChild._debugInfo)),
                  (returnFiber = updateElement(
                    returnFiber,
                    oldFiber,
                    newChild,
                    lanes
                  )),
                  (currentDebugInfo = key),
                  returnFiber)
                : null;
            case REACT_PORTAL_TYPE:
              return newChild.key === key
                ? updatePortal(returnFiber, oldFiber, newChild, lanes)
                : null;
            case REACT_LAZY_TYPE:
              return (
                (key = pushDebugInfo(newChild._debugInfo)),
                (newChild = callLazyInitInDEV(newChild)),
                (returnFiber = updateSlot(
                  returnFiber,
                  oldFiber,
                  newChild,
                  lanes
                )),
                (currentDebugInfo = key),
                returnFiber
              );
          }
          if (
            isArrayImpl(newChild) ||
            getIteratorFn(newChild) ||
            "function" === typeof newChild[ASYNC_ITERATOR]
          ) {
            if (null !== key) return null;
            key = pushDebugInfo(newChild._debugInfo);
            returnFiber = updateFragment(
              returnFiber,
              oldFiber,
              newChild,
              lanes,
              null
            );
            currentDebugInfo = key;
            return returnFiber;
          }
          if ("function" === typeof newChild.then)
            return (
              (key = pushDebugInfo(newChild._debugInfo)),
              (returnFiber = updateSlot(
                returnFiber,
                oldFiber,
                unwrapThenable(newChild),
                lanes
              )),
              (currentDebugInfo = key),
              returnFiber
            );
          if (newChild.$$typeof === REACT_CONTEXT_TYPE)
            return updateSlot(
              returnFiber,
              oldFiber,
              readContextDuringReconciliation(returnFiber, newChild),
              lanes
            );
          throwOnInvalidObjectType(returnFiber, newChild);
        }
        "function" === typeof newChild &&
          warnOnFunctionType(returnFiber, newChild);
        "symbol" === typeof newChild && warnOnSymbolType(returnFiber, newChild);
        return null;
      }
      function updateFromMap(
        existingChildren,
        returnFiber,
        newIdx,
        newChild,
        lanes
      ) {
        if (
          ("string" === typeof newChild && "" !== newChild) ||
          "number" === typeof newChild ||
          "bigint" === typeof newChild
        )
          return (
            (existingChildren = existingChildren.get(newIdx) || null),
            updateTextNode(returnFiber, existingChildren, "" + newChild, lanes)
          );
        if ("object" === typeof newChild && null !== newChild) {
          switch (newChild.$$typeof) {
            case REACT_ELEMENT_TYPE:
              return (
                (newIdx =
                  existingChildren.get(
                    null === newChild.key ? newIdx : newChild.key
                  ) || null),
                (existingChildren = pushDebugInfo(newChild._debugInfo)),
                (returnFiber = updateElement(
                  returnFiber,
                  newIdx,
                  newChild,
                  lanes
                )),
                (currentDebugInfo = existingChildren),
                returnFiber
              );
            case REACT_PORTAL_TYPE:
              return (
                (existingChildren =
                  existingChildren.get(
                    null === newChild.key ? newIdx : newChild.key
                  ) || null),
                updatePortal(returnFiber, existingChildren, newChild, lanes)
              );
            case REACT_LAZY_TYPE:
              var _prevDebugInfo7 = pushDebugInfo(newChild._debugInfo);
              newChild = callLazyInitInDEV(newChild);
              returnFiber = updateFromMap(
                existingChildren,
                returnFiber,
                newIdx,
                newChild,
                lanes
              );
              currentDebugInfo = _prevDebugInfo7;
              return returnFiber;
          }
          if (
            isArrayImpl(newChild) ||
            getIteratorFn(newChild) ||
            "function" === typeof newChild[ASYNC_ITERATOR]
          )
            return (
              (newIdx = existingChildren.get(newIdx) || null),
              (existingChildren = pushDebugInfo(newChild._debugInfo)),
              (returnFiber = updateFragment(
                returnFiber,
                newIdx,
                newChild,
                lanes,
                null
              )),
              (currentDebugInfo = existingChildren),
              returnFiber
            );
          if ("function" === typeof newChild.then)
            return (
              (_prevDebugInfo7 = pushDebugInfo(newChild._debugInfo)),
              (returnFiber = updateFromMap(
                existingChildren,
                returnFiber,
                newIdx,
                unwrapThenable(newChild),
                lanes
              )),
              (currentDebugInfo = _prevDebugInfo7),
              returnFiber
            );
          if (newChild.$$typeof === REACT_CONTEXT_TYPE)
            return updateFromMap(
              existingChildren,
              returnFiber,
              newIdx,
              readContextDuringReconciliation(returnFiber, newChild),
              lanes
            );
          throwOnInvalidObjectType(returnFiber, newChild);
        }
        "function" === typeof newChild &&
          warnOnFunctionType(returnFiber, newChild);
        "symbol" === typeof newChild && warnOnSymbolType(returnFiber, newChild);
        return null;
      }
      function warnOnInvalidKey(returnFiber, workInProgress, child, knownKeys) {
        if ("object" !== typeof child || null === child) return knownKeys;
        switch (child.$$typeof) {
          case REACT_ELEMENT_TYPE:
          case REACT_PORTAL_TYPE:
            warnForMissingKey(returnFiber, workInProgress, child);
            var key = child.key;
            if ("string" !== typeof key) break;
            if (null === knownKeys) {
              knownKeys = new Set();
              knownKeys.add(key);
              break;
            }
            if (!knownKeys.has(key)) {
              knownKeys.add(key);
              break;
            }
            runWithFiberInDEV(workInProgress, function () {
              console.error(
                "Encountered two children with the same key, `%s`. Keys should be unique so that components maintain their identity across updates. Non-unique keys may cause children to be duplicated and/or omitted \u2014 the behavior is unsupported and could change in a future version.",
                key
              );
            });
            break;
          case REACT_LAZY_TYPE:
            (child = callLazyInitInDEV(child)),
              warnOnInvalidKey(returnFiber, workInProgress, child, knownKeys);
        }
        return knownKeys;
      }
      function reconcileChildrenArray(
        returnFiber,
        currentFirstChild,
        newChildren,
        lanes
      ) {
        for (
          var knownKeys = null,
            resultingFirstChild = null,
            previousNewFiber = null,
            oldFiber = currentFirstChild,
            newIdx = (currentFirstChild = 0),
            nextOldFiber = null;
          null !== oldFiber && newIdx < newChildren.length;
          newIdx++
        ) {
          oldFiber.index > newIdx
            ? ((nextOldFiber = oldFiber), (oldFiber = null))
            : (nextOldFiber = oldFiber.sibling);
          var newFiber = updateSlot(
            returnFiber,
            oldFiber,
            newChildren[newIdx],
            lanes
          );
          if (null === newFiber) {
            null === oldFiber && (oldFiber = nextOldFiber);
            break;
          }
          knownKeys = warnOnInvalidKey(
            returnFiber,
            newFiber,
            newChildren[newIdx],
            knownKeys
          );
          shouldTrackSideEffects &&
            oldFiber &&
            null === newFiber.alternate &&
            deleteChild(returnFiber, oldFiber);
          currentFirstChild = placeChild(newFiber, currentFirstChild, newIdx);
          null === previousNewFiber
            ? (resultingFirstChild = newFiber)
            : (previousNewFiber.sibling = newFiber);
          previousNewFiber = newFiber;
          oldFiber = nextOldFiber;
        }
        if (newIdx === newChildren.length)
          return (
            deleteRemainingChildren(returnFiber, oldFiber),
            isHydrating && pushTreeFork(returnFiber, newIdx),
            resultingFirstChild
          );
        if (null === oldFiber) {
          for (; newIdx < newChildren.length; newIdx++)
            (oldFiber = createChild(returnFiber, newChildren[newIdx], lanes)),
              null !== oldFiber &&
                ((knownKeys = warnOnInvalidKey(
                  returnFiber,
                  oldFiber,
                  newChildren[newIdx],
                  knownKeys
                )),
                (currentFirstChild = placeChild(
                  oldFiber,
                  currentFirstChild,
                  newIdx
                )),
                null === previousNewFiber
                  ? (resultingFirstChild = oldFiber)
                  : (previousNewFiber.sibling = oldFiber),
                (previousNewFiber = oldFiber));
          isHydrating && pushTreeFork(returnFiber, newIdx);
          return resultingFirstChild;
        }
        for (
          oldFiber = mapRemainingChildren(oldFiber);
          newIdx < newChildren.length;
          newIdx++
        )
          (nextOldFiber = updateFromMap(
            oldFiber,
            returnFiber,
            newIdx,
            newChildren[newIdx],
            lanes
          )),
            null !== nextOldFiber &&
              ((knownKeys = warnOnInvalidKey(
                returnFiber,
                nextOldFiber,
                newChildren[newIdx],
                knownKeys
              )),
              shouldTrackSideEffects &&
                null !== nextOldFiber.alternate &&
                oldFiber.delete(
                  null === nextOldFiber.key ? newIdx : nextOldFiber.key
                ),
              (currentFirstChild = placeChild(
                nextOldFiber,
                currentFirstChild,
                newIdx
              )),
              null === previousNewFiber
                ? (resultingFirstChild = nextOldFiber)
                : (previousNewFiber.sibling = nextOldFiber),
              (previousNewFiber = nextOldFiber));
        shouldTrackSideEffects &&
          oldFiber.forEach(function (child) {
            return deleteChild(returnFiber, child);
          });
        isHydrating && pushTreeFork(returnFiber, newIdx);
        return resultingFirstChild;
      }
      function reconcileChildrenAsyncIteratable(
        returnFiber,
        currentFirstChild,
        newChildrenIterable,
        lanes
      ) {
        var newChildren = newChildrenIterable[ASYNC_ITERATOR]();
        newChildren !== newChildrenIterable ||
          (0 === returnFiber.tag &&
            "[object AsyncGeneratorFunction]" ===
              Object.prototype.toString.call(returnFiber.type) &&
            "[object AsyncGenerator]" ===
              Object.prototype.toString.call(newChildren)) ||
          (didWarnAboutGenerators ||
            console.error(
              "Using AsyncIterators as children is unsupported and will likely yield unexpected results because enumerating a generator mutates it. You can use an AsyncIterable that can iterate multiple times over the same items."
            ),
          (didWarnAboutGenerators = !0));
        if (null == newChildren)
          throw Error("An iterable object provided no iterator.");
        return reconcileChildrenIterator(
          returnFiber,
          currentFirstChild,
          {
            next: function () {
              return unwrapThenable(newChildren.next());
            }
          },
          lanes
        );
      }
      function reconcileChildrenIterator(
        returnFiber,
        currentFirstChild,
        newChildren,
        lanes
      ) {
        if (null == newChildren)
          throw Error("An iterable object provided no iterator.");
        for (
          var resultingFirstChild = null,
            previousNewFiber = null,
            oldFiber = currentFirstChild,
            newIdx = (currentFirstChild = 0),
            nextOldFiber = null,
            knownKeys = null,
            step = newChildren.next();
          null !== oldFiber && !step.done;
          newIdx++, step = newChildren.next()
        ) {
          oldFiber.index > newIdx
            ? ((nextOldFiber = oldFiber), (oldFiber = null))
            : (nextOldFiber = oldFiber.sibling);
          var newFiber = updateSlot(returnFiber, oldFiber, step.value, lanes);
          if (null === newFiber) {
            null === oldFiber && (oldFiber = nextOldFiber);
            break;
          }
          knownKeys = warnOnInvalidKey(
            returnFiber,
            newFiber,
            step.value,
            knownKeys
          );
          shouldTrackSideEffects &&
            oldFiber &&
            null === newFiber.alternate &&
            deleteChild(returnFiber, oldFiber);
          currentFirstChild = placeChild(newFiber, currentFirstChild, newIdx);
          null === previousNewFiber
            ? (resultingFirstChild = newFiber)
            : (previousNewFiber.sibling = newFiber);
          previousNewFiber = newFiber;
          oldFiber = nextOldFiber;
        }
        if (step.done)
          return (
            deleteRemainingChildren(returnFiber, oldFiber),
            isHydrating && pushTreeFork(returnFiber, newIdx),
            resultingFirstChild
          );
        if (null === oldFiber) {
          for (; !step.done; newIdx++, step = newChildren.next())
            (oldFiber = createChild(returnFiber, step.value, lanes)),
              null !== oldFiber &&
                ((knownKeys = warnOnInvalidKey(
                  returnFiber,
                  oldFiber,
                  step.value,
                  knownKeys
                )),
                (currentFirstChild = placeChild(
                  oldFiber,
                  currentFirstChild,
                  newIdx
                )),
                null === previousNewFiber
                  ? (resultingFirstChild = oldFiber)
                  : (previousNewFiber.sibling = oldFiber),
                (previousNewFiber = oldFiber));
          isHydrating && pushTreeFork(returnFiber, newIdx);
          return resultingFirstChild;
        }
        for (
          oldFiber = mapRemainingChildren(oldFiber);
          !step.done;
          newIdx++, step = newChildren.next()
        )
          (nextOldFiber = updateFromMap(
            oldFiber,
            returnFiber,
            newIdx,
            step.value,
            lanes
          )),
            null !== nextOldFiber &&
              ((knownKeys = warnOnInvalidKey(
                returnFiber,
                nextOldFiber,
                step.value,
                knownKeys
              )),
              shouldTrackSideEffects &&
                null !== nextOldFiber.alternate &&
                oldFiber.delete(
                  null === nextOldFiber.key ? newIdx : nextOldFiber.key
                ),
              (currentFirstChild = placeChild(
                nextOldFiber,
                currentFirstChild,
                newIdx
              )),
              null === previousNewFiber
                ? (resultingFirstChild = nextOldFiber)
                : (previousNewFiber.sibling = nextOldFiber),
              (previousNewFiber = nextOldFiber));
        shouldTrackSideEffects &&
          oldFiber.forEach(function (child) {
            return deleteChild(returnFiber, child);
          });
        isHydrating && pushTreeFork(returnFiber, newIdx);
        return resultingFirstChild;
      }
      function reconcileChildFibersImpl(
        returnFiber,
        currentFirstChild,
        newChild,
        lanes
      ) {
        "object" === typeof newChild &&
          null !== newChild &&
          newChild.type === REACT_FRAGMENT_TYPE &&
          null === newChild.key &&
          void 0 === newChild.props.ref &&
          (validateFragmentProps(newChild, null, returnFiber),
          (newChild = newChild.props.children));
        if ("object" === typeof newChild && null !== newChild) {
          switch (newChild.$$typeof) {
            case REACT_ELEMENT_TYPE:
              var prevDebugInfo = pushDebugInfo(newChild._debugInfo);
              a: {
                for (var key = newChild.key; null !== currentFirstChild; ) {
                  if (currentFirstChild.key === key) {
                    key = newChild.type;
                    if (key === REACT_FRAGMENT_TYPE) {
                      if (7 === currentFirstChild.tag) {
                        deleteRemainingChildren(
                          returnFiber,
                          currentFirstChild.sibling
                        );
                        lanes = useFiber(
                          currentFirstChild,
                          newChild.props.children
                        );
                        coerceRef(lanes, newChild);
                        lanes.return = returnFiber;
                        lanes._debugOwner = newChild._owner;
                        lanes._debugInfo = currentDebugInfo;
                        validateFragmentProps(newChild, lanes, returnFiber);
                        returnFiber = lanes;
                        break a;
                      }
                    } else if (
                      currentFirstChild.elementType === key ||
                      isCompatibleFamilyForHotReloading(
                        currentFirstChild,
                        newChild
                      ) ||
                      ("object" === typeof key &&
                        null !== key &&
                        key.$$typeof === REACT_LAZY_TYPE &&
                        callLazyInitInDEV(key) === currentFirstChild.type)
                    ) {
                      deleteRemainingChildren(
                        returnFiber,
                        currentFirstChild.sibling
                      );
                      lanes = useFiber(currentFirstChild, newChild.props);
                      coerceRef(lanes, newChild);
                      lanes.return = returnFiber;
                      lanes._debugOwner = newChild._owner;
                      lanes._debugInfo = currentDebugInfo;
                      returnFiber = lanes;
                      break a;
                    }
                    deleteRemainingChildren(returnFiber, currentFirstChild);
                    break;
                  } else deleteChild(returnFiber, currentFirstChild);
                  currentFirstChild = currentFirstChild.sibling;
                }
                newChild.type === REACT_FRAGMENT_TYPE
                  ? ((lanes = createFiberFromFragment(
                      newChild.props.children,
                      returnFiber.mode,
                      lanes,
                      newChild.key
                    )),
                    coerceRef(lanes, newChild),
                    (lanes.return = returnFiber),
                    (lanes._debugOwner = returnFiber),
                    (lanes._debugTask = returnFiber._debugTask),
                    (lanes._debugInfo = currentDebugInfo),
                    validateFragmentProps(newChild, lanes, returnFiber),
                    (returnFiber = lanes))
                  : ((lanes = createFiberFromElement(
                      newChild,
                      returnFiber.mode,
                      lanes
                    )),
                    coerceRef(lanes, newChild),
                    (lanes.return = returnFiber),
                    (lanes._debugInfo = currentDebugInfo),
                    (returnFiber = lanes));
              }
              returnFiber = placeSingleChild(returnFiber);
              currentDebugInfo = prevDebugInfo;
              return returnFiber;
            case REACT_PORTAL_TYPE:
              a: {
                prevDebugInfo = newChild;
                for (
                  newChild = prevDebugInfo.key;
                  null !== currentFirstChild;

                ) {
                  if (currentFirstChild.key === newChild)
                    if (
                      4 === currentFirstChild.tag &&
                      currentFirstChild.stateNode.containerInfo ===
                        prevDebugInfo.containerInfo &&
                      currentFirstChild.stateNode.implementation ===
                        prevDebugInfo.implementation
                    ) {
                      deleteRemainingChildren(
                        returnFiber,
                        currentFirstChild.sibling
                      );
                      lanes = useFiber(
                        currentFirstChild,
                        prevDebugInfo.children || []
                      );
                      lanes.return = returnFiber;
                      returnFiber = lanes;
                      break a;
                    } else {
                      deleteRemainingChildren(returnFiber, currentFirstChild);
                      break;
                    }
                  else deleteChild(returnFiber, currentFirstChild);
                  currentFirstChild = currentFirstChild.sibling;
                }
                lanes = createFiberFromPortal(
                  prevDebugInfo,
                  returnFiber.mode,
                  lanes
                );
                lanes.return = returnFiber;
                returnFiber = lanes;
              }
              return placeSingleChild(returnFiber);
            case REACT_LAZY_TYPE:
              return (
                (prevDebugInfo = pushDebugInfo(newChild._debugInfo)),
                (newChild = callLazyInitInDEV(newChild)),
                (returnFiber = reconcileChildFibersImpl(
                  returnFiber,
                  currentFirstChild,
                  newChild,
                  lanes
                )),
                (currentDebugInfo = prevDebugInfo),
                returnFiber
              );
          }
          if (isArrayImpl(newChild))
            return (
              (prevDebugInfo = pushDebugInfo(newChild._debugInfo)),
              (returnFiber = reconcileChildrenArray(
                returnFiber,
                currentFirstChild,
                newChild,
                lanes
              )),
              (currentDebugInfo = prevDebugInfo),
              returnFiber
            );
          if (getIteratorFn(newChild)) {
            prevDebugInfo = pushDebugInfo(newChild._debugInfo);
            key = getIteratorFn(newChild);
            if ("function" !== typeof key)
              throw Error(
                "An object is not an iterable. This error is likely caused by a bug in React. Please file an issue."
              );
            var newChildren = key.call(newChild);
            if (newChildren === newChild) {
              if (
                0 !== returnFiber.tag ||
                "[object GeneratorFunction]" !==
                  Object.prototype.toString.call(returnFiber.type) ||
                "[object Generator]" !==
                  Object.prototype.toString.call(newChildren)
              )
                didWarnAboutGenerators ||
                  console.error(
                    "Using Iterators as children is unsupported and will likely yield unexpected results because enumerating a generator mutates it. You may convert it to an array with `Array.from()` or the `[...spread]` operator before rendering. You can also use an Iterable that can iterate multiple times over the same items."
                  ),
                  (didWarnAboutGenerators = !0);
            } else
              newChild.entries !== key ||
                didWarnAboutMaps ||
                (console.error(
                  "Using Maps as children is not supported. Use an array of keyed ReactElements instead."
                ),
                (didWarnAboutMaps = !0));
            returnFiber = reconcileChildrenIterator(
              returnFiber,
              currentFirstChild,
              newChildren,
              lanes
            );
            currentDebugInfo = prevDebugInfo;
            return returnFiber;
          }
          if ("function" === typeof newChild[ASYNC_ITERATOR])
            return (
              (prevDebugInfo = pushDebugInfo(newChild._debugInfo)),
              (returnFiber = reconcileChildrenAsyncIteratable(
                returnFiber,
                currentFirstChild,
                newChild,
                lanes
              )),
              (currentDebugInfo = prevDebugInfo),
              returnFiber
            );
          if ("function" === typeof newChild.then)
            return (
              (prevDebugInfo = pushDebugInfo(newChild._debugInfo)),
              (returnFiber = reconcileChildFibersImpl(
                returnFiber,
                currentFirstChild,
                unwrapThenable(newChild),
                lanes
              )),
              (currentDebugInfo = prevDebugInfo),
              returnFiber
            );
          if (newChild.$$typeof === REACT_CONTEXT_TYPE)
            return reconcileChildFibersImpl(
              returnFiber,
              currentFirstChild,
              readContextDuringReconciliation(returnFiber, newChild),
              lanes
            );
          throwOnInvalidObjectType(returnFiber, newChild);
        }
        if (
          ("string" === typeof newChild && "" !== newChild) ||
          "number" === typeof newChild ||
          "bigint" === typeof newChild
        )
          return (
            (prevDebugInfo = "" + newChild),
            null !== currentFirstChild && 6 === currentFirstChild.tag
              ? (deleteRemainingChildren(
                  returnFiber,
                  currentFirstChild.sibling
                ),
                (lanes = useFiber(currentFirstChild, prevDebugInfo)),
                (lanes.return = returnFiber),
                (returnFiber = lanes))
              : (deleteRemainingChildren(returnFiber, currentFirstChild),
                (lanes = createFiberFromText(
                  prevDebugInfo,
                  returnFiber.mode,
                  lanes
                )),
                (lanes.return = returnFiber),
                (lanes._debugOwner = returnFiber),
                (lanes._debugTask = returnFiber._debugTask),
                (lanes._debugInfo = currentDebugInfo),
                (returnFiber = lanes)),
            placeSingleChild(returnFiber)
          );
        "function" === typeof newChild &&
          warnOnFunctionType(returnFiber, newChild);
        "symbol" === typeof newChild && warnOnSymbolType(returnFiber, newChild);
        return deleteRemainingChildren(returnFiber, currentFirstChild);
      }
      return function (returnFiber, currentFirstChild, newChild, lanes) {
        var prevDebugInfo = currentDebugInfo;
        currentDebugInfo = null;
        try {
          thenableIndexCounter$1 = 0;
          var firstChildFiber = reconcileChildFibersImpl(
            returnFiber,
            currentFirstChild,
            newChild,
            lanes
          );
          thenableState$1 = null;
          return firstChildFiber;
        } catch (x) {
          if (x === SuspenseException || x === SuspenseActionException) throw x;
          var fiber = createFiber(29, x, null, returnFiber.mode);
          fiber.lanes = lanes;
          fiber.return = returnFiber;
          var debugInfo = (fiber._debugInfo = currentDebugInfo);
          fiber._debugOwner = returnFiber._debugOwner;
          fiber._debugTask = returnFiber._debugTask;
          if (null != debugInfo)
            for (var i = debugInfo.length - 1; 0 <= i; i--)
              if ("string" === typeof debugInfo[i].stack) {
                fiber._debugOwner = debugInfo[i];
                fiber._debugTask = debugInfo[i].debugTask;
                break;
              }
          return fiber;
        } finally {
          currentDebugInfo = prevDebugInfo;
        }
      };
    }
    function validateSuspenseListNestedChild(childSlot, index) {
      var isAnArray = isArrayImpl(childSlot),
        isIterable =
          !isAnArray && "function" === typeof getIteratorFn(childSlot);
      childSlot =
        "object" === typeof childSlot &&
        null !== childSlot &&
        "function" === typeof childSlot[ASYNC_ITERATOR];
      return isAnArray || isIterable || childSlot
        ? ((isAnArray = isAnArray
            ? "array"
            : childSlot
              ? "async iterable"
              : "iterable"),
          console.error(
            "A nested %s was passed to row #%s in <SuspenseList />. Wrap it in an additional SuspenseList to configure its revealOrder: <SuspenseList revealOrder=...> ... <SuspenseList revealOrder=...>{%s}</SuspenseList> ... </SuspenseList>",
            isAnArray,
            index,
            isAnArray
          ),
          !1)
        : !0;
    }
    function initializeUpdateQueue(fiber) {
      fiber.updateQueue = {
        baseState: fiber.memoizedState,
        firstBaseUpdate: null,
        lastBaseUpdate: null,
        shared: { pending: null, lanes: 0, hiddenCallbacks: null },
        callbacks: null
      };
    }
    function cloneUpdateQueue(current, workInProgress) {
      current = current.updateQueue;
      workInProgress.updateQueue === current &&
        (workInProgress.updateQueue = {
          baseState: current.baseState,
          firstBaseUpdate: current.firstBaseUpdate,
          lastBaseUpdate: current.lastBaseUpdate,
          shared: current.shared,
          callbacks: null
        });
    }
    function createUpdate(lane) {
      return {
        lane: lane,
        tag: UpdateState,
        payload: null,
        callback: null,
        next: null
      };
    }
    function enqueueUpdate(fiber, update, lane) {
      var updateQueue = fiber.updateQueue;
      if (null === updateQueue) return null;
      updateQueue = updateQueue.shared;
      if (
        currentlyProcessingQueue === updateQueue &&
        !didWarnUpdateInsideUpdate
      ) {
        var componentName = getComponentNameFromFiber(fiber);
        console.error(
          "An update (setState, replaceState, or forceUpdate) was scheduled from inside an update function. Update functions should be pure, with zero side-effects. Consider using componentDidUpdate or a callback.\n\nPlease update the following component: %s",
          componentName
        );
        didWarnUpdateInsideUpdate = !0;
      }
      if ((executionContext & RenderContext) !== NoContext)
        return (
          (componentName = updateQueue.pending),
          null === componentName
            ? (update.next = update)
            : ((update.next = componentName.next),
              (componentName.next = update)),
          (updateQueue.pending = update),
          (update = getRootForUpdatedFiber(fiber)),
          markUpdateLaneFromFiberToRoot(fiber, null, lane),
          update
        );
      enqueueUpdate$1(fiber, updateQueue, update, lane);
      return getRootForUpdatedFiber(fiber);
    }
    function entangleTransitions(root, fiber, lane) {
      fiber = fiber.updateQueue;
      if (null !== fiber && ((fiber = fiber.shared), 0 !== (lane & 4194048))) {
        var queueLanes = fiber.lanes;
        queueLanes &= root.pendingLanes;
        lane |= queueLanes;
        fiber.lanes = lane;
        markRootEntangled(root, lane);
      }
    }
    function enqueueCapturedUpdate(workInProgress, capturedUpdate) {
      var queue = workInProgress.updateQueue,
        current = workInProgress.alternate;
      if (
        null !== current &&
        ((current = current.updateQueue), queue === current)
      ) {
        var newFirst = null,
          newLast = null;
        queue = queue.firstBaseUpdate;
        if (null !== queue) {
          do {
            var clone = {
              lane: queue.lane,
              tag: queue.tag,
              payload: queue.payload,
              callback: null,
              next: null
            };
            null === newLast
              ? (newFirst = newLast = clone)
              : (newLast = newLast.next = clone);
            queue = queue.next;
          } while (null !== queue);
          null === newLast
            ? (newFirst = newLast = capturedUpdate)
            : (newLast = newLast.next = capturedUpdate);
        } else newFirst = newLast = capturedUpdate;
        queue = {
          baseState: current.baseState,
          firstBaseUpdate: newFirst,
          lastBaseUpdate: newLast,
          shared: current.shared,
          callbacks: current.callbacks
        };
        workInProgress.updateQueue = queue;
        return;
      }
      workInProgress = queue.lastBaseUpdate;
      null === workInProgress
        ? (queue.firstBaseUpdate = capturedUpdate)
        : (workInProgress.next = capturedUpdate);
      queue.lastBaseUpdate = capturedUpdate;
    }
    function suspendIfUpdateReadFromEntangledAsyncAction() {
      if (didReadFromEntangledAsyncAction) {
        var entangledActionThenable = currentEntangledActionThenable;
        if (null !== entangledActionThenable) throw entangledActionThenable;
      }
    }
    function processUpdateQueue(
      workInProgress,
      props,
      instance$jscomp$0,
      renderLanes
    ) {
      didReadFromEntangledAsyncAction = !1;
      var queue = workInProgress.updateQueue;
      hasForceUpdate = !1;
      currentlyProcessingQueue = queue.shared;
      var firstBaseUpdate = queue.firstBaseUpdate,
        lastBaseUpdate = queue.lastBaseUpdate,
        pendingQueue = queue.shared.pending;
      if (null !== pendingQueue) {
        queue.shared.pending = null;
        var lastPendingUpdate = pendingQueue,
          firstPendingUpdate = lastPendingUpdate.next;
        lastPendingUpdate.next = null;
        null === lastBaseUpdate
          ? (firstBaseUpdate = firstPendingUpdate)
          : (lastBaseUpdate.next = firstPendingUpdate);
        lastBaseUpdate = lastPendingUpdate;
        var current = workInProgress.alternate;
        null !== current &&
          ((current = current.updateQueue),
          (pendingQueue = current.lastBaseUpdate),
          pendingQueue !== lastBaseUpdate &&
            (null === pendingQueue
              ? (current.firstBaseUpdate = firstPendingUpdate)
              : (pendingQueue.next = firstPendingUpdate),
            (current.lastBaseUpdate = lastPendingUpdate)));
      }
      if (null !== firstBaseUpdate) {
        var newState = queue.baseState;
        lastBaseUpdate = 0;
        current = firstPendingUpdate = lastPendingUpdate = null;
        pendingQueue = firstBaseUpdate;
        do {
          var updateLane = pendingQueue.lane & -536870913,
            isHiddenUpdate = updateLane !== pendingQueue.lane;
          if (
            isHiddenUpdate
              ? (workInProgressRootRenderLanes & updateLane) === updateLane
              : (renderLanes & updateLane) === updateLane
          ) {
            0 !== updateLane &&
              updateLane === currentEntangledLane &&
              (didReadFromEntangledAsyncAction = !0);
            null !== current &&
              (current = current.next =
                {
                  lane: 0,
                  tag: pendingQueue.tag,
                  payload: pendingQueue.payload,
                  callback: null,
                  next: null
                });
            a: {
              updateLane = workInProgress;
              var partialState = pendingQueue;
              var nextProps = props,
                instance = instance$jscomp$0;
              switch (partialState.tag) {
                case ReplaceState:
                  partialState = partialState.payload;
                  if ("function" === typeof partialState) {
                    isDisallowedContextReadInDEV = !0;
                    var nextState = partialState.call(
                      instance,
                      newState,
                      nextProps
                    );
                    if (updateLane.mode & StrictLegacyMode) {
                      setIsStrictModeForDevtools(!0);
                      try {
                        partialState.call(instance, newState, nextProps);
                      } finally {
                        setIsStrictModeForDevtools(!1);
                      }
                    }
                    isDisallowedContextReadInDEV = !1;
                    newState = nextState;
                    break a;
                  }
                  newState = partialState;
                  break a;
                case CaptureUpdate:
                  updateLane.flags = (updateLane.flags & -65537) | 128;
                case UpdateState:
                  nextState = partialState.payload;
                  if ("function" === typeof nextState) {
                    isDisallowedContextReadInDEV = !0;
                    partialState = nextState.call(
                      instance,
                      newState,
                      nextProps
                    );
                    if (updateLane.mode & StrictLegacyMode) {
                      setIsStrictModeForDevtools(!0);
                      try {
                        nextState.call(instance, newState, nextProps);
                      } finally {
                        setIsStrictModeForDevtools(!1);
                      }
                    }
                    isDisallowedContextReadInDEV = !1;
                  } else partialState = nextState;
                  if (null === partialState || void 0 === partialState) break a;
                  newState = assign({}, newState, partialState);
                  break a;
                case ForceUpdate:
                  hasForceUpdate = !0;
              }
            }
            updateLane = pendingQueue.callback;
            null !== updateLane &&
              ((workInProgress.flags |= 64),
              isHiddenUpdate && (workInProgress.flags |= 8192),
              (isHiddenUpdate = queue.callbacks),
              null === isHiddenUpdate
                ? (queue.callbacks = [updateLane])
                : isHiddenUpdate.push(updateLane));
          } else
            (isHiddenUpdate = {
              lane: updateLane,
              tag: pendingQueue.tag,
              payload: pendingQueue.payload,
              callback: pendingQueue.callback,
              next: null
            }),
              null === current
                ? ((firstPendingUpdate = current = isHiddenUpdate),
                  (lastPendingUpdate = newState))
                : (current = current.next = isHiddenUpdate),
              (lastBaseUpdate |= updateLane);
          pendingQueue = pendingQueue.next;
          if (null === pendingQueue)
            if (((pendingQueue = queue.shared.pending), null === pendingQueue))
              break;
            else
              (isHiddenUpdate = pendingQueue),
                (pendingQueue = isHiddenUpdate.next),
                (isHiddenUpdate.next = null),
                (queue.lastBaseUpdate = isHiddenUpdate),
                (queue.shared.pending = null);
        } while (1);
        null === current && (lastPendingUpdate = newState);
        queue.baseState = lastPendingUpdate;
        queue.firstBaseUpdate = firstPendingUpdate;
        queue.lastBaseUpdate = current;
        null === firstBaseUpdate && (queue.shared.lanes = 0);
        workInProgressRootSkippedLanes |= lastBaseUpdate;
        workInProgress.lanes = lastBaseUpdate;
        workInProgress.memoizedState = newState;
      }
      currentlyProcessingQueue = null;
    }
    function callCallback(callback, context) {
      if ("function" !== typeof callback)
        throw Error(
          "Invalid argument passed as callback. Expected a function. Instead received: " +
            callback
        );
      callback.call(context);
    }
    function commitHiddenCallbacks(updateQueue, context) {
      var hiddenCallbacks = updateQueue.shared.hiddenCallbacks;
      if (null !== hiddenCallbacks)
        for (
          updateQueue.shared.hiddenCallbacks = null, updateQueue = 0;
          updateQueue < hiddenCallbacks.length;
          updateQueue++
        )
          callCallback(hiddenCallbacks[updateQueue], context);
    }
    function commitCallbacks(updateQueue, context) {
      var callbacks = updateQueue.callbacks;
      if (null !== callbacks)
        for (
          updateQueue.callbacks = null, updateQueue = 0;
          updateQueue < callbacks.length;
          updateQueue++
        )
          callCallback(callbacks[updateQueue], context);
    }
    function pushHiddenContext(fiber, context) {
      var prevEntangledRenderLanes = entangledRenderLanes;
      push(prevEntangledRenderLanesCursor, prevEntangledRenderLanes, fiber);
      push(currentTreeHiddenStackCursor, context, fiber);
      entangledRenderLanes = prevEntangledRenderLanes | context.baseLanes;
    }
    function reuseHiddenContextOnStack(fiber) {
      push(prevEntangledRenderLanesCursor, entangledRenderLanes, fiber);
      push(
        currentTreeHiddenStackCursor,
        currentTreeHiddenStackCursor.current,
        fiber
      );
    }
    function popHiddenContext(fiber) {
      entangledRenderLanes = prevEntangledRenderLanesCursor.current;
      pop(currentTreeHiddenStackCursor, fiber);
      pop(prevEntangledRenderLanesCursor, fiber);
    }
    function pushPrimaryTreeSuspenseHandler(handler) {
      var current = handler.alternate;
      push(
        suspenseStackCursor,
        suspenseStackCursor.current & SubtreeSuspenseContextMask,
        handler
      );
      push(suspenseHandlerStackCursor, handler, handler);
      null === shellBoundary &&
        (null === current || null !== currentTreeHiddenStackCursor.current
          ? (shellBoundary = handler)
          : null !== current.memoizedState && (shellBoundary = handler));
    }
    function pushDehydratedActivitySuspenseHandler(fiber) {
      push(suspenseStackCursor, suspenseStackCursor.current, fiber);
      push(suspenseHandlerStackCursor, fiber, fiber);
      null === shellBoundary && (shellBoundary = fiber);
    }
    function pushOffscreenSuspenseHandler(fiber) {
      22 === fiber.tag
        ? (push(suspenseStackCursor, suspenseStackCursor.current, fiber),
          push(suspenseHandlerStackCursor, fiber, fiber),
          null === shellBoundary && (shellBoundary = fiber))
        : reuseSuspenseHandlerOnStack(fiber);
    }
    function reuseSuspenseHandlerOnStack(fiber) {
      push(suspenseStackCursor, suspenseStackCursor.current, fiber);
      push(
        suspenseHandlerStackCursor,
        suspenseHandlerStackCursor.current,
        fiber
      );
    }
    function popSuspenseHandler(fiber) {
      pop(suspenseHandlerStackCursor, fiber);
      shellBoundary === fiber && (shellBoundary = null);
      pop(suspenseStackCursor, fiber);
    }
    function findFirstSuspended(row) {
      for (var node = row; null !== node; ) {
        if (13 === node.tag) {
          var state = node.memoizedState;
          if (
            null !== state &&
            ((state = state.dehydrated),
            null === state ||
              isSuspenseInstancePending(state) ||
              isSuspenseInstanceFallback(state))
          )
            return node;
        } else if (
          19 === node.tag &&
          ("forwards" === node.memoizedProps.revealOrder ||
            "backwards" === node.memoizedProps.revealOrder ||
            "unstable_legacy-backwards" === node.memoizedProps.revealOrder ||
            "together" === node.memoizedProps.revealOrder)
        ) {
          if (0 !== (node.flags & 128)) return node;
        } else if (null !== node.child) {
          node.child.return = node;
          node = node.child;
          continue;
        }
        if (node === row) break;
        for (; null === node.sibling; ) {
          if (null === node.return || node.return === row) return null;
          node = node.return;
        }
        node.sibling.return = node.return;
        node = node.sibling;
      }
      return null;
    }
    function mountHookTypesDev() {
      var hookName = currentHookNameInDev;
      null === hookTypesDev
        ? (hookTypesDev = [hookName])
        : hookTypesDev.push(hookName);
    }
    function updateHookTypesDev() {
      var hookName = currentHookNameInDev;
      if (
        null !== hookTypesDev &&
        (hookTypesUpdateIndexDev++,
        hookTypesDev[hookTypesUpdateIndexDev] !== hookName)
      ) {
        var componentName = getComponentNameFromFiber(currentlyRenderingFiber);
        if (
          !didWarnAboutMismatchedHooksForComponent.has(componentName) &&
          (didWarnAboutMismatchedHooksForComponent.add(componentName),
          null !== hookTypesDev)
        ) {
          for (var table = "", i = 0; i <= hookTypesUpdateIndexDev; i++) {
            var oldHookName = hookTypesDev[i],
              newHookName =
                i === hookTypesUpdateIndexDev ? hookName : oldHookName;
            for (
              oldHookName = i + 1 + ". " + oldHookName;
              30 > oldHookName.length;

            )
              oldHookName += " ";
            oldHookName += newHookName + "\n";
            table += oldHookName;
          }
          console.error(
            "React has detected a change in the order of Hooks called by %s. This will lead to bugs and errors if not fixed. For more information, read the Rules of Hooks: https://react.dev/link/rules-of-hooks\n\n   Previous render            Next render\n   ------------------------------------------------------\n%s   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n",
            componentName,
            table
          );
        }
      }
    }
    function checkDepsAreArrayDev(deps) {
      void 0 === deps ||
        null === deps ||
        isArrayImpl(deps) ||
        console.error(
          "%s received a final argument that is not an array (instead, received `%s`). When specified, the final argument must be an array.",
          currentHookNameInDev,
          typeof deps
        );
    }
    function warnOnUseFormStateInDev() {
      var componentName = getComponentNameFromFiber(currentlyRenderingFiber);
      didWarnAboutUseFormState.has(componentName) ||
        (didWarnAboutUseFormState.add(componentName),
        console.error(
          "ReactDOM.useFormState has been renamed to React.useActionState. Please update %s to use React.useActionState.",
          componentName
        ));
    }
    function throwInvalidHookError() {
      throw Error(
        "Invalid hook call. Hooks can only be called inside of the body of a function component. This could happen for one of the following reasons:\n1. You might have mismatching versions of React and the renderer (such as React DOM)\n2. You might be breaking the Rules of Hooks\n3. You might have more than one copy of React in the same app\nSee https://react.dev/link/invalid-hook-call for tips about how to debug and fix this problem."
      );
    }
    function areHookInputsEqual(nextDeps, prevDeps) {
      if (ignorePreviousDependencies) return !1;
      if (null === prevDeps)
        return (
          console.error(
            "%s received a final argument during this render, but not during the previous render. Even though the final argument is optional, its type cannot change between renders.",
            currentHookNameInDev
          ),
          !1
        );
      nextDeps.length !== prevDeps.length &&
        console.error(
          "The final argument passed to %s changed size between renders. The order and size of this array must remain constant.\n\nPrevious: %s\nIncoming: %s",
          currentHookNameInDev,
          "[" + prevDeps.join(", ") + "]",
          "[" + nextDeps.join(", ") + "]"
        );
      for (var i = 0; i < prevDeps.length && i < nextDeps.length; i++)
        if (!objectIs(nextDeps[i], prevDeps[i])) return !1;
      return !0;
    }
    function renderWithHooks(
      current,
      workInProgress,
      Component,
      props,
      secondArg,
      nextRenderLanes
    ) {
      renderLanes = nextRenderLanes;
      currentlyRenderingFiber = workInProgress;
      hookTypesDev = null !== current ? current._debugHookTypes : null;
      hookTypesUpdateIndexDev = -1;
      ignorePreviousDependencies =
        null !== current && current.type !== workInProgress.type;
      if (
        "[object AsyncFunction]" ===
          Object.prototype.toString.call(Component) ||
        "[object AsyncGeneratorFunction]" ===
          Object.prototype.toString.call(Component)
      )
        (nextRenderLanes = getComponentNameFromFiber(currentlyRenderingFiber)),
          didWarnAboutAsyncClientComponent.has(nextRenderLanes) ||
            (didWarnAboutAsyncClientComponent.add(nextRenderLanes),
            console.error(
              "%s is an async Client Component. Only Server Components can be async at the moment. This error is often caused by accidentally adding `'use client'` to a module that was originally written for the server.",
              null === nextRenderLanes
                ? "An unknown Component"
                : "<" + nextRenderLanes + ">"
            ));
      workInProgress.memoizedState = null;
      workInProgress.updateQueue = null;
      workInProgress.lanes = 0;
      ReactSharedInternals.H =
        null !== current && null !== current.memoizedState
          ? HooksDispatcherOnUpdateInDEV
          : null !== hookTypesDev
            ? HooksDispatcherOnMountWithHookTypesInDEV
            : HooksDispatcherOnMountInDEV;
      shouldDoubleInvokeUserFnsInHooksDEV = nextRenderLanes =
        (workInProgress.mode & StrictLegacyMode) !== NoMode;
      var children = callComponentInDEV(Component, props, secondArg);
      shouldDoubleInvokeUserFnsInHooksDEV = !1;
      didScheduleRenderPhaseUpdateDuringThisPass &&
        (children = renderWithHooksAgain(
          workInProgress,
          Component,
          props,
          secondArg
        ));
      if (nextRenderLanes) {
        setIsStrictModeForDevtools(!0);
        try {
          children = renderWithHooksAgain(
            workInProgress,
            Component,
            props,
            secondArg
          );
        } finally {
          setIsStrictModeForDevtools(!1);
        }
      }
      finishRenderingHooks(current, workInProgress);
      return children;
    }
    function finishRenderingHooks(current, workInProgress) {
      workInProgress._debugHookTypes = hookTypesDev;
      null === workInProgress.dependencies
        ? null !== thenableState &&
          (workInProgress.dependencies = {
            lanes: 0,
            firstContext: null,
            _debugThenableState: thenableState
          })
        : (workInProgress.dependencies._debugThenableState = thenableState);
      ReactSharedInternals.H = ContextOnlyDispatcher;
      var didRenderTooFewHooks =
        null !== currentHook && null !== currentHook.next;
      renderLanes = 0;
      hookTypesDev =
        currentHookNameInDev =
        workInProgressHook =
        currentHook =
        currentlyRenderingFiber =
          null;
      hookTypesUpdateIndexDev = -1;
      null !== current &&
        (current.flags & 65011712) !== (workInProgress.flags & 65011712) &&
        console.error(
          "Internal React error: Expected static flag was missing. Please notify the React team."
        );
      didScheduleRenderPhaseUpdate = !1;
      thenableIndexCounter = 0;
      thenableState = null;
      if (didRenderTooFewHooks)
        throw Error(
          "Rendered fewer hooks than expected. This may be caused by an accidental early return statement."
        );
      null === current ||
        didReceiveUpdate ||
        ((current = current.dependencies),
        null !== current &&
          checkIfContextChanged(current) &&
          (didReceiveUpdate = !0));
      needsToResetSuspendedThenableDEV
        ? ((needsToResetSuspendedThenableDEV = !1), (current = !0))
        : (current = !1);
      current &&
        ((workInProgress =
          getComponentNameFromFiber(workInProgress) || "Unknown"),
        didWarnAboutUseWrappedInTryCatch.has(workInProgress) ||
          didWarnAboutAsyncClientComponent.has(workInProgress) ||
          (didWarnAboutUseWrappedInTryCatch.add(workInProgress),
          console.error(
            "`use` was called from inside a try/catch block. This is not allowed and can lead to unexpected behavior. To handle errors triggered by `use`, wrap your component in a error boundary."
          )));
    }
    function renderWithHooksAgain(workInProgress, Component, props, secondArg) {
      currentlyRenderingFiber = workInProgress;
      var numberOfReRenders = 0;
      do {
        didScheduleRenderPhaseUpdateDuringThisPass && (thenableState = null);
        thenableIndexCounter = 0;
        didScheduleRenderPhaseUpdateDuringThisPass = !1;
        if (numberOfReRenders >= RE_RENDER_LIMIT)
          throw Error(
            "Too many re-renders. React limits the number of renders to prevent an infinite loop."
          );
        numberOfReRenders += 1;
        ignorePreviousDependencies = !1;
        workInProgressHook = currentHook = null;
        if (null != workInProgress.updateQueue) {
          var children = workInProgress.updateQueue;
          children.lastEffect = null;
          children.events = null;
          children.stores = null;
          null != children.memoCache && (children.memoCache.index = 0);
        }
        hookTypesUpdateIndexDev = -1;
        ReactSharedInternals.H = HooksDispatcherOnRerenderInDEV;
        children = callComponentInDEV(Component, props, secondArg);
      } while (didScheduleRenderPhaseUpdateDuringThisPass);
      return children;
    }
    function TransitionAwareHostComponent() {
      var dispatcher = ReactSharedInternals.H,
        maybeThenable = dispatcher.useState()[0];
      maybeThenable =
        "function" === typeof maybeThenable.then
          ? useThenable(maybeThenable)
          : maybeThenable;
      dispatcher = dispatcher.useState()[0];
      (null !== currentHook ? currentHook.memoizedState : null) !==
        dispatcher && (currentlyRenderingFiber.flags |= 1024);
      return maybeThenable;
    }
    function checkDidRenderIdHook() {
      var didRenderIdHook = 0 !== localIdCounter;
      localIdCounter = 0;
      return didRenderIdHook;
    }
    function bailoutHooks(current, workInProgress, lanes) {
      workInProgress.updateQueue = current.updateQueue;
      workInProgress.flags =
        (workInProgress.mode & StrictEffectsMode) !== NoMode
          ? workInProgress.flags & -402655237
          : workInProgress.flags & -2053;
      current.lanes &= ~lanes;
    }
    function resetHooksOnUnwind(workInProgress) {
      if (didScheduleRenderPhaseUpdate) {
        for (
          workInProgress = workInProgress.memoizedState;
          null !== workInProgress;

        ) {
          var queue = workInProgress.queue;
          null !== queue && (queue.pending = null);
          workInProgress = workInProgress.next;
        }
        didScheduleRenderPhaseUpdate = !1;
      }
      renderLanes = 0;
      hookTypesDev =
        workInProgressHook =
        currentHook =
        currentlyRenderingFiber =
          null;
      hookTypesUpdateIndexDev = -1;
      currentHookNameInDev = null;
      didScheduleRenderPhaseUpdateDuringThisPass = !1;
      thenableIndexCounter = localIdCounter = 0;
      thenableState = null;
    }
    function mountWorkInProgressHook() {
      var hook = {
        memoizedState: null,
        baseState: null,
        baseQueue: null,
        queue: null,
        next: null
      };
      null === workInProgressHook
        ? (currentlyRenderingFiber.memoizedState = workInProgressHook = hook)
        : (workInProgressHook = workInProgressHook.next = hook);
      return workInProgressHook;
    }
    function updateWorkInProgressHook() {
      if (null === currentHook) {
        var nextCurrentHook = currentlyRenderingFiber.alternate;
        nextCurrentHook =
          null !== nextCurrentHook ? nextCurrentHook.memoizedState : null;
      } else nextCurrentHook = currentHook.next;
      var nextWorkInProgressHook =
        null === workInProgressHook
          ? currentlyRenderingFiber.memoizedState
          : workInProgressHook.next;
      if (null !== nextWorkInProgressHook)
        (workInProgressHook = nextWorkInProgressHook),
          (currentHook = nextCurrentHook);
      else {
        if (null === nextCurrentHook) {
          if (null === currentlyRenderingFiber.alternate)
            throw Error(
              "Update hook called on initial render. This is likely a bug in React. Please file an issue."
            );
          throw Error("Rendered more hooks than during the previous render.");
        }
        currentHook = nextCurrentHook;
        nextCurrentHook = {
          memoizedState: currentHook.memoizedState,
          baseState: currentHook.baseState,
          baseQueue: currentHook.baseQueue,
          queue: currentHook.queue,
          next: null
        };
        null === workInProgressHook
          ? (currentlyRenderingFiber.memoizedState = workInProgressHook =
              nextCurrentHook)
          : (workInProgressHook = workInProgressHook.next = nextCurrentHook);
      }
      return workInProgressHook;
    }
    function createFunctionComponentUpdateQueue() {
      return { lastEffect: null, events: null, stores: null, memoCache: null };
    }
    function useThenable(thenable) {
      var index = thenableIndexCounter;
      thenableIndexCounter += 1;
      null === thenableState && (thenableState = createThenableState());
      thenable = trackUsedThenable(thenableState, thenable, index);
      index = currentlyRenderingFiber;
      null ===
        (null === workInProgressHook
          ? index.memoizedState
          : workInProgressHook.next) &&
        ((index = index.alternate),
        (ReactSharedInternals.H =
          null !== index && null !== index.memoizedState
            ? HooksDispatcherOnUpdateInDEV
            : HooksDispatcherOnMountInDEV));
      return thenable;
    }
    function use(usable) {
      if (null !== usable && "object" === typeof usable) {
        if ("function" === typeof usable.then) return useThenable(usable);
        if (usable.$$typeof === REACT_CONTEXT_TYPE) return readContext(usable);
      }
      throw Error("An unsupported type was passed to use(): " + String(usable));
    }
    function useMemoCache(size) {
      var memoCache = null,
        updateQueue = currentlyRenderingFiber.updateQueue;
      null !== updateQueue && (memoCache = updateQueue.memoCache);
      if (null == memoCache) {
        var current = currentlyRenderingFiber.alternate;
        null !== current &&
          ((current = current.updateQueue),
          null !== current &&
            ((current = current.memoCache),
            null != current &&
              (memoCache = {
                data: current.data.map(function (array) {
                  return array.slice();
                }),
                index: 0
              })));
      }
      null == memoCache && (memoCache = { data: [], index: 0 });
      null === updateQueue &&
        ((updateQueue = createFunctionComponentUpdateQueue()),
        (currentlyRenderingFiber.updateQueue = updateQueue));
      updateQueue.memoCache = memoCache;
      updateQueue = memoCache.data[memoCache.index];
      if (void 0 === updateQueue || ignorePreviousDependencies)
        for (
          updateQueue = memoCache.data[memoCache.index] = Array(size),
            current = 0;
          current < size;
          current++
        )
          updateQueue[current] = REACT_MEMO_CACHE_SENTINEL;
      else
        updateQueue.length !== size &&
          console.error(
            "Expected a constant size argument for each invocation of useMemoCache. The previous cache was allocated with size %s but size %s was requested.",
            updateQueue.length,
            size
          );
      memoCache.index++;
      return updateQueue;
    }
    function basicStateReducer(state, action) {
      return "function" === typeof action ? action(state) : action;
    }
    function mountReducer(reducer, initialArg, init) {
      var hook = mountWorkInProgressHook();
      if (void 0 !== init) {
        var initialState = init(initialArg);
        if (shouldDoubleInvokeUserFnsInHooksDEV) {
          setIsStrictModeForDevtools(!0);
          try {
            init(initialArg);
          } finally {
            setIsStrictModeForDevtools(!1);
          }
        }
      } else initialState = initialArg;
      hook.memoizedState = hook.baseState = initialState;
      reducer = {
        pending: null,
        lanes: 0,
        dispatch: null,
        lastRenderedReducer: reducer,
        lastRenderedState: initialState
      };
      hook.queue = reducer;
      reducer = reducer.dispatch = dispatchReducerAction.bind(
        null,
        currentlyRenderingFiber,
        reducer
      );
      return [hook.memoizedState, reducer];
    }
    function updateReducer(reducer) {
      var hook = updateWorkInProgressHook();
      return updateReducerImpl(hook, currentHook, reducer);
    }
    function updateReducerImpl(hook, current, reducer) {
      var queue = hook.queue;
      if (null === queue)
        throw Error(
          "Should have a queue. You are likely calling Hooks conditionally, which is not allowed. (https://react.dev/link/invalid-hook-call)"
        );
      queue.lastRenderedReducer = reducer;
      var baseQueue = hook.baseQueue,
        pendingQueue = queue.pending;
      if (null !== pendingQueue) {
        if (null !== baseQueue) {
          var baseFirst = baseQueue.next;
          baseQueue.next = pendingQueue.next;
          pendingQueue.next = baseFirst;
        }
        current.baseQueue !== baseQueue &&
          console.error(
            "Internal error: Expected work-in-progress queue to be a clone. This is a bug in React."
          );
        current.baseQueue = baseQueue = pendingQueue;
        queue.pending = null;
      }
      pendingQueue = hook.baseState;
      if (null === baseQueue) hook.memoizedState = pendingQueue;
      else {
        current = baseQueue.next;
        var newBaseQueueFirst = (baseFirst = null),
          newBaseQueueLast = null,
          update = current,
          didReadFromEntangledAsyncAction = !1;
        do {
          var updateLane = update.lane & -536870913,
            shouldSkipUpdate =
              updateLane !== update.lane
                ? (workInProgressRootRenderLanes & updateLane) !== updateLane
                : (renderLanes & updateLane) !== updateLane;
          if (64 === updateLane) {
            var scheduledGesture = update.gesture;
            if (null !== scheduledGesture)
              if (0 === scheduledGesture.count) {
                update = update.next;
                continue;
              } else if (64 !== renderLanes) shouldSkipUpdate = !0;
              else {
                shouldSkipUpdate = workInProgressRoot;
                if (null === shouldSkipUpdate)
                  throw Error(
                    "Expected a work-in-progress root. This is a bug in React. Please file an issue."
                  );
                shouldSkipUpdate =
                  shouldSkipUpdate.pendingGestures !== scheduledGesture;
              }
          }
          if (shouldSkipUpdate)
            (scheduledGesture = {
              lane: updateLane,
              revertLane: update.revertLane,
              gesture: update.gesture,
              action: update.action,
              hasEagerState: update.hasEagerState,
              eagerState: update.eagerState,
              next: null
            }),
              null === newBaseQueueLast
                ? ((newBaseQueueFirst = newBaseQueueLast = scheduledGesture),
                  (baseFirst = pendingQueue))
                : (newBaseQueueLast = newBaseQueueLast.next = scheduledGesture),
              (currentlyRenderingFiber.lanes |= updateLane),
              (workInProgressRootSkippedLanes |= updateLane);
          else {
            scheduledGesture = update.revertLane;
            if (0 === scheduledGesture)
              null !== newBaseQueueLast &&
                (newBaseQueueLast = newBaseQueueLast.next =
                  {
                    lane: 0,
                    revertLane: 0,
                    gesture: null,
                    action: update.action,
                    hasEagerState: update.hasEagerState,
                    eagerState: update.eagerState,
                    next: null
                  }),
                updateLane === currentEntangledLane &&
                  (didReadFromEntangledAsyncAction = !0);
            else if ((renderLanes & scheduledGesture) === scheduledGesture) {
              update = update.next;
              scheduledGesture === currentEntangledLane &&
                (didReadFromEntangledAsyncAction = !0);
              continue;
            } else
              (updateLane = {
                lane: 0,
                revertLane: update.revertLane,
                gesture: null,
                action: update.action,
                hasEagerState: update.hasEagerState,
                eagerState: update.eagerState,
                next: null
              }),
                null === newBaseQueueLast
                  ? ((newBaseQueueFirst = newBaseQueueLast = updateLane),
                    (baseFirst = pendingQueue))
                  : (newBaseQueueLast = newBaseQueueLast.next = updateLane),
                (currentlyRenderingFiber.lanes |= scheduledGesture),
                (workInProgressRootSkippedLanes |= scheduledGesture);
            updateLane = update.action;
            shouldDoubleInvokeUserFnsInHooksDEV &&
              reducer(pendingQueue, updateLane);
            pendingQueue = update.hasEagerState
              ? update.eagerState
              : reducer(pendingQueue, updateLane);
          }
          update = update.next;
        } while (null !== update && update !== current);
        null === newBaseQueueLast
          ? (baseFirst = pendingQueue)
          : (newBaseQueueLast.next = newBaseQueueFirst);
        if (
          !objectIs(pendingQueue, hook.memoizedState) &&
          ((didReceiveUpdate = !0),
          didReadFromEntangledAsyncAction &&
            ((reducer = currentEntangledActionThenable), null !== reducer))
        )
          throw reducer;
        hook.memoizedState = pendingQueue;
        hook.baseState = baseFirst;
        hook.baseQueue = newBaseQueueLast;
        queue.lastRenderedState = pendingQueue;
      }
      null === baseQueue && (queue.lanes = 0);
      return [hook.memoizedState, queue.dispatch];
    }
    function rerenderReducer(reducer) {
      var hook = updateWorkInProgressHook(),
        queue = hook.queue;
      if (null === queue)
        throw Error(
          "Should have a queue. You are likely calling Hooks conditionally, which is not allowed. (https://react.dev/link/invalid-hook-call)"
        );
      queue.lastRenderedReducer = reducer;
      var dispatch = queue.dispatch,
        lastRenderPhaseUpdate = queue.pending,
        newState = hook.memoizedState;
      if (null !== lastRenderPhaseUpdate) {
        queue.pending = null;
        var update = (lastRenderPhaseUpdate = lastRenderPhaseUpdate.next);
        do
          (newState = reducer(newState, update.action)), (update = update.next);
        while (update !== lastRenderPhaseUpdate);
        objectIs(newState, hook.memoizedState) || (didReceiveUpdate = !0);
        hook.memoizedState = newState;
        null === hook.baseQueue && (hook.baseState = newState);
        queue.lastRenderedState = newState;
      }
      return [newState, dispatch];
    }
    function mountSyncExternalStore(subscribe, getSnapshot, getServerSnapshot) {
      var fiber = currentlyRenderingFiber,
        hook = mountWorkInProgressHook();
      if (isHydrating) {
        if (void 0 === getServerSnapshot)
          throw Error(
            "Missing getServerSnapshot, which is required for server-rendered content. Will revert to client rendering."
          );
        var nextSnapshot = getServerSnapshot();
        didWarnUncachedGetSnapshot ||
          nextSnapshot === getServerSnapshot() ||
          (console.error(
            "The result of getServerSnapshot should be cached to avoid an infinite loop"
          ),
          (didWarnUncachedGetSnapshot = !0));
      } else {
        nextSnapshot = getSnapshot();
        didWarnUncachedGetSnapshot ||
          ((getServerSnapshot = getSnapshot()),
          objectIs(nextSnapshot, getServerSnapshot) ||
            (console.error(
              "The result of getSnapshot should be cached to avoid an infinite loop"
            ),
            (didWarnUncachedGetSnapshot = !0)));
        if (null === workInProgressRoot)
          throw Error(
            "Expected a work-in-progress root. This is a bug in React. Please file an issue."
          );
        0 !== (workInProgressRootRenderLanes & 124) ||
          pushStoreConsistencyCheck(fiber, getSnapshot, nextSnapshot);
      }
      hook.memoizedState = nextSnapshot;
      getServerSnapshot = { value: nextSnapshot, getSnapshot: getSnapshot };
      hook.queue = getServerSnapshot;
      mountEffect(
        subscribeToStore.bind(null, fiber, getServerSnapshot, subscribe),
        [subscribe]
      );
      fiber.flags |= 2048;
      pushSimpleEffect(
        HasEffect | Passive,
        { destroy: void 0 },
        updateStoreInstance.bind(
          null,
          fiber,
          getServerSnapshot,
          nextSnapshot,
          getSnapshot
        ),
        null
      );
      return nextSnapshot;
    }
    function updateSyncExternalStore(
      subscribe,
      getSnapshot,
      getServerSnapshot
    ) {
      var fiber = currentlyRenderingFiber,
        hook = updateWorkInProgressHook(),
        isHydrating$jscomp$0 = isHydrating;
      if (isHydrating$jscomp$0) {
        if (void 0 === getServerSnapshot)
          throw Error(
            "Missing getServerSnapshot, which is required for server-rendered content. Will revert to client rendering."
          );
        getServerSnapshot = getServerSnapshot();
      } else if (
        ((getServerSnapshot = getSnapshot()), !didWarnUncachedGetSnapshot)
      ) {
        var cachedSnapshot = getSnapshot();
        objectIs(getServerSnapshot, cachedSnapshot) ||
          (console.error(
            "The result of getSnapshot should be cached to avoid an infinite loop"
          ),
          (didWarnUncachedGetSnapshot = !0));
      }
      if (
        (cachedSnapshot = !objectIs(
          (currentHook || hook).memoizedState,
          getServerSnapshot
        ))
      )
        (hook.memoizedState = getServerSnapshot), (didReceiveUpdate = !0);
      hook = hook.queue;
      var create = subscribeToStore.bind(null, fiber, hook, subscribe);
      updateEffectImpl(2048, Passive, create, [subscribe]);
      if (
        hook.getSnapshot !== getSnapshot ||
        cachedSnapshot ||
        (null !== workInProgressHook &&
          workInProgressHook.memoizedState.tag & HasEffect)
      ) {
        fiber.flags |= 2048;
        pushSimpleEffect(
          HasEffect | Passive,
          { destroy: void 0 },
          updateStoreInstance.bind(
            null,
            fiber,
            hook,
            getServerSnapshot,
            getSnapshot
          ),
          null
        );
        if (null === workInProgressRoot)
          throw Error(
            "Expected a work-in-progress root. This is a bug in React. Please file an issue."
          );
        isHydrating$jscomp$0 ||
          0 !== (renderLanes & 124) ||
          pushStoreConsistencyCheck(fiber, getSnapshot, getServerSnapshot);
      }
      return getServerSnapshot;
    }
    function pushStoreConsistencyCheck(fiber, getSnapshot, renderedSnapshot) {
      fiber.flags |= 16384;
      fiber = { getSnapshot: getSnapshot, value: renderedSnapshot };
      getSnapshot = currentlyRenderingFiber.updateQueue;
      null === getSnapshot
        ? ((getSnapshot = createFunctionComponentUpdateQueue()),
          (currentlyRenderingFiber.updateQueue = getSnapshot),
          (getSnapshot.stores = [fiber]))
        : ((renderedSnapshot = getSnapshot.stores),
          null === renderedSnapshot
            ? (getSnapshot.stores = [fiber])
            : renderedSnapshot.push(fiber));
    }
    function updateStoreInstance(fiber, inst, nextSnapshot, getSnapshot) {
      inst.value = nextSnapshot;
      inst.getSnapshot = getSnapshot;
      checkIfSnapshotChanged(inst) && forceStoreRerender(fiber);
    }
    function subscribeToStore(fiber, inst, subscribe) {
      return subscribe(function () {
        checkIfSnapshotChanged(inst) &&
          (startUpdateTimerByLane(2, "updateSyncExternalStore()"),
          forceStoreRerender(fiber));
      });
    }
    function checkIfSnapshotChanged(inst) {
      var latestGetSnapshot = inst.getSnapshot;
      inst = inst.value;
      try {
        var nextValue = latestGetSnapshot();
        return !objectIs(inst, nextValue);
      } catch (error) {
        return !0;
      }
    }
    function forceStoreRerender(fiber) {
      var root = enqueueConcurrentRenderForLane(fiber, 2);
      null !== root && scheduleUpdateOnFiber(root, fiber, 2);
    }
    function mountStateImpl(initialState) {
      var hook = mountWorkInProgressHook();
      if ("function" === typeof initialState) {
        var initialStateInitializer = initialState;
        initialState = initialStateInitializer();
        if (shouldDoubleInvokeUserFnsInHooksDEV) {
          setIsStrictModeForDevtools(!0);
          try {
            initialStateInitializer();
          } finally {
            setIsStrictModeForDevtools(!1);
          }
        }
      }
      hook.memoizedState = hook.baseState = initialState;
      hook.queue = {
        pending: null,
        lanes: 0,
        dispatch: null,
        lastRenderedReducer: basicStateReducer,
        lastRenderedState: initialState
      };
      return hook;
    }
    function mountState(initialState) {
      initialState = mountStateImpl(initialState);
      var queue = initialState.queue,
        dispatch = dispatchSetState.bind(null, currentlyRenderingFiber, queue);
      queue.dispatch = dispatch;
      return [initialState.memoizedState, dispatch];
    }
    function mountOptimistic(passthrough) {
      var hook = mountWorkInProgressHook();
      hook.memoizedState = hook.baseState = passthrough;
      var queue = {
        pending: null,
        lanes: 0,
        dispatch: null,
        lastRenderedReducer: null,
        lastRenderedState: null
      };
      hook.queue = queue;
      hook = dispatchOptimisticSetState.bind(
        null,
        currentlyRenderingFiber,
        !0,
        queue
      );
      queue.dispatch = hook;
      return [passthrough, hook];
    }
    function updateOptimistic(passthrough, reducer) {
      var hook = updateWorkInProgressHook();
      return updateOptimisticImpl(hook, currentHook, passthrough, reducer);
    }
    function updateOptimisticImpl(hook, current, passthrough, reducer) {
      hook.baseState = passthrough;
      return updateReducerImpl(
        hook,
        currentHook,
        "function" === typeof reducer ? reducer : basicStateReducer
      );
    }
    function rerenderOptimistic(passthrough, reducer) {
      var hook = updateWorkInProgressHook();
      if (null !== currentHook)
        return updateOptimisticImpl(hook, currentHook, passthrough, reducer);
      hook.baseState = passthrough;
      return [passthrough, hook.queue.dispatch];
    }
    function dispatchActionState(
      fiber,
      actionQueue,
      setPendingState,
      setState,
      payload
    ) {
      if (isRenderPhaseUpdate(fiber))
        throw Error("Cannot update form state while rendering.");
      fiber = actionQueue.action;
      if (null !== fiber) {
        var actionNode = {
          payload: payload,
          action: fiber,
          next: null,
          isTransition: !0,
          status: "pending",
          value: null,
          reason: null,
          listeners: [],
          then: function (listener) {
            actionNode.listeners.push(listener);
          }
        };
        null !== ReactSharedInternals.T
          ? setPendingState(!0)
          : (actionNode.isTransition = !1);
        setState(actionNode);
        setPendingState = actionQueue.pending;
        null === setPendingState
          ? ((actionNode.next = actionQueue.pending = actionNode),
            runActionStateAction(actionQueue, actionNode))
          : ((actionNode.next = setPendingState.next),
            (actionQueue.pending = setPendingState.next = actionNode));
      }
    }
    function runActionStateAction(actionQueue, node) {
      var action = node.action,
        payload = node.payload,
        prevState = actionQueue.state;
      if (node.isTransition) {
        var prevTransition = ReactSharedInternals.T,
          currentTransition = {};
        currentTransition.types =
          null !== prevTransition ? prevTransition.types : null;
        currentTransition.gesture = null;
        currentTransition._updatedFibers = new Set();
        ReactSharedInternals.T = currentTransition;
        try {
          var returnValue = action(prevState, payload),
            onStartTransitionFinish = ReactSharedInternals.S;
          null !== onStartTransitionFinish &&
            onStartTransitionFinish(currentTransition, returnValue);
          handleActionReturnValue(actionQueue, node, returnValue);
        } catch (error) {
          onActionError(actionQueue, node, error);
        } finally {
          null !== prevTransition &&
            null !== currentTransition.types &&
            (null !== prevTransition.types &&
              prevTransition.types !== currentTransition.types &&
              console.error(
                "We expected inner Transitions to have transferred the outer types set and that you cannot add to the outer Transition while inside the inner.This is a bug in React."
              ),
            (prevTransition.types = currentTransition.types)),
            (ReactSharedInternals.T = prevTransition),
            null === prevTransition &&
              currentTransition._updatedFibers &&
              ((actionQueue = currentTransition._updatedFibers.size),
              currentTransition._updatedFibers.clear(),
              10 < actionQueue &&
                console.warn(
                  "Detected a large number of updates inside startTransition. If this is due to a subscription please re-write it to use React provided hooks. Otherwise concurrent mode guarantees are off the table."
                ));
        }
      } else
        try {
          (currentTransition = action(prevState, payload)),
            handleActionReturnValue(actionQueue, node, currentTransition);
        } catch (error$4) {
          onActionError(actionQueue, node, error$4);
        }
    }
    function handleActionReturnValue(actionQueue, node, returnValue) {
      null !== returnValue &&
      "object" === typeof returnValue &&
      "function" === typeof returnValue.then
        ? (ReactSharedInternals.asyncTransitions++,
          returnValue.then(releaseAsyncTransition, releaseAsyncTransition),
          returnValue.then(
            function (nextState) {
              onActionSuccess(actionQueue, node, nextState);
            },
            function (error) {
              return onActionError(actionQueue, node, error);
            }
          ),
          node.isTransition ||
            console.error(
              "An async function with useActionState was called outside of a transition. This is likely not what you intended (for example, isPending will not update correctly). Either call the returned function inside startTransition, or pass it to an `action` or `formAction` prop."
            ))
        : onActionSuccess(actionQueue, node, returnValue);
    }
    function onActionSuccess(actionQueue, actionNode, nextState) {
      actionNode.status = "fulfilled";
      actionNode.value = nextState;
      notifyActionListeners(actionNode);
      actionQueue.state = nextState;
      actionNode = actionQueue.pending;
      null !== actionNode &&
        ((nextState = actionNode.next),
        nextState === actionNode
          ? (actionQueue.pending = null)
          : ((nextState = nextState.next),
            (actionNode.next = nextState),
            runActionStateAction(actionQueue, nextState)));
    }
    function onActionError(actionQueue, actionNode, error) {
      var last = actionQueue.pending;
      actionQueue.pending = null;
      if (null !== last) {
        last = last.next;
        do
          (actionNode.status = "rejected"),
            (actionNode.reason = error),
            notifyActionListeners(actionNode),
            (actionNode = actionNode.next);
        while (actionNode !== last);
      }
      actionQueue.action = null;
    }
    function notifyActionListeners(actionNode) {
      actionNode = actionNode.listeners;
      for (var i = 0; i < actionNode.length; i++) (0, actionNode[i])();
    }
    function actionStateReducer(oldState, newState) {
      return newState;
    }
    function mountActionState(action, initialStateProp) {
      if (isHydrating) {
        var ssrFormState = workInProgressRoot.formState;
        if (null !== ssrFormState) {
          a: {
            var isMatching = currentlyRenderingFiber;
            if (isHydrating) {
              if (nextHydratableInstance) {
                b: {
                  var markerInstance = nextHydratableInstance;
                  for (
                    var inRootOrSingleton = rootOrSingletonContext;
                    8 !== markerInstance.nodeType;

                  ) {
                    if (!inRootOrSingleton) {
                      markerInstance = null;
                      break b;
                    }
                    markerInstance = getNextHydratable(
                      markerInstance.nextSibling
                    );
                    if (null === markerInstance) {
                      markerInstance = null;
                      break b;
                    }
                  }
                  inRootOrSingleton = markerInstance.data;
                  markerInstance =
                    inRootOrSingleton === FORM_STATE_IS_MATCHING ||
                    inRootOrSingleton === FORM_STATE_IS_NOT_MATCHING
                      ? markerInstance
                      : null;
                }
                if (markerInstance) {
                  nextHydratableInstance = getNextHydratable(
                    markerInstance.nextSibling
                  );
                  isMatching = markerInstance.data === FORM_STATE_IS_MATCHING;
                  break a;
                }
              }
              throwOnHydrationMismatch(isMatching);
            }
            isMatching = !1;
          }
          isMatching && (initialStateProp = ssrFormState[0]);
        }
      }
      ssrFormState = mountWorkInProgressHook();
      ssrFormState.memoizedState = ssrFormState.baseState = initialStateProp;
      isMatching = {
        pending: null,
        lanes: 0,
        dispatch: null,
        lastRenderedReducer: actionStateReducer,
        lastRenderedState: initialStateProp
      };
      ssrFormState.queue = isMatching;
      ssrFormState = dispatchSetState.bind(
        null,
        currentlyRenderingFiber,
        isMatching
      );
      isMatching.dispatch = ssrFormState;
      isMatching = mountStateImpl(!1);
      inRootOrSingleton = dispatchOptimisticSetState.bind(
        null,
        currentlyRenderingFiber,
        !1,
        isMatching.queue
      );
      isMatching = mountWorkInProgressHook();
      markerInstance = {
        state: initialStateProp,
        dispatch: null,
        action: action,
        pending: null
      };
      isMatching.queue = markerInstance;
      ssrFormState = dispatchActionState.bind(
        null,
        currentlyRenderingFiber,
        markerInstance,
        inRootOrSingleton,
        ssrFormState
      );
      markerInstance.dispatch = ssrFormState;
      isMatching.memoizedState = action;
      return [initialStateProp, ssrFormState, !1];
    }
    function updateActionState(action) {
      var stateHook = updateWorkInProgressHook();
      return updateActionStateImpl(stateHook, currentHook, action);
    }
    function updateActionStateImpl(stateHook, currentStateHook, action) {
      currentStateHook = updateReducerImpl(
        stateHook,
        currentStateHook,
        actionStateReducer
      )[0];
      stateHook = updateReducer(basicStateReducer)[0];
      if (
        "object" === typeof currentStateHook &&
        null !== currentStateHook &&
        "function" === typeof currentStateHook.then
      )
        try {
          var state = useThenable(currentStateHook);
        } catch (x) {
          if (x === SuspenseException) throw SuspenseActionException;
          throw x;
        }
      else state = currentStateHook;
      currentStateHook = updateWorkInProgressHook();
      var actionQueue = currentStateHook.queue,
        dispatch = actionQueue.dispatch;
      action !== currentStateHook.memoizedState &&
        ((currentlyRenderingFiber.flags |= 2048),
        pushSimpleEffect(
          HasEffect | Passive,
          { destroy: void 0 },
          actionStateActionEffect.bind(null, actionQueue, action),
          null
        ));
      return [state, dispatch, stateHook];
    }
    function actionStateActionEffect(actionQueue, action) {
      actionQueue.action = action;
    }
    function rerenderActionState(action) {
      var stateHook = updateWorkInProgressHook(),
        currentStateHook = currentHook;
      if (null !== currentStateHook)
        return updateActionStateImpl(stateHook, currentStateHook, action);
      updateWorkInProgressHook();
      stateHook = stateHook.memoizedState;
      currentStateHook = updateWorkInProgressHook();
      var dispatch = currentStateHook.queue.dispatch;
      currentStateHook.memoizedState = action;
      return [stateHook, dispatch, !1];
    }
    function pushSimpleEffect(tag, inst, create, deps) {
      tag = { tag: tag, create: create, deps: deps, inst: inst, next: null };
      inst = currentlyRenderingFiber.updateQueue;
      null === inst &&
        ((inst = createFunctionComponentUpdateQueue()),
        (currentlyRenderingFiber.updateQueue = inst));
      create = inst.lastEffect;
      null === create
        ? (inst.lastEffect = tag.next = tag)
        : ((deps = create.next),
          (create.next = tag),
          (tag.next = deps),
          (inst.lastEffect = tag));
      return tag;
    }
    function mountRef(initialValue) {
      var hook = mountWorkInProgressHook();
      initialValue = { current: initialValue };
      return (hook.memoizedState = initialValue);
    }
    function mountEffectImpl(fiberFlags, hookFlags, create, deps) {
      var hook = mountWorkInProgressHook();
      currentlyRenderingFiber.flags |= fiberFlags;
      hook.memoizedState = pushSimpleEffect(
        HasEffect | hookFlags,
        { destroy: void 0 },
        create,
        void 0 === deps ? null : deps
      );
    }
    function updateEffectImpl(fiberFlags, hookFlags, create, deps) {
      var hook = updateWorkInProgressHook();
      deps = void 0 === deps ? null : deps;
      var inst = hook.memoizedState.inst;
      null !== currentHook &&
      null !== deps &&
      areHookInputsEqual(deps, currentHook.memoizedState.deps)
        ? (hook.memoizedState = pushSimpleEffect(hookFlags, inst, create, deps))
        : ((currentlyRenderingFiber.flags |= fiberFlags),
          (hook.memoizedState = pushSimpleEffect(
            HasEffect | hookFlags,
            inst,
            create,
            deps
          )));
    }
    function mountEffect(create, deps) {
      (currentlyRenderingFiber.mode & StrictEffectsMode) !== NoMode
        ? mountEffectImpl(276826112, Passive, create, deps)
        : mountEffectImpl(8390656, Passive, create, deps);
    }
    function useEffectEventImpl(payload) {
      currentlyRenderingFiber.flags |= 4;
      var componentUpdateQueue = currentlyRenderingFiber.updateQueue;
      if (null === componentUpdateQueue)
        (componentUpdateQueue = createFunctionComponentUpdateQueue()),
          (currentlyRenderingFiber.updateQueue = componentUpdateQueue),
          (componentUpdateQueue.events = [payload]);
      else {
        var events = componentUpdateQueue.events;
        null === events
          ? (componentUpdateQueue.events = [payload])
          : events.push(payload);
      }
    }
    function mountEvent(callback) {
      var hook = mountWorkInProgressHook(),
        ref = { impl: callback };
      hook.memoizedState = ref;
      return function () {
        if ((executionContext & RenderContext) !== NoContext)
          throw Error(
            "A function wrapped in useEffectEvent can't be called during rendering."
          );
        return ref.impl.apply(void 0, arguments);
      };
    }
    function updateEvent(callback) {
      var ref = updateWorkInProgressHook().memoizedState;
      useEffectEventImpl({ ref: ref, nextImpl: callback });
      return function () {
        if ((executionContext & RenderContext) !== NoContext)
          throw Error(
            "A function wrapped in useEffectEvent can't be called during rendering."
          );
        return ref.impl.apply(void 0, arguments);
      };
    }
    function mountLayoutEffect(create, deps) {
      var fiberFlags = 4194308;
      (currentlyRenderingFiber.mode & StrictEffectsMode) !== NoMode &&
        (fiberFlags |= 134217728);
      return mountEffectImpl(fiberFlags, Layout, create, deps);
    }
    function imperativeHandleEffect(create, ref) {
      if ("function" === typeof ref) {
        create = create();
        var refCleanup = ref(create);
        return function () {
          "function" === typeof refCleanup ? refCleanup() : ref(null);
        };
      }
      if (null !== ref && void 0 !== ref)
        return (
          ref.hasOwnProperty("current") ||
            console.error(
              "Expected useImperativeHandle() first argument to either be a ref callback or React.createRef() object. Instead received: %s.",
              "an object with keys {" + Object.keys(ref).join(", ") + "}"
            ),
          (create = create()),
          (ref.current = create),
          function () {
            ref.current = null;
          }
        );
    }
    function mountImperativeHandle(ref, create, deps) {
      "function" !== typeof create &&
        console.error(
          "Expected useImperativeHandle() second argument to be a function that creates a handle. Instead received: %s.",
          null !== create ? typeof create : "null"
        );
      deps = null !== deps && void 0 !== deps ? deps.concat([ref]) : null;
      var fiberFlags = 4194308;
      (currentlyRenderingFiber.mode & StrictEffectsMode) !== NoMode &&
        (fiberFlags |= 134217728);
      mountEffectImpl(
        fiberFlags,
        Layout,
        imperativeHandleEffect.bind(null, create, ref),
        deps
      );
    }
    function updateImperativeHandle(ref, create, deps) {
      "function" !== typeof create &&
        console.error(
          "Expected useImperativeHandle() second argument to be a function that creates a handle. Instead received: %s.",
          null !== create ? typeof create : "null"
        );
      deps = null !== deps && void 0 !== deps ? deps.concat([ref]) : null;
      updateEffectImpl(
        4,
        Layout,
        imperativeHandleEffect.bind(null, create, ref),
        deps
      );
    }
    function mountCallback(callback, deps) {
      mountWorkInProgressHook().memoizedState = [
        callback,
        void 0 === deps ? null : deps
      ];
      return callback;
    }
    function updateCallback(callback, deps) {
      var hook = updateWorkInProgressHook();
      deps = void 0 === deps ? null : deps;
      var prevState = hook.memoizedState;
      if (null !== deps && areHookInputsEqual(deps, prevState[1]))
        return prevState[0];
      hook.memoizedState = [callback, deps];
      return callback;
    }
    function mountMemo(nextCreate, deps) {
      var hook = mountWorkInProgressHook();
      deps = void 0 === deps ? null : deps;
      var nextValue = nextCreate();
      if (shouldDoubleInvokeUserFnsInHooksDEV) {
        setIsStrictModeForDevtools(!0);
        try {
          nextCreate();
        } finally {
          setIsStrictModeForDevtools(!1);
        }
      }
      hook.memoizedState = [nextValue, deps];
      return nextValue;
    }
    function updateMemo(nextCreate, deps) {
      var hook = updateWorkInProgressHook();
      deps = void 0 === deps ? null : deps;
      var prevState = hook.memoizedState;
      if (null !== deps && areHookInputsEqual(deps, prevState[1]))
        return prevState[0];
      prevState = nextCreate();
      if (shouldDoubleInvokeUserFnsInHooksDEV) {
        setIsStrictModeForDevtools(!0);
        try {
          nextCreate();
        } finally {
          setIsStrictModeForDevtools(!1);
        }
      }
      hook.memoizedState = [prevState, deps];
      return prevState;
    }
    function mountDeferredValue(value, initialValue) {
      var hook = mountWorkInProgressHook();
      return mountDeferredValueImpl(hook, value, initialValue);
    }
    function updateDeferredValue(value, initialValue) {
      var hook = updateWorkInProgressHook();
      return updateDeferredValueImpl(
        hook,
        currentHook.memoizedState,
        value,
        initialValue
      );
    }
    function rerenderDeferredValue(value, initialValue) {
      var hook = updateWorkInProgressHook();
      return null === currentHook
        ? mountDeferredValueImpl(hook, value, initialValue)
        : updateDeferredValueImpl(
            hook,
            currentHook.memoizedState,
            value,
            initialValue
          );
    }
    function mountDeferredValueImpl(hook, value, initialValue) {
      if (void 0 === initialValue || 0 !== (renderLanes & 1073741824))
        return (hook.memoizedState = value);
      hook.memoizedState = initialValue;
      hook = requestDeferredLane();
      currentlyRenderingFiber.lanes |= hook;
      workInProgressRootSkippedLanes |= hook;
      return initialValue;
    }
    function updateDeferredValueImpl(hook, prevValue, value, initialValue) {
      if (objectIs(value, prevValue)) return value;
      if (null !== currentTreeHiddenStackCursor.current)
        return (
          (hook = mountDeferredValueImpl(hook, value, initialValue)),
          objectIs(hook, prevValue) || (didReceiveUpdate = !0),
          hook
        );
      if (0 === (renderLanes & 42) || 0 !== (renderLanes & 1073741824))
        return (didReceiveUpdate = !0), (hook.memoizedState = value);
      hook = requestDeferredLane();
      currentlyRenderingFiber.lanes |= hook;
      workInProgressRootSkippedLanes |= hook;
      return prevValue;
    }
    function releaseAsyncTransition() {
      ReactSharedInternals.asyncTransitions--;
    }
    function startTransition(
      fiber,
      queue,
      pendingState,
      finishedState,
      callback
    ) {
      var previousPriority = ReactDOMSharedInternals.p;
      ReactDOMSharedInternals.p =
        0 !== previousPriority && previousPriority < ContinuousEventPriority
          ? previousPriority
          : ContinuousEventPriority;
      var prevTransition = ReactSharedInternals.T,
        currentTransition = {};
      currentTransition.types =
        null !== prevTransition ? prevTransition.types : null;
      currentTransition.gesture = null;
      currentTransition._updatedFibers = new Set();
      ReactSharedInternals.T = currentTransition;
      dispatchOptimisticSetState(fiber, !1, queue, pendingState);
      try {
        var returnValue = callback(),
          onStartTransitionFinish = ReactSharedInternals.S;
        null !== onStartTransitionFinish &&
          onStartTransitionFinish(currentTransition, returnValue);
        if (
          null !== returnValue &&
          "object" === typeof returnValue &&
          "function" === typeof returnValue.then
        ) {
          ReactSharedInternals.asyncTransitions++;
          returnValue.then(releaseAsyncTransition, releaseAsyncTransition);
          var thenableForFinishedState = chainThenableValue(
            returnValue,
            finishedState
          );
          dispatchSetStateInternal(
            fiber,
            queue,
            thenableForFinishedState,
            requestUpdateLane(fiber)
          );
        } else
          dispatchSetStateInternal(
            fiber,
            queue,
            finishedState,
            requestUpdateLane(fiber)
          );
      } catch (error) {
        dispatchSetStateInternal(
          fiber,
          queue,
          { then: function () {}, status: "rejected", reason: error },
          requestUpdateLane(fiber)
        );
      } finally {
        (ReactDOMSharedInternals.p = previousPriority),
          null !== prevTransition &&
            null !== currentTransition.types &&
            (null !== prevTransition.types &&
              prevTransition.types !== currentTransition.types &&
              console.error(
                "We expected inner Transitions to have transferred the outer types set and that you cannot add to the outer Transition while inside the inner.This is a bug in React."
              ),
            (prevTransition.types = currentTransition.types)),
          (ReactSharedInternals.T = prevTransition),
          null === prevTransition &&
            currentTransition._updatedFibers &&
            ((fiber = currentTransition._updatedFibers.size),
            currentTransition._updatedFibers.clear(),
            10 < fiber &&
              console.warn(
                "Detected a large number of updates inside startTransition. If this is due to a subscription please re-write it to use React provided hooks. Otherwise concurrent mode guarantees are off the table."
              ));
      }
    }
    function startHostTransition(formFiber, pendingState, action, formData) {
      if (5 !== formFiber.tag)
        throw Error(
          "Expected the form instance to be a HostComponent. This is a bug in React."
        );
      var queue = ensureFormComponentIsStateful(formFiber).queue;
      startTransition(
        formFiber,
        queue,
        pendingState,
        NotPendingTransition,
        null === action
          ? noop
          : function () {
              requestFormReset$2(formFiber);
              return action(formData);
            }
      );
    }
    function ensureFormComponentIsStateful(formFiber) {
      var existingStateHook = formFiber.memoizedState;
      if (null !== existingStateHook) return existingStateHook;
      existingStateHook = {
        memoizedState: NotPendingTransition,
        baseState: NotPendingTransition,
        baseQueue: null,
        queue: {
          pending: null,
          lanes: 0,
          dispatch: null,
          lastRenderedReducer: basicStateReducer,
          lastRenderedState: NotPendingTransition
        },
        next: null
      };
      var initialResetState = {};
      existingStateHook.next = {
        memoizedState: initialResetState,
        baseState: initialResetState,
        baseQueue: null,
        queue: {
          pending: null,
          lanes: 0,
          dispatch: null,
          lastRenderedReducer: basicStateReducer,
          lastRenderedState: initialResetState
        },
        next: null
      };
      formFiber.memoizedState = existingStateHook;
      formFiber = formFiber.alternate;
      null !== formFiber && (formFiber.memoizedState = existingStateHook);
      return existingStateHook;
    }
    function requestFormReset$2(formFiber) {
      var transition = ReactSharedInternals.T;
      if (null === transition)
        console.error(
          "requestFormReset was called outside a transition or action. To fix, move to an action, or wrap with startTransition."
        );
      else if (transition.gesture)
        throw Error(
          "Cannot requestFormReset() inside a startGestureTransition. There should be no side-effects associated with starting a Gesture until its Action is invoked. Move side-effects to the Action instead."
        );
      transition = ensureFormComponentIsStateful(formFiber);
      null === transition.next &&
        (transition = formFiber.alternate.memoizedState);
      dispatchSetStateInternal(
        formFiber,
        transition.next.queue,
        {},
        requestUpdateLane(formFiber)
      );
    }
    function mountTransition() {
      var stateHook = mountStateImpl(!1);
      stateHook = startTransition.bind(
        null,
        currentlyRenderingFiber,
        stateHook.queue,
        !0,
        !1
      );
      mountWorkInProgressHook().memoizedState = stateHook;
      return [!1, stateHook];
    }
    function updateTransition() {
      var booleanOrThenable = updateReducer(basicStateReducer)[0],
        start = updateWorkInProgressHook().memoizedState;
      return [
        "boolean" === typeof booleanOrThenable
          ? booleanOrThenable
          : useThenable(booleanOrThenable),
        start
      ];
    }
    function rerenderTransition() {
      var booleanOrThenable = rerenderReducer(basicStateReducer)[0],
        start = updateWorkInProgressHook().memoizedState;
      return [
        "boolean" === typeof booleanOrThenable
          ? booleanOrThenable
          : useThenable(booleanOrThenable),
        start
      ];
    }
    function useHostTransitionStatus() {
      return readContext(HostTransitionContext);
    }
    function mountId() {
      var hook = mountWorkInProgressHook(),
        identifierPrefix = workInProgressRoot.identifierPrefix;
      if (isHydrating) {
        var treeId = treeContextOverflow;
        var idWithLeadingBit = treeContextId;
        treeId =
          (
            idWithLeadingBit & ~(1 << (32 - clz32(idWithLeadingBit) - 1))
          ).toString(32) + treeId;
        identifierPrefix = "_" + identifierPrefix + "R_" + treeId;
        treeId = localIdCounter++;
        0 < treeId && (identifierPrefix += "H" + treeId.toString(32));
        identifierPrefix += "_";
      } else
        (treeId = globalClientIdCounter++),
          (identifierPrefix =
            "_" + identifierPrefix + "r_" + treeId.toString(32) + "_");
      return (hook.memoizedState = identifierPrefix);
    }
    function mountRefresh() {
      return (mountWorkInProgressHook().memoizedState = refreshCache.bind(
        null,
        currentlyRenderingFiber
      ));
    }
    function refreshCache(fiber, seedKey, seedValue) {
      for (var provider = fiber.return; null !== provider; ) {
        switch (provider.tag) {
          case 24:
          case 3:
            var lane = requestUpdateLane(provider);
            fiber = createUpdate(lane);
            var root = enqueueUpdate(provider, fiber, lane);
            null !== root &&
              (startUpdateTimerByLane(lane, "refresh()"),
              scheduleUpdateOnFiber(root, provider, lane),
              entangleTransitions(root, provider, lane));
            provider = createCache();
            null !== seedKey &&
              void 0 !== seedKey &&
              null !== root &&
              provider.data.set(seedKey, seedValue);
            fiber.payload = { cache: provider };
            return;
        }
        provider = provider.return;
      }
    }
    function dispatchReducerAction(fiber, queue, action) {
      var args = arguments;
      "function" === typeof args[3] &&
        console.error(
          "State updates from the useState() and useReducer() Hooks don't support the second callback argument. To execute a side effect after rendering, declare it in the component body with useEffect()."
        );
      args = requestUpdateLane(fiber);
      var update = {
        lane: args,
        revertLane: 0,
        gesture: null,
        action: action,
        hasEagerState: !1,
        eagerState: null,
        next: null
      };
      isRenderPhaseUpdate(fiber)
        ? enqueueRenderPhaseUpdate(queue, update)
        : ((update = enqueueConcurrentHookUpdate(fiber, queue, update, args)),
          null !== update &&
            (startUpdateTimerByLane(args, "dispatch()"),
            scheduleUpdateOnFiber(update, fiber, args),
            entangleTransitionUpdate(update, queue, args)));
    }
    function dispatchSetState(fiber, queue, action) {
      var args = arguments;
      "function" === typeof args[3] &&
        console.error(
          "State updates from the useState() and useReducer() Hooks don't support the second callback argument. To execute a side effect after rendering, declare it in the component body with useEffect()."
        );
      args = requestUpdateLane(fiber);
      dispatchSetStateInternal(fiber, queue, action, args) &&
        startUpdateTimerByLane(args, "setState()");
    }
    function dispatchSetStateInternal(fiber, queue, action, lane) {
      var update = {
        lane: lane,
        revertLane: 0,
        gesture: null,
        action: action,
        hasEagerState: !1,
        eagerState: null,
        next: null
      };
      if (isRenderPhaseUpdate(fiber)) enqueueRenderPhaseUpdate(queue, update);
      else {
        var alternate = fiber.alternate;
        if (
          0 === fiber.lanes &&
          (null === alternate || 0 === alternate.lanes) &&
          ((alternate = queue.lastRenderedReducer), null !== alternate)
        ) {
          var prevDispatcher = ReactSharedInternals.H;
          ReactSharedInternals.H = InvalidNestedHooksDispatcherOnUpdateInDEV;
          try {
            var currentState = queue.lastRenderedState,
              eagerState = alternate(currentState, action);
            update.hasEagerState = !0;
            update.eagerState = eagerState;
            if (objectIs(eagerState, currentState))
              return (
                enqueueUpdate$1(fiber, queue, update, 0),
                null === workInProgressRoot &&
                  finishQueueingConcurrentUpdates(),
                !1
              );
          } catch (error) {
          } finally {
            ReactSharedInternals.H = prevDispatcher;
          }
        }
        action = enqueueConcurrentHookUpdate(fiber, queue, update, lane);
        if (null !== action)
          return (
            scheduleUpdateOnFiber(action, fiber, lane),
            entangleTransitionUpdate(action, queue, lane),
            !0
          );
      }
      return !1;
    }
    function dispatchOptimisticSetState(
      fiber,
      throwIfDuringRender,
      queue,
      action
    ) {
      var transition = ReactSharedInternals.T;
      null === transition &&
        0 === currentEntangledLane &&
        console.error(
          "An optimistic state update occurred outside a transition or action. To fix, move the update to an action, or wrap with startTransition."
        );
      var lane = null !== transition && transition.gesture ? 64 : 2;
      action = {
        lane: lane,
        revertLane: requestTransitionLane(),
        gesture: null,
        action: action,
        hasEagerState: !1,
        eagerState: null,
        next: null
      };
      if (isRenderPhaseUpdate(fiber)) {
        if (throwIfDuringRender)
          throw Error("Cannot update optimistic state while rendering.");
        console.error("Cannot call startTransition while rendering.");
      } else if (
        ((throwIfDuringRender = enqueueConcurrentHookUpdate(
          fiber,
          queue,
          action,
          lane
        )),
        null !== throwIfDuringRender &&
          (startUpdateTimerByLane(lane, "setOptimistic()"),
          scheduleUpdateOnFiber(throwIfDuringRender, fiber, lane),
          null !== transition &&
            ((transition = transition.gesture), null !== transition)))
      ) {
        a: {
          for (fiber = throwIfDuringRender.pendingGestures; null !== fiber; ) {
            if (fiber.provider === transition) {
              throwIfDuringRender = fiber;
              break a;
            }
            lane = fiber.next;
            if (null === lane) break;
            fiber = lane;
          }
          transition = {
            provider: transition,
            count: 0,
            rangeStart: 0,
            rangeEnd: 100,
            types: null,
            running: null,
            prev: fiber,
            next: null
          };
          null === fiber
            ? (throwIfDuringRender.pendingGestures = transition)
            : (fiber.next = transition);
          ensureRootIsScheduled(throwIfDuringRender);
          throwIfDuringRender = transition;
        }
        action.gesture = throwIfDuringRender;
      }
    }
    function isRenderPhaseUpdate(fiber) {
      var alternate = fiber.alternate;
      return (
        fiber === currentlyRenderingFiber ||
        (null !== alternate && alternate === currentlyRenderingFiber)
      );
    }
    function enqueueRenderPhaseUpdate(queue, update) {
      didScheduleRenderPhaseUpdateDuringThisPass =
        didScheduleRenderPhaseUpdate = !0;
      var pending = queue.pending;
      null === pending
        ? (update.next = update)
        : ((update.next = pending.next), (pending.next = update));
      queue.pending = update;
    }
    function entangleTransitionUpdate(root, queue, lane) {
      if (0 !== (lane & 4194048)) {
        var queueLanes = queue.lanes;
        queueLanes &= root.pendingLanes;
        lane |= queueLanes;
        queue.lanes = lane;
        markRootEntangled(root, lane);
      }
    }
    function warnOnInvalidCallback(callback) {
      if (null !== callback && "function" !== typeof callback) {
        var key = String(callback);
        didWarnOnInvalidCallback.has(key) ||
          (didWarnOnInvalidCallback.add(key),
          console.error(
            "Expected the last optional `callback` argument to be a function. Instead received: %s.",
            callback
          ));
      }
    }
    function applyDerivedStateFromProps(
      workInProgress,
      ctor,
      getDerivedStateFromProps,
      nextProps
    ) {
      var prevState = workInProgress.memoizedState,
        partialState = getDerivedStateFromProps(nextProps, prevState);
      if (workInProgress.mode & StrictLegacyMode) {
        setIsStrictModeForDevtools(!0);
        try {
          partialState = getDerivedStateFromProps(nextProps, prevState);
        } finally {
          setIsStrictModeForDevtools(!1);
        }
      }
      void 0 === partialState &&
        ((ctor = getComponentNameFromType(ctor) || "Component"),
        didWarnAboutUndefinedDerivedState.has(ctor) ||
          (didWarnAboutUndefinedDerivedState.add(ctor),
          console.error(
            "%s.getDerivedStateFromProps(): A valid state object (or null) must be returned. You have returned undefined.",
            ctor
          )));
      prevState =
        null === partialState || void 0 === partialState
          ? prevState
          : assign({}, prevState, partialState);
      workInProgress.memoizedState = prevState;
      0 === workInProgress.lanes &&
        (workInProgress.updateQueue.baseState = prevState);
    }
    function checkShouldComponentUpdate(
      workInProgress,
      ctor,
      oldProps,
      newProps,
      oldState,
      newState,
      nextContext
    ) {
      var instance = workInProgress.stateNode;
      if ("function" === typeof instance.shouldComponentUpdate) {
        oldProps = instance.shouldComponentUpdate(
          newProps,
          newState,
          nextContext
        );
        if (workInProgress.mode & StrictLegacyMode) {
          setIsStrictModeForDevtools(!0);
          try {
            oldProps = instance.shouldComponentUpdate(
              newProps,
              newState,
              nextContext
            );
          } finally {
            setIsStrictModeForDevtools(!1);
          }
        }
        void 0 === oldProps &&
          console.error(
            "%s.shouldComponentUpdate(): Returned undefined instead of a boolean value. Make sure to return true or false.",
            getComponentNameFromType(ctor) || "Component"
          );
        return oldProps;
      }
      return ctor.prototype && ctor.prototype.isPureReactComponent
        ? !shallowEqual(oldProps, newProps) || !shallowEqual(oldState, newState)
        : !0;
    }
    function callComponentWillReceiveProps(
      workInProgress,
      instance,
      newProps,
      nextContext
    ) {
      var oldState = instance.state;
      "function" === typeof instance.componentWillReceiveProps &&
        instance.componentWillReceiveProps(newProps, nextContext);
      "function" === typeof instance.UNSAFE_componentWillReceiveProps &&
        instance.UNSAFE_componentWillReceiveProps(newProps, nextContext);
      instance.state !== oldState &&
        ((workInProgress =
          getComponentNameFromFiber(workInProgress) || "Component"),
        didWarnAboutStateAssignmentForComponent.has(workInProgress) ||
          (didWarnAboutStateAssignmentForComponent.add(workInProgress),
          console.error(
            "%s.componentWillReceiveProps(): Assigning directly to this.state is deprecated (except inside a component's constructor). Use setState instead.",
            workInProgress
          )),
        classComponentUpdater.enqueueReplaceState(
          instance,
          instance.state,
          null
        ));
    }
    function resolveClassComponentProps(Component, baseProps) {
      var newProps = baseProps;
      if ("ref" in baseProps) {
        newProps = {};
        for (var propName in baseProps)
          "ref" !== propName && (newProps[propName] = baseProps[propName]);
      }
      if ((Component = Component.defaultProps)) {
        newProps === baseProps && (newProps = assign({}, newProps));
        for (var _propName in Component)
          void 0 === newProps[_propName] &&
            (newProps[_propName] = Component[_propName]);
      }
      return newProps;
    }
    function defaultOnUncaughtError(error) {
      reportGlobalError(error);
      console.warn(
        "%s\n\n%s\n",
        componentName
          ? "An error occurred in the <" + componentName + "> component."
          : "An error occurred in one of your React components.",
        "Consider adding an error boundary to your tree to customize error handling behavior.\nVisit https://react.dev/link/error-boundaries to learn more about error boundaries."
      );
    }
    function defaultOnCaughtError(error) {
      var componentNameMessage = componentName
          ? "The above error occurred in the <" + componentName + "> component."
          : "The above error occurred in one of your React components.",
        recreateMessage =
          "React will try to recreate this component tree from scratch using the error boundary you provided, " +
          ((errorBoundaryName || "Anonymous") + ".");
      if (
        "object" === typeof error &&
        null !== error &&
        "string" === typeof error.environmentName
      ) {
        var JSCompiler_inline_result = error.environmentName;
        error = [
          "%o\n\n%s\n\n%s\n",
          error,
          componentNameMessage,
          recreateMessage
        ].slice(0);
        "string" === typeof error[0]
          ? error.splice(
              0,
              1,
              badgeFormat + " " + error[0],
              badgeStyle,
              pad + JSCompiler_inline_result + pad,
              resetStyle
            )
          : error.splice(
              0,
              0,
              badgeFormat,
              badgeStyle,
              pad + JSCompiler_inline_result + pad,
              resetStyle
            );
        error.unshift(console);
        JSCompiler_inline_result = bind.apply(console.error, error);
        JSCompiler_inline_result();
      } else
        console.error(
          "%o\n\n%s\n\n%s\n",
          error,
          componentNameMessage,
          recreateMessage
        );
    }
    function defaultOnRecoverableError(error) {
      reportGlobalError(error);
    }
    function logUncaughtError(root, errorInfo) {
      try {
        componentName = errorInfo.source
          ? getComponentNameFromFiber(errorInfo.source)
          : null;
        errorBoundaryName = null;
        var error = errorInfo.value;
        if (null !== ReactSharedInternals.actQueue)
          ReactSharedInternals.thrownErrors.push(error);
        else {
          var onUncaughtError = root.onUncaughtError;
          onUncaughtError(error, { componentStack: errorInfo.stack });
        }
      } catch (e$5) {
        setTimeout(function () {
          throw e$5;
        });
      }
    }
    function logCaughtError(root, boundary, errorInfo) {
      try {
        componentName = errorInfo.source
          ? getComponentNameFromFiber(errorInfo.source)
          : null;
        errorBoundaryName = getComponentNameFromFiber(boundary);
        var onCaughtError = root.onCaughtError;
        onCaughtError(errorInfo.value, {
          componentStack: errorInfo.stack,
          errorBoundary: 1 === boundary.tag ? boundary.stateNode : null
        });
      } catch (e$6) {
        setTimeout(function () {
          throw e$6;
        });
      }
    }
    function createRootErrorUpdate(root, errorInfo, lane) {
      lane = createUpdate(lane);
      lane.tag = CaptureUpdate;
      lane.payload = { element: null };
      lane.callback = function () {
        runWithFiberInDEV(errorInfo.source, logUncaughtError, root, errorInfo);
      };
      return lane;
    }
    function createClassErrorUpdate(lane) {
      lane = createUpdate(lane);
      lane.tag = CaptureUpdate;
      return lane;
    }
    function initializeClassErrorUpdate(update, root, fiber, errorInfo) {
      var getDerivedStateFromError = fiber.type.getDerivedStateFromError;
      if ("function" === typeof getDerivedStateFromError) {
        var error = errorInfo.value;
        update.payload = function () {
          return getDerivedStateFromError(error);
        };
        update.callback = function () {
          markFailedErrorBoundaryForHotReloading(fiber);
          runWithFiberInDEV(
            errorInfo.source,
            logCaughtError,
            root,
            fiber,
            errorInfo
          );
        };
      }
      var inst = fiber.stateNode;
      null !== inst &&
        "function" === typeof inst.componentDidCatch &&
        (update.callback = function () {
          markFailedErrorBoundaryForHotReloading(fiber);
          runWithFiberInDEV(
            errorInfo.source,
            logCaughtError,
            root,
            fiber,
            errorInfo
          );
          "function" !== typeof getDerivedStateFromError &&
            (null === legacyErrorBoundariesThatAlreadyFailed
              ? (legacyErrorBoundariesThatAlreadyFailed = new Set([this]))
              : legacyErrorBoundariesThatAlreadyFailed.add(this));
          callComponentDidCatchInDEV(this, errorInfo);
          "function" === typeof getDerivedStateFromError ||
            (0 === (fiber.lanes & 2) &&
              console.error(
                "%s: Error boundaries should implement getDerivedStateFromError(). In that method, return a state update to display an error message or fallback UI.",
                getComponentNameFromFiber(fiber) || "Unknown"
              ));
        });
    }
    function resetSuspendedComponent(sourceFiber, rootRenderLanes) {
      var currentSourceFiber = sourceFiber.alternate;
      null !== currentSourceFiber &&
        propagateParentContextChanges(
          currentSourceFiber,
          sourceFiber,
          rootRenderLanes,
          !0
        );
    }
    function markSuspenseBoundaryShouldCapture(
      suspenseBoundary,
      returnFiber,
      sourceFiber,
      root,
      rootRenderLanes
    ) {
      suspenseBoundary.flags |= 65536;
      suspenseBoundary.lanes = rootRenderLanes;
      return suspenseBoundary;
    }
    function throwException(
      root,
      returnFiber,
      sourceFiber,
      value,
      rootRenderLanes
    ) {
      sourceFiber.flags |= 32768;
      isDevToolsPresent && restorePendingUpdaters(root, rootRenderLanes);
      if (
        null !== value &&
        "object" === typeof value &&
        (value.$$typeof === REACT_POSTPONE_TYPE &&
          (value = { then: function () {} }),
        "function" === typeof value.then)
      ) {
        resetSuspendedComponent(sourceFiber, rootRenderLanes);
        isHydrating && (didSuspendOrErrorDEV = !0);
        var suspenseBoundary = suspenseHandlerStackCursor.current;
        if (null !== suspenseBoundary) {
          switch (suspenseBoundary.tag) {
            case 31:
            case 13:
              return (
                null === shellBoundary
                  ? renderDidSuspendDelayIfPossible()
                  : null === suspenseBoundary.alternate &&
                    workInProgressRootExitStatus === RootInProgress &&
                    (workInProgressRootExitStatus = RootSuspended),
                (suspenseBoundary.flags &= -257),
                markSuspenseBoundaryShouldCapture(
                  suspenseBoundary,
                  returnFiber,
                  sourceFiber,
                  root,
                  rootRenderLanes
                ),
                value === noopSuspenseyCommitThenable
                  ? (suspenseBoundary.flags |= 16384)
                  : ((sourceFiber = suspenseBoundary.updateQueue),
                    null === sourceFiber
                      ? (suspenseBoundary.updateQueue = new Set([value]))
                      : sourceFiber.add(value),
                    attachPingListener(root, value, rootRenderLanes)),
                !1
              );
            case 22:
              return (
                (suspenseBoundary.flags |= 65536),
                value === noopSuspenseyCommitThenable
                  ? (suspenseBoundary.flags |= 16384)
                  : ((sourceFiber = suspenseBoundary.updateQueue),
                    null === sourceFiber
                      ? ((sourceFiber = {
                          transitions: null,
                          markerInstances: null,
                          retryQueue: new Set([value])
                        }),
                        (suspenseBoundary.updateQueue = sourceFiber))
                      : ((returnFiber = sourceFiber.retryQueue),
                        null === returnFiber
                          ? (sourceFiber.retryQueue = new Set([value]))
                          : returnFiber.add(value)),
                    attachPingListener(root, value, rootRenderLanes)),
                !1
              );
          }
          throw Error(
            "Unexpected Suspense handler tag (" +
              suspenseBoundary.tag +
              "). This is a bug in React."
          );
        }
        attachPingListener(root, value, rootRenderLanes);
        renderDidSuspendDelayIfPossible();
        return !1;
      }
      if (isHydrating)
        return (
          (didSuspendOrErrorDEV = !0),
          (suspenseBoundary = suspenseHandlerStackCursor.current),
          null !== suspenseBoundary
            ? (0 === (suspenseBoundary.flags & 65536) &&
                (suspenseBoundary.flags |= 256),
              markSuspenseBoundaryShouldCapture(
                suspenseBoundary,
                returnFiber,
                sourceFiber,
                root,
                rootRenderLanes
              ),
              value !== HydrationMismatchException &&
                queueHydrationError(
                  createCapturedValueAtFiber(
                    Error(
                      "There was an error while hydrating but React was able to recover by instead client rendering from the nearest Suspense boundary.",
                      { cause: value }
                    ),
                    sourceFiber
                  )
                ))
            : (value !== HydrationMismatchException &&
                queueHydrationError(
                  createCapturedValueAtFiber(
                    Error(
                      "There was an error while hydrating but React was able to recover by instead client rendering the entire root.",
                      { cause: value }
                    ),
                    sourceFiber
                  )
                ),
              (root = root.current.alternate),
              (root.flags |= 65536),
              (rootRenderLanes &= -rootRenderLanes),
              (root.lanes |= rootRenderLanes),
              (sourceFiber = createCapturedValueAtFiber(value, sourceFiber)),
              (rootRenderLanes = createRootErrorUpdate(
                root.stateNode,
                sourceFiber,
                rootRenderLanes
              )),
              enqueueCapturedUpdate(root, rootRenderLanes),
              workInProgressRootExitStatus !== RootSuspendedWithDelay &&
                (workInProgressRootExitStatus = RootErrored)),
          !1
        );
      queueConcurrentError(
        createCapturedValueAtFiber(
          Error(
            "There was an error during concurrent rendering but React was able to recover by instead synchronously rendering the entire root.",
            { cause: value }
          ),
          sourceFiber
        )
      );
      workInProgressRootExitStatus !== RootSuspendedWithDelay &&
        (workInProgressRootExitStatus = RootErrored);
      if (null === returnFiber) return !0;
      sourceFiber = createCapturedValueAtFiber(value, sourceFiber);
      value = returnFiber;
      do {
        switch (value.tag) {
          case 3:
            return (
              (value.flags |= 65536),
              (root = rootRenderLanes & -rootRenderLanes),
              (value.lanes |= root),
              (root = createRootErrorUpdate(
                value.stateNode,
                sourceFiber,
                root
              )),
              enqueueCapturedUpdate(value, root),
              !1
            );
          case 1:
            if (
              ((returnFiber = value.type),
              (suspenseBoundary = value.stateNode),
              0 === (value.flags & 128) &&
                ("function" === typeof returnFiber.getDerivedStateFromError ||
                  (null !== suspenseBoundary &&
                    "function" === typeof suspenseBoundary.componentDidCatch &&
                    (null === legacyErrorBoundariesThatAlreadyFailed ||
                      !legacyErrorBoundariesThatAlreadyFailed.has(
                        suspenseBoundary
                      )))))
            )
              return (
                (value.flags |= 65536),
                (rootRenderLanes &= -rootRenderLanes),
                (value.lanes |= rootRenderLanes),
                (rootRenderLanes = createClassErrorUpdate(rootRenderLanes)),
                initializeClassErrorUpdate(
                  rootRenderLanes,
                  root,
                  value,
                  sourceFiber
                ),
                enqueueCapturedUpdate(value, rootRenderLanes),
                !1
              );
        }
        value = value.return;
      } while (null !== value);
      return !1;
    }
    function reconcileChildren(
      current,
      workInProgress,
      nextChildren,
      renderLanes
    ) {
      workInProgress.child =
        null === current
          ? mountChildFibers(workInProgress, null, nextChildren, renderLanes)
          : reconcileChildFibers(
              workInProgress,
              current.child,
              nextChildren,
              renderLanes
            );
    }
    function updateForwardRef(
      current,
      workInProgress,
      Component,
      nextProps,
      renderLanes
    ) {
      Component = Component.render;
      var ref = workInProgress.ref;
      if ("ref" in nextProps) {
        var propsWithoutRef = {};
        for (var key in nextProps)
          "ref" !== key && (propsWithoutRef[key] = nextProps[key]);
      } else propsWithoutRef = nextProps;
      prepareToReadContext(workInProgress);
      nextProps = renderWithHooks(
        current,
        workInProgress,
        Component,
        propsWithoutRef,
        ref,
        renderLanes
      );
      key = checkDidRenderIdHook();
      if (null !== current && !didReceiveUpdate)
        return (
          bailoutHooks(current, workInProgress, renderLanes),
          bailoutOnAlreadyFinishedWork(current, workInProgress, renderLanes)
        );
      isHydrating && key && pushMaterializedTreeId(workInProgress);
      workInProgress.flags |= 1;
      reconcileChildren(current, workInProgress, nextProps, renderLanes);
      return workInProgress.child;
    }
    function updateMemoComponent(
      current,
      workInProgress,
      Component,
      nextProps,
      renderLanes
    ) {
      if (null === current) {
        var type = Component.type;
        if (
          "function" === typeof type &&
          !shouldConstruct(type) &&
          void 0 === type.defaultProps &&
          null === Component.compare
        )
          return (
            (Component = resolveFunctionForHotReloading(type)),
            (workInProgress.tag = 15),
            (workInProgress.type = Component),
            validateFunctionComponentInDev(workInProgress, type),
            updateSimpleMemoComponent(
              current,
              workInProgress,
              Component,
              nextProps,
              renderLanes
            )
          );
        current = createFiberFromTypeAndProps(
          Component.type,
          null,
          nextProps,
          workInProgress,
          workInProgress.mode,
          renderLanes
        );
        current.ref = workInProgress.ref;
        current.return = workInProgress;
        return (workInProgress.child = current);
      }
      type = current.child;
      if (!checkScheduledUpdateOrContext(current, renderLanes)) {
        var prevProps = type.memoizedProps;
        Component = Component.compare;
        Component = null !== Component ? Component : shallowEqual;
        if (
          Component(prevProps, nextProps) &&
          current.ref === workInProgress.ref
        )
          return bailoutOnAlreadyFinishedWork(
            current,
            workInProgress,
            renderLanes
          );
      }
      workInProgress.flags |= 1;
      current = createWorkInProgress(type, nextProps);
      current.ref = workInProgress.ref;
      current.return = workInProgress;
      return (workInProgress.child = current);
    }
    function updateSimpleMemoComponent(
      current,
      workInProgress,
      Component,
      nextProps,
      renderLanes
    ) {
      if (null !== current) {
        var prevProps = current.memoizedProps;
        if (
          shallowEqual(prevProps, nextProps) &&
          current.ref === workInProgress.ref &&
          workInProgress.type === current.type
        )
          if (
            ((didReceiveUpdate = !1),
            (workInProgress.pendingProps = nextProps = prevProps),
            checkScheduledUpdateOrContext(current, renderLanes))
          )
            0 !== (current.flags & 131072) && (didReceiveUpdate = !0);
          else
            return (
              (workInProgress.lanes = current.lanes),
              bailoutOnAlreadyFinishedWork(current, workInProgress, renderLanes)
            );
      }
      return updateFunctionComponent(
        current,
        workInProgress,
        Component,
        nextProps,
        renderLanes
      );
    }
    function updateOffscreenComponent(
      current,
      workInProgress,
      renderLanes,
      nextProps
    ) {
      var nextChildren = nextProps.children,
        prevState = null !== current ? current.memoizedState : null;
      if ("hidden" === nextProps.mode) {
        if (0 !== (workInProgress.flags & 128)) {
          nextProps =
            null !== prevState
              ? prevState.baseLanes | renderLanes
              : renderLanes;
          if (null !== current) {
            nextChildren = workInProgress.child = current.child;
            for (prevState = 0; null !== nextChildren; )
              (prevState =
                prevState | nextChildren.lanes | nextChildren.childLanes),
                (nextChildren = nextChildren.sibling);
            workInProgress.childLanes = prevState & ~nextProps;
          } else (workInProgress.childLanes = 0), (workInProgress.child = null);
          return deferHiddenOffscreenComponent(
            current,
            workInProgress,
            nextProps,
            renderLanes
          );
        }
        if (0 !== (renderLanes & 536870912))
          (workInProgress.memoizedState = { baseLanes: 0, cachePool: null }),
            null !== current &&
              pushTransition(
                workInProgress,
                null !== prevState ? prevState.cachePool : null
              ),
            null !== prevState
              ? pushHiddenContext(workInProgress, prevState)
              : reuseHiddenContextOnStack(workInProgress),
            pushOffscreenSuspenseHandler(workInProgress);
        else
          return (
            (workInProgress.lanes = workInProgress.childLanes = 536870912),
            deferHiddenOffscreenComponent(
              current,
              workInProgress,
              null !== prevState
                ? prevState.baseLanes | renderLanes
                : renderLanes,
              renderLanes
            )
          );
      } else
        null !== prevState
          ? (pushTransition(workInProgress, prevState.cachePool),
            pushHiddenContext(workInProgress, prevState),
            reuseSuspenseHandlerOnStack(workInProgress),
            (workInProgress.memoizedState = null))
          : (null !== current && pushTransition(workInProgress, null),
            reuseHiddenContextOnStack(workInProgress),
            reuseSuspenseHandlerOnStack(workInProgress));
      reconcileChildren(current, workInProgress, nextChildren, renderLanes);
      return workInProgress.child;
    }
    function deferHiddenOffscreenComponent(
      current,
      workInProgress,
      nextBaseLanes,
      renderLanes
    ) {
      var JSCompiler_inline_result = peekCacheFromPool();
      JSCompiler_inline_result =
        null === JSCompiler_inline_result
          ? null
          : {
              parent: CacheContext._currentValue,
              pool: JSCompiler_inline_result
            };
      workInProgress.memoizedState = {
        baseLanes: nextBaseLanes,
        cachePool: JSCompiler_inline_result
      };
      null !== current && pushTransition(workInProgress, null);
      reuseHiddenContextOnStack(workInProgress);
      pushOffscreenSuspenseHandler(workInProgress);
      null !== current &&
        propagateParentContextChanges(current, workInProgress, renderLanes, !0);
      return null;
    }
    function mountActivityChildren(workInProgress, nextProps) {
      var hiddenProp = nextProps.hidden;
      void 0 !== hiddenProp &&
        console.error(
          '<Activity> doesn\'t accept a hidden prop. Use mode="hidden" instead.\n- <Activity %s>\n+ <Activity %s>',
          !0 === hiddenProp
            ? "hidden"
            : !1 === hiddenProp
              ? "hidden={false}"
              : "hidden={...}",
          hiddenProp ? 'mode="hidden"' : 'mode="visible"'
        );
      nextProps = mountWorkInProgressOffscreenFiber(
        { mode: nextProps.mode, children: nextProps.children },
        workInProgress.mode
      );
      nextProps.ref = workInProgress.ref;
      workInProgress.child = nextProps;
      nextProps.return = workInProgress;
      return nextProps;
    }
    function retryActivityComponentWithoutHydrating(
      current,
      workInProgress,
      renderLanes
    ) {
      reconcileChildFibers(workInProgress, current.child, null, renderLanes);
      current = mountActivityChildren(
        workInProgress,
        workInProgress.pendingProps
      );
      current.flags |= 2;
      popSuspenseHandler(workInProgress);
      workInProgress.memoizedState = null;
      return current;
    }
    function markRef(current, workInProgress) {
      var ref = workInProgress.ref;
      if (null === ref)
        null !== current &&
          null !== current.ref &&
          (workInProgress.flags |= 4194816);
      else {
        if ("function" !== typeof ref && "object" !== typeof ref)
          throw Error(
            "Expected ref to be a function, an object returned by React.createRef(), or undefined/null."
          );
        if (null === current || current.ref !== ref)
          workInProgress.flags |= 4194816;
      }
    }
    function updateFunctionComponent(
      current,
      workInProgress,
      Component,
      nextProps,
      renderLanes
    ) {
      if (
        Component.prototype &&
        "function" === typeof Component.prototype.render
      ) {
        var componentName = getComponentNameFromType(Component) || "Unknown";
        didWarnAboutBadClass[componentName] ||
          (console.error(
            "The <%s /> component appears to have a render method, but doesn't extend React.Component. This is likely to cause errors. Change %s to extend React.Component instead.",
            componentName,
            componentName
          ),
          (didWarnAboutBadClass[componentName] = !0));
      }
      workInProgress.mode & StrictLegacyMode &&
        ReactStrictModeWarnings.recordLegacyContextWarning(
          workInProgress,
          null
        );
      null === current &&
        (validateFunctionComponentInDev(workInProgress, workInProgress.type),
        Component.contextTypes &&
          ((componentName = getComponentNameFromType(Component) || "Unknown"),
          didWarnAboutContextTypes[componentName] ||
            ((didWarnAboutContextTypes[componentName] = !0),
            console.error(
              "%s uses the legacy contextTypes API which was removed in React 19. Use React.createContext() with React.useContext() instead. (https://react.dev/link/legacy-context)",
              componentName
            ))));
      prepareToReadContext(workInProgress);
      Component = renderWithHooks(
        current,
        workInProgress,
        Component,
        nextProps,
        void 0,
        renderLanes
      );
      nextProps = checkDidRenderIdHook();
      if (null !== current && !didReceiveUpdate)
        return (
          bailoutHooks(current, workInProgress, renderLanes),
          bailoutOnAlreadyFinishedWork(current, workInProgress, renderLanes)
        );
      isHydrating && nextProps && pushMaterializedTreeId(workInProgress);
      workInProgress.flags |= 1;
      reconcileChildren(current, workInProgress, Component, renderLanes);
      return workInProgress.child;
    }
    function replayFunctionComponent(
      current,
      workInProgress,
      nextProps,
      Component,
      secondArg,
      renderLanes
    ) {
      prepareToReadContext(workInProgress);
      hookTypesUpdateIndexDev = -1;
      ignorePreviousDependencies =
        null !== current && current.type !== workInProgress.type;
      workInProgress.updateQueue = null;
      nextProps = renderWithHooksAgain(
        workInProgress,
        Component,
        nextProps,
        secondArg
      );
      finishRenderingHooks(current, workInProgress);
      Component = checkDidRenderIdHook();
      if (null !== current && !didReceiveUpdate)
        return (
          bailoutHooks(current, workInProgress, renderLanes),
          bailoutOnAlreadyFinishedWork(current, workInProgress, renderLanes)
        );
      isHydrating && Component && pushMaterializedTreeId(workInProgress);
      workInProgress.flags |= 1;
      reconcileChildren(current, workInProgress, nextProps, renderLanes);
      return workInProgress.child;
    }
    function updateClassComponent(
      current,
      workInProgress,
      Component,
      nextProps,
      renderLanes
    ) {
      switch (shouldErrorImpl(workInProgress)) {
        case !1:
          var _instance = workInProgress.stateNode,
            state = new workInProgress.type(
              workInProgress.memoizedProps,
              _instance.context
            ).state;
          _instance.updater.enqueueSetState(_instance, state, null);
          break;
        case !0:
          workInProgress.flags |= 128;
          workInProgress.flags |= 65536;
          _instance = Error("Simulated error coming from DevTools");
          var lane = renderLanes & -renderLanes;
          workInProgress.lanes |= lane;
          state = workInProgressRoot;
          if (null === state)
            throw Error(
              "Expected a work-in-progress root. This is a bug in React. Please file an issue."
            );
          lane = createClassErrorUpdate(lane);
          initializeClassErrorUpdate(
            lane,
            state,
            workInProgress,
            createCapturedValueAtFiber(_instance, workInProgress)
          );
          enqueueCapturedUpdate(workInProgress, lane);
      }
      prepareToReadContext(workInProgress);
      if (null === workInProgress.stateNode) {
        state = emptyContextObject;
        _instance = Component.contextType;
        "contextType" in Component &&
          null !== _instance &&
          (void 0 === _instance || _instance.$$typeof !== REACT_CONTEXT_TYPE) &&
          !didWarnAboutInvalidateContextType.has(Component) &&
          (didWarnAboutInvalidateContextType.add(Component),
          (lane =
            void 0 === _instance
              ? " However, it is set to undefined. This can be caused by a typo or by mixing up named and default imports. This can also happen due to a circular dependency, so try moving the createContext() call to a separate file."
              : "object" !== typeof _instance
                ? " However, it is set to a " + typeof _instance + "."
                : _instance.$$typeof === REACT_CONSUMER_TYPE
                  ? " Did you accidentally pass the Context.Consumer instead?"
                  : " However, it is set to an object with keys {" +
                    Object.keys(_instance).join(", ") +
                    "}."),
          console.error(
            "%s defines an invalid contextType. contextType should point to the Context object returned by React.createContext().%s",
            getComponentNameFromType(Component) || "Component",
            lane
          ));
        "object" === typeof _instance &&
          null !== _instance &&
          (state = readContext(_instance));
        _instance = new Component(nextProps, state);
        if (workInProgress.mode & StrictLegacyMode) {
          setIsStrictModeForDevtools(!0);
          try {
            _instance = new Component(nextProps, state);
          } finally {
            setIsStrictModeForDevtools(!1);
          }
        }
        state = workInProgress.memoizedState =
          null !== _instance.state && void 0 !== _instance.state
            ? _instance.state
            : null;
        _instance.updater = classComponentUpdater;
        workInProgress.stateNode = _instance;
        _instance._reactInternals = workInProgress;
        _instance._reactInternalInstance = fakeInternalInstance;
        "function" === typeof Component.getDerivedStateFromProps &&
          null === state &&
          ((state = getComponentNameFromType(Component) || "Component"),
          didWarnAboutUninitializedState.has(state) ||
            (didWarnAboutUninitializedState.add(state),
            console.error(
              "`%s` uses `getDerivedStateFromProps` but its initial state is %s. This is not recommended. Instead, define the initial state by assigning an object to `this.state` in the constructor of `%s`. This ensures that `getDerivedStateFromProps` arguments have a consistent shape.",
              state,
              null === _instance.state ? "null" : "undefined",
              state
            )));
        if (
          "function" === typeof Component.getDerivedStateFromProps ||
          "function" === typeof _instance.getSnapshotBeforeUpdate
        ) {
          var foundWillUpdateName = (lane = state = null);
          "function" === typeof _instance.componentWillMount &&
          !0 !== _instance.componentWillMount.__suppressDeprecationWarning
            ? (state = "componentWillMount")
            : "function" === typeof _instance.UNSAFE_componentWillMount &&
              (state = "UNSAFE_componentWillMount");
          "function" === typeof _instance.componentWillReceiveProps &&
          !0 !==
            _instance.componentWillReceiveProps.__suppressDeprecationWarning
            ? (lane = "componentWillReceiveProps")
            : "function" ===
                typeof _instance.UNSAFE_componentWillReceiveProps &&
              (lane = "UNSAFE_componentWillReceiveProps");
          "function" === typeof _instance.componentWillUpdate &&
          !0 !== _instance.componentWillUpdate.__suppressDeprecationWarning
            ? (foundWillUpdateName = "componentWillUpdate")
            : "function" === typeof _instance.UNSAFE_componentWillUpdate &&
              (foundWillUpdateName = "UNSAFE_componentWillUpdate");
          if (null !== state || null !== lane || null !== foundWillUpdateName) {
            _instance = getComponentNameFromType(Component) || "Component";
            var newApiName =
              "function" === typeof Component.getDerivedStateFromProps
                ? "getDerivedStateFromProps()"
                : "getSnapshotBeforeUpdate()";
            didWarnAboutLegacyLifecyclesAndDerivedState.has(_instance) ||
              (didWarnAboutLegacyLifecyclesAndDerivedState.add(_instance),
              console.error(
                "Unsafe legacy lifecycles will not be called for components using new component APIs.\n\n%s uses %s but also contains the following legacy lifecycles:%s%s%s\n\nThe above lifecycles should be removed. Learn more about this warning here:\nhttps://react.dev/link/unsafe-component-lifecycles",
                _instance,
                newApiName,
                null !== state ? "\n  " + state : "",
                null !== lane ? "\n  " + lane : "",
                null !== foundWillUpdateName ? "\n  " + foundWillUpdateName : ""
              ));
          }
        }
        _instance = workInProgress.stateNode;
        state = getComponentNameFromType(Component) || "Component";
        _instance.render ||
          (Component.prototype &&
          "function" === typeof Component.prototype.render
            ? console.error(
                "No `render` method found on the %s instance: did you accidentally return an object from the constructor?",
                state
              )
            : console.error(
                "No `render` method found on the %s instance: you may have forgotten to define `render`.",
                state
              ));
        !_instance.getInitialState ||
          _instance.getInitialState.isReactClassApproved ||
          _instance.state ||
          console.error(
            "getInitialState was defined on %s, a plain JavaScript class. This is only supported for classes created using React.createClass. Did you mean to define a state property instead?",
            state
          );
        _instance.getDefaultProps &&
          !_instance.getDefaultProps.isReactClassApproved &&
          console.error(
            "getDefaultProps was defined on %s, a plain JavaScript class. This is only supported for classes created using React.createClass. Use a static property to define defaultProps instead.",
            state
          );
        _instance.contextType &&
          console.error(
            "contextType was defined as an instance property on %s. Use a static property to define contextType instead.",
            state
          );
        Component.childContextTypes &&
          !didWarnAboutChildContextTypes.has(Component) &&
          (didWarnAboutChildContextTypes.add(Component),
          console.error(
            "%s uses the legacy childContextTypes API which was removed in React 19. Use React.createContext() instead. (https://react.dev/link/legacy-context)",
            state
          ));
        Component.contextTypes &&
          !didWarnAboutContextTypes$1.has(Component) &&
          (didWarnAboutContextTypes$1.add(Component),
          console.error(
            "%s uses the legacy contextTypes API which was removed in React 19. Use React.createContext() with static contextType instead. (https://react.dev/link/legacy-context)",
            state
          ));
        "function" === typeof _instance.componentShouldUpdate &&
          console.error(
            "%s has a method called componentShouldUpdate(). Did you mean shouldComponentUpdate()? The name is phrased as a question because the function is expected to return a value.",
            state
          );
        Component.prototype &&
          Component.prototype.isPureReactComponent &&
          "undefined" !== typeof _instance.shouldComponentUpdate &&
          console.error(
            "%s has a method called shouldComponentUpdate(). shouldComponentUpdate should not be used when extending React.PureComponent. Please extend React.Component if shouldComponentUpdate is used.",
            getComponentNameFromType(Component) || "A pure component"
          );
        "function" === typeof _instance.componentDidUnmount &&
          console.error(
            "%s has a method called componentDidUnmount(). But there is no such lifecycle method. Did you mean componentWillUnmount()?",
            state
          );
        "function" === typeof _instance.componentDidReceiveProps &&
          console.error(
            "%s has a method called componentDidReceiveProps(). But there is no such lifecycle method. If you meant to update the state in response to changing props, use componentWillReceiveProps(). If you meant to fetch data or run side-effects or mutations after React has updated the UI, use componentDidUpdate().",
            state
          );
        "function" === typeof _instance.componentWillRecieveProps &&
          console.error(
            "%s has a method called componentWillRecieveProps(). Did you mean componentWillReceiveProps()?",
            state
          );
        "function" === typeof _instance.UNSAFE_componentWillRecieveProps &&
          console.error(
            "%s has a method called UNSAFE_componentWillRecieveProps(). Did you mean UNSAFE_componentWillReceiveProps()?",
            state
          );
        lane = _instance.props !== nextProps;
        void 0 !== _instance.props &&
          lane &&
          console.error(
            "When calling super() in `%s`, make sure to pass up the same props that your component's constructor was passed.",
            state
          );
        _instance.defaultProps &&
          console.error(
            "Setting defaultProps as an instance property on %s is not supported and will be ignored. Instead, define defaultProps as a static property on %s.",
            state,
            state
          );
        "function" !== typeof _instance.getSnapshotBeforeUpdate ||
          "function" === typeof _instance.componentDidUpdate ||
          didWarnAboutGetSnapshotBeforeUpdateWithoutDidUpdate.has(Component) ||
          (didWarnAboutGetSnapshotBeforeUpdateWithoutDidUpdate.add(Component),
          console.error(
            "%s: getSnapshotBeforeUpdate() should be used with componentDidUpdate(). This component defines getSnapshotBeforeUpdate() only.",
            getComponentNameFromType(Component)
          ));
        "function" === typeof _instance.getDerivedStateFromProps &&
          console.error(
            "%s: getDerivedStateFromProps() is defined as an instance method and will be ignored. Instead, declare it as a static method.",
            state
          );
        "function" === typeof _instance.getDerivedStateFromError &&
          console.error(
            "%s: getDerivedStateFromError() is defined as an instance method and will be ignored. Instead, declare it as a static method.",
            state
          );
        "function" === typeof Component.getSnapshotBeforeUpdate &&
          console.error(
            "%s: getSnapshotBeforeUpdate() is defined as a static method and will be ignored. Instead, declare it as an instance method.",
            state
          );
        (lane = _instance.state) &&
          ("object" !== typeof lane || isArrayImpl(lane)) &&
          console.error("%s.state: must be set to an object or null", state);
        "function" === typeof _instance.getChildContext &&
          "object" !== typeof Component.childContextTypes &&
          console.error(
            "%s.getChildContext(): childContextTypes must be defined in order to use getChildContext().",
            state
          );
        _instance = workInProgress.stateNode;
        _instance.props = nextProps;
        _instance.state = workInProgress.memoizedState;
        _instance.refs = {};
        initializeUpdateQueue(workInProgress);
        state = Component.contextType;
        _instance.context =
          "object" === typeof state && null !== state
            ? readContext(state)
            : emptyContextObject;
        _instance.state === nextProps &&
          ((state = getComponentNameFromType(Component) || "Component"),
          didWarnAboutDirectlyAssigningPropsToState.has(state) ||
            (didWarnAboutDirectlyAssigningPropsToState.add(state),
            console.error(
              "%s: It is not recommended to assign props directly to state because updates to props won't be reflected in state. In most cases, it is better to use props directly.",
              state
            )));
        workInProgress.mode & StrictLegacyMode &&
          ReactStrictModeWarnings.recordLegacyContextWarning(
            workInProgress,
            _instance
          );
        ReactStrictModeWarnings.recordUnsafeLifecycleWarnings(
          workInProgress,
          _instance
        );
        _instance.state = workInProgress.memoizedState;
        state = Component.getDerivedStateFromProps;
        "function" === typeof state &&
          (applyDerivedStateFromProps(
            workInProgress,
            Component,
            state,
            nextProps
          ),
          (_instance.state = workInProgress.memoizedState));
        "function" === typeof Component.getDerivedStateFromProps ||
          "function" === typeof _instance.getSnapshotBeforeUpdate ||
          ("function" !== typeof _instance.UNSAFE_componentWillMount &&
            "function" !== typeof _instance.componentWillMount) ||
          ((state = _instance.state),
          "function" === typeof _instance.componentWillMount &&
            _instance.componentWillMount(),
          "function" === typeof _instance.UNSAFE_componentWillMount &&
            _instance.UNSAFE_componentWillMount(),
          state !== _instance.state &&
            (console.error(
              "%s.componentWillMount(): Assigning directly to this.state is deprecated (except inside a component's constructor). Use setState instead.",
              getComponentNameFromFiber(workInProgress) || "Component"
            ),
            classComponentUpdater.enqueueReplaceState(
              _instance,
              _instance.state,
              null
            )),
          processUpdateQueue(workInProgress, nextProps, _instance, renderLanes),
          suspendIfUpdateReadFromEntangledAsyncAction(),
          (_instance.state = workInProgress.memoizedState));
        "function" === typeof _instance.componentDidMount &&
          (workInProgress.flags |= 4194308);
        (workInProgress.mode & StrictEffectsMode) !== NoMode &&
          (workInProgress.flags |= 134217728);
        _instance = !0;
      } else if (null === current) {
        _instance = workInProgress.stateNode;
        var unresolvedOldProps = workInProgress.memoizedProps;
        lane = resolveClassComponentProps(Component, unresolvedOldProps);
        _instance.props = lane;
        var oldContext = _instance.context;
        foundWillUpdateName = Component.contextType;
        state = emptyContextObject;
        "object" === typeof foundWillUpdateName &&
          null !== foundWillUpdateName &&
          (state = readContext(foundWillUpdateName));
        newApiName = Component.getDerivedStateFromProps;
        foundWillUpdateName =
          "function" === typeof newApiName ||
          "function" === typeof _instance.getSnapshotBeforeUpdate;
        unresolvedOldProps = workInProgress.pendingProps !== unresolvedOldProps;
        foundWillUpdateName ||
          ("function" !== typeof _instance.UNSAFE_componentWillReceiveProps &&
            "function" !== typeof _instance.componentWillReceiveProps) ||
          ((unresolvedOldProps || oldContext !== state) &&
            callComponentWillReceiveProps(
              workInProgress,
              _instance,
              nextProps,
              state
            ));
        hasForceUpdate = !1;
        var oldState = workInProgress.memoizedState;
        _instance.state = oldState;
        processUpdateQueue(workInProgress, nextProps, _instance, renderLanes);
        suspendIfUpdateReadFromEntangledAsyncAction();
        oldContext = workInProgress.memoizedState;
        unresolvedOldProps || oldState !== oldContext || hasForceUpdate
          ? ("function" === typeof newApiName &&
              (applyDerivedStateFromProps(
                workInProgress,
                Component,
                newApiName,
                nextProps
              ),
              (oldContext = workInProgress.memoizedState)),
            (lane =
              hasForceUpdate ||
              checkShouldComponentUpdate(
                workInProgress,
                Component,
                lane,
                nextProps,
                oldState,
                oldContext,
                state
              ))
              ? (foundWillUpdateName ||
                  ("function" !== typeof _instance.UNSAFE_componentWillMount &&
                    "function" !== typeof _instance.componentWillMount) ||
                  ("function" === typeof _instance.componentWillMount &&
                    _instance.componentWillMount(),
                  "function" === typeof _instance.UNSAFE_componentWillMount &&
                    _instance.UNSAFE_componentWillMount()),
                "function" === typeof _instance.componentDidMount &&
                  (workInProgress.flags |= 4194308),
                (workInProgress.mode & StrictEffectsMode) !== NoMode &&
                  (workInProgress.flags |= 134217728))
              : ("function" === typeof _instance.componentDidMount &&
                  (workInProgress.flags |= 4194308),
                (workInProgress.mode & StrictEffectsMode) !== NoMode &&
                  (workInProgress.flags |= 134217728),
                (workInProgress.memoizedProps = nextProps),
                (workInProgress.memoizedState = oldContext)),
            (_instance.props = nextProps),
            (_instance.state = oldContext),
            (_instance.context = state),
            (_instance = lane))
          : ("function" === typeof _instance.componentDidMount &&
              (workInProgress.flags |= 4194308),
            (workInProgress.mode & StrictEffectsMode) !== NoMode &&
              (workInProgress.flags |= 134217728),
            (_instance = !1));
      } else {
        _instance = workInProgress.stateNode;
        cloneUpdateQueue(current, workInProgress);
        state = workInProgress.memoizedProps;
        foundWillUpdateName = resolveClassComponentProps(Component, state);
        _instance.props = foundWillUpdateName;
        newApiName = workInProgress.pendingProps;
        oldState = _instance.context;
        oldContext = Component.contextType;
        lane = emptyContextObject;
        "object" === typeof oldContext &&
          null !== oldContext &&
          (lane = readContext(oldContext));
        unresolvedOldProps = Component.getDerivedStateFromProps;
        (oldContext =
          "function" === typeof unresolvedOldProps ||
          "function" === typeof _instance.getSnapshotBeforeUpdate) ||
          ("function" !== typeof _instance.UNSAFE_componentWillReceiveProps &&
            "function" !== typeof _instance.componentWillReceiveProps) ||
          ((state !== newApiName || oldState !== lane) &&
            callComponentWillReceiveProps(
              workInProgress,
              _instance,
              nextProps,
              lane
            ));
        hasForceUpdate = !1;
        oldState = workInProgress.memoizedState;
        _instance.state = oldState;
        processUpdateQueue(workInProgress, nextProps, _instance, renderLanes);
        suspendIfUpdateReadFromEntangledAsyncAction();
        var newState = workInProgress.memoizedState;
        state !== newApiName ||
        oldState !== newState ||
        hasForceUpdate ||
        (null !== current &&
          null !== current.dependencies &&
          checkIfContextChanged(current.dependencies))
          ? ("function" === typeof unresolvedOldProps &&
              (applyDerivedStateFromProps(
                workInProgress,
                Component,
                unresolvedOldProps,
                nextProps
              ),
              (newState = workInProgress.memoizedState)),
            (foundWillUpdateName =
              hasForceUpdate ||
              checkShouldComponentUpdate(
                workInProgress,
                Component,
                foundWillUpdateName,
                nextProps,
                oldState,
                newState,
                lane
              ) ||
              (null !== current &&
                null !== current.dependencies &&
                checkIfContextChanged(current.dependencies)))
              ? (oldContext ||
                  ("function" !== typeof _instance.UNSAFE_componentWillUpdate &&
                    "function" !== typeof _instance.componentWillUpdate) ||
                  ("function" === typeof _instance.componentWillUpdate &&
                    _instance.componentWillUpdate(nextProps, newState, lane),
                  "function" === typeof _instance.UNSAFE_componentWillUpdate &&
                    _instance.UNSAFE_componentWillUpdate(
                      nextProps,
                      newState,
                      lane
                    )),
                "function" === typeof _instance.componentDidUpdate &&
                  (workInProgress.flags |= 4),
                "function" === typeof _instance.getSnapshotBeforeUpdate &&
                  (workInProgress.flags |= 1024))
              : ("function" !== typeof _instance.componentDidUpdate ||
                  (state === current.memoizedProps &&
                    oldState === current.memoizedState) ||
                  (workInProgress.flags |= 4),
                "function" !== typeof _instance.getSnapshotBeforeUpdate ||
                  (state === current.memoizedProps &&
                    oldState === current.memoizedState) ||
                  (workInProgress.flags |= 1024),
                (workInProgress.memoizedProps = nextProps),
                (workInProgress.memoizedState = newState)),
            (_instance.props = nextProps),
            (_instance.state = newState),
            (_instance.context = lane),
            (_instance = foundWillUpdateName))
          : ("function" !== typeof _instance.componentDidUpdate ||
              (state === current.memoizedProps &&
                oldState === current.memoizedState) ||
              (workInProgress.flags |= 4),
            "function" !== typeof _instance.getSnapshotBeforeUpdate ||
              (state === current.memoizedProps &&
                oldState === current.memoizedState) ||
              (workInProgress.flags |= 1024),
            (_instance = !1));
      }
      lane = _instance;
      markRef(current, workInProgress);
      state = 0 !== (workInProgress.flags & 128);
      if (lane || state) {
        lane = workInProgress.stateNode;
        setCurrentFiber(workInProgress);
        if (state && "function" !== typeof Component.getDerivedStateFromError)
          (Component = null), (profilerStartTime = -1);
        else if (
          ((Component = callRenderInDEV(lane)),
          workInProgress.mode & StrictLegacyMode)
        ) {
          setIsStrictModeForDevtools(!0);
          try {
            callRenderInDEV(lane);
          } finally {
            setIsStrictModeForDevtools(!1);
          }
        }
        workInProgress.flags |= 1;
        null !== current && state
          ? ((workInProgress.child = reconcileChildFibers(
              workInProgress,
              current.child,
              null,
              renderLanes
            )),
            (workInProgress.child = reconcileChildFibers(
              workInProgress,
              null,
              Component,
              renderLanes
            )))
          : reconcileChildren(current, workInProgress, Component, renderLanes);
        workInProgress.memoizedState = lane.state;
        current = workInProgress.child;
      } else
        current = bailoutOnAlreadyFinishedWork(
          current,
          workInProgress,
          renderLanes
        );
      renderLanes = workInProgress.stateNode;
      _instance &&
        renderLanes.props !== nextProps &&
        (didWarnAboutReassigningProps ||
          console.error(
            "It looks like %s is reassigning its own `this.props` while rendering. This is not supported and can lead to confusing bugs.",
            getComponentNameFromFiber(workInProgress) || "a component"
          ),
        (didWarnAboutReassigningProps = !0));
      return current;
    }
    function mountHostRootWithoutHydrating(
      current,
      workInProgress,
      nextChildren,
      renderLanes
    ) {
      resetHydrationState();
      workInProgress.flags |= 256;
      reconcileChildren(current, workInProgress, nextChildren, renderLanes);
      return workInProgress.child;
    }
    function validateFunctionComponentInDev(workInProgress, Component) {
      Component &&
        Component.childContextTypes &&
        console.error(
          "childContextTypes cannot be defined on a function component.\n  %s.childContextTypes = ...",
          Component.displayName || Component.name || "Component"
        );
      "function" === typeof Component.getDerivedStateFromProps &&
        ((workInProgress = getComponentNameFromType(Component) || "Unknown"),
        didWarnAboutGetDerivedStateOnFunctionComponent[workInProgress] ||
          (console.error(
            "%s: Function components do not support getDerivedStateFromProps.",
            workInProgress
          ),
          (didWarnAboutGetDerivedStateOnFunctionComponent[workInProgress] =
            !0)));
      "object" === typeof Component.contextType &&
        null !== Component.contextType &&
        ((Component = getComponentNameFromType(Component) || "Unknown"),
        didWarnAboutContextTypeOnFunctionComponent[Component] ||
          (console.error(
            "%s: Function components do not support contextType.",
            Component
          ),
          (didWarnAboutContextTypeOnFunctionComponent[Component] = !0)));
    }
    function mountSuspenseOffscreenState(renderLanes) {
      return { baseLanes: renderLanes, cachePool: getSuspendedCache() };
    }
    function getRemainingWorkInPrimaryTree(
      current,
      primaryTreeDidDefer,
      renderLanes
    ) {
      current = null !== current ? current.childLanes & ~renderLanes : 0;
      primaryTreeDidDefer && (current |= workInProgressDeferredLane);
      return current;
    }
    function updateSuspenseComponent(current, workInProgress, renderLanes) {
      var JSCompiler_object_inline_componentStack_3164;
      var JSCompiler_object_inline_stack_3163 = workInProgress.pendingProps;
      shouldSuspendImpl(workInProgress) && (workInProgress.flags |= 128);
      var JSCompiler_object_inline_digest_3162 = !1;
      var didSuspend = 0 !== (workInProgress.flags & 128);
      (JSCompiler_object_inline_componentStack_3164 = didSuspend) ||
        (JSCompiler_object_inline_componentStack_3164 =
          null !== current && null === current.memoizedState
            ? !1
            : 0 !== (suspenseStackCursor.current & ForceSuspenseFallback));
      JSCompiler_object_inline_componentStack_3164 &&
        ((JSCompiler_object_inline_digest_3162 = !0),
        (workInProgress.flags &= -129));
      JSCompiler_object_inline_componentStack_3164 =
        0 !== (workInProgress.flags & 32);
      workInProgress.flags &= -33;
      if (null === current) {
        if (isHydrating) {
          JSCompiler_object_inline_digest_3162
            ? pushPrimaryTreeSuspenseHandler(workInProgress)
            : reuseSuspenseHandlerOnStack(workInProgress);
          (current = nextHydratableInstance)
            ? ((renderLanes = canHydrateHydrationBoundary(
                current,
                rootOrSingletonContext
              )),
              (renderLanes =
                null !== renderLanes && renderLanes.data !== ACTIVITY_START_DATA
                  ? renderLanes
                  : null),
              null !== renderLanes &&
                ((JSCompiler_object_inline_componentStack_3164 = {
                  dehydrated: renderLanes,
                  treeContext: getSuspendedTreeContext(),
                  retryLane: 536870912,
                  hydrationErrors: null
                }),
                (workInProgress.memoizedState =
                  JSCompiler_object_inline_componentStack_3164),
                (JSCompiler_object_inline_componentStack_3164 =
                  createFiberFromDehydratedFragment(renderLanes)),
                (JSCompiler_object_inline_componentStack_3164.return =
                  workInProgress),
                (workInProgress.child =
                  JSCompiler_object_inline_componentStack_3164),
                (hydrationParentFiber = workInProgress),
                (nextHydratableInstance = null)))
            : (renderLanes = null);
          if (null === renderLanes)
            throw (
              (warnNonHydratedInstance(workInProgress, current),
              throwOnHydrationMismatch(workInProgress))
            );
          isSuspenseInstanceFallback(renderLanes)
            ? (workInProgress.lanes = 32)
            : (workInProgress.lanes = 536870912);
          return null;
        }
        var nextPrimaryChildren = JSCompiler_object_inline_stack_3163.children,
          nextFallbackChildren = JSCompiler_object_inline_stack_3163.fallback;
        if (JSCompiler_object_inline_digest_3162)
          return (
            reuseSuspenseHandlerOnStack(workInProgress),
            (JSCompiler_object_inline_stack_3163 =
              mountSuspenseFallbackChildren(
                workInProgress,
                nextPrimaryChildren,
                nextFallbackChildren,
                renderLanes
              )),
            (nextPrimaryChildren = workInProgress.child),
            (nextPrimaryChildren.memoizedState =
              mountSuspenseOffscreenState(renderLanes)),
            (nextPrimaryChildren.childLanes = getRemainingWorkInPrimaryTree(
              current,
              JSCompiler_object_inline_componentStack_3164,
              renderLanes
            )),
            (workInProgress.memoizedState = SUSPENDED_MARKER),
            JSCompiler_object_inline_stack_3163
          );
        if (
          "number" ===
          typeof JSCompiler_object_inline_stack_3163.unstable_expectedLoadTime
        )
          return (
            reuseSuspenseHandlerOnStack(workInProgress),
            (JSCompiler_object_inline_stack_3163 =
              mountSuspenseFallbackChildren(
                workInProgress,
                nextPrimaryChildren,
                nextFallbackChildren,
                renderLanes
              )),
            (nextPrimaryChildren = workInProgress.child),
            (nextPrimaryChildren.memoizedState =
              mountSuspenseOffscreenState(renderLanes)),
            (nextPrimaryChildren.childLanes = getRemainingWorkInPrimaryTree(
              current,
              JSCompiler_object_inline_componentStack_3164,
              renderLanes
            )),
            (workInProgress.memoizedState = SUSPENDED_MARKER),
            (workInProgress.lanes = 4194304),
            JSCompiler_object_inline_stack_3163
          );
        pushPrimaryTreeSuspenseHandler(workInProgress);
        return mountSuspensePrimaryChildren(
          workInProgress,
          nextPrimaryChildren
        );
      }
      var prevState = current.memoizedState;
      if (null !== prevState) {
        var JSCompiler_object_inline_message_3161 = prevState.dehydrated;
        if (null !== JSCompiler_object_inline_message_3161) {
          if (didSuspend)
            workInProgress.flags & 256
              ? (pushPrimaryTreeSuspenseHandler(workInProgress),
                (workInProgress.flags &= -257),
                (workInProgress = retrySuspenseComponentWithoutHydrating(
                  current,
                  workInProgress,
                  renderLanes
                )))
              : null !== workInProgress.memoizedState
                ? (reuseSuspenseHandlerOnStack(workInProgress),
                  (workInProgress.child = current.child),
                  (workInProgress.flags |= 128),
                  (workInProgress = null))
                : (reuseSuspenseHandlerOnStack(workInProgress),
                  (nextPrimaryChildren =
                    JSCompiler_object_inline_stack_3163.fallback),
                  (nextFallbackChildren = workInProgress.mode),
                  (JSCompiler_object_inline_stack_3163 =
                    mountWorkInProgressOffscreenFiber(
                      {
                        mode: "visible",
                        children: JSCompiler_object_inline_stack_3163.children
                      },
                      nextFallbackChildren
                    )),
                  (nextPrimaryChildren = createFiberFromFragment(
                    nextPrimaryChildren,
                    nextFallbackChildren,
                    renderLanes,
                    null
                  )),
                  (nextPrimaryChildren.flags |= 2),
                  (JSCompiler_object_inline_stack_3163.return = workInProgress),
                  (nextPrimaryChildren.return = workInProgress),
                  (JSCompiler_object_inline_stack_3163.sibling =
                    nextPrimaryChildren),
                  (workInProgress.child = JSCompiler_object_inline_stack_3163),
                  reconcileChildFibers(
                    workInProgress,
                    current.child,
                    null,
                    renderLanes
                  ),
                  (JSCompiler_object_inline_stack_3163 = workInProgress.child),
                  (JSCompiler_object_inline_stack_3163.memoizedState =
                    mountSuspenseOffscreenState(renderLanes)),
                  (JSCompiler_object_inline_stack_3163.childLanes =
                    getRemainingWorkInPrimaryTree(
                      current,
                      JSCompiler_object_inline_componentStack_3164,
                      renderLanes
                    )),
                  (workInProgress.memoizedState = SUSPENDED_MARKER),
                  (workInProgress = nextPrimaryChildren));
          else if (
            (pushPrimaryTreeSuspenseHandler(workInProgress),
            warnIfHydrating(),
            isSuspenseInstanceFallback(JSCompiler_object_inline_message_3161))
          ) {
            JSCompiler_object_inline_componentStack_3164 =
              JSCompiler_object_inline_message_3161.nextSibling &&
              JSCompiler_object_inline_message_3161.nextSibling.dataset;
            if (JSCompiler_object_inline_componentStack_3164) {
              nextPrimaryChildren =
                JSCompiler_object_inline_componentStack_3164.dgst;
              var message = JSCompiler_object_inline_componentStack_3164.msg;
              nextFallbackChildren =
                JSCompiler_object_inline_componentStack_3164.stck;
              var componentStack =
                JSCompiler_object_inline_componentStack_3164.cstck;
            }
            JSCompiler_object_inline_message_3161 = message;
            JSCompiler_object_inline_digest_3162 = nextPrimaryChildren;
            JSCompiler_object_inline_stack_3163 = nextFallbackChildren;
            JSCompiler_object_inline_componentStack_3164 = componentStack;
            nextPrimaryChildren = JSCompiler_object_inline_digest_3162;
            nextFallbackChildren = JSCompiler_object_inline_message_3161;
            componentStack = JSCompiler_object_inline_componentStack_3164;
            "POSTPONE" !== nextPrimaryChildren &&
              ((JSCompiler_object_inline_componentStack_3164 =
                nextFallbackChildren
                  ? Error(nextFallbackChildren)
                  : Error(
                      "The server could not finish this Suspense boundary, likely due to an error during server rendering. Switched to client rendering."
                    )),
              (JSCompiler_object_inline_componentStack_3164.stack =
                JSCompiler_object_inline_stack_3163 || ""),
              (JSCompiler_object_inline_componentStack_3164.digest =
                nextPrimaryChildren),
              (JSCompiler_object_inline_stack_3163 =
                void 0 === componentStack ? null : componentStack),
              (nextPrimaryChildren = {
                value: JSCompiler_object_inline_componentStack_3164,
                source: null,
                stack: JSCompiler_object_inline_stack_3163
              }),
              "string" === typeof JSCompiler_object_inline_stack_3163 &&
                CapturedStacks.set(
                  JSCompiler_object_inline_componentStack_3164,
                  nextPrimaryChildren
                ),
              queueHydrationError(nextPrimaryChildren));
            workInProgress = retrySuspenseComponentWithoutHydrating(
              current,
              workInProgress,
              renderLanes
            );
          } else if (
            (didReceiveUpdate ||
              propagateParentContextChanges(
                current,
                workInProgress,
                renderLanes,
                !1
              ),
            (JSCompiler_object_inline_componentStack_3164 =
              0 !== (renderLanes & current.childLanes)),
            didReceiveUpdate || JSCompiler_object_inline_componentStack_3164)
          ) {
            JSCompiler_object_inline_componentStack_3164 = workInProgressRoot;
            if (
              null !== JSCompiler_object_inline_componentStack_3164 &&
              ((JSCompiler_object_inline_stack_3163 = getBumpedLaneForHydration(
                JSCompiler_object_inline_componentStack_3164,
                renderLanes
              )),
              0 !== JSCompiler_object_inline_stack_3163 &&
                JSCompiler_object_inline_stack_3163 !== prevState.retryLane)
            )
              throw (
                ((prevState.retryLane = JSCompiler_object_inline_stack_3163),
                enqueueConcurrentRenderForLane(
                  current,
                  JSCompiler_object_inline_stack_3163
                ),
                scheduleUpdateOnFiber(
                  JSCompiler_object_inline_componentStack_3164,
                  current,
                  JSCompiler_object_inline_stack_3163
                ),
                SelectiveHydrationException)
              );
            isSuspenseInstancePending(JSCompiler_object_inline_message_3161) ||
              renderDidSuspendDelayIfPossible();
            workInProgress = retrySuspenseComponentWithoutHydrating(
              current,
              workInProgress,
              renderLanes
            );
          } else
            isSuspenseInstancePending(JSCompiler_object_inline_message_3161)
              ? ((workInProgress.flags |= 192),
                (workInProgress.child = current.child),
                (workInProgress = null))
              : ((current = prevState.treeContext),
                (nextHydratableInstance = getNextHydratable(
                  JSCompiler_object_inline_message_3161.nextSibling
                )),
                (hydrationParentFiber = workInProgress),
                (isHydrating = !0),
                (hydrationErrors = null),
                (didSuspendOrErrorDEV = !1),
                (hydrationDiffRootDEV = null),
                (rootOrSingletonContext = !1),
                null !== current &&
                  restoreSuspendedTreeContext(workInProgress, current),
                (workInProgress = mountSuspensePrimaryChildren(
                  workInProgress,
                  JSCompiler_object_inline_stack_3163.children
                )),
                (workInProgress.flags |= 4096));
          return workInProgress;
        }
      }
      if (JSCompiler_object_inline_digest_3162)
        return (
          reuseSuspenseHandlerOnStack(workInProgress),
          (nextPrimaryChildren = JSCompiler_object_inline_stack_3163.fallback),
          (nextFallbackChildren = workInProgress.mode),
          (componentStack = current.child),
          (JSCompiler_object_inline_message_3161 = componentStack.sibling),
          (JSCompiler_object_inline_stack_3163 = createWorkInProgress(
            componentStack,
            {
              mode: "hidden",
              children: JSCompiler_object_inline_stack_3163.children
            }
          )),
          (JSCompiler_object_inline_stack_3163.subtreeFlags =
            componentStack.subtreeFlags & 65011712),
          null !== JSCompiler_object_inline_message_3161
            ? (nextPrimaryChildren = createWorkInProgress(
                JSCompiler_object_inline_message_3161,
                nextPrimaryChildren
              ))
            : ((nextPrimaryChildren = createFiberFromFragment(
                nextPrimaryChildren,
                nextFallbackChildren,
                renderLanes,
                null
              )),
              (nextPrimaryChildren.flags |= 2)),
          (nextPrimaryChildren.return = workInProgress),
          (JSCompiler_object_inline_stack_3163.return = workInProgress),
          (JSCompiler_object_inline_stack_3163.sibling = nextPrimaryChildren),
          (workInProgress.child = JSCompiler_object_inline_stack_3163),
          (JSCompiler_object_inline_stack_3163 = nextPrimaryChildren),
          (nextPrimaryChildren = workInProgress.child),
          (nextFallbackChildren = current.child.memoizedState),
          null === nextFallbackChildren
            ? (nextFallbackChildren = mountSuspenseOffscreenState(renderLanes))
            : ((componentStack = nextFallbackChildren.cachePool),
              null !== componentStack
                ? ((JSCompiler_object_inline_message_3161 =
                    CacheContext._currentValue),
                  (componentStack =
                    componentStack.parent !==
                    JSCompiler_object_inline_message_3161
                      ? {
                          parent: JSCompiler_object_inline_message_3161,
                          pool: JSCompiler_object_inline_message_3161
                        }
                      : componentStack))
                : (componentStack = getSuspendedCache()),
              (nextFallbackChildren = {
                baseLanes: nextFallbackChildren.baseLanes | renderLanes,
                cachePool: componentStack
              })),
          (nextPrimaryChildren.memoizedState = nextFallbackChildren),
          (nextPrimaryChildren.childLanes = getRemainingWorkInPrimaryTree(
            current,
            JSCompiler_object_inline_componentStack_3164,
            renderLanes
          )),
          (workInProgress.memoizedState = SUSPENDED_MARKER),
          JSCompiler_object_inline_stack_3163
        );
      pushPrimaryTreeSuspenseHandler(workInProgress);
      renderLanes = current.child;
      current = renderLanes.sibling;
      renderLanes = createWorkInProgress(renderLanes, {
        mode: "visible",
        children: JSCompiler_object_inline_stack_3163.children
      });
      renderLanes.return = workInProgress;
      renderLanes.sibling = null;
      null !== current &&
        ((JSCompiler_object_inline_componentStack_3164 =
          workInProgress.deletions),
        null === JSCompiler_object_inline_componentStack_3164
          ? ((workInProgress.deletions = [current]),
            (workInProgress.flags |= 16))
          : JSCompiler_object_inline_componentStack_3164.push(current));
      workInProgress.child = renderLanes;
      workInProgress.memoizedState = null;
      return renderLanes;
    }
    function mountSuspensePrimaryChildren(workInProgress, primaryChildren) {
      primaryChildren = mountWorkInProgressOffscreenFiber(
        { mode: "visible", children: primaryChildren },
        workInProgress.mode
      );
      primaryChildren.return = workInProgress;
      return (workInProgress.child = primaryChildren);
    }
    function mountSuspenseFallbackChildren(
      workInProgress,
      primaryChildren,
      fallbackChildren,
      renderLanes
    ) {
      var mode = workInProgress.mode;
      primaryChildren = mountWorkInProgressOffscreenFiber(
        { mode: "hidden", children: primaryChildren },
        mode
      );
      fallbackChildren = createFiberFromFragment(
        fallbackChildren,
        mode,
        renderLanes,
        null
      );
      primaryChildren.return = workInProgress;
      fallbackChildren.return = workInProgress;
      primaryChildren.sibling = fallbackChildren;
      workInProgress.child = primaryChildren;
      return fallbackChildren;
    }
    function mountWorkInProgressOffscreenFiber(offscreenProps, mode) {
      offscreenProps = createFiber(22, offscreenProps, null, mode);
      offscreenProps.lanes = 0;
      offscreenProps.stateNode = {
        _visibility: OffscreenVisible,
        _pendingMarkers: null,
        _retryCache: null,
        _transitions: null
      };
      return offscreenProps;
    }
    function retrySuspenseComponentWithoutHydrating(
      current,
      workInProgress,
      renderLanes
    ) {
      reconcileChildFibers(workInProgress, current.child, null, renderLanes);
      current = mountSuspensePrimaryChildren(
        workInProgress,
        workInProgress.pendingProps.children
      );
      current.flags |= 2;
      workInProgress.memoizedState = null;
      return current;
    }
    function scheduleSuspenseWorkOnFiber(fiber, renderLanes, propagationRoot) {
      fiber.lanes |= renderLanes;
      var alternate = fiber.alternate;
      null !== alternate && (alternate.lanes |= renderLanes);
      scheduleContextWorkOnParentPath(
        fiber.return,
        renderLanes,
        propagationRoot
      );
    }
    function initSuspenseListRenderState(
      workInProgress,
      isBackwards,
      tail,
      lastContentRow,
      tailMode,
      treeForkCount
    ) {
      var renderState = workInProgress.memoizedState;
      null === renderState
        ? (workInProgress.memoizedState = {
            isBackwards: isBackwards,
            rendering: null,
            renderingStartTime: 0,
            last: lastContentRow,
            tail: tail,
            tailMode: tailMode,
            treeForkCount: treeForkCount
          })
        : ((renderState.isBackwards = isBackwards),
          (renderState.rendering = null),
          (renderState.renderingStartTime = 0),
          (renderState.last = lastContentRow),
          (renderState.tail = tail),
          (renderState.tailMode = tailMode),
          (renderState.treeForkCount = treeForkCount));
    }
    function updateSuspenseListComponent(current, workInProgress, renderLanes) {
      var nextProps = workInProgress.pendingProps,
        revealOrder = nextProps.revealOrder,
        tailMode = nextProps.tail,
        newChildren = nextProps.children,
        suspenseContext = suspenseStackCursor.current;
      (nextProps = 0 !== (suspenseContext & ForceSuspenseFallback))
        ? ((suspenseContext =
            (suspenseContext & SubtreeSuspenseContextMask) |
            ForceSuspenseFallback),
          (workInProgress.flags |= 128))
        : (suspenseContext &= SubtreeSuspenseContextMask);
      push(suspenseStackCursor, suspenseContext, workInProgress);
      suspenseContext = null == revealOrder ? "null" : revealOrder;
      if (
        "forwards" !== revealOrder &&
        "unstable_legacy-backwards" !== revealOrder &&
        "together" !== revealOrder &&
        "independent" !== revealOrder &&
        !didWarnAboutRevealOrder[suspenseContext]
      )
        if (
          ((didWarnAboutRevealOrder[suspenseContext] = !0), null == revealOrder)
        )
          console.error(
            'The default for the <SuspenseList revealOrder="..."> prop is changing. To be future compatible you must explictly specify either "independent" (the current default), "together", "forwards" or "legacy_unstable-backwards".'
          );
        else if ("backwards" === revealOrder)
          console.error(
            'The rendering order of <SuspenseList revealOrder="backwards"> is changing. To be future compatible you must specify revealOrder="legacy_unstable-backwards" instead.'
          );
        else if ("string" === typeof revealOrder)
          switch (revealOrder.toLowerCase()) {
            case "together":
            case "forwards":
            case "backwards":
            case "independent":
              console.error(
                '"%s" is not a valid value for revealOrder on <SuspenseList />. Use lowercase "%s" instead.',
                revealOrder,
                revealOrder.toLowerCase()
              );
              break;
            case "forward":
            case "backward":
              console.error(
                '"%s" is not a valid value for revealOrder on <SuspenseList />. React uses the -s suffix in the spelling. Use "%ss" instead.',
                revealOrder,
                revealOrder.toLowerCase()
              );
              break;
            default:
              console.error(
                '"%s" is not a supported revealOrder on <SuspenseList />. Did you mean "independent", "together", "forwards" or "backwards"?',
                revealOrder
              );
          }
        else
          console.error(
            '%s is not a supported value for revealOrder on <SuspenseList />. Did you mean "independent", "together", "forwards" or "backwards"?',
            revealOrder
          );
      suspenseContext = null == tailMode ? "null" : tailMode;
      if (!didWarnAboutTailOptions[suspenseContext])
        if (null == tailMode) {
          if (
            "forwards" === revealOrder ||
            "backwards" === revealOrder ||
            "unstable_legacy-backwards" === revealOrder
          )
            (didWarnAboutTailOptions[suspenseContext] = !0),
              console.error(
                'The default for the <SuspenseList tail="..."> prop is changing. To be future compatible you must explictly specify either "visible" (the current default), "collapsed" or "hidden".'
              );
        } else
          "visible" !== tailMode &&
          "collapsed" !== tailMode &&
          "hidden" !== tailMode
            ? ((didWarnAboutTailOptions[suspenseContext] = !0),
              console.error(
                '"%s" is not a supported value for tail on <SuspenseList />. Did you mean "visible", "collapsed" or "hidden"?',
                tailMode
              ))
            : "forwards" !== revealOrder &&
              "backwards" !== revealOrder &&
              "unstable_legacy-backwards" !== revealOrder &&
              ((didWarnAboutTailOptions[suspenseContext] = !0),
              console.error(
                '<SuspenseList tail="%s" /> is only valid if revealOrder is "forwards" or "backwards". Did you mean to specify revealOrder="forwards"?',
                tailMode
              ));
      a: if (
        ("forwards" === revealOrder ||
          "backwards" === revealOrder ||
          "unstable_legacy-backwards" === revealOrder) &&
        void 0 !== newChildren &&
        null !== newChildren &&
        !1 !== newChildren
      )
        if (isArrayImpl(newChildren))
          for (
            suspenseContext = 0;
            suspenseContext < newChildren.length;
            suspenseContext++
          ) {
            if (
              !validateSuspenseListNestedChild(
                newChildren[suspenseContext],
                suspenseContext
              )
            )
              break a;
          }
        else if (
          ((suspenseContext = getIteratorFn(newChildren)),
          "function" === typeof suspenseContext)
        ) {
          if ((suspenseContext = suspenseContext.call(newChildren)))
            for (
              var step = suspenseContext.next(), _i = 0;
              !step.done;
              step = suspenseContext.next()
            ) {
              if (!validateSuspenseListNestedChild(step.value, _i)) break a;
              _i++;
            }
        } else
          "function" !== typeof newChildren[ASYNC_ITERATOR] &&
            (newChildren.$$typeof !== REACT_ELEMENT_TYPE ||
            "function" !== typeof newChildren.type ||
            ("[object GeneratorFunction]" !==
              Object.prototype.toString.call(newChildren.type) &&
              "[object AsyncGeneratorFunction]" !==
                Object.prototype.toString.call(newChildren.type))
              ? console.error(
                  'A single row was passed to a <SuspenseList revealOrder="%s" />. This is not useful since it needs multiple rows. Did you mean to pass multiple children or an array?',
                  revealOrder
                )
              : console.error(
                  'A generator Component was passed to a <SuspenseList revealOrder="%s" />. This is not supported as a way to generate lists. Instead, pass an iterable as the children.',
                  revealOrder
                ));
      reconcileChildren(current, workInProgress, newChildren, renderLanes);
      isHydrating
        ? (warnIfNotHydrating(), (newChildren = treeForkCount))
        : (newChildren = 0);
      if (!nextProps && null !== current && 0 !== (current.flags & 128))
        a: for (current = workInProgress.child; null !== current; ) {
          if (13 === current.tag)
            null !== current.memoizedState &&
              scheduleSuspenseWorkOnFiber(current, renderLanes, workInProgress);
          else if (19 === current.tag)
            scheduleSuspenseWorkOnFiber(current, renderLanes, workInProgress);
          else if (null !== current.child) {
            current.child.return = current;
            current = current.child;
            continue;
          }
          if (current === workInProgress) break a;
          for (; null === current.sibling; ) {
            if (null === current.return || current.return === workInProgress)
              break a;
            current = current.return;
          }
          current.sibling.return = current.return;
          current = current.sibling;
        }
      switch (revealOrder) {
        case "forwards":
          renderLanes = workInProgress.child;
          for (revealOrder = null; null !== renderLanes; )
            (current = renderLanes.alternate),
              null !== current &&
                null === findFirstSuspended(current) &&
                (revealOrder = renderLanes),
              (renderLanes = renderLanes.sibling);
          renderLanes = revealOrder;
          null === renderLanes
            ? ((revealOrder = workInProgress.child),
              (workInProgress.child = null))
            : ((revealOrder = renderLanes.sibling),
              (renderLanes.sibling = null));
          initSuspenseListRenderState(
            workInProgress,
            !1,
            revealOrder,
            renderLanes,
            tailMode,
            newChildren
          );
          break;
        case "backwards":
        case "unstable_legacy-backwards":
          renderLanes = null;
          revealOrder = workInProgress.child;
          for (workInProgress.child = null; null !== revealOrder; ) {
            current = revealOrder.alternate;
            if (null !== current && null === findFirstSuspended(current)) {
              workInProgress.child = revealOrder;
              break;
            }
            current = revealOrder.sibling;
            revealOrder.sibling = renderLanes;
            renderLanes = revealOrder;
            revealOrder = current;
          }
          initSuspenseListRenderState(
            workInProgress,
            !0,
            renderLanes,
            null,
            tailMode,
            newChildren
          );
          break;
        case "together":
          initSuspenseListRenderState(
            workInProgress,
            !1,
            null,
            null,
            void 0,
            newChildren
          );
          break;
        default:
          workInProgress.memoizedState = null;
      }
      return workInProgress.child;
    }
    function bailoutOnAlreadyFinishedWork(
      current,
      workInProgress,
      renderLanes
    ) {
      null !== current && (workInProgress.dependencies = current.dependencies);
      profilerStartTime = -1;
      workInProgressRootSkippedLanes |= workInProgress.lanes;
      if (0 === (renderLanes & workInProgress.childLanes))
        if (null !== current) {
          if (
            (propagateParentContextChanges(
              current,
              workInProgress,
              renderLanes,
              !1
            ),
            0 === (renderLanes & workInProgress.childLanes))
          )
            return null;
        } else return null;
      if (null !== current && workInProgress.child !== current.child)
        throw Error("Resuming work not yet implemented.");
      if (null !== workInProgress.child) {
        current = workInProgress.child;
        renderLanes = createWorkInProgress(current, current.pendingProps);
        workInProgress.child = renderLanes;
        for (renderLanes.return = workInProgress; null !== current.sibling; )
          (current = current.sibling),
            (renderLanes = renderLanes.sibling =
              createWorkInProgress(current, current.pendingProps)),
            (renderLanes.return = workInProgress);
        renderLanes.sibling = null;
      }
      return workInProgress.child;
    }
    function checkScheduledUpdateOrContext(current, renderLanes) {
      if (0 !== (current.lanes & renderLanes)) return !0;
      current = current.dependencies;
      return null !== current && checkIfContextChanged(current) ? !0 : !1;
    }
    function attemptEarlyBailoutIfNoScheduledUpdate(
      current,
      workInProgress,
      renderLanes
    ) {
      switch (workInProgress.tag) {
        case 3:
          pushHostContainer(
            workInProgress,
            workInProgress.stateNode.containerInfo
          );
          pushProvider(
            workInProgress,
            CacheContext,
            current.memoizedState.cache
          );
          resetHydrationState();
          break;
        case 27:
        case 5:
          pushHostContext(workInProgress);
          break;
        case 4:
          pushHostContainer(
            workInProgress,
            workInProgress.stateNode.containerInfo
          );
          break;
        case 10:
          pushProvider(
            workInProgress,
            workInProgress.type,
            workInProgress.memoizedProps.value
          );
          break;
        case 12:
          0 !== (renderLanes & workInProgress.childLanes) &&
            (workInProgress.flags |= 4);
          workInProgress.flags |= 2048;
          var stateNode = workInProgress.stateNode;
          stateNode.effectDuration = -0;
          stateNode.passiveEffectDuration = -0;
          break;
        case 31:
          if (null !== workInProgress.memoizedState)
            return (
              (workInProgress.flags |= 128),
              pushDehydratedActivitySuspenseHandler(workInProgress),
              null
            );
          break;
        case 13:
          stateNode = workInProgress.memoizedState;
          if (null !== stateNode) {
            if (null !== stateNode.dehydrated)
              return (
                pushPrimaryTreeSuspenseHandler(workInProgress),
                (workInProgress.flags |= 128),
                null
              );
            if (0 !== (renderLanes & workInProgress.child.childLanes))
              return updateSuspenseComponent(
                current,
                workInProgress,
                renderLanes
              );
            pushPrimaryTreeSuspenseHandler(workInProgress);
            current = bailoutOnAlreadyFinishedWork(
              current,
              workInProgress,
              renderLanes
            );
            return null !== current ? current.sibling : null;
          }
          pushPrimaryTreeSuspenseHandler(workInProgress);
          break;
        case 19:
          var didSuspendBefore = 0 !== (current.flags & 128);
          stateNode = 0 !== (renderLanes & workInProgress.childLanes);
          stateNode ||
            (propagateParentContextChanges(
              current,
              workInProgress,
              renderLanes,
              !1
            ),
            (stateNode = 0 !== (renderLanes & workInProgress.childLanes)));
          if (didSuspendBefore) {
            if (stateNode)
              return updateSuspenseListComponent(
                current,
                workInProgress,
                renderLanes
              );
            workInProgress.flags |= 128;
          }
          didSuspendBefore = workInProgress.memoizedState;
          null !== didSuspendBefore &&
            ((didSuspendBefore.rendering = null),
            (didSuspendBefore.tail = null),
            (didSuspendBefore.lastEffect = null));
          push(
            suspenseStackCursor,
            suspenseStackCursor.current,
            workInProgress
          );
          if (stateNode) break;
          else return null;
        case 22:
          return (
            (workInProgress.lanes = 0),
            updateOffscreenComponent(
              current,
              workInProgress,
              renderLanes,
              workInProgress.pendingProps
            )
          );
        case 24:
          pushProvider(
            workInProgress,
            CacheContext,
            current.memoizedState.cache
          );
      }
      return bailoutOnAlreadyFinishedWork(current, workInProgress, renderLanes);
    }
    function beginWork(current, workInProgress, renderLanes) {
      if (workInProgress._debugNeedsRemount && null !== current) {
        var copiedFiber = createFiberFromTypeAndProps(
          workInProgress.type,
          workInProgress.key,
          workInProgress.pendingProps,
          workInProgress._debugOwner || null,
          workInProgress.mode,
          workInProgress.lanes
        );
        copiedFiber._debugStack = workInProgress._debugStack;
        copiedFiber._debugTask = workInProgress._debugTask;
        var returnFiber = workInProgress.return;
        if (null === returnFiber) throw Error("Cannot swap the root fiber.");
        current.alternate = null;
        workInProgress.alternate = null;
        copiedFiber.index = workInProgress.index;
        copiedFiber.sibling = workInProgress.sibling;
        copiedFiber.return = workInProgress.return;
        copiedFiber.ref = workInProgress.ref;
        copiedFiber._debugInfo = workInProgress._debugInfo;
        if (workInProgress === returnFiber.child)
          returnFiber.child = copiedFiber;
        else {
          var prevSibling = returnFiber.child;
          if (null === prevSibling)
            throw Error("Expected parent to have a child.");
          for (; prevSibling.sibling !== workInProgress; )
            if (((prevSibling = prevSibling.sibling), null === prevSibling))
              throw Error("Expected to find the previous sibling.");
          prevSibling.sibling = copiedFiber;
        }
        var deletions = returnFiber.deletions;
        null === deletions
          ? ((returnFiber.deletions = [current]), (returnFiber.flags |= 16))
          : deletions.push(current);
        copiedFiber.flags |= 2;
        return copiedFiber;
      }
      if (null !== current)
        if (
          current.memoizedProps !== workInProgress.pendingProps ||
          workInProgress.type !== current.type
        )
          didReceiveUpdate = !0;
        else {
          if (
            !checkScheduledUpdateOrContext(current, renderLanes) &&
            0 === (workInProgress.flags & 128)
          )
            return (
              (didReceiveUpdate = !1),
              attemptEarlyBailoutIfNoScheduledUpdate(
                current,
                workInProgress,
                renderLanes
              )
            );
          didReceiveUpdate = 0 !== (current.flags & 131072) ? !0 : !1;
        }
      else {
        didReceiveUpdate = !1;
        var JSCompiler_temp;
        if ((JSCompiler_temp = isHydrating))
          warnIfNotHydrating(),
            (JSCompiler_temp = 0 !== (workInProgress.flags & 1048576));
        if (JSCompiler_temp) {
          var slotIndex = workInProgress.index;
          warnIfNotHydrating();
          pushTreeId(workInProgress, treeForkCount, slotIndex);
        }
      }
      workInProgress.lanes = 0;
      switch (workInProgress.tag) {
        case 16:
          a: {
            var props = workInProgress.pendingProps;
            var Component = callLazyInitInDEV(workInProgress.elementType);
            workInProgress.type = Component;
            if ("function" === typeof Component)
              if (shouldConstruct(Component)) {
                var resolvedProps = resolveClassComponentProps(
                  Component,
                  props
                );
                workInProgress.tag = 1;
                workInProgress.type = Component =
                  resolveFunctionForHotReloading(Component);
                var JSCompiler_inline_result = updateClassComponent(
                  null,
                  workInProgress,
                  Component,
                  resolvedProps,
                  renderLanes
                );
              } else
                (workInProgress.tag = 0),
                  validateFunctionComponentInDev(workInProgress, Component),
                  (workInProgress.type = Component =
                    resolveFunctionForHotReloading(Component)),
                  (JSCompiler_inline_result = updateFunctionComponent(
                    null,
                    workInProgress,
                    Component,
                    props,
                    renderLanes
                  ));
            else {
              if (void 0 !== Component && null !== Component) {
                var $$typeof = Component.$$typeof;
                if ($$typeof === REACT_FORWARD_REF_TYPE) {
                  workInProgress.tag = 11;
                  workInProgress.type = Component =
                    resolveForwardRefForHotReloading(Component);
                  JSCompiler_inline_result = updateForwardRef(
                    null,
                    workInProgress,
                    Component,
                    props,
                    renderLanes
                  );
                  break a;
                } else if ($$typeof === REACT_MEMO_TYPE) {
                  workInProgress.tag = 14;
                  JSCompiler_inline_result = updateMemoComponent(
                    null,
                    workInProgress,
                    Component,
                    props,
                    renderLanes
                  );
                  break a;
                }
              }
              var hint = "";
              null !== Component &&
                "object" === typeof Component &&
                Component.$$typeof === REACT_LAZY_TYPE &&
                (hint =
                  " Did you wrap a component in React.lazy() more than once?");
              var loggedComponent =
                getComponentNameFromType(Component) || Component;
              throw Error(
                "Element type is invalid. Received a promise that resolves to: " +
                  loggedComponent +
                  ". Lazy element type must resolve to a class or function." +
                  hint
              );
            }
          }
          return JSCompiler_inline_result;
        case 0:
          return updateFunctionComponent(
            current,
            workInProgress,
            workInProgress.type,
            workInProgress.pendingProps,
            renderLanes
          );
        case 1:
          var _Component = workInProgress.type,
            resolvedProps$jscomp$0 = resolveClassComponentProps(
              _Component,
              workInProgress.pendingProps
            );
          return updateClassComponent(
            current,
            workInProgress,
            _Component,
            resolvedProps$jscomp$0,
            renderLanes
          );
        case 3:
          a: {
            pushHostContainer(
              workInProgress,
              workInProgress.stateNode.containerInfo
            );
            if (null === current)
              throw Error(
                "Should have a current fiber. This is a bug in React."
              );
            var nextProps = workInProgress.pendingProps,
              prevState = workInProgress.memoizedState,
              prevChildren = prevState.element;
            cloneUpdateQueue(current, workInProgress);
            processUpdateQueue(workInProgress, nextProps, null, renderLanes);
            var nextState = workInProgress.memoizedState,
              nextCache = nextState.cache;
            pushProvider(workInProgress, CacheContext, nextCache);
            nextCache !== prevState.cache &&
              propagateContextChanges(
                workInProgress,
                [CacheContext],
                renderLanes,
                !0
              );
            suspendIfUpdateReadFromEntangledAsyncAction();
            var nextChildren = nextState.element;
            if (prevState.isDehydrated) {
              var overrideState = {
                element: nextChildren,
                isDehydrated: !1,
                cache: nextState.cache
              };
              workInProgress.updateQueue.baseState = overrideState;
              workInProgress.memoizedState = overrideState;
              if (workInProgress.flags & 256) {
                var JSCompiler_inline_result$jscomp$0 =
                  mountHostRootWithoutHydrating(
                    current,
                    workInProgress,
                    nextChildren,
                    renderLanes
                  );
                break a;
              } else if (nextChildren !== prevChildren) {
                var recoverableError = createCapturedValueAtFiber(
                  Error(
                    "This root received an early update, before anything was able hydrate. Switched the entire root to client rendering."
                  ),
                  workInProgress
                );
                queueHydrationError(recoverableError);
                JSCompiler_inline_result$jscomp$0 =
                  mountHostRootWithoutHydrating(
                    current,
                    workInProgress,
                    nextChildren,
                    renderLanes
                  );
                break a;
              } else {
                var parentContainer = workInProgress.stateNode.containerInfo;
                switch (parentContainer.nodeType) {
                  case 9:
                    var parentElement = parentContainer.body;
                    break;
                  default:
                    parentElement =
                      "HTML" === parentContainer.nodeName
                        ? parentContainer.ownerDocument.body
                        : parentContainer;
                }
                nextHydratableInstance = getNextHydratable(
                  parentElement.firstChild
                );
                hydrationParentFiber = workInProgress;
                isHydrating = !0;
                hydrationErrors = null;
                didSuspendOrErrorDEV = !1;
                hydrationDiffRootDEV = null;
                rootOrSingletonContext = !0;
                for (
                  var child = mountChildFibers(
                      workInProgress,
                      null,
                      nextChildren,
                      renderLanes
                    ),
                    node = (workInProgress.child = child);
                  node;

                )
                  (node.flags = (node.flags & -3) | 4096),
                    (node = node.sibling);
              }
            } else {
              resetHydrationState();
              if (nextChildren === prevChildren) {
                JSCompiler_inline_result$jscomp$0 =
                  bailoutOnAlreadyFinishedWork(
                    current,
                    workInProgress,
                    renderLanes
                  );
                break a;
              }
              reconcileChildren(
                current,
                workInProgress,
                nextChildren,
                renderLanes
              );
            }
            JSCompiler_inline_result$jscomp$0 = workInProgress.child;
          }
          return JSCompiler_inline_result$jscomp$0;
        case 26:
          markRef(current, workInProgress);
          if (null === current) {
            var resource = getResource(
              workInProgress.type,
              null,
              workInProgress.pendingProps,
              null
            );
            if (resource) workInProgress.memoizedState = resource;
            else if (!isHydrating) {
              var type = workInProgress.type,
                props$jscomp$0 = workInProgress.pendingProps,
                rootContainerInstance = requiredContext(
                  rootInstanceStackCursor.current
                ),
                domElement = getOwnerDocumentFromRootContainer(
                  rootContainerInstance
                ).createElement(type);
              domElement[internalInstanceKey] = workInProgress;
              domElement[internalPropsKey] = props$jscomp$0;
              setInitialProperties(domElement, type, props$jscomp$0);
              markNodeAsHoistable(domElement);
              workInProgress.stateNode = domElement;
            }
          } else
            workInProgress.memoizedState = getResource(
              workInProgress.type,
              current.memoizedProps,
              workInProgress.pendingProps,
              current.memoizedState
            );
          return null;
        case 27:
          pushHostContext(workInProgress);
          if (null === current && isHydrating) {
            var currentRootContainer = requiredContext(
                rootInstanceStackCursor.current
              ),
              currentHostContext = getHostContext(),
              instance = (workInProgress.stateNode = resolveSingletonInstance(
                workInProgress.type,
                workInProgress.pendingProps,
                currentRootContainer,
                currentHostContext,
                !1
              ));
            if (!didSuspendOrErrorDEV) {
              var differences = diffHydratedProperties(
                instance,
                workInProgress.type,
                workInProgress.pendingProps,
                currentHostContext
              );
              null !== differences &&
                (buildHydrationDiffNode(workInProgress, 0).serverProps =
                  differences);
            }
            hydrationParentFiber = workInProgress;
            rootOrSingletonContext = !0;
            var currentHydratableInstance = nextHydratableInstance;
            isSingletonScope(workInProgress.type)
              ? ((previousHydratableOnEnteringScopedSingleton =
                  currentHydratableInstance),
                (nextHydratableInstance = getNextHydratable(
                  instance.firstChild
                )))
              : (nextHydratableInstance = currentHydratableInstance);
          }
          reconcileChildren(
            current,
            workInProgress,
            workInProgress.pendingProps.children,
            renderLanes
          );
          markRef(current, workInProgress);
          null === current && (workInProgress.flags |= 4194304);
          return workInProgress.child;
        case 5:
          if (null === current && isHydrating) {
            var currentHostContext$jscomp$0 = getHostContext(),
              shouldKeepWarning = validateDOMNesting(
                workInProgress.type,
                currentHostContext$jscomp$0.ancestorInfo
              ),
              nextInstance = nextHydratableInstance,
              JSCompiler_temp$jscomp$0;
            if (!(JSCompiler_temp$jscomp$0 = !nextInstance)) {
              var instance$jscomp$0 = canHydrateInstance(
                nextInstance,
                workInProgress.type,
                workInProgress.pendingProps,
                rootOrSingletonContext
              );
              if (null !== instance$jscomp$0) {
                workInProgress.stateNode = instance$jscomp$0;
                if (!didSuspendOrErrorDEV) {
                  var differences$jscomp$0 = diffHydratedProperties(
                    instance$jscomp$0,
                    workInProgress.type,
                    workInProgress.pendingProps,
                    currentHostContext$jscomp$0
                  );
                  null !== differences$jscomp$0 &&
                    (buildHydrationDiffNode(workInProgress, 0).serverProps =
                      differences$jscomp$0);
                }
                hydrationParentFiber = workInProgress;
                nextHydratableInstance = getNextHydratable(
                  instance$jscomp$0.firstChild
                );
                rootOrSingletonContext = !1;
                var JSCompiler_inline_result$jscomp$1 = !0;
              } else JSCompiler_inline_result$jscomp$1 = !1;
              JSCompiler_temp$jscomp$0 = !JSCompiler_inline_result$jscomp$1;
            }
            JSCompiler_temp$jscomp$0 &&
              (shouldKeepWarning &&
                warnNonHydratedInstance(workInProgress, nextInstance),
              throwOnHydrationMismatch(workInProgress));
          }
          pushHostContext(workInProgress);
          var type$jscomp$0 = workInProgress.type,
            nextProps$jscomp$0 = workInProgress.pendingProps,
            prevProps = null !== current ? current.memoizedProps : null,
            nextChildren$jscomp$0 = nextProps$jscomp$0.children;
          shouldSetTextContent(type$jscomp$0, nextProps$jscomp$0)
            ? (nextChildren$jscomp$0 = null)
            : null !== prevProps &&
              shouldSetTextContent(type$jscomp$0, prevProps) &&
              (workInProgress.flags |= 32);
          if (null !== workInProgress.memoizedState) {
            var newState = renderWithHooks(
              current,
              workInProgress,
              TransitionAwareHostComponent,
              null,
              null,
              renderLanes
            );
            HostTransitionContext._currentValue = newState;
          }
          markRef(current, workInProgress);
          reconcileChildren(
            current,
            workInProgress,
            nextChildren$jscomp$0,
            renderLanes
          );
          return workInProgress.child;
        case 6:
          if (null === current && isHydrating) {
            var text = workInProgress.pendingProps,
              currentHostContext$jscomp$1 = getHostContext(),
              ancestor = currentHostContext$jscomp$1.ancestorInfo.current;
            var shouldKeepWarning$jscomp$0 =
              null != ancestor
                ? validateTextNesting(
                    text,
                    ancestor.tag,
                    currentHostContext$jscomp$1.ancestorInfo.implicitRootScope
                  )
                : !0;
            var nextInstance$jscomp$0 = nextHydratableInstance,
              JSCompiler_temp$jscomp$1;
            if (!(JSCompiler_temp$jscomp$1 = !nextInstance$jscomp$0)) {
              var textInstance = canHydrateTextInstance(
                nextInstance$jscomp$0,
                workInProgress.pendingProps,
                rootOrSingletonContext
              );
              if (null !== textInstance) {
                workInProgress.stateNode = textInstance;
                hydrationParentFiber = workInProgress;
                nextHydratableInstance = null;
                var JSCompiler_inline_result$jscomp$2 = !0;
              } else JSCompiler_inline_result$jscomp$2 = !1;
              JSCompiler_temp$jscomp$1 = !JSCompiler_inline_result$jscomp$2;
            }
            JSCompiler_temp$jscomp$1 &&
              (shouldKeepWarning$jscomp$0 &&
                warnNonHydratedInstance(workInProgress, nextInstance$jscomp$0),
              throwOnHydrationMismatch(workInProgress));
          }
          return null;
        case 13:
          return updateSuspenseComponent(current, workInProgress, renderLanes);
        case 4:
          pushHostContainer(
            workInProgress,
            workInProgress.stateNode.containerInfo
          );
          var nextChildren$jscomp$1 = workInProgress.pendingProps;
          null === current
            ? (workInProgress.child = reconcileChildFibers(
                workInProgress,
                null,
                nextChildren$jscomp$1,
                renderLanes
              ))
            : reconcileChildren(
                current,
                workInProgress,
                nextChildren$jscomp$1,
                renderLanes
              );
          return workInProgress.child;
        case 11:
          return updateForwardRef(
            current,
            workInProgress,
            workInProgress.type,
            workInProgress.pendingProps,
            renderLanes
          );
        case 7:
          var nextChildren$jscomp$2 = workInProgress.pendingProps;
          markRef(current, workInProgress);
          reconcileChildren(
            current,
            workInProgress,
            nextChildren$jscomp$2,
            renderLanes
          );
          return workInProgress.child;
        case 8:
          return (
            reconcileChildren(
              current,
              workInProgress,
              workInProgress.pendingProps.children,
              renderLanes
            ),
            workInProgress.child
          );
        case 12:
          workInProgress.flags |= 4;
          workInProgress.flags |= 2048;
          var stateNode = workInProgress.stateNode;
          stateNode.effectDuration = -0;
          stateNode.passiveEffectDuration = -0;
          reconcileChildren(
            current,
            workInProgress,
            workInProgress.pendingProps.children,
            renderLanes
          );
          return workInProgress.child;
        case 10:
          var context = workInProgress.type,
            newProps = workInProgress.pendingProps,
            newValue = newProps.value;
          "value" in newProps ||
            hasWarnedAboutUsingNoValuePropOnContextProvider ||
            ((hasWarnedAboutUsingNoValuePropOnContextProvider = !0),
            console.error(
              "The `value` prop is required for the `<Context.Provider>`. Did you misspell it or forget to pass it?"
            ));
          pushProvider(workInProgress, context, newValue);
          reconcileChildren(
            current,
            workInProgress,
            newProps.children,
            renderLanes
          );
          return workInProgress.child;
        case 9:
          var context$jscomp$0 = workInProgress.type._context,
            render = workInProgress.pendingProps.children;
          "function" !== typeof render &&
            console.error(
              "A context consumer was rendered with multiple children, or a child that isn't a function. A context consumer expects a single child that is a function. If you did pass a function, make sure there is no trailing or leading whitespace around it."
            );
          prepareToReadContext(workInProgress);
          var newValue$jscomp$0 = readContext(context$jscomp$0);
          var newChildren = callComponentInDEV(
            render,
            newValue$jscomp$0,
            void 0
          );
          workInProgress.flags |= 1;
          reconcileChildren(current, workInProgress, newChildren, renderLanes);
          return workInProgress.child;
        case 14:
          return updateMemoComponent(
            current,
            workInProgress,
            workInProgress.type,
            workInProgress.pendingProps,
            renderLanes
          );
        case 15:
          return updateSimpleMemoComponent(
            current,
            workInProgress,
            workInProgress.type,
            workInProgress.pendingProps,
            renderLanes
          );
        case 19:
          return updateSuspenseListComponent(
            current,
            workInProgress,
            renderLanes
          );
        case 31:
          var nextProps$jscomp$1 = workInProgress.pendingProps,
            didSuspend = 0 !== (workInProgress.flags & 128);
          workInProgress.flags &= -129;
          if (null === current)
            if (isHydrating) {
              if ("hidden" === nextProps$jscomp$1.mode)
                mountActivityChildren(workInProgress, nextProps$jscomp$1);
              else {
                pushDehydratedActivitySuspenseHandler(workInProgress);
                var nextInstance$jscomp$1 = nextHydratableInstance;
                if (nextInstance$jscomp$1) {
                  var hydratableInstance = canHydrateHydrationBoundary(
                    nextInstance$jscomp$1,
                    rootOrSingletonContext
                  );
                  var activityInstance =
                    null !== hydratableInstance &&
                    hydratableInstance.data === ACTIVITY_START_DATA
                      ? hydratableInstance
                      : null;
                  if (null !== activityInstance) {
                    var activityState = {
                      dehydrated: activityInstance,
                      treeContext: getSuspendedTreeContext(),
                      retryLane: 536870912,
                      hydrationErrors: null
                    };
                    workInProgress.memoizedState = activityState;
                    var dehydratedFragment =
                      createFiberFromDehydratedFragment(activityInstance);
                    dehydratedFragment.return = workInProgress;
                    workInProgress.child = dehydratedFragment;
                    hydrationParentFiber = workInProgress;
                    nextHydratableInstance = null;
                  }
                  var JSCompiler_temp$jscomp$2 = activityInstance;
                } else JSCompiler_temp$jscomp$2 = null;
                if (null === JSCompiler_temp$jscomp$2)
                  throw (
                    (warnNonHydratedInstance(
                      workInProgress,
                      nextInstance$jscomp$1
                    ),
                    throwOnHydrationMismatch(workInProgress))
                  );
              }
              workInProgress.lanes = 536870912;
              var JSCompiler_inline_result$jscomp$3 = null;
            } else
              JSCompiler_inline_result$jscomp$3 = mountActivityChildren(
                workInProgress,
                nextProps$jscomp$1
              );
          else {
            var prevState$jscomp$0 = current.memoizedState;
            if (null !== prevState$jscomp$0) {
              var activityInstance$jscomp$0 = prevState$jscomp$0.dehydrated;
              pushDehydratedActivitySuspenseHandler(workInProgress);
              if (didSuspend)
                if (workInProgress.flags & 256) {
                  workInProgress.flags &= -257;
                  var JSCompiler_inline_result$jscomp$4 =
                    retryActivityComponentWithoutHydrating(
                      current,
                      workInProgress,
                      renderLanes
                    );
                } else if (null !== workInProgress.memoizedState)
                  (workInProgress.child = current.child),
                    (workInProgress.flags |= 128),
                    (JSCompiler_inline_result$jscomp$4 = null);
                else
                  throw Error(
                    "Client rendering an Activity suspended it again. This is a bug in React."
                  );
              else {
                warnIfHydrating();
                didReceiveUpdate ||
                  propagateParentContextChanges(
                    current,
                    workInProgress,
                    renderLanes,
                    !1
                  );
                var hasContextChanged =
                  0 !== (renderLanes & current.childLanes);
                if (didReceiveUpdate || hasContextChanged) {
                  var root = workInProgressRoot;
                  if (null !== root) {
                    var attemptHydrationAtLane = getBumpedLaneForHydration(
                      root,
                      renderLanes
                    );
                    if (
                      0 !== attemptHydrationAtLane &&
                      attemptHydrationAtLane !== prevState$jscomp$0.retryLane
                    )
                      throw (
                        ((prevState$jscomp$0.retryLane =
                          attemptHydrationAtLane),
                        enqueueConcurrentRenderForLane(
                          current,
                          attemptHydrationAtLane
                        ),
                        scheduleUpdateOnFiber(
                          root,
                          current,
                          attemptHydrationAtLane
                        ),
                        SelectiveHydrationException)
                      );
                  }
                  renderDidSuspendDelayIfPossible();
                  JSCompiler_inline_result$jscomp$4 =
                    retryActivityComponentWithoutHydrating(
                      current,
                      workInProgress,
                      renderLanes
                    );
                } else {
                  var treeContext = prevState$jscomp$0.treeContext;
                  nextHydratableInstance = getNextHydratable(
                    activityInstance$jscomp$0.nextSibling
                  );
                  hydrationParentFiber = workInProgress;
                  isHydrating = !0;
                  hydrationErrors = null;
                  didSuspendOrErrorDEV = !1;
                  hydrationDiffRootDEV = null;
                  rootOrSingletonContext = !1;
                  null !== treeContext &&
                    restoreSuspendedTreeContext(workInProgress, treeContext);
                  var primaryChildFragment = mountActivityChildren(
                    workInProgress,
                    nextProps$jscomp$1
                  );
                  primaryChildFragment.flags |= 4096;
                  JSCompiler_inline_result$jscomp$4 = primaryChildFragment;
                }
              }
              JSCompiler_inline_result$jscomp$3 =
                JSCompiler_inline_result$jscomp$4;
            } else {
              var primaryChildFragment$jscomp$0 = createWorkInProgress(
                current.child,
                {
                  mode: nextProps$jscomp$1.mode,
                  children: nextProps$jscomp$1.children
                }
              );
              primaryChildFragment$jscomp$0.ref = workInProgress.ref;
              workInProgress.child = primaryChildFragment$jscomp$0;
              primaryChildFragment$jscomp$0.return = workInProgress;
              JSCompiler_inline_result$jscomp$3 = primaryChildFragment$jscomp$0;
            }
          }
          return JSCompiler_inline_result$jscomp$3;
        case 22:
          return updateOffscreenComponent(
            current,
            workInProgress,
            renderLanes,
            workInProgress.pendingProps
          );
        case 24:
          prepareToReadContext(workInProgress);
          var parentCache = readContext(CacheContext);
          if (null === current) {
            var cacheFromPool = peekCacheFromPool();
            if (null !== cacheFromPool) var freshCache = cacheFromPool;
            else {
              var root$jscomp$0 = workInProgressRoot,
                freshCache$jscomp$0 = createCache();
              root$jscomp$0.pooledCache = freshCache$jscomp$0;
              retainCache(freshCache$jscomp$0);
              null !== freshCache$jscomp$0 &&
                (root$jscomp$0.pooledCacheLanes |= renderLanes);
              freshCache = freshCache$jscomp$0;
            }
            workInProgress.memoizedState = {
              parent: parentCache,
              cache: freshCache
            };
            initializeUpdateQueue(workInProgress);
            pushProvider(workInProgress, CacheContext, freshCache);
          } else {
            0 !== (current.lanes & renderLanes) &&
              (cloneUpdateQueue(current, workInProgress),
              processUpdateQueue(workInProgress, null, null, renderLanes),
              suspendIfUpdateReadFromEntangledAsyncAction());
            var prevState$jscomp$1 = current.memoizedState,
              nextState$jscomp$0 = workInProgress.memoizedState;
            if (prevState$jscomp$1.parent !== parentCache) {
              var derivedState = { parent: parentCache, cache: parentCache };
              workInProgress.memoizedState = derivedState;
              0 === workInProgress.lanes &&
                (workInProgress.memoizedState =
                  workInProgress.updateQueue.baseState =
                    derivedState);
              pushProvider(workInProgress, CacheContext, parentCache);
            } else {
              var nextCache$jscomp$0 = nextState$jscomp$0.cache;
              pushProvider(workInProgress, CacheContext, nextCache$jscomp$0);
              nextCache$jscomp$0 !== prevState$jscomp$1.cache &&
                propagateContextChanges(
                  workInProgress,
                  [CacheContext],
                  renderLanes,
                  !0
                );
            }
          }
          reconcileChildren(
            current,
            workInProgress,
            workInProgress.pendingProps.children,
            renderLanes
          );
          return workInProgress.child;
        case 30:
          var pendingProps = workInProgress.pendingProps;
          null != pendingProps.name && "auto" !== pendingProps.name
            ? (workInProgress.flags |= null === current ? 18882560 : 18874368)
            : isHydrating && pushMaterializedTreeId(workInProgress);
          if (void 0 !== pendingProps.className) {
            var example =
              "string" === typeof pendingProps.className
                ? JSON.stringify(pendingProps.className)
                : "{...}";
            didWarnAboutClassNameOnViewTransition[example] ||
              ((didWarnAboutClassNameOnViewTransition[example] = !0),
              console.error(
                '<ViewTransition> doesn\'t accept a "className" prop. It has been renamed to "default".\n-   <ViewTransition className=%s>\n+   <ViewTransition default=%s>',
                example,
                example
              ));
          }
          null !== current && current.memoizedProps.name !== pendingProps.name
            ? (workInProgress.flags |= 4194816)
            : markRef(current, workInProgress);
          reconcileChildren(
            current,
            workInProgress,
            pendingProps.children,
            renderLanes
          );
          return workInProgress.child;
        case 29:
          throw workInProgress.pendingProps;
      }
      throw Error(
        "Unknown unit of work tag (" +
          workInProgress.tag +
          "). This error is likely caused by a bug in React. Please file an issue."
      );
    }
    function markUpdate(workInProgress) {
      workInProgress.flags |= 4;
    }
    function preloadInstanceAndSuspendIfNeeded(
      workInProgress,
      type,
      oldProps,
      newProps,
      renderLanes
    ) {
      var JSCompiler_temp;
      if (
        (JSCompiler_temp =
          (workInProgress.mode & SuspenseyImagesMode) !== NoMode)
      )
        JSCompiler_temp =
          null === oldProps
            ? maySuspendCommit(type, newProps)
            : maySuspendCommit(type, newProps) &&
              (newProps.src !== oldProps.src ||
                newProps.srcSet !== oldProps.srcSet);
      if (JSCompiler_temp) {
        if (
          ((workInProgress.flags |= 16777216),
          (renderLanes & 335544128) === renderLanes)
        )
          if (workInProgress.stateNode.complete) workInProgress.flags |= 8192;
          else if (shouldRemainOnPreviousScreen()) workInProgress.flags |= 8192;
          else
            throw (
              ((suspendedThenable = noopSuspenseyCommitThenable),
              SuspenseyCommitException)
            );
      } else workInProgress.flags &= -16777217;
    }
    function preloadResourceAndSuspendIfNeeded(workInProgress, resource) {
      if (
        "stylesheet" !== resource.type ||
        (resource.state.loading & Inserted) !== NotLoaded
      )
        workInProgress.flags &= -16777217;
      else if (((workInProgress.flags |= 16777216), !preloadResource(resource)))
        if (shouldRemainOnPreviousScreen()) workInProgress.flags |= 8192;
        else
          throw (
            ((suspendedThenable = noopSuspenseyCommitThenable),
            SuspenseyCommitException)
          );
    }
    function scheduleRetryEffect(workInProgress, retryQueue) {
      null !== retryQueue && (workInProgress.flags |= 4);
      workInProgress.flags & 16384 &&
        ((retryQueue =
          22 !== workInProgress.tag ? claimNextRetryLane() : 536870912),
        (workInProgress.lanes |= retryQueue),
        (workInProgressSuspendedRetryLanes |= retryQueue));
    }
    function cutOffTailIfNeeded(renderState, hasRenderedATailFallback) {
      if (!isHydrating)
        switch (renderState.tailMode) {
          case "hidden":
            hasRenderedATailFallback = renderState.tail;
            for (var lastTailNode = null; null !== hasRenderedATailFallback; )
              null !== hasRenderedATailFallback.alternate &&
                (lastTailNode = hasRenderedATailFallback),
                (hasRenderedATailFallback = hasRenderedATailFallback.sibling);
            null === lastTailNode
              ? (renderState.tail = null)
              : (lastTailNode.sibling = null);
            break;
          case "collapsed":
            lastTailNode = renderState.tail;
            for (var _lastTailNode = null; null !== lastTailNode; )
              null !== lastTailNode.alternate && (_lastTailNode = lastTailNode),
                (lastTailNode = lastTailNode.sibling);
            null === _lastTailNode
              ? hasRenderedATailFallback || null === renderState.tail
                ? (renderState.tail = null)
                : (renderState.tail.sibling = null)
              : (_lastTailNode.sibling = null);
        }
    }
    function bubbleProperties(completedWork) {
      var didBailout =
          null !== completedWork.alternate &&
          completedWork.alternate.child === completedWork.child,
        newChildLanes = 0,
        subtreeFlags = 0;
      if (didBailout)
        if ((completedWork.mode & ProfileMode) !== NoMode) {
          for (
            var _treeBaseDuration = completedWork.selfBaseDuration,
              _child2 = completedWork.child;
            null !== _child2;

          )
            (newChildLanes |= _child2.lanes | _child2.childLanes),
              (subtreeFlags |= _child2.subtreeFlags & 65011712),
              (subtreeFlags |= _child2.flags & 65011712),
              (_treeBaseDuration += _child2.treeBaseDuration),
              (_child2 = _child2.sibling);
          completedWork.treeBaseDuration = _treeBaseDuration;
        } else
          for (
            _treeBaseDuration = completedWork.child;
            null !== _treeBaseDuration;

          )
            (newChildLanes |=
              _treeBaseDuration.lanes | _treeBaseDuration.childLanes),
              (subtreeFlags |= _treeBaseDuration.subtreeFlags & 65011712),
              (subtreeFlags |= _treeBaseDuration.flags & 65011712),
              (_treeBaseDuration.return = completedWork),
              (_treeBaseDuration = _treeBaseDuration.sibling);
      else if ((completedWork.mode & ProfileMode) !== NoMode) {
        _treeBaseDuration = completedWork.actualDuration;
        _child2 = completedWork.selfBaseDuration;
        for (var child = completedWork.child; null !== child; )
          (newChildLanes |= child.lanes | child.childLanes),
            (subtreeFlags |= child.subtreeFlags),
            (subtreeFlags |= child.flags),
            (_treeBaseDuration += child.actualDuration),
            (_child2 += child.treeBaseDuration),
            (child = child.sibling);
        completedWork.actualDuration = _treeBaseDuration;
        completedWork.treeBaseDuration = _child2;
      } else
        for (
          _treeBaseDuration = completedWork.child;
          null !== _treeBaseDuration;

        )
          (newChildLanes |=
            _treeBaseDuration.lanes | _treeBaseDuration.childLanes),
            (subtreeFlags |= _treeBaseDuration.subtreeFlags),
            (subtreeFlags |= _treeBaseDuration.flags),
            (_treeBaseDuration.return = completedWork),
            (_treeBaseDuration = _treeBaseDuration.sibling);
      completedWork.subtreeFlags |= subtreeFlags;
      completedWork.childLanes = newChildLanes;
      return didBailout;
    }
    function completeWork(current, workInProgress, renderLanes) {
      var newProps = workInProgress.pendingProps;
      popTreeContext(workInProgress);
      switch (workInProgress.tag) {
        case 16:
        case 15:
        case 0:
        case 11:
        case 7:
        case 8:
        case 12:
        case 9:
        case 14:
          return bubbleProperties(workInProgress), null;
        case 1:
          return bubbleProperties(workInProgress), null;
        case 3:
          renderLanes = workInProgress.stateNode;
          newProps = null;
          null !== current && (newProps = current.memoizedState.cache);
          workInProgress.memoizedState.cache !== newProps &&
            (workInProgress.flags |= 2048);
          popProvider(CacheContext, workInProgress);
          popHostContainer(workInProgress);
          renderLanes.pendingContext &&
            ((renderLanes.context = renderLanes.pendingContext),
            (renderLanes.pendingContext = null));
          if (null === current || null === current.child)
            popHydrationState(workInProgress)
              ? (emitPendingHydrationWarnings(), markUpdate(workInProgress))
              : null === current ||
                (current.memoizedState.isDehydrated &&
                  0 === (workInProgress.flags & 256)) ||
                ((workInProgress.flags |= 1024),
                upgradeHydrationErrorsToRecoverable());
          bubbleProperties(workInProgress);
          return null;
        case 26:
          var type = workInProgress.type,
            nextResource = workInProgress.memoizedState;
          null === current
            ? (markUpdate(workInProgress),
              null !== nextResource
                ? (bubbleProperties(workInProgress),
                  preloadResourceAndSuspendIfNeeded(
                    workInProgress,
                    nextResource
                  ))
                : (bubbleProperties(workInProgress),
                  preloadInstanceAndSuspendIfNeeded(
                    workInProgress,
                    type,
                    null,
                    newProps,
                    renderLanes
                  )))
            : nextResource
              ? nextResource !== current.memoizedState
                ? (markUpdate(workInProgress),
                  bubbleProperties(workInProgress),
                  preloadResourceAndSuspendIfNeeded(
                    workInProgress,
                    nextResource
                  ))
                : (bubbleProperties(workInProgress),
                  (workInProgress.flags &= -16777217))
              : ((current = current.memoizedProps),
                current !== newProps && markUpdate(workInProgress),
                bubbleProperties(workInProgress),
                preloadInstanceAndSuspendIfNeeded(
                  workInProgress,
                  type,
                  current,
                  newProps,
                  renderLanes
                ));
          return null;
        case 27:
          popHostContext(workInProgress);
          renderLanes = requiredContext(rootInstanceStackCursor.current);
          type = workInProgress.type;
          if (null !== current && null != workInProgress.stateNode)
            current.memoizedProps !== newProps && markUpdate(workInProgress);
          else {
            if (!newProps) {
              if (null === workInProgress.stateNode)
                throw Error(
                  "We must have new props for new mounts. This error is likely caused by a bug in React. Please file an issue."
                );
              bubbleProperties(workInProgress);
              workInProgress.subtreeFlags &= -33554433;
              return null;
            }
            current = getHostContext();
            popHydrationState(workInProgress)
              ? prepareToHydrateHostInstance(workInProgress, current)
              : ((current = resolveSingletonInstance(
                  type,
                  newProps,
                  renderLanes,
                  current,
                  !0
                )),
                (workInProgress.stateNode = current),
                markUpdate(workInProgress));
          }
          bubbleProperties(workInProgress);
          workInProgress.subtreeFlags &= -33554433;
          return null;
        case 5:
          popHostContext(workInProgress);
          type = workInProgress.type;
          if (null !== current && null != workInProgress.stateNode)
            current.memoizedProps !== newProps && markUpdate(workInProgress);
          else {
            if (!newProps) {
              if (null === workInProgress.stateNode)
                throw Error(
                  "We must have new props for new mounts. This error is likely caused by a bug in React. Please file an issue."
                );
              bubbleProperties(workInProgress);
              workInProgress.subtreeFlags &= -33554433;
              return null;
            }
            var _currentHostContext = getHostContext();
            if (popHydrationState(workInProgress)) {
              prepareToHydrateHostInstance(workInProgress, _currentHostContext);
              a: switch (type) {
                case "input":
                case "select":
                case "textarea":
                case "img":
                  newProps = !0;
                  break a;
                default:
                  newProps = !1;
              }
              newProps && (workInProgress.flags |= 64);
            } else {
              nextResource = requiredContext(rootInstanceStackCursor.current);
              validateDOMNesting(type, _currentHostContext.ancestorInfo);
              _currentHostContext = _currentHostContext.context;
              nextResource = getOwnerDocumentFromRootContainer(nextResource);
              switch (_currentHostContext) {
                case HostContextNamespaceSvg:
                  nextResource = nextResource.createElementNS(
                    SVG_NAMESPACE,
                    type
                  );
                  break;
                case HostContextNamespaceMath:
                  nextResource = nextResource.createElementNS(
                    MATH_NAMESPACE,
                    type
                  );
                  break;
                default:
                  switch (type) {
                    case "svg":
                      nextResource = nextResource.createElementNS(
                        SVG_NAMESPACE,
                        type
                      );
                      break;
                    case "math":
                      nextResource = nextResource.createElementNS(
                        MATH_NAMESPACE,
                        type
                      );
                      break;
                    case "script":
                      nextResource = nextResource.createElement("div");
                      nextResource.innerHTML = "<script>\x3c/script>";
                      nextResource = nextResource.removeChild(
                        nextResource.firstChild
                      );
                      break;
                    case "select":
                      nextResource =
                        "string" === typeof newProps.is
                          ? nextResource.createElement("select", {
                              is: newProps.is
                            })
                          : nextResource.createElement("select");
                      newProps.multiple
                        ? (nextResource.multiple = !0)
                        : newProps.size && (nextResource.size = newProps.size);
                      break;
                    default:
                      (nextResource =
                        "string" === typeof newProps.is
                          ? nextResource.createElement(type, {
                              is: newProps.is
                            })
                          : nextResource.createElement(type)),
                        -1 === type.indexOf("-") &&
                          (type !== type.toLowerCase() &&
                            console.error(
                              "<%s /> is using incorrect casing. Use PascalCase for React components, or lowercase for HTML elements.",
                              type
                            ),
                          "[object HTMLUnknownElement]" !==
                            Object.prototype.toString.call(nextResource) ||
                            hasOwnProperty.call(warnedUnknownTags, type) ||
                            ((warnedUnknownTags[type] = !0),
                            console.error(
                              "The tag <%s> is unrecognized in this browser. If you meant to render a React component, start its name with an uppercase letter.",
                              type
                            )));
                  }
              }
              nextResource[internalInstanceKey] = workInProgress;
              nextResource[internalPropsKey] = newProps;
              a: for (
                _currentHostContext = workInProgress.child;
                null !== _currentHostContext;

              ) {
                if (
                  5 === _currentHostContext.tag ||
                  6 === _currentHostContext.tag
                )
                  nextResource.appendChild(_currentHostContext.stateNode);
                else if (
                  4 !== _currentHostContext.tag &&
                  27 !== _currentHostContext.tag &&
                  null !== _currentHostContext.child
                ) {
                  _currentHostContext.child.return = _currentHostContext;
                  _currentHostContext = _currentHostContext.child;
                  continue;
                }
                if (_currentHostContext === workInProgress) break a;
                for (; null === _currentHostContext.sibling; ) {
                  if (
                    null === _currentHostContext.return ||
                    _currentHostContext.return === workInProgress
                  )
                    break a;
                  _currentHostContext = _currentHostContext.return;
                }
                _currentHostContext.sibling.return = _currentHostContext.return;
                _currentHostContext = _currentHostContext.sibling;
              }
              workInProgress.stateNode = nextResource;
              a: switch (
                (setInitialProperties(nextResource, type, newProps), type)
              ) {
                case "button":
                case "input":
                case "select":
                case "textarea":
                  newProps = !!newProps.autoFocus;
                  break a;
                case "img":
                  newProps = !0;
                  break a;
                default:
                  newProps = !1;
              }
              newProps && markUpdate(workInProgress);
            }
          }
          bubbleProperties(workInProgress);
          workInProgress.subtreeFlags &= -33554433;
          preloadInstanceAndSuspendIfNeeded(
            workInProgress,
            workInProgress.type,
            null === current ? null : current.memoizedProps,
            workInProgress.pendingProps,
            renderLanes
          );
          return null;
        case 6:
          if (current && null != workInProgress.stateNode)
            current.memoizedProps !== newProps && markUpdate(workInProgress);
          else {
            if (
              "string" !== typeof newProps &&
              null === workInProgress.stateNode
            )
              throw Error(
                "We must have new props for new mounts. This error is likely caused by a bug in React. Please file an issue."
              );
            current = requiredContext(rootInstanceStackCursor.current);
            renderLanes = getHostContext();
            if (popHydrationState(workInProgress)) {
              current = workInProgress.stateNode;
              renderLanes = workInProgress.memoizedProps;
              type = !didSuspendOrErrorDEV;
              newProps = null;
              nextResource = hydrationParentFiber;
              if (null !== nextResource)
                switch (nextResource.tag) {
                  case 3:
                    type &&
                      ((type = diffHydratedTextForDevWarnings(
                        current,
                        renderLanes,
                        newProps
                      )),
                      null !== type &&
                        (buildHydrationDiffNode(workInProgress, 0).serverProps =
                          type));
                    break;
                  case 27:
                  case 5:
                    (newProps = nextResource.memoizedProps),
                      type &&
                        ((type = diffHydratedTextForDevWarnings(
                          current,
                          renderLanes,
                          newProps
                        )),
                        null !== type &&
                          (buildHydrationDiffNode(
                            workInProgress,
                            0
                          ).serverProps = type));
                }
              current[internalInstanceKey] = workInProgress;
              current =
                current.nodeValue === renderLanes ||
                (null !== newProps &&
                  !0 === newProps.suppressHydrationWarning) ||
                checkForUnmatchedText(current.nodeValue, renderLanes)
                  ? !0
                  : !1;
              current || throwOnHydrationMismatch(workInProgress, !0);
            } else
              (type = renderLanes.ancestorInfo.current),
                null != type &&
                  validateTextNesting(
                    newProps,
                    type.tag,
                    renderLanes.ancestorInfo.implicitRootScope
                  ),
                (current =
                  getOwnerDocumentFromRootContainer(current).createTextNode(
                    newProps
                  )),
                (current[internalInstanceKey] = workInProgress),
                (workInProgress.stateNode = current);
          }
          bubbleProperties(workInProgress);
          return null;
        case 31:
          renderLanes = workInProgress.memoizedState;
          if (null === current || null !== current.memoizedState) {
            newProps = popHydrationState(workInProgress);
            if (null !== renderLanes) {
              if (null === current) {
                if (!newProps)
                  throw Error(
                    "A dehydrated suspense component was completed without a hydrated node. This is probably a bug in React."
                  );
                current = workInProgress.memoizedState;
                current = null !== current ? current.dehydrated : null;
                if (!current)
                  throw Error(
                    "Expected to have a hydrated activity instance. This error is likely caused by a bug in React. Please file an issue."
                  );
                current[internalInstanceKey] = workInProgress;
                bubbleProperties(workInProgress);
                (workInProgress.mode & ProfileMode) !== NoMode &&
                  null !== renderLanes &&
                  ((current = workInProgress.child),
                  null !== current &&
                    (workInProgress.treeBaseDuration -=
                      current.treeBaseDuration));
              } else
                emitPendingHydrationWarnings(),
                  resetHydrationState(),
                  0 === (workInProgress.flags & 128) &&
                    (renderLanes = workInProgress.memoizedState = null),
                  (workInProgress.flags |= 4),
                  bubbleProperties(workInProgress),
                  (workInProgress.mode & ProfileMode) !== NoMode &&
                    null !== renderLanes &&
                    ((current = workInProgress.child),
                    null !== current &&
                      (workInProgress.treeBaseDuration -=
                        current.treeBaseDuration));
              current = !1;
            } else
              (renderLanes = upgradeHydrationErrorsToRecoverable()),
                null !== current &&
                  null !== current.memoizedState &&
                  (current.memoizedState.hydrationErrors = renderLanes),
                (current = !0);
            if (!current) {
              if (workInProgress.flags & 256)
                return popSuspenseHandler(workInProgress), workInProgress;
              popSuspenseHandler(workInProgress);
              return null;
            }
            if (0 !== (workInProgress.flags & 128))
              throw Error(
                "Client rendering an Activity suspended it again. This is a bug in React."
              );
          }
          bubbleProperties(workInProgress);
          return null;
        case 13:
          newProps = workInProgress.memoizedState;
          if (
            null === current ||
            (null !== current.memoizedState &&
              null !== current.memoizedState.dehydrated)
          ) {
            type = newProps;
            nextResource = popHydrationState(workInProgress);
            if (null !== type && null !== type.dehydrated) {
              if (null === current) {
                if (!nextResource)
                  throw Error(
                    "A dehydrated suspense component was completed without a hydrated node. This is probably a bug in React."
                  );
                nextResource = workInProgress.memoizedState;
                nextResource =
                  null !== nextResource ? nextResource.dehydrated : null;
                if (!nextResource)
                  throw Error(
                    "Expected to have a hydrated suspense instance. This error is likely caused by a bug in React. Please file an issue."
                  );
                nextResource[internalInstanceKey] = workInProgress;
                bubbleProperties(workInProgress);
                (workInProgress.mode & ProfileMode) !== NoMode &&
                  null !== type &&
                  ((type = workInProgress.child),
                  null !== type &&
                    (workInProgress.treeBaseDuration -= type.treeBaseDuration));
              } else
                emitPendingHydrationWarnings(),
                  resetHydrationState(),
                  0 === (workInProgress.flags & 128) &&
                    (type = workInProgress.memoizedState = null),
                  (workInProgress.flags |= 4),
                  bubbleProperties(workInProgress),
                  (workInProgress.mode & ProfileMode) !== NoMode &&
                    null !== type &&
                    ((type = workInProgress.child),
                    null !== type &&
                      (workInProgress.treeBaseDuration -=
                        type.treeBaseDuration));
              type = !1;
            } else
              (type = upgradeHydrationErrorsToRecoverable()),
                null !== current &&
                  null !== current.memoizedState &&
                  (current.memoizedState.hydrationErrors = type),
                (type = !0);
            if (!type) {
              if (workInProgress.flags & 256)
                return popSuspenseHandler(workInProgress), workInProgress;
              popSuspenseHandler(workInProgress);
              return null;
            }
          }
          popSuspenseHandler(workInProgress);
          if (0 !== (workInProgress.flags & 128))
            return (
              (workInProgress.lanes = renderLanes),
              (workInProgress.mode & ProfileMode) !== NoMode &&
                transferActualDuration(workInProgress),
              workInProgress
            );
          renderLanes = null !== newProps;
          current = null !== current && null !== current.memoizedState;
          renderLanes &&
            ((newProps = workInProgress.child),
            (type = null),
            null !== newProps.alternate &&
              null !== newProps.alternate.memoizedState &&
              null !== newProps.alternate.memoizedState.cachePool &&
              (type = newProps.alternate.memoizedState.cachePool.pool),
            (nextResource = null),
            null !== newProps.memoizedState &&
              null !== newProps.memoizedState.cachePool &&
              (nextResource = newProps.memoizedState.cachePool.pool),
            nextResource !== type && (newProps.flags |= 2048));
          renderLanes !== current &&
            renderLanes &&
            (workInProgress.child.flags |= 8192);
          scheduleRetryEffect(workInProgress, workInProgress.updateQueue);
          bubbleProperties(workInProgress);
          (workInProgress.mode & ProfileMode) !== NoMode &&
            renderLanes &&
            ((current = workInProgress.child),
            null !== current &&
              (workInProgress.treeBaseDuration -= current.treeBaseDuration));
          return null;
        case 4:
          return (
            popHostContainer(workInProgress),
            null === current &&
              listenToAllSupportedEvents(
                workInProgress.stateNode.containerInfo
              ),
            bubbleProperties(workInProgress),
            null
          );
        case 10:
          return (
            popProvider(workInProgress.type, workInProgress),
            bubbleProperties(workInProgress),
            null
          );
        case 19:
          pop(suspenseStackCursor, workInProgress);
          newProps = workInProgress.memoizedState;
          if (null === newProps) return bubbleProperties(workInProgress), null;
          type = 0 !== (workInProgress.flags & 128);
          nextResource = newProps.rendering;
          if (null === nextResource)
            if (type) cutOffTailIfNeeded(newProps, !1);
            else {
              if (
                workInProgressRootExitStatus !== RootInProgress ||
                (null !== current && 0 !== (current.flags & 128))
              )
                for (current = workInProgress.child; null !== current; ) {
                  nextResource = findFirstSuspended(current);
                  if (null !== nextResource) {
                    workInProgress.flags |= 128;
                    cutOffTailIfNeeded(newProps, !1);
                    current = nextResource.updateQueue;
                    workInProgress.updateQueue = current;
                    scheduleRetryEffect(workInProgress, current);
                    workInProgress.subtreeFlags = 0;
                    current = renderLanes;
                    for (
                      renderLanes = workInProgress.child;
                      null !== renderLanes;

                    )
                      resetWorkInProgress(renderLanes, current),
                        (renderLanes = renderLanes.sibling);
                    push(
                      suspenseStackCursor,
                      (suspenseStackCursor.current &
                        SubtreeSuspenseContextMask) |
                        ForceSuspenseFallback,
                      workInProgress
                    );
                    isHydrating &&
                      pushTreeFork(workInProgress, newProps.treeForkCount);
                    return workInProgress.child;
                  }
                  current = current.sibling;
                }
              null !== newProps.tail &&
                now$1() > workInProgressRootRenderTargetTime &&
                ((workInProgress.flags |= 128),
                (type = !0),
                cutOffTailIfNeeded(newProps, !1),
                (workInProgress.lanes = 4194304));
            }
          else {
            if (!type)
              if (
                ((current = findFirstSuspended(nextResource)), null !== current)
              ) {
                if (
                  ((workInProgress.flags |= 128),
                  (type = !0),
                  (current = current.updateQueue),
                  (workInProgress.updateQueue = current),
                  scheduleRetryEffect(workInProgress, current),
                  cutOffTailIfNeeded(newProps, !0),
                  null === newProps.tail &&
                    "hidden" === newProps.tailMode &&
                    !nextResource.alternate &&
                    !isHydrating)
                )
                  return bubbleProperties(workInProgress), null;
              } else
                2 * now$1() - newProps.renderingStartTime >
                  workInProgressRootRenderTargetTime &&
                  536870912 !== renderLanes &&
                  ((workInProgress.flags |= 128),
                  (type = !0),
                  cutOffTailIfNeeded(newProps, !1),
                  (workInProgress.lanes = 4194304));
            newProps.isBackwards
              ? ((nextResource.sibling = workInProgress.child),
                (workInProgress.child = nextResource))
              : ((current = newProps.last),
                null !== current
                  ? (current.sibling = nextResource)
                  : (workInProgress.child = nextResource),
                (newProps.last = nextResource));
          }
          if (null !== newProps.tail)
            return (
              (current = newProps.tail),
              (newProps.rendering = current),
              (newProps.tail = current.sibling),
              (newProps.renderingStartTime = now$1()),
              (current.sibling = null),
              (renderLanes = suspenseStackCursor.current),
              (renderLanes = type
                ? (renderLanes & SubtreeSuspenseContextMask) |
                  ForceSuspenseFallback
                : renderLanes & SubtreeSuspenseContextMask),
              push(suspenseStackCursor, renderLanes, workInProgress),
              isHydrating &&
                pushTreeFork(workInProgress, newProps.treeForkCount),
              current
            );
          bubbleProperties(workInProgress);
          return null;
        case 22:
        case 23:
          return (
            popSuspenseHandler(workInProgress),
            popHiddenContext(workInProgress),
            (newProps = null !== workInProgress.memoizedState),
            null !== current
              ? (null !== current.memoizedState) !== newProps &&
                (workInProgress.flags |= 8192)
              : newProps && (workInProgress.flags |= 8192),
            newProps
              ? 0 !== (renderLanes & 536870912) &&
                0 === (workInProgress.flags & 128) &&
                (bubbleProperties(workInProgress),
                workInProgress.subtreeFlags & 6 &&
                  (workInProgress.flags |= 8192))
              : bubbleProperties(workInProgress),
            (renderLanes = workInProgress.updateQueue),
            null !== renderLanes &&
              scheduleRetryEffect(workInProgress, renderLanes.retryQueue),
            (renderLanes = null),
            null !== current &&
              null !== current.memoizedState &&
              null !== current.memoizedState.cachePool &&
              (renderLanes = current.memoizedState.cachePool.pool),
            (newProps = null),
            null !== workInProgress.memoizedState &&
              null !== workInProgress.memoizedState.cachePool &&
              (newProps = workInProgress.memoizedState.cachePool.pool),
            newProps !== renderLanes && (workInProgress.flags |= 2048),
            null !== current && pop(resumedCache, workInProgress),
            null
          );
        case 24:
          return (
            (renderLanes = null),
            null !== current && (renderLanes = current.memoizedState.cache),
            workInProgress.memoizedState.cache !== renderLanes &&
              (workInProgress.flags |= 2048),
            popProvider(CacheContext, workInProgress),
            bubbleProperties(workInProgress),
            null
          );
        case 25:
          return null;
        case 30:
          return (
            (workInProgress.flags |= 33554432),
            bubbleProperties(workInProgress),
            null
          );
      }
      throw Error(
        "Unknown unit of work tag (" +
          workInProgress.tag +
          "). This error is likely caused by a bug in React. Please file an issue."
      );
    }
    function unwindWork(current, workInProgress) {
      popTreeContext(workInProgress);
      switch (workInProgress.tag) {
        case 1:
          return (
            (current = workInProgress.flags),
            current & 65536
              ? ((workInProgress.flags = (current & -65537) | 128),
                (workInProgress.mode & ProfileMode) !== NoMode &&
                  transferActualDuration(workInProgress),
                workInProgress)
              : null
          );
        case 3:
          return (
            popProvider(CacheContext, workInProgress),
            popHostContainer(workInProgress),
            (current = workInProgress.flags),
            0 !== (current & 65536) && 0 === (current & 128)
              ? ((workInProgress.flags = (current & -65537) | 128),
                workInProgress)
              : null
          );
        case 26:
        case 27:
        case 5:
          return popHostContext(workInProgress), null;
        case 31:
          if (null !== workInProgress.memoizedState) {
            popSuspenseHandler(workInProgress);
            if (null === workInProgress.alternate)
              throw Error(
                "Threw in newly mounted dehydrated component. This is likely a bug in React. Please file an issue."
              );
            resetHydrationState();
          }
          current = workInProgress.flags;
          return current & 65536
            ? ((workInProgress.flags = (current & -65537) | 128),
              (workInProgress.mode & ProfileMode) !== NoMode &&
                transferActualDuration(workInProgress),
              workInProgress)
            : null;
        case 13:
          popSuspenseHandler(workInProgress);
          current = workInProgress.memoizedState;
          if (null !== current && null !== current.dehydrated) {
            if (null === workInProgress.alternate)
              throw Error(
                "Threw in newly mounted dehydrated component. This is likely a bug in React. Please file an issue."
              );
            resetHydrationState();
          }
          current = workInProgress.flags;
          return current & 65536
            ? ((workInProgress.flags = (current & -65537) | 128),
              (workInProgress.mode & ProfileMode) !== NoMode &&
                transferActualDuration(workInProgress),
              workInProgress)
            : null;
        case 19:
          return pop(suspenseStackCursor, workInProgress), null;
        case 4:
          return popHostContainer(workInProgress), null;
        case 10:
          return popProvider(workInProgress.type, workInProgress), null;
        case 22:
        case 23:
          return (
            popSuspenseHandler(workInProgress),
            popHiddenContext(workInProgress),
            null !== current && pop(resumedCache, workInProgress),
            (current = workInProgress.flags),
            current & 65536
              ? ((workInProgress.flags = (current & -65537) | 128),
                (workInProgress.mode & ProfileMode) !== NoMode &&
                  transferActualDuration(workInProgress),
                workInProgress)
              : null
          );
        case 24:
          return popProvider(CacheContext, workInProgress), null;
        case 25:
          return null;
        default:
          return null;
      }
    }
    function unwindInterruptedWork(current, interruptedWork) {
      popTreeContext(interruptedWork);
      switch (interruptedWork.tag) {
        case 3:
          popProvider(CacheContext, interruptedWork);
          popHostContainer(interruptedWork);
          break;
        case 26:
        case 27:
        case 5:
          popHostContext(interruptedWork);
          break;
        case 4:
          popHostContainer(interruptedWork);
          break;
        case 31:
          null !== interruptedWork.memoizedState &&
            popSuspenseHandler(interruptedWork);
          break;
        case 13:
          popSuspenseHandler(interruptedWork);
          break;
        case 19:
          pop(suspenseStackCursor, interruptedWork);
          break;
        case 10:
          popProvider(interruptedWork.type, interruptedWork);
          break;
        case 22:
        case 23:
          popSuspenseHandler(interruptedWork);
          popHiddenContext(interruptedWork);
          null !== current && pop(resumedCache, interruptedWork);
          break;
        case 24:
          popProvider(CacheContext, interruptedWork);
      }
    }
    function shouldProfile(current) {
      return (current.mode & ProfileMode) !== NoMode;
    }
    function commitHookLayoutEffects(finishedWork, hookFlags) {
      shouldProfile(finishedWork)
        ? (startEffectTimer(),
          commitHookEffectListMount(hookFlags, finishedWork),
          recordEffectDuration())
        : commitHookEffectListMount(hookFlags, finishedWork);
    }
    function commitHookLayoutUnmountEffects(
      finishedWork,
      nearestMountedAncestor,
      hookFlags
    ) {
      shouldProfile(finishedWork)
        ? (startEffectTimer(),
          commitHookEffectListUnmount(
            hookFlags,
            finishedWork,
            nearestMountedAncestor
          ),
          recordEffectDuration())
        : commitHookEffectListUnmount(
            hookFlags,
            finishedWork,
            nearestMountedAncestor
          );
    }
    function commitHookEffectListMount(flags, finishedWork) {
      try {
        var updateQueue = finishedWork.updateQueue,
          lastEffect = null !== updateQueue ? updateQueue.lastEffect : null;
        if (null !== lastEffect) {
          var firstEffect = lastEffect.next;
          updateQueue = firstEffect;
          do {
            if (
              (updateQueue.tag & flags) === flags &&
              ((lastEffect = void 0),
              (flags & Insertion) !== NoFlags &&
                (isRunningInsertionEffect = !0),
              (lastEffect = runWithFiberInDEV(
                finishedWork,
                callCreateInDEV,
                updateQueue
              )),
              (flags & Insertion) !== NoFlags &&
                (isRunningInsertionEffect = !1),
              void 0 !== lastEffect && "function" !== typeof lastEffect)
            ) {
              var hookName = void 0;
              hookName =
                0 !== (updateQueue.tag & Layout)
                  ? "useLayoutEffect"
                  : 0 !== (updateQueue.tag & Insertion)
                    ? "useInsertionEffect"
                    : "useEffect";
              var addendum = void 0;
              addendum =
                null === lastEffect
                  ? " You returned null. If your effect does not require clean up, return undefined (or nothing)."
                  : "function" === typeof lastEffect.then
                    ? "\n\nIt looks like you wrote " +
                      hookName +
                      "(async () => ...) or returned a Promise. Instead, write the async function inside your effect and call it immediately:\n\n" +
                      hookName +
                      "(() => {\n  async function fetchData() {\n    // You can await here\n    const response = await MyAPI.getData(someId);\n    // ...\n  }\n  fetchData();\n}, [someId]); // Or [] if effect doesn't need props or state\n\nLearn more about data fetching with Hooks: https://react.dev/link/hooks-data-fetching"
                    : " You returned: " + lastEffect;
              runWithFiberInDEV(
                finishedWork,
                function (n, a) {
                  console.error(
                    "%s must not return anything besides a function, which is used for clean-up.%s",
                    n,
                    a
                  );
                },
                hookName,
                addendum
              );
            }
            updateQueue = updateQueue.next;
          } while (updateQueue !== firstEffect);
        }
      } catch (error) {
        captureCommitPhaseError(finishedWork, finishedWork.return, error);
      }
    }
    function commitHookEffectListUnmount(
      flags,
      finishedWork,
      nearestMountedAncestor
    ) {
      try {
        var updateQueue = finishedWork.updateQueue,
          lastEffect = null !== updateQueue ? updateQueue.lastEffect : null;
        if (null !== lastEffect) {
          var firstEffect = lastEffect.next;
          updateQueue = firstEffect;
          do {
            if ((updateQueue.tag & flags) === flags) {
              var inst = updateQueue.inst,
                destroy = inst.destroy;
              void 0 !== destroy &&
                ((inst.destroy = void 0),
                (flags & Insertion) !== NoFlags &&
                  (isRunningInsertionEffect = !0),
                (lastEffect = finishedWork),
                runWithFiberInDEV(
                  lastEffect,
                  callDestroyInDEV,
                  lastEffect,
                  nearestMountedAncestor,
                  destroy
                ),
                (flags & Insertion) !== NoFlags &&
                  (isRunningInsertionEffect = !1));
            }
            updateQueue = updateQueue.next;
          } while (updateQueue !== firstEffect);
        }
      } catch (error) {
        captureCommitPhaseError(finishedWork, finishedWork.return, error);
      }
    }
    function commitHookPassiveMountEffects(finishedWork, hookFlags) {
      shouldProfile(finishedWork)
        ? (startEffectTimer(),
          commitHookEffectListMount(hookFlags, finishedWork),
          recordEffectDuration())
        : commitHookEffectListMount(hookFlags, finishedWork);
    }
    function commitHookPassiveUnmountEffects(
      finishedWork,
      nearestMountedAncestor,
      hookFlags
    ) {
      shouldProfile(finishedWork)
        ? (startEffectTimer(),
          commitHookEffectListUnmount(
            hookFlags,
            finishedWork,
            nearestMountedAncestor
          ),
          recordEffectDuration())
        : commitHookEffectListUnmount(
            hookFlags,
            finishedWork,
            nearestMountedAncestor
          );
    }
    function commitClassCallbacks(finishedWork) {
      var updateQueue = finishedWork.updateQueue;
      if (null !== updateQueue) {
        var instance = finishedWork.stateNode;
        finishedWork.type.defaultProps ||
          "ref" in finishedWork.memoizedProps ||
          didWarnAboutReassigningProps ||
          (instance.props !== finishedWork.memoizedProps &&
            console.error(
              "Expected %s props to match memoized props before processing the update queue. This might either be because of a bug in React, or because a component reassigns its own `this.props`. Please file an issue.",
              getComponentNameFromFiber(finishedWork) || "instance"
            ),
          instance.state !== finishedWork.memoizedState &&
            console.error(
              "Expected %s state to match memoized state before processing the update queue. This might either be because of a bug in React, or because a component reassigns its own `this.state`. Please file an issue.",
              getComponentNameFromFiber(finishedWork) || "instance"
            ));
        try {
          runWithFiberInDEV(
            finishedWork,
            commitCallbacks,
            updateQueue,
            instance
          );
        } catch (error) {
          captureCommitPhaseError(finishedWork, finishedWork.return, error);
        }
      }
    }
    function callGetSnapshotBeforeUpdates(instance, prevProps, prevState) {
      return instance.getSnapshotBeforeUpdate(prevProps, prevState);
    }
    function commitClassSnapshot(finishedWork, current) {
      var prevProps = current.memoizedProps,
        prevState = current.memoizedState;
      current = finishedWork.stateNode;
      finishedWork.type.defaultProps ||
        "ref" in finishedWork.memoizedProps ||
        didWarnAboutReassigningProps ||
        (current.props !== finishedWork.memoizedProps &&
          console.error(
            "Expected %s props to match memoized props before getSnapshotBeforeUpdate. This might either be because of a bug in React, or because a component reassigns its own `this.props`. Please file an issue.",
            getComponentNameFromFiber(finishedWork) || "instance"
          ),
        current.state !== finishedWork.memoizedState &&
          console.error(
            "Expected %s state to match memoized state before getSnapshotBeforeUpdate. This might either be because of a bug in React, or because a component reassigns its own `this.state`. Please file an issue.",
            getComponentNameFromFiber(finishedWork) || "instance"
          ));
      try {
        var resolvedPrevProps = resolveClassComponentProps(
          finishedWork.type,
          prevProps
        );
        var snapshot = runWithFiberInDEV(
          finishedWork,
          callGetSnapshotBeforeUpdates,
          current,
          resolvedPrevProps,
          prevState
        );
        prevProps = didWarnAboutUndefinedSnapshotBeforeUpdate;
        void 0 !== snapshot ||
          prevProps.has(finishedWork.type) ||
          (prevProps.add(finishedWork.type),
          runWithFiberInDEV(finishedWork, function () {
            console.error(
              "%s.getSnapshotBeforeUpdate(): A snapshot value (or null) must be returned. You have returned undefined.",
              getComponentNameFromFiber(finishedWork)
            );
          }));
        current.__reactInternalSnapshotBeforeUpdate = snapshot;
      } catch (error) {
        captureCommitPhaseError(finishedWork, finishedWork.return, error);
      }
    }
    function safelyCallComponentWillUnmount(
      current,
      nearestMountedAncestor,
      instance
    ) {
      instance.props = resolveClassComponentProps(
        current.type,
        current.memoizedProps
      );
      instance.state = current.memoizedState;
      shouldProfile(current)
        ? (startEffectTimer(),
          runWithFiberInDEV(
            current,
            callComponentWillUnmountInDEV,
            current,
            nearestMountedAncestor,
            instance
          ),
          recordEffectDuration())
        : runWithFiberInDEV(
            current,
            callComponentWillUnmountInDEV,
            current,
            nearestMountedAncestor,
            instance
          );
    }
    function commitAttachRef(finishedWork) {
      var ref = finishedWork.ref;
      if (null !== ref) {
        switch (finishedWork.tag) {
          case 26:
          case 27:
          case 5:
            var instanceToUse = finishedWork.stateNode;
            break;
          case 30:
            instanceToUse = finishedWork.stateNode;
            var name = getViewTransitionName(
              finishedWork.memoizedProps,
              instanceToUse
            );
            if (null === instanceToUse.ref || instanceToUse.ref.name !== name)
              instanceToUse.ref = createViewTransitionInstance(name);
            instanceToUse = instanceToUse.ref;
            break;
          case 7:
            null === finishedWork.stateNode &&
              (finishedWork.stateNode = new FragmentInstance(finishedWork));
            instanceToUse = finishedWork.stateNode;
            break;
          default:
            instanceToUse = finishedWork.stateNode;
        }
        if ("function" === typeof ref)
          if (shouldProfile(finishedWork))
            try {
              startEffectTimer(),
                (finishedWork.refCleanup = ref(instanceToUse));
            } finally {
              recordEffectDuration();
            }
          else finishedWork.refCleanup = ref(instanceToUse);
        else
          "string" === typeof ref
            ? console.error("String refs are no longer supported.")
            : ref.hasOwnProperty("current") ||
              console.error(
                "Unexpected ref object provided for %s. Use either a ref-setter function or React.createRef().",
                getComponentNameFromFiber(finishedWork)
              ),
            (ref.current = instanceToUse);
      }
    }
    function safelyAttachRef(current, nearestMountedAncestor) {
      try {
        runWithFiberInDEV(current, commitAttachRef, current);
      } catch (error) {
        captureCommitPhaseError(current, nearestMountedAncestor, error);
      }
    }
    function safelyDetachRef(current, nearestMountedAncestor) {
      var ref = current.ref,
        refCleanup = current.refCleanup;
      if (null !== ref)
        if ("function" === typeof refCleanup)
          try {
            if (shouldProfile(current))
              try {
                startEffectTimer(), runWithFiberInDEV(current, refCleanup);
              } finally {
                recordEffectDuration(current);
              }
            else runWithFiberInDEV(current, refCleanup);
          } catch (error) {
            captureCommitPhaseError(current, nearestMountedAncestor, error);
          } finally {
            (current.refCleanup = null),
              (current = current.alternate),
              null != current && (current.refCleanup = null);
          }
        else if ("function" === typeof ref)
          try {
            if (shouldProfile(current))
              try {
                startEffectTimer(), runWithFiberInDEV(current, ref, null);
              } finally {
                recordEffectDuration(current);
              }
            else runWithFiberInDEV(current, ref, null);
          } catch (error$7) {
            captureCommitPhaseError(current, nearestMountedAncestor, error$7);
          }
        else ref.current = null;
    }
    function commitProfiler(
      finishedWork,
      current,
      commitStartTime,
      effectDuration
    ) {
      var _finishedWork$memoize = finishedWork.memoizedProps,
        id = _finishedWork$memoize.id,
        onCommit = _finishedWork$memoize.onCommit;
      _finishedWork$memoize = _finishedWork$memoize.onRender;
      current = null === current ? "mount" : "update";
      currentUpdateIsNested && (current = "nested-update");
      "function" === typeof _finishedWork$memoize &&
        _finishedWork$memoize(
          id,
          current,
          finishedWork.actualDuration,
          finishedWork.treeBaseDuration,
          finishedWork.actualStartTime,
          commitStartTime
        );
      "function" === typeof onCommit &&
        onCommit(id, current, effectDuration, commitStartTime);
    }
    function commitProfilerPostCommitImpl(
      finishedWork,
      current,
      commitStartTime,
      passiveEffectDuration
    ) {
      var _finishedWork$memoize2 = finishedWork.memoizedProps;
      finishedWork = _finishedWork$memoize2.id;
      _finishedWork$memoize2 = _finishedWork$memoize2.onPostCommit;
      current = null === current ? "mount" : "update";
      currentUpdateIsNested && (current = "nested-update");
      "function" === typeof _finishedWork$memoize2 &&
        _finishedWork$memoize2(
          finishedWork,
          current,
          passiveEffectDuration,
          commitStartTime
        );
    }
    function commitHostMount(finishedWork) {
      var type = finishedWork.type,
        props = finishedWork.memoizedProps,
        instance = finishedWork.stateNode;
      try {
        runWithFiberInDEV(
          finishedWork,
          commitMount,
          instance,
          type,
          props,
          finishedWork
        );
      } catch (error) {
        captureCommitPhaseError(finishedWork, finishedWork.return, error);
      }
    }
    function commitHostUpdate(finishedWork, newProps, oldProps) {
      try {
        runWithFiberInDEV(
          finishedWork,
          commitUpdate,
          finishedWork.stateNode,
          finishedWork.type,
          oldProps,
          newProps,
          finishedWork
        );
      } catch (error) {
        captureCommitPhaseError(finishedWork, finishedWork.return, error);
      }
    }
    function commitNewChildToFragmentInstances(fiber, parentFragmentInstances) {
      if (
        5 === fiber.tag &&
        null === fiber.alternate &&
        null !== parentFragmentInstances
      )
        for (var i = 0; i < parentFragmentInstances.length; i++)
          commitNewChildToFragmentInstance(
            fiber.stateNode,
            parentFragmentInstances[i]
          );
    }
    function commitFragmentInstanceDeletionEffects(fiber) {
      for (var parent = fiber.return; null !== parent; ) {
        if (isFragmentInstanceParent(parent)) {
          var childElement = fiber.stateNode,
            eventListeners = parent.stateNode._eventListeners;
          if (null !== eventListeners)
            for (var i = 0; i < eventListeners.length; i++) {
              var _eventListeners$i3 = eventListeners[i];
              childElement.removeEventListener(
                _eventListeners$i3.type,
                _eventListeners$i3.listener,
                _eventListeners$i3.optionsOrUseCapture
              );
            }
        }
        if (isHostParent(parent)) break;
        parent = parent.return;
      }
    }
    function isHostParent(fiber) {
      return (
        5 === fiber.tag ||
        3 === fiber.tag ||
        26 === fiber.tag ||
        (27 === fiber.tag && isSingletonScope(fiber.type)) ||
        4 === fiber.tag
      );
    }
    function isFragmentInstanceParent(fiber) {
      return fiber && 7 === fiber.tag && null !== fiber.stateNode;
    }
    function getHostSibling(fiber) {
      a: for (;;) {
        for (; null === fiber.sibling; ) {
          if (null === fiber.return || isHostParent(fiber.return)) return null;
          fiber = fiber.return;
        }
        fiber.sibling.return = fiber.return;
        for (
          fiber = fiber.sibling;
          5 !== fiber.tag && 6 !== fiber.tag && 18 !== fiber.tag;

        ) {
          if (27 === fiber.tag && isSingletonScope(fiber.type)) continue a;
          if (fiber.flags & 2) continue a;
          if (null === fiber.child || 4 === fiber.tag) continue a;
          else (fiber.child.return = fiber), (fiber = fiber.child);
        }
        if (!(fiber.flags & 2)) return fiber.stateNode;
      }
    }
    function insertOrAppendPlacementNodeIntoContainer(
      node,
      before,
      parent,
      parentFragmentInstances
    ) {
      var tag = node.tag;
      if (5 === tag || 6 === tag)
        (tag = node.stateNode),
          before
            ? (warnForReactChildrenConflict(parent),
              (9 === parent.nodeType
                ? parent.body
                : "HTML" === parent.nodeName
                  ? parent.ownerDocument.body
                  : parent
              ).insertBefore(tag, before))
            : (warnForReactChildrenConflict(parent),
              (before =
                9 === parent.nodeType
                  ? parent.body
                  : "HTML" === parent.nodeName
                    ? parent.ownerDocument.body
                    : parent),
              before.appendChild(tag),
              (tag = parent._reactRootContainer),
              (null !== tag && void 0 !== tag) ||
                null !== before.onclick ||
                (before.onclick = noop$1)),
          commitNewChildToFragmentInstances(node, parentFragmentInstances),
          (viewTransitionMutationContext = !0);
      else if (
        4 !== tag &&
        (27 === tag &&
          isSingletonScope(node.type) &&
          ((parent = node.stateNode), (before = null)),
        (node = node.child),
        null !== node)
      )
        for (
          insertOrAppendPlacementNodeIntoContainer(
            node,
            before,
            parent,
            parentFragmentInstances
          ),
            node = node.sibling;
          null !== node;

        )
          insertOrAppendPlacementNodeIntoContainer(
            node,
            before,
            parent,
            parentFragmentInstances
          ),
            (node = node.sibling);
    }
    function insertOrAppendPlacementNode(
      node,
      before,
      parent,
      parentFragmentInstances
    ) {
      var tag = node.tag;
      if (5 === tag || 6 === tag)
        (tag = node.stateNode),
          before ? parent.insertBefore(tag, before) : parent.appendChild(tag),
          commitNewChildToFragmentInstances(node, parentFragmentInstances),
          (viewTransitionMutationContext = !0);
      else if (
        4 !== tag &&
        (27 === tag && isSingletonScope(node.type) && (parent = node.stateNode),
        (node = node.child),
        null !== node)
      )
        for (
          insertOrAppendPlacementNode(
            node,
            before,
            parent,
            parentFragmentInstances
          ),
            node = node.sibling;
          null !== node;

        )
          insertOrAppendPlacementNode(
            node,
            before,
            parent,
            parentFragmentInstances
          ),
            (node = node.sibling);
    }
    function commitPlacement(finishedWork) {
      for (
        var hostParentFiber,
          parentFragmentInstances = null,
          parentFiber = finishedWork.return;
        null !== parentFiber;

      ) {
        if (isFragmentInstanceParent(parentFiber)) {
          var fragmentInstance = parentFiber.stateNode;
          null === parentFragmentInstances
            ? (parentFragmentInstances = [fragmentInstance])
            : parentFragmentInstances.push(fragmentInstance);
        }
        if (isHostParent(parentFiber)) {
          hostParentFiber = parentFiber;
          break;
        }
        parentFiber = parentFiber.return;
      }
      if (null == hostParentFiber)
        throw Error(
          "Expected to find a host parent. This error is likely caused by a bug in React. Please file an issue."
        );
      switch (hostParentFiber.tag) {
        case 27:
          hostParentFiber = hostParentFiber.stateNode;
          parentFiber = getHostSibling(finishedWork);
          insertOrAppendPlacementNode(
            finishedWork,
            parentFiber,
            hostParentFiber,
            parentFragmentInstances
          );
          break;
        case 5:
          parentFiber = hostParentFiber.stateNode;
          hostParentFiber.flags & 32 &&
            (resetTextContent(parentFiber), (hostParentFiber.flags &= -33));
          hostParentFiber = getHostSibling(finishedWork);
          insertOrAppendPlacementNode(
            finishedWork,
            hostParentFiber,
            parentFiber,
            parentFragmentInstances
          );
          break;
        case 3:
        case 4:
          hostParentFiber = hostParentFiber.stateNode.containerInfo;
          parentFiber = getHostSibling(finishedWork);
          insertOrAppendPlacementNodeIntoContainer(
            finishedWork,
            parentFiber,
            hostParentFiber,
            parentFragmentInstances
          );
          break;
        default:
          throw Error(
            "Invalid host parent fiber. This error is likely caused by a bug in React. Please file an issue."
          );
      }
    }
    function commitHostSingletonAcquisition(finishedWork) {
      var singleton = finishedWork.stateNode,
        props = finishedWork.memoizedProps;
      try {
        runWithFiberInDEV(
          finishedWork,
          acquireSingletonInstance,
          finishedWork.type,
          props,
          singleton,
          finishedWork
        );
      } catch (error) {
        captureCommitPhaseError(finishedWork, finishedWork.return, error);
      }
    }
    function trackEnterViewTransitions$1(placement) {
      if (30 === placement.tag || 0 !== (placement.subtreeFlags & 33554432))
        shouldStartViewTransition = !0;
    }
    function pushViewTransitionCancelableScope() {
      var prevChildren = viewTransitionCancelableChildren;
      viewTransitionCancelableChildren = null;
      return prevChildren;
    }
    function applyViewTransitionToHostInstances(
      child,
      name,
      className,
      collectMeasurements,
      stopAtNestedViewTransitions
    ) {
      viewTransitionHostInstanceIdx = 0;
      return applyViewTransitionToHostInstancesRecursive(
        child,
        name,
        className,
        collectMeasurements,
        stopAtNestedViewTransitions
      );
    }
    function applyViewTransitionToHostInstancesRecursive(
      child,
      name,
      className,
      collectMeasurements,
      stopAtNestedViewTransitions
    ) {
      for (var inViewport = !1; null !== child; ) {
        if (5 === child.tag) {
          var instance = child.stateNode;
          if (null !== collectMeasurements) {
            var measurement = measureInstance(instance);
            collectMeasurements.push(measurement);
            measurement.view && (inViewport = !0);
          } else
            inViewport || (measureInstance(instance).view && (inViewport = !0));
          shouldStartViewTransition = !0;
          applyViewTransitionName(
            instance,
            0 === viewTransitionHostInstanceIdx
              ? name
              : name + "_" + viewTransitionHostInstanceIdx,
            className
          );
          viewTransitionHostInstanceIdx++;
        } else if (22 !== child.tag || null === child.memoizedState)
          (30 === child.tag && stopAtNestedViewTransitions) ||
            (applyViewTransitionToHostInstancesRecursive(
              child.child,
              name,
              className,
              collectMeasurements,
              stopAtNestedViewTransitions
            ) &&
              (inViewport = !0));
        child = child.sibling;
      }
      return inViewport;
    }
    function restoreViewTransitionOnHostInstances(
      child,
      stopAtNestedViewTransitions
    ) {
      for (; null !== child; ) {
        if (5 === child.tag)
          restoreViewTransitionName(child.stateNode, child.memoizedProps);
        else if (22 !== child.tag || null === child.memoizedState)
          (30 === child.tag && stopAtNestedViewTransitions) ||
            restoreViewTransitionOnHostInstances(
              child.child,
              stopAtNestedViewTransitions
            );
        child = child.sibling;
      }
    }
    function commitAppearingPairViewTransitions(placement) {
      if (0 !== (placement.subtreeFlags & 18874368))
        for (placement = placement.child; null !== placement; ) {
          if (22 !== placement.tag || null !== placement.memoizedState)
            if (
              (commitAppearingPairViewTransitions(placement),
              30 === placement.tag &&
                0 !== (placement.flags & 18874368) &&
                placement.stateNode.paired)
            ) {
              var props = placement.memoizedProps;
              if (null == props.name || "auto" === props.name)
                throw Error(
                  "Found a pair with an auto name. This is a bug in React."
                );
              var name = props.name;
              props = getViewTransitionClassName(props.default, props.share);
              "none" !== props &&
                (applyViewTransitionToHostInstances(
                  placement.child,
                  name,
                  props,
                  null,
                  !1
                ) ||
                  restoreViewTransitionOnHostInstances(placement.child, !1));
            }
          placement = placement.sibling;
        }
    }
    function commitEnterViewTransitions(placement, gesture) {
      if (30 === placement.tag) {
        var state = placement.stateNode,
          props = placement.memoizedProps,
          name = getViewTransitionName(props, state),
          className = getViewTransitionClassName(
            props.default,
            state.paired ? props.share : props.enter
          );
        "none" !== className
          ? applyViewTransitionToHostInstances(
              placement.child,
              name,
              className,
              null,
              !1
            )
            ? (commitAppearingPairViewTransitions(placement),
              state.paired ||
                gesture ||
                scheduleViewTransitionEvent(placement, props.onEnter))
            : restoreViewTransitionOnHostInstances(placement.child, !1)
          : commitAppearingPairViewTransitions(placement);
      } else if (0 !== (placement.subtreeFlags & 33554432))
        for (placement = placement.child; null !== placement; )
          commitEnterViewTransitions(placement, gesture),
            (placement = placement.sibling);
      else commitAppearingPairViewTransitions(placement);
    }
    function commitDeletedPairViewTransitions(deletion) {
      if (
        null !== appearingViewTransitions &&
        0 !== appearingViewTransitions.size
      ) {
        var pairs = appearingViewTransitions;
        if (0 !== (deletion.subtreeFlags & 18874368))
          for (deletion = deletion.child; null !== deletion; ) {
            if (22 !== deletion.tag || null !== deletion.memoizedState) {
              if (30 === deletion.tag && 0 !== (deletion.flags & 18874368)) {
                var props = deletion.memoizedProps,
                  name = props.name;
                if (null != name && "auto" !== name) {
                  var pair = pairs.get(name);
                  if (void 0 !== pair) {
                    var className = getViewTransitionClassName(
                      props.default,
                      props.share
                    );
                    "none" !== className &&
                      (applyViewTransitionToHostInstances(
                        deletion.child,
                        name,
                        className,
                        null,
                        !1
                      )
                        ? ((className = deletion.stateNode),
                          (pair.paired = className),
                          (className.paired = pair),
                          scheduleViewTransitionEvent(deletion, props.onShare))
                        : restoreViewTransitionOnHostInstances(
                            deletion.child,
                            !1
                          ));
                    pairs.delete(name);
                    if (0 === pairs.size) break;
                  }
                }
              }
              commitDeletedPairViewTransitions(deletion);
            }
            deletion = deletion.sibling;
          }
      }
    }
    function commitExitViewTransitions(deletion) {
      if (30 === deletion.tag) {
        var props = deletion.memoizedProps,
          name = getViewTransitionName(props, deletion.stateNode),
          pair =
            null !== appearingViewTransitions
              ? appearingViewTransitions.get(name)
              : void 0,
          className = getViewTransitionClassName(
            props.default,
            void 0 !== pair ? props.share : props.exit
          );
        "none" !== className &&
          (applyViewTransitionToHostInstances(
            deletion.child,
            name,
            className,
            null,
            !1
          )
            ? void 0 !== pair
              ? ((className = deletion.stateNode),
                (pair.paired = className),
                (className.paired = pair),
                appearingViewTransitions.delete(name),
                scheduleViewTransitionEvent(deletion, props.onShare))
              : scheduleViewTransitionEvent(deletion, props.onExit)
            : restoreViewTransitionOnHostInstances(deletion.child, !1));
        null !== appearingViewTransitions &&
          commitDeletedPairViewTransitions(deletion);
      } else if (0 !== (deletion.subtreeFlags & 33554432))
        for (deletion = deletion.child; null !== deletion; )
          commitExitViewTransitions(deletion), (deletion = deletion.sibling);
      else
        null !== appearingViewTransitions &&
          commitDeletedPairViewTransitions(deletion);
    }
    function commitNestedViewTransitions(changedParent) {
      for (changedParent = changedParent.child; null !== changedParent; ) {
        if (30 === changedParent.tag) {
          var props = changedParent.memoizedProps,
            name = getViewTransitionName(props, changedParent.stateNode);
          props = getViewTransitionClassName(props.default, props.update);
          changedParent.flags &= -5;
          "none" !== props &&
            applyViewTransitionToHostInstances(
              changedParent.child,
              name,
              props,
              (changedParent.memoizedState = []),
              !1
            );
        } else
          0 !== (changedParent.subtreeFlags & 33554432) &&
            commitNestedViewTransitions(changedParent);
        changedParent = changedParent.sibling;
      }
    }
    function restorePairedViewTransitions(parent) {
      if (0 !== (parent.subtreeFlags & 18874368))
        for (parent = parent.child; null !== parent; ) {
          if (22 !== parent.tag || null !== parent.memoizedState) {
            if (30 === parent.tag && 0 !== (parent.flags & 18874368)) {
              var instance = parent.stateNode;
              null !== instance.paired &&
                ((instance.paired = null),
                restoreViewTransitionOnHostInstances(parent.child, !1));
            }
            restorePairedViewTransitions(parent);
          }
          parent = parent.sibling;
        }
    }
    function restoreEnterOrExitViewTransitions(fiber) {
      if (30 === fiber.tag)
        (fiber.stateNode.paired = null),
          restoreViewTransitionOnHostInstances(fiber.child, !1),
          restorePairedViewTransitions(fiber);
      else if (0 !== (fiber.subtreeFlags & 33554432))
        for (fiber = fiber.child; null !== fiber; )
          restoreEnterOrExitViewTransitions(fiber), (fiber = fiber.sibling);
      else restorePairedViewTransitions(fiber);
    }
    function restoreNestedViewTransitions(changedParent) {
      for (changedParent = changedParent.child; null !== changedParent; )
        30 === changedParent.tag
          ? restoreViewTransitionOnHostInstances(changedParent.child, !1)
          : 0 !== (changedParent.subtreeFlags & 33554432) &&
            restoreNestedViewTransitions(changedParent),
          (changedParent = changedParent.sibling);
    }
    function measureViewTransitionHostInstancesRecursive(
      parentViewTransition,
      child,
      newName,
      oldName,
      className,
      previousMeasurements,
      stopAtNestedViewTransitions
    ) {
      for (var inViewport = !1; null !== child; ) {
        if (5 === child.tag) {
          var instance = child.stateNode;
          if (
            null !== previousMeasurements &&
            viewTransitionHostInstanceIdx < previousMeasurements.length
          ) {
            var previousMeasurement =
                previousMeasurements[viewTransitionHostInstanceIdx],
              nextMeasurement = measureInstance(instance);
            if (previousMeasurement.view || nextMeasurement.view)
              inViewport = !0;
            var JSCompiler_temp;
            if ((JSCompiler_temp = 0 === (parentViewTransition.flags & 4)))
              if (nextMeasurement.clip) JSCompiler_temp = !0;
              else {
                JSCompiler_temp = previousMeasurement.rect;
                var newRect = nextMeasurement.rect;
                JSCompiler_temp =
                  JSCompiler_temp.y !== newRect.y ||
                  JSCompiler_temp.x !== newRect.x ||
                  JSCompiler_temp.height !== newRect.height ||
                  JSCompiler_temp.width !== newRect.width;
              }
            JSCompiler_temp && (parentViewTransition.flags |= 4);
            nextMeasurement.abs
              ? (nextMeasurement = !previousMeasurement.abs)
              : ((previousMeasurement = previousMeasurement.rect),
                (nextMeasurement = nextMeasurement.rect),
                (nextMeasurement =
                  previousMeasurement.height !== nextMeasurement.height ||
                  previousMeasurement.width !== nextMeasurement.width));
            nextMeasurement && (parentViewTransition.flags |= 32);
          } else parentViewTransition.flags |= 32;
          0 !== (parentViewTransition.flags & 4) &&
            applyViewTransitionName(
              instance,
              0 === viewTransitionHostInstanceIdx
                ? newName
                : newName + "_" + viewTransitionHostInstanceIdx,
              className
            );
          (inViewport && 0 !== (parentViewTransition.flags & 4)) ||
            (null === viewTransitionCancelableChildren &&
              (viewTransitionCancelableChildren = []),
            viewTransitionCancelableChildren.push(
              instance,
              oldName,
              child.memoizedProps
            ));
          viewTransitionHostInstanceIdx++;
        } else if (22 !== child.tag || null === child.memoizedState)
          30 === child.tag && stopAtNestedViewTransitions
            ? (parentViewTransition.flags |= child.flags & 32)
            : measureViewTransitionHostInstancesRecursive(
                parentViewTransition,
                child.child,
                newName,
                oldName,
                className,
                previousMeasurements,
                stopAtNestedViewTransitions
              ) && (inViewport = !0);
        child = child.sibling;
      }
      return inViewport;
    }
    function measureUpdateViewTransition(current, finishedWork, gesture) {
      var oldFiber = gesture ? finishedWork : current,
        newFiber = gesture ? current : finishedWork,
        props = newFiber.memoizedProps,
        state = newFiber.stateNode;
      current = getViewTransitionName(props, state);
      var oldName = getViewTransitionName(oldFiber.memoizedProps, state);
      props = getViewTransitionClassName(props.default, props.update);
      if ("none" === props) return !1;
      gesture
        ? ((oldFiber = state.clones),
          (gesture =
            null === oldFiber ? null : oldFiber.map(measureClonedInstance)))
        : ((gesture = oldFiber.memoizedState), (oldFiber.memoizedState = null));
      oldFiber = newFiber.child;
      viewTransitionHostInstanceIdx = 0;
      current = measureViewTransitionHostInstancesRecursive(
        finishedWork,
        oldFiber,
        current,
        oldName,
        props,
        gesture,
        !0
      );
      viewTransitionHostInstanceIdx !==
        (null === gesture ? 0 : gesture.length) && (finishedWork.flags |= 32);
      return current;
    }
    function measureNestedViewTransitions(changedParent, gesture) {
      for (changedParent = changedParent.child; null !== changedParent; ) {
        if (30 === changedParent.tag) {
          var props = changedParent.memoizedProps,
            state = changedParent.stateNode,
            name = getViewTransitionName(props, state),
            className = getViewTransitionClassName(props.default, props.update);
          if (gesture) {
            state = state.clones;
            var previousMeasurements =
              null === state ? null : state.map(measureClonedInstance);
          } else
            (previousMeasurements = changedParent.memoizedState),
              (changedParent.memoizedState = null);
          state = changedParent;
          var child = changedParent.child,
            newName = name;
          viewTransitionHostInstanceIdx = 0;
          className = measureViewTransitionHostInstancesRecursive(
            state,
            child,
            newName,
            name,
            className,
            previousMeasurements,
            !1
          );
          0 !== (changedParent.flags & 4) &&
            className &&
            (gesture ||
              scheduleViewTransitionEvent(changedParent, props.onUpdate));
        } else
          0 !== (changedParent.subtreeFlags & 33554432) &&
            measureNestedViewTransitions(changedParent, gesture);
        changedParent = changedParent.sibling;
      }
    }
    function trackNamedViewTransition(fiber) {
      var name = fiber.memoizedProps.name;
      if (null != name && "auto" !== name) {
        var existing = mountedNamedViewTransitions.get(name);
        if (void 0 !== existing) {
          if (
            existing !== fiber &&
            existing !== fiber.alternate &&
            !didWarnAboutName[name]
          ) {
            didWarnAboutName[name] = !0;
            var stringifiedName = JSON.stringify(name);
            runWithFiberInDEV(fiber, function () {
              console.error(
                "There are two <ViewTransition name=%s> components with the same name mounted at the same time. This is not supported and will cause View Transitions to error. Try to use a more unique name e.g. by using a namespace prefix and adding the id of an item to the name.",
                stringifiedName
              );
            });
            runWithFiberInDEV(existing, function () {
              console.error(
                "The existing <ViewTransition name=%s> duplicate has this stack trace.",
                stringifiedName
              );
            });
          }
        } else mountedNamedViewTransitions.set(name, fiber);
      }
    }
    function untrackNamedViewTransition(fiber) {
      var name = fiber.memoizedProps.name;
      if (null != name && "auto" !== name) {
        var existing = mountedNamedViewTransitions.get(name);
        void 0 === existing ||
          (existing !== fiber && existing !== fiber.alternate) ||
          mountedNamedViewTransitions.delete(name);
      }
    }
    function isHydratingParent(current, finishedWork) {
      return 31 === finishedWork.tag
        ? ((finishedWork = finishedWork.memoizedState),
          null !== current.memoizedState && null === finishedWork)
        : 13 === finishedWork.tag
          ? ((current = current.memoizedState),
            (finishedWork = finishedWork.memoizedState),
            null !== current &&
              null !== current.dehydrated &&
              (null === finishedWork || null === finishedWork.dehydrated))
          : 3 === finishedWork.tag
            ? current.memoizedState.isDehydrated &&
              0 === (finishedWork.flags & 256)
            : !1;
    }
    function commitBeforeMutationEffects(root, firstChild, committedLanes) {
      root = root.containerInfo;
      eventsEnabled = _enabled;
      root = getActiveElementDeep(root);
      if (hasSelectionCapabilities(root)) {
        if ("selectionStart" in root)
          var JSCompiler_temp = {
            start: root.selectionStart,
            end: root.selectionEnd
          };
        else
          a: {
            JSCompiler_temp =
              ((JSCompiler_temp = root.ownerDocument) &&
                JSCompiler_temp.defaultView) ||
              window;
            var selection =
              JSCompiler_temp.getSelection && JSCompiler_temp.getSelection();
            if (selection && 0 !== selection.rangeCount) {
              JSCompiler_temp = selection.anchorNode;
              var anchorOffset = selection.anchorOffset,
                focusNode = selection.focusNode;
              selection = selection.focusOffset;
              try {
                JSCompiler_temp.nodeType, focusNode.nodeType;
              } catch (e$2) {
                JSCompiler_temp = null;
                break a;
              }
              var length = 0,
                start = -1,
                end = -1,
                indexWithinAnchor = 0,
                indexWithinFocus = 0,
                node = root,
                parentNode = null;
              b: for (;;) {
                for (var next; ; ) {
                  node !== JSCompiler_temp ||
                    (0 !== anchorOffset && 3 !== node.nodeType) ||
                    (start = length + anchorOffset);
                  node !== focusNode ||
                    (0 !== selection && 3 !== node.nodeType) ||
                    (end = length + selection);
                  3 === node.nodeType && (length += node.nodeValue.length);
                  if (null === (next = node.firstChild)) break;
                  parentNode = node;
                  node = next;
                }
                for (;;) {
                  if (node === root) break b;
                  parentNode === JSCompiler_temp &&
                    ++indexWithinAnchor === anchorOffset &&
                    (start = length);
                  parentNode === focusNode &&
                    ++indexWithinFocus === selection &&
                    (end = length);
                  if (null !== (next = node.nextSibling)) break;
                  node = parentNode;
                  parentNode = node.parentNode;
                }
                node = next;
              }
              JSCompiler_temp =
                -1 === start || -1 === end ? null : { start: start, end: end };
            } else JSCompiler_temp = null;
          }
        JSCompiler_temp = JSCompiler_temp || { start: 0, end: 0 };
      } else JSCompiler_temp = null;
      selectionInformation = {
        focusedElem: root,
        selectionRange: JSCompiler_temp
      };
      _enabled = !1;
      committedLanes = (committedLanes & 335544064) === committedLanes;
      nextEffect = firstChild;
      for (firstChild = committedLanes ? 9270 : 1028; null !== nextEffect; ) {
        root = nextEffect;
        if (
          committedLanes &&
          ((JSCompiler_temp = root.deletions), null !== JSCompiler_temp)
        )
          for (
            anchorOffset = 0;
            anchorOffset < JSCompiler_temp.length;
            anchorOffset++
          )
            committedLanes &&
              commitExitViewTransitions(JSCompiler_temp[anchorOffset]);
        if (null === root.alternate && 0 !== (root.flags & 2))
          committedLanes && trackEnterViewTransitions$1(root),
            commitBeforeMutationEffects_complete(committedLanes);
        else {
          if (22 === root.tag)
            if (
              ((JSCompiler_temp = root.alternate), null !== root.memoizedState)
            ) {
              null !== JSCompiler_temp &&
                null === JSCompiler_temp.memoizedState &&
                committedLanes &&
                commitExitViewTransitions(JSCompiler_temp);
              commitBeforeMutationEffects_complete(committedLanes);
              continue;
            } else if (
              null !== JSCompiler_temp &&
              null !== JSCompiler_temp.memoizedState
            ) {
              committedLanes && trackEnterViewTransitions$1(root);
              commitBeforeMutationEffects_complete(committedLanes);
              continue;
            }
          JSCompiler_temp = root.child;
          0 !== (root.subtreeFlags & firstChild) && null !== JSCompiler_temp
            ? ((JSCompiler_temp.return = root), (nextEffect = JSCompiler_temp))
            : (committedLanes && commitNestedViewTransitions(root),
              commitBeforeMutationEffects_complete(committedLanes));
        }
      }
      appearingViewTransitions = null;
    }
    function commitBeforeMutationEffects_complete(
      isViewTransitionEligible$jscomp$0
    ) {
      for (; null !== nextEffect; ) {
        var fiber = nextEffect,
          finishedWork = fiber,
          isViewTransitionEligible = isViewTransitionEligible$jscomp$0,
          current = finishedWork.alternate,
          flags = finishedWork.flags;
        switch (finishedWork.tag) {
          case 0:
            if (
              0 !== (flags & 4) &&
              ((isViewTransitionEligible = finishedWork.updateQueue),
              (isViewTransitionEligible =
                null !== isViewTransitionEligible
                  ? isViewTransitionEligible.events
                  : null),
              null !== isViewTransitionEligible)
            )
              for (
                finishedWork = 0;
                finishedWork < isViewTransitionEligible.length;
                finishedWork++
              )
                (current = isViewTransitionEligible[finishedWork]),
                  (current.ref.impl = current.nextImpl);
            break;
          case 11:
          case 15:
            break;
          case 1:
            0 !== (flags & 1024) &&
              null !== current &&
              commitClassSnapshot(finishedWork, current);
            break;
          case 3:
            if (0 !== (flags & 1024))
              if (
                ((isViewTransitionEligible =
                  finishedWork.stateNode.containerInfo),
                (finishedWork = isViewTransitionEligible.nodeType),
                9 === finishedWork)
              )
                clearContainerSparingly(isViewTransitionEligible);
              else if (1 === finishedWork)
                switch (isViewTransitionEligible.nodeName) {
                  case "HEAD":
                  case "HTML":
                  case "BODY":
                    clearContainerSparingly(isViewTransitionEligible);
                    break;
                  default:
                    isViewTransitionEligible.textContent = "";
                }
            break;
          case 5:
          case 26:
          case 27:
          case 6:
          case 4:
          case 17:
            break;
          case 30:
            isViewTransitionEligible &&
              null !== current &&
              ((isViewTransitionEligible = current),
              (current = finishedWork),
              (finishedWork = getViewTransitionName(
                isViewTransitionEligible.memoizedProps,
                isViewTransitionEligible.stateNode
              )),
              (current = current.memoizedProps),
              (current = getViewTransitionClassName(
                current.default,
                current.update
              )),
              "none" !== current &&
                applyViewTransitionToHostInstances(
                  isViewTransitionEligible.child,
                  finishedWork,
                  current,
                  (isViewTransitionEligible.memoizedState = []),
                  !0
                ));
            break;
          default:
            if (0 !== (flags & 1024))
              throw Error(
                "This unit of work tag should not have side-effects. This error is likely caused by a bug in React. Please file an issue."
              );
        }
        isViewTransitionEligible = fiber.sibling;
        if (null !== isViewTransitionEligible) {
          isViewTransitionEligible.return = fiber.return;
          nextEffect = isViewTransitionEligible;
          break;
        }
        nextEffect = fiber.return;
      }
    }
    function commitLayoutEffectOnFiber(finishedRoot, current, finishedWork) {
      var prevEffectStart = pushComponentEffectStart(),
        prevEffectDuration = pushComponentEffectDuration(),
        prevEffectErrors = pushComponentEffectErrors(),
        flags = finishedWork.flags;
      switch (finishedWork.tag) {
        case 0:
        case 11:
        case 15:
          recursivelyTraverseLayoutEffects(finishedRoot, finishedWork);
          flags & 4 &&
            commitHookLayoutEffects(finishedWork, Layout | HasEffect);
          break;
        case 1:
          recursivelyTraverseLayoutEffects(finishedRoot, finishedWork);
          if (flags & 4)
            if (((finishedRoot = finishedWork.stateNode), null === current))
              finishedWork.type.defaultProps ||
                "ref" in finishedWork.memoizedProps ||
                didWarnAboutReassigningProps ||
                (finishedRoot.props !== finishedWork.memoizedProps &&
                  console.error(
                    "Expected %s props to match memoized props before componentDidMount. This might either be because of a bug in React, or because a component reassigns its own `this.props`. Please file an issue.",
                    getComponentNameFromFiber(finishedWork) || "instance"
                  ),
                finishedRoot.state !== finishedWork.memoizedState &&
                  console.error(
                    "Expected %s state to match memoized state before componentDidMount. This might either be because of a bug in React, or because a component reassigns its own `this.state`. Please file an issue.",
                    getComponentNameFromFiber(finishedWork) || "instance"
                  )),
                shouldProfile(finishedWork)
                  ? (startEffectTimer(),
                    runWithFiberInDEV(
                      finishedWork,
                      callComponentDidMountInDEV,
                      finishedWork,
                      finishedRoot
                    ),
                    recordEffectDuration())
                  : runWithFiberInDEV(
                      finishedWork,
                      callComponentDidMountInDEV,
                      finishedWork,
                      finishedRoot
                    );
            else {
              var prevProps = resolveClassComponentProps(
                finishedWork.type,
                current.memoizedProps
              );
              current = current.memoizedState;
              finishedWork.type.defaultProps ||
                "ref" in finishedWork.memoizedProps ||
                didWarnAboutReassigningProps ||
                (finishedRoot.props !== finishedWork.memoizedProps &&
                  console.error(
                    "Expected %s props to match memoized props before componentDidUpdate. This might either be because of a bug in React, or because a component reassigns its own `this.props`. Please file an issue.",
                    getComponentNameFromFiber(finishedWork) || "instance"
                  ),
                finishedRoot.state !== finishedWork.memoizedState &&
                  console.error(
                    "Expected %s state to match memoized state before componentDidUpdate. This might either be because of a bug in React, or because a component reassigns its own `this.state`. Please file an issue.",
                    getComponentNameFromFiber(finishedWork) || "instance"
                  ));
              shouldProfile(finishedWork)
                ? (startEffectTimer(),
                  runWithFiberInDEV(
                    finishedWork,
                    callComponentDidUpdateInDEV,
                    finishedWork,
                    finishedRoot,
                    prevProps,
                    current,
                    finishedRoot.__reactInternalSnapshotBeforeUpdate
                  ),
                  recordEffectDuration())
                : runWithFiberInDEV(
                    finishedWork,
                    callComponentDidUpdateInDEV,
                    finishedWork,
                    finishedRoot,
                    prevProps,
                    current,
                    finishedRoot.__reactInternalSnapshotBeforeUpdate
                  );
            }
          flags & 64 && commitClassCallbacks(finishedWork);
          flags & 512 && safelyAttachRef(finishedWork, finishedWork.return);
          break;
        case 3:
          current = pushNestedEffectDurations();
          recursivelyTraverseLayoutEffects(finishedRoot, finishedWork);
          if (
            flags & 64 &&
            ((flags = finishedWork.updateQueue), null !== flags)
          ) {
            prevProps = null;
            if (null !== finishedWork.child)
              switch (finishedWork.child.tag) {
                case 27:
                case 5:
                  prevProps = finishedWork.child.stateNode;
                  break;
                case 1:
                  prevProps = finishedWork.child.stateNode;
              }
            try {
              runWithFiberInDEV(
                finishedWork,
                commitCallbacks,
                flags,
                prevProps
              );
            } catch (error) {
              captureCommitPhaseError(finishedWork, finishedWork.return, error);
            }
          }
          finishedRoot.effectDuration += popNestedEffectDurations(current);
          break;
        case 27:
          null === current &&
            flags & 4 &&
            commitHostSingletonAcquisition(finishedWork);
        case 26:
        case 5:
          recursivelyTraverseLayoutEffects(finishedRoot, finishedWork);
          if (null === current)
            if (flags & 4) commitHostMount(finishedWork);
            else if (flags & 64) {
              finishedRoot = finishedWork.type;
              current = finishedWork.memoizedProps;
              prevProps = finishedWork.stateNode;
              try {
                runWithFiberInDEV(
                  finishedWork,
                  commitHydratedInstance,
                  prevProps,
                  finishedRoot,
                  current,
                  finishedWork
                );
              } catch (error) {
                captureCommitPhaseError(
                  finishedWork,
                  finishedWork.return,
                  error
                );
              }
            }
          flags & 512 && safelyAttachRef(finishedWork, finishedWork.return);
          break;
        case 12:
          if (flags & 4) {
            flags = pushNestedEffectDurations();
            recursivelyTraverseLayoutEffects(finishedRoot, finishedWork);
            finishedRoot = finishedWork.stateNode;
            finishedRoot.effectDuration += bubbleNestedEffectDurations(flags);
            try {
              runWithFiberInDEV(
                finishedWork,
                commitProfiler,
                finishedWork,
                current,
                commitStartTime,
                finishedRoot.effectDuration
              );
            } catch (error) {
              captureCommitPhaseError(finishedWork, finishedWork.return, error);
            }
          } else recursivelyTraverseLayoutEffects(finishedRoot, finishedWork);
          break;
        case 31:
          recursivelyTraverseLayoutEffects(finishedRoot, finishedWork);
          flags & 4 &&
            commitActivityHydrationCallbacks(finishedRoot, finishedWork);
          break;
        case 13:
          recursivelyTraverseLayoutEffects(finishedRoot, finishedWork);
          flags & 4 &&
            commitSuspenseHydrationCallbacks(finishedRoot, finishedWork);
          flags & 64 &&
            ((finishedRoot = finishedWork.memoizedState),
            null !== finishedRoot &&
              ((finishedRoot = finishedRoot.dehydrated),
              null !== finishedRoot &&
                ((flags = retryDehydratedSuspenseBoundary.bind(
                  null,
                  finishedWork
                )),
                registerSuspenseInstanceRetry(finishedRoot, flags))));
          break;
        case 22:
          flags =
            null !== finishedWork.memoizedState || offscreenSubtreeIsHidden;
          if (!flags) {
            current =
              (null !== current && null !== current.memoizedState) ||
              offscreenSubtreeWasHidden;
            prevProps = offscreenSubtreeIsHidden;
            var prevOffscreenSubtreeWasHidden = offscreenSubtreeWasHidden;
            offscreenSubtreeIsHidden = flags;
            (offscreenSubtreeWasHidden = current) &&
            !prevOffscreenSubtreeWasHidden
              ? (recursivelyTraverseReappearLayoutEffects(
                  finishedRoot,
                  finishedWork,
                  0 !== (finishedWork.subtreeFlags & 8772)
                ),
                (finishedWork.mode & ProfileMode) !== NoMode &&
                  0 <= componentEffectStartTime &&
                  0 <= componentEffectEndTime &&
                  0.05 < componentEffectEndTime - componentEffectStartTime &&
                  logComponentReappeared(
                    finishedWork,
                    componentEffectStartTime,
                    componentEffectEndTime
                  ))
              : recursivelyTraverseLayoutEffects(finishedRoot, finishedWork);
            offscreenSubtreeIsHidden = prevProps;
            offscreenSubtreeWasHidden = prevOffscreenSubtreeWasHidden;
          }
          break;
        case 30:
          flags & 18874368 && trackNamedViewTransition(finishedWork);
          recursivelyTraverseLayoutEffects(finishedRoot, finishedWork);
          flags & 512 && safelyAttachRef(finishedWork, finishedWork.return);
          break;
        case 7:
          flags & 512 && safelyAttachRef(finishedWork, finishedWork.return);
        default:
          recursivelyTraverseLayoutEffects(finishedRoot, finishedWork);
      }
      (finishedWork.mode & ProfileMode) !== NoMode &&
        0 <= componentEffectStartTime &&
        0 <= componentEffectEndTime &&
        (0.05 < componentEffectDuration &&
          logComponentEffect(
            finishedWork,
            componentEffectStartTime,
            componentEffectEndTime,
            componentEffectDuration,
            componentEffectErrors
          ),
        null === finishedWork.alternate &&
          null !== finishedWork.return &&
          null !== finishedWork.return.alternate &&
          0.05 < componentEffectEndTime - componentEffectStartTime &&
          (isHydratingParent(
            finishedWork.return.alternate,
            finishedWork.return
          ) ||
            logComponentTrigger(
              finishedWork,
              componentEffectStartTime,
              componentEffectEndTime,
              "Mount"
            )));
      popComponentEffectStart(prevEffectStart);
      popComponentEffectDuration(prevEffectDuration);
      componentEffectErrors = prevEffectErrors;
    }
    function detachFiberAfterEffects(fiber) {
      var alternate = fiber.alternate;
      null !== alternate &&
        ((fiber.alternate = null), detachFiberAfterEffects(alternate));
      fiber.child = null;
      fiber.deletions = null;
      fiber.sibling = null;
      5 === fiber.tag &&
        ((alternate = fiber.stateNode),
        null !== alternate && detachDeletedInstance(alternate));
      fiber.stateNode = null;
      fiber._debugOwner = null;
      fiber.return = null;
      fiber.dependencies = null;
      fiber.memoizedProps = null;
      fiber.memoizedState = null;
      fiber.pendingProps = null;
      fiber.stateNode = null;
      fiber.updateQueue = null;
    }
    function recursivelyTraverseDeletionEffects(
      finishedRoot,
      nearestMountedAncestor,
      parent
    ) {
      for (parent = parent.child; null !== parent; )
        commitDeletionEffectsOnFiber(
          finishedRoot,
          nearestMountedAncestor,
          parent
        ),
          (parent = parent.sibling);
    }
    function commitDeletionEffectsOnFiber(
      finishedRoot,
      nearestMountedAncestor,
      deletedFiber
    ) {
      if (
        injectedHook &&
        "function" === typeof injectedHook.onCommitFiberUnmount
      )
        try {
          injectedHook.onCommitFiberUnmount(rendererID, deletedFiber);
        } catch (err) {
          hasLoggedError ||
            ((hasLoggedError = !0),
            console.error(
              "React instrumentation encountered an error: %s",
              err
            ));
        }
      var prevEffectStart = pushComponentEffectStart(),
        prevEffectDuration = pushComponentEffectDuration(),
        prevEffectErrors = pushComponentEffectErrors();
      switch (deletedFiber.tag) {
        case 26:
          offscreenSubtreeWasHidden ||
            safelyDetachRef(deletedFiber, nearestMountedAncestor);
          recursivelyTraverseDeletionEffects(
            finishedRoot,
            nearestMountedAncestor,
            deletedFiber
          );
          deletedFiber.memoizedState
            ? deletedFiber.memoizedState.count--
            : deletedFiber.stateNode &&
              ((finishedRoot = deletedFiber.stateNode),
              finishedRoot.parentNode.removeChild(finishedRoot));
          break;
        case 27:
          offscreenSubtreeWasHidden ||
            safelyDetachRef(deletedFiber, nearestMountedAncestor);
          var prevHostParent = hostParent,
            prevHostParentIsContainer = hostParentIsContainer;
          isSingletonScope(deletedFiber.type) &&
            ((hostParent = deletedFiber.stateNode),
            (hostParentIsContainer = !1));
          recursivelyTraverseDeletionEffects(
            finishedRoot,
            nearestMountedAncestor,
            deletedFiber
          );
          runWithFiberInDEV(
            deletedFiber,
            releaseSingletonInstance,
            deletedFiber.stateNode
          );
          hostParent = prevHostParent;
          hostParentIsContainer = prevHostParentIsContainer;
          break;
        case 5:
          offscreenSubtreeWasHidden ||
            safelyDetachRef(deletedFiber, nearestMountedAncestor),
            5 === deletedFiber.tag &&
              commitFragmentInstanceDeletionEffects(deletedFiber);
        case 6:
          prevHostParent = hostParent;
          prevHostParentIsContainer = hostParentIsContainer;
          hostParent = null;
          recursivelyTraverseDeletionEffects(
            finishedRoot,
            nearestMountedAncestor,
            deletedFiber
          );
          hostParent = prevHostParent;
          hostParentIsContainer = prevHostParentIsContainer;
          if (null !== hostParent)
            if (hostParentIsContainer)
              try {
                runWithFiberInDEV(
                  deletedFiber,
                  removeChildFromContainer,
                  hostParent,
                  deletedFiber.stateNode
                ),
                  (viewTransitionMutationContext = !0);
              } catch (error) {
                captureCommitPhaseError(
                  deletedFiber,
                  nearestMountedAncestor,
                  error
                );
              }
            else
              try {
                runWithFiberInDEV(
                  deletedFiber,
                  removeChild,
                  hostParent,
                  deletedFiber.stateNode
                ),
                  (viewTransitionMutationContext = !0);
              } catch (error) {
                captureCommitPhaseError(
                  deletedFiber,
                  nearestMountedAncestor,
                  error
                );
              }
          break;
        case 18:
          null !== hostParent &&
            (hostParentIsContainer
              ? ((finishedRoot = hostParent),
                clearHydrationBoundary(
                  9 === finishedRoot.nodeType
                    ? finishedRoot.body
                    : "HTML" === finishedRoot.nodeName
                      ? finishedRoot.ownerDocument.body
                      : finishedRoot,
                  deletedFiber.stateNode
                ),
                retryIfBlockedOn(finishedRoot))
              : clearHydrationBoundary(hostParent, deletedFiber.stateNode));
          break;
        case 4:
          prevHostParent = hostParent;
          prevHostParentIsContainer = hostParentIsContainer;
          hostParent = deletedFiber.stateNode.containerInfo;
          hostParentIsContainer = !0;
          recursivelyTraverseDeletionEffects(
            finishedRoot,
            nearestMountedAncestor,
            deletedFiber
          );
          hostParent = prevHostParent;
          hostParentIsContainer = prevHostParentIsContainer;
          break;
        case 0:
        case 11:
        case 14:
        case 15:
          offscreenSubtreeWasHidden ||
            commitHookEffectListUnmount(
              Insertion,
              deletedFiber,
              nearestMountedAncestor
            );
          offscreenSubtreeWasHidden ||
            commitHookLayoutUnmountEffects(
              deletedFiber,
              nearestMountedAncestor,
              Layout
            );
          recursivelyTraverseDeletionEffects(
            finishedRoot,
            nearestMountedAncestor,
            deletedFiber
          );
          break;
        case 1:
          offscreenSubtreeWasHidden ||
            (safelyDetachRef(deletedFiber, nearestMountedAncestor),
            (prevHostParent = deletedFiber.stateNode),
            "function" === typeof prevHostParent.componentWillUnmount &&
              safelyCallComponentWillUnmount(
                deletedFiber,
                nearestMountedAncestor,
                prevHostParent
              ));
          recursivelyTraverseDeletionEffects(
            finishedRoot,
            nearestMountedAncestor,
            deletedFiber
          );
          break;
        case 21:
          recursivelyTraverseDeletionEffects(
            finishedRoot,
            nearestMountedAncestor,
            deletedFiber
          );
          break;
        case 22:
          offscreenSubtreeWasHidden =
            (prevHostParent = offscreenSubtreeWasHidden) ||
            null !== deletedFiber.memoizedState;
          recursivelyTraverseDeletionEffects(
            finishedRoot,
            nearestMountedAncestor,
            deletedFiber
          );
          offscreenSubtreeWasHidden = prevHostParent;
          break;
        case 30:
          deletedFiber.flags & 18874368 &&
            untrackNamedViewTransition(deletedFiber);
          safelyDetachRef(deletedFiber, nearestMountedAncestor);
          recursivelyTraverseDeletionEffects(
            finishedRoot,
            nearestMountedAncestor,
            deletedFiber
          );
          break;
        case 7:
          offscreenSubtreeWasHidden ||
            safelyDetachRef(deletedFiber, nearestMountedAncestor);
          recursivelyTraverseDeletionEffects(
            finishedRoot,
            nearestMountedAncestor,
            deletedFiber
          );
          break;
        default:
          recursivelyTraverseDeletionEffects(
            finishedRoot,
            nearestMountedAncestor,
            deletedFiber
          );
      }
      (deletedFiber.mode & ProfileMode) !== NoMode &&
        0 <= componentEffectStartTime &&
        0 <= componentEffectEndTime &&
        0.05 < componentEffectDuration &&
        logComponentEffect(
          deletedFiber,
          componentEffectStartTime,
          componentEffectEndTime,
          componentEffectDuration,
          componentEffectErrors
        );
      popComponentEffectStart(prevEffectStart);
      popComponentEffectDuration(prevEffectDuration);
      componentEffectErrors = prevEffectErrors;
    }
    function commitActivityHydrationCallbacks(finishedRoot, finishedWork) {
      if (
        null === finishedWork.memoizedState &&
        ((finishedRoot = finishedWork.alternate),
        null !== finishedRoot &&
          ((finishedRoot = finishedRoot.memoizedState), null !== finishedRoot))
      ) {
        finishedRoot = finishedRoot.dehydrated;
        try {
          runWithFiberInDEV(
            finishedWork,
            commitHydratedActivityInstance,
            finishedRoot
          );
        } catch (error) {
          captureCommitPhaseError(finishedWork, finishedWork.return, error);
        }
      }
    }
    function commitSuspenseHydrationCallbacks(finishedRoot, finishedWork) {
      if (
        null === finishedWork.memoizedState &&
        ((finishedRoot = finishedWork.alternate),
        null !== finishedRoot &&
          ((finishedRoot = finishedRoot.memoizedState),
          null !== finishedRoot &&
            ((finishedRoot = finishedRoot.dehydrated), null !== finishedRoot)))
      )
        try {
          runWithFiberInDEV(
            finishedWork,
            commitHydratedSuspenseInstance,
            finishedRoot
          );
        } catch (error) {
          captureCommitPhaseError(finishedWork, finishedWork.return, error);
        }
    }
    function getRetryCache(finishedWork) {
      switch (finishedWork.tag) {
        case 31:
        case 13:
        case 19:
          var retryCache = finishedWork.stateNode;
          null === retryCache &&
            (retryCache = finishedWork.stateNode = new PossiblyWeakSet());
          return retryCache;
        case 22:
          return (
            (finishedWork = finishedWork.stateNode),
            (retryCache = finishedWork._retryCache),
            null === retryCache &&
              (retryCache = finishedWork._retryCache = new PossiblyWeakSet()),
            retryCache
          );
        default:
          throw Error(
            "Unexpected Suspense handler tag (" +
              finishedWork.tag +
              "). This is a bug in React."
          );
      }
    }
    function attachSuspenseRetryListeners(finishedWork, wakeables) {
      var retryCache = getRetryCache(finishedWork);
      wakeables.forEach(function (wakeable) {
        var retry = resolveRetryWakeable.bind(null, finishedWork, wakeable);
        if (!retryCache.has(wakeable)) {
          retryCache.add(wakeable);
          if (isDevToolsPresent)
            if (null !== inProgressLanes && null !== inProgressRoot)
              restorePendingUpdaters(inProgressRoot, inProgressLanes);
            else
              throw Error(
                "Expected finished root and lanes to be set. This is a bug in React."
              );
          wakeable.then(retry, retry);
        }
      });
    }
    function recursivelyTraverseMutationEffects(
      root$jscomp$0,
      parentFiber,
      lanes
    ) {
      var deletions = parentFiber.deletions;
      if (null !== deletions)
        for (var i = 0; i < deletions.length; i++) {
          var root = root$jscomp$0,
            returnFiber = parentFiber,
            deletedFiber = deletions[i],
            prevEffectStart = pushComponentEffectStart(),
            parent = returnFiber;
          a: for (; null !== parent; ) {
            switch (parent.tag) {
              case 27:
                if (isSingletonScope(parent.type)) {
                  hostParent = parent.stateNode;
                  hostParentIsContainer = !1;
                  break a;
                }
                break;
              case 5:
                hostParent = parent.stateNode;
                hostParentIsContainer = !1;
                break a;
              case 3:
              case 4:
                hostParent = parent.stateNode.containerInfo;
                hostParentIsContainer = !0;
                break a;
            }
            parent = parent.return;
          }
          if (null === hostParent)
            throw Error(
              "Expected to find a host parent. This error is likely caused by a bug in React. Please file an issue."
            );
          commitDeletionEffectsOnFiber(root, returnFiber, deletedFiber);
          hostParent = null;
          hostParentIsContainer = !1;
          (deletedFiber.mode & ProfileMode) !== NoMode &&
            0 <= componentEffectStartTime &&
            0 <= componentEffectEndTime &&
            0.05 < componentEffectEndTime - componentEffectStartTime &&
            logComponentTrigger(
              deletedFiber,
              componentEffectStartTime,
              componentEffectEndTime,
              "Unmount"
            );
          popComponentEffectStart(prevEffectStart);
          root = deletedFiber;
          returnFiber = root.alternate;
          null !== returnFiber && (returnFiber.return = null);
          root.return = null;
        }
      if (parentFiber.subtreeFlags & 13878)
        for (parentFiber = parentFiber.child; null !== parentFiber; )
          commitMutationEffectsOnFiber(parentFiber, root$jscomp$0, lanes),
            (parentFiber = parentFiber.sibling);
    }
    function commitMutationEffectsOnFiber(finishedWork, root, lanes) {
      var prevEffectStart = pushComponentEffectStart(),
        prevEffectDuration = pushComponentEffectDuration(),
        prevEffectErrors = pushComponentEffectErrors(),
        current = finishedWork.alternate,
        flags = finishedWork.flags;
      switch (finishedWork.tag) {
        case 0:
        case 11:
        case 14:
        case 15:
          recursivelyTraverseMutationEffects(root, finishedWork, lanes);
          commitReconciliationEffects(finishedWork);
          flags & 4 &&
            (commitHookEffectListUnmount(
              Insertion | HasEffect,
              finishedWork,
              finishedWork.return
            ),
            commitHookEffectListMount(Insertion | HasEffect, finishedWork),
            commitHookLayoutUnmountEffects(
              finishedWork,
              finishedWork.return,
              Layout | HasEffect
            ));
          break;
        case 1:
          recursivelyTraverseMutationEffects(root, finishedWork, lanes);
          commitReconciliationEffects(finishedWork);
          flags & 512 &&
            (offscreenSubtreeWasHidden ||
              null === current ||
              safelyDetachRef(current, current.return));
          flags & 64 &&
            offscreenSubtreeIsHidden &&
            ((current = finishedWork.updateQueue),
            null !== current &&
              ((flags = current.callbacks),
              null !== flags &&
                ((root = current.shared.hiddenCallbacks),
                (current.shared.hiddenCallbacks =
                  null === root ? flags : root.concat(flags)))));
          break;
        case 26:
          var hoistableRoot = currentHoistableRoot;
          recursivelyTraverseMutationEffects(root, finishedWork, lanes);
          commitReconciliationEffects(finishedWork);
          flags & 512 &&
            (offscreenSubtreeWasHidden ||
              null === current ||
              safelyDetachRef(current, current.return));
          if (flags & 4)
            if (
              ((root = null !== current ? current.memoizedState : null),
              (flags = finishedWork.memoizedState),
              null === current)
            )
              if (null === flags)
                if (null === finishedWork.stateNode) {
                  a: {
                    current = finishedWork.type;
                    flags = finishedWork.memoizedProps;
                    root = hoistableRoot.ownerDocument || hoistableRoot;
                    b: switch (current) {
                      case "title":
                        lanes = root.getElementsByTagName("title")[0];
                        if (
                          !lanes ||
                          lanes[internalHoistableMarker] ||
                          lanes[internalInstanceKey] ||
                          lanes.namespaceURI === SVG_NAMESPACE ||
                          lanes.hasAttribute("itemprop")
                        )
                          (lanes = root.createElement(current)),
                            root.head.insertBefore(
                              lanes,
                              root.querySelector("head > title")
                            );
                        setInitialProperties(lanes, current, flags);
                        lanes[internalInstanceKey] = finishedWork;
                        markNodeAsHoistable(lanes);
                        current = lanes;
                        break a;
                      case "link":
                        if (
                          (hoistableRoot = getHydratableHoistableCache(
                            "link",
                            "href",
                            root
                          ).get(current + (flags.href || "")))
                        )
                          for (var i = 0; i < hoistableRoot.length; i++)
                            if (
                              ((lanes = hoistableRoot[i]),
                              lanes.getAttribute("href") ===
                                (null == flags.href || "" === flags.href
                                  ? null
                                  : flags.href) &&
                                lanes.getAttribute("rel") ===
                                  (null == flags.rel ? null : flags.rel) &&
                                lanes.getAttribute("title") ===
                                  (null == flags.title ? null : flags.title) &&
                                lanes.getAttribute("crossorigin") ===
                                  (null == flags.crossOrigin
                                    ? null
                                    : flags.crossOrigin))
                            ) {
                              hoistableRoot.splice(i, 1);
                              break b;
                            }
                        lanes = root.createElement(current);
                        setInitialProperties(lanes, current, flags);
                        root.head.appendChild(lanes);
                        break;
                      case "meta":
                        if (
                          (hoistableRoot = getHydratableHoistableCache(
                            "meta",
                            "content",
                            root
                          ).get(current + (flags.content || "")))
                        )
                          for (i = 0; i < hoistableRoot.length; i++)
                            if (
                              ((lanes = hoistableRoot[i]),
                              checkAttributeStringCoercion(
                                flags.content,
                                "content"
                              ),
                              lanes.getAttribute("content") ===
                                (null == flags.content
                                  ? null
                                  : "" + flags.content) &&
                                lanes.getAttribute("name") ===
                                  (null == flags.name ? null : flags.name) &&
                                lanes.getAttribute("property") ===
                                  (null == flags.property
                                    ? null
                                    : flags.property) &&
                                lanes.getAttribute("http-equiv") ===
                                  (null == flags.httpEquiv
                                    ? null
                                    : flags.httpEquiv) &&
                                lanes.getAttribute("charset") ===
                                  (null == flags.charSet
                                    ? null
                                    : flags.charSet))
                            ) {
                              hoistableRoot.splice(i, 1);
                              break b;
                            }
                        lanes = root.createElement(current);
                        setInitialProperties(lanes, current, flags);
                        root.head.appendChild(lanes);
                        break;
                      default:
                        throw Error(
                          'getNodesForType encountered a type it did not expect: "' +
                            current +
                            '". This is a bug in React.'
                        );
                    }
                    lanes[internalInstanceKey] = finishedWork;
                    markNodeAsHoistable(lanes);
                    current = lanes;
                  }
                  finishedWork.stateNode = current;
                } else
                  mountHoistable(
                    hoistableRoot,
                    finishedWork.type,
                    finishedWork.stateNode
                  );
              else
                finishedWork.stateNode = acquireResource(
                  hoistableRoot,
                  flags,
                  finishedWork.memoizedProps
                );
            else
              root !== flags
                ? (null === root
                    ? null !== current.stateNode &&
                      ((current = current.stateNode),
                      current.parentNode.removeChild(current))
                    : root.count--,
                  null === flags
                    ? mountHoistable(
                        hoistableRoot,
                        finishedWork.type,
                        finishedWork.stateNode
                      )
                    : acquireResource(
                        hoistableRoot,
                        flags,
                        finishedWork.memoizedProps
                      ))
                : null === flags &&
                  null !== finishedWork.stateNode &&
                  commitHostUpdate(
                    finishedWork,
                    finishedWork.memoizedProps,
                    current.memoizedProps
                  );
          break;
        case 27:
          recursivelyTraverseMutationEffects(root, finishedWork, lanes);
          commitReconciliationEffects(finishedWork);
          flags & 512 &&
            (offscreenSubtreeWasHidden ||
              null === current ||
              safelyDetachRef(current, current.return));
          null !== current &&
            flags & 4 &&
            commitHostUpdate(
              finishedWork,
              finishedWork.memoizedProps,
              current.memoizedProps
            );
          break;
        case 5:
          recursivelyTraverseMutationEffects(root, finishedWork, lanes);
          commitReconciliationEffects(finishedWork);
          flags & 512 &&
            (offscreenSubtreeWasHidden ||
              null === current ||
              safelyDetachRef(current, current.return));
          if (finishedWork.flags & 32) {
            root = finishedWork.stateNode;
            try {
              runWithFiberInDEV(finishedWork, resetTextContent, root),
                (viewTransitionMutationContext = !0);
            } catch (error) {
              captureCommitPhaseError(finishedWork, finishedWork.return, error);
            }
          }
          flags & 4 &&
            null != finishedWork.stateNode &&
            ((root = finishedWork.memoizedProps),
            commitHostUpdate(
              finishedWork,
              root,
              null !== current ? current.memoizedProps : root
            ));
          flags & 1024 &&
            ((needsFormReset = !0),
            "form" !== finishedWork.type &&
              console.error(
                "Unexpected host component type. Expected a form. This is a bug in React."
              ));
          break;
        case 6:
          recursivelyTraverseMutationEffects(root, finishedWork, lanes);
          commitReconciliationEffects(finishedWork);
          if (flags & 4) {
            if (null === finishedWork.stateNode)
              throw Error(
                "This should have a text node initialized. This error is likely caused by a bug in React. Please file an issue."
              );
            flags = finishedWork.memoizedProps;
            current = null !== current ? current.memoizedProps : flags;
            root = finishedWork.stateNode;
            try {
              runWithFiberInDEV(
                finishedWork,
                commitTextUpdate,
                root,
                current,
                flags
              ),
                (viewTransitionMutationContext = !0);
            } catch (error) {
              captureCommitPhaseError(finishedWork, finishedWork.return, error);
            }
          }
          break;
        case 3:
          hoistableRoot = pushNestedEffectDurations();
          viewTransitionMutationContext = rootMutationContext = !1;
          tagCaches = null;
          i = currentHoistableRoot;
          currentHoistableRoot = getHoistableRoot(root.containerInfo);
          recursivelyTraverseMutationEffects(root, finishedWork, lanes);
          currentHoistableRoot = i;
          commitReconciliationEffects(finishedWork);
          if (
            flags & 4 &&
            null !== current &&
            current.memoizedState.isDehydrated
          )
            try {
              runWithFiberInDEV(
                finishedWork,
                commitHydratedContainer,
                root.containerInfo
              );
            } catch (error) {
              captureCommitPhaseError(finishedWork, finishedWork.return, error);
            }
          needsFormReset &&
            ((needsFormReset = !1), recursivelyResetForms(finishedWork));
          root.effectDuration += popNestedEffectDurations(hoistableRoot);
          popMutationContext(!1);
          rootMutationContext &&
            0 !== (lanes & 34) &&
            ((root.indicatorLanes &= ~currentEventTransitionLane),
            (needsIsomorphicIndicator = !1));
          break;
        case 4:
          current = pushMutationContext();
          flags = currentHoistableRoot;
          currentHoistableRoot = getHoistableRoot(
            finishedWork.stateNode.containerInfo
          );
          recursivelyTraverseMutationEffects(root, finishedWork, lanes);
          commitReconciliationEffects(finishedWork);
          currentHoistableRoot = flags;
          viewTransitionMutationContext &&
            inUpdateViewTransition &&
            (rootViewTransitionAffected = !0);
          popMutationContext(current);
          break;
        case 12:
          current = pushNestedEffectDurations();
          recursivelyTraverseMutationEffects(root, finishedWork, lanes);
          commitReconciliationEffects(finishedWork);
          finishedWork.stateNode.effectDuration +=
            bubbleNestedEffectDurations(current);
          break;
        case 31:
          recursivelyTraverseMutationEffects(root, finishedWork, lanes);
          commitReconciliationEffects(finishedWork);
          flags & 4 &&
            ((current = finishedWork.updateQueue),
            null !== current &&
              ((finishedWork.updateQueue = null),
              attachSuspenseRetryListeners(finishedWork, current)));
          break;
        case 13:
          recursivelyTraverseMutationEffects(root, finishedWork, lanes);
          commitReconciliationEffects(finishedWork);
          finishedWork.child.flags & 8192 &&
            (null !== finishedWork.memoizedState) !==
              (null !== current && null !== current.memoizedState) &&
            (globalMostRecentFallbackTime = now$1());
          flags & 4 &&
            ((current = finishedWork.updateQueue),
            null !== current &&
              ((finishedWork.updateQueue = null),
              attachSuspenseRetryListeners(finishedWork, current)));
          break;
        case 22:
          hoistableRoot = null !== finishedWork.memoizedState;
          var wasHidden = null !== current && null !== current.memoizedState,
            prevOffscreenSubtreeIsHidden = offscreenSubtreeIsHidden,
            prevOffscreenSubtreeWasHidden = offscreenSubtreeWasHidden;
          offscreenSubtreeIsHidden =
            prevOffscreenSubtreeIsHidden || hoistableRoot;
          offscreenSubtreeWasHidden =
            prevOffscreenSubtreeWasHidden || wasHidden;
          recursivelyTraverseMutationEffects(root, finishedWork, lanes);
          offscreenSubtreeWasHidden = prevOffscreenSubtreeWasHidden;
          offscreenSubtreeIsHidden = prevOffscreenSubtreeIsHidden;
          wasHidden &&
            !hoistableRoot &&
            !prevOffscreenSubtreeIsHidden &&
            !prevOffscreenSubtreeWasHidden &&
            (finishedWork.mode & ProfileMode) !== NoMode &&
            0 <= componentEffectStartTime &&
            0 <= componentEffectEndTime &&
            0.05 < componentEffectEndTime - componentEffectStartTime &&
            logComponentReappeared(
              finishedWork,
              componentEffectStartTime,
              componentEffectEndTime
            );
          commitReconciliationEffects(finishedWork);
          if (flags & 8192)
            a: for (
              root = finishedWork.stateNode,
                root._visibility = hoistableRoot
                  ? root._visibility & ~OffscreenVisible
                  : root._visibility | OffscreenVisible,
                !hoistableRoot ||
                  null === current ||
                  wasHidden ||
                  offscreenSubtreeIsHidden ||
                  offscreenSubtreeWasHidden ||
                  (recursivelyTraverseDisappearLayoutEffects(finishedWork),
                  (finishedWork.mode & ProfileMode) !== NoMode &&
                    0 <= componentEffectStartTime &&
                    0 <= componentEffectEndTime &&
                    0.05 < componentEffectEndTime - componentEffectStartTime &&
                    logComponentTrigger(
                      finishedWork,
                      componentEffectStartTime,
                      componentEffectEndTime,
                      "Disconnect"
                    )),
                current = null,
                root = finishedWork;
              ;

            ) {
              if (5 === root.tag || 26 === root.tag) {
                if (null === current) {
                  lanes = current = root;
                  try {
                    (i = lanes.stateNode),
                      hoistableRoot
                        ? runWithFiberInDEV(lanes, hideInstance, i)
                        : runWithFiberInDEV(
                            lanes,
                            unhideInstance,
                            lanes.stateNode,
                            lanes.memoizedProps
                          );
                  } catch (error) {
                    captureCommitPhaseError(lanes, lanes.return, error);
                  }
                }
              } else if (6 === root.tag) {
                if (null === current) {
                  lanes = root;
                  try {
                    var instance = lanes.stateNode;
                    hoistableRoot
                      ? runWithFiberInDEV(lanes, hideTextInstance, instance)
                      : runWithFiberInDEV(
                          lanes,
                          unhideTextInstance,
                          instance,
                          lanes.memoizedProps
                        );
                    viewTransitionMutationContext = !0;
                  } catch (error) {
                    captureCommitPhaseError(lanes, lanes.return, error);
                  }
                }
              } else if (18 === root.tag) {
                if (null === current) {
                  lanes = root;
                  try {
                    var instance$jscomp$0 = lanes.stateNode;
                    hoistableRoot
                      ? runWithFiberInDEV(
                          lanes,
                          hideDehydratedBoundary,
                          instance$jscomp$0
                        )
                      : runWithFiberInDEV(
                          lanes,
                          unhideDehydratedBoundary,
                          lanes.stateNode
                        );
                  } catch (error) {
                    captureCommitPhaseError(lanes, lanes.return, error);
                  }
                }
              } else if (
                ((22 !== root.tag && 23 !== root.tag) ||
                  null === root.memoizedState ||
                  root === finishedWork) &&
                null !== root.child
              ) {
                root.child.return = root;
                root = root.child;
                continue;
              }
              if (root === finishedWork) break a;
              for (; null === root.sibling; ) {
                if (null === root.return || root.return === finishedWork)
                  break a;
                current === root && (current = null);
                root = root.return;
              }
              current === root && (current = null);
              root.sibling.return = root.return;
              root = root.sibling;
            }
          flags & 4 &&
            ((current = finishedWork.updateQueue),
            null !== current &&
              ((flags = current.retryQueue),
              null !== flags &&
                ((current.retryQueue = null),
                attachSuspenseRetryListeners(finishedWork, flags))));
          break;
        case 19:
          recursivelyTraverseMutationEffects(root, finishedWork, lanes);
          commitReconciliationEffects(finishedWork);
          flags & 4 &&
            ((current = finishedWork.updateQueue),
            null !== current &&
              ((finishedWork.updateQueue = null),
              attachSuspenseRetryListeners(finishedWork, current)));
          break;
        case 30:
          flags & 512 &&
            (offscreenSubtreeWasHidden ||
              null === current ||
              safelyDetachRef(current, current.return));
          flags = pushMutationContext();
          hoistableRoot = inUpdateViewTransition;
          i = (lanes & 335544064) === lanes;
          instance = finishedWork.memoizedProps;
          inUpdateViewTransition =
            i &&
            "none" !==
              getViewTransitionClassName(instance.default, instance.update);
          recursivelyTraverseMutationEffects(root, finishedWork, lanes);
          commitReconciliationEffects(finishedWork);
          i &&
            null !== current &&
            viewTransitionMutationContext &&
            (finishedWork.flags |= 4);
          inUpdateViewTransition = hoistableRoot;
          popMutationContext(flags);
          break;
        case 21:
          break;
        case 7:
          current &&
            null !== current.stateNode &&
            (current.stateNode._fragmentFiber = finishedWork);
        default:
          recursivelyTraverseMutationEffects(root, finishedWork, lanes),
            commitReconciliationEffects(finishedWork);
      }
      (finishedWork.mode & ProfileMode) !== NoMode &&
        0 <= componentEffectStartTime &&
        0 <= componentEffectEndTime &&
        (0.05 < componentEffectDuration &&
          logComponentEffect(
            finishedWork,
            componentEffectStartTime,
            componentEffectEndTime,
            componentEffectDuration,
            componentEffectErrors
          ),
        null === finishedWork.alternate &&
          null !== finishedWork.return &&
          null !== finishedWork.return.alternate &&
          0.05 < componentEffectEndTime - componentEffectStartTime &&
          (isHydratingParent(
            finishedWork.return.alternate,
            finishedWork.return
          ) ||
            logComponentTrigger(
              finishedWork,
              componentEffectStartTime,
              componentEffectEndTime,
              "Mount"
            )));
      popComponentEffectStart(prevEffectStart);
      popComponentEffectDuration(prevEffectDuration);
      componentEffectErrors = prevEffectErrors;
    }
    function commitReconciliationEffects(finishedWork) {
      var flags = finishedWork.flags;
      if (flags & 2) {
        try {
          runWithFiberInDEV(finishedWork, commitPlacement, finishedWork);
        } catch (error) {
          captureCommitPhaseError(finishedWork, finishedWork.return, error);
        }
        finishedWork.flags &= -3;
      }
      flags & 4096 && (finishedWork.flags &= -4097);
    }
    function recursivelyResetForms(parentFiber) {
      if (parentFiber.subtreeFlags & 1024)
        for (parentFiber = parentFiber.child; null !== parentFiber; ) {
          var fiber = parentFiber;
          recursivelyResetForms(fiber);
          5 === fiber.tag && fiber.flags & 1024 && fiber.stateNode.reset();
          parentFiber = parentFiber.sibling;
        }
    }
    function recursivelyTraverseAfterMutationEffects(root, parentFiber) {
      if (parentFiber.subtreeFlags & 9270)
        for (parentFiber = parentFiber.child; null !== parentFiber; )
          commitAfterMutationEffectsOnFiber(parentFiber, root),
            (parentFiber = parentFiber.sibling);
      else measureNestedViewTransitions(parentFiber, !1);
    }
    function commitAfterMutationEffectsOnFiber(finishedWork, root) {
      var current = finishedWork.alternate;
      if (null === current) commitEnterViewTransitions(finishedWork, !1);
      else
        switch (finishedWork.tag) {
          case 3:
            rootViewTransitionNameCanceled = viewTransitionContextChanged$1 =
              !1;
            pushViewTransitionCancelableScope();
            recursivelyTraverseAfterMutationEffects(root, finishedWork);
            if (
              !viewTransitionContextChanged$1 &&
              !rootViewTransitionAffected
            ) {
              finishedWork = viewTransitionCancelableChildren;
              if (null !== finishedWork)
                for (var i = 0; i < finishedWork.length; i += 3)
                  cancelViewTransitionName(
                    finishedWork[i],
                    finishedWork[i + 1],
                    finishedWork[i + 2]
                  );
              cancelRootViewTransitionName(root.containerInfo);
              rootViewTransitionNameCanceled = !0;
            }
            viewTransitionCancelableChildren = null;
            break;
          case 5:
            recursivelyTraverseAfterMutationEffects(root, finishedWork);
            break;
          case 4:
            i = viewTransitionContextChanged$1;
            viewTransitionContextChanged$1 = !1;
            recursivelyTraverseAfterMutationEffects(root, finishedWork);
            viewTransitionContextChanged$1 && (rootViewTransitionAffected = !0);
            viewTransitionContextChanged$1 = i;
            break;
          case 22:
            null === finishedWork.memoizedState &&
              (null !== current.memoizedState
                ? commitEnterViewTransitions(finishedWork, !1)
                : recursivelyTraverseAfterMutationEffects(root, finishedWork));
            break;
          case 30:
            i = viewTransitionContextChanged$1;
            var prevCancelableChildren = pushViewTransitionCancelableScope();
            viewTransitionContextChanged$1 = !1;
            recursivelyTraverseAfterMutationEffects(root, finishedWork);
            viewTransitionContextChanged$1 && (finishedWork.flags |= 4);
            root = measureUpdateViewTransition(current, finishedWork, !1);
            0 !== (finishedWork.flags & 4) && root
              ? (scheduleViewTransitionEvent(
                  finishedWork,
                  finishedWork.memoizedProps.onUpdate
                ),
                (viewTransitionCancelableChildren = prevCancelableChildren))
              : null !== prevCancelableChildren &&
                (prevCancelableChildren.push.apply(
                  prevCancelableChildren,
                  viewTransitionCancelableChildren
                ),
                (viewTransitionCancelableChildren = prevCancelableChildren));
            viewTransitionContextChanged$1 =
              0 !== (finishedWork.flags & 32) ? !0 : i;
            break;
          default:
            recursivelyTraverseAfterMutationEffects(root, finishedWork);
        }
    }
    function recursivelyTraverseLayoutEffects(root, parentFiber) {
      if (parentFiber.subtreeFlags & 8772)
        for (parentFiber = parentFiber.child; null !== parentFiber; )
          commitLayoutEffectOnFiber(root, parentFiber.alternate, parentFiber),
            (parentFiber = parentFiber.sibling);
    }
    function disappearLayoutEffects(finishedWork) {
      var prevEffectStart = pushComponentEffectStart(),
        prevEffectDuration = pushComponentEffectDuration(),
        prevEffectErrors = pushComponentEffectErrors();
      switch (finishedWork.tag) {
        case 0:
        case 11:
        case 14:
        case 15:
          commitHookLayoutUnmountEffects(
            finishedWork,
            finishedWork.return,
            Layout
          );
          recursivelyTraverseDisappearLayoutEffects(finishedWork);
          break;
        case 1:
          safelyDetachRef(finishedWork, finishedWork.return);
          var instance = finishedWork.stateNode;
          "function" === typeof instance.componentWillUnmount &&
            safelyCallComponentWillUnmount(
              finishedWork,
              finishedWork.return,
              instance
            );
          recursivelyTraverseDisappearLayoutEffects(finishedWork);
          break;
        case 27:
          runWithFiberInDEV(
            finishedWork,
            releaseSingletonInstance,
            finishedWork.stateNode
          );
        case 26:
        case 5:
          safelyDetachRef(finishedWork, finishedWork.return);
          5 === finishedWork.tag &&
            commitFragmentInstanceDeletionEffects(finishedWork);
          recursivelyTraverseDisappearLayoutEffects(finishedWork);
          break;
        case 22:
          null === finishedWork.memoizedState &&
            recursivelyTraverseDisappearLayoutEffects(finishedWork);
          break;
        case 30:
          finishedWork.flags & 18874368 &&
            untrackNamedViewTransition(finishedWork);
          safelyDetachRef(finishedWork, finishedWork.return);
          recursivelyTraverseDisappearLayoutEffects(finishedWork);
          break;
        case 7:
          safelyDetachRef(finishedWork, finishedWork.return);
        default:
          recursivelyTraverseDisappearLayoutEffects(finishedWork);
      }
      (finishedWork.mode & ProfileMode) !== NoMode &&
        0 <= componentEffectStartTime &&
        0 <= componentEffectEndTime &&
        0.05 < componentEffectDuration &&
        logComponentEffect(
          finishedWork,
          componentEffectStartTime,
          componentEffectEndTime,
          componentEffectDuration,
          componentEffectErrors
        );
      popComponentEffectStart(prevEffectStart);
      popComponentEffectDuration(prevEffectDuration);
      componentEffectErrors = prevEffectErrors;
    }
    function recursivelyTraverseDisappearLayoutEffects(parentFiber) {
      for (parentFiber = parentFiber.child; null !== parentFiber; )
        disappearLayoutEffects(parentFiber),
          (parentFiber = parentFiber.sibling);
    }
    function reappearLayoutEffects(
      finishedRoot,
      current,
      finishedWork,
      includeWorkInProgressEffects
    ) {
      var prevEffectStart = pushComponentEffectStart(),
        prevEffectDuration = pushComponentEffectDuration(),
        prevEffectErrors = pushComponentEffectErrors(),
        flags = finishedWork.flags;
      switch (finishedWork.tag) {
        case 0:
        case 11:
        case 15:
          recursivelyTraverseReappearLayoutEffects(
            finishedRoot,
            finishedWork,
            includeWorkInProgressEffects
          );
          commitHookLayoutEffects(finishedWork, Layout);
          break;
        case 1:
          recursivelyTraverseReappearLayoutEffects(
            finishedRoot,
            finishedWork,
            includeWorkInProgressEffects
          );
          current = finishedWork.stateNode;
          "function" === typeof current.componentDidMount &&
            runWithFiberInDEV(
              finishedWork,
              callComponentDidMountInDEV,
              finishedWork,
              current
            );
          current = finishedWork.updateQueue;
          if (null !== current) {
            finishedRoot = finishedWork.stateNode;
            try {
              runWithFiberInDEV(
                finishedWork,
                commitHiddenCallbacks,
                current,
                finishedRoot
              );
            } catch (error) {
              captureCommitPhaseError(finishedWork, finishedWork.return, error);
            }
          }
          includeWorkInProgressEffects &&
            flags & 64 &&
            commitClassCallbacks(finishedWork);
          safelyAttachRef(finishedWork, finishedWork.return);
          break;
        case 27:
          commitHostSingletonAcquisition(finishedWork);
        case 26:
        case 5:
          if (5 === finishedWork.tag)
            a: for (var parent = finishedWork.return; null !== parent; ) {
              isFragmentInstanceParent(parent) &&
                commitNewChildToFragmentInstance(
                  finishedWork.stateNode,
                  parent.stateNode
                );
              if (isHostParent(parent)) break a;
              parent = parent.return;
            }
          recursivelyTraverseReappearLayoutEffects(
            finishedRoot,
            finishedWork,
            includeWorkInProgressEffects
          );
          includeWorkInProgressEffects &&
            null === current &&
            flags & 4 &&
            commitHostMount(finishedWork);
          safelyAttachRef(finishedWork, finishedWork.return);
          break;
        case 12:
          if (includeWorkInProgressEffects && flags & 4) {
            flags = pushNestedEffectDurations();
            recursivelyTraverseReappearLayoutEffects(
              finishedRoot,
              finishedWork,
              includeWorkInProgressEffects
            );
            includeWorkInProgressEffects = finishedWork.stateNode;
            includeWorkInProgressEffects.effectDuration +=
              bubbleNestedEffectDurations(flags);
            try {
              runWithFiberInDEV(
                finishedWork,
                commitProfiler,
                finishedWork,
                current,
                commitStartTime,
                includeWorkInProgressEffects.effectDuration
              );
            } catch (error) {
              captureCommitPhaseError(finishedWork, finishedWork.return, error);
            }
          } else
            recursivelyTraverseReappearLayoutEffects(
              finishedRoot,
              finishedWork,
              includeWorkInProgressEffects
            );
          break;
        case 31:
          recursivelyTraverseReappearLayoutEffects(
            finishedRoot,
            finishedWork,
            includeWorkInProgressEffects
          );
          includeWorkInProgressEffects &&
            flags & 4 &&
            commitActivityHydrationCallbacks(finishedRoot, finishedWork);
          break;
        case 13:
          recursivelyTraverseReappearLayoutEffects(
            finishedRoot,
            finishedWork,
            includeWorkInProgressEffects
          );
          includeWorkInProgressEffects &&
            flags & 4 &&
            commitSuspenseHydrationCallbacks(finishedRoot, finishedWork);
          break;
        case 22:
          null === finishedWork.memoizedState &&
            recursivelyTraverseReappearLayoutEffects(
              finishedRoot,
              finishedWork,
              includeWorkInProgressEffects
            );
          safelyAttachRef(finishedWork, finishedWork.return);
          break;
        case 30:
          recursivelyTraverseReappearLayoutEffects(
            finishedRoot,
            finishedWork,
            includeWorkInProgressEffects
          );
          flags & 18874368 && trackNamedViewTransition(finishedWork);
          safelyAttachRef(finishedWork, finishedWork.return);
          break;
        case 7:
          safelyAttachRef(finishedWork, finishedWork.return);
        default:
          recursivelyTraverseReappearLayoutEffects(
            finishedRoot,
            finishedWork,
            includeWorkInProgressEffects
          );
      }
      (finishedWork.mode & ProfileMode) !== NoMode &&
        0 <= componentEffectStartTime &&
        0 <= componentEffectEndTime &&
        0.05 < componentEffectDuration &&
        logComponentEffect(
          finishedWork,
          componentEffectStartTime,
          componentEffectEndTime,
          componentEffectDuration,
          componentEffectErrors
        );
      popComponentEffectStart(prevEffectStart);
      popComponentEffectDuration(prevEffectDuration);
      componentEffectErrors = prevEffectErrors;
    }
    function recursivelyTraverseReappearLayoutEffects(
      finishedRoot,
      parentFiber,
      includeWorkInProgressEffects
    ) {
      includeWorkInProgressEffects =
        includeWorkInProgressEffects && 0 !== (parentFiber.subtreeFlags & 8772);
      for (parentFiber = parentFiber.child; null !== parentFiber; )
        reappearLayoutEffects(
          finishedRoot,
          parentFiber.alternate,
          parentFiber,
          includeWorkInProgressEffects
        ),
          (parentFiber = parentFiber.sibling);
    }
    function commitOffscreenPassiveMountEffects(current, finishedWork) {
      var previousCache = null;
      null !== current &&
        null !== current.memoizedState &&
        null !== current.memoizedState.cachePool &&
        (previousCache = current.memoizedState.cachePool.pool);
      current = null;
      null !== finishedWork.memoizedState &&
        null !== finishedWork.memoizedState.cachePool &&
        (current = finishedWork.memoizedState.cachePool.pool);
      current !== previousCache &&
        (null != current && retainCache(current),
        null != previousCache && releaseCache(previousCache));
    }
    function commitCachePassiveMountEffect(current, finishedWork) {
      current = null;
      null !== finishedWork.alternate &&
        (current = finishedWork.alternate.memoizedState.cache);
      finishedWork = finishedWork.memoizedState.cache;
      finishedWork !== current &&
        (retainCache(finishedWork), null != current && releaseCache(current));
    }
    function recursivelyTraversePassiveMountEffects(
      root,
      parentFiber,
      committedLanes,
      committedTransitions,
      endTime
    ) {
      var isViewTransitionEligible =
        (committedLanes & 335544064) === committedLanes;
      if (
        parentFiber.subtreeFlags & (isViewTransitionEligible ? 10262 : 10256) ||
        (0 !== parentFiber.actualDuration &&
          (null === parentFiber.alternate ||
            parentFiber.alternate.child !== parentFiber.child))
      )
        for (parentFiber = parentFiber.child; null !== parentFiber; )
          (isViewTransitionEligible = parentFiber.sibling),
            commitPassiveMountOnFiber(
              root,
              parentFiber,
              committedLanes,
              committedTransitions,
              null !== isViewTransitionEligible
                ? isViewTransitionEligible.actualStartTime
                : endTime
            ),
            (parentFiber = isViewTransitionEligible);
      else
        isViewTransitionEligible && restoreNestedViewTransitions(parentFiber);
    }
    function commitPassiveMountOnFiber(
      finishedRoot,
      finishedWork,
      committedLanes,
      committedTransitions,
      endTime
    ) {
      var prevEffectStart = pushComponentEffectStart(),
        prevEffectDuration = pushComponentEffectDuration(),
        prevEffectErrors = pushComponentEffectErrors(),
        prevDeepEquality = alreadyWarnedForDeepEquality,
        isViewTransitionEligible =
          (committedLanes & 335544064) === committedLanes;
      isViewTransitionEligible &&
        null === finishedWork.alternate &&
        null !== finishedWork.return &&
        null !== finishedWork.return.alternate &&
        restoreEnterOrExitViewTransitions(finishedWork);
      var flags = finishedWork.flags;
      switch (finishedWork.tag) {
        case 0:
        case 11:
        case 15:
          (finishedWork.mode & ProfileMode) !== NoMode &&
            0 < finishedWork.actualStartTime &&
            0 !== (finishedWork.flags & 1) &&
            logComponentRender(
              finishedWork,
              finishedWork.actualStartTime,
              endTime,
              inHydratedSubtree,
              committedLanes
            );
          recursivelyTraversePassiveMountEffects(
            finishedRoot,
            finishedWork,
            committedLanes,
            committedTransitions,
            endTime
          );
          flags & 2048 &&
            commitHookPassiveMountEffects(finishedWork, Passive | HasEffect);
          break;
        case 1:
          (finishedWork.mode & ProfileMode) !== NoMode &&
            0 < finishedWork.actualStartTime &&
            (0 !== (finishedWork.flags & 128)
              ? logComponentErrored(
                  finishedWork,
                  finishedWork.actualStartTime,
                  endTime,
                  []
                )
              : 0 !== (finishedWork.flags & 1) &&
                logComponentRender(
                  finishedWork,
                  finishedWork.actualStartTime,
                  endTime,
                  inHydratedSubtree,
                  committedLanes
                ));
          recursivelyTraversePassiveMountEffects(
            finishedRoot,
            finishedWork,
            committedLanes,
            committedTransitions,
            endTime
          );
          break;
        case 3:
          var prevProfilerEffectDuration = pushNestedEffectDurations(),
            wasInHydratedSubtree = inHydratedSubtree;
          inHydratedSubtree =
            null !== finishedWork.alternate &&
            finishedWork.alternate.memoizedState.isDehydrated &&
            0 === (finishedWork.flags & 256);
          recursivelyTraversePassiveMountEffects(
            finishedRoot,
            finishedWork,
            committedLanes,
            committedTransitions,
            endTime
          );
          inHydratedSubtree = wasInHydratedSubtree;
          isViewTransitionEligible &&
            rootViewTransitionNameCanceled &&
            restoreRootViewTransitionName(finishedRoot.containerInfo);
          flags & 2048 &&
            ((committedLanes = null),
            null !== finishedWork.alternate &&
              (committedLanes = finishedWork.alternate.memoizedState.cache),
            (committedTransitions = finishedWork.memoizedState.cache),
            committedTransitions !== committedLanes &&
              (retainCache(committedTransitions),
              null != committedLanes && releaseCache(committedLanes)));
          finishedRoot.passiveEffectDuration += popNestedEffectDurations(
            prevProfilerEffectDuration
          );
          break;
        case 12:
          if (flags & 2048) {
            flags = pushNestedEffectDurations();
            recursivelyTraversePassiveMountEffects(
              finishedRoot,
              finishedWork,
              committedLanes,
              committedTransitions,
              endTime
            );
            finishedRoot = finishedWork.stateNode;
            finishedRoot.passiveEffectDuration +=
              bubbleNestedEffectDurations(flags);
            try {
              runWithFiberInDEV(
                finishedWork,
                commitProfilerPostCommitImpl,
                finishedWork,
                finishedWork.alternate,
                commitStartTime,
                finishedRoot.passiveEffectDuration
              );
            } catch (error) {
              captureCommitPhaseError(finishedWork, finishedWork.return, error);
            }
          } else
            recursivelyTraversePassiveMountEffects(
              finishedRoot,
              finishedWork,
              committedLanes,
              committedTransitions,
              endTime
            );
          break;
        case 31:
          flags = inHydratedSubtree;
          isViewTransitionEligible =
            null !== finishedWork.alternate
              ? finishedWork.alternate.memoizedState
              : null;
          prevProfilerEffectDuration = finishedWork.memoizedState;
          null !== isViewTransitionEligible &&
          null === prevProfilerEffectDuration
            ? ((prevProfilerEffectDuration = finishedWork.deletions),
              null !== prevProfilerEffectDuration &&
              0 < prevProfilerEffectDuration.length &&
              18 === prevProfilerEffectDuration[0].tag
                ? ((inHydratedSubtree = !1),
                  (isViewTransitionEligible =
                    isViewTransitionEligible.hydrationErrors),
                  null !== isViewTransitionEligible &&
                    logComponentErrored(
                      finishedWork,
                      finishedWork.actualStartTime,
                      endTime,
                      isViewTransitionEligible
                    ))
                : (inHydratedSubtree = !0))
            : (inHydratedSubtree = !1);
          recursivelyTraversePassiveMountEffects(
            finishedRoot,
            finishedWork,
            committedLanes,
            committedTransitions,
            endTime
          );
          inHydratedSubtree = flags;
          break;
        case 13:
          flags = inHydratedSubtree;
          isViewTransitionEligible =
            null !== finishedWork.alternate
              ? finishedWork.alternate.memoizedState
              : null;
          prevProfilerEffectDuration = finishedWork.memoizedState;
          null === isViewTransitionEligible ||
          null === isViewTransitionEligible.dehydrated ||
          (null !== prevProfilerEffectDuration &&
            null !== prevProfilerEffectDuration.dehydrated)
            ? (inHydratedSubtree = !1)
            : ((prevProfilerEffectDuration = finishedWork.deletions),
              null !== prevProfilerEffectDuration &&
              0 < prevProfilerEffectDuration.length &&
              18 === prevProfilerEffectDuration[0].tag
                ? ((inHydratedSubtree = !1),
                  (isViewTransitionEligible =
                    isViewTransitionEligible.hydrationErrors),
                  null !== isViewTransitionEligible &&
                    logComponentErrored(
                      finishedWork,
                      finishedWork.actualStartTime,
                      endTime,
                      isViewTransitionEligible
                    ))
                : (inHydratedSubtree = !0));
          recursivelyTraversePassiveMountEffects(
            finishedRoot,
            finishedWork,
            committedLanes,
            committedTransitions,
            endTime
          );
          inHydratedSubtree = flags;
          break;
        case 23:
          break;
        case 22:
          wasInHydratedSubtree = finishedWork.stateNode;
          prevProfilerEffectDuration = finishedWork.alternate;
          null !== finishedWork.memoizedState
            ? (isViewTransitionEligible &&
                null !== prevProfilerEffectDuration &&
                null === prevProfilerEffectDuration.memoizedState &&
                restoreEnterOrExitViewTransitions(prevProfilerEffectDuration),
              wasInHydratedSubtree._visibility &
              OffscreenPassiveEffectsConnected
                ? recursivelyTraversePassiveMountEffects(
                    finishedRoot,
                    finishedWork,
                    committedLanes,
                    committedTransitions,
                    endTime
                  )
                : recursivelyTraverseAtomicPassiveEffects(
                    finishedRoot,
                    finishedWork,
                    committedLanes,
                    committedTransitions,
                    endTime
                  ))
            : (isViewTransitionEligible &&
                null !== prevProfilerEffectDuration &&
                null !== prevProfilerEffectDuration.memoizedState &&
                restoreEnterOrExitViewTransitions(finishedWork),
              wasInHydratedSubtree._visibility &
              OffscreenPassiveEffectsConnected
                ? recursivelyTraversePassiveMountEffects(
                    finishedRoot,
                    finishedWork,
                    committedLanes,
                    committedTransitions,
                    endTime
                  )
                : ((wasInHydratedSubtree._visibility |=
                    OffscreenPassiveEffectsConnected),
                  recursivelyTraverseReconnectPassiveEffects(
                    finishedRoot,
                    finishedWork,
                    committedLanes,
                    committedTransitions,
                    0 !== (finishedWork.subtreeFlags & 10256),
                    endTime
                  ),
                  (finishedWork.mode & ProfileMode) === NoMode ||
                    inHydratedSubtree ||
                    ((finishedRoot = finishedWork.actualStartTime),
                    0 <= finishedRoot &&
                      0.05 < endTime - finishedRoot &&
                      logComponentReappeared(
                        finishedWork,
                        finishedRoot,
                        endTime
                      ),
                    0 <= componentEffectStartTime &&
                      0 <= componentEffectEndTime &&
                      0.05 <
                        componentEffectEndTime - componentEffectStartTime &&
                      logComponentReappeared(
                        finishedWork,
                        componentEffectStartTime,
                        componentEffectEndTime
                      ))));
          flags & 2048 &&
            commitOffscreenPassiveMountEffects(
              prevProfilerEffectDuration,
              finishedWork
            );
          break;
        case 24:
          recursivelyTraversePassiveMountEffects(
            finishedRoot,
            finishedWork,
            committedLanes,
            committedTransitions,
            endTime
          );
          flags & 2048 &&
            commitCachePassiveMountEffect(finishedWork.alternate, finishedWork);
          break;
        case 30:
          isViewTransitionEligible &&
            ((flags = finishedWork.alternate),
            null !== flags &&
              (restoreViewTransitionOnHostInstances(flags.child, !0),
              restoreViewTransitionOnHostInstances(finishedWork.child, !0)));
          recursivelyTraversePassiveMountEffects(
            finishedRoot,
            finishedWork,
            committedLanes,
            committedTransitions,
            endTime
          );
          break;
        default:
          recursivelyTraversePassiveMountEffects(
            finishedRoot,
            finishedWork,
            committedLanes,
            committedTransitions,
            endTime
          );
      }
      if ((finishedWork.mode & ProfileMode) !== NoMode) {
        if (
          (finishedRoot =
            !inHydratedSubtree &&
            null === finishedWork.alternate &&
            null !== finishedWork.return &&
            null !== finishedWork.return.alternate)
        )
          (committedLanes = finishedWork.actualStartTime),
            0 <= committedLanes &&
              0.05 < endTime - committedLanes &&
              logComponentTrigger(
                finishedWork,
                committedLanes,
                endTime,
                "Mount"
              );
        0 <= componentEffectStartTime &&
          0 <= componentEffectEndTime &&
          (0.05 < componentEffectDuration &&
            logComponentEffect(
              finishedWork,
              componentEffectStartTime,
              componentEffectEndTime,
              componentEffectDuration,
              componentEffectErrors
            ),
          finishedRoot &&
            0.05 < componentEffectEndTime - componentEffectStartTime &&
            logComponentTrigger(
              finishedWork,
              componentEffectStartTime,
              componentEffectEndTime,
              "Mount"
            ));
      }
      popComponentEffectStart(prevEffectStart);
      popComponentEffectDuration(prevEffectDuration);
      componentEffectErrors = prevEffectErrors;
      alreadyWarnedForDeepEquality = prevDeepEquality;
    }
    function recursivelyTraverseReconnectPassiveEffects(
      finishedRoot,
      parentFiber,
      committedLanes,
      committedTransitions,
      includeWorkInProgressEffects,
      endTime
    ) {
      includeWorkInProgressEffects =
        includeWorkInProgressEffects &&
        0 !== (parentFiber.subtreeFlags & 10256);
      for (parentFiber = parentFiber.child; null !== parentFiber; ) {
        var nextSibling = parentFiber.sibling;
        reconnectPassiveEffects(
          finishedRoot,
          parentFiber,
          committedLanes,
          committedTransitions,
          includeWorkInProgressEffects,
          null !== nextSibling ? nextSibling.actualStartTime : endTime
        );
        parentFiber = nextSibling;
      }
    }
    function reconnectPassiveEffects(
      finishedRoot,
      finishedWork,
      committedLanes,
      committedTransitions,
      includeWorkInProgressEffects,
      endTime
    ) {
      var prevEffectStart = pushComponentEffectStart(),
        prevEffectDuration = pushComponentEffectDuration(),
        prevEffectErrors = pushComponentEffectErrors(),
        prevDeepEquality = alreadyWarnedForDeepEquality;
      includeWorkInProgressEffects &&
        (finishedWork.mode & ProfileMode) !== NoMode &&
        0 < finishedWork.actualStartTime &&
        0 !== (finishedWork.flags & 1) &&
        logComponentRender(
          finishedWork,
          finishedWork.actualStartTime,
          endTime,
          inHydratedSubtree,
          committedLanes
        );
      var flags = finishedWork.flags;
      switch (finishedWork.tag) {
        case 0:
        case 11:
        case 15:
          recursivelyTraverseReconnectPassiveEffects(
            finishedRoot,
            finishedWork,
            committedLanes,
            committedTransitions,
            includeWorkInProgressEffects,
            endTime
          );
          commitHookPassiveMountEffects(finishedWork, Passive);
          break;
        case 23:
          break;
        case 22:
          var _instance2 = finishedWork.stateNode;
          null !== finishedWork.memoizedState
            ? _instance2._visibility & OffscreenPassiveEffectsConnected
              ? recursivelyTraverseReconnectPassiveEffects(
                  finishedRoot,
                  finishedWork,
                  committedLanes,
                  committedTransitions,
                  includeWorkInProgressEffects,
                  endTime
                )
              : recursivelyTraverseAtomicPassiveEffects(
                  finishedRoot,
                  finishedWork,
                  committedLanes,
                  committedTransitions,
                  endTime
                )
            : ((_instance2._visibility |= OffscreenPassiveEffectsConnected),
              recursivelyTraverseReconnectPassiveEffects(
                finishedRoot,
                finishedWork,
                committedLanes,
                committedTransitions,
                includeWorkInProgressEffects,
                endTime
              ));
          includeWorkInProgressEffects &&
            flags & 2048 &&
            commitOffscreenPassiveMountEffects(
              finishedWork.alternate,
              finishedWork
            );
          break;
        case 24:
          recursivelyTraverseReconnectPassiveEffects(
            finishedRoot,
            finishedWork,
            committedLanes,
            committedTransitions,
            includeWorkInProgressEffects,
            endTime
          );
          includeWorkInProgressEffects &&
            flags & 2048 &&
            commitCachePassiveMountEffect(finishedWork.alternate, finishedWork);
          break;
        default:
          recursivelyTraverseReconnectPassiveEffects(
            finishedRoot,
            finishedWork,
            committedLanes,
            committedTransitions,
            includeWorkInProgressEffects,
            endTime
          );
      }
      (finishedWork.mode & ProfileMode) !== NoMode &&
        0 <= componentEffectStartTime &&
        0 <= componentEffectEndTime &&
        0.05 < componentEffectDuration &&
        logComponentEffect(
          finishedWork,
          componentEffectStartTime,
          componentEffectEndTime,
          componentEffectDuration,
          componentEffectErrors
        );
      popComponentEffectStart(prevEffectStart);
      popComponentEffectDuration(prevEffectDuration);
      componentEffectErrors = prevEffectErrors;
      alreadyWarnedForDeepEquality = prevDeepEquality;
    }
    function recursivelyTraverseAtomicPassiveEffects(
      finishedRoot$jscomp$0,
      parentFiber,
      committedLanes$jscomp$0,
      committedTransitions$jscomp$0,
      endTime$jscomp$0
    ) {
      if (parentFiber.subtreeFlags & 10256)
        for (var child = parentFiber.child; null !== child; ) {
          parentFiber = child.sibling;
          var finishedRoot = finishedRoot$jscomp$0,
            committedLanes = committedLanes$jscomp$0,
            committedTransitions = committedTransitions$jscomp$0,
            endTime =
              null !== parentFiber
                ? parentFiber.actualStartTime
                : endTime$jscomp$0,
            prevDeepEquality = alreadyWarnedForDeepEquality;
          (child.mode & ProfileMode) !== NoMode &&
            0 < child.actualStartTime &&
            0 !== (child.flags & 1) &&
            logComponentRender(
              child,
              child.actualStartTime,
              endTime,
              inHydratedSubtree,
              committedLanes
            );
          var flags = child.flags;
          switch (child.tag) {
            case 22:
              recursivelyTraverseAtomicPassiveEffects(
                finishedRoot,
                child,
                committedLanes,
                committedTransitions,
                endTime
              );
              flags & 2048 &&
                commitOffscreenPassiveMountEffects(child.alternate, child);
              break;
            case 24:
              recursivelyTraverseAtomicPassiveEffects(
                finishedRoot,
                child,
                committedLanes,
                committedTransitions,
                endTime
              );
              flags & 2048 &&
                commitCachePassiveMountEffect(child.alternate, child);
              break;
            default:
              recursivelyTraverseAtomicPassiveEffects(
                finishedRoot,
                child,
                committedLanes,
                committedTransitions,
                endTime
              );
          }
          alreadyWarnedForDeepEquality = prevDeepEquality;
          child = parentFiber;
        }
    }
    function recursivelyAccumulateSuspenseyCommit(parentFiber, committedLanes) {
      if (parentFiber.subtreeFlags & suspenseyCommitFlag)
        for (parentFiber = parentFiber.child; null !== parentFiber; )
          accumulateSuspenseyCommitOnFiber(parentFiber, committedLanes),
            (parentFiber = parentFiber.sibling);
    }
    function accumulateSuspenseyCommitOnFiber(fiber, committedLanes) {
      switch (fiber.tag) {
        case 26:
          recursivelyAccumulateSuspenseyCommit(fiber, committedLanes);
          fiber.flags & suspenseyCommitFlag &&
            (null !== fiber.memoizedState
              ? suspendResource(
                  currentHoistableRoot,
                  fiber.memoizedState,
                  fiber.memoizedProps
                )
              : ((fiber = fiber.stateNode),
                (committedLanes & 335544128) === committedLanes &&
                  suspendInstance(fiber)));
          break;
        case 5:
          recursivelyAccumulateSuspenseyCommit(fiber, committedLanes);
          fiber.flags & suspenseyCommitFlag &&
            ((fiber = fiber.stateNode),
            (committedLanes & 335544128) === committedLanes &&
              suspendInstance(fiber));
          break;
        case 3:
        case 4:
          var previousHoistableRoot = currentHoistableRoot;
          currentHoistableRoot = getHoistableRoot(
            fiber.stateNode.containerInfo
          );
          recursivelyAccumulateSuspenseyCommit(fiber, committedLanes);
          currentHoistableRoot = previousHoistableRoot;
          break;
        case 22:
          null === fiber.memoizedState &&
            ((previousHoistableRoot = fiber.alternate),
            null !== previousHoistableRoot &&
            null !== previousHoistableRoot.memoizedState
              ? ((previousHoistableRoot = suspenseyCommitFlag),
                (suspenseyCommitFlag = 16777216),
                recursivelyAccumulateSuspenseyCommit(fiber, committedLanes),
                (suspenseyCommitFlag = previousHoistableRoot))
              : recursivelyAccumulateSuspenseyCommit(fiber, committedLanes));
          break;
        case 30:
          if (
            0 !== (fiber.flags & suspenseyCommitFlag) &&
            ((previousHoistableRoot = fiber.memoizedProps.name),
            null != previousHoistableRoot && "auto" !== previousHoistableRoot)
          ) {
            var state = fiber.stateNode;
            state.paired = null;
            null === appearingViewTransitions &&
              (appearingViewTransitions = new Map());
            appearingViewTransitions.set(previousHoistableRoot, state);
          }
          recursivelyAccumulateSuspenseyCommit(fiber, committedLanes);
          break;
        default:
          recursivelyAccumulateSuspenseyCommit(fiber, committedLanes);
      }
    }
    function detachAlternateSiblings(parentFiber) {
      var previousFiber = parentFiber.alternate;
      if (
        null !== previousFiber &&
        ((parentFiber = previousFiber.child), null !== parentFiber)
      ) {
        previousFiber.child = null;
        do
          (previousFiber = parentFiber.sibling),
            (parentFiber.sibling = null),
            (parentFiber = previousFiber);
        while (null !== parentFiber);
      }
    }
    function recursivelyTraversePassiveUnmountEffects(parentFiber) {
      var deletions = parentFiber.deletions;
      if (0 !== (parentFiber.flags & 16)) {
        if (null !== deletions)
          for (var i = 0; i < deletions.length; i++) {
            var childToDelete = deletions[i],
              prevEffectStart = pushComponentEffectStart();
            nextEffect = childToDelete;
            commitPassiveUnmountEffectsInsideOfDeletedTree_begin(
              childToDelete,
              parentFiber
            );
            (childToDelete.mode & ProfileMode) !== NoMode &&
              0 <= componentEffectStartTime &&
              0 <= componentEffectEndTime &&
              0.05 < componentEffectEndTime - componentEffectStartTime &&
              logComponentTrigger(
                childToDelete,
                componentEffectStartTime,
                componentEffectEndTime,
                "Unmount"
              );
            popComponentEffectStart(prevEffectStart);
          }
        detachAlternateSiblings(parentFiber);
      }
      if (parentFiber.subtreeFlags & 10256)
        for (parentFiber = parentFiber.child; null !== parentFiber; )
          commitPassiveUnmountOnFiber(parentFiber),
            (parentFiber = parentFiber.sibling);
    }
    function commitPassiveUnmountOnFiber(finishedWork) {
      var prevEffectStart = pushComponentEffectStart(),
        prevEffectDuration = pushComponentEffectDuration(),
        prevEffectErrors = pushComponentEffectErrors();
      switch (finishedWork.tag) {
        case 0:
        case 11:
        case 15:
          recursivelyTraversePassiveUnmountEffects(finishedWork);
          finishedWork.flags & 2048 &&
            commitHookPassiveUnmountEffects(
              finishedWork,
              finishedWork.return,
              Passive | HasEffect
            );
          break;
        case 3:
          var prevProfilerEffectDuration = pushNestedEffectDurations();
          recursivelyTraversePassiveUnmountEffects(finishedWork);
          finishedWork.stateNode.passiveEffectDuration +=
            popNestedEffectDurations(prevProfilerEffectDuration);
          break;
        case 12:
          prevProfilerEffectDuration = pushNestedEffectDurations();
          recursivelyTraversePassiveUnmountEffects(finishedWork);
          finishedWork.stateNode.passiveEffectDuration +=
            bubbleNestedEffectDurations(prevProfilerEffectDuration);
          break;
        case 22:
          prevProfilerEffectDuration = finishedWork.stateNode;
          null !== finishedWork.memoizedState &&
          prevProfilerEffectDuration._visibility &
            OffscreenPassiveEffectsConnected &&
          (null === finishedWork.return || 13 !== finishedWork.return.tag)
            ? ((prevProfilerEffectDuration._visibility &=
                ~OffscreenPassiveEffectsConnected),
              recursivelyTraverseDisconnectPassiveEffects(finishedWork),
              (finishedWork.mode & ProfileMode) !== NoMode &&
                0 <= componentEffectStartTime &&
                0 <= componentEffectEndTime &&
                0.05 < componentEffectEndTime - componentEffectStartTime &&
                logComponentTrigger(
                  finishedWork,
                  componentEffectStartTime,
                  componentEffectEndTime,
                  "Disconnect"
                ))
            : recursivelyTraversePassiveUnmountEffects(finishedWork);
          break;
        default:
          recursivelyTraversePassiveUnmountEffects(finishedWork);
      }
      (finishedWork.mode & ProfileMode) !== NoMode &&
        0 <= componentEffectStartTime &&
        0 <= componentEffectEndTime &&
        0.05 < componentEffectDuration &&
        logComponentEffect(
          finishedWork,
          componentEffectStartTime,
          componentEffectEndTime,
          componentEffectDuration,
          componentEffectErrors
        );
      popComponentEffectStart(prevEffectStart);
      popComponentEffectDuration(prevEffectDuration);
      componentEffectErrors = prevEffectErrors;
    }
    function recursivelyTraverseDisconnectPassiveEffects(parentFiber) {
      var deletions = parentFiber.deletions;
      if (0 !== (parentFiber.flags & 16)) {
        if (null !== deletions)
          for (var i = 0; i < deletions.length; i++) {
            var childToDelete = deletions[i],
              prevEffectStart = pushComponentEffectStart();
            nextEffect = childToDelete;
            commitPassiveUnmountEffectsInsideOfDeletedTree_begin(
              childToDelete,
              parentFiber
            );
            (childToDelete.mode & ProfileMode) !== NoMode &&
              0 <= componentEffectStartTime &&
              0 <= componentEffectEndTime &&
              0.05 < componentEffectEndTime - componentEffectStartTime &&
              logComponentTrigger(
                childToDelete,
                componentEffectStartTime,
                componentEffectEndTime,
                "Unmount"
              );
            popComponentEffectStart(prevEffectStart);
          }
        detachAlternateSiblings(parentFiber);
      }
      for (parentFiber = parentFiber.child; null !== parentFiber; )
        disconnectPassiveEffect(parentFiber),
          (parentFiber = parentFiber.sibling);
    }
    function disconnectPassiveEffect(finishedWork) {
      var prevEffectStart = pushComponentEffectStart(),
        prevEffectDuration = pushComponentEffectDuration(),
        prevEffectErrors = pushComponentEffectErrors();
      switch (finishedWork.tag) {
        case 0:
        case 11:
        case 15:
          commitHookPassiveUnmountEffects(
            finishedWork,
            finishedWork.return,
            Passive
          );
          recursivelyTraverseDisconnectPassiveEffects(finishedWork);
          break;
        case 22:
          var instance = finishedWork.stateNode;
          instance._visibility & OffscreenPassiveEffectsConnected &&
            ((instance._visibility &= ~OffscreenPassiveEffectsConnected),
            recursivelyTraverseDisconnectPassiveEffects(finishedWork));
          break;
        default:
          recursivelyTraverseDisconnectPassiveEffects(finishedWork);
      }
      (finishedWork.mode & ProfileMode) !== NoMode &&
        0 <= componentEffectStartTime &&
        0 <= componentEffectEndTime &&
        0.05 < componentEffectDuration &&
        logComponentEffect(
          finishedWork,
          componentEffectStartTime,
          componentEffectEndTime,
          componentEffectDuration,
          componentEffectErrors
        );
      popComponentEffectStart(prevEffectStart);
      popComponentEffectDuration(prevEffectDuration);
      componentEffectErrors = prevEffectErrors;
    }
    function commitPassiveUnmountEffectsInsideOfDeletedTree_begin(
      deletedSubtreeRoot,
      nearestMountedAncestor$jscomp$0
    ) {
      for (; null !== nextEffect; ) {
        var fiber = nextEffect,
          current = fiber,
          nearestMountedAncestor = nearestMountedAncestor$jscomp$0,
          prevEffectStart = pushComponentEffectStart(),
          prevEffectDuration = pushComponentEffectDuration(),
          prevEffectErrors = pushComponentEffectErrors();
        switch (current.tag) {
          case 0:
          case 11:
          case 15:
            commitHookPassiveUnmountEffects(
              current,
              nearestMountedAncestor,
              Passive
            );
            break;
          case 23:
          case 22:
            null !== current.memoizedState &&
              null !== current.memoizedState.cachePool &&
              ((nearestMountedAncestor = current.memoizedState.cachePool.pool),
              null != nearestMountedAncestor &&
                retainCache(nearestMountedAncestor));
            break;
          case 24:
            releaseCache(current.memoizedState.cache);
        }
        (current.mode & ProfileMode) !== NoMode &&
          0 <= componentEffectStartTime &&
          0 <= componentEffectEndTime &&
          0.05 < componentEffectDuration &&
          logComponentEffect(
            current,
            componentEffectStartTime,
            componentEffectEndTime,
            componentEffectDuration,
            componentEffectErrors
          );
        popComponentEffectStart(prevEffectStart);
        popComponentEffectDuration(prevEffectDuration);
        componentEffectErrors = prevEffectErrors;
        current = fiber.child;
        if (null !== current) (current.return = fiber), (nextEffect = current);
        else
          a: for (fiber = deletedSubtreeRoot; null !== nextEffect; ) {
            current = nextEffect;
            prevEffectStart = current.sibling;
            prevEffectDuration = current.return;
            detachFiberAfterEffects(current);
            if (current === fiber) {
              nextEffect = null;
              break a;
            }
            if (null !== prevEffectStart) {
              prevEffectStart.return = prevEffectDuration;
              nextEffect = prevEffectStart;
              break a;
            }
            nextEffect = prevEffectDuration;
          }
      }
    }
    function applyViewTransitionToClones(name, className, clones) {
      for (var i = 0; i < clones.length; i++)
        applyViewTransitionName(
          clones[i],
          0 === i ? name : name + "_" + i,
          className
        );
    }
    function trackDeletedPairViewTransitions(deletion) {
      if (
        null !== appearingViewTransitions &&
        0 !== appearingViewTransitions.size
      ) {
        var pairs = appearingViewTransitions;
        if (0 !== (deletion.subtreeFlags & 18874368))
          for (deletion = deletion.child; null !== deletion; ) {
            if (22 !== deletion.tag || null !== deletion.memoizedState) {
              if (30 === deletion.tag && 0 !== (deletion.flags & 18874368)) {
                var props = deletion.memoizedProps,
                  name = props.name;
                if (null != name && "auto" !== name) {
                  var pair = pairs.get(name);
                  if (void 0 !== pair) {
                    pairs.delete(name);
                    props = getViewTransitionClassName(
                      props.default,
                      props.share
                    );
                    if ("none" !== props) {
                      var newInstance = deletion.stateNode;
                      pair.paired = newInstance;
                      newInstance.paired = pair;
                      pair = pair.clones;
                      null !== pair &&
                        applyViewTransitionToClones(name, props, pair);
                    }
                    if (0 === pairs.size) break;
                  }
                }
              }
              trackDeletedPairViewTransitions(deletion);
            }
            deletion = deletion.sibling;
          }
      }
    }
    function trackEnterViewTransitions(deletion) {
      if (30 === deletion.tag) {
        var props = deletion.memoizedProps,
          name = getViewTransitionName(props, deletion.stateNode),
          pair =
            null !== appearingViewTransitions
              ? appearingViewTransitions.get(name)
              : void 0;
        props = getViewTransitionClassName(
          props.default,
          void 0 !== pair ? props.share : props.enter
        );
        if ("none" !== props && void 0 !== pair) {
          appearingViewTransitions.delete(name);
          var newInstance = deletion.stateNode;
          pair.paired = newInstance;
          newInstance.paired = pair;
          pair = pair.clones;
          null !== pair && applyViewTransitionToClones(name, props, pair);
        }
        trackDeletedPairViewTransitions(deletion);
      } else if (0 !== (deletion.subtreeFlags & 33554432))
        for (deletion = deletion.child; null !== deletion; )
          trackEnterViewTransitions(deletion), (deletion = deletion.sibling);
      else trackDeletedPairViewTransitions(deletion);
    }
    function applyAppearingPairViewTransition(child) {
      if (0 !== (child.flags & 18874368)) {
        var state = child.stateNode;
        if (state.paired) {
          var props = child.memoizedProps;
          if (null == props.name || "auto" === props.name)
            throw Error(
              "Found a pair with an auto name. This is a bug in React."
            );
          child = props.name;
          props = getViewTransitionClassName(props.default, props.share);
          "none" !== props &&
            ((state = state.clones),
            null !== state && applyViewTransitionToClones(child, props, state));
        }
      }
    }
    function applyExitViewTransition(placement) {
      var state = placement.stateNode,
        props = placement.memoizedProps;
      placement = getViewTransitionName(props, state);
      props = getViewTransitionClassName(
        props.default,
        state.paired ? props.share : props.exit
      );
      "none" !== props &&
        ((state = state.clones),
        null !== state && applyViewTransitionToClones(placement, props, state));
    }
    function recursivelyInsertNew(
      parentFiber,
      hostParentClone,
      parentViewTransition,
      visitPhase
    ) {
      if (
        visitPhase !== INSERT_APPEARING_PAIR ||
        null !== parentViewTransition ||
        0 !== (parentFiber.subtreeFlags & 18874368)
      )
        for (parentFiber = parentFiber.child; null !== parentFiber; )
          recursivelyInsertNewFiber(
            parentFiber,
            hostParentClone,
            parentViewTransition,
            visitPhase
          ),
            (parentFiber = parentFiber.sibling);
    }
    function recursivelyInsertNewFiber(
      finishedWork,
      hostParentClone,
      parentViewTransition,
      visitPhase
    ) {
      switch (finishedWork.tag) {
        case 26:
          recursivelyInsertNew(
            finishedWork,
            hostParentClone,
            parentViewTransition,
            visitPhase
          );
          break;
        case 27:
          recursivelyInsertNew(
            finishedWork,
            hostParentClone,
            parentViewTransition,
            visitPhase
          );
          finishedWork.flags & 4 &&
            console.error(
              "startGestureTransition() caused something to render a new <%s>. This is not possible in the current implementation. Make sure that the swipe doesn't mount any new <%s> elements.",
              finishedWork.type,
              finishedWork.type
            );
          break;
        case 5:
          var instance = finishedWork.stateNode;
          visitPhase !== INSERT_APPEARING_PAIR
            ? (hostParentClone.appendChild(instance),
              (viewTransitionMutationContext = !0),
              recursivelyInsertNew(
                finishedWork,
                instance,
                null,
                INSERT_APPEARING_PAIR
              ))
            : recursivelyInsertNew(finishedWork, instance, null, visitPhase);
          null !== parentViewTransition &&
            (null === parentViewTransition.clones
              ? (parentViewTransition.clones = [instance])
              : parentViewTransition.clones.push(instance));
          break;
        case 6:
          finishedWork = finishedWork.stateNode;
          if (null === finishedWork)
            throw Error(
              "This should have a text node initialized. This error is likely caused by a bug in React. Please file an issue."
            );
          visitPhase !== INSERT_APPEARING_PAIR &&
            (hostParentClone.appendChild(finishedWork),
            (viewTransitionMutationContext = !0));
          break;
        case 4:
          break;
        case 22:
          null === finishedWork.memoizedState &&
            recursivelyInsertNew(
              finishedWork,
              hostParentClone,
              parentViewTransition,
              visitPhase
            );
          break;
        case 30:
          parentViewTransition = pushMutationContext();
          instance = finishedWork.stateNode;
          instance.clones = null;
          recursivelyInsertNew(
            finishedWork,
            hostParentClone,
            instance,
            visitPhase === INSERT_EXIT ? INSERT_APPEND : visitPhase
          );
          visitPhase === INSERT_EXIT
            ? applyExitViewTransition(finishedWork)
            : (visitPhase === INSERT_APPEARING_PAIR ||
                visitPhase === INSERT_APPEND) &&
              applyAppearingPairViewTransition(finishedWork);
          popMutationContext(parentViewTransition);
          break;
        default:
          recursivelyInsertNew(
            finishedWork,
            hostParentClone,
            parentViewTransition,
            visitPhase
          );
      }
    }
    function recursivelyInsertClonesFromExistingTree(
      parentFiber,
      hostParentClone,
      parentViewTransition,
      visitPhase
    ) {
      for (parentFiber = parentFiber.child; null !== parentFiber; ) {
        switch (parentFiber.tag) {
          case 5:
            var instance = parentFiber.stateNode;
            switch (visitPhase) {
              case CLONE_EXIT:
              case CLONE_UNHIDE:
              case CLONE_APPEARING_PAIR:
                var _nextPhase =
                  0 !== (parentFiber.subtreeFlags & 18874368)
                    ? CLONE_APPEARING_PAIR
                    : CLONE_UNCHANGED;
                break;
              default:
                _nextPhase = CLONE_UNCHANGED;
            }
            _nextPhase !== CLONE_UNCHANGED
              ? ((instance = instance.cloneNode(!1)),
                recursivelyInsertClonesFromExistingTree(
                  parentFiber,
                  instance,
                  null,
                  _nextPhase
                ))
              : (instance = instance.cloneNode(!0));
            hostParentClone.appendChild(instance);
            null !== parentViewTransition &&
              (null === parentViewTransition.clones
                ? (parentViewTransition.clones = [instance])
                : parentViewTransition.clones.push(instance));
            if (visitPhase === CLONE_EXIT || visitPhase === CLONE_UNHIDE)
              unhideInstance(instance, parentFiber.memoizedProps),
                (viewTransitionMutationContext = !0);
            break;
          case 6:
            _nextPhase = parentFiber.stateNode;
            if (null === _nextPhase)
              throw Error(
                "This should have a text node initialized. This error is likely caused by a bug in React. Please file an issue."
              );
            _nextPhase = _nextPhase.cloneNode(!1);
            hostParentClone.appendChild(_nextPhase);
            if (visitPhase === CLONE_EXIT || visitPhase === CLONE_UNHIDE)
              (_nextPhase.nodeValue = parentFiber.memoizedProps),
                (viewTransitionMutationContext = !0);
            break;
          case 4:
            break;
          case 22:
            null === parentFiber.memoizedState &&
              recursivelyInsertClonesFromExistingTree(
                parentFiber,
                hostParentClone,
                parentViewTransition,
                visitPhase
              );
            break;
          case 30:
            _nextPhase = pushMutationContext();
            instance = parentFiber.stateNode;
            instance.clones = null;
            parentFiber.flags &= -5;
            recursivelyInsertClonesFromExistingTree(
              parentFiber,
              hostParentClone,
              instance,
              visitPhase === CLONE_EXIT
                ? CLONE_UNHIDE
                : visitPhase === CLONE_UPDATE
                  ? CLONE_UNCHANGED
                  : visitPhase
            );
            if (visitPhase === CLONE_EXIT) applyExitViewTransition(parentFiber);
            else if (
              visitPhase === CLONE_APPEARING_PAIR ||
              visitPhase === CLONE_UNHIDE
            )
              applyAppearingPairViewTransition(parentFiber);
            else if (visitPhase === CLONE_UPDATE) {
              var state = parentFiber.stateNode,
                props = parentFiber.memoizedProps;
              instance = getViewTransitionName(props, state);
              props = getViewTransitionClassName(props.default, props.update);
              "none" !== props &&
                ((state = state.clones),
                null !== state &&
                  applyViewTransitionToClones(instance, props, state));
            }
            popMutationContext(_nextPhase);
            break;
          default:
            recursivelyInsertClonesFromExistingTree(
              parentFiber,
              hostParentClone,
              parentViewTransition,
              visitPhase
            );
        }
        parentFiber = parentFiber.sibling;
      }
    }
    function recursivelyInsertClones(
      parentFiber,
      hostParentClone$jscomp$0,
      parentViewTransition,
      visitPhase$jscomp$0
    ) {
      var deletions = parentFiber.deletions;
      if (null !== deletions)
        for (var i = 0; i < deletions.length; i++)
          trackEnterViewTransitions(deletions[i]),
            (viewTransitionMutationContext = !0);
      if (
        null === parentFiber.alternate ||
        0 !== (parentFiber.subtreeFlags & 13878)
      )
        for (parentFiber = parentFiber.child; null !== parentFiber; ) {
          deletions = parentFiber;
          var hostParentClone = hostParentClone$jscomp$0;
          var nextPhase = parentViewTransition;
          var visitPhase = visitPhase$jscomp$0;
          i = deletions.alternate;
          if (null === i)
            recursivelyInsertNewFiber(
              deletions,
              hostParentClone,
              nextPhase,
              INSERT_EXIT
            );
          else {
            var flags = deletions.flags;
            switch (deletions.tag) {
              case 26:
                recursivelyInsertClones(
                  deletions,
                  hostParentClone,
                  nextPhase,
                  visitPhase
                );
                break;
              case 27:
                recursivelyInsertClones(
                  deletions,
                  hostParentClone,
                  nextPhase,
                  visitPhase
                );
                if (flags & 4) {
                  hostParentClone = deletions.memoizedProps;
                  i = i.memoizedProps;
                  visitPhase = deletions.stateNode;
                  flags = deletions.type;
                  nextPhase = pushMutationContext();
                  try {
                    commitUpdate(
                      visitPhase,
                      flags,
                      i,
                      hostParentClone,
                      deletions
                    ),
                      viewTransitionMutationContext &&
                        console.error(
                          "startGestureTransition() caused something to mutate <%s>. This is not possible in the current implementation. Make sure that the swipe doesn't update any state which causes <%s> to change.",
                          deletions.type,
                          deletions.type
                        ),
                      commitUpdate(
                        visitPhase,
                        flags,
                        hostParentClone,
                        i,
                        deletions
                      );
                  } finally {
                    popMutationContext(nextPhase);
                  }
                }
                break;
              case 5:
                var clone = deletions.stateNode;
                null === deletions.child
                  ? ((clone = clone.cloneNode(!0)),
                    deletions.flags & 32 &&
                      (resetTextContent(clone),
                      (viewTransitionMutationContext = !0)))
                  : (clone = clone.cloneNode(!1));
                flags & 4 &&
                  commitUpdate(
                    clone,
                    deletions.type,
                    i.memoizedProps,
                    deletions.memoizedProps
                  );
                visitPhase === CLONE_EXIT || visitPhase === CLONE_UNHIDE
                  ? (hostParentClone.appendChild(clone),
                    unhideInstance(clone, deletions.memoizedProps),
                    recursivelyInsertClones(
                      deletions,
                      clone,
                      null,
                      CLONE_APPEARING_PAIR
                    ),
                    (viewTransitionMutationContext = !0))
                  : (hostParentClone.appendChild(clone),
                    recursivelyInsertClones(
                      deletions,
                      clone,
                      null,
                      visitPhase
                    ));
                null !== nextPhase &&
                  (null === nextPhase.clones
                    ? (nextPhase.clones = [clone])
                    : nextPhase.clones.push(clone));
                break;
              case 6:
                nextPhase = deletions.stateNode;
                if (null === nextPhase)
                  throw Error(
                    "This should have a text node initialized. This error is likely caused by a bug in React. Please file an issue."
                  );
                nextPhase = nextPhase.cloneNode(!1);
                flags & 4 &&
                  ((nextPhase.nodeValue = i.memoizedProps),
                  (viewTransitionMutationContext = !0));
                hostParentClone.appendChild(nextPhase);
                if (visitPhase === CLONE_EXIT || visitPhase === CLONE_UNHIDE)
                  (nextPhase.nodeValue = deletions.memoizedProps),
                    (viewTransitionMutationContext = !0);
                break;
              case 4:
                break;
              case 22:
                null === deletions.memoizedState
                  ? ((i =
                      visitPhase === CLONE_UPDATE && 0 !== (flags & 8192)
                        ? CLONE_EXIT
                        : visitPhase),
                    recursivelyInsertClones(
                      deletions,
                      hostParentClone,
                      nextPhase,
                      i
                    ))
                  : null !== i &&
                    null === i.memoizedState &&
                    (trackEnterViewTransitions(i),
                    (viewTransitionMutationContext = !0));
                break;
              case 30:
                flags = pushMutationContext();
                clone = deletions.stateNode;
                clone.clones = null;
                nextPhase =
                  visitPhase === CLONE_EXIT ? CLONE_UNHIDE : visitPhase;
                recursivelyInsertClones(
                  deletions,
                  hostParentClone,
                  clone,
                  nextPhase
                );
                viewTransitionMutationContext && (deletions.flags |= 4);
                visitPhase === CLONE_EXIT
                  ? applyExitViewTransition(deletions)
                  : visitPhase === CLONE_APPEARING_PAIR ||
                      visitPhase === CLONE_UNHIDE
                    ? applyAppearingPairViewTransition(deletions)
                    : visitPhase === CLONE_UPDATE &&
                      ((hostParentClone = deletions.stateNode),
                      (i = i.memoizedProps),
                      (deletions = getViewTransitionName(
                        deletions.memoizedProps,
                        hostParentClone
                      )),
                      (i = getViewTransitionClassName(i.default, i.update)),
                      "none" !== i &&
                        ((hostParentClone = hostParentClone.clones),
                        null !== hostParentClone &&
                          applyViewTransitionToClones(
                            deletions,
                            i,
                            hostParentClone
                          )));
                popMutationContext(flags);
                break;
              default:
                recursivelyInsertClones(
                  deletions,
                  hostParentClone,
                  nextPhase,
                  visitPhase
                );
            }
          }
          parentFiber = parentFiber.sibling;
        }
      else
        recursivelyInsertClonesFromExistingTree(
          parentFiber,
          hostParentClone$jscomp$0,
          parentViewTransition,
          visitPhase$jscomp$0
        );
    }
    function recursivelyApplyViewTransitions(parentFiber) {
      var deletions = parentFiber.deletions;
      if (null !== deletions)
        for (var i = 0; i < deletions.length; i++)
          commitEnterViewTransitions(deletions[i], !0);
      if (
        null === parentFiber.alternate ||
        0 !== (parentFiber.subtreeFlags & 13878)
      )
        for (parentFiber = parentFiber.child; null !== parentFiber; ) {
          deletions = parentFiber;
          i = deletions.alternate;
          if (null !== i) {
            var flags = deletions.flags;
            switch (deletions.tag) {
              case 4:
                break;
              case 22:
                flags & 8192 &&
                  null !== deletions.memoizedState &&
                  null !== i &&
                  null === i.memoizedState &&
                  commitEnterViewTransitions(i, !0);
                break;
              case 30:
                flags = viewTransitionContextChanged;
                var prevCancelableChildren =
                  pushViewTransitionCancelableScope();
                viewTransitionContextChanged = !1;
                recursivelyApplyViewTransitions(deletions);
                viewTransitionContextChanged && (deletions.flags |= 4);
                i = measureUpdateViewTransition(i, deletions, !0);
                0 !== (deletions.flags & 4) && i
                  ? (viewTransitionCancelableChildren = prevCancelableChildren)
                  : null !== prevCancelableChildren &&
                    (prevCancelableChildren.push.apply(
                      prevCancelableChildren,
                      viewTransitionCancelableChildren
                    ),
                    (viewTransitionCancelableChildren =
                      prevCancelableChildren));
                viewTransitionContextChanged =
                  0 !== (deletions.flags & 32) ? !0 : flags;
                deletions.stateNode.clones = null;
                break;
              default:
                recursivelyApplyViewTransitions(deletions);
            }
          }
          parentFiber = parentFiber.sibling;
        }
      else measureNestedViewTransitions(parentFiber, !0);
    }
    function recursivelyRestoreViewTransitions(parentFiber) {
      var deletions = parentFiber.deletions;
      if (null !== deletions)
        for (var i = 0; i < deletions.length; i++)
          restoreEnterOrExitViewTransitions(deletions[i]);
      if (
        null === parentFiber.alternate ||
        0 !== (parentFiber.subtreeFlags & 13878)
      )
        for (parentFiber = parentFiber.child; null !== parentFiber; )
          restoreViewTransitionsOnFiber(parentFiber),
            (parentFiber = parentFiber.sibling);
      else restoreNestedViewTransitions(parentFiber);
    }
    function restoreViewTransitionsOnFiber(finishedWork) {
      var current = finishedWork.alternate;
      if (null === current) restoreEnterOrExitViewTransitions(finishedWork);
      else {
        var flags = finishedWork.flags;
        switch (finishedWork.tag) {
          case 4:
            break;
          case 22:
            flags & 8192 &&
              (null === finishedWork.memoizedState
                ? restoreEnterOrExitViewTransitions(finishedWork)
                : null !== current &&
                  null === current.memoizedState &&
                  restoreEnterOrExitViewTransitions(current));
            break;
          case 30:
            restoreViewTransitionOnHostInstances(current.child, !0);
            recursivelyRestoreViewTransitions(finishedWork);
            break;
          default:
            recursivelyRestoreViewTransitions(finishedWork);
        }
      }
    }
    function onCommitRoot() {
      commitHooks.forEach(function (commitHook) {
        return commitHook();
      });
    }
    function isConcurrentActEnvironment() {
      var isReactActEnvironmentGlobal =
        "undefined" !== typeof IS_REACT_ACT_ENVIRONMENT
          ? IS_REACT_ACT_ENVIRONMENT
          : void 0;
      isReactActEnvironmentGlobal ||
        null === ReactSharedInternals.actQueue ||
        console.error(
          "The current testing environment is not configured to support act(...)"
        );
      return isReactActEnvironmentGlobal;
    }
    function requestUpdateLane(fiber) {
      if (
        (executionContext & RenderContext) !== NoContext &&
        0 !== workInProgressRootRenderLanes
      )
        return workInProgressRootRenderLanes & -workInProgressRootRenderLanes;
      var transition = ReactSharedInternals.T;
      if (null !== transition) {
        if (transition.gesture)
          throw Error(
            "Cannot setState on regular state inside a startGestureTransition. Gestures can only update the useOptimistic() hook. There should be no side-effects associated with starting a Gesture until its Action is invoked. Move side-effects to the Action instead."
          );
        transition._updatedFibers || (transition._updatedFibers = new Set());
        transition._updatedFibers.add(fiber);
        return requestTransitionLane();
      }
      return resolveUpdatePriority();
    }
    function requestDeferredLane() {
      0 === workInProgressDeferredLane &&
        (workInProgressDeferredLane =
          0 === (workInProgressRootRenderLanes & 536870912) || isHydrating
            ? claimNextTransitionLane()
            : 536870912);
      var suspenseHandler = suspenseHandlerStackCursor.current;
      null !== suspenseHandler && (suspenseHandler.flags |= 32);
      return workInProgressDeferredLane;
    }
    function scheduleViewTransitionEvent(fiber, callback) {
      if (null != callback) {
        var state = fiber.stateNode,
          instance = state.ref;
        null === instance &&
          (instance = state.ref =
            createViewTransitionInstance(
              getViewTransitionName(fiber.memoizedProps, state)
            ));
        null === pendingViewTransitionEvents &&
          (pendingViewTransitionEvents = []);
        pendingViewTransitionEvents.push(callback.bind(null, instance));
      }
    }
    function scheduleUpdateOnFiber(root, fiber, lane) {
      isRunningInsertionEffect &&
        console.error("useInsertionEffect must not schedule updates.");
      isFlushingPassiveEffects && (didScheduleUpdateDuringPassiveEffects = !0);
      if (
        (root === workInProgressRoot &&
          (workInProgressSuspendedReason === SuspendedOnData ||
            workInProgressSuspendedReason === SuspendedOnAction)) ||
        null !== root.cancelPendingCommit
      )
        prepareFreshStack(root, 0),
          markRootSuspended(
            root,
            workInProgressRootRenderLanes,
            workInProgressDeferredLane,
            !1
          );
      markRootUpdated$1(root, lane);
      if (
        (executionContext & RenderContext) !== NoContext &&
        root === workInProgressRoot
      ) {
        if (isRendering)
          switch (fiber.tag) {
            case 0:
            case 11:
            case 15:
              root =
                (workInProgress && getComponentNameFromFiber(workInProgress)) ||
                "Unknown";
              didWarnAboutUpdateInRenderForAnotherComponent.has(root) ||
                (didWarnAboutUpdateInRenderForAnotherComponent.add(root),
                (fiber = getComponentNameFromFiber(fiber) || "Unknown"),
                console.error(
                  "Cannot update a component (`%s`) while rendering a different component (`%s`). To locate the bad setState() call inside `%s`, follow the stack trace as described in https://react.dev/link/setstate-in-render",
                  fiber,
                  root,
                  root
                ));
              break;
            case 1:
              didWarnAboutUpdateInRender ||
                (console.error(
                  "Cannot update during an existing state transition (such as within `render`). Render methods should be a pure function of props and state."
                ),
                (didWarnAboutUpdateInRender = !0));
          }
      } else
        isDevToolsPresent && addFiberToLanesMap(root, fiber, lane),
          warnIfUpdatesNotWrappedWithActDEV(fiber),
          root === workInProgressRoot &&
            ((executionContext & RenderContext) === NoContext &&
              (workInProgressRootInterleavedUpdatedLanes |= lane),
            workInProgressRootExitStatus === RootSuspendedWithDelay &&
              markRootSuspended(
                root,
                workInProgressRootRenderLanes,
                workInProgressDeferredLane,
                !1
              )),
          ensureRootIsScheduled(root);
    }
    function performWorkOnRoot(root, lanes, forceSync) {
      if ((executionContext & (RenderContext | CommitContext)) !== NoContext)
        throw Error("Should not already be working.");
      if (0 !== workInProgressRootRenderLanes && null !== workInProgress) {
        var yieldedFiber = workInProgress,
          yieldEndTime = now$1();
        switch (yieldReason) {
          case SuspendedOnImmediate:
          case SuspendedOnData:
            var startTime = yieldStartTime;
            supportsUserTiming &&
              ((yieldedFiber = yieldedFiber._debugTask)
                ? yieldedFiber.run(
                    console.timeStamp.bind(
                      console,
                      "Suspended",
                      startTime,
                      yieldEndTime,
                      COMPONENTS_TRACK,
                      void 0,
                      "primary-light"
                    )
                  )
                : console.timeStamp(
                    "Suspended",
                    startTime,
                    yieldEndTime,
                    COMPONENTS_TRACK,
                    void 0,
                    "primary-light"
                  ));
            break;
          case SuspendedOnAction:
            startTime = yieldStartTime;
            supportsUserTiming &&
              ((yieldedFiber = yieldedFiber._debugTask)
                ? yieldedFiber.run(
                    console.timeStamp.bind(
                      console,
                      "Action",
                      startTime,
                      yieldEndTime,
                      COMPONENTS_TRACK,
                      void 0,
                      "primary-light"
                    )
                  )
                : console.timeStamp(
                    "Action",
                    startTime,
                    yieldEndTime,
                    COMPONENTS_TRACK,
                    void 0,
                    "primary-light"
                  ));
            break;
          default:
            supportsUserTiming &&
              ((yieldedFiber = yieldEndTime - yieldStartTime),
              3 > yieldedFiber ||
                console.timeStamp(
                  "Blocked",
                  yieldStartTime,
                  yieldEndTime,
                  COMPONENTS_TRACK,
                  void 0,
                  5 > yieldedFiber
                    ? "primary-light"
                    : 10 > yieldedFiber
                      ? "primary"
                      : 100 > yieldedFiber
                        ? "primary-dark"
                        : "error"
                ));
        }
      }
      startTime = (yieldEndTime =
        (!forceSync &&
          0 === (lanes & 124) &&
          0 === (lanes & root.expiredLanes)) ||
        checkIfRootIsPrerendering(root, lanes))
        ? renderRootConcurrent(root, lanes)
        : renderRootSync(root, lanes, !0);
      var renderWasConcurrent = yieldEndTime;
      do {
        if (startTime === RootInProgress) {
          workInProgressRootIsPrerendering &&
            !yieldEndTime &&
            markRootSuspended(root, lanes, 0, !1);
          lanes = workInProgressSuspendedReason;
          yieldStartTime = now();
          yieldReason = lanes;
          break;
        } else {
          yieldedFiber = now$1();
          forceSync = root.current.alternate;
          if (
            renderWasConcurrent &&
            !isRenderConsistentWithExternalStores(forceSync)
          ) {
            setCurrentTrackFromLanes(lanes);
            supportsUserTiming &&
              console.timeStamp(
                "Teared Render",
                renderStartTime,
                yieldedFiber,
                currentTrack,
                LANES_TRACK_GROUP,
                "error"
              );
            finalizeRender(lanes, yieldedFiber);
            startTime = renderRootSync(root, lanes, !1);
            renderWasConcurrent = !1;
            continue;
          }
          if (startTime === RootErrored) {
            renderWasConcurrent = lanes;
            if (root.errorRecoveryDisabledLanes & renderWasConcurrent)
              var errorRetryLanes = 0;
            else
              (errorRetryLanes = root.pendingLanes & -536870913),
                (errorRetryLanes =
                  0 !== errorRetryLanes
                    ? errorRetryLanes
                    : errorRetryLanes & 536870912
                      ? 536870912
                      : 0);
            if (0 !== errorRetryLanes) {
              setCurrentTrackFromLanes(lanes);
              logErroredRenderPhase(renderStartTime, yieldedFiber);
              finalizeRender(lanes, yieldedFiber);
              lanes = errorRetryLanes;
              a: {
                yieldedFiber = root;
                startTime = renderWasConcurrent;
                renderWasConcurrent = workInProgressRootConcurrentErrors;
                var wasRootDehydrated =
                  yieldedFiber.current.memoizedState.isDehydrated;
                wasRootDehydrated &&
                  (prepareFreshStack(yieldedFiber, errorRetryLanes).flags |=
                    256);
                errorRetryLanes = renderRootSync(
                  yieldedFiber,
                  errorRetryLanes,
                  !1
                );
                if (errorRetryLanes !== RootErrored) {
                  if (
                    workInProgressRootDidAttachPingListener &&
                    !wasRootDehydrated
                  ) {
                    yieldedFiber.errorRecoveryDisabledLanes |= startTime;
                    workInProgressRootInterleavedUpdatedLanes |= startTime;
                    startTime = RootSuspendedWithDelay;
                    break a;
                  }
                  yieldedFiber = workInProgressRootRecoverableErrors;
                  workInProgressRootRecoverableErrors = renderWasConcurrent;
                  null !== yieldedFiber &&
                    (null === workInProgressRootRecoverableErrors
                      ? (workInProgressRootRecoverableErrors = yieldedFiber)
                      : workInProgressRootRecoverableErrors.push.apply(
                          workInProgressRootRecoverableErrors,
                          yieldedFiber
                        ));
                }
                startTime = errorRetryLanes;
              }
              renderWasConcurrent = !1;
              if (startTime !== RootErrored) continue;
              else yieldedFiber = now$1();
            }
          }
          if (startTime === RootFatalErrored) {
            setCurrentTrackFromLanes(lanes);
            logErroredRenderPhase(renderStartTime, yieldedFiber);
            finalizeRender(lanes, yieldedFiber);
            prepareFreshStack(root, 0);
            markRootSuspended(root, lanes, 0, !0);
            break;
          }
          a: {
            yieldEndTime = root;
            switch (startTime) {
              case RootInProgress:
              case RootFatalErrored:
                throw Error("Root did not complete. This is a bug in React.");
              case RootSuspendedWithDelay:
                if ((lanes & 4194048) !== lanes) break;
              case RootSuspendedAtTheShell:
                setCurrentTrackFromLanes(lanes);
                logSuspendedRenderPhase(renderStartTime, yieldedFiber, lanes);
                finalizeRender(lanes, yieldedFiber);
                forceSync = lanes;
                0 !== (forceSync & 3) || 0 !== (forceSync & 124)
                  ? (blockingSuspendedTime = yieldedFiber)
                  : 0 !== (forceSync & 4194048) &&
                    (transitionSuspendedTime = yieldedFiber);
                markRootSuspended(
                  yieldEndTime,
                  lanes,
                  workInProgressDeferredLane,
                  !workInProgressRootDidSkipSuspendedSiblings
                );
                break a;
              case RootErrored:
                workInProgressRootRecoverableErrors = null;
                break;
              case RootSuspended:
              case RootCompleted:
                break;
              default:
                throw Error("Unknown root exit status.");
            }
            if (null !== ReactSharedInternals.actQueue)
              commitRoot(
                yieldEndTime,
                forceSync,
                lanes,
                workInProgressRootRecoverableErrors,
                workInProgressTransitions,
                workInProgressRootDidIncludeRecursiveRenderUpdate,
                workInProgressDeferredLane,
                workInProgressRootInterleavedUpdatedLanes,
                workInProgressSuspendedRetryLanes,
                startTime,
                IMMEDIATE_COMMIT,
                renderStartTime,
                yieldedFiber
              );
            else {
              if (
                (lanes & 62914560) === lanes &&
                ((renderWasConcurrent =
                  globalMostRecentFallbackTime +
                  FALLBACK_THROTTLE_MS -
                  now$1()),
                10 < renderWasConcurrent)
              ) {
                markRootSuspended(
                  yieldEndTime,
                  lanes,
                  workInProgressDeferredLane,
                  !workInProgressRootDidSkipSuspendedSiblings
                );
                if (0 !== getNextLanes(yieldEndTime, 0, !0)) break a;
                yieldEndTime.timeoutHandle = scheduleTimeout(
                  commitRootWhenReady.bind(
                    null,
                    yieldEndTime,
                    forceSync,
                    workInProgressRootRecoverableErrors,
                    workInProgressTransitions,
                    workInProgressRootDidIncludeRecursiveRenderUpdate,
                    lanes,
                    workInProgressDeferredLane,
                    workInProgressRootInterleavedUpdatedLanes,
                    workInProgressSuspendedRetryLanes,
                    workInProgressRootDidSkipSuspendedSiblings,
                    startTime,
                    THROTTLED_COMMIT,
                    renderStartTime,
                    yieldedFiber
                  ),
                  renderWasConcurrent
                );
                break a;
              }
              commitRootWhenReady(
                yieldEndTime,
                forceSync,
                workInProgressRootRecoverableErrors,
                workInProgressTransitions,
                workInProgressRootDidIncludeRecursiveRenderUpdate,
                lanes,
                workInProgressDeferredLane,
                workInProgressRootInterleavedUpdatedLanes,
                workInProgressSuspendedRetryLanes,
                workInProgressRootDidSkipSuspendedSiblings,
                startTime,
                IMMEDIATE_COMMIT,
                renderStartTime,
                yieldedFiber
              );
            }
          }
        }
        break;
      } while (1);
      ensureRootIsScheduled(root);
    }
    function commitRootWhenReady(
      root,
      finishedWork,
      recoverableErrors,
      transitions,
      didIncludeRenderPhaseUpdate,
      lanes,
      spawnedLane,
      updatedLanes,
      suspendedRetryLanes,
      didSkipSuspendedSiblings,
      exitStatus,
      suspendedCommitReason,
      completedRenderStartTime,
      completedRenderEndTime
    ) {
      root.timeoutHandle = noTimeout;
      var subtreeFlags = finishedWork.subtreeFlags,
        isViewTransitionEligible = (lanes & 335544064) === lanes,
        isGestureTransition = 64 === lanes;
      if (
        isViewTransitionEligible ||
        subtreeFlags & 8192 ||
        16785408 === (subtreeFlags & 16785408) ||
        isGestureTransition
      ) {
        suspendedState = { stylesheets: null, count: 0, unsuspend: noop$1 };
        appearingViewTransitions = null;
        accumulateSuspenseyCommitOnFiber(finishedWork, lanes);
        if (
          (isViewTransitionEligible || isGestureTransition) &&
          null === root.stoppingGestures
        ) {
          isViewTransitionEligible = root.containerInfo;
          if (null === suspendedState)
            throw Error(
              "Internal React Error: suspendedState null when it was expected to exists. Please report this as a React bug."
            );
          subtreeFlags = suspendedState;
          isViewTransitionEligible = (
            9 === isViewTransitionEligible.nodeType
              ? isViewTransitionEligible
              : isViewTransitionEligible.ownerDocument
          ).__reactViewTransition;
          null != isViewTransitionEligible &&
            (subtreeFlags.count++,
            (subtreeFlags = onUnsuspend.bind(subtreeFlags)),
            isViewTransitionEligible.finished.then(subtreeFlags, subtreeFlags));
        }
        subtreeFlags = waitForCommitToBeReady();
        if (null !== subtreeFlags) {
          root.cancelPendingCommit = subtreeFlags(
            commitRoot.bind(
              null,
              root,
              finishedWork,
              lanes,
              recoverableErrors,
              transitions,
              didIncludeRenderPhaseUpdate,
              spawnedLane,
              updatedLanes,
              suspendedRetryLanes,
              exitStatus,
              SUSPENDED_COMMIT,
              completedRenderStartTime,
              completedRenderEndTime
            )
          );
          markRootSuspended(
            root,
            lanes,
            spawnedLane,
            !didSkipSuspendedSiblings
          );
          return;
        }
      }
      commitRoot(
        root,
        finishedWork,
        lanes,
        recoverableErrors,
        transitions,
        didIncludeRenderPhaseUpdate,
        spawnedLane,
        updatedLanes,
        suspendedRetryLanes,
        exitStatus,
        suspendedCommitReason,
        completedRenderStartTime,
        completedRenderEndTime
      );
    }
    function isRenderConsistentWithExternalStores(finishedWork) {
      for (var node = finishedWork; ; ) {
        var tag = node.tag;
        if (
          (0 === tag || 11 === tag || 15 === tag) &&
          node.flags & 16384 &&
          ((tag = node.updateQueue),
          null !== tag && ((tag = tag.stores), null !== tag))
        )
          for (var i = 0; i < tag.length; i++) {
            var check = tag[i],
              getSnapshot = check.getSnapshot;
            check = check.value;
            try {
              if (!objectIs(getSnapshot(), check)) return !1;
            } catch (error) {
              return !1;
            }
          }
        tag = node.child;
        if (node.subtreeFlags & 16384 && null !== tag)
          (tag.return = node), (node = tag);
        else {
          if (node === finishedWork) break;
          for (; null === node.sibling; ) {
            if (null === node.return || node.return === finishedWork) return !0;
            node = node.return;
          }
          node.sibling.return = node.return;
          node = node.sibling;
        }
      }
      return !0;
    }
    function markRootSuspended(
      root,
      suspendedLanes,
      spawnedLane,
      didAttemptEntireTree
    ) {
      suspendedLanes &= ~workInProgressRootPingedLanes;
      suspendedLanes &= ~workInProgressRootInterleavedUpdatedLanes;
      root.suspendedLanes |= suspendedLanes;
      root.pingedLanes &= ~suspendedLanes;
      didAttemptEntireTree && (root.warmLanes |= suspendedLanes);
      didAttemptEntireTree = root.expirationTimes;
      for (var lanes = suspendedLanes; 0 < lanes; ) {
        var index = 31 - clz32(lanes),
          lane = 1 << index;
        didAttemptEntireTree[index] = -1;
        lanes &= ~lane;
      }
      0 !== spawnedLane &&
        markSpawnedDeferredLane(root, spawnedLane, suspendedLanes);
    }
    function flushSyncWork$1() {
      return (executionContext & (RenderContext | CommitContext)) === NoContext
        ? (flushSyncWorkAcrossRoots_impl(0, !1), !1)
        : !0;
    }
    function resetWorkInProgressStack() {
      if (null !== workInProgress) {
        if (workInProgressSuspendedReason === NotSuspended)
          var interruptedWork = workInProgress.return;
        else
          (interruptedWork = workInProgress),
            resetContextDependencies(),
            resetHooksOnUnwind(interruptedWork),
            (thenableState$1 = null),
            (thenableIndexCounter$1 = 0),
            (interruptedWork = workInProgress);
        for (; null !== interruptedWork; )
          unwindInterruptedWork(interruptedWork.alternate, interruptedWork),
            (interruptedWork = interruptedWork.return);
        workInProgress = null;
      }
    }
    function finalizeRender(lanes, finalizationTime) {
      if (0 !== (lanes & 3) || 0 !== (lanes & 124))
        blockingClampTime = finalizationTime;
      0 !== (lanes & 4194048) && (transitionClampTime = finalizationTime);
    }
    function prepareFreshStack(root, lanes) {
      supportsUserTiming &&
        (console.timeStamp(
          "Blocking Track",
          0.003,
          0.003,
          "Blocking",
          LANES_TRACK_GROUP,
          "primary-light"
        ),
        console.timeStamp(
          "Transition Track",
          0.003,
          0.003,
          "Transition",
          LANES_TRACK_GROUP,
          "primary-light"
        ),
        console.timeStamp(
          "Suspense Track",
          0.003,
          0.003,
          "Suspense",
          LANES_TRACK_GROUP,
          "primary-light"
        ),
        console.timeStamp(
          "Idle Track",
          0.003,
          0.003,
          "Idle",
          LANES_TRACK_GROUP,
          "primary-light"
        ));
      var previousRenderStartTime = renderStartTime;
      renderStartTime = now();
      if (0 !== workInProgressRootRenderLanes && 0 < previousRenderStartTime) {
        setCurrentTrackFromLanes(workInProgressRootRenderLanes);
        if (
          workInProgressRootExitStatus === RootSuspended ||
          workInProgressRootExitStatus === RootSuspendedWithDelay
        )
          logSuspendedRenderPhase(
            previousRenderStartTime,
            renderStartTime,
            lanes
          );
        else {
          var endTime = renderStartTime;
          supportsUserTiming &&
            console.timeStamp(
              (lanes & 536870912) === lanes
                ? "Prewarm"
                : (lanes & 201326741) === lanes
                  ? "Interrupted Hydration"
                  : "Interrupted Render",
              previousRenderStartTime,
              endTime,
              currentTrack,
              LANES_TRACK_GROUP,
              (lanes & 738197653) === lanes ? "tertiary-dark" : "primary-dark"
            );
        }
        finalizeRender(workInProgressRootRenderLanes, renderStartTime);
      }
      if (0 !== (lanes & 3) || 0 !== (lanes & 124)) {
        previousRenderStartTime =
          0 <= blockingUpdateTime && blockingUpdateTime < blockingClampTime
            ? blockingClampTime
            : blockingUpdateTime;
        var clampedEventTime =
          0 <= blockingEventTime && blockingEventTime < blockingClampTime
            ? blockingClampTime
            : blockingEventTime;
        0 <= blockingSuspendedTime &&
          (setCurrentTrackFromLanes(lanes),
          logSuspendedWithDelayPhase(
            blockingSuspendedTime,
            0 <= clampedEventTime
              ? clampedEventTime
              : 0 <= previousRenderStartTime
                ? previousRenderStartTime
                : renderStartTime,
            lanes
          ));
        var eventType = blockingEventType,
          eventIsRepeat = blockingEventIsRepeat;
        endTime = blockingSpawnedUpdate;
        var renderStartTime$jscomp$0 = renderStartTime,
          debugTask = blockingUpdateTask;
        if (supportsUserTiming) {
          currentTrack = "Blocking";
          var eventEndTime =
            0 < previousRenderStartTime
              ? previousRenderStartTime
              : renderStartTime$jscomp$0;
          if (
            0 < clampedEventTime &&
            null !== eventType &&
            eventEndTime > clampedEventTime
          ) {
            var color = eventIsRepeat ? "secondary-light" : "warning";
            debugTask
              ? debugTask.run(
                  console.timeStamp.bind(
                    console,
                    eventIsRepeat ? "" : "Event: " + eventType,
                    clampedEventTime,
                    eventEndTime,
                    currentTrack,
                    LANES_TRACK_GROUP,
                    color
                  )
                )
              : console.timeStamp(
                  eventIsRepeat ? "" : "Event: " + eventType,
                  clampedEventTime,
                  eventEndTime,
                  currentTrack,
                  LANES_TRACK_GROUP,
                  color
                );
          }
          0 < previousRenderStartTime &&
            renderStartTime$jscomp$0 > previousRenderStartTime &&
            ((clampedEventTime = endTime
              ? "error"
              : (lanes & 738197653) === lanes
                ? "tertiary-light"
                : "primary-light"),
            debugTask
              ? debugTask.run(
                  console.timeStamp.bind(
                    console,
                    endTime
                      ? "Cascading Update"
                      : 5 < renderStartTime$jscomp$0 - previousRenderStartTime
                        ? "Update Blocked"
                        : "Update",
                    previousRenderStartTime,
                    renderStartTime$jscomp$0,
                    currentTrack,
                    LANES_TRACK_GROUP,
                    clampedEventTime
                  )
                )
              : console.timeStamp(
                  endTime
                    ? "Cascading Update"
                    : 5 < renderStartTime$jscomp$0 - previousRenderStartTime
                      ? "Update Blocked"
                      : "Update",
                  previousRenderStartTime,
                  renderStartTime$jscomp$0,
                  currentTrack,
                  LANES_TRACK_GROUP,
                  clampedEventTime
                ));
        }
        blockingUpdateTime = -1.1;
        blockingUpdateTask = null;
        blockingSuspendedTime = -1.1;
        blockingEventIsRepeat = !0;
        blockingSpawnedUpdate = !1;
      }
      0 !== (lanes & 4194048) &&
        ((previousRenderStartTime =
          0 <= transitionStartTime && transitionStartTime < transitionClampTime
            ? transitionClampTime
            : transitionStartTime),
        (endTime =
          0 <= transitionUpdateTime &&
          transitionUpdateTime < transitionClampTime
            ? transitionClampTime
            : transitionUpdateTime),
        (clampedEventTime =
          0 <= transitionEventTime && transitionEventTime < transitionClampTime
            ? transitionClampTime
            : transitionEventTime),
        0 <= transitionSuspendedTime &&
          (setCurrentTrackFromLanes(lanes),
          logSuspendedWithDelayPhase(
            transitionSuspendedTime,
            0 <= clampedEventTime
              ? clampedEventTime
              : 0 <= endTime
                ? endTime
                : renderStartTime,
            lanes
          )),
        (eventType = transitionEventType),
        (eventIsRepeat = transitionEventIsRepeat),
        (renderStartTime$jscomp$0 = renderStartTime),
        (debugTask = transitionUpdateTask),
        supportsUserTiming &&
          ((currentTrack = "Transition"),
          (eventEndTime =
            0 < previousRenderStartTime
              ? previousRenderStartTime
              : 0 < endTime
                ? endTime
                : renderStartTime$jscomp$0),
          0 < clampedEventTime &&
            eventEndTime > clampedEventTime &&
            null !== eventType &&
            ((color = eventIsRepeat ? "secondary-light" : "warning"),
            debugTask
              ? debugTask.run(
                  console.timeStamp.bind(
                    console,
                    eventIsRepeat ? "" : "Event: " + eventType,
                    clampedEventTime,
                    eventEndTime,
                    currentTrack,
                    LANES_TRACK_GROUP,
                    color
                  )
                )
              : console.timeStamp(
                  eventIsRepeat ? "" : "Event: " + eventType,
                  clampedEventTime,
                  eventEndTime,
                  currentTrack,
                  LANES_TRACK_GROUP,
                  color
                )),
          (clampedEventTime = 0 < endTime ? endTime : renderStartTime$jscomp$0),
          0 < previousRenderStartTime &&
            clampedEventTime > previousRenderStartTime &&
            (debugTask
              ? debugTask.run(
                  console.timeStamp.bind(
                    console,
                    "Action",
                    previousRenderStartTime,
                    clampedEventTime,
                    currentTrack,
                    LANES_TRACK_GROUP,
                    "primary-dark"
                  )
                )
              : console.timeStamp(
                  "Action",
                  previousRenderStartTime,
                  clampedEventTime,
                  currentTrack,
                  LANES_TRACK_GROUP,
                  "primary-dark"
                )),
          0 < endTime &&
            renderStartTime$jscomp$0 > endTime &&
            (debugTask
              ? debugTask.run(
                  console.timeStamp.bind(
                    console,
                    5 < renderStartTime$jscomp$0 - endTime
                      ? "Update Blocked"
                      : "Update",
                    endTime,
                    renderStartTime$jscomp$0,
                    currentTrack,
                    LANES_TRACK_GROUP,
                    "primary-light"
                  )
                )
              : console.timeStamp(
                  5 < renderStartTime$jscomp$0 - endTime
                    ? "Update Blocked"
                    : "Update",
                  endTime,
                  renderStartTime$jscomp$0,
                  currentTrack,
                  LANES_TRACK_GROUP,
                  "primary-light"
                ))),
        (transitionUpdateTime = transitionStartTime = -1.1),
        (transitionUpdateTask = null),
        (transitionSuspendedTime = -1.1),
        (transitionEventIsRepeat = !0));
      previousRenderStartTime = root.timeoutHandle;
      previousRenderStartTime !== noTimeout &&
        ((root.timeoutHandle = noTimeout),
        cancelTimeout(previousRenderStartTime));
      previousRenderStartTime = root.cancelPendingCommit;
      null !== previousRenderStartTime &&
        ((root.cancelPendingCommit = null), previousRenderStartTime());
      resetWorkInProgressStack();
      workInProgressRoot = root;
      workInProgress = previousRenderStartTime = createWorkInProgress(
        root.current,
        null
      );
      workInProgressRootRenderLanes = lanes;
      workInProgressSuspendedReason = NotSuspended;
      workInProgressThrownValue = null;
      workInProgressRootDidSkipSuspendedSiblings = !1;
      workInProgressRootIsPrerendering = checkIfRootIsPrerendering(root, lanes);
      workInProgressRootDidAttachPingListener = !1;
      workInProgressRootExitStatus = RootInProgress;
      workInProgressSuspendedRetryLanes =
        workInProgressDeferredLane =
        workInProgressRootPingedLanes =
        workInProgressRootInterleavedUpdatedLanes =
        workInProgressRootSkippedLanes =
          0;
      workInProgressRootRecoverableErrors = workInProgressRootConcurrentErrors =
        null;
      workInProgressRootDidIncludeRecursiveRenderUpdate = !1;
      0 !== (lanes & 8) && (lanes |= lanes & 32);
      endTime = root.entangledLanes;
      if (0 !== endTime)
        for (root = root.entanglements, endTime &= lanes; 0 < endTime; )
          (renderStartTime$jscomp$0 = 31 - clz32(endTime)),
            (debugTask = 1 << renderStartTime$jscomp$0),
            (lanes |= root[renderStartTime$jscomp$0]),
            (endTime &= ~debugTask);
      entangledRenderLanes = lanes;
      finishQueueingConcurrentUpdates();
      root = getCurrentTime();
      1e3 < root - lastResetTime &&
        ((ReactSharedInternals.recentlyCreatedOwnerStacks = 0),
        (lastResetTime = root));
      ReactStrictModeWarnings.discardPendingWarnings();
      return previousRenderStartTime;
    }
    function handleThrow(root, thrownValue) {
      currentlyRenderingFiber = null;
      ReactSharedInternals.H = ContextOnlyDispatcher;
      ReactSharedInternals.getCurrentStack = null;
      isRendering = !1;
      current = null;
      thrownValue === SuspenseException ||
      thrownValue === SuspenseActionException
        ? ((thrownValue = getSuspendedThenable()),
          (workInProgressSuspendedReason = SuspendedOnImmediate))
        : thrownValue === SuspenseyCommitException
          ? ((thrownValue = getSuspendedThenable()),
            (workInProgressSuspendedReason = SuspendedOnInstance))
          : (workInProgressSuspendedReason =
              thrownValue === SelectiveHydrationException
                ? SuspendedOnHydration
                : null !== thrownValue &&
                    "object" === typeof thrownValue &&
                    "function" === typeof thrownValue.then
                  ? SuspendedOnDeprecatedThrowPromise
                  : SuspendedOnError);
      workInProgressThrownValue = thrownValue;
      var erroredWork = workInProgress;
      null === erroredWork
        ? ((workInProgressRootExitStatus = RootFatalErrored),
          logUncaughtError(
            root,
            createCapturedValueAtFiber(thrownValue, root.current)
          ))
        : erroredWork.mode & ProfileMode &&
          stopProfilerTimerIfRunningAndRecordDuration(erroredWork);
    }
    function shouldRemainOnPreviousScreen() {
      var handler = suspenseHandlerStackCursor.current;
      return null === handler
        ? !0
        : (workInProgressRootRenderLanes & 4194048) ===
            workInProgressRootRenderLanes
          ? null === shellBoundary
            ? !0
            : !1
          : (workInProgressRootRenderLanes & 62914560) ===
                workInProgressRootRenderLanes ||
              0 !== (workInProgressRootRenderLanes & 536870912)
            ? handler === shellBoundary
            : !1;
    }
    function pushDispatcher() {
      var prevDispatcher = ReactSharedInternals.H;
      ReactSharedInternals.H = ContextOnlyDispatcher;
      return null === prevDispatcher ? ContextOnlyDispatcher : prevDispatcher;
    }
    function pushAsyncDispatcher() {
      var prevAsyncDispatcher = ReactSharedInternals.A;
      ReactSharedInternals.A = DefaultAsyncDispatcher;
      return prevAsyncDispatcher;
    }
    function renderDidSuspendDelayIfPossible() {
      workInProgressRootExitStatus = RootSuspendedWithDelay;
      workInProgressRootDidSkipSuspendedSiblings ||
        ((workInProgressRootRenderLanes & 4194048) !==
          workInProgressRootRenderLanes &&
          null !== suspenseHandlerStackCursor.current) ||
        (workInProgressRootIsPrerendering = !0);
      (0 === (workInProgressRootSkippedLanes & 134217727) &&
        0 === (workInProgressRootInterleavedUpdatedLanes & 134217727)) ||
        null === workInProgressRoot ||
        markRootSuspended(
          workInProgressRoot,
          workInProgressRootRenderLanes,
          workInProgressDeferredLane,
          !1
        );
    }
    function queueConcurrentError(error) {
      null === workInProgressRootConcurrentErrors
        ? (workInProgressRootConcurrentErrors = [error])
        : workInProgressRootConcurrentErrors.push(error);
    }
    function renderRootSync(root, lanes, shouldYieldForPrerendering) {
      var prevExecutionContext = executionContext;
      executionContext |= RenderContext;
      var prevDispatcher = pushDispatcher(),
        prevAsyncDispatcher = pushAsyncDispatcher();
      if (
        workInProgressRoot !== root ||
        workInProgressRootRenderLanes !== lanes
      ) {
        if (isDevToolsPresent) {
          var memoizedUpdaters = root.memoizedUpdaters;
          0 < memoizedUpdaters.size &&
            (restorePendingUpdaters(root, workInProgressRootRenderLanes),
            memoizedUpdaters.clear());
          movePendingFibersToMemoized(root, lanes);
        }
        workInProgressTransitions = null;
        prepareFreshStack(root, lanes);
      }
      lanes = !1;
      memoizedUpdaters = workInProgressRootExitStatus;
      a: do
        try {
          if (
            workInProgressSuspendedReason !== NotSuspended &&
            null !== workInProgress
          ) {
            var unitOfWork = workInProgress,
              thrownValue = workInProgressThrownValue;
            switch (workInProgressSuspendedReason) {
              case SuspendedOnHydration:
                resetWorkInProgressStack();
                memoizedUpdaters = RootSuspendedAtTheShell;
                break a;
              case SuspendedOnImmediate:
              case SuspendedOnData:
              case SuspendedOnAction:
              case SuspendedOnDeprecatedThrowPromise:
                null === suspenseHandlerStackCursor.current && (lanes = !0);
                var reason = workInProgressSuspendedReason;
                workInProgressSuspendedReason = NotSuspended;
                workInProgressThrownValue = null;
                throwAndUnwindWorkLoop(root, unitOfWork, thrownValue, reason);
                if (
                  shouldYieldForPrerendering &&
                  workInProgressRootIsPrerendering
                ) {
                  memoizedUpdaters = RootInProgress;
                  break a;
                }
                break;
              default:
                (reason = workInProgressSuspendedReason),
                  (workInProgressSuspendedReason = NotSuspended),
                  (workInProgressThrownValue = null),
                  throwAndUnwindWorkLoop(root, unitOfWork, thrownValue, reason);
            }
          }
          workLoopSync();
          memoizedUpdaters = workInProgressRootExitStatus;
          break;
        } catch (thrownValue$8) {
          handleThrow(root, thrownValue$8);
        }
      while (1);
      lanes && root.shellSuspendCounter++;
      resetContextDependencies();
      executionContext = prevExecutionContext;
      ReactSharedInternals.H = prevDispatcher;
      ReactSharedInternals.A = prevAsyncDispatcher;
      null === workInProgress &&
        ((workInProgressRoot = null),
        (workInProgressRootRenderLanes = 0),
        finishQueueingConcurrentUpdates());
      return memoizedUpdaters;
    }
    function workLoopSync() {
      for (; null !== workInProgress; ) performUnitOfWork(workInProgress);
    }
    function renderRootConcurrent(root, lanes) {
      var prevExecutionContext = executionContext;
      executionContext |= RenderContext;
      var prevDispatcher = pushDispatcher(),
        prevAsyncDispatcher = pushAsyncDispatcher();
      if (
        workInProgressRoot !== root ||
        workInProgressRootRenderLanes !== lanes
      ) {
        if (isDevToolsPresent) {
          var memoizedUpdaters = root.memoizedUpdaters;
          0 < memoizedUpdaters.size &&
            (restorePendingUpdaters(root, workInProgressRootRenderLanes),
            memoizedUpdaters.clear());
          movePendingFibersToMemoized(root, lanes);
        }
        workInProgressTransitions = null;
        workInProgressRootRenderTargetTime = now$1() + RENDER_TIMEOUT_MS;
        prepareFreshStack(root, lanes);
      } else
        workInProgressRootIsPrerendering = checkIfRootIsPrerendering(
          root,
          lanes
        );
      a: do
        try {
          if (
            workInProgressSuspendedReason !== NotSuspended &&
            null !== workInProgress
          )
            b: switch (
              ((lanes = workInProgress),
              (memoizedUpdaters = workInProgressThrownValue),
              workInProgressSuspendedReason)
            ) {
              case SuspendedOnError:
                workInProgressSuspendedReason = NotSuspended;
                workInProgressThrownValue = null;
                throwAndUnwindWorkLoop(
                  root,
                  lanes,
                  memoizedUpdaters,
                  SuspendedOnError
                );
                break;
              case SuspendedOnData:
              case SuspendedOnAction:
                if (isThenableResolved(memoizedUpdaters)) {
                  workInProgressSuspendedReason = NotSuspended;
                  workInProgressThrownValue = null;
                  replaySuspendedUnitOfWork(lanes);
                  break;
                }
                lanes = function () {
                  (workInProgressSuspendedReason !== SuspendedOnData &&
                    workInProgressSuspendedReason !== SuspendedOnAction) ||
                    workInProgressRoot !== root ||
                    (workInProgressSuspendedReason =
                      SuspendedAndReadyToContinue);
                  ensureRootIsScheduled(root);
                };
                memoizedUpdaters.then(lanes, lanes);
                break a;
              case SuspendedOnImmediate:
                workInProgressSuspendedReason = SuspendedAndReadyToContinue;
                break a;
              case SuspendedOnInstance:
                workInProgressSuspendedReason =
                  SuspendedOnInstanceAndReadyToContinue;
                break a;
              case SuspendedAndReadyToContinue:
                isThenableResolved(memoizedUpdaters)
                  ? ((workInProgressSuspendedReason = NotSuspended),
                    (workInProgressThrownValue = null),
                    replaySuspendedUnitOfWork(lanes))
                  : ((workInProgressSuspendedReason = NotSuspended),
                    (workInProgressThrownValue = null),
                    throwAndUnwindWorkLoop(
                      root,
                      lanes,
                      memoizedUpdaters,
                      SuspendedAndReadyToContinue
                    ));
                break;
              case SuspendedOnInstanceAndReadyToContinue:
                var resource = null;
                switch (workInProgress.tag) {
                  case 26:
                    resource = workInProgress.memoizedState;
                  case 5:
                  case 27:
                    var hostFiber = workInProgress;
                    if (
                      resource
                        ? preloadResource(resource)
                        : hostFiber.stateNode.complete
                    ) {
                      workInProgressSuspendedReason = NotSuspended;
                      workInProgressThrownValue = null;
                      var sibling = hostFiber.sibling;
                      if (null !== sibling) workInProgress = sibling;
                      else {
                        var returnFiber = hostFiber.return;
                        null !== returnFiber
                          ? ((workInProgress = returnFiber),
                            completeUnitOfWork(returnFiber))
                          : (workInProgress = null);
                      }
                      break b;
                    }
                    break;
                  default:
                    console.error(
                      "Unexpected type of fiber triggered a suspensey commit. This is a bug in React."
                    );
                }
                workInProgressSuspendedReason = NotSuspended;
                workInProgressThrownValue = null;
                throwAndUnwindWorkLoop(
                  root,
                  lanes,
                  memoizedUpdaters,
                  SuspendedOnInstanceAndReadyToContinue
                );
                break;
              case SuspendedOnDeprecatedThrowPromise:
                workInProgressSuspendedReason = NotSuspended;
                workInProgressThrownValue = null;
                throwAndUnwindWorkLoop(
                  root,
                  lanes,
                  memoizedUpdaters,
                  SuspendedOnDeprecatedThrowPromise
                );
                break;
              case SuspendedOnHydration:
                resetWorkInProgressStack();
                workInProgressRootExitStatus = RootSuspendedAtTheShell;
                break a;
              default:
                throw Error(
                  "Unexpected SuspendedReason. This is a bug in React."
                );
            }
          null !== ReactSharedInternals.actQueue
            ? workLoopSync()
            : workLoopConcurrentByScheduler();
          break;
        } catch (thrownValue$9) {
          handleThrow(root, thrownValue$9);
        }
      while (1);
      resetContextDependencies();
      ReactSharedInternals.H = prevDispatcher;
      ReactSharedInternals.A = prevAsyncDispatcher;
      executionContext = prevExecutionContext;
      if (null !== workInProgress) return RootInProgress;
      workInProgressRoot = null;
      workInProgressRootRenderLanes = 0;
      finishQueueingConcurrentUpdates();
      return workInProgressRootExitStatus;
    }
    function workLoopConcurrentByScheduler() {
      for (; null !== workInProgress && !shouldYield(); )
        performUnitOfWork(workInProgress);
    }
    function performUnitOfWork(unitOfWork) {
      var current = unitOfWork.alternate;
      (unitOfWork.mode & ProfileMode) !== NoMode
        ? (startProfilerTimer(unitOfWork),
          (current = runWithFiberInDEV(
            unitOfWork,
            beginWork,
            current,
            unitOfWork,
            entangledRenderLanes
          )),
          stopProfilerTimerIfRunningAndRecordDuration(unitOfWork))
        : (current = runWithFiberInDEV(
            unitOfWork,
            beginWork,
            current,
            unitOfWork,
            entangledRenderLanes
          ));
      unitOfWork.memoizedProps = unitOfWork.pendingProps;
      null === current
        ? completeUnitOfWork(unitOfWork)
        : (workInProgress = current);
    }
    function replaySuspendedUnitOfWork(unitOfWork) {
      var next = runWithFiberInDEV(unitOfWork, replayBeginWork, unitOfWork);
      unitOfWork.memoizedProps = unitOfWork.pendingProps;
      null === next ? completeUnitOfWork(unitOfWork) : (workInProgress = next);
    }
    function replayBeginWork(unitOfWork) {
      var current = unitOfWork.alternate,
        isProfilingMode = (unitOfWork.mode & ProfileMode) !== NoMode;
      isProfilingMode && startProfilerTimer(unitOfWork);
      switch (unitOfWork.tag) {
        case 15:
        case 0:
          current = replayFunctionComponent(
            current,
            unitOfWork,
            unitOfWork.pendingProps,
            unitOfWork.type,
            void 0,
            workInProgressRootRenderLanes
          );
          break;
        case 11:
          current = replayFunctionComponent(
            current,
            unitOfWork,
            unitOfWork.pendingProps,
            unitOfWork.type.render,
            unitOfWork.ref,
            workInProgressRootRenderLanes
          );
          break;
        case 5:
          resetHooksOnUnwind(unitOfWork);
        default:
          unwindInterruptedWork(current, unitOfWork),
            (unitOfWork = workInProgress =
              resetWorkInProgress(unitOfWork, entangledRenderLanes)),
            (current = beginWork(current, unitOfWork, entangledRenderLanes));
      }
      isProfilingMode &&
        stopProfilerTimerIfRunningAndRecordDuration(unitOfWork);
      return current;
    }
    function throwAndUnwindWorkLoop(
      root,
      unitOfWork,
      thrownValue,
      suspendedReason
    ) {
      resetContextDependencies();
      resetHooksOnUnwind(unitOfWork);
      thenableState$1 = null;
      thenableIndexCounter$1 = 0;
      var returnFiber = unitOfWork.return;
      try {
        if (
          throwException(
            root,
            returnFiber,
            unitOfWork,
            thrownValue,
            workInProgressRootRenderLanes
          )
        ) {
          workInProgressRootExitStatus = RootFatalErrored;
          logUncaughtError(
            root,
            createCapturedValueAtFiber(thrownValue, root.current)
          );
          workInProgress = null;
          return;
        }
      } catch (error) {
        if (null !== returnFiber) throw ((workInProgress = returnFiber), error);
        workInProgressRootExitStatus = RootFatalErrored;
        logUncaughtError(
          root,
          createCapturedValueAtFiber(thrownValue, root.current)
        );
        workInProgress = null;
        return;
      }
      if (unitOfWork.flags & 32768) {
        if (isHydrating || suspendedReason === SuspendedOnError) root = !0;
        else if (
          workInProgressRootIsPrerendering ||
          0 !== (workInProgressRootRenderLanes & 536870912)
        )
          root = !1;
        else if (
          ((workInProgressRootDidSkipSuspendedSiblings = root = !0),
          suspendedReason === SuspendedOnData ||
            suspendedReason === SuspendedOnAction ||
            suspendedReason === SuspendedOnImmediate ||
            suspendedReason === SuspendedOnDeprecatedThrowPromise)
        )
          (suspendedReason = suspenseHandlerStackCursor.current),
            null !== suspendedReason &&
              13 === suspendedReason.tag &&
              (suspendedReason.flags |= 16384);
        unwindUnitOfWork(unitOfWork, root);
      } else completeUnitOfWork(unitOfWork);
    }
    function completeUnitOfWork(unitOfWork) {
      var completedWork = unitOfWork;
      do {
        if (0 !== (completedWork.flags & 32768)) {
          unwindUnitOfWork(
            completedWork,
            workInProgressRootDidSkipSuspendedSiblings
          );
          return;
        }
        var current = completedWork.alternate;
        unitOfWork = completedWork.return;
        startProfilerTimer(completedWork);
        current = runWithFiberInDEV(
          completedWork,
          completeWork,
          current,
          completedWork,
          entangledRenderLanes
        );
        (completedWork.mode & ProfileMode) !== NoMode &&
          stopProfilerTimerIfRunningAndRecordIncompleteDuration(completedWork);
        if (null !== current) {
          workInProgress = current;
          return;
        }
        completedWork = completedWork.sibling;
        if (null !== completedWork) {
          workInProgress = completedWork;
          return;
        }
        workInProgress = completedWork = unitOfWork;
      } while (null !== completedWork);
      workInProgressRootExitStatus === RootInProgress &&
        (workInProgressRootExitStatus = RootCompleted);
    }
    function unwindUnitOfWork(unitOfWork, skipSiblings) {
      do {
        var next = unwindWork(unitOfWork.alternate, unitOfWork);
        if (null !== next) {
          next.flags &= 32767;
          workInProgress = next;
          return;
        }
        if ((unitOfWork.mode & ProfileMode) !== NoMode) {
          stopProfilerTimerIfRunningAndRecordIncompleteDuration(unitOfWork);
          next = unitOfWork.actualDuration;
          for (var child = unitOfWork.child; null !== child; )
            (next += child.actualDuration), (child = child.sibling);
          unitOfWork.actualDuration = next;
        }
        next = unitOfWork.return;
        null !== next &&
          ((next.flags |= 32768),
          (next.subtreeFlags = 0),
          (next.deletions = null));
        if (
          !skipSiblings &&
          ((unitOfWork = unitOfWork.sibling), null !== unitOfWork)
        ) {
          workInProgress = unitOfWork;
          return;
        }
        workInProgress = unitOfWork = next;
      } while (null !== unitOfWork);
      workInProgressRootExitStatus = RootSuspendedAtTheShell;
      workInProgress = null;
    }
    function commitRoot(
      root,
      finishedWork,
      lanes,
      recoverableErrors,
      transitions,
      didIncludeRenderPhaseUpdate,
      spawnedLane,
      updatedLanes,
      suspendedRetryLanes,
      exitStatus,
      suspendedCommitReason,
      completedRenderStartTime,
      completedRenderEndTime
    ) {
      root.cancelPendingCommit = null;
      do flushPendingEffects();
      while (pendingEffectsStatus !== NO_PENDING_EFFECTS);
      ReactStrictModeWarnings.flushLegacyContextWarning();
      ReactStrictModeWarnings.flushPendingUnsafeLifecycleWarnings();
      if ((executionContext & (RenderContext | CommitContext)) !== NoContext)
        throw Error("Should not already be working.");
      setCurrentTrackFromLanes(lanes);
      exitStatus === RootErrored
        ? logErroredRenderPhase(
            completedRenderStartTime,
            completedRenderEndTime
          )
        : null !== recoverableErrors
          ? logRecoveredRenderPhase(
              completedRenderStartTime,
              completedRenderEndTime,
              lanes,
              recoverableErrors,
              null !== finishedWork &&
                null !== finishedWork.alternate &&
                finishedWork.alternate.memoizedState.isDehydrated &&
                0 !== (finishedWork.flags & 256)
            )
          : supportsUserTiming &&
            console.timeStamp(
              (lanes & 536870912) === lanes
                ? "Prepared"
                : (lanes & 201326741) === lanes
                  ? "Hydrated"
                  : "Render",
              completedRenderStartTime,
              completedRenderEndTime,
              currentTrack,
              LANES_TRACK_GROUP,
              (lanes & 738197653) === lanes ? "tertiary-dark" : "primary-dark"
            );
      if (null === finishedWork)
        null !== root.stoppingGestures && stopCompletedGestures(root);
      else {
        0 === lanes &&
          console.error(
            "finishedLanes should not be empty during a commit. This is a bug in React."
          );
        if (finishedWork === root.current)
          throw Error(
            "Cannot commit the same tree as before. This error is likely caused by a bug in React. Please file an issue."
          );
        didIncludeRenderPhaseUpdate =
          finishedWork.lanes | finishedWork.childLanes;
        didIncludeRenderPhaseUpdate |= concurrentlyUpdatedLanes;
        null === root.pendingGestures && (didIncludeRenderPhaseUpdate &= -65);
        markRootFinished(
          root,
          lanes,
          didIncludeRenderPhaseUpdate,
          spawnedLane,
          updatedLanes,
          suspendedRetryLanes
        );
        root === workInProgressRoot &&
          ((workInProgress = workInProgressRoot = null),
          (workInProgressRootRenderLanes = 0));
        pendingFinishedWork = finishedWork;
        pendingEffectsRoot = root;
        pendingEffectsLanes = lanes;
        pendingEffectsRemainingLanes = didIncludeRenderPhaseUpdate;
        pendingPassiveTransitions = transitions;
        pendingRecoverableErrors = recoverableErrors;
        pendingEffectsRenderEndTime = completedRenderEndTime;
        pendingSuspendedCommitReason = suspendedCommitReason;
        if (64 === lanes) commitGestureOnRoot(root, finishedWork);
        else {
          pendingViewTransitionEvents = null;
          (lanes & 335544064) === lanes
            ? ((pendingTransitionTypes = claimQueuedTransitionTypes(root)),
              (recoverableErrors = 10262))
            : ((pendingTransitionTypes = null), (recoverableErrors = 10256));
          0 !== finishedWork.actualDuration ||
          0 !== (finishedWork.subtreeFlags & recoverableErrors) ||
          0 !== (finishedWork.flags & recoverableErrors)
            ? ((root.callbackNode = null),
              (root.callbackPriority = 0),
              scheduleCallback$1(NormalPriority$1, function () {
                schedulerEvent = window.event;
                flushPassiveEffects(!0);
                return null;
              }))
            : ((root.callbackNode = null), (root.callbackPriority = 0));
          commitErrors = null;
          commitStartTime = now();
          suspendedCommitReason === SUSPENDED_COMMIT
            ? supportsUserTiming &&
              console.timeStamp(
                "Suspended on CSS or Images",
                completedRenderEndTime,
                commitStartTime,
                currentTrack,
                LANES_TRACK_GROUP,
                "secondary-light"
              )
            : suspendedCommitReason === THROTTLED_COMMIT &&
              supportsUserTiming &&
              console.timeStamp(
                "Throttled",
                completedRenderEndTime,
                commitStartTime,
                currentTrack,
                LANES_TRACK_GROUP,
                "secondary-light"
              );
          shouldStartViewTransition = !1;
          suspendedCommitReason = 0 !== (finishedWork.flags & 13878);
          if (
            0 !== (finishedWork.subtreeFlags & 13878) ||
            suspendedCommitReason
          ) {
            suspendedCommitReason = ReactSharedInternals.T;
            ReactSharedInternals.T = null;
            completedRenderEndTime = ReactDOMSharedInternals.p;
            ReactDOMSharedInternals.p = DiscreteEventPriority;
            recoverableErrors = executionContext;
            executionContext |= CommitContext;
            try {
              commitBeforeMutationEffects(root, finishedWork, lanes);
            } finally {
              (executionContext = recoverableErrors),
                (ReactDOMSharedInternals.p = completedRenderEndTime),
                (ReactSharedInternals.T = suspendedCommitReason);
            }
          }
          finishedWork = shouldStartViewTransition;
          null !== root.stoppingGestures &&
            (stopCompletedGestures(root), (finishedWork = !1));
          pendingEffectsStatus = PENDING_MUTATION_PHASE;
          finishedWork
            ? (pendingViewTransition = startViewTransition(
                root.containerInfo,
                pendingTransitionTypes,
                flushMutationEffects,
                flushLayoutEffects,
                flushAfterMutationEffects,
                flushSpawnedWork,
                flushPassiveEffects,
                reportViewTransitionError
              ))
            : (flushMutationEffects(),
              flushLayoutEffects(),
              flushSpawnedWork());
        }
      }
    }
    function reportViewTransitionError(error) {
      if (pendingEffectsStatus !== NO_PENDING_EFFECTS) {
        var onRecoverableError = pendingEffectsRoot.onRecoverableError;
        onRecoverableError(error, makeErrorInfo(null));
      }
    }
    function flushAfterMutationEffects() {
      pendingEffectsStatus === PENDING_AFTER_MUTATION_PHASE &&
        ((pendingEffectsStatus = NO_PENDING_EFFECTS),
        commitAfterMutationEffectsOnFiber(
          pendingFinishedWork,
          pendingEffectsRoot
        ),
        (pendingEffectsStatus = PENDING_SPAWNED_WORK));
    }
    function flushMutationEffects() {
      if (pendingEffectsStatus === PENDING_MUTATION_PHASE) {
        pendingEffectsStatus = NO_PENDING_EFFECTS;
        var root = pendingEffectsRoot,
          finishedWork = pendingFinishedWork,
          lanes = pendingEffectsLanes,
          rootMutationHasEffect = 0 !== (finishedWork.flags & 13878);
        if (
          0 !== (finishedWork.subtreeFlags & 13878) ||
          rootMutationHasEffect
        ) {
          rootMutationHasEffect = ReactSharedInternals.T;
          ReactSharedInternals.T = null;
          var previousPriority = ReactDOMSharedInternals.p;
          ReactDOMSharedInternals.p = DiscreteEventPriority;
          var prevExecutionContext = executionContext;
          executionContext |= CommitContext;
          try {
            inProgressLanes = lanes;
            inProgressRoot = root;
            inUpdateViewTransition = rootViewTransitionAffected = !1;
            resetComponentEffectTimers();
            commitMutationEffectsOnFiber(finishedWork, root, lanes);
            inProgressRoot = inProgressLanes = null;
            lanes = selectionInformation;
            var curFocusedElem = getActiveElementDeep(root.containerInfo),
              priorFocusedElem = lanes.focusedElem,
              priorSelectionRange = lanes.selectionRange;
            if (
              curFocusedElem !== priorFocusedElem &&
              priorFocusedElem &&
              priorFocusedElem.ownerDocument &&
              containsNode(
                priorFocusedElem.ownerDocument.documentElement,
                priorFocusedElem
              )
            ) {
              if (
                null !== priorSelectionRange &&
                hasSelectionCapabilities(priorFocusedElem)
              ) {
                var start = priorSelectionRange.start,
                  end = priorSelectionRange.end;
                void 0 === end && (end = start);
                if ("selectionStart" in priorFocusedElem)
                  (priorFocusedElem.selectionStart = start),
                    (priorFocusedElem.selectionEnd = Math.min(
                      end,
                      priorFocusedElem.value.length
                    ));
                else {
                  var doc = priorFocusedElem.ownerDocument || document,
                    win = (doc && doc.defaultView) || window;
                  if (win.getSelection) {
                    var selection = win.getSelection(),
                      length = priorFocusedElem.textContent.length,
                      start$jscomp$0 = Math.min(
                        priorSelectionRange.start,
                        length
                      ),
                      end$jscomp$0 =
                        void 0 === priorSelectionRange.end
                          ? start$jscomp$0
                          : Math.min(priorSelectionRange.end, length);
                    !selection.extend &&
                      start$jscomp$0 > end$jscomp$0 &&
                      ((curFocusedElem = end$jscomp$0),
                      (end$jscomp$0 = start$jscomp$0),
                      (start$jscomp$0 = curFocusedElem));
                    var startMarker = getNodeForCharacterOffset(
                        priorFocusedElem,
                        start$jscomp$0
                      ),
                      endMarker = getNodeForCharacterOffset(
                        priorFocusedElem,
                        end$jscomp$0
                      );
                    if (
                      startMarker &&
                      endMarker &&
                      (1 !== selection.rangeCount ||
                        selection.anchorNode !== startMarker.node ||
                        selection.anchorOffset !== startMarker.offset ||
                        selection.focusNode !== endMarker.node ||
                        selection.focusOffset !== endMarker.offset)
                    ) {
                      var range = doc.createRange();
                      range.setStart(startMarker.node, startMarker.offset);
                      selection.removeAllRanges();
                      start$jscomp$0 > end$jscomp$0
                        ? (selection.addRange(range),
                          selection.extend(endMarker.node, endMarker.offset))
                        : (range.setEnd(endMarker.node, endMarker.offset),
                          selection.addRange(range));
                    }
                  }
                }
              }
              doc = [];
              for (
                selection = priorFocusedElem;
                (selection = selection.parentNode);

              )
                1 === selection.nodeType &&
                  doc.push({
                    element: selection,
                    left: selection.scrollLeft,
                    top: selection.scrollTop
                  });
              "function" === typeof priorFocusedElem.focus &&
                priorFocusedElem.focus();
              for (
                priorFocusedElem = 0;
                priorFocusedElem < doc.length;
                priorFocusedElem++
              ) {
                var info = doc[priorFocusedElem];
                info.element.scrollLeft = info.left;
                info.element.scrollTop = info.top;
              }
            }
            _enabled = !!eventsEnabled;
            selectionInformation = eventsEnabled = null;
          } finally {
            (executionContext = prevExecutionContext),
              (ReactDOMSharedInternals.p = previousPriority),
              (ReactSharedInternals.T = rootMutationHasEffect);
          }
        }
        root.current = finishedWork;
        pendingEffectsStatus = PENDING_LAYOUT_PHASE;
      }
    }
    function flushLayoutEffects() {
      if (pendingEffectsStatus === PENDING_LAYOUT_PHASE) {
        pendingEffectsStatus = NO_PENDING_EFFECTS;
        var root = pendingEffectsRoot,
          finishedWork = pendingFinishedWork,
          lanes = pendingEffectsLanes,
          cleanUpIndicator = root.pendingIndicator;
        if (null !== cleanUpIndicator && 0 === root.indicatorLanes) {
          var prevTransition = ReactSharedInternals.T;
          ReactSharedInternals.T = null;
          var previousPriority = ReactDOMSharedInternals.p;
          ReactDOMSharedInternals.p = DiscreteEventPriority;
          var prevExecutionContext = executionContext;
          executionContext |= CommitContext;
          root.pendingIndicator = null;
          try {
            cleanUpIndicator();
          } catch (x) {
            reportGlobalError(x);
          } finally {
            (executionContext = prevExecutionContext),
              (ReactDOMSharedInternals.p = previousPriority),
              (ReactSharedInternals.T = prevTransition);
          }
        }
        cleanUpIndicator = 0 !== (finishedWork.flags & 8772);
        if (0 !== (finishedWork.subtreeFlags & 8772) || cleanUpIndicator) {
          cleanUpIndicator = ReactSharedInternals.T;
          ReactSharedInternals.T = null;
          prevTransition = ReactDOMSharedInternals.p;
          ReactDOMSharedInternals.p = DiscreteEventPriority;
          previousPriority = executionContext;
          executionContext |= CommitContext;
          try {
            (inProgressLanes = lanes),
              (inProgressRoot = root),
              resetComponentEffectTimers(),
              commitLayoutEffectOnFiber(
                root,
                finishedWork.alternate,
                finishedWork
              ),
              (inProgressRoot = inProgressLanes = null);
          } finally {
            (executionContext = previousPriority),
              (ReactDOMSharedInternals.p = prevTransition),
              (ReactSharedInternals.T = cleanUpIndicator);
          }
        }
        pendingEffectsStatus = PENDING_AFTER_MUTATION_PHASE;
      }
    }
    function flushSpawnedWork() {
      if (
        pendingEffectsStatus === PENDING_SPAWNED_WORK ||
        pendingEffectsStatus === PENDING_AFTER_MUTATION_PHASE
      ) {
        pendingEffectsStatus = NO_PENDING_EFFECTS;
        pendingViewTransition = null;
        requestPaint();
        var root = pendingEffectsRoot,
          finishedWork = pendingFinishedWork,
          lanes = pendingEffectsLanes,
          completedRenderEndTime = pendingEffectsRenderEndTime,
          recoverableErrors = pendingRecoverableErrors,
          suspendedCommitReason = pendingSuspendedCommitReason;
        commitEndTime = now();
        completedRenderEndTime =
          suspendedCommitReason === IMMEDIATE_COMMIT
            ? completedRenderEndTime
            : commitStartTime;
        suspendedCommitReason = commitEndTime;
        null !== commitErrors
          ? logCommitErrored(
              completedRenderEndTime,
              suspendedCommitReason,
              commitErrors,
              !1
            )
          : supportsUserTiming &&
            console.timeStamp(
              "Commit",
              completedRenderEndTime,
              suspendedCommitReason,
              currentTrack,
              LANES_TRACK_GROUP,
              "secondary-dark"
            );
        completedRenderEndTime = (lanes & 335544064) === lanes ? 10262 : 10256;
        (completedRenderEndTime =
          0 !== finishedWork.actualDuration ||
          0 !== (finishedWork.subtreeFlags & completedRenderEndTime) ||
          0 !== (finishedWork.flags & completedRenderEndTime))
          ? (pendingEffectsStatus = PENDING_PASSIVE_PHASE)
          : ((pendingEffectsStatus = NO_PENDING_EFFECTS),
            (pendingFinishedWork = pendingEffectsRoot = null),
            releaseRootPooledCache(root, root.pendingLanes),
            (nestedPassiveUpdateCount = 0),
            (rootWithPassiveNestedUpdates = null));
        suspendedCommitReason = root.pendingLanes;
        0 === suspendedCommitReason &&
          (legacyErrorBoundariesThatAlreadyFailed = null);
        completedRenderEndTime || commitDoubleInvokeEffectsInDEV(root);
        suspendedCommitReason = lanesToEventPriority(lanes);
        finishedWork = finishedWork.stateNode;
        if (
          injectedHook &&
          "function" === typeof injectedHook.onCommitFiberRoot
        )
          try {
            var didError = 128 === (finishedWork.current.flags & 128);
            switch (suspendedCommitReason) {
              case DiscreteEventPriority:
                var schedulerPriority = ImmediatePriority;
                break;
              case ContinuousEventPriority:
                schedulerPriority = UserBlockingPriority;
                break;
              case DefaultEventPriority:
                schedulerPriority = NormalPriority$1;
                break;
              case IdleEventPriority:
                schedulerPriority = IdlePriority;
                break;
              default:
                schedulerPriority = NormalPriority$1;
            }
            injectedHook.onCommitFiberRoot(
              rendererID,
              finishedWork,
              schedulerPriority,
              didError
            );
          } catch (err) {
            hasLoggedError ||
              ((hasLoggedError = !0),
              console.error(
                "React instrumentation encountered an error: %s",
                err
              ));
          }
        isDevToolsPresent && root.memoizedUpdaters.clear();
        onCommitRoot();
        if (null !== recoverableErrors) {
          didError = ReactSharedInternals.T;
          schedulerPriority = ReactDOMSharedInternals.p;
          ReactDOMSharedInternals.p = DiscreteEventPriority;
          ReactSharedInternals.T = null;
          try {
            var onRecoverableError = root.onRecoverableError;
            for (
              finishedWork = 0;
              finishedWork < recoverableErrors.length;
              finishedWork++
            ) {
              var recoverableError = recoverableErrors[finishedWork],
                errorInfo = makeErrorInfo(recoverableError.stack);
              runWithFiberInDEV(
                recoverableError.source,
                onRecoverableError,
                recoverableError.value,
                errorInfo
              );
            }
          } finally {
            (ReactSharedInternals.T = didError),
              (ReactDOMSharedInternals.p = schedulerPriority);
          }
        }
        recoverableErrors = pendingViewTransitionEvents;
        onRecoverableError = pendingTransitionTypes;
        pendingTransitionTypes = null;
        if (null !== recoverableErrors)
          for (
            pendingViewTransitionEvents = null,
              null === onRecoverableError && (onRecoverableError = []),
              recoverableError = 0;
            recoverableError < recoverableErrors.length;
            recoverableError++
          )
            (0, recoverableErrors[recoverableError])(onRecoverableError);
        0 !== (pendingEffectsLanes & 3) && flushPendingEffects();
        ensureRootIsScheduled(root);
        suspendedCommitReason = root.pendingLanes;
        0 !== (lanes & 4194090) && 0 !== (suspendedCommitReason & 42)
          ? ((nestedUpdateScheduled = !0),
            root === rootWithNestedUpdates
              ? nestedUpdateCount++
              : ((nestedUpdateCount = 0), (rootWithNestedUpdates = root)))
          : (nestedUpdateCount = 0);
        completedRenderEndTime || finalizeRender(lanes, commitEndTime);
        if (hasScheduledReplayAttempt) {
          hasScheduledReplayAttempt = !1;
          null !== queuedFocus &&
            attemptReplayContinuousQueuedEvent(queuedFocus) &&
            (queuedFocus = null);
          null !== queuedDrag &&
            attemptReplayContinuousQueuedEvent(queuedDrag) &&
            (queuedDrag = null);
          null !== queuedMouse &&
            attemptReplayContinuousQueuedEvent(queuedMouse) &&
            (queuedMouse = null);
          queuedPointers.forEach(attemptReplayContinuousQueuedEventInMap);
          queuedPointerCaptures.forEach(
            attemptReplayContinuousQueuedEventInMap
          );
          for (root = 0; root < queuedChangeEventTargets.length; root++)
            (lanes = queuedChangeEventTargets[root]),
              "INPUT" === lanes.nodeName
                ? "checkbox" === lanes.type || "radio" === lanes.type
                  ? (lanes.dispatchEvent(
                      new ("function" === typeof PointerEvent
                        ? PointerEvent
                        : Event)("click", { bubbles: !0 })
                    ),
                    lanes.dispatchEvent(new Event("input", { bubbles: !0 })))
                  : "function" === typeof InputEvent &&
                    lanes.dispatchEvent(
                      new InputEvent("input", { bubbles: !0 })
                    )
                : "TEXTAREA" === lanes.nodeName &&
                  "function" === typeof InputEvent &&
                  lanes.dispatchEvent(new InputEvent("input", { bubbles: !0 })),
              lanes.dispatchEvent(new Event("change", { bubbles: !0 }));
          queuedChangeEventTargets.length = 0;
        }
        flushSyncWorkAcrossRoots_impl(0, !1);
      }
    }
    function commitGestureOnRoot(root, finishedWork) {
      var finishedGesture = root.pendingGestures;
      if (null === finishedGesture) ensureRootIsScheduled(root);
      else {
        deleteScheduledGesture(root, finishedGesture);
        var prevTransition = ReactSharedInternals.T;
        ReactSharedInternals.T = null;
        var previousPriority = ReactDOMSharedInternals.p;
        ReactDOMSharedInternals.p = DiscreteEventPriority;
        var prevExecutionContext = executionContext;
        executionContext |= CommitContext;
        try {
          didWarnForRootClone ||
            ((didWarnForRootClone = !0),
            console.warn(
              "startGestureTransition() caused something to mutate or relayout the root. This currently requires a clone of the whole document. Make sure to add a <ViewTransition> directly around an absolutely positioned DOM node to minimize the impact of any changes caused by the Gesture Transition."
            ));
          var rootContainer = root.containerInfo,
            documentElement =
              9 === rootContainer.nodeType
                ? rootContainer.documentElement
                : rootContainer.ownerDocument.documentElement;
          null !== documentElement &&
            "" === documentElement.style.viewTransitionName &&
            (documentElement.style.viewTransitionName = "none");
          var containerInstance =
            9 === rootContainer.nodeType
              ? rootContainer.body
              : "HTML" === rootContainer.nodeName
                ? rootContainer.ownerDocument.body
                : rootContainer;
          var containerParent = containerInstance.parentNode;
          if (null === containerParent)
            throw Error(
              "Cannot use a startGestureTransition() on a detached root."
            );
          var clone = containerInstance.cloneNode(!1),
            computedStyle = getComputedStyle(containerInstance);
          if (
            "absolute" !== computedStyle.position &&
            "fixed" !== computedStyle.position
          ) {
            for (
              rootContainer = containerParent;
              null != rootContainer.parentNode &&
              9 !== rootContainer.parentNode.nodeType &&
              "static" === getComputedStyle(rootContainer).position;

            )
              rootContainer = rootContainer.parentNode;
            var positionedAncestorStyle = rootContainer.style,
              containerInstanceStyle = containerInstance.style,
              prevAncestorTranslate = positionedAncestorStyle.translate,
              prevAncestorScale = positionedAncestorStyle.scale,
              prevAncestorRotate = positionedAncestorStyle.rotate,
              prevAncestorTransform = positionedAncestorStyle.transform,
              prevTranslate = containerInstanceStyle.translate,
              prevScale = containerInstanceStyle.scale,
              prevRotate = containerInstanceStyle.rotate,
              prevTransform = containerInstanceStyle.transform;
            positionedAncestorStyle.translate = "none";
            positionedAncestorStyle.scale = "none";
            positionedAncestorStyle.rotate = "none";
            positionedAncestorStyle.transform = "none";
            containerInstanceStyle.translate = "none";
            containerInstanceStyle.scale = "none";
            containerInstanceStyle.rotate = "none";
            containerInstanceStyle.transform = "none";
            var ancestorRect = rootContainer.getBoundingClientRect(),
              rect = containerInstance.getBoundingClientRect(),
              cloneStyle = clone.style;
            cloneStyle.position = "absolute";
            cloneStyle.top = rect.top - ancestorRect.top + "px";
            cloneStyle.left = rect.left - ancestorRect.left + "px";
            cloneStyle.width = rect.width + "px";
            cloneStyle.height = rect.height + "px";
            cloneStyle.margin = "0px";
            cloneStyle.boxSizing = "border-box";
            positionedAncestorStyle.translate = prevAncestorTranslate;
            positionedAncestorStyle.scale = prevAncestorScale;
            positionedAncestorStyle.rotate = prevAncestorRotate;
            positionedAncestorStyle.transform = prevAncestorTransform;
            containerInstanceStyle.translate = prevTranslate;
            containerInstanceStyle.scale = prevScale;
            containerInstanceStyle.rotate = prevRotate;
            containerInstanceStyle.transform = prevTransform;
          }
          clone.style.viewTransitionName = "root";
          var transform = computedStyle.transform;
          "none" === transform && (transform = "");
          var scale = computedStyle.scale;
          if ("none" !== scale && "" !== scale) {
            var parts = scale.split(" ");
            transform =
              (3 === parts.length ? "scale3d" : "scale") +
              "(" +
              parts.join(", ") +
              ") " +
              transform;
          }
          var rotate = computedStyle.rotate;
          if ("none" !== rotate && "" !== rotate) {
            var _parts = rotate.split(" ");
            transform =
              1 === _parts.length
                ? "rotate(" + _parts[0] + ") " + transform
                : 2 === _parts.length
                  ? "rotate" +
                    _parts[0].toUpperCase() +
                    "(" +
                    _parts[1] +
                    ") " +
                    transform
                  : "rotate3d(" + _parts.join(", ") + ") " + transform;
          }
          var translate = computedStyle.translate;
          if ("none" !== translate && "" !== translate) {
            var _parts2 = translate.split(" ");
            transform =
              (3 === _parts2.length ? "translate3d" : "translate") +
              "(" +
              _parts2.join(", ") +
              ") " +
              transform;
          }
          var transform$jscomp$0 = transform;
          clone.style.translate = "none";
          clone.style.scale = "none";
          clone.style.rotate = "none";
          clone.style.transform =
            "translate(-20000px, -20000px) " + transform$jscomp$0;
          containerInstance.parentNode.insertBefore(
            clone,
            containerInstance.nextSibling
          );
          root.gestureClone = clone;
          recursivelyInsertClones(finishedWork, clone, null, CLONE_UPDATE);
        } finally {
          (executionContext = prevExecutionContext),
            (ReactDOMSharedInternals.p = previousPriority),
            (ReactSharedInternals.T = prevTransition);
        }
        pendingTransitionTypes = finishedGesture.types;
        pendingEffectsStatus = PENDING_GESTURE_MUTATION_PHASE;
        pendingViewTransition = finishedGesture.running =
          startGestureTransition(
            root.containerInfo,
            finishedGesture.provider,
            finishedGesture.rangeStart,
            finishedGesture.rangeEnd,
            pendingTransitionTypes,
            flushGestureMutations,
            flushGestureAnimations,
            reportViewTransitionError
          );
      }
    }
    function flushGestureMutations() {
      if (pendingEffectsStatus === PENDING_GESTURE_MUTATION_PHASE) {
        pendingEffectsStatus = NO_PENDING_EFFECTS;
        var root = pendingEffectsRoot,
          finishedWork = pendingFinishedWork,
          prevTransition = ReactSharedInternals.T;
        ReactSharedInternals.T = null;
        var previousPriority = ReactDOMSharedInternals.p;
        ReactDOMSharedInternals.p = DiscreteEventPriority;
        var prevExecutionContext = executionContext;
        executionContext |= CommitContext;
        try {
          viewTransitionContextChanged = !1;
          pushViewTransitionCancelableScope();
          recursivelyApplyViewTransitions(finishedWork);
          var rootClone = root.gestureClone;
          if (null !== rootClone) {
            root.gestureClone = null;
            var rootContainer = root.containerInfo;
            var containerInstance =
              9 === rootContainer.nodeType
                ? rootContainer.body
                : "HTML" === rootContainer.nodeName
                  ? rootContainer.ownerDocument.body
                  : rootContainer;
            var containerParent = containerInstance.parentNode;
            if (null === containerParent)
              throw Error(
                "Cannot use a startGestureTransition() on a detached root."
              );
            containerParent.removeChild(rootClone);
            containerInstance.style.viewTransitionName = "root";
          }
          if (!viewTransitionContextChanged) {
            finishedWork = viewTransitionCancelableChildren;
            if (null !== finishedWork)
              for (
                rootClone = 0;
                rootClone < finishedWork.length;
                rootClone += 3
              )
                cancelViewTransitionName(
                  finishedWork[rootClone],
                  finishedWork[rootClone + 1],
                  finishedWork[rootClone + 2]
                );
            restoreRootViewTransitionName(root.containerInfo);
            cancelRootViewTransitionName(root.containerInfo);
          }
          viewTransitionCancelableChildren = null;
        } finally {
          (executionContext = prevExecutionContext),
            (ReactDOMSharedInternals.p = previousPriority),
            (ReactSharedInternals.T = prevTransition);
        }
        pendingEffectsStatus = PENDING_GESTURE_ANIMATION_PHASE;
      }
    }
    function flushGestureAnimations() {
      flushGestureMutations();
      if (pendingEffectsStatus === PENDING_GESTURE_ANIMATION_PHASE) {
        pendingEffectsStatus = NO_PENDING_EFFECTS;
        var root = pendingEffectsRoot,
          finishedWork = pendingFinishedWork;
        pendingFinishedWork = pendingEffectsRoot = null;
        pendingEffectsLanes = 0;
        pendingViewTransition = null;
        var prevTransition = ReactSharedInternals.T;
        ReactSharedInternals.T = null;
        var previousPriority = ReactDOMSharedInternals.p;
        ReactDOMSharedInternals.p = DiscreteEventPriority;
        var prevExecutionContext = executionContext;
        executionContext |= CommitContext;
        try {
          restoreViewTransitionsOnFiber(finishedWork),
            restoreRootViewTransitionName(root.containerInfo);
        } finally {
          (executionContext = prevExecutionContext),
            (ReactDOMSharedInternals.p = previousPriority),
            (ReactSharedInternals.T = prevTransition);
        }
        ensureRootIsScheduled(root);
      }
    }
    function makeErrorInfo(componentStack) {
      componentStack = { componentStack: componentStack };
      Object.defineProperty(componentStack, "digest", {
        get: function () {
          console.error(
            'You are accessing "digest" from the errorInfo object passed to onRecoverableError. This property is no longer provided as part of errorInfo but can be accessed as a property of the Error instance itself.'
          );
        }
      });
      return componentStack;
    }
    function releaseRootPooledCache(root, remainingLanes) {
      0 === (root.pooledCacheLanes &= remainingLanes) &&
        ((remainingLanes = root.pooledCache),
        null != remainingLanes &&
          ((root.pooledCache = null), releaseCache(remainingLanes)));
    }
    function flushPendingEffects(wasDelayedCommit) {
      null !== pendingViewTransition &&
        (pendingViewTransition.skipTransition(),
        didWarnAboutInterruptedViewTransitions ||
          ((didWarnAboutInterruptedViewTransitions = !0),
          console.warn(
            "A flushSync update cancelled a View Transition because it was called while the View Transition was still preparing. To preserve the synchronous semantics, React had to skip the View Transition. If you can, try to avoid flushSync() in a scenario that's likely to interfere."
          )),
        (pendingViewTransition = null));
      flushGestureMutations();
      flushGestureAnimations();
      flushMutationEffects();
      flushLayoutEffects();
      flushSpawnedWork();
      return flushPassiveEffects(wasDelayedCommit);
    }
    function flushPassiveEffects(wasDelayedCommit) {
      if (pendingEffectsStatus !== PENDING_PASSIVE_PHASE) return !1;
      var root = pendingEffectsRoot,
        remainingLanes = pendingEffectsRemainingLanes;
      pendingEffectsRemainingLanes = 0;
      var renderPriority = lanesToEventPriority(pendingEffectsLanes),
        priority =
          0 === DefaultEventPriority || DefaultEventPriority > renderPriority
            ? DefaultEventPriority
            : renderPriority;
      renderPriority = ReactSharedInternals.T;
      var previousPriority = ReactDOMSharedInternals.p;
      try {
        ReactDOMSharedInternals.p = priority;
        ReactSharedInternals.T = null;
        var transitions = pendingPassiveTransitions;
        pendingPassiveTransitions = null;
        priority = pendingEffectsRoot;
        var lanes = pendingEffectsLanes;
        pendingEffectsStatus = NO_PENDING_EFFECTS;
        pendingFinishedWork = pendingEffectsRoot = null;
        pendingEffectsLanes = 0;
        if ((executionContext & (RenderContext | CommitContext)) !== NoContext)
          throw Error("Cannot flush passive effects while already rendering.");
        setCurrentTrackFromLanes(lanes);
        isFlushingPassiveEffects = !0;
        didScheduleUpdateDuringPassiveEffects = !1;
        var passiveEffectStartTime = 0;
        commitErrors = null;
        passiveEffectStartTime = now$1();
        supportsUserTiming &&
          console.timeStamp(
            wasDelayedCommit ? "Waiting for Paint" : "",
            commitEndTime,
            passiveEffectStartTime,
            currentTrack,
            LANES_TRACK_GROUP,
            "secondary-light"
          );
        wasDelayedCommit = executionContext;
        executionContext |= CommitContext;
        var finishedWork = priority.current;
        resetComponentEffectTimers();
        commitPassiveUnmountOnFiber(finishedWork);
        var finishedWork$jscomp$0 = priority.current;
        finishedWork = pendingEffectsRenderEndTime;
        resetComponentEffectTimers();
        commitPassiveMountOnFiber(
          priority,
          finishedWork$jscomp$0,
          lanes,
          transitions,
          finishedWork
        );
        commitDoubleInvokeEffectsInDEV(priority);
        executionContext = wasDelayedCommit;
        var passiveEffectsEndTime = now$1();
        finishedWork$jscomp$0 = passiveEffectStartTime;
        null !== commitErrors
          ? logCommitErrored(
              finishedWork$jscomp$0,
              passiveEffectsEndTime,
              commitErrors,
              !0
            )
          : supportsUserTiming &&
            console.timeStamp(
              "Remaining Effects",
              finishedWork$jscomp$0,
              passiveEffectsEndTime,
              currentTrack,
              LANES_TRACK_GROUP,
              "secondary-dark"
            );
        finalizeRender(lanes, passiveEffectsEndTime);
        flushSyncWorkAcrossRoots_impl(0, !1);
        didScheduleUpdateDuringPassiveEffects
          ? priority === rootWithPassiveNestedUpdates
            ? nestedPassiveUpdateCount++
            : ((nestedPassiveUpdateCount = 0),
              (rootWithPassiveNestedUpdates = priority))
          : (nestedPassiveUpdateCount = 0);
        didScheduleUpdateDuringPassiveEffects = isFlushingPassiveEffects = !1;
        if (
          injectedHook &&
          "function" === typeof injectedHook.onPostCommitFiberRoot
        )
          try {
            injectedHook.onPostCommitFiberRoot(rendererID, priority);
          } catch (err) {
            hasLoggedError ||
              ((hasLoggedError = !0),
              console.error(
                "React instrumentation encountered an error: %s",
                err
              ));
          }
        var stateNode = priority.current.stateNode;
        stateNode.effectDuration = 0;
        stateNode.passiveEffectDuration = 0;
        return !0;
      } finally {
        (ReactDOMSharedInternals.p = previousPriority),
          (ReactSharedInternals.T = renderPriority),
          releaseRootPooledCache(root, remainingLanes);
      }
    }
    function captureCommitPhaseErrorOnRoot(rootFiber, sourceFiber, error) {
      sourceFiber = createCapturedValueAtFiber(error, sourceFiber);
      recordEffectError(sourceFiber);
      sourceFiber = createRootErrorUpdate(rootFiber.stateNode, sourceFiber, 2);
      rootFiber = enqueueUpdate(rootFiber, sourceFiber, 2);
      null !== rootFiber &&
        (markRootUpdated$1(rootFiber, 2), ensureRootIsScheduled(rootFiber));
    }
    function captureCommitPhaseError(
      sourceFiber,
      nearestMountedAncestor,
      error
    ) {
      isRunningInsertionEffect = !1;
      if (3 === sourceFiber.tag)
        captureCommitPhaseErrorOnRoot(sourceFiber, sourceFiber, error);
      else {
        for (; null !== nearestMountedAncestor; ) {
          if (3 === nearestMountedAncestor.tag) {
            captureCommitPhaseErrorOnRoot(
              nearestMountedAncestor,
              sourceFiber,
              error
            );
            return;
          }
          if (1 === nearestMountedAncestor.tag) {
            var instance = nearestMountedAncestor.stateNode;
            if (
              "function" ===
                typeof nearestMountedAncestor.type.getDerivedStateFromError ||
              ("function" === typeof instance.componentDidCatch &&
                (null === legacyErrorBoundariesThatAlreadyFailed ||
                  !legacyErrorBoundariesThatAlreadyFailed.has(instance)))
            ) {
              sourceFiber = createCapturedValueAtFiber(error, sourceFiber);
              recordEffectError(sourceFiber);
              error = createClassErrorUpdate(2);
              instance = enqueueUpdate(nearestMountedAncestor, error, 2);
              null !== instance &&
                (initializeClassErrorUpdate(
                  error,
                  instance,
                  nearestMountedAncestor,
                  sourceFiber
                ),
                markRootUpdated$1(instance, 2),
                ensureRootIsScheduled(instance));
              return;
            }
          }
          nearestMountedAncestor = nearestMountedAncestor.return;
        }
        console.error(
          "Internal React error: Attempted to capture a commit phase error inside a detached tree. This indicates a bug in React. Potential causes include deleting the same fiber more than once, committing an already-finished tree, or an inconsistent return pointer.\n\nError message:\n\n%s",
          error
        );
      }
    }
    function attachPingListener(root, wakeable, lanes) {
      var pingCache = root.pingCache;
      if (null === pingCache) {
        pingCache = root.pingCache = new PossiblyWeakMap();
        var threadIDs = new Set();
        pingCache.set(wakeable, threadIDs);
      } else
        (threadIDs = pingCache.get(wakeable)),
          void 0 === threadIDs &&
            ((threadIDs = new Set()), pingCache.set(wakeable, threadIDs));
      threadIDs.has(lanes) ||
        ((workInProgressRootDidAttachPingListener = !0),
        threadIDs.add(lanes),
        (pingCache = pingSuspendedRoot.bind(null, root, wakeable, lanes)),
        isDevToolsPresent && restorePendingUpdaters(root, lanes),
        wakeable.then(pingCache, pingCache));
    }
    function pingSuspendedRoot(root, wakeable, pingedLanes) {
      var pingCache = root.pingCache;
      null !== pingCache && pingCache.delete(wakeable);
      root.pingedLanes |= root.suspendedLanes & pingedLanes;
      root.warmLanes &= ~pingedLanes;
      0 !== (pingedLanes & 3) || 0 !== (pingedLanes & 124)
        ? 0 > blockingUpdateTime &&
          (blockingClampTime = blockingUpdateTime = now())
        : 0 !== (pingedLanes & 4194048) &&
          0 > transitionUpdateTime &&
          (transitionClampTime = transitionUpdateTime = now());
      isConcurrentActEnvironment() &&
        null === ReactSharedInternals.actQueue &&
        console.error(
          "A suspended resource finished loading inside a test, but the event was not wrapped in act(...).\n\nWhen testing, code that resolves suspended data should be wrapped into act(...):\n\nact(() => {\n  /* finish loading suspended data */\n});\n/* assert on the output */\n\nThis ensures that you're testing the behavior the user would see in the browser. Learn more at https://react.dev/link/wrap-tests-with-act"
        );
      workInProgressRoot === root &&
        (workInProgressRootRenderLanes & pingedLanes) === pingedLanes &&
        (workInProgressRootExitStatus === RootSuspendedWithDelay ||
        (workInProgressRootExitStatus === RootSuspended &&
          (workInProgressRootRenderLanes & 62914560) ===
            workInProgressRootRenderLanes &&
          now$1() - globalMostRecentFallbackTime < FALLBACK_THROTTLE_MS)
          ? (executionContext & RenderContext) === NoContext &&
            prepareFreshStack(root, 0)
          : (workInProgressRootPingedLanes |= pingedLanes),
        workInProgressSuspendedRetryLanes === workInProgressRootRenderLanes &&
          (workInProgressSuspendedRetryLanes = 0));
      ensureRootIsScheduled(root);
    }
    function retryTimedOutBoundary(boundaryFiber, retryLane) {
      0 === retryLane && (retryLane = claimNextRetryLane());
      boundaryFiber = enqueueConcurrentRenderForLane(boundaryFiber, retryLane);
      null !== boundaryFiber &&
        (markRootUpdated$1(boundaryFiber, retryLane),
        ensureRootIsScheduled(boundaryFiber));
    }
    function retryDehydratedSuspenseBoundary(boundaryFiber) {
      var suspenseState = boundaryFiber.memoizedState,
        retryLane = 0;
      null !== suspenseState && (retryLane = suspenseState.retryLane);
      retryTimedOutBoundary(boundaryFiber, retryLane);
    }
    function resolveRetryWakeable(boundaryFiber, wakeable) {
      var retryLane = 0;
      switch (boundaryFiber.tag) {
        case 31:
        case 13:
          var retryCache = boundaryFiber.stateNode;
          var suspenseState = boundaryFiber.memoizedState;
          null !== suspenseState && (retryLane = suspenseState.retryLane);
          break;
        case 19:
          retryCache = boundaryFiber.stateNode;
          break;
        case 22:
          retryCache = boundaryFiber.stateNode._retryCache;
          break;
        default:
          throw Error(
            "Pinged unknown suspense boundary type. This is probably a bug in React."
          );
      }
      null !== retryCache && retryCache.delete(wakeable);
      retryTimedOutBoundary(boundaryFiber, retryLane);
    }
    function recursivelyTraverseAndDoubleInvokeEffectsInDEV(
      root$jscomp$0,
      parentFiber,
      isInStrictMode
    ) {
      if (0 !== (parentFiber.subtreeFlags & 67117056))
        for (parentFiber = parentFiber.child; null !== parentFiber; ) {
          var root = root$jscomp$0,
            fiber = parentFiber,
            isStrictModeFiber = fiber.type === REACT_STRICT_MODE_TYPE;
          isStrictModeFiber = isInStrictMode || isStrictModeFiber;
          22 !== fiber.tag
            ? fiber.flags & 67108864
              ? isStrictModeFiber &&
                runWithFiberInDEV(
                  fiber,
                  doubleInvokeEffectsOnFiber,
                  root,
                  fiber
                )
              : recursivelyTraverseAndDoubleInvokeEffectsInDEV(
                  root,
                  fiber,
                  isStrictModeFiber
                )
            : null === fiber.memoizedState &&
              (isStrictModeFiber && fiber.flags & 8192
                ? runWithFiberInDEV(
                    fiber,
                    doubleInvokeEffectsOnFiber,
                    root,
                    fiber
                  )
                : fiber.subtreeFlags & 67108864 &&
                  runWithFiberInDEV(
                    fiber,
                    recursivelyTraverseAndDoubleInvokeEffectsInDEV,
                    root,
                    fiber,
                    isStrictModeFiber
                  ));
          parentFiber = parentFiber.sibling;
        }
    }
    function doubleInvokeEffectsOnFiber(root, fiber) {
      setIsStrictModeForDevtools(!0);
      try {
        disappearLayoutEffects(fiber),
          disconnectPassiveEffect(fiber),
          reappearLayoutEffects(root, fiber.alternate, fiber, !1),
          reconnectPassiveEffects(root, fiber, 0, null, !1, 0);
      } finally {
        setIsStrictModeForDevtools(!1);
      }
    }
    function commitDoubleInvokeEffectsInDEV(root) {
      var doubleInvokeEffects = !0;
      root.current.mode & (StrictLegacyMode | StrictEffectsMode) ||
        (doubleInvokeEffects = !1);
      recursivelyTraverseAndDoubleInvokeEffectsInDEV(
        root,
        root.current,
        doubleInvokeEffects
      );
    }
    function warnAboutUpdateOnNotYetMountedFiberInDEV(fiber) {
      if ((executionContext & RenderContext) === NoContext) {
        var tag = fiber.tag;
        if (
          3 === tag ||
          1 === tag ||
          0 === tag ||
          11 === tag ||
          14 === tag ||
          15 === tag
        ) {
          tag = getComponentNameFromFiber(fiber) || "ReactComponent";
          if (null !== didWarnStateUpdateForNotYetMountedComponent) {
            if (didWarnStateUpdateForNotYetMountedComponent.has(tag)) return;
            didWarnStateUpdateForNotYetMountedComponent.add(tag);
          } else didWarnStateUpdateForNotYetMountedComponent = new Set([tag]);
          runWithFiberInDEV(fiber, function () {
            console.error(
              "Can't perform a React state update on a component that hasn't mounted yet. This indicates that you have a side-effect in your render function that asynchronously tries to update the component. Move this work to useEffect instead."
            );
          });
        }
      }
    }
    function restorePendingUpdaters(root, lanes) {
      isDevToolsPresent &&
        root.memoizedUpdaters.forEach(function (schedulingFiber) {
          addFiberToLanesMap(root, schedulingFiber, lanes);
        });
    }
    function scheduleCallback$1(priorityLevel, callback) {
      var actQueue = ReactSharedInternals.actQueue;
      return null !== actQueue
        ? (actQueue.push(callback), fakeActCallbackNode$1)
        : scheduleCallback$3(priorityLevel, callback);
    }
    function warnIfUpdatesNotWrappedWithActDEV(fiber) {
      isConcurrentActEnvironment() &&
        null === ReactSharedInternals.actQueue &&
        runWithFiberInDEV(fiber, function () {
          console.error(
            "An update to %s inside a test was not wrapped in act(...).\n\nWhen testing, code that causes React state updates should be wrapped into act(...):\n\nact(() => {\n  /* fire events that update state */\n});\n/* assert on the output */\n\nThis ensures that you're testing the behavior the user would see in the browser. Learn more at https://react.dev/link/wrap-tests-with-act",
            getComponentNameFromFiber(fiber)
          );
        });
    }
    function ensureRootIsScheduled(root) {
      root !== lastScheduledRoot &&
        null === root.next &&
        (null === lastScheduledRoot
          ? (firstScheduledRoot = lastScheduledRoot = root)
          : (lastScheduledRoot = lastScheduledRoot.next = root));
      mightHavePendingSyncWork = !0;
      ensureScheduleIsScheduled();
    }
    function ensureScheduleIsScheduled() {
      null !== ReactSharedInternals.actQueue
        ? didScheduleMicrotask_act ||
          ((didScheduleMicrotask_act = !0), scheduleImmediateRootScheduleTask())
        : didScheduleMicrotask ||
          ((didScheduleMicrotask = !0), scheduleImmediateRootScheduleTask());
    }
    function flushSyncWorkAcrossRoots_impl(syncTransitionLanes, onlyLegacy) {
      if (!isFlushingWork && mightHavePendingSyncWork) {
        isFlushingWork = !0;
        do {
          var didPerformSomeWork = !1;
          for (var root = firstScheduledRoot; null !== root; ) {
            if (!onlyLegacy)
              if (0 !== syncTransitionLanes) {
                var pendingLanes = root.pendingLanes;
                if (0 === pendingLanes) var nextLanes = 0;
                else {
                  var suspendedLanes = root.suspendedLanes,
                    pingedLanes = root.pingedLanes;
                  nextLanes =
                    (1 << (31 - clz32(42 | syncTransitionLanes) + 1)) - 1;
                  nextLanes &= pendingLanes & ~(suspendedLanes & ~pingedLanes);
                  nextLanes =
                    nextLanes & 201326741
                      ? (nextLanes & 201326741) | 1
                      : nextLanes
                        ? nextLanes | 2
                        : 0;
                }
                0 !== nextLanes &&
                  ((didPerformSomeWork = !0),
                  performSyncWorkOnRoot(root, nextLanes));
              } else
                (nextLanes = workInProgressRootRenderLanes),
                  (nextLanes = getNextLanes(
                    root,
                    root === workInProgressRoot ? nextLanes : 0,
                    null !== root.cancelPendingCommit ||
                      root.timeoutHandle !== noTimeout
                  )),
                  (0 === (nextLanes & 3) && 64 !== nextLanes) ||
                    checkIfRootIsPrerendering(root, nextLanes) ||
                    ((didPerformSomeWork = !0),
                    performSyncWorkOnRoot(root, nextLanes));
            root = root.next;
          }
        } while (didPerformSomeWork);
        isFlushingWork = !1;
      }
    }
    function processRootScheduleInImmediateTask() {
      schedulerEvent = window.event;
      processRootScheduleInMicrotask();
    }
    function processRootScheduleInMicrotask() {
      mightHavePendingSyncWork =
        didScheduleMicrotask_act =
        didScheduleMicrotask =
          !1;
      var syncTransitionLanes = 0;
      0 !== currentEventTransitionLane &&
        (syncTransitionLanes = shouldAttemptEagerTransition()
          ? currentEventTransitionLane
          : 32);
      for (
        var currentTime = now$1(), prev = null, root = firstScheduledRoot;
        null !== root;

      ) {
        var next = root.next,
          nextLanes = scheduleTaskForRootDuringMicrotask(root, currentTime);
        if (0 === nextLanes)
          (root.next = null),
            null === prev ? (firstScheduledRoot = next) : (prev.next = next),
            null === next && (lastScheduledRoot = prev);
        else if (
          ((prev = root),
          0 !== syncTransitionLanes ||
            0 !== (nextLanes & 3) ||
            64 === nextLanes)
        )
          mightHavePendingSyncWork = !0;
        root = next;
      }
      (pendingEffectsStatus !== NO_PENDING_EFFECTS &&
        pendingEffectsStatus !== PENDING_PASSIVE_PHASE) ||
        flushSyncWorkAcrossRoots_impl(syncTransitionLanes, !1);
      if (0 !== currentEventTransitionLane) {
        currentEventTransitionLane = 0;
        if (
          needsIsomorphicIndicator &&
          null != isomorphicDefaultTransitionIndicator &&
          null === pendingIsomorphicIndicator
        )
          try {
            pendingIsomorphicIndicator =
              isomorphicDefaultTransitionIndicator() || noop$1;
          } catch (x) {
            (pendingIsomorphicIndicator = noop$1), reportGlobalError(x);
          }
        for (
          syncTransitionLanes = firstScheduledRoot;
          null !== syncTransitionLanes;

        ) {
          if (
            0 !== syncTransitionLanes.indicatorLanes &&
            null === syncTransitionLanes.pendingIndicator
          )
            if (null !== pendingIsomorphicIndicator)
              (currentTime = syncTransitionLanes),
                pendingEntangledRoots++,
                (currentTime.pendingIndicator = releaseIsomorphicIndicator);
            else
              try {
                var onDefaultTransitionIndicator =
                  syncTransitionLanes.onDefaultTransitionIndicator;
                syncTransitionLanes.pendingIndicator =
                  onDefaultTransitionIndicator() || noop$1;
              } catch (x) {
                (syncTransitionLanes.pendingIndicator = noop$1),
                  reportGlobalError(x);
              }
          syncTransitionLanes = syncTransitionLanes.next;
        }
      }
    }
    function scheduleTaskForRootDuringMicrotask(root, currentTime) {
      for (
        var suspendedLanes = root.suspendedLanes,
          pingedLanes = root.pingedLanes,
          expirationTimes = root.expirationTimes,
          lanes = root.pendingLanes & -62914561;
        0 < lanes;

      ) {
        var index = 31 - clz32(lanes),
          lane = 1 << index,
          expirationTime = expirationTimes[index];
        if (-1 === expirationTime) {
          if (0 === (lane & suspendedLanes) || 0 !== (lane & pingedLanes))
            expirationTimes[index] = computeExpirationTime(lane, currentTime);
        } else expirationTime <= currentTime && (root.expiredLanes |= lane);
        lanes &= ~lane;
      }
      currentTime = workInProgressRoot;
      suspendedLanes = workInProgressRootRenderLanes;
      suspendedLanes = getNextLanes(
        root,
        root === currentTime ? suspendedLanes : 0,
        null !== root.cancelPendingCommit || root.timeoutHandle !== noTimeout
      );
      pingedLanes = root.callbackNode;
      if (
        0 === suspendedLanes ||
        (root === currentTime &&
          (workInProgressSuspendedReason === SuspendedOnData ||
            workInProgressSuspendedReason === SuspendedOnAction)) ||
        null !== root.cancelPendingCommit
      )
        return (
          null !== pingedLanes && cancelCallback(pingedLanes),
          (root.callbackNode = null),
          (root.callbackPriority = 0)
        );
      if (
        0 !== (suspendedLanes & 3) &&
        !checkIfRootIsPrerendering(root, suspendedLanes)
      )
        return (
          null !== pingedLanes && cancelCallback(pingedLanes),
          (root.callbackPriority = 2),
          (root.callbackNode = null),
          2
        );
      currentTime = suspendedLanes & -suspendedLanes;
      if (
        currentTime !== root.callbackPriority ||
        (null !== ReactSharedInternals.actQueue &&
          pingedLanes !== fakeActCallbackNode)
      )
        cancelCallback(pingedLanes);
      else return currentTime;
      switch (lanesToEventPriority(suspendedLanes)) {
        case DiscreteEventPriority:
        case ContinuousEventPriority:
          suspendedLanes = UserBlockingPriority;
          break;
        case DefaultEventPriority:
          suspendedLanes = NormalPriority$1;
          break;
        case IdleEventPriority:
          suspendedLanes = IdlePriority;
          break;
        default:
          suspendedLanes = NormalPriority$1;
      }
      pingedLanes = performWorkOnRootViaSchedulerTask.bind(null, root);
      null !== ReactSharedInternals.actQueue
        ? (ReactSharedInternals.actQueue.push(pingedLanes),
          (suspendedLanes = fakeActCallbackNode))
        : (suspendedLanes = scheduleCallback$3(suspendedLanes, pingedLanes));
      root.callbackPriority = currentTime;
      root.callbackNode = suspendedLanes;
      return currentTime;
    }
    function performWorkOnRootViaSchedulerTask(root, didTimeout) {
      nestedUpdateScheduled = currentUpdateIsNested = !1;
      schedulerEvent = window.event;
      if (
        pendingEffectsStatus !== NO_PENDING_EFFECTS &&
        pendingEffectsStatus !== PENDING_PASSIVE_PHASE
      )
        return (root.callbackNode = null), (root.callbackPriority = 0), null;
      var originalCallbackNode = root.callbackNode;
      if (flushPendingEffects(!0) && root.callbackNode !== originalCallbackNode)
        return null;
      var workInProgressRootRenderLanes$jscomp$0 =
        workInProgressRootRenderLanes;
      workInProgressRootRenderLanes$jscomp$0 = getNextLanes(
        root,
        root === workInProgressRoot
          ? workInProgressRootRenderLanes$jscomp$0
          : 0,
        null !== root.cancelPendingCommit || root.timeoutHandle !== noTimeout
      );
      if (0 === workInProgressRootRenderLanes$jscomp$0) return null;
      performWorkOnRoot(
        root,
        workInProgressRootRenderLanes$jscomp$0,
        didTimeout
      );
      scheduleTaskForRootDuringMicrotask(root, now$1());
      return null != root.callbackNode &&
        root.callbackNode === originalCallbackNode
        ? performWorkOnRootViaSchedulerTask.bind(null, root)
        : null;
    }
    function performSyncWorkOnRoot(root, lanes) {
      if (flushPendingEffects()) return null;
      currentUpdateIsNested = nestedUpdateScheduled;
      nestedUpdateScheduled = !1;
      performWorkOnRoot(root, lanes, !0);
    }
    function cancelCallback(callbackNode) {
      callbackNode !== fakeActCallbackNode &&
        null !== callbackNode &&
        cancelCallback$1(callbackNode);
    }
    function scheduleImmediateRootScheduleTask() {
      null !== ReactSharedInternals.actQueue &&
        ReactSharedInternals.actQueue.push(function () {
          processRootScheduleInMicrotask();
          return null;
        });
      scheduleMicrotask(function () {
        (executionContext & (RenderContext | CommitContext)) !== NoContext
          ? scheduleCallback$3(
              ImmediatePriority,
              processRootScheduleInImmediateTask
            )
          : processRootScheduleInMicrotask();
      });
    }
    function requestTransitionLane() {
      if (0 === currentEventTransitionLane) {
        var actionScopeLane = currentEntangledLane;
        currentEventTransitionLane =
          0 !== actionScopeLane ? actionScopeLane : claimNextTransitionLane();
      }
      return currentEventTransitionLane;
    }
    function coerceFormActionProp(actionProp) {
      if (
        null == actionProp ||
        "symbol" === typeof actionProp ||
        "boolean" === typeof actionProp
      )
        return null;
      if ("function" === typeof actionProp) return actionProp;
      checkAttributeStringCoercion(actionProp, "action");
      return sanitizeURL("" + actionProp);
    }
    function createFormDataWithSubmitter(form, submitter) {
      var temp = submitter.ownerDocument.createElement("input");
      temp.name = submitter.name;
      temp.value = submitter.value;
      form.id && temp.setAttribute("form", form.id);
      submitter.parentNode.insertBefore(temp, submitter);
      form = new FormData(form);
      temp.parentNode.removeChild(temp);
      return form;
    }
    function extractEvents$2(
      dispatchQueue,
      domEventName,
      maybeTargetInst,
      nativeEvent,
      nativeEventTarget
    ) {
      if (
        "submit" === domEventName &&
        maybeTargetInst &&
        maybeTargetInst.stateNode === nativeEventTarget
      ) {
        var action = coerceFormActionProp(
            (nativeEventTarget[internalPropsKey] || null).action
          ),
          submitter = nativeEvent.submitter;
        submitter &&
          ((domEventName = (domEventName = submitter[internalPropsKey] || null)
            ? coerceFormActionProp(domEventName.formAction)
            : submitter.getAttribute("formAction")),
          null !== domEventName &&
            ((action = domEventName), (submitter = null)));
        var event = new SyntheticEvent(
          "action",
          "action",
          null,
          nativeEvent,
          nativeEventTarget
        );
        dispatchQueue.push({
          event: event,
          listeners: [
            {
              instance: null,
              listener: function () {
                if (nativeEvent.defaultPrevented) {
                  if (0 !== currentEventTransitionLane) {
                    var formData = submitter
                        ? createFormDataWithSubmitter(
                            nativeEventTarget,
                            submitter
                          )
                        : new FormData(nativeEventTarget),
                      pendingState = {
                        pending: !0,
                        data: formData,
                        method: nativeEventTarget.method,
                        action: action
                      };
                    Object.freeze(pendingState);
                    startHostTransition(
                      maybeTargetInst,
                      pendingState,
                      null,
                      formData
                    );
                  }
                } else
                  "function" === typeof action &&
                    (event.preventDefault(),
                    (formData = submitter
                      ? createFormDataWithSubmitter(
                          nativeEventTarget,
                          submitter
                        )
                      : new FormData(nativeEventTarget)),
                    (pendingState = {
                      pending: !0,
                      data: formData,
                      method: nativeEventTarget.method,
                      action: action
                    }),
                    Object.freeze(pendingState),
                    startHostTransition(
                      maybeTargetInst,
                      pendingState,
                      action,
                      formData
                    ));
              },
              currentTarget: nativeEventTarget
            }
          ]
        });
      }
    }
    function runEventInBatch(dispatchQueue) {
      processDispatchQueue(dispatchQueue, 0);
    }
    function fireScrollEnd(targetInst, nativeEvent, nativeEventTarget) {
      nativeEventTarget[internalScrollTimer] = void 0;
      if (isMouseDown || isTouchStarted)
        debounceScrollEnd(targetInst, nativeEvent, nativeEventTarget);
      else {
        var dispatchQueue = [];
        targetInst = accumulateTwoPhaseListeners(targetInst, "onScrollEnd");
        0 < targetInst.length &&
          ((nativeEvent = new SyntheticUIEvent(
            "onScrollEnd",
            "scrollend",
            null,
            nativeEvent,
            nativeEventTarget
          )),
          dispatchQueue.push({ event: nativeEvent, listeners: targetInst }));
        batchedUpdates$2(runEventInBatch, dispatchQueue);
      }
    }
    function debounceScrollEnd(targetInst, nativeEvent, nativeEventTarget) {
      var existingTimer = nativeEventTarget[internalScrollTimer];
      null != existingTimer && clearTimeout(existingTimer);
      null !== targetInst &&
        ((targetInst = setTimeout(
          fireScrollEnd.bind(null, targetInst, nativeEvent, nativeEventTarget),
          DEBOUNCE_TIMEOUT
        )),
        (nativeEventTarget[internalScrollTimer] = targetInst));
    }
    function executeDispatch(event, listener, currentTarget) {
      event.currentTarget = currentTarget;
      try {
        listener(event);
      } catch (error) {
        reportGlobalError(error);
      }
      event.currentTarget = null;
    }
    function processDispatchQueue(dispatchQueue, eventSystemFlags) {
      eventSystemFlags = 0 !== (eventSystemFlags & 4);
      for (var i = 0; i < dispatchQueue.length; i++) {
        var _dispatchQueue$i = dispatchQueue[i];
        a: {
          var previousInstance = void 0,
            event = _dispatchQueue$i.event;
          _dispatchQueue$i = _dispatchQueue$i.listeners;
          if (eventSystemFlags)
            for (
              var i$jscomp$0 = _dispatchQueue$i.length - 1;
              0 <= i$jscomp$0;
              i$jscomp$0--
            ) {
              var _dispatchListeners$i = _dispatchQueue$i[i$jscomp$0],
                instance = _dispatchListeners$i.instance,
                currentTarget = _dispatchListeners$i.currentTarget;
              _dispatchListeners$i = _dispatchListeners$i.listener;
              if (instance !== previousInstance && event.isPropagationStopped())
                break a;
              null !== instance
                ? runWithFiberInDEV(
                    instance,
                    executeDispatch,
                    event,
                    _dispatchListeners$i,
                    currentTarget
                  )
                : executeDispatch(event, _dispatchListeners$i, currentTarget);
              previousInstance = instance;
            }
          else
            for (
              i$jscomp$0 = 0;
              i$jscomp$0 < _dispatchQueue$i.length;
              i$jscomp$0++
            ) {
              _dispatchListeners$i = _dispatchQueue$i[i$jscomp$0];
              instance = _dispatchListeners$i.instance;
              currentTarget = _dispatchListeners$i.currentTarget;
              _dispatchListeners$i = _dispatchListeners$i.listener;
              if (instance !== previousInstance && event.isPropagationStopped())
                break a;
              null !== instance
                ? runWithFiberInDEV(
                    instance,
                    executeDispatch,
                    event,
                    _dispatchListeners$i,
                    currentTarget
                  )
                : executeDispatch(event, _dispatchListeners$i, currentTarget);
              previousInstance = instance;
            }
        }
      }
    }
    function listenToNonDelegatedEvent(domEventName, targetElement) {
      nonDelegatedEvents.has(domEventName) ||
        console.error(
          'Did not expect a listenToNonDelegatedEvent() call for "%s". This is a bug in React. Please file an issue.',
          domEventName
        );
      var listenerSet = targetElement[internalEventHandlersKey];
      void 0 === listenerSet &&
        (listenerSet = targetElement[internalEventHandlersKey] = new Set());
      var listenerSetKey = domEventName + "__bubble";
      listenerSet.has(listenerSetKey) ||
        (addTrappedEventListener(targetElement, domEventName, 2, !1),
        listenerSet.add(listenerSetKey));
    }
    function listenToNativeEvent(domEventName, isCapturePhaseListener, target) {
      nonDelegatedEvents.has(domEventName) &&
        !isCapturePhaseListener &&
        console.error(
          'Did not expect a listenToNativeEvent() call for "%s" in the bubble phase. This is a bug in React. Please file an issue.',
          domEventName
        );
      var eventSystemFlags = 0;
      isCapturePhaseListener && (eventSystemFlags |= 4);
      addTrappedEventListener(
        target,
        domEventName,
        eventSystemFlags,
        isCapturePhaseListener
      );
    }
    function listenToAllSupportedEvents(rootContainerElement) {
      if (!rootContainerElement[listeningMarker]) {
        rootContainerElement[listeningMarker] = !0;
        allNativeEvents.forEach(function (domEventName) {
          "selectionchange" !== domEventName &&
            (nonDelegatedEvents.has(domEventName) ||
              listenToNativeEvent(domEventName, !1, rootContainerElement),
            listenToNativeEvent(domEventName, !0, rootContainerElement));
        });
        var ownerDocument =
          9 === rootContainerElement.nodeType
            ? rootContainerElement
            : rootContainerElement.ownerDocument;
        null === ownerDocument ||
          ownerDocument[listeningMarker] ||
          ((ownerDocument[listeningMarker] = !0),
          listenToNativeEvent("selectionchange", !1, ownerDocument));
      }
    }
    function addTrappedEventListener(
      targetContainer,
      domEventName,
      eventSystemFlags,
      isCapturePhaseListener
    ) {
      switch (getEventPriority(domEventName)) {
        case DiscreteEventPriority:
          var listenerWrapper = dispatchDiscreteEvent;
          break;
        case ContinuousEventPriority:
          listenerWrapper = dispatchContinuousEvent;
          break;
        default:
          listenerWrapper = dispatchEvent;
      }
      eventSystemFlags = listenerWrapper.bind(
        null,
        domEventName,
        eventSystemFlags,
        targetContainer
      );
      listenerWrapper = void 0;
      !passiveBrowserEventsSupported ||
        ("touchstart" !== domEventName &&
          "touchmove" !== domEventName &&
          "wheel" !== domEventName) ||
        (listenerWrapper = !0);
      isCapturePhaseListener
        ? void 0 !== listenerWrapper
          ? targetContainer.addEventListener(domEventName, eventSystemFlags, {
              capture: !0,
              passive: listenerWrapper
            })
          : targetContainer.addEventListener(domEventName, eventSystemFlags, !0)
        : void 0 !== listenerWrapper
          ? targetContainer.addEventListener(domEventName, eventSystemFlags, {
              passive: listenerWrapper
            })
          : targetContainer.addEventListener(
              domEventName,
              eventSystemFlags,
              !1
            );
    }
    function dispatchEventForPluginEventSystem(
      domEventName,
      eventSystemFlags,
      nativeEvent,
      targetInst$jscomp$0,
      targetContainer
    ) {
      var ancestorInst = targetInst$jscomp$0;
      if (
        0 === (eventSystemFlags & 1) &&
        0 === (eventSystemFlags & 2) &&
        null !== targetInst$jscomp$0
      )
        a: for (;;) {
          if (null === targetInst$jscomp$0) return;
          var nodeTag = targetInst$jscomp$0.tag;
          if (3 === nodeTag || 4 === nodeTag) {
            var container = targetInst$jscomp$0.stateNode.containerInfo;
            if (container === targetContainer) break;
            if (4 === nodeTag)
              for (nodeTag = targetInst$jscomp$0.return; null !== nodeTag; ) {
                var grandTag = nodeTag.tag;
                if (
                  (3 === grandTag || 4 === grandTag) &&
                  nodeTag.stateNode.containerInfo === targetContainer
                )
                  return;
                nodeTag = nodeTag.return;
              }
            for (; null !== container; ) {
              nodeTag = getClosestInstanceFromNode(container);
              if (null === nodeTag) return;
              grandTag = nodeTag.tag;
              if (
                5 === grandTag ||
                6 === grandTag ||
                26 === grandTag ||
                27 === grandTag
              ) {
                targetInst$jscomp$0 = ancestorInst = nodeTag;
                continue a;
              }
              container = container.parentNode;
            }
          }
          targetInst$jscomp$0 = targetInst$jscomp$0.return;
        }
      batchedUpdates$2(function () {
        var targetInst = ancestorInst,
          nativeEventTarget = getEventTarget(nativeEvent),
          dispatchQueue = [];
        a: {
          var reactName = topLevelEventsToReactNames.get(domEventName);
          if (void 0 !== reactName) {
            var SyntheticEventCtor = SyntheticEvent,
              reactEventType = domEventName;
            switch (domEventName) {
              case "keypress":
                if (0 === getEventCharCode(nativeEvent)) break a;
              case "keydown":
              case "keyup":
                SyntheticEventCtor = SyntheticKeyboardEvent;
                break;
              case "focusin":
                reactEventType = "focus";
                SyntheticEventCtor = SyntheticFocusEvent;
                break;
              case "focusout":
                reactEventType = "blur";
                SyntheticEventCtor = SyntheticFocusEvent;
                break;
              case "beforeblur":
              case "afterblur":
                SyntheticEventCtor = SyntheticFocusEvent;
                break;
              case "click":
                if (2 === nativeEvent.button) break a;
              case "auxclick":
              case "dblclick":
              case "mousedown":
              case "mousemove":
              case "mouseup":
              case "mouseout":
              case "mouseover":
              case "contextmenu":
                SyntheticEventCtor = SyntheticMouseEvent;
                break;
              case "drag":
              case "dragend":
              case "dragenter":
              case "dragexit":
              case "dragleave":
              case "dragover":
              case "dragstart":
              case "drop":
                SyntheticEventCtor = SyntheticDragEvent;
                break;
              case "touchcancel":
              case "touchend":
              case "touchmove":
              case "touchstart":
                SyntheticEventCtor = SyntheticTouchEvent;
                break;
              case ANIMATION_END:
              case ANIMATION_ITERATION:
              case ANIMATION_START:
                SyntheticEventCtor = SyntheticAnimationEvent;
                break;
              case TRANSITION_END:
                SyntheticEventCtor = SyntheticTransitionEvent;
                break;
              case "scroll":
              case "scrollend":
                SyntheticEventCtor = SyntheticUIEvent;
                break;
              case "wheel":
                SyntheticEventCtor = SyntheticWheelEvent;
                break;
              case "copy":
              case "cut":
              case "paste":
                SyntheticEventCtor = SyntheticClipboardEvent;
                break;
              case "gotpointercapture":
              case "lostpointercapture":
              case "pointercancel":
              case "pointerdown":
              case "pointermove":
              case "pointerout":
              case "pointerover":
              case "pointerup":
                SyntheticEventCtor = SyntheticPointerEvent;
                break;
              case "toggle":
              case "beforetoggle":
                SyntheticEventCtor = SyntheticToggleEvent;
            }
            var inCapturePhase = 0 !== (eventSystemFlags & 4);
            inCapturePhase = accumulateSinglePhaseListeners(
              targetInst,
              reactName,
              nativeEvent.type,
              inCapturePhase,
              !inCapturePhase &&
                ("scroll" === domEventName || "scrollend" === domEventName)
            );
            0 < inCapturePhase.length &&
              ((reactName = new SyntheticEventCtor(
                reactName,
                reactEventType,
                null,
                nativeEvent,
                nativeEventTarget
              )),
              dispatchQueue.push({
                event: reactName,
                listeners: inCapturePhase
              }));
          }
        }
        if (0 === (eventSystemFlags & 7)) {
          a: {
            SyntheticEventCtor =
              "mouseover" === domEventName || "pointerover" === domEventName;
            reactName =
              "mouseout" === domEventName || "pointerout" === domEventName;
            if (
              SyntheticEventCtor &&
              nativeEvent !== currentReplayingEvent &&
              (reactEventType =
                nativeEvent.relatedTarget || nativeEvent.fromElement) &&
              (getClosestInstanceFromNode(reactEventType) ||
                reactEventType[internalContainerInstanceKey])
            )
              break a;
            if (reactName || SyntheticEventCtor) {
              reactEventType =
                nativeEventTarget.window === nativeEventTarget
                  ? nativeEventTarget
                  : (SyntheticEventCtor = nativeEventTarget.ownerDocument)
                    ? SyntheticEventCtor.defaultView ||
                      SyntheticEventCtor.parentWindow
                    : window;
              if (reactName) {
                if (
                  ((SyntheticEventCtor =
                    nativeEvent.relatedTarget || nativeEvent.toElement),
                  (reactName = targetInst),
                  (SyntheticEventCtor = SyntheticEventCtor
                    ? getClosestInstanceFromNode(SyntheticEventCtor)
                    : null),
                  null !== SyntheticEventCtor)
                ) {
                  inCapturePhase = getNearestMountedFiber(SyntheticEventCtor);
                  var tag = SyntheticEventCtor.tag;
                  if (
                    SyntheticEventCtor !== inCapturePhase ||
                    (5 !== tag && 27 !== tag && 6 !== tag)
                  )
                    SyntheticEventCtor = null;
                }
              } else (reactName = null), (SyntheticEventCtor = targetInst);
              if (reactName !== SyntheticEventCtor) {
                tag = SyntheticMouseEvent;
                var leaveEventType = "onMouseLeave",
                  enterEventType = "onMouseEnter",
                  eventTypePrefix = "mouse";
                if (
                  "pointerout" === domEventName ||
                  "pointerover" === domEventName
                )
                  (tag = SyntheticPointerEvent),
                    (leaveEventType = "onPointerLeave"),
                    (enterEventType = "onPointerEnter"),
                    (eventTypePrefix = "pointer");
                inCapturePhase =
                  null == reactName
                    ? reactEventType
                    : getNodeFromInstance(reactName);
                var toNode =
                  null == SyntheticEventCtor
                    ? reactEventType
                    : getNodeFromInstance(SyntheticEventCtor);
                reactEventType = new tag(
                  leaveEventType,
                  eventTypePrefix + "leave",
                  reactName,
                  nativeEvent,
                  nativeEventTarget
                );
                reactEventType.target = inCapturePhase;
                reactEventType.relatedTarget = toNode;
                leaveEventType = null;
                getClosestInstanceFromNode(nativeEventTarget) === targetInst &&
                  ((tag = new tag(
                    enterEventType,
                    eventTypePrefix + "enter",
                    SyntheticEventCtor,
                    nativeEvent,
                    nativeEventTarget
                  )),
                  (tag.target = toNode),
                  (tag.relatedTarget = inCapturePhase),
                  (leaveEventType = tag));
                inCapturePhase = leaveEventType;
                tag =
                  reactName && SyntheticEventCtor
                    ? getLowestCommonAncestor(
                        reactName,
                        SyntheticEventCtor,
                        getParent
                      )
                    : null;
                null !== reactName &&
                  accumulateEnterLeaveListenersForEvent(
                    dispatchQueue,
                    reactEventType,
                    reactName,
                    tag,
                    !1
                  );
                null !== SyntheticEventCtor &&
                  null !== inCapturePhase &&
                  accumulateEnterLeaveListenersForEvent(
                    dispatchQueue,
                    inCapturePhase,
                    SyntheticEventCtor,
                    tag,
                    !0
                  );
              }
            }
          }
          a: {
            reactName = targetInst ? getNodeFromInstance(targetInst) : window;
            SyntheticEventCtor =
              reactName.nodeName && reactName.nodeName.toLowerCase();
            if (
              "select" === SyntheticEventCtor ||
              ("input" === SyntheticEventCtor && "file" === reactName.type)
            )
              var getTargetInstFunc = getTargetInstForChangeEvent;
            else if (isTextInputElement(reactName))
              if (isInputEventSupported)
                getTargetInstFunc = getTargetInstForInputOrChangeEvent;
              else {
                getTargetInstFunc = getTargetInstForInputEventPolyfill;
                var handleEventFunc = handleEventsForInputEventPolyfill;
              }
            else
              (SyntheticEventCtor = reactName.nodeName),
                !SyntheticEventCtor ||
                "input" !== SyntheticEventCtor.toLowerCase() ||
                ("checkbox" !== reactName.type && "radio" !== reactName.type)
                  ? targetInst &&
                    isCustomElement(targetInst.elementType) &&
                    (getTargetInstFunc = getTargetInstForChangeEvent)
                  : (getTargetInstFunc = getTargetInstForClickEvent);
            if (
              getTargetInstFunc &&
              (getTargetInstFunc = getTargetInstFunc(domEventName, targetInst))
            ) {
              createAndAccumulateChangeEvent(
                dispatchQueue,
                getTargetInstFunc,
                nativeEvent,
                nativeEventTarget
              );
              break a;
            }
            handleEventFunc &&
              handleEventFunc(domEventName, reactName, targetInst);
            "focusout" === domEventName &&
              targetInst &&
              "number" === reactName.type &&
              null != targetInst.memoizedProps.value &&
              setDefaultValue(reactName, "number", reactName.value);
          }
          handleEventFunc = targetInst
            ? getNodeFromInstance(targetInst)
            : window;
          switch (domEventName) {
            case "focusin":
              if (
                isTextInputElement(handleEventFunc) ||
                "true" === handleEventFunc.contentEditable
              )
                (activeElement = handleEventFunc),
                  (activeElementInst = targetInst),
                  (lastSelection = null);
              break;
            case "focusout":
              lastSelection = activeElementInst = activeElement = null;
              break;
            case "mousedown":
              mouseDown = !0;
              break;
            case "contextmenu":
            case "mouseup":
            case "dragend":
              mouseDown = !1;
              constructSelectEvent(
                dispatchQueue,
                nativeEvent,
                nativeEventTarget
              );
              break;
            case "selectionchange":
              if (skipSelectionChangeEvent) break;
            case "keydown":
            case "keyup":
              constructSelectEvent(
                dispatchQueue,
                nativeEvent,
                nativeEventTarget
              );
          }
          var fallbackData;
          if (canUseCompositionEvent)
            b: {
              switch (domEventName) {
                case "compositionstart":
                  var eventType = "onCompositionStart";
                  break b;
                case "compositionend":
                  eventType = "onCompositionEnd";
                  break b;
                case "compositionupdate":
                  eventType = "onCompositionUpdate";
                  break b;
              }
              eventType = void 0;
            }
          else
            isComposing
              ? isFallbackCompositionEnd(domEventName, nativeEvent) &&
                (eventType = "onCompositionEnd")
              : "keydown" === domEventName &&
                nativeEvent.keyCode === START_KEYCODE &&
                (eventType = "onCompositionStart");
          eventType &&
            (useFallbackCompositionData &&
              "ko" !== nativeEvent.locale &&
              (isComposing || "onCompositionStart" !== eventType
                ? "onCompositionEnd" === eventType &&
                  isComposing &&
                  (fallbackData = getData())
                : ((root = nativeEventTarget),
                  (startText = "value" in root ? root.value : root.textContent),
                  (isComposing = !0))),
            (handleEventFunc = accumulateTwoPhaseListeners(
              targetInst,
              eventType
            )),
            0 < handleEventFunc.length &&
              ((eventType = new SyntheticCompositionEvent(
                eventType,
                domEventName,
                null,
                nativeEvent,
                nativeEventTarget
              )),
              dispatchQueue.push({
                event: eventType,
                listeners: handleEventFunc
              }),
              fallbackData
                ? (eventType.data = fallbackData)
                : ((fallbackData = getDataFromCustomEvent(nativeEvent)),
                  null !== fallbackData && (eventType.data = fallbackData))));
          if (
            (fallbackData = canUseTextInputEvent
              ? getNativeBeforeInputChars(domEventName, nativeEvent)
              : getFallbackBeforeInputChars(domEventName, nativeEvent))
          )
            (eventType = accumulateTwoPhaseListeners(
              targetInst,
              "onBeforeInput"
            )),
              0 < eventType.length &&
                ((handleEventFunc = new SyntheticInputEvent(
                  "onBeforeInput",
                  "beforeinput",
                  null,
                  nativeEvent,
                  nativeEventTarget
                )),
                dispatchQueue.push({
                  event: handleEventFunc,
                  listeners: eventType
                }),
                (handleEventFunc.data = fallbackData));
          extractEvents$2(
            dispatchQueue,
            domEventName,
            targetInst,
            nativeEvent,
            nativeEventTarget
          );
        }
        a: if (
          ((fallbackData = 0 !== (eventSystemFlags & 4)),
          "scrollend" !== domEventName)
        ) {
          if (!isScrollEndEventSupported && fallbackData)
            switch (domEventName) {
              case "scroll":
                null !== nativeEventTarget &&
                  debounceScrollEnd(targetInst, nativeEvent, nativeEventTarget);
                break;
              case "touchstart":
                isTouchStarted = !0;
                break;
              case "touchcancel":
              case "touchend":
                isTouchStarted = !1;
                break;
              case "mousedown":
                isMouseDown = !0;
                break;
              case "mouseup":
                isMouseDown = !1;
            }
        } else {
          if (!isScrollEndEventSupported && null !== nativeEventTarget)
            if (
              ((eventType = nativeEventTarget[internalScrollTimer]),
              null != eventType)
            )
              clearTimeout(eventType),
                (nativeEventTarget[internalScrollTimer] = void 0);
            else break a;
          targetInst = accumulateSinglePhaseListeners(
            targetInst,
            "onScrollEnd",
            "scrollend",
            fallbackData,
            !fallbackData
          );
          0 < targetInst.length &&
            ((nativeEventTarget = new SyntheticUIEvent(
              "onScrollEnd",
              "scrollend",
              null,
              nativeEvent,
              nativeEventTarget
            )),
            dispatchQueue.push({
              event: nativeEventTarget,
              listeners: targetInst
            }));
        }
        processDispatchQueue(dispatchQueue, eventSystemFlags);
      });
    }
    function createDispatchListener(instance, listener, currentTarget) {
      return {
        instance: instance,
        listener: listener,
        currentTarget: currentTarget
      };
    }
    function accumulateSinglePhaseListeners(
      targetFiber,
      reactName,
      nativeEventType,
      inCapturePhase,
      accumulateTargetOnly
    ) {
      reactName = inCapturePhase
        ? null !== reactName
          ? reactName + "Capture"
          : null
        : reactName;
      for (nativeEventType = []; null !== targetFiber; ) {
        var _instance2 = targetFiber;
        inCapturePhase = _instance2.stateNode;
        _instance2 = _instance2.tag;
        (5 !== _instance2 && 26 !== _instance2 && 27 !== _instance2) ||
          null === inCapturePhase ||
          null === reactName ||
          ((_instance2 = getListener(targetFiber, reactName)),
          null != _instance2 &&
            nativeEventType.push(
              createDispatchListener(targetFiber, _instance2, inCapturePhase)
            ));
        if (accumulateTargetOnly) break;
        targetFiber = targetFiber.return;
      }
      return nativeEventType;
    }
    function accumulateTwoPhaseListeners(targetFiber, reactName) {
      for (
        var captureName = reactName + "Capture", listeners = [];
        null !== targetFiber;

      ) {
        var _instance3 = targetFiber,
          stateNode = _instance3.stateNode;
        _instance3 = _instance3.tag;
        (5 !== _instance3 && 26 !== _instance3 && 27 !== _instance3) ||
          null === stateNode ||
          ((_instance3 = getListener(targetFiber, captureName)),
          null != _instance3 &&
            listeners.unshift(
              createDispatchListener(targetFiber, _instance3, stateNode)
            ),
          (_instance3 = getListener(targetFiber, reactName)),
          null != _instance3 &&
            listeners.push(
              createDispatchListener(targetFiber, _instance3, stateNode)
            ));
        if (3 === targetFiber.tag) return listeners;
        targetFiber = targetFiber.return;
      }
      return [];
    }
    function getParent(inst) {
      if (null === inst) return null;
      do inst = inst.return;
      while (inst && 5 !== inst.tag && 27 !== inst.tag);
      return inst ? inst : null;
    }
    function accumulateEnterLeaveListenersForEvent(
      dispatchQueue,
      event,
      target,
      common,
      inCapturePhase
    ) {
      for (
        var registrationName = event._reactName, listeners = [];
        null !== target && target !== common;

      ) {
        var _instance4 = target,
          alternate = _instance4.alternate,
          stateNode = _instance4.stateNode;
        _instance4 = _instance4.tag;
        if (null !== alternate && alternate === common) break;
        (5 !== _instance4 && 26 !== _instance4 && 27 !== _instance4) ||
          null === stateNode ||
          ((alternate = stateNode),
          inCapturePhase
            ? ((stateNode = getListener(target, registrationName)),
              null != stateNode &&
                listeners.unshift(
                  createDispatchListener(target, stateNode, alternate)
                ))
            : inCapturePhase ||
              ((stateNode = getListener(target, registrationName)),
              null != stateNode &&
                listeners.push(
                  createDispatchListener(target, stateNode, alternate)
                )));
        target = target.return;
      }
      0 !== listeners.length &&
        dispatchQueue.push({ event: event, listeners: listeners });
    }
    function validatePropertiesInDevelopment(type, props) {
      validateProperties$2(type, props);
      ("input" !== type && "textarea" !== type && "select" !== type) ||
        null == props ||
        null !== props.value ||
        didWarnValueNull ||
        ((didWarnValueNull = !0),
        "select" === type && props.multiple
          ? console.error(
              "`value` prop on `%s` should not be null. Consider using an empty array when `multiple` is set to `true` to clear the component or `undefined` for uncontrolled components.",
              type
            )
          : console.error(
              "`value` prop on `%s` should not be null. Consider using an empty string to clear the component or `undefined` for uncontrolled components.",
              type
            ));
      var eventRegistry = {
        registrationNameDependencies: registrationNameDependencies,
        possibleRegistrationNames: possibleRegistrationNames
      };
      isCustomElement(type) ||
        "string" === typeof props.is ||
        warnUnknownProperties(type, props, eventRegistry);
      props.contentEditable &&
        !props.suppressContentEditableWarning &&
        null != props.children &&
        console.error(
          "A component is `contentEditable` and contains `children` managed by React. It is now your responsibility to guarantee that none of those nodes are unexpectedly modified or duplicated. This is probably not intentional."
        );
    }
    function warnForPropDifference(
      propName,
      serverValue,
      clientValue,
      serverDifferences
    ) {
      serverValue !== clientValue &&
        ((clientValue = normalizeMarkupForTextOrAttribute(clientValue)),
        normalizeMarkupForTextOrAttribute(serverValue) !== clientValue &&
          (serverDifferences[propName] = serverValue));
    }
    function warnForExtraAttributes(
      domElement,
      attributeNames,
      serverDifferences
    ) {
      attributeNames.forEach(function (attributeName) {
        serverDifferences[getPropNameFromAttributeName(attributeName)] =
          "style" === attributeName
            ? getStylesObjectFromElement(domElement)
            : domElement.getAttribute(attributeName);
      });
    }
    function warnForInvalidEventListener(registrationName, listener) {
      !1 === listener
        ? console.error(
            "Expected `%s` listener to be a function, instead got `false`.\n\nIf you used to conditionally omit it with %s={condition && value}, pass %s={condition ? value : undefined} instead.",
            registrationName,
            registrationName,
            registrationName
          )
        : console.error(
            "Expected `%s` listener to be a function, instead got a value of `%s` type.",
            registrationName,
            typeof listener
          );
    }
    function normalizeHTML(parent, html) {
      parent =
        parent.namespaceURI === MATH_NAMESPACE ||
        parent.namespaceURI === SVG_NAMESPACE
          ? parent.ownerDocument.createElementNS(
              parent.namespaceURI,
              parent.tagName
            )
          : parent.ownerDocument.createElement(parent.tagName);
      parent.innerHTML = html;
      return parent.innerHTML;
    }
    function normalizeMarkupForTextOrAttribute(markup) {
      willCoercionThrow(markup) &&
        (console.error(
          "The provided HTML markup uses a value of unsupported type %s. This value must be coerced to a string before using it here.",
          typeName(markup)
        ),
        testStringCoercion(markup));
      return ("string" === typeof markup ? markup : "" + markup)
        .replace(NORMALIZE_NEWLINES_REGEX, "\n")
        .replace(NORMALIZE_NULL_AND_REPLACEMENT_REGEX, "");
    }
    function checkForUnmatchedText(serverText, clientText) {
      clientText = normalizeMarkupForTextOrAttribute(clientText);
      return normalizeMarkupForTextOrAttribute(serverText) === clientText
        ? !0
        : !1;
    }
    function setProp(domElement, tag, key, value, props, prevValue) {
      switch (key) {
        case "children":
          if ("string" === typeof value)
            validateTextNesting(value, tag, !1),
              "body" === tag ||
                ("textarea" === tag && "" === value) ||
                setTextContent(domElement, value);
          else if ("number" === typeof value || "bigint" === typeof value)
            validateTextNesting("" + value, tag, !1),
              "body" !== tag && setTextContent(domElement, "" + value);
          else return;
          break;
        case "className":
          setValueForKnownAttribute(domElement, "class", value);
          break;
        case "tabIndex":
          setValueForKnownAttribute(domElement, "tabindex", value);
          break;
        case "dir":
        case "role":
        case "viewBox":
        case "width":
        case "height":
          setValueForKnownAttribute(domElement, key, value);
          break;
        case "style":
          setValueForStyles(domElement, value, prevValue);
          return;
        case "data":
          if ("object" !== tag) {
            setValueForKnownAttribute(domElement, "data", value);
            break;
          }
        case "src":
          if ("object" === typeof value && null !== value)
            if ("img" === tag || "video" === tag || "audio" === tag)
              try {
                setSrcObject(domElement, tag, value);
                break;
              } catch (x) {}
            else
              try {
                URL.revokeObjectURL(URL.createObjectURL(value)),
                  "source" === tag
                    ? console.error(
                        "Passing Blob, MediaSource or MediaStream to <source src> is not supported. Pass it directly to <img src>, <video src> or <audio src> instead."
                      )
                    : console.error(
                        "Passing Blob, MediaSource or MediaStream to <%s src> is not supported.",
                        tag
                      );
              } catch (x$10) {}
        case "href":
          if ("" === value && ("a" !== tag || "href" !== key)) {
            "src" === key
              ? console.error(
                  'An empty string ("") was passed to the %s attribute. This may cause the browser to download the whole page again over the network. To fix this, either do not render the element at all or pass null to %s instead of an empty string.',
                  key,
                  key
                )
              : console.error(
                  'An empty string ("") was passed to the %s attribute. To fix this, either do not render the element at all or pass null to %s instead of an empty string.',
                  key,
                  key
                );
            domElement.removeAttribute(key);
            break;
          }
          if (
            null == value ||
            "function" === typeof value ||
            "symbol" === typeof value ||
            "boolean" === typeof value
          ) {
            domElement.removeAttribute(key);
            break;
          }
          checkAttributeStringCoercion(value, key);
          value = sanitizeURL("" + value);
          domElement.setAttribute(key, value);
          break;
        case "action":
        case "formAction":
          null != value &&
            ("form" === tag
              ? "formAction" === key
                ? console.error(
                    "You can only pass the formAction prop to <input> or <button>. Use the action prop on <form>."
                  )
                : "function" === typeof value &&
                  ((null == props.encType && null == props.method) ||
                    didWarnFormActionMethod ||
                    ((didWarnFormActionMethod = !0),
                    console.error(
                      "Cannot specify a encType or method for a form that specifies a function as the action. React provides those automatically. They will get overridden."
                    )),
                  null == props.target ||
                    didWarnFormActionTarget ||
                    ((didWarnFormActionTarget = !0),
                    console.error(
                      "Cannot specify a target for a form that specifies a function as the action. The function will always be executed in the same window."
                    )))
              : "input" === tag || "button" === tag
                ? "action" === key
                  ? console.error(
                      "You can only pass the action prop to <form>. Use the formAction prop on <input> or <button>."
                    )
                  : "input" !== tag ||
                      "submit" === props.type ||
                      "image" === props.type ||
                      didWarnFormActionType
                    ? "button" !== tag ||
                      null == props.type ||
                      "submit" === props.type ||
                      didWarnFormActionType
                      ? "function" === typeof value &&
                        (null == props.name ||
                          didWarnFormActionName ||
                          ((didWarnFormActionName = !0),
                          console.error(
                            'Cannot specify a "name" prop for a button that specifies a function as a formAction. React needs it to encode which action should be invoked. It will get overridden.'
                          )),
                        (null == props.formEncType &&
                          null == props.formMethod) ||
                          didWarnFormActionMethod ||
                          ((didWarnFormActionMethod = !0),
                          console.error(
                            "Cannot specify a formEncType or formMethod for a button that specifies a function as a formAction. React provides those automatically. They will get overridden."
                          )),
                        null == props.formTarget ||
                          didWarnFormActionTarget ||
                          ((didWarnFormActionTarget = !0),
                          console.error(
                            "Cannot specify a formTarget for a button that specifies a function as a formAction. The function will always be executed in the same window."
                          )))
                      : ((didWarnFormActionType = !0),
                        console.error(
                          'A button can only specify a formAction along with type="submit" or no type.'
                        ))
                    : ((didWarnFormActionType = !0),
                      console.error(
                        'An input can only specify a formAction along with type="submit" or type="image".'
                      ))
                : "action" === key
                  ? console.error(
                      "You can only pass the action prop to <form>."
                    )
                  : console.error(
                      "You can only pass the formAction prop to <input> or <button>."
                    ));
          if ("function" === typeof value) {
            domElement.setAttribute(
              key,
              "javascript:throw new Error('A React form was unexpectedly submitted. If you called form.submit() manually, consider using form.requestSubmit() instead. If you\\'re trying to use event.stopPropagation() in a submit event handler, consider also calling event.preventDefault().')"
            );
            break;
          } else
            "function" === typeof prevValue &&
              ("formAction" === key
                ? ("input" !== tag &&
                    setProp(domElement, tag, "name", props.name, props, null),
                  setProp(
                    domElement,
                    tag,
                    "formEncType",
                    props.formEncType,
                    props,
                    null
                  ),
                  setProp(
                    domElement,
                    tag,
                    "formMethod",
                    props.formMethod,
                    props,
                    null
                  ),
                  setProp(
                    domElement,
                    tag,
                    "formTarget",
                    props.formTarget,
                    props,
                    null
                  ))
                : (setProp(
                    domElement,
                    tag,
                    "encType",
                    props.encType,
                    props,
                    null
                  ),
                  setProp(domElement, tag, "method", props.method, props, null),
                  setProp(
                    domElement,
                    tag,
                    "target",
                    props.target,
                    props,
                    null
                  )));
          if (
            null == value ||
            "symbol" === typeof value ||
            "boolean" === typeof value
          ) {
            domElement.removeAttribute(key);
            break;
          }
          checkAttributeStringCoercion(value, key);
          value = sanitizeURL("" + value);
          domElement.setAttribute(key, value);
          break;
        case "onClick":
          null != value &&
            ("function" !== typeof value &&
              warnForInvalidEventListener(key, value),
            (domElement.onclick = noop$1));
          return;
        case "onScroll":
          null != value &&
            ("function" !== typeof value &&
              warnForInvalidEventListener(key, value),
            listenToNonDelegatedEvent("scroll", domElement));
          return;
        case "onScrollEnd":
          null != value &&
            ("function" !== typeof value &&
              warnForInvalidEventListener(key, value),
            listenToNonDelegatedEvent("scrollend", domElement),
            listenToNonDelegatedEvent("scroll", domElement));
          return;
        case "dangerouslySetInnerHTML":
          if (null != value) {
            if ("object" !== typeof value || !("__html" in value))
              throw Error(
                "`props.dangerouslySetInnerHTML` must be in the form `{__html: ...}`. Please visit https://react.dev/link/dangerously-set-inner-html for more information."
              );
            key = value.__html;
            if (null != key) {
              if (null != props.children)
                throw Error(
                  "Can only set one of `children` or `props.dangerouslySetInnerHTML`."
                );
              domElement.innerHTML = key;
            }
          }
          break;
        case "multiple":
          domElement.multiple =
            value && "function" !== typeof value && "symbol" !== typeof value;
          break;
        case "muted":
          domElement.muted =
            value && "function" !== typeof value && "symbol" !== typeof value;
          break;
        case "suppressContentEditableWarning":
        case "suppressHydrationWarning":
        case "defaultValue":
        case "defaultChecked":
        case "innerHTML":
        case "ref":
          break;
        case "autoFocus":
          break;
        case "xlinkHref":
          if (
            null == value ||
            "function" === typeof value ||
            "boolean" === typeof value ||
            "symbol" === typeof value
          ) {
            domElement.removeAttribute("xlink:href");
            break;
          }
          checkAttributeStringCoercion(value, key);
          key = sanitizeURL("" + value);
          domElement.setAttributeNS(xlinkNamespace, "xlink:href", key);
          break;
        case "contentEditable":
        case "spellCheck":
        case "draggable":
        case "value":
        case "autoReverse":
        case "externalResourcesRequired":
        case "focusable":
        case "preserveAlpha":
          null != value &&
          "function" !== typeof value &&
          "symbol" !== typeof value
            ? (checkAttributeStringCoercion(value, key),
              domElement.setAttribute(key, "" + value))
            : domElement.removeAttribute(key);
          break;
        case "inert":
          "" !== value ||
            didWarnForNewBooleanPropsWithEmptyValue[key] ||
            ((didWarnForNewBooleanPropsWithEmptyValue[key] = !0),
            console.error(
              "Received an empty string for a boolean attribute `%s`. This will treat the attribute as if it were false. Either pass `false` to silence this warning, or pass `true` if you used an empty string in earlier versions of React to indicate this attribute is true.",
              key
            ));
        case "allowFullScreen":
        case "async":
        case "autoPlay":
        case "controls":
        case "default":
        case "defer":
        case "disabled":
        case "disablePictureInPicture":
        case "disableRemotePlayback":
        case "formNoValidate":
        case "hidden":
        case "loop":
        case "noModule":
        case "noValidate":
        case "open":
        case "playsInline":
        case "readOnly":
        case "required":
        case "reversed":
        case "scoped":
        case "seamless":
        case "itemScope":
          value && "function" !== typeof value && "symbol" !== typeof value
            ? domElement.setAttribute(key, "")
            : domElement.removeAttribute(key);
          break;
        case "capture":
        case "download":
          !0 === value
            ? domElement.setAttribute(key, "")
            : !1 !== value &&
                null != value &&
                "function" !== typeof value &&
                "symbol" !== typeof value
              ? (checkAttributeStringCoercion(value, key),
                domElement.setAttribute(key, value))
              : domElement.removeAttribute(key);
          break;
        case "cols":
        case "rows":
        case "size":
        case "span":
          null != value &&
          "function" !== typeof value &&
          "symbol" !== typeof value &&
          !isNaN(value) &&
          1 <= value
            ? (checkAttributeStringCoercion(value, key),
              domElement.setAttribute(key, value))
            : domElement.removeAttribute(key);
          break;
        case "rowSpan":
        case "start":
          null == value ||
          "function" === typeof value ||
          "symbol" === typeof value ||
          isNaN(value)
            ? domElement.removeAttribute(key)
            : (checkAttributeStringCoercion(value, key),
              domElement.setAttribute(key, value));
          break;
        case "popover":
          listenToNonDelegatedEvent("beforetoggle", domElement);
          listenToNonDelegatedEvent("toggle", domElement);
          setValueForAttribute(domElement, "popover", value);
          break;
        case "xlinkActuate":
          setValueForNamespacedAttribute(
            domElement,
            xlinkNamespace,
            "xlink:actuate",
            value
          );
          break;
        case "xlinkArcrole":
          setValueForNamespacedAttribute(
            domElement,
            xlinkNamespace,
            "xlink:arcrole",
            value
          );
          break;
        case "xlinkRole":
          setValueForNamespacedAttribute(
            domElement,
            xlinkNamespace,
            "xlink:role",
            value
          );
          break;
        case "xlinkShow":
          setValueForNamespacedAttribute(
            domElement,
            xlinkNamespace,
            "xlink:show",
            value
          );
          break;
        case "xlinkTitle":
          setValueForNamespacedAttribute(
            domElement,
            xlinkNamespace,
            "xlink:title",
            value
          );
          break;
        case "xlinkType":
          setValueForNamespacedAttribute(
            domElement,
            xlinkNamespace,
            "xlink:type",
            value
          );
          break;
        case "xmlBase":
          setValueForNamespacedAttribute(
            domElement,
            xmlNamespace,
            "xml:base",
            value
          );
          break;
        case "xmlLang":
          setValueForNamespacedAttribute(
            domElement,
            xmlNamespace,
            "xml:lang",
            value
          );
          break;
        case "xmlSpace":
          setValueForNamespacedAttribute(
            domElement,
            xmlNamespace,
            "xml:space",
            value
          );
          break;
        case "is":
          null != prevValue &&
            console.error(
              'Cannot update the "is" prop after it has been initialized.'
            );
          setValueForAttribute(domElement, "is", value);
          break;
        case "innerText":
        case "textContent":
          return;
        case "popoverTarget":
          didWarnPopoverTargetObject ||
            null == value ||
            "object" !== typeof value ||
            ((didWarnPopoverTargetObject = !0),
            console.error(
              "The `popoverTarget` prop expects the ID of an Element as a string. Received %s instead.",
              value
            ));
        default:
          if (
            !(2 < key.length) ||
            ("o" !== key[0] && "O" !== key[0]) ||
            ("n" !== key[1] && "N" !== key[1])
          )
            (key = getAttributeAlias(key)),
              setValueForAttribute(domElement, key, value);
          else {
            registrationNameDependencies.hasOwnProperty(key) &&
              null != value &&
              "function" !== typeof value &&
              warnForInvalidEventListener(key, value);
            return;
          }
      }
      viewTransitionMutationContext = !0;
    }
    function setPropOnCustomElement(
      domElement,
      tag,
      key,
      value,
      props,
      prevValue
    ) {
      switch (key) {
        case "style":
          setValueForStyles(domElement, value, prevValue);
          return;
        case "dangerouslySetInnerHTML":
          if (null != value) {
            if ("object" !== typeof value || !("__html" in value))
              throw Error(
                "`props.dangerouslySetInnerHTML` must be in the form `{__html: ...}`. Please visit https://react.dev/link/dangerously-set-inner-html for more information."
              );
            key = value.__html;
            if (null != key) {
              if (null != props.children)
                throw Error(
                  "Can only set one of `children` or `props.dangerouslySetInnerHTML`."
                );
              domElement.innerHTML = key;
            }
          }
          break;
        case "children":
          if ("string" === typeof value) setTextContent(domElement, value);
          else if ("number" === typeof value || "bigint" === typeof value)
            setTextContent(domElement, "" + value);
          else return;
          break;
        case "onScroll":
          null != value &&
            ("function" !== typeof value &&
              warnForInvalidEventListener(key, value),
            listenToNonDelegatedEvent("scroll", domElement));
          return;
        case "onScrollEnd":
          null != value &&
            ("function" !== typeof value &&
              warnForInvalidEventListener(key, value),
            listenToNonDelegatedEvent("scrollend", domElement),
            listenToNonDelegatedEvent("scroll", domElement));
          return;
        case "onClick":
          null != value &&
            ("function" !== typeof value &&
              warnForInvalidEventListener(key, value),
            (domElement.onclick = noop$1));
          return;
        case "suppressContentEditableWarning":
        case "suppressHydrationWarning":
        case "innerHTML":
        case "ref":
          return;
        case "innerText":
        case "textContent":
          return;
        default:
          if (registrationNameDependencies.hasOwnProperty(key))
            null != value &&
              "function" !== typeof value &&
              warnForInvalidEventListener(key, value);
          else
            a: {
              if (
                "o" === key[0] &&
                "n" === key[1] &&
                ((props = key.endsWith("Capture")),
                (tag = key.slice(2, props ? key.length - 7 : void 0)),
                (prevValue = domElement[internalPropsKey] || null),
                (prevValue = null != prevValue ? prevValue[key] : null),
                "function" === typeof prevValue &&
                  domElement.removeEventListener(tag, prevValue, props),
                "function" === typeof value)
              ) {
                "function" !== typeof prevValue &&
                  null !== prevValue &&
                  (key in domElement
                    ? (domElement[key] = null)
                    : domElement.hasAttribute(key) &&
                      domElement.removeAttribute(key));
                domElement.addEventListener(tag, value, props);
                break a;
              }
              viewTransitionMutationContext = !0;
              key in domElement
                ? (domElement[key] = value)
                : !0 === value
                  ? domElement.setAttribute(key, "")
                  : setValueForAttribute(domElement, key, value);
            }
          return;
      }
      viewTransitionMutationContext = !0;
    }
    function setInitialProperties(domElement, tag, props) {
      validatePropertiesInDevelopment(tag, props);
      switch (tag) {
        case "div":
        case "span":
        case "svg":
        case "path":
        case "a":
        case "g":
        case "p":
        case "li":
          break;
        case "img":
          listenToNonDelegatedEvent("error", domElement);
          listenToNonDelegatedEvent("load", domElement);
          var hasSrc = !1,
            hasSrcSet = !1;
          for (propKey in props)
            if (props.hasOwnProperty(propKey)) {
              var propValue = props[propKey];
              if (null != propValue)
                switch (propKey) {
                  case "src":
                    hasSrc = !0;
                    break;
                  case "srcSet":
                    hasSrcSet = !0;
                    break;
                  case "children":
                  case "dangerouslySetInnerHTML":
                    throw Error(
                      tag +
                        " is a void element tag and must neither have `children` nor use `dangerouslySetInnerHTML`."
                    );
                  default:
                    setProp(domElement, tag, propKey, propValue, props, null);
                }
            }
          hasSrcSet &&
            setProp(domElement, tag, "srcSet", props.srcSet, props, null);
          hasSrc && setProp(domElement, tag, "src", props.src, props, null);
          return;
        case "input":
          checkControlledValueProps("input", props);
          listenToNonDelegatedEvent("invalid", domElement);
          var value = (propValue = hasSrcSet = null),
            defaultValue = null,
            checked = null;
          var propKey = null;
          for (hasSrc in props)
            if (props.hasOwnProperty(hasSrc)) {
              var _propValue = props[hasSrc];
              if (null != _propValue)
                switch (hasSrc) {
                  case "name":
                    hasSrcSet = _propValue;
                    break;
                  case "type":
                    propValue = _propValue;
                    break;
                  case "checked":
                    checked = _propValue;
                    break;
                  case "defaultChecked":
                    propKey = _propValue;
                    break;
                  case "value":
                    value = _propValue;
                    break;
                  case "defaultValue":
                    defaultValue = _propValue;
                    break;
                  case "children":
                  case "dangerouslySetInnerHTML":
                    if (null != _propValue)
                      throw Error(
                        tag +
                          " is a void element tag and must neither have `children` nor use `dangerouslySetInnerHTML`."
                      );
                    break;
                  default:
                    setProp(domElement, tag, hasSrc, _propValue, props, null);
                }
            }
          validateInputProps(domElement, props);
          a: {
            tag = value;
            hasSrc = defaultValue;
            props = checked;
            null != propValue &&
              "function" !== typeof propValue &&
              "symbol" !== typeof propValue &&
              "boolean" !== typeof propValue &&
              (checkAttributeStringCoercion(propValue, "type"),
              (domElement.type = propValue));
            if (null != tag || null != hasSrc) {
              if (
                !(
                  ("submit" !== propValue && "reset" !== propValue) ||
                  (void 0 !== tag && null !== tag)
                )
              ) {
                track(domElement);
                break a;
              }
              hasSrc = null != hasSrc ? "" + getToStringValue(hasSrc) : "";
              tag = null != tag ? "" + getToStringValue(tag) : hasSrc;
              tag !== domElement.value && (domElement.value = tag);
              domElement.defaultValue = tag;
            }
            tag = null != props ? props : propKey;
            tag = "function" !== typeof tag && "symbol" !== typeof tag && !!tag;
            domElement.checked = !!tag;
            domElement.defaultChecked = !!tag;
            null != hasSrcSet &&
              "function" !== typeof hasSrcSet &&
              "symbol" !== typeof hasSrcSet &&
              "boolean" !== typeof hasSrcSet &&
              (checkAttributeStringCoercion(hasSrcSet, "name"),
              (domElement.name = hasSrcSet));
            track(domElement);
          }
          return;
        case "select":
          checkControlledValueProps("select", props);
          listenToNonDelegatedEvent("invalid", domElement);
          hasSrc = propValue = propKey = null;
          for (hasSrcSet in props)
            if (
              props.hasOwnProperty(hasSrcSet) &&
              ((checked = props[hasSrcSet]), null != checked)
            )
              switch (hasSrcSet) {
                case "value":
                  propKey = checked;
                  break;
                case "defaultValue":
                  propValue = checked;
                  break;
                case "multiple":
                  hasSrc = checked;
                default:
                  setProp(domElement, tag, hasSrcSet, checked, props, null);
              }
          validateSelectProps(domElement, props);
          tag = propKey;
          props = propValue;
          domElement.multiple = !!hasSrc;
          null != tag
            ? updateOptions(domElement, !!hasSrc, tag, !1)
            : null != props && updateOptions(domElement, !!hasSrc, props, !0);
          return;
        case "textarea":
          checkControlledValueProps("textarea", props);
          listenToNonDelegatedEvent("invalid", domElement);
          hasSrcSet = propKey = hasSrc = null;
          for (propValue in props)
            if (
              props.hasOwnProperty(propValue) &&
              ((checked = props[propValue]), null != checked)
            )
              switch (propValue) {
                case "value":
                  hasSrc = checked;
                  break;
                case "defaultValue":
                  propKey = checked;
                  break;
                case "children":
                  hasSrcSet = checked;
                  break;
                case "dangerouslySetInnerHTML":
                  if (null != checked)
                    throw Error(
                      "`dangerouslySetInnerHTML` does not make sense on <textarea>."
                    );
                  break;
                default:
                  setProp(domElement, tag, propValue, checked, props, null);
              }
          validateTextareaProps(domElement, props);
          tag = propKey;
          props = hasSrcSet;
          if (null == hasSrc) {
            if (null != props) {
              if (null != tag)
                throw Error(
                  "If you supply `defaultValue` on a <textarea>, do not pass children."
                );
              if (isArrayImpl(props)) {
                if (1 < props.length)
                  throw Error("<textarea> can only have at most one child.");
                props = props[0];
              }
              tag = props;
            }
            null == tag && (tag = "");
            hasSrc = tag;
          }
          tag = getToStringValue(hasSrc);
          domElement.defaultValue = tag;
          props = domElement.textContent;
          props === tag &&
            "" !== props &&
            null !== props &&
            (domElement.value = props);
          track(domElement);
          return;
        case "option":
          validateOptionProps(domElement, props);
          for (defaultValue in props)
            if (
              props.hasOwnProperty(defaultValue) &&
              ((hasSrc = props[defaultValue]), null != hasSrc)
            )
              switch (defaultValue) {
                case "selected":
                  domElement.selected =
                    hasSrc &&
                    "function" !== typeof hasSrc &&
                    "symbol" !== typeof hasSrc;
                  break;
                default:
                  setProp(domElement, tag, defaultValue, hasSrc, props, null);
              }
          return;
        case "dialog":
          listenToNonDelegatedEvent("beforetoggle", domElement);
          listenToNonDelegatedEvent("toggle", domElement);
          listenToNonDelegatedEvent("cancel", domElement);
          listenToNonDelegatedEvent("close", domElement);
          break;
        case "iframe":
        case "object":
          listenToNonDelegatedEvent("load", domElement);
          break;
        case "video":
        case "audio":
          for (hasSrc = 0; hasSrc < mediaEventTypes.length; hasSrc++)
            listenToNonDelegatedEvent(mediaEventTypes[hasSrc], domElement);
          break;
        case "image":
          listenToNonDelegatedEvent("error", domElement);
          listenToNonDelegatedEvent("load", domElement);
          break;
        case "details":
          listenToNonDelegatedEvent("toggle", domElement);
          break;
        case "embed":
        case "source":
        case "link":
          listenToNonDelegatedEvent("error", domElement),
            listenToNonDelegatedEvent("load", domElement);
        case "area":
        case "base":
        case "br":
        case "col":
        case "hr":
        case "keygen":
        case "meta":
        case "param":
        case "track":
        case "wbr":
        case "menuitem":
          for (value in props)
            if (
              props.hasOwnProperty(value) &&
              ((hasSrc = props[value]), null != hasSrc)
            )
              switch (value) {
                case "children":
                case "dangerouslySetInnerHTML":
                  throw Error(
                    tag +
                      " is a void element tag and must neither have `children` nor use `dangerouslySetInnerHTML`."
                  );
                default:
                  setProp(domElement, tag, value, hasSrc, props, null);
              }
          return;
        default:
          if (isCustomElement(tag)) {
            for (_propValue in props)
              props.hasOwnProperty(_propValue) &&
                ((hasSrc = props[_propValue]),
                void 0 !== hasSrc &&
                  setPropOnCustomElement(
                    domElement,
                    tag,
                    _propValue,
                    hasSrc,
                    props,
                    void 0
                  ));
            return;
          }
      }
      for (checked in props)
        props.hasOwnProperty(checked) &&
          ((hasSrc = props[checked]),
          null != hasSrc &&
            setProp(domElement, tag, checked, hasSrc, props, null));
    }
    function updateProperties(domElement, tag, lastProps, nextProps) {
      validatePropertiesInDevelopment(tag, nextProps);
      switch (tag) {
        case "div":
        case "span":
        case "svg":
        case "path":
        case "a":
        case "g":
        case "p":
        case "li":
          break;
        case "input":
          var name = null,
            type = null,
            value = null,
            defaultValue = null,
            lastDefaultValue = null,
            checked = null,
            defaultChecked = null;
          for (propKey in lastProps) {
            var lastProp = lastProps[propKey];
            if (lastProps.hasOwnProperty(propKey) && null != lastProp)
              switch (propKey) {
                case "checked":
                  break;
                case "value":
                  break;
                case "defaultValue":
                  lastDefaultValue = lastProp;
                default:
                  nextProps.hasOwnProperty(propKey) ||
                    setProp(
                      domElement,
                      tag,
                      propKey,
                      null,
                      nextProps,
                      lastProp
                    );
              }
          }
          for (var _propKey8 in nextProps) {
            var propKey = nextProps[_propKey8];
            lastProp = lastProps[_propKey8];
            if (
              nextProps.hasOwnProperty(_propKey8) &&
              (null != propKey || null != lastProp)
            )
              switch (_propKey8) {
                case "type":
                  propKey !== lastProp && (viewTransitionMutationContext = !0);
                  type = propKey;
                  break;
                case "name":
                  propKey !== lastProp && (viewTransitionMutationContext = !0);
                  name = propKey;
                  break;
                case "checked":
                  propKey !== lastProp && (viewTransitionMutationContext = !0);
                  checked = propKey;
                  break;
                case "defaultChecked":
                  propKey !== lastProp && (viewTransitionMutationContext = !0);
                  defaultChecked = propKey;
                  break;
                case "value":
                  propKey !== lastProp && (viewTransitionMutationContext = !0);
                  value = propKey;
                  break;
                case "defaultValue":
                  propKey !== lastProp && (viewTransitionMutationContext = !0);
                  defaultValue = propKey;
                  break;
                case "children":
                case "dangerouslySetInnerHTML":
                  if (null != propKey)
                    throw Error(
                      tag +
                        " is a void element tag and must neither have `children` nor use `dangerouslySetInnerHTML`."
                    );
                  break;
                default:
                  propKey !== lastProp &&
                    setProp(
                      domElement,
                      tag,
                      _propKey8,
                      propKey,
                      nextProps,
                      lastProp
                    );
              }
          }
          tag =
            "checkbox" === lastProps.type || "radio" === lastProps.type
              ? null != lastProps.checked
              : null != lastProps.value;
          nextProps =
            "checkbox" === nextProps.type || "radio" === nextProps.type
              ? null != nextProps.checked
              : null != nextProps.value;
          tag ||
            !nextProps ||
            didWarnUncontrolledToControlled ||
            (console.error(
              "A component is changing an uncontrolled input to be controlled. This is likely caused by the value changing from undefined to a defined value, which should not happen. Decide between using a controlled or uncontrolled input element for the lifetime of the component. More info: https://react.dev/link/controlled-components"
            ),
            (didWarnUncontrolledToControlled = !0));
          !tag ||
            nextProps ||
            didWarnControlledToUncontrolled ||
            (console.error(
              "A component is changing a controlled input to be uncontrolled. This is likely caused by the value changing from a defined to undefined, which should not happen. Decide between using a controlled or uncontrolled input element for the lifetime of the component. More info: https://react.dev/link/controlled-components"
            ),
            (didWarnControlledToUncontrolled = !0));
          updateInput(
            domElement,
            value,
            defaultValue,
            lastDefaultValue,
            checked,
            defaultChecked,
            type,
            name
          );
          return;
        case "select":
          propKey = value = defaultValue = _propKey8 = null;
          for (type in lastProps)
            if (
              ((lastDefaultValue = lastProps[type]),
              lastProps.hasOwnProperty(type) && null != lastDefaultValue)
            )
              switch (type) {
                case "value":
                  break;
                case "multiple":
                  propKey = lastDefaultValue;
                default:
                  nextProps.hasOwnProperty(type) ||
                    setProp(
                      domElement,
                      tag,
                      type,
                      null,
                      nextProps,
                      lastDefaultValue
                    );
              }
          for (name in nextProps)
            if (
              ((type = nextProps[name]),
              (lastDefaultValue = lastProps[name]),
              nextProps.hasOwnProperty(name) &&
                (null != type || null != lastDefaultValue))
            )
              switch (name) {
                case "value":
                  type !== lastDefaultValue &&
                    (viewTransitionMutationContext = !0);
                  _propKey8 = type;
                  break;
                case "defaultValue":
                  type !== lastDefaultValue &&
                    (viewTransitionMutationContext = !0);
                  defaultValue = type;
                  break;
                case "multiple":
                  type !== lastDefaultValue &&
                    (viewTransitionMutationContext = !0),
                    (value = type);
                default:
                  type !== lastDefaultValue &&
                    setProp(
                      domElement,
                      tag,
                      name,
                      type,
                      nextProps,
                      lastDefaultValue
                    );
              }
          nextProps = defaultValue;
          tag = value;
          lastProps = propKey;
          null != _propKey8
            ? updateOptions(domElement, !!tag, _propKey8, !1)
            : !!lastProps !== !!tag &&
              (null != nextProps
                ? updateOptions(domElement, !!tag, nextProps, !0)
                : updateOptions(domElement, !!tag, tag ? [] : "", !1));
          return;
        case "textarea":
          propKey = _propKey8 = null;
          for (defaultValue in lastProps)
            if (
              ((name = lastProps[defaultValue]),
              lastProps.hasOwnProperty(defaultValue) &&
                null != name &&
                !nextProps.hasOwnProperty(defaultValue))
            )
              switch (defaultValue) {
                case "value":
                  break;
                case "children":
                  break;
                default:
                  setProp(domElement, tag, defaultValue, null, nextProps, name);
              }
          for (value in nextProps)
            if (
              ((name = nextProps[value]),
              (type = lastProps[value]),
              nextProps.hasOwnProperty(value) && (null != name || null != type))
            )
              switch (value) {
                case "value":
                  name !== type && (viewTransitionMutationContext = !0);
                  _propKey8 = name;
                  break;
                case "defaultValue":
                  name !== type && (viewTransitionMutationContext = !0);
                  propKey = name;
                  break;
                case "children":
                  break;
                case "dangerouslySetInnerHTML":
                  if (null != name)
                    throw Error(
                      "`dangerouslySetInnerHTML` does not make sense on <textarea>."
                    );
                  break;
                default:
                  name !== type &&
                    setProp(domElement, tag, value, name, nextProps, type);
              }
          updateTextarea(domElement, _propKey8, propKey);
          return;
        case "option":
          for (var _propKey13 in lastProps)
            if (
              ((_propKey8 = lastProps[_propKey13]),
              lastProps.hasOwnProperty(_propKey13) &&
                null != _propKey8 &&
                !nextProps.hasOwnProperty(_propKey13))
            )
              switch (_propKey13) {
                case "selected":
                  domElement.selected = !1;
                  break;
                default:
                  setProp(
                    domElement,
                    tag,
                    _propKey13,
                    null,
                    nextProps,
                    _propKey8
                  );
              }
          for (lastDefaultValue in nextProps)
            if (
              ((_propKey8 = nextProps[lastDefaultValue]),
              (propKey = lastProps[lastDefaultValue]),
              nextProps.hasOwnProperty(lastDefaultValue) &&
                _propKey8 !== propKey &&
                (null != _propKey8 || null != propKey))
            )
              switch (lastDefaultValue) {
                case "selected":
                  _propKey8 !== propKey && (viewTransitionMutationContext = !0);
                  domElement.selected =
                    _propKey8 &&
                    "function" !== typeof _propKey8 &&
                    "symbol" !== typeof _propKey8;
                  break;
                default:
                  setProp(
                    domElement,
                    tag,
                    lastDefaultValue,
                    _propKey8,
                    nextProps,
                    propKey
                  );
              }
          return;
        case "img":
        case "link":
        case "area":
        case "base":
        case "br":
        case "col":
        case "embed":
        case "hr":
        case "keygen":
        case "meta":
        case "param":
        case "source":
        case "track":
        case "wbr":
        case "menuitem":
          for (var _propKey15 in lastProps)
            (_propKey8 = lastProps[_propKey15]),
              lastProps.hasOwnProperty(_propKey15) &&
                null != _propKey8 &&
                !nextProps.hasOwnProperty(_propKey15) &&
                setProp(
                  domElement,
                  tag,
                  _propKey15,
                  null,
                  nextProps,
                  _propKey8
                );
          for (checked in nextProps)
            if (
              ((_propKey8 = nextProps[checked]),
              (propKey = lastProps[checked]),
              nextProps.hasOwnProperty(checked) &&
                _propKey8 !== propKey &&
                (null != _propKey8 || null != propKey))
            )
              switch (checked) {
                case "children":
                case "dangerouslySetInnerHTML":
                  if (null != _propKey8)
                    throw Error(
                      tag +
                        " is a void element tag and must neither have `children` nor use `dangerouslySetInnerHTML`."
                    );
                  break;
                default:
                  setProp(
                    domElement,
                    tag,
                    checked,
                    _propKey8,
                    nextProps,
                    propKey
                  );
              }
          return;
        default:
          if (isCustomElement(tag)) {
            for (var _propKey17 in lastProps)
              (_propKey8 = lastProps[_propKey17]),
                lastProps.hasOwnProperty(_propKey17) &&
                  void 0 !== _propKey8 &&
                  !nextProps.hasOwnProperty(_propKey17) &&
                  setPropOnCustomElement(
                    domElement,
                    tag,
                    _propKey17,
                    void 0,
                    nextProps,
                    _propKey8
                  );
            for (defaultChecked in nextProps)
              (_propKey8 = nextProps[defaultChecked]),
                (propKey = lastProps[defaultChecked]),
                !nextProps.hasOwnProperty(defaultChecked) ||
                  _propKey8 === propKey ||
                  (void 0 === _propKey8 && void 0 === propKey) ||
                  setPropOnCustomElement(
                    domElement,
                    tag,
                    defaultChecked,
                    _propKey8,
                    nextProps,
                    propKey
                  );
            return;
          }
      }
      for (var _propKey19 in lastProps)
        (_propKey8 = lastProps[_propKey19]),
          lastProps.hasOwnProperty(_propKey19) &&
            null != _propKey8 &&
            !nextProps.hasOwnProperty(_propKey19) &&
            setProp(domElement, tag, _propKey19, null, nextProps, _propKey8);
      for (lastProp in nextProps)
        (_propKey8 = nextProps[lastProp]),
          (propKey = lastProps[lastProp]),
          !nextProps.hasOwnProperty(lastProp) ||
            _propKey8 === propKey ||
            (null == _propKey8 && null == propKey) ||
            setProp(domElement, tag, lastProp, _propKey8, nextProps, propKey);
    }
    function getPropNameFromAttributeName(attrName) {
      switch (attrName) {
        case "class":
          return "className";
        case "for":
          return "htmlFor";
        default:
          return attrName;
      }
    }
    function getStylesObjectFromElement(domElement) {
      var serverValueInObjectForm = {};
      domElement = domElement.style;
      for (var i = 0; i < domElement.length; i++) {
        var styleName = domElement[i];
        serverValueInObjectForm[styleName] =
          domElement.getPropertyValue(styleName);
      }
      return serverValueInObjectForm;
    }
    function diffHydratedStyles(domElement, value$jscomp$0, serverDifferences) {
      if (null != value$jscomp$0 && "object" !== typeof value$jscomp$0)
        console.error(
          "The `style` prop expects a mapping from style properties to values, not a string. For example, style={{marginRight: spacing + 'em'}} when using JSX."
        );
      else {
        var clientValue;
        var delimiter = (clientValue = ""),
          styleName;
        for (styleName in value$jscomp$0)
          if (value$jscomp$0.hasOwnProperty(styleName)) {
            var value = value$jscomp$0[styleName];
            null != value &&
              "boolean" !== typeof value &&
              "" !== value &&
              (0 === styleName.indexOf("--")
                ? (checkCSSPropertyStringCoercion(value, styleName),
                  (clientValue +=
                    delimiter + styleName + ":" + ("" + value).trim()))
                : "number" !== typeof value ||
                    0 === value ||
                    unitlessNumbers.has(styleName)
                  ? (checkCSSPropertyStringCoercion(value, styleName),
                    (clientValue +=
                      delimiter +
                      styleName
                        .replace(uppercasePattern, "-$1")
                        .toLowerCase()
                        .replace(msPattern$1, "-ms-") +
                      ":" +
                      ("" + value).trim()))
                  : (clientValue +=
                      delimiter +
                      styleName
                        .replace(uppercasePattern, "-$1")
                        .toLowerCase()
                        .replace(msPattern$1, "-ms-") +
                      ":" +
                      value +
                      "px"),
              (delimiter = ";"));
          }
        clientValue = clientValue || null;
        value$jscomp$0 = domElement.getAttribute("style");
        value$jscomp$0 !== clientValue &&
          ((clientValue = normalizeMarkupForTextOrAttribute(clientValue)),
          normalizeMarkupForTextOrAttribute(value$jscomp$0) !== clientValue &&
            (serverDifferences.style = getStylesObjectFromElement(domElement)));
      }
    }
    function hydrateAttribute(
      domElement,
      propKey,
      attributeName,
      value,
      extraAttributes,
      serverDifferences
    ) {
      extraAttributes.delete(attributeName);
      domElement = domElement.getAttribute(attributeName);
      if (null === domElement)
        switch (typeof value) {
          case "undefined":
          case "function":
          case "symbol":
          case "boolean":
            return;
        }
      else if (null != value)
        switch (typeof value) {
          case "function":
          case "symbol":
          case "boolean":
            break;
          default:
            if (
              (checkAttributeStringCoercion(value, propKey),
              domElement === "" + value)
            )
              return;
        }
      warnForPropDifference(propKey, domElement, value, serverDifferences);
    }
    function hydrateBooleanAttribute(
      domElement,
      propKey,
      attributeName,
      value,
      extraAttributes,
      serverDifferences
    ) {
      extraAttributes.delete(attributeName);
      domElement = domElement.getAttribute(attributeName);
      if (null === domElement) {
        switch (typeof value) {
          case "function":
          case "symbol":
            return;
        }
        if (!value) return;
      } else
        switch (typeof value) {
          case "function":
          case "symbol":
            break;
          default:
            if (value) return;
        }
      warnForPropDifference(propKey, domElement, value, serverDifferences);
    }
    function hydrateBooleanishAttribute(
      domElement,
      propKey,
      attributeName,
      value,
      extraAttributes,
      serverDifferences
    ) {
      extraAttributes.delete(attributeName);
      domElement = domElement.getAttribute(attributeName);
      if (null === domElement)
        switch (typeof value) {
          case "undefined":
          case "function":
          case "symbol":
            return;
        }
      else if (null != value)
        switch (typeof value) {
          case "function":
          case "symbol":
            break;
          default:
            if (
              (checkAttributeStringCoercion(value, attributeName),
              domElement === "" + value)
            )
              return;
        }
      warnForPropDifference(propKey, domElement, value, serverDifferences);
    }
    function hydrateNumericAttribute(
      domElement,
      propKey,
      attributeName,
      value,
      extraAttributes,
      serverDifferences
    ) {
      extraAttributes.delete(attributeName);
      domElement = domElement.getAttribute(attributeName);
      if (null === domElement)
        switch (typeof value) {
          case "undefined":
          case "function":
          case "symbol":
          case "boolean":
            return;
          default:
            if (isNaN(value)) return;
        }
      else if (null != value)
        switch (typeof value) {
          case "function":
          case "symbol":
          case "boolean":
            break;
          default:
            if (
              !isNaN(value) &&
              (checkAttributeStringCoercion(value, propKey),
              domElement === "" + value)
            )
              return;
        }
      warnForPropDifference(propKey, domElement, value, serverDifferences);
    }
    function hydrateSanitizedAttribute(
      domElement,
      propKey,
      attributeName,
      value,
      extraAttributes,
      serverDifferences
    ) {
      extraAttributes.delete(attributeName);
      domElement = domElement.getAttribute(attributeName);
      if (null === domElement)
        switch (typeof value) {
          case "undefined":
          case "function":
          case "symbol":
          case "boolean":
            return;
        }
      else if (null != value)
        switch (typeof value) {
          case "function":
          case "symbol":
          case "boolean":
            break;
          default:
            if (
              (checkAttributeStringCoercion(value, propKey),
              (attributeName = sanitizeURL("" + value)),
              domElement === attributeName)
            )
              return;
        }
      warnForPropDifference(propKey, domElement, value, serverDifferences);
    }
    function diffHydratedProperties(domElement, tag, props, hostContext) {
      for (
        var serverDifferences = {},
          extraAttributes = new Set(),
          attributes = domElement.attributes,
          i = 0;
        i < attributes.length;
        i++
      )
        switch (attributes[i].name.toLowerCase()) {
          case "value":
            break;
          case "checked":
            break;
          case "selected":
            break;
          case "vt-name":
          case "vt-update":
          case "vt-enter":
          case "vt-exit":
          case "vt-share":
            break;
          default:
            extraAttributes.add(attributes[i].name);
        }
      if (isCustomElement(tag))
        for (var propKey in props) {
          if (props.hasOwnProperty(propKey)) {
            var value = props[propKey];
            if (null != value)
              if (registrationNameDependencies.hasOwnProperty(propKey))
                "function" !== typeof value &&
                  warnForInvalidEventListener(propKey, value);
              else if (!0 !== props.suppressHydrationWarning)
                switch (propKey) {
                  case "children":
                    ("string" !== typeof value && "number" !== typeof value) ||
                      warnForPropDifference(
                        "children",
                        domElement.textContent,
                        value,
                        serverDifferences
                      );
                    continue;
                  case "suppressContentEditableWarning":
                  case "suppressHydrationWarning":
                  case "defaultValue":
                  case "defaultChecked":
                  case "innerHTML":
                  case "ref":
                    continue;
                  case "dangerouslySetInnerHTML":
                    var serverHTML = domElement.innerHTML;
                    value = value ? value.__html : void 0;
                    null != value &&
                      ((value = normalizeHTML(domElement, value)),
                      warnForPropDifference(
                        propKey,
                        serverHTML,
                        value,
                        serverDifferences
                      ));
                    continue;
                  case "style":
                    extraAttributes.delete(propKey);
                    diffHydratedStyles(domElement, value, serverDifferences);
                    continue;
                  case "offsetParent":
                  case "offsetTop":
                  case "offsetLeft":
                  case "offsetWidth":
                  case "offsetHeight":
                  case "isContentEditable":
                  case "outerText":
                  case "outerHTML":
                    extraAttributes.delete(propKey.toLowerCase());
                    console.error(
                      "Assignment to read-only property will result in a no-op: `%s`",
                      propKey
                    );
                    continue;
                  case "className":
                    extraAttributes.delete("class");
                    serverHTML = getValueForAttributeOnCustomComponent(
                      domElement,
                      "class",
                      value
                    );
                    warnForPropDifference(
                      "className",
                      serverHTML,
                      value,
                      serverDifferences
                    );
                    continue;
                  default:
                    hostContext.context === HostContextNamespaceNone &&
                    "svg" !== tag &&
                    "math" !== tag
                      ? extraAttributes.delete(propKey.toLowerCase())
                      : extraAttributes.delete(propKey),
                      (serverHTML = getValueForAttributeOnCustomComponent(
                        domElement,
                        propKey,
                        value
                      )),
                      warnForPropDifference(
                        propKey,
                        serverHTML,
                        value,
                        serverDifferences
                      );
                }
          }
        }
      else
        for (value in props)
          if (
            props.hasOwnProperty(value) &&
            ((propKey = props[value]), null != propKey)
          )
            if (registrationNameDependencies.hasOwnProperty(value))
              "function" !== typeof propKey &&
                warnForInvalidEventListener(value, propKey);
            else if (!0 !== props.suppressHydrationWarning)
              switch (value) {
                case "children":
                  ("string" !== typeof propKey &&
                    "number" !== typeof propKey) ||
                    warnForPropDifference(
                      "children",
                      domElement.textContent,
                      propKey,
                      serverDifferences
                    );
                  continue;
                case "suppressContentEditableWarning":
                case "suppressHydrationWarning":
                case "value":
                case "checked":
                case "selected":
                case "defaultValue":
                case "defaultChecked":
                case "innerHTML":
                case "ref":
                  continue;
                case "dangerouslySetInnerHTML":
                  attributes = domElement.innerHTML;
                  propKey = propKey ? propKey.__html : void 0;
                  null != propKey &&
                    ((propKey = normalizeHTML(domElement, propKey)),
                    attributes !== propKey &&
                      (serverDifferences[value] = { __html: attributes }));
                  continue;
                case "className":
                  hydrateAttribute(
                    domElement,
                    value,
                    "class",
                    propKey,
                    extraAttributes,
                    serverDifferences
                  );
                  continue;
                case "tabIndex":
                  hydrateAttribute(
                    domElement,
                    value,
                    "tabindex",
                    propKey,
                    extraAttributes,
                    serverDifferences
                  );
                  continue;
                case "style":
                  extraAttributes.delete(value);
                  diffHydratedStyles(domElement, propKey, serverDifferences);
                  continue;
                case "multiple":
                  extraAttributes.delete(value);
                  warnForPropDifference(
                    value,
                    domElement.multiple,
                    propKey,
                    serverDifferences
                  );
                  continue;
                case "muted":
                  extraAttributes.delete(value);
                  warnForPropDifference(
                    value,
                    domElement.muted,
                    propKey,
                    serverDifferences
                  );
                  continue;
                case "autoFocus":
                  extraAttributes.delete("autofocus");
                  warnForPropDifference(
                    value,
                    domElement.autofocus,
                    propKey,
                    serverDifferences
                  );
                  continue;
                case "data":
                  if ("object" !== tag) {
                    extraAttributes.delete(value);
                    attributes = domElement.getAttribute("data");
                    warnForPropDifference(
                      value,
                      attributes,
                      propKey,
                      serverDifferences
                    );
                    continue;
                  }
                case "src":
                  if ("object" === typeof propKey && null !== propKey)
                    if ("img" === tag || "video" === tag || "audio" === tag)
                      try {
                        URL.revokeObjectURL(URL.createObjectURL(propKey));
                        a: {
                          attributes = domElement;
                          i = propKey;
                          var serverDifferences$jscomp$0 = serverDifferences;
                          extraAttributes.delete("src");
                          serverHTML = attributes.getAttribute("src");
                          if (null != serverHTML && null != i) {
                            var size = i.size,
                              type = i.type;
                            if (
                              "number" === typeof size &&
                              "string" === typeof type &&
                              0 ===
                                serverHTML.indexOf("data:" + type + ";base64,")
                            ) {
                              var byteLength =
                                ((serverHTML.length - (5 + type.length + 8)) /
                                  4) *
                                3;
                              "=" === serverHTML[serverHTML.length - 1] &&
                                byteLength--;
                              "=" === serverHTML[serverHTML.length - 2] &&
                                byteLength--;
                              if (byteLength === size) break a;
                            }
                          }
                          warnForPropDifference(
                            "src",
                            serverHTML,
                            i,
                            serverDifferences$jscomp$0
                          );
                        }
                        continue;
                      } catch (x) {}
                    else
                      try {
                        URL.revokeObjectURL(URL.createObjectURL(propKey)),
                          "source" === tag
                            ? console.error(
                                "Passing Blob, MediaSource or MediaStream to <source src> is not supported. Pass it directly to <img src>, <video src> or <audio src> instead."
                              )
                            : console.error(
                                "Passing Blob, MediaSource or MediaStream to <%s src> is not supported.",
                                tag
                              );
                      } catch (x$11) {}
                case "href":
                  if (
                    !(
                      "" !== propKey ||
                      ("a" === tag && "href" === value) ||
                      ("object" === tag && "data" === value)
                    )
                  ) {
                    "src" === value
                      ? console.error(
                          'An empty string ("") was passed to the %s attribute. This may cause the browser to download the whole page again over the network. To fix this, either do not render the element at all or pass null to %s instead of an empty string.',
                          value,
                          value
                        )
                      : console.error(
                          'An empty string ("") was passed to the %s attribute. To fix this, either do not render the element at all or pass null to %s instead of an empty string.',
                          value,
                          value
                        );
                    continue;
                  }
                  hydrateSanitizedAttribute(
                    domElement,
                    value,
                    value,
                    propKey,
                    extraAttributes,
                    serverDifferences
                  );
                  continue;
                case "action":
                case "formAction":
                  attributes = domElement.getAttribute(value);
                  if ("function" === typeof propKey) {
                    extraAttributes.delete(value.toLowerCase());
                    "formAction" === value
                      ? (extraAttributes.delete("name"),
                        extraAttributes.delete("formenctype"),
                        extraAttributes.delete("formmethod"),
                        extraAttributes.delete("formtarget"))
                      : (extraAttributes.delete("enctype"),
                        extraAttributes.delete("method"),
                        extraAttributes.delete("target"));
                    continue;
                  } else if (attributes === EXPECTED_FORM_ACTION_URL) {
                    extraAttributes.delete(value.toLowerCase());
                    warnForPropDifference(
                      value,
                      "function",
                      propKey,
                      serverDifferences
                    );
                    continue;
                  }
                  hydrateSanitizedAttribute(
                    domElement,
                    value,
                    value.toLowerCase(),
                    propKey,
                    extraAttributes,
                    serverDifferences
                  );
                  continue;
                case "xlinkHref":
                  hydrateSanitizedAttribute(
                    domElement,
                    value,
                    "xlink:href",
                    propKey,
                    extraAttributes,
                    serverDifferences
                  );
                  continue;
                case "contentEditable":
                  hydrateBooleanishAttribute(
                    domElement,
                    value,
                    "contenteditable",
                    propKey,
                    extraAttributes,
                    serverDifferences
                  );
                  continue;
                case "spellCheck":
                  hydrateBooleanishAttribute(
                    domElement,
                    value,
                    "spellcheck",
                    propKey,
                    extraAttributes,
                    serverDifferences
                  );
                  continue;
                case "draggable":
                case "autoReverse":
                case "externalResourcesRequired":
                case "focusable":
                case "preserveAlpha":
                  hydrateBooleanishAttribute(
                    domElement,
                    value,
                    value,
                    propKey,
                    extraAttributes,
                    serverDifferences
                  );
                  continue;
                case "allowFullScreen":
                case "async":
                case "autoPlay":
                case "controls":
                case "default":
                case "defer":
                case "disabled":
                case "disablePictureInPicture":
                case "disableRemotePlayback":
                case "formNoValidate":
                case "hidden":
                case "loop":
                case "noModule":
                case "noValidate":
                case "open":
                case "playsInline":
                case "readOnly":
                case "required":
                case "reversed":
                case "scoped":
                case "seamless":
                case "itemScope":
                  hydrateBooleanAttribute(
                    domElement,
                    value,
                    value.toLowerCase(),
                    propKey,
                    extraAttributes,
                    serverDifferences
                  );
                  continue;
                case "capture":
                case "download":
                  a: {
                    i = domElement;
                    serverDifferences$jscomp$0 = attributes = value;
                    var serverDifferences$jscomp$1 = serverDifferences;
                    extraAttributes.delete(serverDifferences$jscomp$0);
                    i = i.getAttribute(serverDifferences$jscomp$0);
                    if (null === i)
                      switch (typeof propKey) {
                        case "undefined":
                        case "function":
                        case "symbol":
                          break a;
                        default:
                          if (!1 === propKey) break a;
                      }
                    else if (null != propKey)
                      switch (typeof propKey) {
                        case "function":
                        case "symbol":
                          break;
                        case "boolean":
                          if (!0 === propKey && "" === i) break a;
                          break;
                        default:
                          if (
                            (checkAttributeStringCoercion(propKey, attributes),
                            i === "" + propKey)
                          )
                            break a;
                      }
                    warnForPropDifference(
                      attributes,
                      i,
                      propKey,
                      serverDifferences$jscomp$1
                    );
                  }
                  continue;
                case "cols":
                case "rows":
                case "size":
                case "span":
                  a: {
                    i = domElement;
                    serverDifferences$jscomp$0 = attributes = value;
                    serverDifferences$jscomp$1 = serverDifferences;
                    extraAttributes.delete(serverDifferences$jscomp$0);
                    i = i.getAttribute(serverDifferences$jscomp$0);
                    if (null === i)
                      switch (typeof propKey) {
                        case "undefined":
                        case "function":
                        case "symbol":
                        case "boolean":
                          break a;
                        default:
                          if (isNaN(propKey) || 1 > propKey) break a;
                      }
                    else if (null != propKey)
                      switch (typeof propKey) {
                        case "function":
                        case "symbol":
                        case "boolean":
                          break;
                        default:
                          if (
                            !(isNaN(propKey) || 1 > propKey) &&
                            (checkAttributeStringCoercion(propKey, attributes),
                            i === "" + propKey)
                          )
                            break a;
                      }
                    warnForPropDifference(
                      attributes,
                      i,
                      propKey,
                      serverDifferences$jscomp$1
                    );
                  }
                  continue;
                case "rowSpan":
                  hydrateNumericAttribute(
                    domElement,
                    value,
                    "rowspan",
                    propKey,
                    extraAttributes,
                    serverDifferences
                  );
                  continue;
                case "start":
                  hydrateNumericAttribute(
                    domElement,
                    value,
                    value,
                    propKey,
                    extraAttributes,
                    serverDifferences
                  );
                  continue;
                case "xHeight":
                  hydrateAttribute(
                    domElement,
                    value,
                    "x-height",
                    propKey,
                    extraAttributes,
                    serverDifferences
                  );
                  continue;
                case "xlinkActuate":
                  hydrateAttribute(
                    domElement,
                    value,
                    "xlink:actuate",
                    propKey,
                    extraAttributes,
                    serverDifferences
                  );
                  continue;
                case "xlinkArcrole":
                  hydrateAttribute(
                    domElement,
                    value,
                    "xlink:arcrole",
                    propKey,
                    extraAttributes,
                    serverDifferences
                  );
                  continue;
                case "xlinkRole":
                  hydrateAttribute(
                    domElement,
                    value,
                    "xlink:role",
                    propKey,
                    extraAttributes,
                    serverDifferences
                  );
                  continue;
                case "xlinkShow":
                  hydrateAttribute(
                    domElement,
                    value,
                    "xlink:show",
                    propKey,
                    extraAttributes,
                    serverDifferences
                  );
                  continue;
                case "xlinkTitle":
                  hydrateAttribute(
                    domElement,
                    value,
                    "xlink:title",
                    propKey,
                    extraAttributes,
                    serverDifferences
                  );
                  continue;
                case "xlinkType":
                  hydrateAttribute(
                    domElement,
                    value,
                    "xlink:type",
                    propKey,
                    extraAttributes,
                    serverDifferences
                  );
                  continue;
                case "xmlBase":
                  hydrateAttribute(
                    domElement,
                    value,
                    "xml:base",
                    propKey,
                    extraAttributes,
                    serverDifferences
                  );
                  continue;
                case "xmlLang":
                  hydrateAttribute(
                    domElement,
                    value,
                    "xml:lang",
                    propKey,
                    extraAttributes,
                    serverDifferences
                  );
                  continue;
                case "xmlSpace":
                  hydrateAttribute(
                    domElement,
                    value,
                    "xml:space",
                    propKey,
                    extraAttributes,
                    serverDifferences
                  );
                  continue;
                case "inert":
                  "" !== propKey ||
                    didWarnForNewBooleanPropsWithEmptyValue[value] ||
                    ((didWarnForNewBooleanPropsWithEmptyValue[value] = !0),
                    console.error(
                      "Received an empty string for a boolean attribute `%s`. This will treat the attribute as if it were false. Either pass `false` to silence this warning, or pass `true` if you used an empty string in earlier versions of React to indicate this attribute is true.",
                      value
                    ));
                  hydrateBooleanAttribute(
                    domElement,
                    value,
                    value,
                    propKey,
                    extraAttributes,
                    serverDifferences
                  );
                  continue;
                default:
                  if (
                    !(2 < value.length) ||
                    ("o" !== value[0] && "O" !== value[0]) ||
                    ("n" !== value[1] && "N" !== value[1])
                  ) {
                    i = getAttributeAlias(value);
                    attributes = !1;
                    hostContext.context === HostContextNamespaceNone &&
                    "svg" !== tag &&
                    "math" !== tag
                      ? extraAttributes.delete(i.toLowerCase())
                      : ((serverDifferences$jscomp$0 = value.toLowerCase()),
                        (serverDifferences$jscomp$0 =
                          possibleStandardNames.hasOwnProperty(
                            serverDifferences$jscomp$0
                          )
                            ? possibleStandardNames[
                                serverDifferences$jscomp$0
                              ] || null
                            : null),
                        null !== serverDifferences$jscomp$0 &&
                          serverDifferences$jscomp$0 !== value &&
                          ((attributes = !0),
                          extraAttributes.delete(serverDifferences$jscomp$0)),
                        extraAttributes.delete(i));
                    a: if (
                      ((serverDifferences$jscomp$0 = domElement),
                      (serverDifferences$jscomp$1 = i),
                      (i = propKey),
                      isAttributeNameSafe(serverDifferences$jscomp$1))
                    )
                      if (
                        serverDifferences$jscomp$0.hasAttribute(
                          serverDifferences$jscomp$1
                        )
                      )
                        (serverDifferences$jscomp$0 =
                          serverDifferences$jscomp$0.getAttribute(
                            serverDifferences$jscomp$1
                          )),
                          checkAttributeStringCoercion(
                            i,
                            serverDifferences$jscomp$1
                          ),
                          (i =
                            serverDifferences$jscomp$0 === "" + i
                              ? i
                              : serverDifferences$jscomp$0);
                      else {
                        switch (typeof i) {
                          case "function":
                          case "symbol":
                            break a;
                          case "boolean":
                            if (
                              ((serverDifferences$jscomp$0 =
                                serverDifferences$jscomp$1
                                  .toLowerCase()
                                  .slice(0, 5)),
                              "data-" !== serverDifferences$jscomp$0 &&
                                "aria-" !== serverDifferences$jscomp$0)
                            )
                              break a;
                        }
                        i = void 0 === i ? void 0 : null;
                      }
                    else i = void 0;
                    attributes ||
                      warnForPropDifference(
                        value,
                        i,
                        propKey,
                        serverDifferences
                      );
                  }
              }
      0 < extraAttributes.size &&
        !0 !== props.suppressHydrationWarning &&
        warnForExtraAttributes(domElement, extraAttributes, serverDifferences);
      return 0 === Object.keys(serverDifferences).length
        ? null
        : serverDifferences;
    }
    function propNamesListJoin(list, combinator) {
      switch (list.length) {
        case 0:
          return "";
        case 1:
          return list[0];
        case 2:
          return list[0] + " " + combinator + " " + list[1];
        default:
          return (
            list.slice(0, -1).join(", ") +
            ", " +
            combinator +
            " " +
            list[list.length - 1]
          );
      }
    }
    function getOwnerDocumentFromRootContainer(rootContainerElement) {
      return 9 === rootContainerElement.nodeType
        ? rootContainerElement
        : rootContainerElement.ownerDocument;
    }
    function getOwnHostContext(namespaceURI) {
      switch (namespaceURI) {
        case SVG_NAMESPACE:
          return HostContextNamespaceSvg;
        case MATH_NAMESPACE:
          return HostContextNamespaceMath;
        default:
          return HostContextNamespaceNone;
      }
    }
    function getChildHostContextProd(parentNamespace, type) {
      if (parentNamespace === HostContextNamespaceNone)
        switch (type) {
          case "svg":
            return HostContextNamespaceSvg;
          case "math":
            return HostContextNamespaceMath;
          default:
            return HostContextNamespaceNone;
        }
      return parentNamespace === HostContextNamespaceSvg &&
        "foreignObject" === type
        ? HostContextNamespaceNone
        : parentNamespace;
    }
    function shouldSetTextContent(type, props) {
      return (
        "textarea" === type ||
        "noscript" === type ||
        "string" === typeof props.children ||
        "number" === typeof props.children ||
        "bigint" === typeof props.children ||
        ("object" === typeof props.dangerouslySetInnerHTML &&
          null !== props.dangerouslySetInnerHTML &&
          null != props.dangerouslySetInnerHTML.__html)
      );
    }
    function shouldAttemptEagerTransition() {
      var event = window.event;
      if (event && "popstate" === event.type) {
        if (event === currentPopstateTransitionEvent) return !1;
        currentPopstateTransitionEvent = event;
        return !0;
      }
      currentPopstateTransitionEvent = null;
      return !1;
    }
    function resolveEventType() {
      var event = window.event;
      return event && event !== schedulerEvent ? event.type : null;
    }
    function resolveEventTimeStamp() {
      var event = window.event;
      return event && event !== schedulerEvent ? event.timeStamp : -1.1;
    }
    function handleErrorInNextTick(error) {
      setTimeout(function () {
        throw error;
      });
    }
    function commitMount(domElement, type, newProps) {
      switch (type) {
        case "button":
        case "input":
        case "select":
        case "textarea":
          newProps.autoFocus && domElement.focus();
          break;
        case "img":
          if (newProps.src) {
            newProps = newProps.src;
            if ("object" === typeof newProps)
              try {
                setSrcObject(domElement, type, newProps);
                break;
              } catch (x) {}
            domElement.src = newProps;
          } else newProps.srcSet && (domElement.srcset = newProps.srcSet);
      }
    }
    function commitHydratedInstance(domElement, type, props) {
      switch (type) {
        case "input":
          var value = props.value,
            defaultValue = props.defaultValue;
          type = props.checked;
          props = props.defaultChecked;
          defaultValue =
            null != defaultValue ? "" + getToStringValue(defaultValue) : "";
          value = null != value ? "" + getToStringValue(value) : defaultValue;
          type = null != type ? type : props;
          domElement.checked = domElement.checked;
          trackHydrated(
            domElement,
            value,
            "function" !== typeof type && "symbol" !== typeof type && !!type
          ) &&
            ("radio" !== domElement.type || domElement.checked) &&
            queueChangeEvent(domElement);
          break;
        case "select":
          value = props.value;
          type = domElement.options;
          defaultValue = null != value ? value : props.defaultValue;
          value = !1;
          if (props.multiple) {
            props = {};
            if (null != defaultValue)
              for (var i = 0; i < defaultValue.length; i++)
                props["$" + defaultValue[i]] = !0;
            for (defaultValue = 0; defaultValue < type.length; defaultValue++)
              if (
                ((i = props.hasOwnProperty("$" + type[defaultValue].value)),
                type[defaultValue].selected !== i)
              ) {
                value = !0;
                break;
              }
          } else
            for (
              props =
                null == defaultValue
                  ? null
                  : "" + getToStringValue(defaultValue),
                defaultValue = 0;
              defaultValue < type.length;
              defaultValue++
            )
              if (
                (null != props ||
                  type[defaultValue].disabled ||
                  (props = type[defaultValue].value),
                type[defaultValue].selected !==
                  (type[defaultValue].value === props))
              ) {
                value = !0;
                break;
              }
          value && queueChangeEvent(domElement);
          break;
        case "textarea":
          (type = props.defaultValue),
            (props = props.value),
            null == props && (null == type && (type = ""), (props = type)),
            (type = "" + getToStringValue(props)),
            trackHydrated(domElement, type, !1) && queueChangeEvent(domElement);
      }
    }
    function commitUpdate(domElement, type, oldProps, newProps) {
      updateProperties(domElement, type, oldProps, newProps);
      domElement[internalPropsKey] = newProps;
    }
    function resetTextContent(domElement) {
      setTextContent(domElement, "");
    }
    function commitTextUpdate(textInstance, oldText, newText) {
      textInstance.nodeValue = newText;
    }
    function warnForReactChildrenConflict(container) {
      if (!container.__reactWarnedAboutChildrenConflict) {
        var props = container[internalPropsKey] || null;
        if (null !== props) {
          var fiber = getInstanceFromNode(container);
          null !== fiber &&
            ("string" === typeof props.children ||
            "number" === typeof props.children
              ? ((container.__reactWarnedAboutChildrenConflict = !0),
                runWithFiberInDEV(fiber, function () {
                  console.error(
                    'Cannot use a ref on a React element as a container to `createRoot` or `createPortal` if that element also sets "children" text content using React. It should be a leaf with no children. Otherwise it\'s ambiguous which children should be used.'
                  );
                }))
              : null != props.dangerouslySetInnerHTML &&
                ((container.__reactWarnedAboutChildrenConflict = !0),
                runWithFiberInDEV(fiber, function () {
                  console.error(
                    'Cannot use a ref on a React element as a container to `createRoot` or `createPortal` if that element also sets "dangerouslySetInnerHTML" using React. It should be a leaf with no children. Otherwise it\'s ambiguous which children should be used.'
                  );
                })));
        }
      }
    }
    function isSingletonScope(type) {
      return "head" === type;
    }
    function removeChild(parentInstance, child) {
      parentInstance.removeChild(child);
    }
    function removeChildFromContainer(container, child) {
      (9 === container.nodeType
        ? container.body
        : "HTML" === container.nodeName
          ? container.ownerDocument.body
          : container
      ).removeChild(child);
    }
    function clearHydrationBoundary(parentInstance, hydrationInstance) {
      var node = hydrationInstance,
        depth = 0;
      do {
        var nextNode = node.nextSibling;
        parentInstance.removeChild(node);
        if (nextNode && 8 === nextNode.nodeType)
          if (
            ((node = nextNode.data),
            node === SUSPENSE_END_DATA || node === ACTIVITY_END_DATA)
          ) {
            if (0 === depth) {
              parentInstance.removeChild(nextNode);
              retryIfBlockedOn(hydrationInstance);
              return;
            }
            depth--;
          } else if (
            node === SUSPENSE_START_DATA ||
            node === SUSPENSE_PENDING_START_DATA ||
            node === SUSPENSE_QUEUED_START_DATA ||
            node === SUSPENSE_FALLBACK_START_DATA ||
            node === ACTIVITY_START_DATA
          )
            depth++;
          else if (node === PREAMBLE_CONTRIBUTION_HTML)
            releaseSingletonInstance(
              parentInstance.ownerDocument.documentElement
            );
          else if (node === PREAMBLE_CONTRIBUTION_HEAD) {
            node = parentInstance.ownerDocument.head;
            releaseSingletonInstance(node);
            for (var node$jscomp$0 = node.firstChild; node$jscomp$0; ) {
              var nextNode$jscomp$0 = node$jscomp$0.nextSibling,
                nodeName = node$jscomp$0.nodeName;
              node$jscomp$0[internalHoistableMarker] ||
                "SCRIPT" === nodeName ||
                "STYLE" === nodeName ||
                ("LINK" === nodeName &&
                  "stylesheet" === node$jscomp$0.rel.toLowerCase()) ||
                node.removeChild(node$jscomp$0);
              node$jscomp$0 = nextNode$jscomp$0;
            }
          } else
            node === PREAMBLE_CONTRIBUTION_BODY &&
              releaseSingletonInstance(parentInstance.ownerDocument.body);
        node = nextNode;
      } while (node);
      retryIfBlockedOn(hydrationInstance);
    }
    function hideOrUnhideDehydratedBoundary(suspenseInstance, isHidden) {
      var node = suspenseInstance;
      suspenseInstance = 0;
      do {
        var nextNode = node.nextSibling;
        1 === node.nodeType
          ? isHidden
            ? ((node._stashedDisplay = node.style.display),
              (node.style.display = "none"))
            : ((node.style.display = node._stashedDisplay || ""),
              "" === node.getAttribute("style") &&
                node.removeAttribute("style"))
          : 3 === node.nodeType &&
            (isHidden
              ? ((node._stashedText = node.nodeValue), (node.nodeValue = ""))
              : (node.nodeValue = node._stashedText || ""));
        if (nextNode && 8 === nextNode.nodeType)
          if (((node = nextNode.data), node === SUSPENSE_END_DATA))
            if (0 === suspenseInstance) break;
            else suspenseInstance--;
          else
            (node !== SUSPENSE_START_DATA &&
              node !== SUSPENSE_PENDING_START_DATA &&
              node !== SUSPENSE_QUEUED_START_DATA &&
              node !== SUSPENSE_FALLBACK_START_DATA) ||
              suspenseInstance++;
        node = nextNode;
      } while (node);
    }
    function hideDehydratedBoundary(suspenseInstance) {
      hideOrUnhideDehydratedBoundary(suspenseInstance, !0);
    }
    function hideInstance(instance) {
      instance = instance.style;
      "function" === typeof instance.setProperty
        ? instance.setProperty("display", "none", "important")
        : (instance.display = "none");
    }
    function hideTextInstance(textInstance) {
      textInstance.nodeValue = "";
    }
    function unhideDehydratedBoundary(dehydratedInstance) {
      hideOrUnhideDehydratedBoundary(dehydratedInstance, !1);
    }
    function unhideInstance(instance, props) {
      props = props[STYLE];
      props =
        void 0 !== props && null !== props && props.hasOwnProperty("display")
          ? props.display
          : null;
      instance.style.display =
        null == props || "boolean" === typeof props ? "" : ("" + props).trim();
    }
    function unhideTextInstance(textInstance, text) {
      textInstance.nodeValue = text;
    }
    function applyViewTransitionName(instance, name, className) {
      instance.style.viewTransitionName = name;
      null != className && (instance.style.viewTransitionClass = className);
      name = getComputedStyle(instance);
      if ("inline" === name.display) {
        className = instance.getClientRects();
        if (1 === className.length) var JSCompiler_inline_result = 1;
        else
          for (
            var i = (JSCompiler_inline_result = 0);
            i < className.length;
            i++
          ) {
            var rect = className[i];
            0 < rect.width && 0 < rect.height && JSCompiler_inline_result++;
          }
        if (1 === JSCompiler_inline_result)
          (instance = instance.style),
            (instance.display =
              1 === className.length ? "inline-block" : "block"),
            (instance.marginTop = "-" + name.paddingTop),
            (instance.marginBottom = "-" + name.paddingBottom);
        else
          for (name = instance.firstChild; null != name; ) {
            if (
              1 === name.nodeType &&
              "block" === getComputedStyle(name).display
            ) {
              console.error(
                "You're about to start a <ViewTransition> around a display: inline element <%s>, which itself has a display: block element <%s> inside it. This might trigger a bug in Safari which causes the View Transition to be skipped with a duplicate name error.\nhttps://bugs.webkit.org/show_bug.cgi?id=290923",
                instance.tagName.toLocaleLowerCase(),
                name.tagName.toLocaleLowerCase()
              );
              break;
            }
            if (null != name.firstChild) name = name.firstChild;
            else {
              if (name === instance) break;
              for (
                ;
                null == name.nextSibling &&
                null != name.parentNode &&
                name.parentNode !== instance;

              )
                name = name.parentNode;
              name = name.nextSibling;
            }
          }
      }
    }
    function restoreViewTransitionName(instance, props) {
      instance = instance.style;
      props = props[STYLE];
      var viewTransitionName =
        null != props
          ? props.hasOwnProperty("viewTransitionName")
            ? props.viewTransitionName
            : props.hasOwnProperty("view-transition-name")
              ? props["view-transition-name"]
              : null
          : null;
      instance.viewTransitionName =
        null == viewTransitionName || "boolean" === typeof viewTransitionName
          ? ""
          : ("" + viewTransitionName).trim();
      viewTransitionName =
        null != props
          ? props.hasOwnProperty("viewTransitionClass")
            ? props.viewTransitionClass
            : props.hasOwnProperty("view-transition-class")
              ? props["view-transition-class"]
              : null
          : null;
      instance.viewTransitionClass =
        null == viewTransitionName || "boolean" === typeof viewTransitionName
          ? ""
          : ("" + viewTransitionName).trim();
      "inline-block" === instance.display &&
        (null == props
          ? (instance.display = instance.margin = "")
          : ((viewTransitionName = props.display),
            (instance.display =
              null == viewTransitionName ||
              "boolean" === typeof viewTransitionName
                ? ""
                : viewTransitionName),
            (viewTransitionName = props.margin),
            null != viewTransitionName
              ? (instance.margin = viewTransitionName)
              : ((viewTransitionName = props.hasOwnProperty("marginTop")
                  ? props.marginTop
                  : props["margin-top"]),
                (instance.marginTop =
                  null == viewTransitionName ||
                  "boolean" === typeof viewTransitionName
                    ? ""
                    : viewTransitionName),
                (props = props.hasOwnProperty("marginBottom")
                  ? props.marginBottom
                  : props["margin-bottom"]),
                (instance.marginBottom =
                  null == props || "boolean" === typeof props ? "" : props))));
    }
    function cancelViewTransitionName(instance, oldName, props) {
      restoreViewTransitionName(instance, props);
      instance = instance.ownerDocument.documentElement;
      null !== instance &&
        instance.animate(
          { opacity: [0, 0], pointerEvents: ["none", "none"] },
          {
            duration: 0,
            fill: "forwards",
            pseudoElement: "::view-transition-group(" + oldName + ")"
          }
        );
    }
    function cancelRootViewTransitionName(rootContainer) {
      rootContainer =
        9 === rootContainer.nodeType
          ? rootContainer.documentElement
          : rootContainer.ownerDocument.documentElement;
      null !== rootContainer &&
        "" === rootContainer.style.viewTransitionName &&
        ((rootContainer.style.viewTransitionName = "none"),
        rootContainer.animate(
          { opacity: [0, 0], pointerEvents: ["none", "none"] },
          {
            duration: 0,
            fill: "forwards",
            pseudoElement: "::view-transition-group(root)"
          }
        ),
        rootContainer.animate(
          { width: [0, 0], height: [0, 0] },
          { duration: 0, fill: "forwards", pseudoElement: "::view-transition" }
        ));
    }
    function restoreRootViewTransitionName(rootContainer) {
      rootContainer =
        9 === rootContainer.nodeType
          ? rootContainer.body
          : "HTML" === rootContainer.nodeName
            ? rootContainer.ownerDocument.body
            : rootContainer;
      "root" === rootContainer.style.viewTransitionName &&
        (rootContainer.style.viewTransitionName = "");
      rootContainer = rootContainer.ownerDocument.documentElement;
      null !== rootContainer &&
        "none" === rootContainer.style.viewTransitionName &&
        (rootContainer.style.viewTransitionName = "");
    }
    function createMeasurement(rect, computedStyle, element) {
      element = element.ownerDocument.defaultView;
      return {
        rect: rect,
        abs:
          "absolute" === computedStyle.position ||
          "fixed" === computedStyle.position,
        clip:
          "none" !== computedStyle.clipPath ||
          "visible" !== computedStyle.overflow ||
          "none" !== computedStyle.filter ||
          "none" !== computedStyle.mask ||
          "none" !== computedStyle.mask ||
          "0px" !== computedStyle.borderRadius,
        view:
          0 <= rect.bottom &&
          0 <= rect.right &&
          rect.top <= element.innerHeight &&
          rect.left <= element.innerWidth
      };
    }
    function measureInstance(instance) {
      var rect = instance.getBoundingClientRect(),
        computedStyle = getComputedStyle(instance);
      return createMeasurement(rect, computedStyle, instance);
    }
    function measureClonedInstance(instance) {
      var measuredRect = instance.getBoundingClientRect();
      measuredRect = new DOMRect(
        measuredRect.x + 2e4,
        measuredRect.y + 2e4,
        measuredRect.width,
        measuredRect.height
      );
      var computedStyle = getComputedStyle(instance);
      return createMeasurement(measuredRect, computedStyle, instance);
    }
    function cancelAllViewTransitionAnimations(scope) {
      for (
        var animations = scope.getAnimations({ subtree: !0 }), i = 0;
        i < animations.length;
        i++
      ) {
        var anim = animations[i],
          effect = anim.effect,
          pseudo = effect.pseudoElement;
        null != pseudo &&
          pseudo.startsWith("::view-transition") &&
          effect.target === scope &&
          anim.cancel();
      }
    }
    function customizeViewTransitionError(error, ignoreAbort) {
      if ("object" === typeof error && null !== error)
        switch (error.name) {
          case "TimeoutError":
            return Error(
              "A ViewTransition timed out because a Navigation stalled. This can happen if a Navigation is blocked on React itself. Such as if it's resolved inside useEffect. This can be solved by moving the resolution to useLayoutEffect.",
              { cause: error }
            );
          case "AbortError":
            return ignoreAbort
              ? null
              : Error(
                  "A ViewTransition was aborted early. This might be because you have other View Transition libraries on the page and only one can run at a time. To avoid this, use only React's built-in <ViewTransition> to coordinate.",
                  { cause: error }
                );
          case "InvalidStateError":
            if (
              "View transition was skipped because document visibility state is hidden." ===
                error.message ||
              "Skipping view transition because document visibility state has become hidden." ===
                error.message ||
              "Skipping view transition because viewport size changed." ===
                error.message
            )
              return null;
            if (
              "Transition was aborted because of invalid state" ===
              error.message
            )
              return Error(
                "A ViewTransition could not start. See the console for more details.",
                { cause: error }
              );
        }
      return error;
    }
    function forceLayout(ownerDocument) {
      return ownerDocument.documentElement.clientHeight;
    }
    function startViewTransition(
      rootContainer,
      transitionTypes,
      mutationCallback,
      layoutCallback,
      afterMutationCallback,
      spawnedWorkCallback,
      passiveCallback,
      errorCallback
    ) {
      var ownerDocument =
        9 === rootContainer.nodeType
          ? rootContainer
          : rootContainer.ownerDocument;
      try {
        var transition = ownerDocument.startViewTransition({
          update: function () {
            var ownerWindow = ownerDocument.defaultView;
            ownerWindow =
              ownerWindow.navigation && ownerWindow.navigation.transition;
            var previousFontLoadingStatus = ownerDocument.fonts.status;
            mutationCallback();
            if (
              "loaded" === previousFontLoadingStatus &&
              (forceLayout(ownerDocument),
              "loading" === ownerDocument.fonts.status)
            )
              return (
                (previousFontLoadingStatus = Promise.race([
                  ownerDocument.fonts.ready,
                  new Promise(function (resolve) {
                    return setTimeout(resolve, SUSPENSEY_FONT_TIMEOUT);
                  })
                ]).then(layoutCallback, layoutCallback)),
                (ownerWindow
                  ? Promise.allSettled([
                      ownerWindow.finished,
                      previousFontLoadingStatus
                    ])
                  : previousFontLoadingStatus
                ).then(afterMutationCallback, afterMutationCallback)
              );
            layoutCallback();
            if (ownerWindow)
              return ownerWindow.finished.then(
                afterMutationCallback,
                afterMutationCallback
              );
            afterMutationCallback();
          },
          types: transitionTypes
        });
        ownerDocument.__reactViewTransition = transition;
        transition.ready.then(
          function () {
            for (
              var animations = ownerDocument.documentElement.getAnimations({
                  subtree: !0
                }),
                i = 0;
              i < animations.length;
              i++
            ) {
              var effect = animations[i].effect,
                pseudoElement = effect.pseudoElement;
              if (
                null != pseudoElement &&
                pseudoElement.startsWith("::view-transition")
              ) {
                pseudoElement = effect.getKeyframes();
                for (
                  var width = void 0,
                    height = void 0,
                    unchangedDimensions = !0,
                    j = 0;
                  j < pseudoElement.length;
                  j++
                ) {
                  var keyframe = pseudoElement[j],
                    w = keyframe.width;
                  if (void 0 === width) width = w;
                  else if (width !== w) {
                    unchangedDimensions = !1;
                    break;
                  }
                  w = keyframe.height;
                  if (void 0 === height) height = w;
                  else if (height !== w) {
                    unchangedDimensions = !1;
                    break;
                  }
                  delete keyframe.width;
                  delete keyframe.height;
                  "none" === keyframe.transform && delete keyframe.transform;
                }
                unchangedDimensions &&
                  void 0 !== width &&
                  void 0 !== height &&
                  (effect.setKeyframes(pseudoElement),
                  (unchangedDimensions = getComputedStyle(
                    effect.target,
                    effect.pseudoElement
                  )),
                  unchangedDimensions.width !== width ||
                    unchangedDimensions.height !== height) &&
                  ((unchangedDimensions = pseudoElement[0]),
                  (unchangedDimensions.width = width),
                  (unchangedDimensions.height = height),
                  (unchangedDimensions =
                    pseudoElement[pseudoElement.length - 1]),
                  (unchangedDimensions.width = width),
                  (unchangedDimensions.height = height),
                  effect.setKeyframes(pseudoElement));
              }
            }
            spawnedWorkCallback();
          },
          function (error) {
            try {
              (error = customizeViewTransitionError(error, !1)),
                null !== error && errorCallback(error);
            } finally {
              mutationCallback(), layoutCallback(), spawnedWorkCallback();
            }
          }
        );
        transition.finished.finally(function () {
          cancelAllViewTransitionAnimations(ownerDocument.documentElement);
          ownerDocument.__reactViewTransition === transition &&
            (ownerDocument.__reactViewTransition = null);
          passiveCallback();
        });
        return transition;
      } catch (x) {
        return (
          mutationCallback(), layoutCallback(), spawnedWorkCallback(), null
        );
      }
    }
    function mergeTranslate(translateA, translateB) {
      if (!translateA || "none" === translateA) return translateB || "";
      if (!translateB || "none" === translateB) return translateA || "";
      translateA = translateA.split(" ");
      translateB = translateB.split(" ");
      var i,
        result = "";
      for (i = 0; i < translateA.length && i < translateB.length; i++)
        0 < i && (result += " "),
          (result += "calc(" + translateA[i] + " + " + translateB[i] + ")");
      for (; i < translateA.length; i++) result += " " + translateA[i];
      for (; i < translateB.length; i++) result += " " + translateB[i];
      return result;
    }
    function animateGesture(
      keyframes,
      targetElement,
      pseudoElement,
      timeline,
      customTimelineCleanup,
      rangeStart,
      rangeEnd,
      moveFirstFrameIntoViewport,
      moveAllFramesIntoViewport
    ) {
      for (
        var width, height, unchangedDimensions = !0, i = 0;
        i < keyframes.length;
        i++
      ) {
        var keyframe = keyframes[i];
        delete keyframe.easing;
        delete keyframe.computedOffset;
        var w = keyframe.width;
        void 0 === width
          ? (width = w)
          : width !== w && (unchangedDimensions = !1);
        w = keyframe.height;
        void 0 === height
          ? (height = w)
          : height !== w && (unchangedDimensions = !1);
        "auto" === keyframe.width && delete keyframe.width;
        "auto" === keyframe.height && delete keyframe.height;
        "none" === keyframe.transform && delete keyframe.transform;
        moveAllFramesIntoViewport &&
          null == keyframe.transform &&
          (null == keyframe.translate || "" === keyframe.translate
            ? ((w = getComputedStyle(targetElement, pseudoElement).translate),
              (keyframe.translate = mergeTranslate(w, "20000px 20000px")))
            : (keyframe.translate = mergeTranslate(
                keyframe.translate,
                "20000px 20000px"
              )));
      }
      moveFirstFrameIntoViewport &&
        ((moveFirstFrameIntoViewport = keyframes[0]),
        (moveAllFramesIntoViewport = moveFirstFrameIntoViewport.transform),
        null != moveAllFramesIntoViewport &&
          (moveFirstFrameIntoViewport.transform =
            "translate(20000px, 20000px) " +
            ("none" === moveAllFramesIntoViewport
              ? ""
              : moveAllFramesIntoViewport)));
      if (
        unchangedDimensions &&
        void 0 !== width &&
        void 0 !== height &&
        ((unchangedDimensions = getComputedStyle(targetElement, pseudoElement)),
        unchangedDimensions.width === width &&
          unchangedDimensions.height === height)
      )
        for (width = 0; width < keyframes.length; width++)
          (height = keyframes[width]),
            delete height.width,
            delete height.height;
      width = rangeStart > rangeEnd;
      timeline instanceof AnimationTimeline
        ? targetElement.animate(keyframes, {
            pseudoElement: pseudoElement,
            timeline: timeline,
            easing: "linear",
            fill: "both",
            direction: width ? "normal" : "reverse",
            rangeStart: (width ? rangeEnd : rangeStart) + "%",
            rangeEnd: (width ? rangeStart : rangeEnd) + "%"
          })
        : ((keyframes = targetElement.animate(keyframes, {
            pseudoElement: pseudoElement,
            easing: "linear",
            fill: "both",
            direction: width ? "normal" : "reverse",
            delay: width ? rangeEnd : rangeStart,
            duration: width ? rangeStart - rangeEnd : rangeEnd - rangeStart
          })),
          (timeline = timeline.animate(keyframes)) &&
            customTimelineCleanup.push(timeline));
    }
    function startGestureTransition(
      rootContainer,
      timeline,
      rangeStart,
      rangeEnd,
      transitionTypes,
      mutationCallback,
      animateCallback,
      errorCallback
    ) {
      var ownerDocument =
        9 === rootContainer.nodeType
          ? rootContainer
          : rootContainer.ownerDocument;
      try {
        forceLayout(ownerDocument);
        var transition = ownerDocument.startViewTransition({
          update: mutationCallback,
          types: transitionTypes
        });
        ownerDocument.__reactViewTransition = transition;
        var customTimelineCleanup = [],
          readyCallback = function () {
            for (
              var documentElement = ownerDocument.documentElement,
                animations = documentElement.getAnimations({ subtree: !0 }),
                foundGroups = new Set(),
                foundNews = new Set(),
                longestDuration = 0,
                i = 0;
              i < animations.length;
              i++
            ) {
              var effect = animations[i].effect,
                pseudoElement = effect.pseudoElement;
              null != pseudoElement &&
                pseudoElement.startsWith("::view-transition") &&
                ((effect = effect.getTiming()),
                (effect =
                  effect.delay +
                  ("number" === typeof effect.duration ? effect.duration : 0)),
                effect > longestDuration && (longestDuration = effect),
                pseudoElement.startsWith("::view-transition-group")
                  ? foundGroups.add(pseudoElement.slice(23))
                  : pseudoElement.startsWith("::view-transition-new") &&
                    foundNews.add(pseudoElement.slice(21)));
            }
            longestDuration = (rangeEnd - rangeStart) / longestDuration;
            for (i = 0; i < animations.length; i++) {
              var anim = animations[i];
              if (
                "running" === anim.playState &&
                ((pseudoElement = anim.effect),
                (effect = pseudoElement.pseudoElement),
                null != effect &&
                  effect.startsWith("::view-transition") &&
                  pseudoElement.target === documentElement)
              ) {
                anim.cancel();
                var isGeneratedGroupAnim = !1,
                  isExitGroupAnim = !1;
                if (effect.startsWith("::view-transition-group")) {
                  var groupName = effect.slice(23);
                  foundNews.has(groupName)
                    ? ((isGeneratedGroupAnim = anim.animationName),
                      (isGeneratedGroupAnim =
                        null != isGeneratedGroupAnim &&
                        isGeneratedGroupAnim.startsWith(
                          "-ua-view-transition-group-anim-"
                        )))
                    : (isExitGroupAnim = !0);
                }
                var _timing = pseudoElement.getTiming();
                anim =
                  rangeEnd -
                  (("number" === typeof _timing.duration
                    ? _timing.duration
                    : 0) +
                    _timing.delay) *
                    longestDuration;
                groupName = rangeEnd - _timing.delay * longestDuration;
                if (
                  "reverse" === _timing.direction ||
                  "alternate-reverse" === _timing.direction
                )
                  (_timing = anim), (anim = groupName), (groupName = _timing);
                animateGesture(
                  pseudoElement.getKeyframes(),
                  pseudoElement.target,
                  effect,
                  timeline,
                  customTimelineCleanup,
                  anim,
                  groupName,
                  isGeneratedGroupAnim,
                  isExitGroupAnim
                );
                effect.startsWith("::view-transition-old") &&
                  ((effect = effect.slice(21)),
                  foundGroups.has(effect) ||
                    foundNews.has(effect) ||
                    (foundGroups.add(effect),
                    animateGesture(
                      [{}, {}],
                      pseudoElement.target,
                      "::view-transition-group" + effect,
                      timeline,
                      customTimelineCleanup,
                      rangeStart,
                      rangeEnd,
                      !1,
                      !0
                    )));
              }
            }
            documentElement
              .animate([{}, {}], {
                pseudoElement: "::view-transition",
                duration: 1
              })
              .pause();
            animateCallback();
          },
          readyForAnimations =
            -1 !== navigator.userAgent.indexOf("Chrome")
              ? function () {
                  return requestAnimationFrame(readyCallback);
                }
              : readyCallback;
        transition.ready.then(readyForAnimations, function (error) {
          try {
            (error = customizeViewTransitionError(error, !0)),
              null !== error && errorCallback(error);
          } finally {
            mutationCallback(), animateCallback();
          }
        });
        transition.finished.finally(function () {
          cancelAllViewTransitionAnimations(ownerDocument.documentElement);
          for (var i = 0; i < customTimelineCleanup.length; i++)
            (0, customTimelineCleanup[i])();
          ownerDocument.__reactViewTransition === transition &&
            (ownerDocument.__reactViewTransition = null);
        });
        return transition;
      } catch (x) {
        return mutationCallback(), animateCallback(), null;
      }
    }
    function ViewTransitionPseudoElement(pseudo, name) {
      this._scope = document.documentElement;
      this._selector = "::view-transition-" + pseudo + "(" + name + ")";
    }
    function createViewTransitionInstance(name) {
      return {
        name: name,
        group: new ViewTransitionPseudoElement("group", name),
        imagePair: new ViewTransitionPseudoElement("image-pair", name),
        old: new ViewTransitionPseudoElement("old", name),
        new: new ViewTransitionPseudoElement("new", name)
      };
    }
    function FragmentInstance(fragmentFiber) {
      this._fragmentFiber = fragmentFiber;
      this._observers = this._eventListeners = null;
    }
    function addEventListenerToChild(
      child,
      type,
      listener,
      optionsOrUseCapture
    ) {
      getInstanceFromHostFiber(child).addEventListener(
        type,
        listener,
        optionsOrUseCapture
      );
      return !1;
    }
    function removeEventListenerFromChild(
      child,
      type,
      listener,
      optionsOrUseCapture
    ) {
      getInstanceFromHostFiber(child).removeEventListener(
        type,
        listener,
        optionsOrUseCapture
      );
      return !1;
    }
    function setFocusOnFiberIfFocusable(fiber, focusOptions) {
      fiber = getInstanceFromHostFiber(fiber);
      return setFocusIfFocusable(fiber, focusOptions);
    }
    function collectChildren(child, collection) {
      collection.push(child);
      return !1;
    }
    function blurActiveElementWithinFragment(child) {
      child = getInstanceFromHostFiber(child);
      return child === child.ownerDocument.activeElement
        ? (child.blur(), !0)
        : !1;
    }
    function observeChild(child, observer) {
      child = getInstanceFromHostFiber(child);
      observer.observe(child);
      return !1;
    }
    function unobserveChild(child, observer) {
      child = getInstanceFromHostFiber(child);
      observer.unobserve(child);
      return !1;
    }
    function collectClientRects(child, rects) {
      child = getInstanceFromHostFiber(child);
      rects.push.apply(rects, child.getClientRects());
      return !1;
    }
    function validateDocumentPositionWithFiberTree(
      documentPosition,
      fragmentFiber,
      precedingBoundaryFiber,
      followingBoundaryFiber,
      otherNode
    ) {
      var otherFiber = getClosestInstanceFromNode(otherNode);
      return documentPosition & Node.DOCUMENT_POSITION_CONTAINED_BY
        ? !!otherFiber && isFiberContainedBy(fragmentFiber, otherFiber)
        : documentPosition & Node.DOCUMENT_POSITION_CONTAINS
          ? null === otherFiber
            ? ((otherFiber = otherNode.ownerDocument),
              otherNode === otherFiber || otherNode === otherFiber.body)
            : isFiberContainedBy(otherFiber, fragmentFiber)
          : documentPosition & Node.DOCUMENT_POSITION_PRECEDING
            ? ((followingBoundaryFiber = !!otherFiber) &&
                !(followingBoundaryFiber =
                  otherFiber === precedingBoundaryFiber) &&
                ((followingBoundaryFiber = getLowestCommonAncestor(
                  precedingBoundaryFiber,
                  otherFiber,
                  getParentForFragmentAncestors
                )),
                null === followingBoundaryFiber
                  ? (followingBoundaryFiber = !1)
                  : (traverseVisibleHostChildren(
                      followingBoundaryFiber,
                      !0,
                      isFiberPrecedingCheck,
                      otherFiber,
                      precedingBoundaryFiber
                    ),
                    (otherFiber = searchTarget),
                    (searchTarget = null),
                    (followingBoundaryFiber = null !== otherFiber))),
              followingBoundaryFiber)
            : documentPosition & Node.DOCUMENT_POSITION_FOLLOWING
              ? ((precedingBoundaryFiber = !!otherFiber) &&
                  !(precedingBoundaryFiber =
                    otherFiber === followingBoundaryFiber) &&
                  ((precedingBoundaryFiber = getLowestCommonAncestor(
                    followingBoundaryFiber,
                    otherFiber,
                    getParentForFragmentAncestors
                  )),
                  null === precedingBoundaryFiber
                    ? (precedingBoundaryFiber = !1)
                    : (traverseVisibleHostChildren(
                        precedingBoundaryFiber,
                        !0,
                        isFiberFollowingCheck,
                        otherFiber,
                        followingBoundaryFiber
                      ),
                      (otherFiber = searchTarget),
                      (searchBoundary = searchTarget = null),
                      (precedingBoundaryFiber = null !== otherFiber))),
                precedingBoundaryFiber)
              : !1;
    }
    function normalizeListenerOptions(opts) {
      return null == opts
        ? "0"
        : "boolean" === typeof opts
          ? "c=" + (opts ? "1" : "0")
          : "c=" +
            (opts.capture ? "1" : "0") +
            "&o=" +
            (opts.once ? "1" : "0") +
            "&p=" +
            (opts.passive ? "1" : "0");
    }
    function indexOfEventListener(
      eventListeners,
      type,
      listener,
      optionsOrUseCapture
    ) {
      for (var i = 0; i < eventListeners.length; i++) {
        var item = eventListeners[i];
        if (
          item.type === type &&
          item.listener === listener &&
          normalizeListenerOptions(item.optionsOrUseCapture) ===
            normalizeListenerOptions(optionsOrUseCapture)
        )
          return i;
      }
      return -1;
    }
    function commitNewChildToFragmentInstance(childInstance, fragmentInstance) {
      var eventListeners = fragmentInstance._eventListeners;
      if (null !== eventListeners)
        for (var i = 0; i < eventListeners.length; i++) {
          var _eventListeners$i2 = eventListeners[i];
          childInstance.addEventListener(
            _eventListeners$i2.type,
            _eventListeners$i2.listener,
            _eventListeners$i2.optionsOrUseCapture
          );
        }
      null !== fragmentInstance._observers &&
        fragmentInstance._observers.forEach(function (observer) {
          observer.observe(childInstance);
        });
    }
    function clearContainerSparingly(container) {
      var nextNode = container.firstChild;
      nextNode && 10 === nextNode.nodeType && (nextNode = nextNode.nextSibling);
      for (; nextNode; ) {
        var node = nextNode;
        nextNode = nextNode.nextSibling;
        switch (node.nodeName) {
          case "HTML":
          case "HEAD":
          case "BODY":
            clearContainerSparingly(node);
            detachDeletedInstance(node);
            continue;
          case "SCRIPT":
          case "STYLE":
            continue;
          case "LINK":
            if ("stylesheet" === node.rel.toLowerCase()) continue;
        }
        container.removeChild(node);
      }
    }
    function canHydrateInstance(instance, type, props, inRootOrSingleton) {
      for (; 1 === instance.nodeType; ) {
        var anyProps = props;
        if (instance.nodeName.toLowerCase() !== type.toLowerCase()) {
          if (
            !inRootOrSingleton &&
            ("INPUT" !== instance.nodeName || "hidden" !== instance.type)
          )
            break;
        } else if (!inRootOrSingleton)
          if ("input" === type && "hidden" === instance.type) {
            checkAttributeStringCoercion(anyProps.name, "name");
            var name = null == anyProps.name ? null : "" + anyProps.name;
            if (
              "hidden" === anyProps.type &&
              instance.getAttribute("name") === name
            )
              return instance;
          } else return instance;
        else if (!instance[internalHoistableMarker])
          switch (type) {
            case "meta":
              if (!instance.hasAttribute("itemprop")) break;
              return instance;
            case "link":
              name = instance.getAttribute("rel");
              if (
                "stylesheet" === name &&
                instance.hasAttribute("data-precedence")
              )
                break;
              else if (
                name !== anyProps.rel ||
                instance.getAttribute("href") !==
                  (null == anyProps.href || "" === anyProps.href
                    ? null
                    : anyProps.href) ||
                instance.getAttribute("crossorigin") !==
                  (null == anyProps.crossOrigin
                    ? null
                    : anyProps.crossOrigin) ||
                instance.getAttribute("title") !==
                  (null == anyProps.title ? null : anyProps.title)
              )
                break;
              return instance;
            case "style":
              if (instance.hasAttribute("data-precedence")) break;
              return instance;
            case "script":
              name = instance.getAttribute("src");
              if (
                (name !== (null == anyProps.src ? null : anyProps.src) ||
                  instance.getAttribute("type") !==
                    (null == anyProps.type ? null : anyProps.type) ||
                  instance.getAttribute("crossorigin") !==
                    (null == anyProps.crossOrigin
                      ? null
                      : anyProps.crossOrigin)) &&
                name &&
                instance.hasAttribute("async") &&
                !instance.hasAttribute("itemprop")
              )
                break;
              return instance;
            default:
              return instance;
          }
        instance = getNextHydratable(instance.nextSibling);
        if (null === instance) break;
      }
      return null;
    }
    function canHydrateTextInstance(instance, text, inRootOrSingleton) {
      if ("" === text) return null;
      for (; 3 !== instance.nodeType; ) {
        if (
          (1 !== instance.nodeType ||
            "INPUT" !== instance.nodeName ||
            "hidden" !== instance.type) &&
          !inRootOrSingleton
        )
          return null;
        instance = getNextHydratable(instance.nextSibling);
        if (null === instance) return null;
      }
      return instance;
    }
    function canHydrateHydrationBoundary(instance, inRootOrSingleton) {
      for (; 8 !== instance.nodeType; ) {
        if (!inRootOrSingleton) return null;
        instance = getNextHydratable(instance.nextSibling);
        if (null === instance) return null;
      }
      return instance;
    }
    function isSuspenseInstancePending(instance) {
      return (
        instance.data === SUSPENSE_PENDING_START_DATA ||
        instance.data === SUSPENSE_QUEUED_START_DATA
      );
    }
    function isSuspenseInstanceFallback(instance) {
      return (
        instance.data === SUSPENSE_FALLBACK_START_DATA ||
        (instance.data === SUSPENSE_PENDING_START_DATA &&
          instance.ownerDocument.readyState !== DOCUMENT_READY_STATE_LOADING)
      );
    }
    function registerSuspenseInstanceRetry(instance, callback) {
      var ownerDocument = instance.ownerDocument;
      if (instance.data === SUSPENSE_QUEUED_START_DATA)
        instance._reactRetry = callback;
      else if (
        instance.data !== SUSPENSE_PENDING_START_DATA ||
        ownerDocument.readyState !== DOCUMENT_READY_STATE_LOADING
      )
        callback();
      else {
        var listener = function () {
          callback();
          ownerDocument.removeEventListener("DOMContentLoaded", listener);
        };
        ownerDocument.addEventListener("DOMContentLoaded", listener);
        instance._reactRetry = listener;
      }
    }
    function getNextHydratable(node) {
      for (; null != node; node = node.nextSibling) {
        var nodeType = node.nodeType;
        if (1 === nodeType || 3 === nodeType) break;
        if (8 === nodeType) {
          nodeType = node.data;
          if (
            nodeType === SUSPENSE_START_DATA ||
            nodeType === SUSPENSE_FALLBACK_START_DATA ||
            nodeType === SUSPENSE_PENDING_START_DATA ||
            nodeType === SUSPENSE_QUEUED_START_DATA ||
            nodeType === ACTIVITY_START_DATA ||
            nodeType === FORM_STATE_IS_MATCHING ||
            nodeType === FORM_STATE_IS_NOT_MATCHING
          )
            break;
          if (nodeType === SUSPENSE_END_DATA || nodeType === ACTIVITY_END_DATA)
            return null;
        }
      }
      return node;
    }
    function describeHydratableInstanceForDevWarnings(instance) {
      if (1 === instance.nodeType) {
        for (
          var JSCompiler_temp_const = instance.nodeName.toLowerCase(),
            serverDifferences = {},
            attributes = instance.attributes,
            i = 0;
          i < attributes.length;
          i++
        ) {
          var attr = attributes[i];
          serverDifferences[getPropNameFromAttributeName(attr.name)] =
            "style" === attr.name.toLowerCase()
              ? getStylesObjectFromElement(instance)
              : attr.value;
        }
        return { type: JSCompiler_temp_const, props: serverDifferences };
      }
      return 8 === instance.nodeType
        ? instance.data === ACTIVITY_START_DATA
          ? { type: "Activity", props: {} }
          : { type: "Suspense", props: {} }
        : instance.nodeValue;
    }
    function diffHydratedTextForDevWarnings(textInstance, text, parentProps) {
      return null === parentProps ||
        !0 !== parentProps[SUPPRESS_HYDRATION_WARNING]
        ? (textInstance.nodeValue === text
            ? (textInstance = null)
            : ((text = normalizeMarkupForTextOrAttribute(text)),
              (textInstance =
                normalizeMarkupForTextOrAttribute(textInstance.nodeValue) ===
                text
                  ? null
                  : textInstance.nodeValue)),
          textInstance)
        : null;
    }
    function getNextHydratableInstanceAfterHydrationBoundary(
      hydrationInstance
    ) {
      hydrationInstance = hydrationInstance.nextSibling;
      for (var depth = 0; hydrationInstance; ) {
        if (8 === hydrationInstance.nodeType) {
          var data = hydrationInstance.data;
          if (data === SUSPENSE_END_DATA || data === ACTIVITY_END_DATA) {
            if (0 === depth)
              return getNextHydratable(hydrationInstance.nextSibling);
            depth--;
          } else
            (data !== SUSPENSE_START_DATA &&
              data !== SUSPENSE_FALLBACK_START_DATA &&
              data !== SUSPENSE_PENDING_START_DATA &&
              data !== SUSPENSE_QUEUED_START_DATA &&
              data !== ACTIVITY_START_DATA) ||
              depth++;
        }
        hydrationInstance = hydrationInstance.nextSibling;
      }
      return null;
    }
    function getParentHydrationBoundary(targetInstance) {
      targetInstance = targetInstance.previousSibling;
      for (var depth = 0; targetInstance; ) {
        if (8 === targetInstance.nodeType) {
          var data = targetInstance.data;
          if (
            data === SUSPENSE_START_DATA ||
            data === SUSPENSE_FALLBACK_START_DATA ||
            data === SUSPENSE_PENDING_START_DATA ||
            data === SUSPENSE_QUEUED_START_DATA ||
            data === ACTIVITY_START_DATA
          ) {
            if (0 === depth) return targetInstance;
            depth--;
          } else
            (data !== SUSPENSE_END_DATA && data !== ACTIVITY_END_DATA) ||
              depth++;
        }
        targetInstance = targetInstance.previousSibling;
      }
      return null;
    }
    function commitHydratedContainer(container) {
      retryIfBlockedOn(container);
    }
    function commitHydratedActivityInstance(activityInstance) {
      retryIfBlockedOn(activityInstance);
    }
    function commitHydratedSuspenseInstance(suspenseInstance) {
      retryIfBlockedOn(suspenseInstance);
    }
    function setFocusIfFocusable(node, focusOptions) {
      function handleFocus() {
        didFocus = !0;
      }
      var didFocus = !1;
      try {
        node.addEventListener("focus", handleFocus),
          (node.focus || HTMLElement.prototype.focus).call(node, focusOptions);
      } finally {
        node.removeEventListener("focus", handleFocus);
      }
      return didFocus;
    }
    function resolveSingletonInstance(
      type,
      props,
      rootContainerInstance,
      hostContext,
      validateDOMNestingDev
    ) {
      validateDOMNestingDev &&
        validateDOMNesting(type, hostContext.ancestorInfo);
      props = getOwnerDocumentFromRootContainer(rootContainerInstance);
      switch (type) {
        case "html":
          type = props.documentElement;
          if (!type)
            throw Error(
              "React expected an <html> element (document.documentElement) to exist in the Document but one was not found. React never removes the documentElement for any Document it renders into so the cause is likely in some other script running on this page."
            );
          return type;
        case "head":
          type = props.head;
          if (!type)
            throw Error(
              "React expected a <head> element (document.head) to exist in the Document but one was not found. React never removes the head for any Document it renders into so the cause is likely in some other script running on this page."
            );
          return type;
        case "body":
          type = props.body;
          if (!type)
            throw Error(
              "React expected a <body> element (document.body) to exist in the Document but one was not found. React never removes the body for any Document it renders into so the cause is likely in some other script running on this page."
            );
          return type;
        default:
          throw Error(
            "resolveSingletonInstance was called with an element type that is not supported. This is a bug in React."
          );
      }
    }
    function acquireSingletonInstance(
      type,
      props,
      instance,
      internalInstanceHandle
    ) {
      if (
        !instance[internalContainerInstanceKey] &&
        getInstanceFromNode(instance)
      ) {
        var tagName = instance.tagName.toLowerCase();
        console.error(
          "You are mounting a new %s component when a previous one has not first unmounted. It is an error to render more than one %s component at a time and attributes and children of these components will likely fail in unpredictable ways. Please only render a single instance of <%s> and if you need to mount a new one, ensure any previous ones have unmounted first.",
          tagName,
          tagName,
          tagName
        );
      }
      switch (type) {
        case "html":
        case "head":
        case "body":
          break;
        default:
          console.error(
            "acquireSingletonInstance was called with an element type that is not supported. This is a bug in React."
          );
      }
      for (tagName = instance.attributes; tagName.length; )
        instance.removeAttributeNode(tagName[0]);
      setInitialProperties(instance, type, props);
      instance[internalInstanceKey] = internalInstanceHandle;
      instance[internalPropsKey] = props;
    }
    function releaseSingletonInstance(instance) {
      for (var attributes = instance.attributes; attributes.length; )
        instance.removeAttributeNode(attributes[0]);
      detachDeletedInstance(instance);
    }
    function getHoistableRoot(container) {
      return "function" === typeof container.getRootNode
        ? container.getRootNode()
        : 9 === container.nodeType
          ? container
          : container.ownerDocument;
    }
    function preconnectAs(rel, href, crossOrigin) {
      var ownerDocument = globalDocument;
      if (ownerDocument && "string" === typeof href && href) {
        var limitedEscapedHref =
          escapeSelectorAttributeValueInsideDoubleQuotes(href);
        limitedEscapedHref =
          'link[rel="' + rel + '"][href="' + limitedEscapedHref + '"]';
        "string" === typeof crossOrigin &&
          (limitedEscapedHref += '[crossorigin="' + crossOrigin + '"]');
        preconnectsSet.has(limitedEscapedHref) ||
          (preconnectsSet.add(limitedEscapedHref),
          (rel = { rel: rel, crossOrigin: crossOrigin, href: href }),
          null === ownerDocument.querySelector(limitedEscapedHref) &&
            ((href = ownerDocument.createElement("link")),
            setInitialProperties(href, "link", rel),
            markNodeAsHoistable(href),
            ownerDocument.head.appendChild(href)));
      }
    }
    function getResource(type, currentProps, pendingProps, currentResource) {
      var resourceRoot = (resourceRoot = rootInstanceStackCursor.current)
        ? getHoistableRoot(resourceRoot)
        : null;
      if (!resourceRoot)
        throw Error(
          '"resourceRoot" was expected to exist. This is a bug in React.'
        );
      switch (type) {
        case "meta":
        case "title":
          return null;
        case "style":
          return "string" === typeof pendingProps.precedence &&
            "string" === typeof pendingProps.href
            ? ((pendingProps = getStyleKey(pendingProps.href)),
              (currentProps =
                getResourcesFromRoot(resourceRoot).hoistableStyles),
              (currentResource = currentProps.get(pendingProps)),
              currentResource ||
                ((currentResource = {
                  type: "style",
                  instance: null,
                  count: 0,
                  state: null
                }),
                currentProps.set(pendingProps, currentResource)),
              currentResource)
            : { type: "void", instance: null, count: 0, state: null };
        case "link":
          if (
            "stylesheet" === pendingProps.rel &&
            "string" === typeof pendingProps.href &&
            "string" === typeof pendingProps.precedence
          ) {
            type = getStyleKey(pendingProps.href);
            var _styles = getResourcesFromRoot(resourceRoot).hoistableStyles,
              _resource = _styles.get(type);
            if (
              !_resource &&
              ((resourceRoot = resourceRoot.ownerDocument || resourceRoot),
              (_resource = {
                type: "stylesheet",
                instance: null,
                count: 0,
                state: { loading: NotLoaded, preload: null }
              }),
              _styles.set(type, _resource),
              (_styles = resourceRoot.querySelector(
                getStylesheetSelectorFromKey(type)
              )) &&
                !_styles._p &&
                ((_resource.instance = _styles),
                (_resource.state.loading = Loaded | Inserted)),
              !preloadPropsMap.has(type))
            ) {
              var preloadProps = {
                rel: "preload",
                as: "style",
                href: pendingProps.href,
                crossOrigin: pendingProps.crossOrigin,
                integrity: pendingProps.integrity,
                media: pendingProps.media,
                hrefLang: pendingProps.hrefLang,
                referrerPolicy: pendingProps.referrerPolicy
              };
              preloadPropsMap.set(type, preloadProps);
              _styles ||
                preloadStylesheet(
                  resourceRoot,
                  type,
                  preloadProps,
                  _resource.state
                );
            }
            if (currentProps && null === currentResource)
              throw (
                ((pendingProps =
                  "\n\n  - " +
                  describeLinkForResourceErrorDEV(currentProps) +
                  "\n  + " +
                  describeLinkForResourceErrorDEV(pendingProps)),
                Error(
                  "Expected <link> not to update to be updated to a stylesheet with precedence. Check the `rel`, `href`, and `precedence` props of this component. Alternatively, check whether two different <link> components render in the same slot or share the same key." +
                    pendingProps
                ))
              );
            return _resource;
          }
          if (currentProps && null !== currentResource)
            throw (
              ((pendingProps =
                "\n\n  - " +
                describeLinkForResourceErrorDEV(currentProps) +
                "\n  + " +
                describeLinkForResourceErrorDEV(pendingProps)),
              Error(
                "Expected stylesheet with precedence to not be updated to a different kind of <link>. Check the `rel`, `href`, and `precedence` props of this component. Alternatively, check whether two different <link> components render in the same slot or share the same key." +
                  pendingProps
              ))
            );
          return null;
        case "script":
          return (
            (currentProps = pendingProps.async),
            (pendingProps = pendingProps.src),
            "string" === typeof pendingProps &&
            currentProps &&
            "function" !== typeof currentProps &&
            "symbol" !== typeof currentProps
              ? ((pendingProps = getScriptKey(pendingProps)),
                (currentProps =
                  getResourcesFromRoot(resourceRoot).hoistableScripts),
                (currentResource = currentProps.get(pendingProps)),
                currentResource ||
                  ((currentResource = {
                    type: "script",
                    instance: null,
                    count: 0,
                    state: null
                  }),
                  currentProps.set(pendingProps, currentResource)),
                currentResource)
              : { type: "void", instance: null, count: 0, state: null }
          );
        default:
          throw Error(
            'getResource encountered a type it did not expect: "' +
              type +
              '". this is a bug in React.'
          );
      }
    }
    function describeLinkForResourceErrorDEV(props) {
      var describedProps = 0,
        description = "<link";
      "string" === typeof props.rel
        ? (describedProps++, (description += ' rel="' + props.rel + '"'))
        : hasOwnProperty.call(props, "rel") &&
          (describedProps++,
          (description +=
            ' rel="' +
            (null === props.rel ? "null" : "invalid type " + typeof props.rel) +
            '"'));
      "string" === typeof props.href
        ? (describedProps++, (description += ' href="' + props.href + '"'))
        : hasOwnProperty.call(props, "href") &&
          (describedProps++,
          (description +=
            ' href="' +
            (null === props.href
              ? "null"
              : "invalid type " + typeof props.href) +
            '"'));
      "string" === typeof props.precedence
        ? (describedProps++,
          (description += ' precedence="' + props.precedence + '"'))
        : hasOwnProperty.call(props, "precedence") &&
          (describedProps++,
          (description +=
            " precedence={" +
            (null === props.precedence
              ? "null"
              : "invalid type " + typeof props.precedence) +
            "}"));
      Object.getOwnPropertyNames(props).length > describedProps &&
        (description += " ...");
      return description + " />";
    }
    function getStyleKey(href) {
      return (
        'href="' + escapeSelectorAttributeValueInsideDoubleQuotes(href) + '"'
      );
    }
    function getStylesheetSelectorFromKey(key) {
      return 'link[rel="stylesheet"][' + key + "]";
    }
    function stylesheetPropsFromRawProps(rawProps) {
      return assign({}, rawProps, {
        "data-precedence": rawProps.precedence,
        precedence: null
      });
    }
    function preloadStylesheet(ownerDocument, key, preloadProps, state) {
      ownerDocument.querySelector(
        'link[rel="preload"][as="style"][' + key + "]"
      )
        ? (state.loading = Loaded)
        : ((key = ownerDocument.createElement("link")),
          (state.preload = key),
          key.addEventListener("load", function () {
            return (state.loading |= Loaded);
          }),
          key.addEventListener("error", function () {
            return (state.loading |= Errored);
          }),
          setInitialProperties(key, "link", preloadProps),
          markNodeAsHoistable(key),
          ownerDocument.head.appendChild(key));
    }
    function getScriptKey(src) {
      return (
        '[src="' + escapeSelectorAttributeValueInsideDoubleQuotes(src) + '"]'
      );
    }
    function getScriptSelectorFromKey(key) {
      return "script[async]" + key;
    }
    function acquireResource(hoistableRoot, resource, props) {
      resource.count++;
      if (null === resource.instance)
        switch (resource.type) {
          case "style":
            var instance = hoistableRoot.querySelector(
              'style[data-href~="' +
                escapeSelectorAttributeValueInsideDoubleQuotes(props.href) +
                '"]'
            );
            if (instance)
              return (
                (resource.instance = instance),
                markNodeAsHoistable(instance),
                instance
              );
            var styleProps = assign({}, props, {
              "data-href": props.href,
              "data-precedence": props.precedence,
              href: null,
              precedence: null
            });
            instance = (
              hoistableRoot.ownerDocument || hoistableRoot
            ).createElement("style");
            markNodeAsHoistable(instance);
            setInitialProperties(instance, "style", styleProps);
            insertStylesheet(instance, props.precedence, hoistableRoot);
            return (resource.instance = instance);
          case "stylesheet":
            styleProps = getStyleKey(props.href);
            var _instance = hoistableRoot.querySelector(
              getStylesheetSelectorFromKey(styleProps)
            );
            if (_instance)
              return (
                (resource.state.loading |= Inserted),
                (resource.instance = _instance),
                markNodeAsHoistable(_instance),
                _instance
              );
            instance = stylesheetPropsFromRawProps(props);
            (styleProps = preloadPropsMap.get(styleProps)) &&
              adoptPreloadPropsForStylesheet(instance, styleProps);
            _instance = (
              hoistableRoot.ownerDocument || hoistableRoot
            ).createElement("link");
            markNodeAsHoistable(_instance);
            var linkInstance = _instance;
            linkInstance._p = new Promise(function (resolve, reject) {
              linkInstance.onload = resolve;
              linkInstance.onerror = reject;
            });
            setInitialProperties(_instance, "link", instance);
            resource.state.loading |= Inserted;
            insertStylesheet(_instance, props.precedence, hoistableRoot);
            return (resource.instance = _instance);
          case "script":
            _instance = getScriptKey(props.src);
            if (
              (styleProps = hoistableRoot.querySelector(
                getScriptSelectorFromKey(_instance)
              ))
            )
              return (
                (resource.instance = styleProps),
                markNodeAsHoistable(styleProps),
                styleProps
              );
            instance = props;
            if ((styleProps = preloadPropsMap.get(_instance)))
              (instance = assign({}, props)),
                adoptPreloadPropsForScript(instance, styleProps);
            hoistableRoot = hoistableRoot.ownerDocument || hoistableRoot;
            styleProps = hoistableRoot.createElement("script");
            markNodeAsHoistable(styleProps);
            setInitialProperties(styleProps, "link", instance);
            hoistableRoot.head.appendChild(styleProps);
            return (resource.instance = styleProps);
          case "void":
            return null;
          default:
            throw Error(
              'acquireResource encountered a resource type it did not expect: "' +
                resource.type +
                '". this is a bug in React.'
            );
        }
      else
        "stylesheet" === resource.type &&
          (resource.state.loading & Inserted) === NotLoaded &&
          ((instance = resource.instance),
          (resource.state.loading |= Inserted),
          insertStylesheet(instance, props.precedence, hoistableRoot));
      return resource.instance;
    }
    function insertStylesheet(instance, precedence, root) {
      for (
        var nodes = root.querySelectorAll(
            'link[rel="stylesheet"][data-precedence],style[data-precedence]'
          ),
          last = nodes.length ? nodes[nodes.length - 1] : null,
          prior = last,
          i = 0;
        i < nodes.length;
        i++
      ) {
        var node = nodes[i];
        if (node.dataset.precedence === precedence) prior = node;
        else if (prior !== last) break;
      }
      prior
        ? prior.parentNode.insertBefore(instance, prior.nextSibling)
        : ((precedence = 9 === root.nodeType ? root.head : root),
          precedence.insertBefore(instance, precedence.firstChild));
    }
    function adoptPreloadPropsForStylesheet(stylesheetProps, preloadProps) {
      null == stylesheetProps.crossOrigin &&
        (stylesheetProps.crossOrigin = preloadProps.crossOrigin);
      null == stylesheetProps.referrerPolicy &&
        (stylesheetProps.referrerPolicy = preloadProps.referrerPolicy);
      null == stylesheetProps.title &&
        (stylesheetProps.title = preloadProps.title);
    }
    function adoptPreloadPropsForScript(scriptProps, preloadProps) {
      null == scriptProps.crossOrigin &&
        (scriptProps.crossOrigin = preloadProps.crossOrigin);
      null == scriptProps.referrerPolicy &&
        (scriptProps.referrerPolicy = preloadProps.referrerPolicy);
      null == scriptProps.integrity &&
        (scriptProps.integrity = preloadProps.integrity);
    }
    function getHydratableHoistableCache(type, keyAttribute, ownerDocument) {
      if (null === tagCaches) {
        var cache = new Map();
        var caches = (tagCaches = new Map());
        caches.set(ownerDocument, cache);
      } else
        (caches = tagCaches),
          (cache = caches.get(ownerDocument)),
          cache || ((cache = new Map()), caches.set(ownerDocument, cache));
      if (cache.has(type)) return cache;
      cache.set(type, null);
      ownerDocument = ownerDocument.getElementsByTagName(type);
      for (caches = 0; caches < ownerDocument.length; caches++) {
        var node = ownerDocument[caches];
        if (
          !(
            node[internalHoistableMarker] ||
            node[internalInstanceKey] ||
            ("link" === type && "stylesheet" === node.getAttribute("rel"))
          ) &&
          node.namespaceURI !== SVG_NAMESPACE
        ) {
          var nodeKey = node.getAttribute(keyAttribute) || "";
          nodeKey = type + nodeKey;
          var existing = cache.get(nodeKey);
          existing ? existing.push(node) : cache.set(nodeKey, [node]);
        }
      }
      return cache;
    }
    function mountHoistable(hoistableRoot, type, instance) {
      hoistableRoot = hoistableRoot.ownerDocument || hoistableRoot;
      hoistableRoot.head.insertBefore(
        instance,
        "title" === type ? hoistableRoot.querySelector("head > title") : null
      );
    }
    function isHostHoistableType(type, props, hostContext) {
      var outsideHostContainerContext =
        !hostContext.ancestorInfo.containerTagInScope;
      if (
        hostContext.context === HostContextNamespaceSvg ||
        null != props.itemProp
      )
        return (
          !outsideHostContainerContext ||
            null == props.itemProp ||
            ("meta" !== type &&
              "title" !== type &&
              "style" !== type &&
              "link" !== type &&
              "script" !== type) ||
            console.error(
              "Cannot render a <%s> outside the main document if it has an `itemProp` prop. `itemProp` suggests the tag belongs to an `itemScope` which can appear anywhere in the DOM. If you were intending for React to hoist this <%s> remove the `itemProp` prop. Otherwise, try moving this tag into the <head> or <body> of the Document.",
              type,
              type
            ),
          !1
        );
      switch (type) {
        case "meta":
        case "title":
          return !0;
        case "style":
          if (
            "string" !== typeof props.precedence ||
            "string" !== typeof props.href ||
            "" === props.href
          ) {
            outsideHostContainerContext &&
              console.error(
                'Cannot render a <style> outside the main document without knowing its precedence and a unique href key. React can hoist and deduplicate <style> tags if you provide a `precedence` prop along with an `href` prop that does not conflict with the `href` values used in any other hoisted <style> or <link rel="stylesheet" ...> tags.  Note that hoisting <style> tags is considered an advanced feature that most will not use directly. Consider moving the <style> tag to the <head> or consider adding a `precedence="default"` and `href="some unique resource identifier"`.'
              );
            break;
          }
          return !0;
        case "link":
          if (
            "string" !== typeof props.rel ||
            "string" !== typeof props.href ||
            "" === props.href ||
            props.onLoad ||
            props.onError
          ) {
            if (
              "stylesheet" === props.rel &&
              "string" === typeof props.precedence
            ) {
              type = props.href;
              var onError = props.onError,
                disabled = props.disabled;
              hostContext = [];
              props.onLoad && hostContext.push("`onLoad`");
              onError && hostContext.push("`onError`");
              null != disabled && hostContext.push("`disabled`");
              onError = propNamesListJoin(hostContext, "and");
              onError += 1 === hostContext.length ? " prop" : " props";
              disabled =
                1 === hostContext.length ? "an " + onError : "the " + onError;
              hostContext.length &&
                console.error(
                  'React encountered a <link rel="stylesheet" href="%s" ... /> with a `precedence` prop that also included %s. The presence of loading and error handlers indicates an intent to manage the stylesheet loading state from your from your Component code and React will not hoist or deduplicate this stylesheet. If your intent was to have React hoist and deduplciate this stylesheet using the `precedence` prop remove the %s, otherwise remove the `precedence` prop.',
                  type,
                  disabled,
                  onError
                );
            }
            outsideHostContainerContext &&
              ("string" !== typeof props.rel ||
              "string" !== typeof props.href ||
              "" === props.href
                ? console.error(
                    "Cannot render a <link> outside the main document without a `rel` and `href` prop. Try adding a `rel` and/or `href` prop to this <link> or moving the link into the <head> tag"
                  )
                : (props.onError || props.onLoad) &&
                  console.error(
                    "Cannot render a <link> with onLoad or onError listeners outside the main document. Try removing onLoad={...} and onError={...} or moving it into the root <head> tag or somewhere in the <body>."
                  ));
            break;
          }
          switch (props.rel) {
            case "stylesheet":
              return (
                (type = props.precedence),
                (props = props.disabled),
                "string" !== typeof type &&
                  outsideHostContainerContext &&
                  console.error(
                    'Cannot render a <link rel="stylesheet" /> outside the main document without knowing its precedence. Consider adding precedence="default" or moving it into the root <head> tag.'
                  ),
                "string" === typeof type && null == props
              );
            default:
              return !0;
          }
        case "script":
          type =
            props.async &&
            "function" !== typeof props.async &&
            "symbol" !== typeof props.async;
          if (
            !type ||
            props.onLoad ||
            props.onError ||
            !props.src ||
            "string" !== typeof props.src
          ) {
            outsideHostContainerContext &&
              (type
                ? props.onLoad || props.onError
                  ? console.error(
                      "Cannot render a <script> with onLoad or onError listeners outside the main document. Try removing onLoad={...} and onError={...} or moving it into the root <head> tag or somewhere in the <body>."
                    )
                  : console.error(
                      "Cannot render a <script> outside the main document without `async={true}` and a non-empty `src` prop. Ensure there is a valid `src` and either make the script async or move it into the root <head> tag or somewhere in the <body>."
                    )
                : console.error(
                    'Cannot render a sync or defer <script> outside the main document without knowing its order. Try adding async="" or moving it into the root <head> tag.'
                  ));
            break;
          }
          return !0;
        case "noscript":
        case "template":
          outsideHostContainerContext &&
            console.error(
              "Cannot render <%s> outside the main document. Try moving it into the root <head> tag.",
              type
            );
      }
      return !1;
    }
    function maySuspendCommit(type, props) {
      return (
        "img" === type &&
        null != props.src &&
        "" !== props.src &&
        null == props.onLoad &&
        "lazy" !== props.loading
      );
    }
    function preloadResource(resource) {
      return "stylesheet" === resource.type &&
        (resource.state.loading & Settled) === NotLoaded
        ? !1
        : !0;
    }
    function suspendInstance(instance) {
      if (null === suspendedState)
        throw Error(
          "Internal React Error: suspendedState null when it was expected to exists. Please report this as a React bug."
        );
      var state = suspendedState;
      "function" === typeof instance.decode &&
        "function" === typeof setTimeout &&
        (state.count++,
        (state = onUnsuspend.bind(state)),
        Promise.race([
          instance.decode(),
          new Promise(function (resolve) {
            return setTimeout(resolve, SUSPENSEY_IMAGE_TIMEOUT);
          })
        ]).then(state, state));
    }
    function suspendResource(hoistableRoot, resource, props) {
      if (null === suspendedState)
        throw Error(
          "Internal React Error: suspendedState null when it was expected to exists. Please report this as a React bug."
        );
      var state = suspendedState;
      if (
        "stylesheet" === resource.type &&
        ("string" !== typeof props.media ||
          !1 !== matchMedia(props.media).matches) &&
        (resource.state.loading & Inserted) === NotLoaded
      ) {
        if (null === resource.instance) {
          var key = getStyleKey(props.href),
            instance = hoistableRoot.querySelector(
              getStylesheetSelectorFromKey(key)
            );
          if (instance) {
            hoistableRoot = instance._p;
            null !== hoistableRoot &&
              "object" === typeof hoistableRoot &&
              "function" === typeof hoistableRoot.then &&
              (state.count++,
              (state = onUnsuspend.bind(state)),
              hoistableRoot.then(state, state));
            resource.state.loading |= Inserted;
            resource.instance = instance;
            markNodeAsHoistable(instance);
            return;
          }
          instance = hoistableRoot.ownerDocument || hoistableRoot;
          props = stylesheetPropsFromRawProps(props);
          (key = preloadPropsMap.get(key)) &&
            adoptPreloadPropsForStylesheet(props, key);
          instance = instance.createElement("link");
          markNodeAsHoistable(instance);
          var linkInstance = instance;
          linkInstance._p = new Promise(function (resolve, reject) {
            linkInstance.onload = resolve;
            linkInstance.onerror = reject;
          });
          setInitialProperties(instance, "link", props);
          resource.instance = instance;
        }
        null === state.stylesheets && (state.stylesheets = new Map());
        state.stylesheets.set(resource, hoistableRoot);
        (hoistableRoot = resource.state.preload) &&
          (resource.state.loading & Settled) === NotLoaded &&
          (state.count++,
          (resource = onUnsuspend.bind(state)),
          hoistableRoot.addEventListener("load", resource),
          hoistableRoot.addEventListener("error", resource));
      }
    }
    function waitForCommitToBeReady() {
      if (null === suspendedState)
        throw Error(
          "Internal React Error: suspendedState null when it was expected to exists. Please report this as a React bug."
        );
      var state = suspendedState;
      state.stylesheets &&
        0 === state.count &&
        insertSuspendedStylesheets(state, state.stylesheets);
      return 0 < state.count
        ? function (commit) {
            var stylesheetTimer = setTimeout(function () {
              state.stylesheets &&
                insertSuspendedStylesheets(state, state.stylesheets);
              if (state.unsuspend) {
                var unsuspend = state.unsuspend;
                state.unsuspend = null;
                unsuspend();
              }
            }, 6e4);
            state.unsuspend = commit;
            return function () {
              state.unsuspend = null;
              clearTimeout(stylesheetTimer);
            };
          }
        : null;
    }
    function onUnsuspend() {
      this.count--;
      if (0 === this.count)
 