// src/hooks/useDarkMode.ts
import { useEffect, useState } from 'react';

export function useDarkMode() {
  const [isDark, setIsDark] = useState(false);

useEffect(() => {
  const stored = localStorage.getItem('dark-mode');
  const prefers = window.matchMedia('(prefers-color-scheme: dark)').matches;
  const initial = stored !== null ? stored === 'true' : prefers;

  console.log('🌙 initializing dark mode', { stored, prefers, initial });

  setIsDark(initial);
  document.documentElement.classList.toggle('dark', initial);
}, []);


  useEffect(() => {
    document.documentElement.classList.toggle('dark', isDark);
    localStorage.setItem('dark-mode', isDark.toString());
    
  }, [isDark]);

  return [isDark, setIsDark] as const;
}
