'use client';

import { motion } from 'framer-motion';
import { CheckCircle2 } from 'lucide-react';

export default function AnimatedLoginSpinner() {
  return (
    <motion.div
      initial={{ opacity: 0 }}
      animate={{ opacity: 1 }}
      exit={{ opacity: 0 }}
      className="fixed inset-0 z-50 flex flex-col items-center justify-center bg-gradient-to-br from-green-50 via-white to-green-100 dark:from-gray-900 dark:via-gray-800 dark:to-gray-900"
    >
      {/* Pulse ring effect */}
      <div className="relative mb-6">
        <motion.span
          className="absolute inline-flex h-full w-full rounded-full bg-green-400 opacity-75"
          animate={{
            scale: [1, 1.5],
            opacity: [0.7, 0],
          }}
          transition={{
            duration: 1.2,
            repeat: Infinity,
            ease: 'easeOut',
          }}
        />
        <motion.div
          initial={{ scale: 0 }}
          animate={{ scale: 1 }}
          transition={{ type: 'spring', stiffness: 120, damping: 10 }}
          className="relative flex items-center justify-center w-20 h-20 rounded-full bg-green-600 shadow-xl"
        >
          <CheckCircle2 className="w-10 h-10 text-white drop-shadow-md" />
        </motion.div>
      </div>

      {/* Text animation */}
      <motion.p
        className="text-xl font-semibold text-green-700 dark:text-green-300"
        initial={{ y: 20, opacity: 0 }}
        animate={{ y: 0, opacity: 1 }}
        transition={{ duration: 0.6, delay: 0.3 }}
      >
        Logging you in...
      </motion.p>
    </motion.div>
  );
}
