// src/app/api/forgotpassword/route.ts
import { NextRequest, NextResponse } from 'next/server';
import axios, { AxiosError } from 'axios';
import { API_BASE_PATH } from "@/config/apiConfig";

const API_BASE_URL = API_BASE_PATH;

export async function POST(req: NextRequest) {
  try {
    const body = await req.json();
    const { email } = body;

    const formData = new URLSearchParams();
    formData.append('email', email);

    const response = await axios.post(`${API_BASE_URL}/user/resetpassword`, formData, {
      headers: {
        Accept: 'application/json',
        'Content-Type': 'application/x-www-form-urlencoded',
      },
    });

    return NextResponse.json({ message: 'Reset link sent!' }, { status: 200 });
  } catch (error) {
    const axiosError = error as AxiosError<{ message: string }>;
    return NextResponse.json(
      { message: axiosError.response?.data?.message || 'Failed to send reset link' },
      { status: axiosError.response?.status || 500 }
    );
  }
}
