

<?php $__env->startSection('content'); ?>
    <div class="page-wrapper">
        <div class="content container-fluid">
            <div class="page-header">
                <div class="row align-items-center">
                    <div class="col">
                        <h3 class="page-title">Projects</h3>
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="index.html">Dashboard</a></li>
                            <li class="breadcrumb-item active">Projects</li>
                        </ul>
                    </div>
                    <?php if(Auth::user()->role_name == 'Admin'): ?>

                    <div class="col-auto float-right ml-auto">
                        <button class="btn add-btn" data-toggle="modal" data-target="#add_project_modal">
                            <i class="fa fa-plus"></i> Create Project
                        </button>
                    </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Projects Table -->
            <div class="table-responsive">
                <table id="projectTable" class="table table-striped">
                    <thead>
                        <tr>
                            <th>Project ID</th>
                            <th>Project Name</th>
                            <th>Client</th>
                            <th>Assigned Group</th>
                            <th>Assigned To</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($project->project_id); ?></td>
                                <td><?php echo e($project->project_name); ?></td>
                                <td><?php echo e($project->client->name); ?></td>
                                <td><?php echo e($project->group->name); ?></td>
                                <td><?php echo e($project->assignedTo->name); ?></td>
                                <td><?php echo e($project->status); ?></td>
                                <td>
                                    <button class="btn btn-primary edit-btn" data-id="<?php echo e($project->id); ?>" data-toggle="modal" data-target="#add_project_modal">
                                        <i class="fa fa-edit"></i> Edit
                                    </button>
                                    <form action="<?php echo e(route('projects.destroy', $project->id)); ?>" method="POST" style="display:inline;">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button class="btn btn-danger" type="submit">
                                            <i class="fa fa-trash"></i> Delete
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Add/Edit Project Modal -->
    <div id="add_project_modal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add Project</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="projectForm" method="POST" action="<?php echo e(route('projects.store')); ?>" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="project_id" id="project_id">
                        
                        <div class="form-group">
                            <label for="project_name">Project Name</label>
                            <input type="text" class="form-control" id="project_name" name="project_name" required>
                        </div>
                        <div class="form-group">
                            <label for="client_name">Client</label>
                            <select class="form-control" id="client_name" name="client_id" required>
                                <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($client->id); ?>"><?php echo e($client->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group">
    <label for="assigned_group">Assigned Group</label>
    <select class="form-control" id="assigned_group" name="assigned_group_id" required>
        <?php $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($group['id']); ?>"><?php echo e($group['name']); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
</div>

                        <div class="form-group">
                            <label for="assigned_to">Assigned To</label>
                            <select class="form-control" id="assigned_to" name="assigned_to_id" required>
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="status">Status</label>
                            <select class="form-control" id="status" name="status" required>
                                <option value="Active">Active</option>
                                <option value="Completed">Completed</option>
                                <option value="Pending">Pending</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="start_date">Start Date</label>
                            <input type="date" class="form-control" id="start_date" name="start_date" required>
                        </div>
                        <div class="form-group">
                            <label for="end_date">End Date</label>
                            <input type="date" class="form-control" id="end_date" name="end_date" required>
                        </div>
                        <div class="form-group">
                            <label for="project_logo">Project Logo</label>
                            <input type="file" class="form-control" id="project_logo" name="project_logo">
                        </div>
                        <div class="form-group">
                            <label for="description">Description</label>
                            <textarea class="form-control" id="description" name="description" required></textarea>
                        </div>
                        
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary">Save Project</button>
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $(document).ready(function() {
            // Initialize DataTables
            $('#projectTable').DataTable();

            // Handle Edit button click
            $('.edit-btn').click(function() {
                var projectId = $(this).data('id');
                $.ajax({
                    url: '/projects/' + projectId + '/edit',
                    method: 'GET',
                    success: function(response) {
                        // Fill the modal with data from the project
                        var project = response.project;
                        $('#project_id').val(project.id);
                        $('#project_name').val(project.project_name);
                        $('#client_name').val(project.client_id);
                        $('#assigned_group').val(project.assigned_group_id);
                        $('#assigned_to').val(project.assigned_to_id);
                        $('#status').val(project.status);
                        $('#start_date').val(project.start_date);
                        $('#end_date').val(project.end_date);
                        $('#description').val(project.description);

                        // Change modal title to 'Edit Project'
                        $('#add_project_modal .modal-title').text('Edit Project');

                        // Set form action to update route
                        $('#projectForm').attr('action', '/projects/' + project.id);
                    }
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\IATT\Pictures\HRM-MIS\HR-Management-System-Built-on-Laravel-11-main\resources\views/project/index.blade.php ENDPATH**/ ?>