<!-- Sidebar -->
<div class="sidebar" id="sidebar">
    <div class="sidebar-inner slimscroll">
        <div id="sidebar-menu" class="sidebar-menu">
            <ul>
                <!-- Main Menu -->
                <li class="menu-title">
                    <span>Main</span>
                </li>
                <li class="{{ set_active(['home','em/dashboard']) }} submenu">
                    <a href="#">
                        <i class="la la-dashboard"></i>
                        <span>Dashboard</span> 
                        <span class="menu-arrow"></span>
                    </a>
                    <ul>
                    @if (Auth::user()->role_name == 'Admin')

                        <li><a class="{{ set_active(['home']) }}" href="{{ route('home') }}">Admin Dashboard</a></li>
                        @endif   

                        @if (Auth::user()->role_name == 'Normal User')

                        <li><a class="{{ set_active(['em/dashboard']) }}" href="{{ route('em/dashboard') }}">Employee Dashboard</a></li>
                        @endif   
                    </ul>
                </li>

                @if (Auth::user()->role_name == 'Admin')
                    <!-- Admin Authentication -->
                    <li class="menu-title"><span>Authentication</span></li>
                    <li class="{{ set_active(['userManagement', 'activity/log']) }} submenu">
                        <a href="#"><i class="la la-user-secret"></i> <span>User Controller</span> <span class="menu-arrow"></span></a>
                        <ul>
                            <li><a class="{{ set_active(['userManagement']) }}" href="{{ route('userManagement') }}">All Users</a></li>
                        </ul>
                    </li>

                    <!-- Admin Features -->
                    <li><a class="{{ set_active(['attendance/page']) }}" href="{{ route('attendance/page') }}"><i class="la la-calendar-check-o mr-3"></i> Attendance</a></li>
                    <li><a class="{{ set_active(['form/leaves/new']) }}" href="{{ route('form/leaves/new') }}"><i class="la la-calendar mr-3"></i> Leaves <span class="badge badge-pill bg-primary float-right">1</span></a></li>
                    <li class="{{set_active(['roles/permissions/page'])}}"><a href="{{ route('roles/permissions/page') }}"><i class="la la-key"></i><span>Roles & Permissions</span></a></li>

                    <li><a class="{{ set_active(['form/departments/page']) }}" href="{{ route('form/departments/page') }}"><i class="la la-building mr-3"></i> Departments</a></li>
                    <li><a class="{{ set_active(['form/designations/page']) }}" href="{{ route('form/designations/page') }}"><i class="la la-sitemap mr-3"></i> Designations</a></li>
                    <li><a class="{{ set_active(['form/leavesettings/page']) }}" href="{{ route('form/leavesettings/page') }}"><i class="la la-cogs mr-3"></i> Leave Settings</a></li>
                    <li><a class="{{ set_active(['form/holidays/new']) }}" href="{{ route('form/holidays/new') }}"><i class="la la-plane mr-3"></i> Holidays</a></li>
                   
                    <li class="menu-title"><span>Project Management</span></li>

                    <li class="{{ set_active(['all/employee/list', 'form/leaves/employee/new']) }} submenu" slimscroll>
                        <a href="#"><i class="la la-user"></i> <span>Project Management</span> <span class="menu-arrow"></span></a>
                        <ul>
                            <li><a class="{{ set_active(['client']) }}" href="{{ route('client.index') }}">Clients</a></li>
                            <li><a class="{{ set_active(['projects']) }}" href="{{ route('projects.index') }}">Projects</a></li>
                            <li><a class="{{ set_active(['tasks']) }}" href="{{ route('task.index') }}">Tasks</a></li>
                            <li><a class="{{ set_active(['defects']) }}" href="{{ route('defects.index') }}">Defect Task</a></li>
                           
                        </ul>
                    </li>
                    <!-- Payroll -->
                    <li class="menu-title"><span>HR</span></li>
                    <li class="{{ set_active(['form/salary/page', 'form/payroll/items']) }} submenu">
                        <a href="#"><i class="la la-money"></i> <span>Payroll</span> <span class="menu-arrow"></span></a>
                        <ul>
                            <li><a class="{{ set_active(['form/salary/page']) }}" href="{{ route('form/salary/page') }}">Employee Salary</a></li>
                            <li><a class="{{ set_active(['form/payroll/items']) }}" href="{{ route('form/payroll/items') }}">Payroll Items</a></li>
                        </ul>
                    </li>

                    <!-- Reports -->
                    <li class="{{ set_active(['form/expense/reports/page', 'form/invoice/reports/page']) }} submenu">
                        <a href="#"><i class="la la-pie-chart"></i> <span>Reports</span> <span class="menu-arrow"></span></a>
                        <ul>
                            <li><a class="{{ set_active(['form/expense/reports/page']) }}" href="{{ route('form/expense/reports/page') }}">Expense Report</a></li>
                            <li><a class="{{ set_active(['form/invoice/reports/page']) }}" href="{{ route('form/invoice/reports/page') }}">Invoice Report</a></li>
                            <li><a class="{{ set_active(['form/payments/reports/page']) }}" href="{{ route('form/payments/reports/page') }}">Payments Report</a></li>
                            <li><a class="{{ set_active(['form/employee/reports/page']) }}" href="{{ route('form/employee/reports/page') }}">Employee Report</a></li>
                            <li><a class="{{ set_active(['form/attendance/reports/page']) }}" href="{{ route('form/attendance/reports/page') }}">Attendance Report</a></li>
                            <li><a class="{{ set_active(['form/leave/reports/page']) }}" href="{{ route('form/leave/reports/page') }}">Leave Report</a></li>
                        </ul>
                    </li>
                @endif

                @if (Auth::user()->role_name == 'Normal User')
                    <!-- Employee Menu -->
                    <li class="menu-title"><span>Employees</span></li>
                    <li class="{{ set_active(['all/employee/list', 'form/leaves/employee/new']) }} submenu">
                        <a href="#"><i class="la la-user"></i> <span>Employees</span> <span class="menu-arrow"></span></a>
                        <ul>
                            <li><a class="{{ set_active(['all/employee/list']) }}" href="{{ route('all/employee/card') }}">All Employees</a></li>
                            <li><a class="{{ set_active(['form/leaves/employee/new']) }}" href="{{ route('form/leaves/employee/new') }}">Leaves</a></li>
                            <li><a class="{{ set_active(['attendance/employee/page']) }}" href="{{ route('attendance/employee/page') }}">Attendance</a></li>
                            <li><a class="{{ set_active(['form/timesheet/page']) }}" href="{{ route('form/timesheet/page') }}">Timesheet</a></li>
                            <li><a class="{{ set_active(['form/shiftscheduling/page']) }}" href="{{ route('form/shiftscheduling/page') }}">Shift & Schedule</a></li>
                            <li><a class="{{ set_active(['form/overtime/page']) }}" href="{{ route('form/overtime/page') }}">Overtime</a></li>
                           
                        </ul>
                    </li>

                    <li class="{{ set_active(['all/employee/list', 'form/leaves/employee/new']) }} submenu">
                        <a href="#"><i class="la la-user"></i> <span>Project Management</span> <span class="menu-arrow"></span></a>
                        <ul>
                            <li><a class="{{ set_active(['projects']) }}" href="{{ route('projects.index') }}">Projects</a></li>
                            <li><a class="{{ set_active(['tasks']) }}" href="{{ route('task.index') }}">Tasks</a></li>
                            <li><a class="{{ set_active(['defects']) }}" href="{{ route('defects.index') }}">Defect Task</a></li>
                           
                        </ul>
                    </li>
                @endif
            </ul>
        </div>
    </div>
</div>
<!-- /Sidebar -->
