@extends('layouts.master')
 
@section('content')
    <link href="https://cdn.jsdelivr.net/npm/toastr@2.1.4/build/toastr.min.css" rel="stylesheet">
 
    <div class="page-wrapper">
        <div class="content container-fluid">
            <div class="page-header">
                <div class="row align-items-center">
                    <div class="col">
                        <h3 class="page-title">Designations</h3>
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('home') }}">Dashboard</a></li>
                            <li class="breadcrumb-item active">Designations</li>
                        </ul>
                    </div>
                    <div class="col-auto float-right ml-auto">
                        <!-- Add Designation Button -->
                        <a href="#" class="btn add-btn" data-toggle="modal" data-target="#add_designation"><i class="fa fa-plus"></i> Add Designation</a>
                    </div>
                </div>
            </div>
 
            @if (session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif
 
            @if (session('error'))
                <div class="alert alert-danger">
                    {{ session('error') }}
                </div>
            @endif
 
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table table-striped custom-table mb-0 datatable">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Designation</th>
                                    <th>Department</th>
                                    <th class="text-right">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($designations as $designation)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $designation->designation }}</td>
                                        <td>{{ $designation->department }}</td>
                                        <td class="text-right">
                                            <a href="#" class="btn btn-sm btn-info edit-designation"
                                                data-id="{{ $designation->id }}"
                                                data-designation_name="{{ $designation->designation }}"
                                                data-department="{{ $designation->department }}"
                                                data-toggle="modal"
                                                data-target="#edit_designation">Edit</a>
                                            <a href="#" class="btn btn-sm btn-danger delete-designation"
                                                data-id="{{ $designation->id }}"
                                                data-toggle="modal"
                                                data-target="#delete_designation">Delete</a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
 
        <!-- Add Designation Modal -->
        <div id="add_designation" class="modal custom-modal fade" tabindex="-1" aria-labelledby="add_designation_label" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Add New Designation</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">&times;</button>
                    </div>
                    <div class="modal-body">
                        <form id="addDesignationForm" method="POST" action="{{ route('form.designations.save') }}">
                            @csrf
                            <div class="form-group">
                                <label>Designation Name</label>
                                <input class="form-control @error('designation') is-invalid @enderror" type="text" name="designation" value="{{ old('designation') }}" required>
                                @error('designation')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label>Department</label>
                                <select class="form-control @error('department') is-invalid @enderror" name="department" required>
                                    @foreach ($departments as $department)
                                        <option value="{{ $department->department }}" {{ old('department') == $department->department ? 'selected' : '' }}>{{ $department->department }}</option>
                                    @endforeach
                                </select>
                                @error('department')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>
                            <button class="btn btn-primary submit-btn">Save</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
 
        <!-- Edit Designation Modal -->
        <div id="edit_designation" class="modal custom-modal fade" tabindex="-1" aria-labelledby="edit_designation_label" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Edit Designation</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">&times;</button>
                    </div>
                    <div class="modal-body">
                        <form id="editDesignationForm" method="POST" action="">
                            @csrf
                            <input type="hidden" id="edit_designation_id" name="id">
 
                            <div class="form-group">
                                <label>Designation Name</label>
                                <input class="form-control" id="edit_designation_name" type="text" name="designation" required>
                            </div>
 
                            <div class="form-group">
                                <label>Department</label>
                                <select class="form-control" id="edit_department" name="department" required>
                                    @foreach ($departments as $department)
                                        <option value="{{ $department->department }}">{{ $department->department }}</option>
                                    @endforeach
                                </select>
                            </div>
 
                            <button class="btn btn-primary submit-btn">Save Changes</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
 
        <!-- Delete Designation Modal -->
        <div id="delete_designation" class="modal custom-modal fade" tabindex="-1" aria-labelledby="delete_designation_label" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Delete Designation</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">&times;</button>
                    </div>
                    <div class="modal-body">
                        <form id="deleteDesignationForm" method="POST" action="{{ route('form.designations.delete', ':id') }}">
                            @csrf
                            @method('DELETE')
                            <p>Are you sure you want to delete this designation?</p>
                            <input type="hidden" id="delete_designation_id" name="id">
                            <button class="btn btn-danger submit-btn">Delete</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
 
@section('script')
<script>
    // Edit Designation
    $(document).on('click', '.edit-designation', function() {
        var designationId = $(this).data('id');
        var designationName = $(this).data('designation_name');
        var department = $(this).data('department');
 
        // Set the modal input fields with data
        $('#edit_designation_id').val(designationId);
        $('#edit_designation_name').val(designationName);
        $('#edit_department').val(department);
 
        // Set the form action for updating the designation
        var actionUrl = '{{ route("form.designations.update", ":id") }}';
        actionUrl = actionUrl.replace(':id', designationId);
        $('#editDesignationForm').attr('action', actionUrl);
 
        // Show the edit modal
        $('#edit_designation').modal('show');
    });
 
    // Delete Designation
    $(document).on('click', '.delete-designation', function() {
        var designationId = $(this).data('id');
        var action = "{{ route('form.designations.delete', ':id') }}".replace(':id', designationId);
        $('#deleteDesignationForm').attr('action', action);
    });
</script>
@endsection