@extends('layouts.master')

@section('content')

@section('style')
<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.6.3/css/all.css">
<link rel="stylesheet" href="{{ URL::to('assets/css/checkbox-style.css') }}">
<link rel="stylesheet" href="https://cdn.datatables.net/1.11.4/css/jquery.dataTables.min.css">
@endsection


<div class="page-wrapper">
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-center">
                <div class="col">
                    <h3 class="page-title">Defects</h3>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="">Dashboard</a></li>
                        <li class="breadcrumb-item active">Defects</li>
                    </ul>
                </div>
                @if (Auth::user()->role_name == 'Admin')

                <div class="col-auto float-right ml-auto">
                    <a href="#" class="btn add-btn" data-toggle="modal" data-target="#add_defect_modal">
                        <i class="fa fa-plus"></i> Create Defect
                    </a>
                </div>
                @endif
            </div>
        </div>


        @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
        @endif

        <!-- Defect Table -->
        <div class="table-responsive">
            <table id="defectTable" class="table table-striped">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Defect Name</th>
                        <th>Project</th>

                        <th>Description</th>
                        <th>Assigned Team</th>
                        <th>Estimated Hours</th>
                        <th>Severity</th>
                        <th>Status</th>

                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($defects as $defect)
                    <tr>
                        <td>{{ $defect->id }}</td>
                        <td>{{ $defect->defect_name }}</td>
                        <td> {{ collect($projects)->firstWhere('id', $defect->project_id)['project_name'] ?? '' }}</td>

                        <td>{{ $defect->defect_description }}</td>
                        <td> {{ collect($groups)->firstWhere('id', $defect->assigned_team)['department'] ?? '' }}</td>
                        <td>{{ $defect->estimated_hours }}</td>
                        <td><span class="badge badge-{{ strtolower($defect->severity) }}">{{ $defect->severity }}</span></td>
                        <td><span class="badge badge-{{ strtolower($defect->status) }}">{{ $defect->status }}</span></td>




                        <td>
                            <button class="btn btn-primary edit-btn" data-id="{{ $defect->id }}" data-toggle="modal" data-target="#add_defect_modal">
                                <i class="fa fa-edit"></i>
                            </button>
                            <form action="{{ route('defects.destroy', $defect->id) }}" method="POST" style="display:inline;">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-danger" type="submit" onclick="return confirm('Are you sure you want to delete this defect?')">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </form>
                        </td>

                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

    </div>
</div>

<!-- Add/Edit Defect Modal -->
<div id="add_defect_modal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Create Defect</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>

            <div class="modal-body">
                <form action="{{ route('defects.store') }}" method="POST" id="defectForm" enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="defect_id" id="defect_id">

                    <div class="form-group">
                        <label for="defect_name">Defect Name</label>
                        <input type="text" class="form-control" id="defect_name" name="defect_name" value="" required>
                    </div>
                    {{-- Project ID (Optional, commented-out section) --}}

                    <div class="form-group">
                        <label for="project_id">project id</label>
                        <select class="form-control" id="project_id" name="project_id" required>
                            @foreach ($projects as $pro)
                            <option value="{{ $pro->id }}">{{ $pro->project_name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="defect_type">Defect Type</label>
                        <select type="text" class="form-control" id="defect_type" name="defect_type" value="" required>
                            <option>Defects</option>
                            <option>Enhancement</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="defect_description">Description</label>
                        <textarea class="form-control" id="defect_description" name="defect_description" value="" required></textarea>
                    </div>
                    <div class="form-group">
                        <label for="assigned_team">Assigned Team</label>
                        <select type="text" class="form-control" id="assigned_team" name="assigned_team" value="" required>
                            @foreach ($groups as $group)
                            <option value="{{ $group['id'] }}">{{ $group['department'] }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="estimated_hours">Estimated Hours</label>
                        <input type="number" class="form-control" id="estimated_hours" name="estimated_hours" step="0.1" value="" required>
                    </div>
                    <div class="form-group">
                        <label for="fileupload">Upload File</label>
                        <input type="file" class="form-control-file" id="fileupload" name="fileupload" value="">
                    </div>
                    <div class="form-group">

                        <img id="defect_image" src="" alt="Defect Image" class="img-fluid" style="max-width: 200px; display: none;">
                    </div>


                    <div class="form-group">
                        <label for="overdue">Overdue Date</label>
                        <input type="number" class="form-control" id="overdue" name="overdue" value="" required>
                    </div>
                    <div class="form-group">
                        <label for="severity">Severity</label>
                        <select class="form-control" id="severity" name="severity" value="" required>
                            <option value="Low">Low</option>
                            <option value="Medium">Medium</option>
                            <option value="High">High</option>
                            <option value="Critical">Critical</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="status">Status</label>
                        <select class="form-control" id="status" name="status" value="" required>
                            <option value="Open">Open</option>
                            <option value="In Progress">In Progress</option>
                            <option value="Resolved">Resolved</option>
                            <option value="Closed">Closed</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="reported_by">Reported By</label>
                        <select type="number" class="form-control" id="reported_by" name="reported_by" value="" required>
                            @foreach ($users as $user)
                            <option value="{{ $user->id }}">{{ $user->name }}</option>
                            @endforeach
                        </select>

                    </div>

                    <!-- New Fields -->
                    <div class="form-group">
                        <label for="assigned_to">Assigned To</label>
                        <select type="number" class="form-control" id="assigned_to" name="assigned_to" value="" required>
                            @foreach ($users as $user)
                            <option value="{{ $user->id }}">{{ $user->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="created_user_id">Created By</label>
                        <input disabled type="text" class="form-control" id="creator_id_name" value="{{ Session::get('name') }}" required>
                        <input type="hidden" name="created_user_id" id="created_user_id" value="{{ Session::get('user_id') }}">

                        </i>

                    </div>
                    <div class="form-group">
                        <label for="start_date">Start Date</label>
                        <input type="date" class="form-control" id="start_date" name="start_date" value="" required>
                    </div>
                    <div class="form-group">
                        <label for="end_date">End Date</label>
                        <input type="date" class="form-control" id="end_date" name="end_date" value="" required>
                    </div>

                    <button type="submit" class="btn btn-primary">Save Defect</button>
                </form>
            </div>
        </div>
    </div>
</div>


@endsection

@section('script')
<script>
    let setUrl = null;

    $('#defectTable').DataTable();

    $('.add-btn').on('click', function() {
        $('#defect_image').hide();
        $('#fileupload').attr('required', true);
        setUrl = "<?= route('defects.store') ?>";
        $('#defectForm').attr('action', setUrl).attr('method', 'POST');
        $('#modal-title').text('Add defects');
        $('#defectForm')[0].reset();
    });

    $('.edit-btn').on('click', function() {

        $('#fileupload').removeAttr('required');
        var defectId = $(this).data('id');
        setUrl = "<?= route('defects.update', ['defect' => ':id']) ?>".replace(':id', defectId);
        $.get('/defects/' + defectId + '/edit', function(data) {
            console.log(data);
            // Fill the modal form with existing defect data
            $('#defect_id').val(data.id);
            $('#defect_name').val(data.defect_name);
            $('#project_id').val(data.project_id);
            $('#defect_type').val(data.defect_type);
            $('#defect_description').val(data.defect_description);
            $('#assigned_team').val(data.assigned_team);
            $('#estimated_hours').val(data.estimated_hours);
            $('#severity').val(data.severity);
            $('#status').val(data.status);
            $('#reported_by').val(data.reported_by);
            $('#overdue').val(data.overdue);
            $('#assigned_to').val(data.assigned_to);
            $('#created_user_id').val(data.created_user_id);
            $('#creator_id_name').val(data.creator_id_name);
            $('#start_date').val(data.start_date.split('T')[0]);
            $('#end_date').val(data.end_date.split('T')[0]);

            $('#defectForm').attr('action', setUrl).attr('method', 'POST');
            // Change modal title to 'Edit Project'
            $('.modal-title').text('Edit Defects');

            if (data.fileupload) {
                $('#defect_image').attr('src', '/' + data.fileupload).show();
            } else {
                $('#defect_image').hide();
            }
        });
    });
</script>
@endsection