# Core Committers
The core committers team is reviewed approximately annually, new members are added based on quality contributions to SilverStipe code and outstanding community participation. 

## Core committer team
* [Damian Mooyman](https://github.com/tractorcow/)
* [Daniel Hensby](https://github.com/dhensby)
* [Hamish Friedlander](https://github.com/hafriedlander)
* [Ingo Schommer](https://github.com/chillu)
* [Loz Calver](https://github.com/kinglozzer)
* [Mateusz Uzdowski](https://github.com/mateusz/)
* [Sam Minnée](https://github.com/sminnee)
* [Sean Harvey](https://github.com/halkyon/)
* [Stig Lindqvist](https://github.com/stojg)
* [Will Morgan](https://github.com/willmorgan)
* [Will Rossiter](https://github.com/wilr/)

## House rules for the core committer team

The "core committers" consist of everybody with write permissions to our codebase.
With great power comes great responsibility, so we have agreed on certain expectations:

 * Be friendly, encouraging and constructive towards other community members
 * Frequently review pull requests and new issues (in particular, respond quickly to @mentions)
 * Treat issues according to our [issue guidelines](issues_and_bugs)
 * Don't commit directly to core, raise pull requests instead (except trivial fixes)
 * Only merge code you have tested and fully understand. If in doubt, ask for a second opinion.
 * Ensure contributions have appropriate [test coverage](../developer_guides/testing), are documented, and pass our [coding conventions](/getting_started/coding_conventions)
 * Keep the codebase "releasable" at all times (check our [release process](release_process))
 * API changes and non-trivial features should not be merged into release branches. 
 * API changes on master should not be merged until they have the buy-in of at least two core committers (or better, through the [core mailing list](https://groups.google.com/forum/#!forum/silverstripe-dev))
 * Be inclusive. Ensure a wide range of SilverStripe developers can obtain an understanding of your code and docs, and you're not the only one who can maintain it.
 * Avoid `git push --force`, and be careful with your git remotes (no accidental pushes)
 * Use your own forks to create feature branches

