# 3.0.6-rc1 (2013-08-08)

## Overview

 * Security: Require ADMIN for `?flush=1` (stop denial of service attacks)
 ([#1692](https://github.com/silverstripe/silverstripe-framework/issues/1692))

## Details

### Security: Require ADMIN for ?flush=1

Flushing the various manifests (class, template, config) is performed through a GET
parameter (`flush=1`). Since this action requires more server resources than normal requests,
it can facilitate [denial-of-service attacks](https://en.wikipedia.org/wiki/Denial-of-service_attack).

To prevent this, main.php now checks and only allows the flush parameter in the following cases:

 * The [environment](/topics/environment-management) is in "dev mode"
 * A user is logged in with ADMIN permissions
 * An error occurs during startup

This applies to both `flush=1` and `flush=all` (technically we only check for the existence of any parameter value)
but only through web requests made through main.php - CLI requests, or any other request that goes through
a custom start up script will still process all flush requests as normal.

Thanks to Christopher Tombleson for reporting.

## Upgrading

 * If you have created your own composite database fields, then you should amend the setValue() to allow the passing of
   an object (usually DataObject) as well as an array.
 * If you have provided your own startup scripts (ones that include core/Core.php) that can be accessed via a web
   request, you should ensure that you limit use of the flush parameter
 * Translation entity namespaces can no longer contain dots, since it conflicts with the YAML format. 
 * Translation entities defined in templates now use their fully qualified entity name without dots.
   Before: `BackLink_Button.ss.Back`, after `BackLink_Button_ss.Back`. Please fix any custom language
   files or uses of those entities in custom code.
 * If using "Māori/Te Reo" (mi_NZ) as your CMS locale, please re-select it in `admin/myprofile`
   to ensure correct operation (it has changed its locale identifier)


## Changelog

### API Changes

 * 2013-03-08 [b81f39a](https://github.com/silverstripe/sapphire/commit/b81f39a) Handle uncaught ValidationException on CMS controller execution (Ingo Schommer)
 * 2013-02-27 [e6fffb9](https://github.com/silverstripe/sapphire/commit/e6fffb9) Remove content-length setting in HTTPResponse (Ingo Schommer)
 * 2013-02-27 [600d9cf](https://github.com/silverstripe/sapphire/commit/600d9cf) Make Object::config use late static binding (Hamish Friedlander)
 * 2013-02-12 [10199f9](https://github.com/silverstripe/sapphire/commit/10199f9) Data corruption on Versioned due to lazy loading (Julian Seidenberg)
 * 2013-01-24 [11f4b2c](https://github.com/silverstripe/sapphire/commit/11f4b2c) HTTP::urlRewriter with (string)$code deprecated in 3.1. Fixed regressions and CSS urls. (Damian Mooyman)

### Features and Enhancements

 * 2013-04-21 [eb583c5](https://github.com/silverstripe/sapphire/commit/eb583c5) Added DataObject::getQueriedDatabaseFields() as faster alternative to toMap() API: CompositeDBField::setValue() may be passed an object as its second argument, in addition to array. (Sam Minnee)
 * 2013-03-18 [b401d39](https://github.com/silverstripe/sapphire/commit/b401d39) Move temp data into a user-specific subfolder, to stop temp-permission bugs from occurring. (Sam Minnee)
 * 2013-02-22 [de641dd](https://github.com/silverstripe/sapphire/commit/de641dd) updated the reference index on doc.silverstripe.com 3.0 - There were lots of broken and missing links (Jeremy Bridson)

### Bugfixes

 * 2013-08-05 [5f9387c](https://github.com/silverstripe/sapphire/commit/5f9387c) Constants magic_quotes handling needs function from Core (Hamish Friedlander)
 * 2013-08-05 [041466f](https://github.com/silverstripe/sapphire/commit/041466f) Token redirect where in IIS a / needs adding between host & url (Hamish Friedlander)
 * 2013-08-02 [a685a8d](https://github.com/silverstripe/sapphire/commit/a685a8d) Include flushtoken when install redirects to successfullyinstalled (Hamish Friedlander)
 * 2013-08-01 [3420587](https://github.com/silverstripe/sapphire/commit/3420587) Flush on memory exhaustion and headers sent (Hamish Friedlander)
 * 2013-07-23 [a1ea905](https://github.com/silverstripe/sapphire/commit/a1ea905) Nice errors and allows flush on module removal (Hamish Friedlander)
 * 2013-07-22 [84011aa](https://github.com/silverstripe/sapphire/commit/84011aa) Only suppress fatal errors (Hamish Friedlander)
 * 2013-07-19 [a312cd0](https://github.com/silverstripe/sapphire/commit/a312cd0) Ignore invalid tokens instead of throwing 403 (Hamish Friedlander)
 * 2013-07-19 [036c36a](https://github.com/silverstripe/sapphire/commit/036c36a) Have ParameterConfirmationToken work regardless of include path (Hamish Friedlander)
 * 2013-07-18 [1298d4a](https://github.com/silverstripe/sapphire/commit/1298d4a) Prevent DOS by checking for env and admin on ?flush=1 (#1692) (Hamish Friedlander)
 * 2013-07-15 [999fd39](https://github.com/silverstripe/sapphire/commit/999fd39) preg_replace_callback in emailer was broken (Stephen Shkardoon)
 * 2013-06-13 [3b40711](https://github.com/silverstripe/sapphire/commit/3b40711) Resize infinite loops in IE8 (fixes #575) (Ingo Schommer)
 * 2013-05-27 [c7f1412](https://github.com/silverstripe/silverstripe-cms/commit/c7f1412) #651 Broken redirection after creating new folder in assets (Mike Parkhill)
 * 2013-05-23 [c85c495](https://github.com/silverstripe/sapphire/commit/c85c495) GridFieldFilterHeader works without non-filterable cols (Ingo Schommer)
 * 2013-05-08 [00b8ffd](https://github.com/silverstripe/sapphire/commit/00b8ffd) File class typo (Tony Air)
 * 2013-04-26 [b211f22](https://github.com/silverstripe/sapphire/commit/b211f22) JSONDataFormatter wrong relation identifiers (fixes #1795) (Ingo Schommer)
 * 2013-04-20 [41c0f80](https://github.com/silverstripe/sapphire/commit/41c0f80) Only block root vendor folder (colymba)
 * 2013-04-01 [df4d742](https://github.com/silverstripe/sapphire/commit/df4d742) Saving of custom meta tags (fixes #8288) (Joseph Madden)
 * 2013-03-29 [3aced11](https://github.com/silverstripe/sapphire/commit/3aced11) GridFieldFilterHeader only filters on last filter (Stig Lindqvist)
 * 2013-03-27 [19a8545](https://github.com/silverstripe/sapphire/commit/19a8545) update deprecated 'live' jquery to 'on' (Naomi Guyer)
 * 2013-03-25 [0ebd525](https://github.com/silverstripe/silverstripe-cms/commit/0ebd525) Unset "underneath page" title when switching to "top" in "add page" (Ingo Schommer)
 * 2013-03-25 [3f2b6a5](https://github.com/silverstripe/sapphire/commit/3f2b6a5) Don't silently unset ParentID in "add page" dialog (Ingo Schommer)
 * 2013-03-25 [0a283ea](https://github.com/silverstripe/sapphire/commit/0a283ea) Unset internal metadata on TreeDropdownField setValue() (Ingo Schommer)
 * 2013-03-20 [2787d36](https://github.com/silverstripe/sapphire/commit/2787d36) "Insert Link" and other TinyMCE loading bugs (fixes #8327) (Ingo Schommer)
 * 2013-03-20 [143317c](https://github.com/silverstripe/sapphire/commit/143317c) SQL Injection in CsvBulkLoader (fixes #6227) (Stephen Shkardoon)
 * 2013-03-19 [9ac104b](https://github.com/silverstripe/sapphire/commit/9ac104b) $_COOKIES is not un-magic_quotes'd (Stephen Shkardoon)
 * 2013-03-18 [5c933b4](https://github.com/silverstripe/silverstripe-cms/commit/5c933b4) SilverStripeNavigator shows wrong message. (uniun)
 * 2013-03-12 [dd6f33a](https://github.com/silverstripe/sapphire/commit/dd6f33a) Respect tree node limits, fix search result node display (Ingo Schommer)
 * 2013-02-26 [a8a10f8](https://github.com/silverstripe/sapphire/commit/a8a10f8) Transaction stub methods for better cross 2.x and 3.x compat (Ingo Schommer)
 * 2013-02-17 [c7b0666](https://github.com/silverstripe/silverstripe-cms/commit/c7b0666) Escape page titles in CommentAdmin table listing (Ingo Schommer)
 * 2013-02-15 [428cbe4](https://github.com/silverstripe/sapphire/commit/428cbe4) issue with Injector::create not passing args (Marcus Nyeholt)
 * 2013-01-30 [b24a0a5](https://github.com/silverstripe/sapphire/commit/b24a0a5) Remove extraneous &lt;/div&gt; breaking IE8 image embedding (os#8218) (Mateusz Uzdowski)
 * 2013-01-15 [50995fb](https://github.com/silverstripe/sapphire/commit/50995fb) Undefined `$allowed_actions` overrides parent definitions, stricter handling of $allowed_actions on Extension (Ingo Schommer)
 * 2013-01-06 [eecd348](https://github.com/silverstripe/sapphire/commit/eecd348) Keep Member.PasswordEncryption setting on empty passwords (Ingo Schommer)
 * 2012-10-26 [d8b106e](https://github.com/silverstripe/sapphire/commit/d8b106e) TestRunner was not cleaning up DB on failure (Craig Weber)
 * 2012-10-10 [e2bf964](https://github.com/silverstripe/sapphire/commit/e2bf964) 7934 When lazy loading fields respect version of the record (jean)
 * 2012-10-05 [1ffbb8f](https://github.com/silverstripe/sapphire/commit/1ffbb8f) Exclude framework/dev from text collection (fixes #4754) (Ingo Schommer)
 * 2012-09-10 [17bd873](https://github.com/silverstripe/sapphire/commit/17bd873) 7853 Flush the content of drop down fields when closing html editor linker (links and images) (jean)
