# 2.4.2-rc1

## Changelog

### Features and Enhancements

 * [rev:110757] added the ability to toggle the use draft site setting
 * [rev:110467] #5977 Added optional argument to !ClassInfo::getValidSubClasses() and removed harcoded !SiteTree
 * [rev:110211] disable basic auth by default, tests run on the assumption it is disabled.
 * [rev:109104] Added -v / --verbose option to dev/tests/*, to make it output every single test name before it starts that test.
 * [rev:109101] Session::set_cookie_path() and Session::set_cookie_domain() are now possible. This is useful for sharing cookies across all subdomains, for example.
 * [rev:108942] make !RestfulService support PUT method.
 * [rev:108663] ErrorDocument in default .htaccess so Apache serves default 404 and 500 server error pages
 * [rev:108644] #3828 500 server error page is created by default on dev/build
 * [rev:108499] New Member records are populated with the currently set default through i18n::set_locale()
 * [rev:108437] Restful service returns cached response on http and curl errors
 * [rev:108428] #2856 Limiting of relative URLs for Director::forceSSL() using a map of PCRE regular expressions
 * [rev:108418] Added  argument to SQLQuery->leftJoin()/innerJoin() (#5802, thanks stojg)
 * [rev:108417] Full-text search with double quotes returns too many results. ticket #5733. Thanks ktauber.

### API Changes

 * [rev:110856] Member->canEdit() returns false if the editing member has lower permissions than the edited member, for example if a member with CMS_ACCESS_!SecurityAdmin permissions tries to edit an ADMIN  (fixes #5651)
 * [rev:109156] #5873 !DataObjectSet::shift() now performs a proper shift instead of unshift (wrong). Please use !DataObjectSet::unshift($item) if unshifting was intended!
 * [rev:109156] Added !DataObjectSet::pop()
 * [rev:109103] Member::set_session_regenerate_id() can now be used to disable Member::session_regenerate_id() which can break setting session cookies across all subdomains of a site

### Bugfixes

 * [rev:110901] delete orphaned records from versioned tables when updating. #5936
 * [rev:110894] Protect !MemberTest from side effects caused by auth_openid and forum modules
 * [rev:110889] Respecting field specific locale settings in !DatetimeField and !DateField when validating and saving values (fixes #5931, thanks Tjofras)
 * [rev:110859] Disallow addition of members to groups with !MemberTableField->addtogroup() when the editing member doesn't have permissions on the added member
 * [rev:110858] Don't suggest members in !SecurityAdmin->autocomplete() that the current user doesn't have rights to edit (fixes #5651)
 * [rev:110857] Enforcing canEdit() checks in !ComplexTableField_Popup - making form readonly if the current user can't edit
 * [rev:110838] Case insensitive !DateField value navigation (fixes #5990, thanks gw0(
 * [rev:110835] Passing $name in !MoneyField->!FieldCurrency() (fixes #5982, thanks andersw)
 * [rev:110809] Removing "typography" class from HTMLEditorField container (should just apply to the contained `<iframe>`) (fixes #5949)
 * [rev:110808] Allowing $extraClass on !CheckboxField !FieldHolder (fixes #5939, thanks mobiusnz)
 * [rev:110759] ensure that pages can only be requested from staging and live
 * [rev:110463] Fixed boundary PHP notice case in !RequiredFields::php() where a field name may not be defined in the $data array when a Form is submitted
 * [rev:110439] #5811 Fixed default selection of root node when CMS first opened (no currentPage set in session)
 * [rev:110262] fix !TranslatableSearchFormText by supporting fulltext search for MSSQL and using extendedSQL function call that augments queries properly (previously it was using DB::query which does not augment). Added wait to !TranslatableSearchFormText so the test actually passes.
 * [rev:110197] MigrateSiteTreeLinkingTask now takes a direct map when querying the page tracked links instead of looping through the direct result set. This fixes SQL Server failing when MARS (Multiple Active Result Sets) is disabled
 * [rev:110165] Fixed missing "Save" action input label on !ComplexTableField popup form
 * [rev:110130] force the test to wait until indexing completes. Do not use stop words ('me')
 * [rev:109834] BasicAuthTests fail when Member's unique_identifier_field is anything except the default of Email
 * [rev:109714] disable basic auth for the restful controller test
 * [rev:109712] makeRelative would return "false" for the root path, empty string is expected - fix that
 * [rev:109712] change the check in forceSSL to work on Windows - it sets the $_SERVER['https'] to off, instead of null
 * [rev:109591] getItem didn't consider the PostgreSQL SQL syntax. Columns with Capital letters must be quoted. Added quotes to the where clause in getItem. I didn't added quotes to the baseTable because it causes PostgreSQL errors (tables can not be double quoted, just single quoted).
 * [rev:109168] $val is now cast as an int to prevent strings always returning true (YES)
 * [rev:109155] Validator::requiredField() should check the required field submitted value is an array before check strlen(). Some fields submitted as an array, e.g. !MoneyField
 * [rev:109128] Remove () that was breaking coverage report
 * [rev:109106] sort order of widgets is now fixed.
 * [rev:109102] Themed permissionFailure messages
 * [rev:109083] Group::getCMSFields() should use Tab instances with a fixed name instead of translated one, leaving the translation for the tab title instead
 * [rev:109082] SiteTree decorated canView() checks not being passed through to !SiteTree::canView()
 * [rev:109081] StringField::setNullifyEmpty() should assign the given value boolean, not evaluate whether it's true or not
 * [rev:109079] Count() call on a non-object in File::!BackLinkTrackingCount()
 * [rev:109063] Fixed File::getAbsoluteURL() absolute generation
 * [rev:109062] File::getAbsoluteURL() should return a URL, not a filesystem path
 * [rev:108887] CSVBulkLoader import method now no longer requires files to end in '.csv'. Some projects want to import files in CSV format, but not of csv file type.
 * [rev:108811] Added specific border case for array form data in !RequiredFields::php()
 * [rev:108792] Fixed validation to accept arrays (!FileField case)
 * [rev:108633] NumericField javascript does not accept negatives, make use of isNaN built-in javascript function instead of custom regex
 * [rev:108515] #5627 Clear session on logout
 * [rev:108513] EMAIL_BOUNCEHANDLER_KEY cannot be defined
 * [rev:108512] Validator/!RequiredFields should not regard "0" as an empty value
 * [rev:108509] SapphireTest::create_temp_db() should restore the SS error handler from the PHPUnit one temporarily in case there's any errors building
 * [rev:108492] Undefined variable destURL in Director::forceWWW() (regression from r107094)
 * [rev:108436] Checking for existence of $('!SwitchView') (fixes #5282)
 * [rev:108432] Database password input in installer should be password, so that the password is obfuscated when input
 * [rev:108427] Take note of output format when building Location header for !RestfulServer
 * [rev:108422] CurrencyField doesn't accept negative value (#5769, thanks simon_w)
 * [rev:108421] Fixed !ContentNegotiator to handle HTML and XHTML base tags properly when converting, regression from r108413
 * [rev:108413] #5855 SSViewer::get_base_tag() should produce a properly closed base tag for XHTML (thanks smorris!)
 * [rev:108409] #5862 JSON output of JSONDataFormatter now uses quotes for keys to be safer
 * [rev:108408] Member_!ProfileForm should fallback to english text for save button if no translation defined for current language
 * [rev:108407] #5852 Missing translation for !SecurityAdmin save button causes it to have no text, should default to english "Save"
 * [rev:108400] Undefined variable when calling !DataObject::many_many_extraFields() and relation name couldn't be found for the component
 * [rev:108399] DataObjects without the Versioned decorator cannot have a "Version" field. ticket #5775. Thanks ajshort
 * [rev:108397] Added condition to avoid error creating "!PastMember" cookie on dev/build (ticket #5780) Thanks simon_w
 * [rev:108396] Applied/edited paradigmincarnate's patch to quote plaintext email with htmlEmail (#5120)

### Minor changes

 * [rev:110847] Documentation
 * [rev:110837] Check in !TableListField->!HighlightClasses() (fixes #5993, thanks lx)
 * [rev:110836] Avoid using ASP-style tags in SSViewer comments, it confuses PHP with asp_tags=ON (fixes #5976, thanks ezero)
 * [rev:110440] Warning about install.php existing for root site tree node as well (!SiteConfig form)
 * [rev:110435] German translations for cms javascript (#5921, thanks bartlomiej)
 * [rev:110243] added missing closing tag
 * [rev:110205] Make dev/build not constantly show a changed index because of whitespace between VersionID and Version in the index spec
 * [rev:110200] Removed removeDuplicates() call on linked pages !DataObjectSet in !MigrateSiteTreeLinkingTask which is no longer required, as the duplicate results were fixed in !DataObject directly
 * [rev:110190] only call next() in iterator validation on initialisation or after reset NOT if current value is invalid
 * [rev:109788] repair installer for sqlite
 * [rev:109787] repair installer for sqlite
 * [rev:109405] neatly quote identifiers
 * [rev:109382] return a fail instead of an error
 * [rev:109334] Remove whitespace if Surname field set on Member, but not !FirstName
 * [rev:109333] Tests for Member::getName() and Member::setName()
 * [rev:109330] trim space off end of firstname if surname is not set. #5925
 * [rev:109274] CSSContentParser::__construct() now gives a better error if the content could not be parsed. This will mostly happen if tidy isn't present.
 * [rev:109165] phpDoc updates for SS_!LogFileWriter and SS_!LogEmailWriter
 * [rev:109156] Unit tests for !DataObjectSet::shift(), !DataObjectSet::unshift() and !DataObjectSet::pop()
 * [rev:109152] Doc update for Director::forceSSL()
 * [rev:109127] Applied patch from walec51 for <% control %> on empty set (#5579) Also added unit tests by ischommer
 * [rev:109105] Fix links etc, and remove www. from SS urls
 * [rev:109100] Clear out the test database in between each salad scenario.
 * [rev:109066] Added tests for File::getURL() and File::getAbsoluteURL()
 * [rev:108961] remove SQL table alias keyword AS
 * [rev:108666] Fixed tests not working on the web side as redirection to https would occur
 * [rev:108665] Fixed !DirectorTest to restore it's REQUEST_URI state to the original one after each test method is run
 * [rev:108640] allow $icon to be overridden on !ErrorPages. PATCH via martljn (#5875).
 * [rev:108571] Changed unknown web server text
 * [rev:108570] Allow checking for a specific IIS version (parameter to !InstallRequirements::isIIS())
 * [rev:108569] Removed double up of similar logic in !InstallRequirements
 * [rev:108568] Simplified discovery of webserver during install
 * [rev:108561] Removed unncessary isset() check
 * [rev:108559] Add some documentation to !LeftAndMain_right.js
 * [rev:108546] Removed command line functionality from installer which is no longer used
 * [rev:108518] Fixed failing test as session being set before logging out and losing BackURL
 * [rev:108500] Fixed failing tests because of locale not being set to the default in !SapphireTest::setUp()
 * [rev:108442] Translations in CMSMain_left.ss
 * [rev:108441] Making "todo" tab title translatable
 * [rev:108435] Fixed Director::forceSSL() breaking unit tests because headers were already sent
 * [rev:108434] Reverted r108433
 * [rev:108433] DirectorTest should not extend from !FunctionalTest (regression from r108428)
 * [rev:108376] Add trailing slash to image tag (thanks to mattclegg)
 * [rev:108375] Cross-referencing some documentation

### Other

 * [rev:110241] #5870 Block web requests to silverstripe-cache directory via htaccess !RedirectMatch rule or web.config hiddenSegments functionality if using IIS 7.x
 * [rev:109177] Revert "MINOR: Applied patch from walec51 for <% control %> on empty set (#5579) Also added unit tests by ischommer"
 * [rev:109177] This was not supposed to be pushed out yet.
 * [rev:109177] 
 * [rev:109177] This reverts commit 9c2aafa414948314236674e31fd756797d695139.
 * [rev:109163] Revert "BUGFIX: sort order of widgets is now fixed."
 * [rev:109163] 
 * [rev:109163] This reverts commit 1e7781ba2b8ac30333a20d9a1b0bcb9b4ba5b0b0.
 * [rev:109099] Added dev/tests/emptydb to clear out test session databases.
 * [rev:108417] Using htmlentities($keywords,ENT_NOQUOTES) instead of proposed solution

<code>./sscreatechangelog --version 2.4.2-rc1 --branch branches/2.4 --stopbranch tags/2.4.1</code>