# 2.4.0-rc2 (2010-04-30)

##  Overview

 * Improved permission handling in the "Security" section: "Access to all CMS sections" not automatically checks all inherited permissions
 * Fixed usage of file, image and link selection in the CMS with multilingual sites (Translatable)
 * Fixed core unit tests for PostgreSQL
 * Fixed a core bug in PostgreSQL concerning the ordering and grouping of DataObjectSet results
 * Allowing the new "SiteConfig" interface to save TinyMCE content, enabling easier usage of default content which doesn't belong to a single page
 * Updated api.silverstripe.org to accurately reflect the current API in different releases, with a nightly rebuild to keep it that way


## Changelog

###  Features and Enhancements

 * [rev:103730] use FileSystem class to create cache directory to unsure the right permissions are set
 * [rev:103710] MemberLoginForm::performLogin() now uses the authenticator_class variable set in subclasses of MemberLoginForm, without having to overload performLogin()
 * [rev:103708] create cache directory when it does not exist before running the cache build test
 * [rev:103581] Added i18n::set_default_locale() to set standard locale (which is different from "current locale" retrieved through i18n::get_locale())
 * [rev:103466] make the getTree ajax call more generic so it get local from its containing form, rather than hard-coded "Form_EditForm_Locale" cos the field is not only used in "EditForm"
 * [rev:103465] to make the FileIFrameField and TreeSelectionField easy to use in CMS with Translatable on.
 * [rev:103328] Automatically checking all "CMS section" checkboxes in PermissionCheckboxSetField.js when "Access to all CMS interfaces" is selected. Saving these permissions individually also resolves certain edge cases like #5438.
 * [rev:103250] added tests for checking the change password functionality, including the resulting redirection (from #5420)
 * [rev:103229] allow ChangePasswordForm to redirect to BackURL (from #5420)
 * [rev:103198] allow onAfterPublish and onBeforePublish handlers directly on Page classes (#5112)
 * [rev:103047] allow to check for any changed fields on the DataObject, this is expected behaviour when isChanged function is called without parameters (#5421, patch by walec51)
 * [rev:102899] added language (Ticket #5390)


###  API Changes

 * [rev:103792] changed the modulus offset to 1 to correctly order sets


###  Bugfixes

 * [rev:103803] Rebuilding test database for postgresql in SearchFormTest and TranslatableSearchFormTest to avoid stale index information in the database
 * [rev:103745] static publisher for a site that resides in a subfolder of webroot
 * [rev:103734] Fix linkCount .js in AssetAdmin deleteRecord (ticket #5486)
 * [rev:103706] Use correct quoting for BrokenLinksReport (ticket #5474)
 * [rev:103674] #5485 PermissionCheckboxSetField javascript would always uncheck all CMS_ACCESS_* permission checkboxes on initialize event
 * [rev:103620] Fixed ordering by aggregate columns for DataObject::get() calls with joins.
 * [rev:103613] Fixed unlimitedRowCount() for grouped queries
 * [rev:103612] Ensure that group by of many-many queries with extraFields is set correctly.
 * [rev:103591] ModelAsController test failed for projects which do not support nested urls. This fix stores the original configuration and enables 'nested-urls' at the beginning of the tests and reset the state in tearDown.
 * [rev:103588] #5362: Fixed duplicate removal on DataObject:get() with join argument for all databases.
 * [rev:103582] Choosing i18n::default_locale() in Member->populateDefaults() instead of "current locale". This fixes a bug where a new member created through admin/security automatically "inherits" the current locale settings of the admin creating it.
 * [rev:103552] CSSContentParser now reports better errors by using simplexml_load_string() instead of SimpleXMLElement directly
 * [rev:103519] Prevent duplicate HTML IDs in ModelAdmin
 * [rev:103518] Fixed redirection in PageCommentInterface to use Link() instead of URLSegment (fixes 4200, thanks ktauber)
 * [rev:103461] Renamed Nested URLs are automatically redirected to their new location with 301 HTTP status code in ModelAsController/ContentController (fixes #5393, thanks cbarberis)
 * [rev:103451] Fixed CurrencyField->jsValidation() regex escaping (fixes #5462, thanks mobiusnz)
 * [rev:103450] DateField with setConfig('dmyfields') now validates TRUE for empty values (fixes #5458)
 * [rev:103448] Allow EDIT_SITECONFIG permission selection in admin/security (fixes #5459)
 * [rev:103341] Don't show error when adding default SiteConfig records after upgrading a site.
 * [rev:103336] Using try/catch in MemberTableField->saveComplexTableField() similiar to parent implementation, which means trying to save a Member duplicate doesn't end up in a fatal error (fixes #5444)
 * [rev:103255] static publishing now uses the last non-null theme, OR the value defined in StaticPublisher::static_publisher_theme.
 * [rev:103240] r101093 broke casting of values from the failover object. Add lookup to the failover for casting info, and add test
 * [rev:103226] made the invalid password message translatable; disallow new blank password (as it makes it impossible to login); Member::checkPassword now returns ValidationResult - handle that properly (#5420, patch submitted by walec51)
 * [rev:103214] the decorator was not completely removed, which caused trouble for tests running later in the same batch
 * [rev:103183] default sort column now quoted
 * [rev:103182] default sort column now quoted
 * [rev:103127] realtime publishing now enabled by default
 * [rev:103099] Only replace double slashes in SS_HTTPRequest->__construct() for relative- its a failsafe against wrongly formatted URLs like 'admin//assets' instead of 'admin/assets', but breaks absolute URLs with 'http://' prefix
 * [rev:103092] disallow numeric actions - numeric array indexes are incorrectly picked up as allowed actions (#5331)
 * [rev:103083] make the javascript-producing functions behave in the same way. Now they will return a javascript snippet and the caller is responsible for adding it to a FormResponse. Removes the duplication in AJAX response which happened when FormResponse::add has been used before the call to JS helper functions (#5359)
 * [rev:103037] correct mollom field mapping
 * [rev:103012] added optional separator for http_build_query in HTTP:setGetVar(). this fixes sorting columns in ModelAdmin (ticket #5325).
 * [rev:102730] Fixing RquestHandler->checkAccessAction() on PHP 5.2 - ReflectionMethod->class returns inconsisent results in older PHP versions. (see r102003)
 * [rev:102712] Fixed CTF sorting in ModelAdmin results (was failing because of missing 'ResultAssembly' GET parameters
 * [rev:102686] Float should always be not null and default 0 in the database
 * [rev:102545] Using i18n::get_locale() in ContentController->ContentLocale() to ensure the correct locale can be used in templates withouth Translatable enabled (broken in r97207, thanks DesignCity) (from r102544)
 * [rev:102460] #5316 Float and Double should never try to save NULL as the "null" value
 * [rev:102436] #5320 ManyManyComplexTableField::getQuery() now uses T-SQL compatible syntax CASE WHEN instead of IF THEN which works in multiple databases as well
 * [rev:102386] delete from published site never calls canDeleteFromLive(). (via marcus #5364)
 * [rev:102320] fixed invalid HTML output from page comments template
 * [rev:102300] SSViewer now allows cli to do a flush on non-dev environments
 * [rev:102265] Fix Salad tests
 * [rev:102237] exchanged MySQL CONCAT function with ANSI compliant operator
 * [rev:102160] allow HTMLEditorFields to save in SiteConfig, fixes #5246
 * [rev:102156] fallback to the standard authenticator before throwing user_error as in some cases auth  method is not passed back to the login form
 * [rev:102094] Fixed bug with SiteTree::onBeforeWrite() that broke subsites.
 * [rev:102084] #5343: Call DataObject::onBeforeWrite only once for SiteTree
 * [rev:102081] #5337: Allow decoration of DataObject
 * [rev:102074] Fixed SiteTree::page_type_classes() to exclude 'SiteTree' even if on array position 0 - slight difference in return values from Postgres to MySQL (fixes #5336)
 * [rev:102072] Logging in with an invalid email returns no error message (fixes #5332, thanks ajshort)


###  Minor changes

 * [rev:103821] Fixed TranslatableSearchFormTest for postgresql (strict type assertions)
 * [rev:103819] Fixed TranslatableTest for postgresql database driver (mostly ordering issues)
 * [rev:103818] Fixed CMSMainTest for postgres by not hardcoding fixture IDs
 * [rev:103799] Removed mysql specific functionality from DataObjectSchemaGenerationTest and moved it to a new MySQLDatabaseTest
 * [rev:103798] Fixed TranslatableTest for postgresql database driver (mostly ordering issues)
 * [rev:103787] update unit test for checking whether a DataObject has been changed or not without providing a field name
 * [rev:103763] Unsetting state in FilesystemPublisherTest (regression from r103745)
 * [rev:103744] Allowing querystring arguments in sapphire/Makefile
 * [rev:103692] Restored docblock of SQLQuery::unlimitedRowCount()
 * [rev:103640] Fixed AggregateTest for MSSQLDatabase (wrong date formatting)
 * [rev:103606] recache tables if cache is empty
 * [rev:103558] sort page comment table by Created field - show newest entries first
 * [rev:103555] added moderation message for non-ajax mode
 * [rev:103533] Fix to ModelAdmin, part of r103519
 * [rev:103520] add more in-line documentation and fix the typo: should => should not
 * [rev:103515] Database quoting in TreeDropdownField (fixes #5484)
 * [rev:103485] Documentation
 * [rev:103398] Fixed phpdoc documentation
 * [rev:103397] Fixed phpdoc documentation
 * [rev:103391] Fixed phpdoc documentation (from r103390)
 * [rev:103388] Fixed phpdoc documentation (from r103385)
 * [rev:103386] Fixed phpdoc documentation (from r103384)
 * [rev:103345] Reverted accidental commit of date_default_timezone_set() to Pacific/Auckland (see r89164)
 * [rev:103337] Returning ValidationResult from Member->onBeforeWrite() to ensure the ValidationException is compatible with MemberTableField (related to r103336)
 * [rev:103322] Enum DBField class should default to ExactMatchFilter to avoid wrong results with overlapping Enum values in LIKE queries (see #5434)
 * [rev:103226] typo
 * [rev:103093] fixed the error message on class conflict (#5439, patch submitted by rorschach)
 * [rev:102909] Using canView() instead of deprecated can('view') in ContentController
 * [rev:102901] reverted wrong change
 * [rev:102518] Fixed undefined variable in SiteTree::can_edit_multiple() (broken in r83442) (from r102516)
 * [rev:102149] Fixed phpDoc @package and @subpackage for MySQLDatabaseConfigurationHelper
 * [rev:102077] added abstract datetime helper functions
 * [rev:102071] Removed unnecessary sapphire/thirdparty/.gitignore, as the directory doesnt contain svn:externals any longer (fixes #5334)
 * [rev:102045] Fixed spelling mistake in ConfigureFromEnv class documentation

`./sscreatechangelog --version 2.4.0-rc2 --branch branches/2.4 --stoprevision 102039`