# 3.1.12

# Overview

This security release resolves some XSS and an XML vulnerability in the Framework.

## Upgrading

If your code relies on `Convert::xml2array` there are some important things to consider with regards to
certain vulnerabilities. In this release additional options have been added to this method to assist
users in guarding against these risks, although each option has been turned off by default.

Please refer to http://phpsecurity.readthedocs.org/en/latest/Injection-Attacks.html#xml-external-entity-injection
on details of some of the specific reasons behind the need for these changes and how you can guard
against them in your code.

Specifically this method has these two new parameters:

 * The `$disableDoctypes` parameter has been added to disallow parsing of XML content containing
   a <!DOCTYPE > header, which may potentially contain unguarded or recursive entity definitions.
 * The `$disableExternals` parameter allows XML parsing to ignore any externally referenced
   dependency within the file, ensuring that injected XML is unable to invoke data from potentially
   hazardous sources.

## Security

 * 2015-03-20 [ee9bddb](https://github.com/silverstripe/sapphire/commit/ee9bddb) Fix SS-2015-010 (Damian Mooyman) - See announcement [ss-2015-010](http://www.silverstripe.org/software/download/security-releases/ss-2015-010-xss-in-directorforce-redirect)
 * 2015-03-20 [7f983c2](https://github.com/silverstripe/sapphire/commit/7f983c2) Fix SS-2014-017 (Damian Mooyman) - See announcement [ss-2014-017](http://www.silverstripe.org/software/download/security-releases/ss-2014-017-xml-quadratic-blowup-attack)
 * 2015-03-20 [604c328](https://github.com/silverstripe/sapphire/commit/604c328) Fixed XSS vulnerability relating to rewrite_hash (Christopher Pitt) - See announcements [ss-2014-015](http://www.silverstripe.org/software/download/security-releases/ss-2014-015-ie-requests-not-properly-behaving-with-rewritehashlinks), [ss-2015-009](http://www.silverstripe.org/software/download/security-releases/ss-2015-009-xss-in-rewritten-hash-links)

### Bugfixes

 * 2015-03-18 [b34c236](https://github.com/silverstripe/sapphire/commit/b34c236) Fix joins on tables containing "select" being mistaken for sub-selects Fix PHPDoc on SQLQuery::addFrom and SQLQuery::setFrom Fixes #3965 (Damian Mooyman)
 * 2015-03-11 [a61c08d](https://github.com/silverstripe/sapphire/commit/a61c08d) Security::$default_message_set Config value unusable (Loz Calver)
 * 2015-03-10 [9651889](https://github.com/silverstripe/sapphire/commit/9651889) Fix yaml generation to conform to version 1.1, accepted by transifex (Damian Mooyman)
 * 2015-02-25 [f5f41b2](https://github.com/silverstripe/sapphire/commit/f5f41b2) Ensuring custom CMS validator uses Object-&gt;hasMethod() to respect extension decorator pattern. (Patrick Nelson)
 * 2015-01-13 [9da7e90](https://github.com/silverstripe/silverstripe-cms/commit/9da7e90) . Missing translation entity (Elvinas L.)

## Changelog

 * [framework](https://github.com/silverstripe/silverstripe-framework/releases/tag/3.1.12)
 * [cms](https://github.com/silverstripe/silverstripe-cms/releases/tag/3.1.12)
 * [installer](https://github.com/silverstripe/silverstripe-installer/releases/tag/3.1.12)
