# 3.0.9

## Overview

### Default current Versioned "stage" to "Live" rather than "Stage"

Previously only the controllers responsible for page and CMS display 
(`LeftAndMain` and `ContentController`) explicitly set a stage through
`Versioned::choose_site_stage()`. Unless this method is called,
the default stage will be "Stage", showing draft content.
Any direct subclasses of `Controller` interacting with "versioned" objects
are vulnerable to exposing unpublished content, unless `choose_site_stage()`
is called explicitly in their own logic.

In order to provide more secure default behaviour, we have changed
`choose_site_stage()` to be called on all requests, defaulting to the "Live" stage.
If your logic relies on querying draft content, use `Versioned::reading_stage('Stage')`.

Important: The `choose_site_stage()` call only deals with setting the default stage,
and doesn't check if the user is authenticated to view it. As with any other controller logic,
please use `DataObject->canView()` to determine permissions.

	:::php
	class MyController extends Controller {
		private static $allowed_actions = array('showpage');
		public function showpage($request) {
			$page = Page::get()->byID($request->param('ID'));
			if(!$page->canView()) return $this->httpError(401);
			// continue with authenticated logic...
		}
	}

### API Changes

 * 2013-08-03 [0e7231f](https://github.com/silverstripe/sapphire/commit/0e7231f) Disable discontinued Google Spellcheck in TinyMCE (Ingo Schommer)