# 2.4.6 (2011-10-17)

## Overview

 * Security: Cross-site scripting on anchor links
 * Security: Possible SQL injection for MySQL when using far east character encodings
 * Security: SQL injection in Folder::findOrMake() parameter (used mostly in author-only CMS through `Upload::load()`)
 * Security: Privilege escalation from `EDIT_PERMISSIONS` to `ADMIN` for users access to the CMS (through `Member->getCMSFields()` and `TreeMultiselectField`)
 * Security: Potential remote code execution through serialization of page comment user submissions

## Upgrading Notes ##

### Security: User-uploaded files searchable when using FulltextSearchable ###

The FulltextSearchable default configuration includes all file names in the `assets/` folder.
While this is desired in most cases, it can lead to unexpected public visibility of data,
e.g. when uploaded through users. For example, CVs uploaded to a recruiting site most likely shouldn't be searchable.

Option 1: Disable file search completely (through `mysite/_config.php`):

	FulltextSearchable::enable(array('SiteTree'));

Option 2: Exclude file search from individual files by setting the `File.ShowInSearch` database property to `0`.
This property has been added in the 2.4.6 release. You can apply this retroactively to all files with this SQL statement:

	UPDATE `File` SET `ShowInSearch` = 0;

Please note that all these files are still exposed through the webserver if the path is known,
regardless of the `ShowInSearch` setting. To fully secure uploaded files, 
you can apply protection on a webserver level (e.g. `.htaccess`/`web.config` configuration).
Alternatively, you can proxy these files through your own permission control system
rather than exposing them directly through the webserver (e.g. with the ["securefiles" module](http://www.silverstripe.org/secure-files/)).

One common way to allow user-uploaded files is the ["userforms" module](http://www.silverstripe.org/user-forms-module/). This module has been altered to mark all uploaded files with `ShowInSearch`=0 by default.

### Security: Cross-site scripting (XSS) on anchor links

Anchor links (`<a href="#">`) are automatically rewritten by the SilverStripe
template parser to work with the `<base>` tag, which is a prerequisite for the framework.
This applies to all links passed through `SSViewer::process()` with the 'rewriteHashlinks' option enabled,
which is the framework default. Most commonly, these links will be created through the "Content"
field in the CMS, but any links inserted through template placeholders are vulnerable.
Modern browsers automatically fix basic XSS attacks through built-in XSS filters,
the vulnerability has only been confirmed in Internet Explorer 6 and 7 so far.

When upgrading to this SilverStripe version, please ensure to flush all template caches
by using the `dev/build/?flush=all` URL.

Thanks to Michael Best and Stefan Schurtz for reporting.

### Security: Possible SQL injection for MySQL when using far east character encodings

MySQL databases with a client set to certain far east encodings (SJIS, BIG5, GBK, GB18030, and UHC) 
can be vulnerable to SQL injections through usage of the
deprecated `[addslashes()](http://php.net/addslashes)` method.
These character sets are not supported by SilverStripe,
and not a default setting for MySQL - so its unlikely that you're affected.

By default, any 2.4.x installation sets the connection character set
to UTF-8, which doesn't have this vulnerability. Please check that
you have the following command in your `_config.php`:
`MySQLDatabase::set_connection_charset('utf8')`.
If this value isn't set, the default encoding in MySQL will apply
(which is usually "latin-1" or "ISO 8859-1", so not a vulnerable multibyte character set).

See [shiflett.org](http://shiflett.org/blog/2006/jan/addslashes-versus-mysql-real-escape-string)
for further details on the exploit. Thanks to Tim Spencer for reporting.

### Security: Page comments cookie possible vulnerability through unserialize()

Only applicable if any page allows comments (through the `SiteTree.ProvideComments` attribute),
and SilverStripe is of version 2.4.x (the feature wasn't present in 2.3, and has been extracted from trunk).
The `PageCommentInterface_Form->postcomment()` method stores user data for re-submission
through cookies (in case the first submission fails due to a validation error).
The data is stored via `serialize()`/`unserialize()`, making it potentially vulnerable
to improper method invocation or property injection. While we are not aware
of any active vulnerabilities, the serialization has been replaced with a more secure JSON format.

Thanks to Tim Klein for reporting.

Note: The commenting functionality has been moved to a new "[comments](https://github.com/silverstripe/silverstripe-comments)" module in trunk,
which has the same bugfixes applied.

## Changelog ##

### Features and Enhancements

 * 2011-10-17 [6d6fdd2](https://github.com/silverstripe/sapphire/commit/6d6fdd2) Added SSViewer::getOption() as a logical counterpart to SSViewer::setOption() (Ingo Schommer)
 * 2011-09-28 [ad13f80](https://github.com/silverstripe/sapphire/commit/ad13f80) Updated Windows installation documentation on using PHP Manager which takes out most of the PHP configuration effort. (Sean Harvey)
 * 2011-09-15 [bb757d1](https://github.com/silverstripe/silverstripe-cms/commit/bb757d1) Allow editing of new File.ShowInSearch flag through AssetTableField (Ingo Schommer)
 * 2011-09-15 [83ad8d4](https://github.com/silverstripe/sapphire/commit/83ad8d4) Added File.ShowInSearch flag to mirror the existing SiteTree.ShowInSearch flag - e.g. useful to limit visibility of user-uploaded files. Enforced in MySQLDatabase-&gt;searchEngine(). (Ingo Schommer)
 * 2011-05-26 [9d344a0](https://github.com/silverstripe/sapphire/commit/9d344a0) Allowing filtered arguments on specific functions like mysql_connect() in SS_Backtrace (Ingo Schommer)
 * 2011-02-11 [c6992f3](https://github.com/silverstripe/sapphire/commit/c6992f3) Adjusted from-source documentation to github and piston (Ingo Schommer)
 * 2011-02-07 [8bd01d6](https://github.com/silverstripe/sapphire/commit/8bd01d6) Added sapphire/docs (migrated from https://github.com/chillu/silverstripe-doc-restructuring) (Ingo Schommer)
 * 2011-02-02 [590dbb5](https://github.com/silverstripe/sapphire/commit/590dbb5) Made it possible to attach utility links to a ComplexTableField beyond just exporting (e.g. printing). (ajshort)

### Bugfixes

 * 2011-10-17 [16c3235](https://github.com/silverstripe/sapphire/commit/16c3235) Escaping base URLs for anchor links rewritten by SSViewer::process() with the 'rewriteHashlinks' option enabled (which is a framework default, and necessary because of the use of a &lt;base&gt; tag). Also added escaping for base URLs rendered through the 'php' variation of 'rewriteHashlinks' (Ingo Schommer)
 * 2011-09-28 [7805e3e](https://github.com/silverstripe/sapphire/commit/7805e3e) i18n::include_by_locale() assumes a themes directory always exists and causes error if that's not the case. Some projects don't require any themes, like pure applications. (Sean Harvey)
 * 2011-09-15 [b5ea2f6](https://github.com/silverstripe/silverstripe-cms/commit/b5ea2f6) Consistently using Convert::raw2sql() instead of DB::getConn()-&gt;addslashes() or PHP's deprecated addslashes() for database escaping (Ingo Schommer)
 * 2011-09-15 [73cca09](https://github.com/silverstripe/sapphire/commit/73cca09) Consistently using Convert::raw2sql() instead of DB::getConn()-&gt;addslashes() or PHP's deprecated addslashes() for database escaping (Ingo Schommer)
 * 2011-08-31 [af0bf45](https://github.com/silverstripe/silverstripe-cms/commit/af0bf45) fixing random changing of access tab radio buttons when refreshing the CMS with a URL such as /admin#Root_Access in Firefox. (Julian Seidenberg)
 * 2011-03-22 [01f5b3d](https://github.com/silverstripe/sapphire/commit/01f5b3d) Fixed MigrateSiteTreeLinkingTask not working correctly when CLRF newlines being used (Sean Harvey)
 * 2011-03-21 [fef7c32](https://github.com/silverstripe/sapphire/commit/fef7c32) Fixed SQL injection in Folder::findOrMake()  parameter. Exploitable through Upload::, although unlikely to be set via user input. (Ingo Schommer)
 * 2011-03-09 [de1f070](https://github.com/silverstripe/sapphire/commit/de1f070) Avoid privilege escalation from EDIT_PERMISSIONS to ADMIN through TreeMultiselectField (in Member-&gt;getCMSFields()) by checking for admin groups in Member-&gt;onChangeGroups() (Ingo Schommer)

### Minor changes

 * 2011-09-07 [01b08a5](https://github.com/silverstripe/sapphire/commit/01b08a5) removed incorrect getter/setter statements. (Will Rossiter)
 * 2011-08-20 [0ef4161](https://github.com/silverstripe/sapphire/commit/0ef4161) fixed syntax error in FormAction example. (Will Rossiter)
 * 2011-08-11 [62ed138](https://github.com/silverstripe/sapphire/commit/62ed138) documentation fixes from comments provided by the community. See below for a list of fixes: * fixed typo in Email documentation. * updated link for tutorial code to be relative now that bug #6408 is fixed * removed 2.3 related docs from 2.4 docs folder * fixed typo with Orientation documentation * updated old task url for images/flush (Will Rossiter)
 * 2011-05-19 [1704e42](https://github.com/silverstripe/sapphire/commit/1704e42) Return empty string from SQLQuery-&gt;sql() if SELECT is the default value, and no FROM is set (moved logic from DB-specific implementations) (Ingo Schommer)
 * 2011-03-21 [4c1866c](https://github.com/silverstripe/sapphire/commit/4c1866c) Updated contributing guidelines (Ingo Schommer)
 * 2011-03-21 [551bc5d](https://github.com/silverstripe/sapphire/commit/551bc5d) Improved patch documentation (Ingo Schommer)
 * 2011-03-08 [e9f20cf](https://github.com/silverstripe/sapphire/commit/e9f20cf) Documentation fixes (Ingo Schommer)
 * 2011-03-08 [5d87f29](https://github.com/silverstripe/sapphire/commit/5d87f29) Added fix to test troubleshooting docs about PHPUnit 3.5 missing MockObject class (Sean Harvey)
 * 2011-03-03 [cc0f62c](https://github.com/silverstripe/sapphire/commit/cc0f62c) Fixed title escaping in 'built in page controls' documentation (Ingo Schommer)
 * 2011-02-25 [ff63ba9](https://github.com/silverstripe/sapphire/commit/ff63ba9) Fixed broken i18nTest on Windows because of newline character differences (Sean Harvey)
 * 2011-02-25 [b559b9b](https://github.com/silverstripe/sapphire/commit/b559b9b) Fixed broken CSVParserTest on Windows because of newline character differences (Sean Harvey)
 * 2011-02-23 [918d9cb](https://github.com/silverstripe/sapphire/commit/918d9cb) Added docs/ contributing notes (Ingo Schommer)
 * 2011-02-22 [8ad630d](https://github.com/silverstripe/sapphire/commit/8ad630d) formatting changes and fixes to original document formatting (Michael Andrewartha)
 * 2011-02-21 [201506e](https://github.com/silverstripe/sapphire/commit/201506e) Added deprecated SapphireTest-&gt;assertType() in order to support PHPUnit 3.5 or newer, but stay backwards compatible to PHPUnit 3.4 (Ingo Schommer)
 * 2011-02-16 [f15f083](https://github.com/silverstripe/sapphire/commit/f15f083) Updated 'from source' docs (Ingo Schommer)
 * 2011-02-14 [994f7a3](https://github.com/silverstripe/sapphire/commit/994f7a3) Fixed blackcandy github links in docs (Ingo Schommer)
 * 2011-02-14 [629aa9b](https://github.com/silverstripe/sapphire/commit/629aa9b) Removed reference to additional CSS download in tutorial 4, moved to the silverstripe-installer project (Ingo Schommer)
 * 2011-02-12 [753a454](https://github.com/silverstripe/sapphire/commit/753a454) Fixed spacing in docs (Ingo Schommer)
 * 2011-02-12 [5bfc722](https://github.com/silverstripe/sapphire/commit/5bfc722) Removed duplicated 'additional requirements' from docs (Ingo Schommer)
 * 2011-02-07 [d23aeb2](https://github.com/silverstripe/sapphire/commit/d23aeb2) Fixing image links in docs/en/tutorials/ (Ingo Schommer)
 * 2011-02-04 [900b0a7](https://github.com/silverstripe/sapphire/commit/900b0a7) Fixed an empty utility container adding extra padding to the bottom of table fields. (ajshort)
 * 2011-02-02 [9e49d04](https://github.com/silverstripe/sapphire/commit/9e49d04) Only show the CTF utility bar if there are utilities available. (ajshort)

### Other

 * 2011-10-18 [96bee47](https://github.com/silverstripe/sapphire/commit/96bee47) MINO Switching 'rewriteHashlinks' sanitization from Convert::raw2att() to strip_tags() to make the resulting PHP more portable when mode is set to 'php' (Ingo Schommer)
 * 2011-09-08 [d15e850](https://github.com/silverstripe/silverstripe-cms/commit/d15e850) SECURITY Using JSON instead of serialize() to stringify user data in PageCommentsInterface (Ingo Schommer)
 * 2011-08-26 [0f91fb8](https://github.com/silverstripe/sapphire/commit/0f91fb8) Changes error reporting level to explicitly exclude E_DREPRECATED and E_STRICT, rather than xor. (simonwelsh)
 * 2011-08-26 [9ffa903](https://github.com/silverstripe/sapphire/commit/9ffa903) Adds missing semicolon for PHP5.4 support. (simonwelsh)
 * 2011-08-24 [8342f6b](https://github.com/silverstripe/sapphire/commit/8342f6b) Removed references to Language Chooser Widget until it can be updated to work with the new translation model. (simonwelsh)
 * 2011-08-22 [d8c6bda](https://github.com/silverstripe/sapphire/commit/d8c6bda) Removed profanity (Adam Rice)
 * 2011-06-09 [1f0277b](https://github.com/silverstripe/silverstripe-cms/commit/1f0277b) Add some missing CZ translations in cms javascript (Ladislav Kubes)
 * 2011-06-09 [5d3ddaf](https://github.com/silverstripe/silverstripe-cms/commit/5d3ddaf) Add some translation in cms core (Ladislav Kubes)
 * 2011-06-09 [46090cf](https://github.com/silverstripe/sapphire/commit/46090cf) fix language namespace (devel)
 * 2011-06-09 [5f3dde5](https://github.com/silverstripe/sapphire/commit/5f3dde5) Add some CZ translations (devel)
 * 2011-03-09 [f3ac573](https://github.com/silverstripe/sapphire/commit/f3ac573) Small text changes, added api links, cont. updating images for tutorials, fixed tutorials from member feedback (Michael Andrewartha)