#  2.4.0 (2010-05-05)

##  Overview

 * Support for hierarchical URLs
 * Support for MSSQL server database abstraction (via a separate module)
 * A "SiteConfig" record stores site-wide settings and default permissions and author groups for pages
 * "Permission Roles" are a simple way to combine multiple permission codes and assign them to groups in the Security interface. This makes permissions easier to maintain and less repetitive to set up.
 * The CMS searches for broken internal links to other pages and broken file references, and highlights them in the WYSIWYG editor
 * Dramatically reduced memory usage in CMS tree on larger sites (10,000+)
 * Performance improvements around Object and ViewableData property access.
 * Improved Shortcode API to allow for custom tag parsing in CMS content
 * More fine-grained permission control for translators
 * Improved unit test execution speed, increased number of tests cases by 30%
 * Better XSS security of the autologin token by using HTTPOnly cookies, more secure brute force login restrictions
 * Decreased memory usage in "Files & Images" section
 * Support for SQLite and PostgreSQL databases (via separate module)
 * Partial caching in templates, to allow for faster load times of certain aspects in dynamic pages.
 * Upload controls in the CMS no longer require the Adobe Flash plugin, and work again on Mac OSX.
 * File and page dropdown selections support inline searching, to make handling larger tree structures easier.
 * Fixed password hashing design flaw, which makes SilverStripe databases more portable between different server architectures.
 * Improved reporting API to unify the CMS sidebar reports and full-page reports on their own section. Its easier to add custom filters to reports.
 * Batch action handling handles larger tree structures, provides better visual feedback, and respects permissions on individual pages.
 * Global site configuration is translatable, meaning titles for your website can be in different languages without any switching in your templates.
 * Allow selection of themes through the site configuration interface (in addition to changing the theme via configuration code)
 * More fine-grained translation permissions: A group can be limited to only edit a certain language in the CMS.
 * Added dropdown to choose from existing anchor links when inserting a link from the CMS sidebar.
 * Team members can get permissions to see the draft version of a page in preview mode without requiring CMS access.
 * Pages of type "Virtual Page" have improved stability in regards to their permission control, translation and publication.
 * Improved broken link detection (''talk to Andy for more info'')
 * Removed the jsparty/ toplevel folder, and moved all its dependencies into sapphire/thirdparty and cms/thirdparty
 * More than 350 bugfix and enhancement commits, and 200 minor changes.

## Upgrading

In preparation for the pending release of 2.4.0 the following page contains all the information you need to know about
the changes that have been undertaken.

This page **doesn't include new features of 2.4.0** as such, just functionality that has changed or been removed since
2.3.

Before you start upgrading you should always backup your site directory and the database. Once you have a backup made
remove the `cms/`, `sapphire/` and `jsparty/` folders then copy in the new `cms/` and `sapphire/` folders from
your 2.4 download.


### Removed jsparty

The rather unorganised top level `jsparty/` folder has been removed from the core distribution and files separated to `cms/thirdparty` and `sapphire/thirdparty`. If your custom code referred to files in `jsparty` you will have to
update the links to the new location (either `sapphire/thirdparty/` or `cms/thirdparty/`). 

Thirdparty files which aren't used in any core features have also been removed such as jquery-validate. If you reference
any files at all from `jsparty` you should double check your paths.

### Removed Classes

As part of our effort to tidy the core product we have removed several classes which we believed didn't warrant
inclusion in the official release. They either were out of date functionality or superseded or just didn't justify
inclusion. Where needed we have moved the files to individual modules. Also note several field types which were due for
deprecating have been kept due to use within the CMS (''UniqueTextField'', `UniqueRestrictedTextField`). These however
are going to be removed for the next major release.

 | Class name                               | | Comment  | 
 | ----------                               | | -------  | 
 | `AjaxFormAction`                       | |          |
 | `BankAccountField`                     | | moved to [formfields_nz](http://open.silverstripe.org/browser/modules/formfields_nz) module | 
 | `CalendarDateField`                    | | use `DateField` with ''setConfig('showcalendar', true)'', moved to [legacydatetimefields](http://open.silverstripe.org/browser/modules/legacydatetimefields/trunk) module | 
 | `CompositeDateField`, `DMYDateField` | | use `DateField` with ''setConfig('dmyfields', true)'', moved to [legacydatetimefields](http://open.silverstripe.org/browser/modules/legacydatetimefields/trunk) module    | 
 | `ConfirmedFormAction`                  | |          |
 | `DMYDateField`                         | |          |
 | `DropdownTimeField`                    | | use `TimeField` with ''setConfig('showdropdown', true)'', moved to [legacydatetimefields](http://open.silverstripe.org/browser/modules/legacydatetimefields/trunk) module | 
 | `Email_Template`                       | | use `Email` instead | 
 | `GhostPage`                            | |          |
 | `GSTNumberField`                       | | moved to [formfields_nz](http://open.silverstripe.org/browser/modules/formfields_nz) module | 
 | `HiddenFieldGroup`                     | |          |
 | `PDODatabase`                          | |          |
 | `PermissionDropdownField`              | |          |
 | `PopupDateTimeField`                   | | use `DatetimeField`, moved to [legacydatetimefields](http://open.silverstripe.org/browser/modules/legacydatetimefields/trunk) module | 
 | `ReportField`                          | |          |
 | `TypeDropdown`                         | |          |


Some date/time field implementations were completely refactored, and their old implementations moved to the
[legacydatetimefields](http://open.silverstripe.org/browser/modules/legacydatetimefields/trunk) module:

 | Class name          | | Comment                                                                         | 
 | ----------          | |-------                                                                          | 
 | `LegacyDateField` | | old version of `DateField`, renamed to avoid conflicts with new `DateField` | 
 | `LegacyTimeField` | | old version of `TimeField`, renamed to avoid conflicts with new `TimeField` | 

### Removed SWFUpload

SWFUpload has been removed from the core package due to ongoing issues with supporting it. The CMS Content Editors
upload has been rewritten to use jQuery so no 2.3 functionality has been lost but if your module made use of this
library, then you will need to bundle it within your module. Related files which have been removed as a side effect of
this - `Upload.js`, `TinyMCEImageEnhancements.js`, `SWF_Upload.js` and `CMSMain_Upload.js`.

### Renamed Classes

We undertook some major work to reduce classname conflicts. Some classes have been namespaced with 'SS' to reduce
conflicts with other code. A couple notes - even though the classes have been renamed to `SS_`<ClassName>` the class is
still contained within the `ClassName.php'' file (no `SS_` prefix)


 | Original class name        | | New class name                | 
 | -------------------        | | --------------                | 
 | `Report`                 | | `SS_Report`                 | 
 | `HTTPRequest`            | | `SS_HTTPRequest`            | 
 | `HTTPResponse`           | | `SS_HTTPResponse`           | 
 | `HTTPResponse_Exception` | | `SS_HTTPResponse_Exception` | 
 | `Database`               | | `SS_Database`               | 
 | `Query`                  | | `SS_Query`                  | 
 | `SSDateTime`             | | `SS_Datetime`               | 
 | `Backtrace`              | | `SS_Backtrace`              | 
 | `Cli`                    | | `SS_Cli`                    | 
 | `Log`                    | | `SS_Log`                    | 
 | `LogEmailWriter`         | | `SS_LogEmailWriter`         | 
 | `LogErrorEmailFormatter` | | `SS_LogErrorEmailFormatter` | 
 | `LogErrorFileFormatter`  | | `SS_LogErrorFileFormatter`  | 
 | `LogFileWriter`          | | `SS_LogFileWriter`          | 
 | `ZendLog`                | | `SS_ZendLog`                | 
 | `HTMLValue`              | | `SS_HTMLValue`              | 

### Nested URLs enabled by default

When using our installer, the "nested URLs" feature will be enabled by default by a setting in *mysite/_config.php* (see
[blog
post](http://www.silverstripe.org/preview-of-silverstripe-2-4-hierarchical-urls-a-developer-community-contribution/)).
You can enable it manually for existing websites. Existing URLs will automatically change to the nested format without
republication (your old URLs should redirect automatically).

	:::php
	SiteTree::enable_nested_urls();


### SiteTree->Link() instead of SiteTree->URLSegment

Relating to the "nested URLs" feature, all *SiteTree* URLs should be accessed via *SiteTree->Link()* instead of using
the property *SiteTree->URLSegment* directly.

### Removed SiteTree::$add_action
 `$add_action` on Pages has been removed. If you want to define your own custom title for pages then you use
"`<myclassname>`.TITLE" in the i18n language tables instead or define your add action using `singular_name()`

	:::php
	// using the lang tables
	$lang['en_US']['RedirectorPage']['TITLE'] = "Redirector Page";


	// using singular_name()
	function singular_name() { return "Redirector Page"; }


### Removed dev/reset

Use `dev/tests/startsession` to create a new temporary database, or custom database tools like phpMyAdmin to
completely drop a database.


### Registering reports through SS_Report::register()

Removed `ReportAdmin->getReportClassNames()` in favour of `SS_Report::register()` to add custom reports to the CMS
(see [r98175](http://open.silverstripe.org/changeset/98175), [r98215](http://open.silverstripe.org/changeset/98215))

	:::php
	// in your _config file
	SS_Report::register("SideReport", "SideReport_NameOfReport");

### Fulltext Search and Indexes disabled by default

As of SilverStripe  2.4.0, no search engine is included by default. If you want to use a search engine, you should
enable it with this command in your _config.php:

	:::php
	FulltextSearchable::enable();


This will add a *SearchForm()* and *results()* method in your *Page_Controller*, as well as set up common fields
like SiteTree.Content to be indexed.

Note: Results may vary with database drivers other than *MySQLDatabase*. 

### Object Extension Instances

When working with extension instances directly on the extended object, please use the new *getExtensionInstances()*
getter. You need to manually call *setOwner($this)* before using the instance. 

Base setup:

	:::php
	class MyExtension extends Extension {
	  function myExtensionMethod() { // ... }
	}
	Object::add_extension('MyObject', 'MyExtension');


Wrong:

	:::php
	class MyObject extends DataObject {
	  function myExtensionMethod() {
	    $ext = $this->extension_instances['MyExtension'];
	    return $ext->myExtensionMethod();
	  }
	}


Right:

	:::php
	class MyObject extends DataObject {
	  function myExtensionMethod() {
	    $ext = $this->getExtensionInstance('MyExtension');
	    $ext->setOwner($this);
	    $ext->myExtensionMethod();
	  }
	}

### HTMLEditorField (TinyMCE) stores content as UTF8 instead of HTML Entities

Prior to 2.4.0, the TinyMCE JavaScript library would store a subset of special characters as HTML entities (see [TinyMCE
Configuration](http://wiki.moxiecode.com/index.php/TinyMCE:Configuration/entities)). SilverStripe expects UTF8 for user
input in the CMS, database storage as well as output. We have made this behaviour more consistent by converting the
TinyMCE entities back into UTF8 for database storage. 

### MySQL character set to UTF8 on new installations

The MySQL character set for SilverStripe used to be the database default (often "latin1", sometimes "utf8"). While all
textual database columns created by SilverStripe have been storing their content as "utf8" already in earlier releases,
MySQL fulltext search might not return the desired results with special characters (see
[#3582](http://open.silverstripe.org/ticket/3582)).

For new installations with a MySQL database backend, this will be set automatically to "utf8" by the installer in

*mysite/_config.php*. For existing sites built with SilverStripe 2.3, add the following code to your
*mysite/_config.php*.

	:::php
	MySQLDatabase::set_connection_charset('utf8');


No conversion of existing database schemas or content should be necessary.

### MySQL 5.0+ or newer required

See [server-requirements](/installation/server-requirements).

### BASE_PATH constant

Use `BASE_PATH` and `BASE_URL` instead of data from `$_SERVER` to calculate the base script path.

### Interface Change: "Site Content" tab renamed to "Pages"

The headlines of the left-hand tree panels have been changed accordingly.

### Data Migration: Files and Images

Existing files and images inside the Assets folder may not be displayed when you visit the 'Files & Images' tab in the
CMS.  If you get an error message when clicking through the folders in the site tree, this can be resolved by deleting
the content in the 'File' table in the database, and then clicking the 'Look for new files' button.

### Data Migration: User-defined forms

If you get errors in the User-define forms module, check that there is no column called 'CustomParameter' present in
either of the 'EditableFormField', 'EditableFormField_Live' or 'EditableFormField_versions' tables.

You need to login to your database management system (for example phpmyadmin) and delete the 'CustomParameter' column
from the EditableFormField table.

## Changelog

###  Features and Enhancements

 * [rev:104093] Add dev/build/defaults to call requireDefaultRecords
 * [rev:103730] use FileSystem class to create cache directory to unsure the right permissions are set
 * [rev:103710] MemberLoginForm::performLogin() now uses the authenticator_class variable set in subclasses of MemberLoginForm, without having to overload performLogin()
 * [rev:103708] create cache directory when it does not exist before running the cache build test
 * [rev:103581] Added i18n::set_default_locale() to set standard locale (which is different from "current locale" retrieved through i18n::get_locale())
 * [rev:103466] make the getTree ajax call more generic so it get local from its containing form, rather than hard-coded "Form_EditForm_Locale" cos the field is not only used in "EditForm"
 * [rev:103465] to make the FileIFrameField and TreeSelectionField easy to use in CMS with Translatable on.
 * [rev:103328] Automatically checking all "CMS section" checkboxes in PermissionCheckboxSetField.js when "Access to all CMS interfaces" is selected. Saving these permissions individually also resolves certain edge cases like #5438.
 * [rev:103250] added tests for checking the change password functionality, including the resulting redirection (from #5420)
 * [rev:103229] allow ChangePasswordForm to redirect to BackURL (from #5420)
 * [rev:103198] allow onAfterPublish and onBeforePublish handlers directly on Page classes (#5112)
 * [rev:103047] allow to check for any changed fields on the DataObject, this is expected behaviour when isChanged function is called without parameters (#5421, patch by walec51)
 * [rev:102899] added language (Ticket #5390)
 * [rev:101871] Updated automatic regression tests (Salad)
 * [rev:101670] RedirectorPage ExternalURL field now defaults to http:// to be consistent with the "Another website" option for HtmlEditorField LinkForm
 * [rev:101661] tidied up installer process to streamline process. Moved requirements to top and button to bottom and added visual seperation of the individual steps
 * [rev:101381] refactored requirements section to hide successful tests
 * [rev:101378] Added links to installation introduction text for sources of help and suggested web hosts
 * [rev:101246] Improved wording and styling in installer. Added links to server requirements, themes download, tutorial. Decreased vertical space before the "install" button to make it more obvious.
 * [rev:101127] Added 'Dependent pages' tab to CMS, to show virtuals, redirectors, and backlinks that point to this page.
 * [rev:101054] Allowing SQLite selection in installer
 * [rev:101054] Moved all Javascript containedin  install.php and config-form.html to install.js, and using jQuery to simplify logic
 * [rev:101054] Allow installer to attach custom form fields based on the install driver (as defined in _register_database.php)
 * [rev:100989] If no arguments specified for cli-script.php/sake, then provide a friendly message to the user on where to get help
 * [rev:100966] MoneyField currency dropdown can be made from an associate array like array('NZD'=>'New Zealand Dollor', 'USD'=>"United States Dollor') as well
 * [rev:100940] Added help text for "locale" setting in installer
 * [rev:100937] Redirecting to translated page when original is requested with a 'locale' GET parameter (e.g. 'about-us/?locale=de_DE' will redirect to 'ueber-uns' with a 301 HTTP response).  Implemented in ContentController->handleRequest(). (see #5001)
 * [rev:100908] Added DatabaseAdapterRegistry::unregister() to remove a database from the registry
 * [rev:100902] Added _register_database.php to sapphire which sets the SS provided databases for DatabaseAdapterRegistry
 * [rev:100893] Added Hebrew (he_IL) language to sapphire (thanks Oren, Yotam, tzvika, Amir, ohad)
 * [rev:100893] Added Lithuanian (lt_LT) language to sapphire (thanks Irmantas, Mindaugas, Donatas, Andrius)
 * [rev:100892] Added Hebrew (he_IL) language to cms (thanks Oren, Yotam, tzvika, Amir, ohad)
 * [rev:100892] Added Lithuanian (lt_LT) language to cms (thanks Irmantas, Mindaugas, Donatas, Andrius)
 * [rev:100884] Using jquery.live instead of livequery for SelectionGroup.js
 * [rev:100852] Updated jquery.ondemand.js to sapphire trunk version, to ensure compatibility with jQuery 1.4.2
 * [rev:100849] Only defining document.getElementsByClassName() in prototype.js if no native implementation exists (which speeds up the CMS). Ported from 'jquery13' module, thanks Hamish
 * [rev:100847] Updated jquery.livequery from v1.0.2 to v1.1.1 (located in sapphire/thirdparty/jquery-livequery/
 * [rev:100846] Updated jquery.metadata from ~v.1.0 to v2.1 (located in sapphire/thirdparty/jquery-metadata
 * [rev:100845] Updated jQuery.form library from v2.08 to v2.40 (located in sapphire/thirdparty/jquery-form
 * [rev:100844] Updated jQuery library from v1.2.6 to v1.4.2 (located in sapphire/thirdparty/jquery/
 * [rev:100799] Creating default "Content Authors" group with limited rights if no other groups exist.
 * [rev:100776] Better editing of roles through SecurityAdmin instead of a new "Roles" tab. Removed (previously unreleased) PermissionRoleAdmin. (see #4757)
 * [rev:100774] Allowing custom popup requirements in ComplexTableField without subclassing through $requirementsForPopupCallback
 * [rev:100771] Respecting SecurityAdmin::$hidden_permissions in PermissionRole->getCMSFields()
 * [rev:100769] you can now choose your site locale at install time
 * [rev:100753] Added 'updateImageForm', 'updateFlashForm', 'updateLinkForm' hooks to HtmlEditorField (the imageform hook was necessary to make the 'pixlr' module work) (see #3938)
 * [rev:100696] show all database systems we support, along with messages if the user cannot use them. Also allow 3rd parties to register their own database classes to appear in this list.
 * [rev:100536] Stored combined files in assets/_combinedfiles by default
 * [rev:100529] Combined files now live in assets/.combinedfiles by default
 * [rev:100528] #3387 Requirements now has a new static function called Requirements::set_combined_files_folder() for setting where the combined files should belong
 * [rev:100453] #4599 DataObjectSet now uses more array functions instead of performing equivalent tasks - thanks simon_w!
 * [rev:100423] Convert JSON functions now use the Services_JSON library where appropriate instead of custom code, and if json_decode() or json_encode() are available these are used
 * [rev:100400] #5072 RSSFeed_Entry::rssField() now respects custom getters on the data class
 * [rev:100327] allow ordering of page commented to be configurabled
 * [rev:100058] AssetAdmin now uses Upload_Validator instead of setting the rules directly on Upload
 * [rev:99954] you can now do coverage tests of single/multiple tests, or entire modules
 * [rev:99942] fixed forward button underneath result form
 * [rev:99929] #4787 Widget now respects updateCMSFields on extension classes so additional fields can be add (or existing ones removed)
 * [rev:99845] #4043 Allow setting the from address for debug information in SS_LogEmailWriter - thanks Hamish!
 * [rev:99841] #5024 Installer now checks that the user has entered a username and password correctly for the default admin, an additional button for re-checking requirements is now found at the bottom of the admin configuration section
 * [rev:99841] Error messages for database AND admin configuration are now in the same place at the top of the installer
 * [rev:99737] Allow DataObjectSet to remove duplicates based on any field  (#5094, thanks mobiusnz) (from r99736)
 * [rev:99692] Disabling/checking permission checkboxes in admin/security when 'ADMIN' permission is selected
 * [rev:99690] Saving group relations on SecurityAdmin->EditForm()/RootForm() through TreeMultiselectField instead of hidden 'Group'/'GroupID' values (from r99579)
 * [rev:99688] Saving MemberTableField through new 'Groups' field added in Member->getCMSFields(). (from r98882)
 * [rev:99679] added new PageCommnet to yml so we have different amounts of moderated/unmodereated
 * [rev:99677] Making  setting optional in MemberTableField. Field instances without  will list all members unfiltered, and remove members from the database rather than the group relation.
 * [rev:99677] Allow disabling of 'inline add' formfields in a MemberTableField through setPermissions(array('inlineadd')) (from r98825)
 * [rev:99667] Only show 'HTML Editor Config' dropdown in Group->getCMSFields() if more than one option exists
 * [rev:99666] Showing checkboxes as disabled for inherited roles in Group->getCMSFields() (from r99597)
 * [rev:99664] Added OptionsetField->setDisabledItems() to allow specifically disabling certain checkboxes
 * [rev:99664] Added CheckboxSetField->setDefaultItems() to tick specified checkboxes regardless of the value passed (from r99596)
 * [rev:99662] Showing (readonly) permissions for a Member record in admin/security popup (from r99586)
 * [rev:99660] PermissionCheckboxSetField_Readonly (with all checkboxes disabled)
 * [rev:99660] Added 'assigned to...' label to group permissions in PermissionCheckboxSetField - used in Member->getCMSFields() readonly permission view (from r99585)
 * [rev:99658] Allowing PermissionCheckboxSetField to inspect multiple group records for existing permissions (from r99584)
 * [rev:99648] View and select groups for a specific member via the member popup in admin/security (requires EDIT_PERMISSIONS) (from r98880)
 * [rev:99361] Allow locale/dateformat specific reordering of day, month, year input fields in DateField
 * [rev:99360] New DatetimeField class (form field wrapper composed of DateField andTimeField)
 * [rev:99360] New DateField and TimeField form classes with more consistent API and easier localization
 * [rev:99360] Using Zend_Date for DateField and TimeField, with more robust date handling, starting localization support. Set globally via i18n::set_locale(), or for a field instance through setLocale(). Note: Javascript validation is not localized yet.
 * [rev:99302] SiteTree::batch_permission_check() populates its own cache (from r97900)
 * [rev:99117] set file metadata on upload. (from r97780)
 * [rev:99106] set file metadata on upload. (from r97780)
 * [rev:99088] Add close link (from r97751)
 * [rev:99080] Add Link to silverstripe navigator (from r97407)
 * [rev:99069] added PageComment for CommentAdminTest
 * [rev:99066] CommentAdmin unitest
 * [rev:99047] Make navigator items more overloadable (from r97376)
 * [rev:99046] Refactor links in $SilverStripeNavigator so modules can add extras (from r97299)
 * [rev:98756] Added help texts for MemberImportForm and GroupImportForm (merged and rewritten from r98750)
 * [rev:98737] Allow extension of LeftAndMain->getEditForm() (and subclasses) through a new updateEditForm() hook (see r98736 for additions to AssetAdmin and CMSMain)
 * [rev:98736] Import groups from CSV in admin/security through the new GroupImportForm class (and GroupCsvBulkLoader) (merged and rewritten from r98711)
 * [rev:98735] Allowing custom 'root forms' when id values '0' or 'root' are passed from the tree selection. (rewritten from r98710)
 * [rev:98732] Import members and their group assignments from CSV in admin/security through the new MemberImportForm class (merged from r98708)
 * [rev:98715] Added GroupCsvBulkLoader class to facilitate group imports with permission codes and hierarchy (merged from r94252)
 * [rev:98714] MemberCsvBulkLoader for easy member import with group associations (merged from r94251)
 * [rev:98713] Added BulkLoader->deleteExistingRecords(), removed unnecessary parameters from BulkLoader->load() (merged from r94250)
 * [rev:98713] Decreased memory usage in BulkLoader->load() when deleting all records before importing  (merged from r94250)
 * [rev:98677] Added checkbox to switch off using the environment during install if it's available
 * [rev:98659] #3903 Initial changes to installer to support selection of different database drivers
 * [rev:98656] you can now pass arbitrary CURL options to the request() method of RestfulService.
 * [rev:98469] Add HTMLCleaner abstract class, and Diff::cleanHTML()
 * [rev:98428] Allow overriding TableListField_Item on TableListField by setting the property itemClass
 * [rev:98268] Moved the log-in validation process from individual authenticators into Member->checkPassword() and canLogIn(), to allow more extensibility and control (trunk, 2.4).
 * [rev:98219] roll batch permissions in to a generic function (from r97748)
 * [rev:98211] batchactions can now implement confirmationDialog() to provide a custom confirmation dialog to the front end.
 * [rev:98180] Allow for custom generation of SSReport::ID() for parameterised reports.
 * [rev:98179] Removed broken links reports from sidebar (in anticipation of adding them to the main reporting area) (from r95954)
 * [rev:98173] Improved look and feel for report filtering
 * [rev:98165] Performance improvement to CMS load time with many pages. (from r95490)
 * [rev:98159] added canAddTopLevel permission to SiteConfig to determine which users/groups can add pages to the root of the sitetree. (from r87279)
 * [rev:98156] audit trails
 * [rev:98156] ability to parameterize SSReport's (from r85903)
 * [rev:98132] Allow sort descending as well as ascending. (from r96054)
 * [rev:98110] Allow user theme selection through SiteConfig, falling back to SSViewer::set_theme() as a default if there are none selected
 * [rev:98104] Improved TableListField header styling. (from r96028)
 * [rev:98102] Add a function to give link to Live site (from r95948)
 * [rev:98091] ManifestBuilder::get_manifest_info() now uses ManifestBuilder::get_themes() instead of doing it's own retrieval of available themes
 * [rev:98080] Removed dev/reset, instead encouraging the use of dev/tests/startsession for tests.
 * [rev:98080] Let people use dev/tests/startsession without a fixture, instead calling requireDefaultRecords
 * [rev:98041] added support for MySQL data type SET used in MultiEnum FEATURE: added datetime helper functions
 * [rev:98025] add 'view site tree as' functionality.
 * [rev:97896] 2.4 tickets (#4670) new permission code to view draft w/o CMS access
 * [rev:97895] 2.4 tickets (#4670), new permission code to view draft stage w/o CMS access
 * [rev:97819] Allow ungrouped retrieval of Permission::get_codes() through new $grouped switch
 * [rev:97793] removed the situation, when the user is left with empty search box and empty dropdown.
 * [rev:97792] use Validator::get_javascript_validator_handler() to check if the handler is turned on before doing either js or php validation
 * [rev:97765] Select the uploaded image after uploading by default. #4962
 * [rev:97745] adapt the page dropdown based off the allowedChildren values
 * [rev:97606] Added hover states to "Available widgets" boxes in the CMS for usability
 * [rev:97602] Added visual elements to aid in the usability of the WidgetAreaEditor
 * [rev:97601] CMS Editor Upload panel now loads the root files directly and allows the user to upload to the root assets dir
 * [rev:97597] Changed menu title from "Site Content" to "Pages" to be consistent with other menu labels
 * [rev:97597] Changed tree root node in CMS to get title from SiteConfig rather than defaulting to "Site Content"
 * [rev:97597] Changed tree panel headline in CMS from "Site Content and Structure" to "Page Tree" to stay consistent with new CMS menu title
 * [rev:97583] Don't set up the test db if database tests aren't being run. From: Sam Minnee
 * [rev:97530] Adjusted "Available Widgets" column to be narrower than "Widgets currently used", allowing more space for configuring widgets
 * [rev:97478] Member->requireDefaultRecords() no longer creates a default administrator based on $_REQUEST data. Moved functionality into Installer->install()
 * [rev:97436] Updated Member->getMemberFormFields() to use scaffolding and to be in line with Member->getCMSFields(). From: Andrew Short  (from r97401)
 * [rev:97391] Add partial caching support to SSViewer.
 * [rev:97390] Add aggregate calculation to DataObject, allowing (cached) calculation of Max, Min, Count, Avg, etc
 * [rev:97389] Add cache factory that provides nice API over top of Zend_Cache
 * [rev:97370] Allowing translation of SiteConfig (including toplevel permission groups)
 * [rev:97207] Added ContentController->ContentLocale() to allow XHTML/HTML specific lang= attribute settings in custom template code (see #4858). Removed `<meta http-equiv="Content-Language"...>` tag in SiteTree->MetaTags().
 * [rev:97207] Updated blackcandy theme to use new $ContentLocale attribute to set the locale of the current page (in Page.ss)
 * [rev:97192] Added RestfulService::set_default_proxy() and RestfulService->setProxy() (#4637, thanks hamish)
 * [rev:97031] upgrading the search functionality of the TreeDropdownTree with pluggable search function
 * [rev:97028] include menu title in default search. PATCH via lubzee #4508
 * [rev:97024] added Session::clearAll() functionality. ENHANCEMENT: Added Unit Tests covering Session API. MINOR: Tided up formatting in session class and included doc comments for API level documentation
 * [rev:97018] Use tidied HTML in DataDifferencer
 * [rev:97017] Try to tidy HTML using external libraries if available
 * [rev:97011] Added TabIndex to FormActions. Ticket: #4905. PATCH: via keeny
 * [rev:96821] Added applicable pages checks to delete from live, delete from draft, and publish (from r94775)
 * [rev:96820] Added 'greyed out' status of batch action checkboxes while applicable pages are being loaded via ajax. (from r94774)
 * [rev:96819] Update the checkboxes available to batch-actions to show only the applicable pages for that particular action.
 * [rev:96800] Let LeftAndMain subclass canView() methods optionally redirect. (from r90018)
 * [rev:96793] Renamed Author column to User in the page version history to better reflect that they might not have been authors, and just iniators of workflow actions. (from r89015)
 * [rev:96792] Added new onRenameLinkAsset() handler to static publishing for better link rewriting. (from r89014)
 * [rev:96778] Files and images section warns if you are deleting a file that is linked to
 * [rev:96752] Recognise HTTP_X_FORWARDED_HOST header and use that in place of HTTP_HOST (from r93148)
 * [rev:96668] Change to TreeDropdownField, giving it filtering behaviour as described in ticket http://open.silverstripe.org/ticket/3007 . Its disabled by default for legacy compatibility, but enabled for HtmlEditorField so that link editor is filterable for local links, via an extra boolean parameter on TreeDowndownField.
 * [rev:96440] Add onLoad callback handler CMSLoadFunctions
 * [rev:96049] Added Date::Rfc3339() for returning an RFC 3339 valid date format (from r96010)
 * [rev:95418] added delete all link to page comments. Patch via #4427. Thanks walec51
 * [rev:95194] added translatable support to mathspamprotection. PATCH via noini (#4755)
 * [rev:94887] added several tests for PermissionCheckboxSetField, PermissionRole and Group
 * [rev:94515] Improved layout of altercation message when called via CLI. Patch via simon_w #4373
 * [rev:94423] Allow passing in an Exception object to SS_Log::log() in addition to an array describing the error context (line number, file, trace etc)
 * [rev:94381] Added FunctionalTest::findAttribute() as a helper for getting an attribute from a SimpleXMLElement object by it's name
 * [rev:94297] Added DataObjectSet::emptyItems() to remove all the items from the set - this is useful for when you are augmenting CMS and front end fields via updateCMSFields() and updateFrontEndFields() on a DataObjectDecorator
 * [rev:94063] Added MultipleOf and Modulus methods to ViewableData - useful for templating work
 * [rev:94062] Loading of tinymce_ssbuttons plugin via relative paths in HtmlEditorConfig rather than using the plugin name as a path spec  (see r94060)
 * [rev:94060] Added support for loading external plugins (with relative paths) in HtmlEditorConfig. This means relative paths can be separate from the plugin name, and fixes a bug where paths containing dashes were ignored by TinyMCE.init().
 * [rev:94060] Changed sapphire/thirdparty/tinymce-advcode to use the original plugin name, and specify its relative path through HtmlEditorConfig instead.
 * [rev:93771] Added  parameter to DBLocale->Nice()
 * [rev:93771] Added DBLocale->getNativeName()
 * [rev:92879] Allowing to hide certain permission from showing in SecurityAdmin? through add_hidden_permission() (refactored from r92428) (from r92866)
 * [rev:91576] Pluggable password encryption through PasswordEncryptor class (#3665) (merged from r90949)
 * [rev:91496] added ability to upload images from site content pane. Merged via r9130, r91347, r91350, r91480
 * [rev:91044] Added Session::destroy() as a means to remove the current session using session_destroy()
 * [rev:91044] Added optional $sid parameter to Session::start() to start the session using an existing session ID


###  API Changes

 * [rev:103792] changed the modulus offset to 1 to correctly order sets
 * [rev:102012] Changed MySQLFulltextSearchable class to FulltextSearchable (applies to all databases)
 * [rev:102003] Disallow methods/actions in RequestHandler->checkAccessAction() which are implemented on parent classes (e.g. ViewableData and Object), unless access is controlled through $allowed_actions. This limits information exposure from getters used in template contexts.
 * [rev:101833] Allow cached blocks within control and if blocks, as long as that control or if block is contained within an uncached block, not a cached block
 * [rev:101155] Add option for DataObjectDecorator::onAfterSkippedWrite()
 * [rev:101137] Partial cache adjustments - now supports nested cache blocks (which are independant of their containing cache block), conditionals to control if a given cache block is active, and includes hash of template code in key (so template changes mean cache is invalidated). Changes template control for cache block to `<% cached %>`, to which the now deprecated `<% cacheblock %>` is aliased, and an additional template control `<% uncached %>` has been added.
 * [rev:101127] Added SiteTree::VirtualPages() and SiteTree::DependentPages() accessors.
 * [rev:101119] Allow on_db_reset() methods on DataObjects as well as DataObjectDecortators
 * [rev:101093] Replaced eval based creation of extension and field objects with Object::create_from_string().
 * [rev:101093] Introduced new function Object::create_from_string() to instantiate an object from a string like 'Int(50)'
 * [rev:101044] Made MySQL fulltext search optional, activated with MySQLFulltextSearchable::enable()
 * [rev:101043] Pass the full extension string as the 2nd argument to DataObjectDecorator::extraStatics()
 * [rev:100842] Upgraded jQuery UI from v1.6rc1 (r687) to v1.8rc3. This release prefixes all *.js and *.css files with 'jquery', so ui.core.js is now called jquery.ui.core.js.
 * [rev:100842] Upgraded jQuery UI themes from v1.6rc1 to v1.8rc3. Removed 'flora' and 'default' themes, replaced with the 'base' and 'smoothness' themes found in the default distribution
 * [rev:100718] Removed "auto-merging" of member records from Member->onBeforeWrite() due to security reasons - please use DataObject->merge() explicitly if this is desired behaviour (from r100705)
 * [rev:100651] dbDataType function created
 * [rev:100513] Refactored Requirements to use Requirements_Backend at all times - this makes testing far easier. Thanks tobych!
 * [rev:100512] TreeDropdownField no longer requires your object to have the Hierarchy extension
 * [rev:100503] Removed deprecated Email_Template class, please use Email instead!
 * [rev:100498] Removed deprecated Image::loadUploaded() (deprecated from the parent::loadUploaded for which it called), please use Upload directly instead!
 * [rev:100495] Removed deprecated File::loadUploaded(), please use Upload directly instead!
 * [rev:100493] Removed deprecated function RootURLController::get_homepage_urlsegment(), please use RootURLController::get_homepage_link() instead!
 * [rev:100492] Removed deprecated function SiteTree::get_by_url(), please use SiteTree::get_by_link() instead!
 * [rev:100490] Removed deprecated methods DataObjectSet::filter_map() and DataObjectSet::map_multiple() - please use map() instead!
 * [rev:100057] #5107 Upload now uses Upload_Validator to separate the validation rules from the File loading done in the Upload class
 * [rev:99849] SiteTree::validURLSegment extendable (#5907)
 * [rev:99360] Date/time parsing in DateField, TimeField and DatetimeField defaults to i18n::get_locale() ('en_US') instead of using en_NZ/en_GB specific parsing. Use i18n::set_locale('en_NZ') in mysite/_config.php to revert to old behaviour.
 * [rev:99360] $timeformat constructor parameter in TimeField needs to be in ISO date notation (not PHP's date())
 * [rev:99360] TimeField, DateField and related subclasses use Zend_Date for date parsing, meaning they're stricer than the previously used strtotime()
 * [rev:99360] Removed DMYCalendarDateField and CalendarDateField, use DateField with setConfig('showcalendar')
 * [rev:99360] Removed CompositeDateField, DMYDateField, use DateField with setConfig('dmyfields')
 * [rev:99360] Removed DropdownTimeField, use TimeField with setConfig('showdropdown')
 * [rev:99360] Removed PopupDateTimeField, use DatetimeField
 * [rev:99360] Changed 'date', 'month' and 'year' HTML field names to lowercase in DMYDateField
 * [rev:99360] Removed support for ambiguous date formats in DateField, e.g. '06/03/03'. Use DateField->setConfig('dateformat', `<format>`) to revert to this behaviour.
 * [rev:99360] Removed $futureOnly flag from DateField, CalendarDateField etc., use DateField->setConfig('min') and DateField->setConfig('max')
 * [rev:99119] Refactor Versioned so a single state is kept for stage, archived date, or any module specific reading modes (from r98161)
 * [rev:99114] Use the same navigator items in the CMS that are used on the frontend (from r97395)
 * [rev:99079] Use the same navigator items in the CMS that are used on the frontend (from r97395)
 * [rev:99063] Let sitetree extensions prepopulate permisson cache for their own permissions. (from r98650)
 * [rev:99051] Let any DataObjectDecorator define an on_db_reset() method that is called by tests, like in Versioned. (from r97734)
 * [rev:98786] Installer now uses a database configuration helper class which isolates the logic of checking the database away from the installer, this interface can be used by other databases like MSSQL and PostgreSQL. The installer now looks for a specific file inside each database module, provided it's configured in install.php MySQL is provided by default, as it lives in sapphire
 * [rev:98543] Made ComplexTableField not use Object::create() for item and popup classes to be consistent with TableListField. These can be overridden as itemClass and popupClass are public properties on ComplexTableField
 * [rev:98373] HTTP::setGetVar() always returns absolute URLs. Use Director::makeRelative() to make them relative again.
 * [rev:98373] HTTP::setGetVar() combines any GET parameters in PHP array notation (e.g. "foo[bar]=val") instead of replacing the whole array
 * [rev:98224] Refactor Versioned so a single state is kept for stage, archived date, or any module specific reading modes (from r98161)
 * [rev:98215] Introduced new API for SS_Report
 * [rev:98191] Added SideReportWrapper to help you tailor report columns for the side reports.
 * [rev:98191] Allow use of 'casting' option on side report columns.
 * [rev:98191] Make 'title' optional on side report columns. (from r96272)
 * [rev:98176] Removed SideReport class, use SSReport as the base-class for them instead.
 * [rev:98176] Use SSReport::register(SideReport) to explicitly register reports on the LHS of the content view.
 * [rev:98175] Added explicit registration of reports with SSReport::register() (from r95857)
 * [rev:98159] Security::permissionFailure(); will no longer tell the client side JS to show the login box if the user is already logged in
 * [rev:98101] Allow passing of an explicit map of dropdown items to a TreeDropdownField.
 * [rev:98096] Refactored test for whether a SQLQuery can be sorted by a particular column into SQLQuery::canSortBy($fieldName) (from r95850)
 * [rev:98056] Decimal now allows setting a default value properly
 * [rev:97996] rename the class "Cache" to "SS_Cache" (ref ticket: #4997)
 * [rev:97827] Added cancelSchemaUpdate() and doesSchemaNeedUpdating() to the Database class
 * [rev:97819] Removed $blankItemText parameter from Permission::get_codes()
 * [rev:97818] Removed Member::init_db_fields(), its no longer needed due to the Member.PasswordEncyrption property changing from an ENUM to Varchar.
 * [rev:97797] Fixed i18n _t() calls without namespaces in template includes: They now default to setting the include filename as namespace, rather than the including template (#4915, #3400 - thanks Henk_Poley, jwalsoe, walec51)
 * [rev:97731] Determine default BASE_PATH/BASE_URL from the __FILE__ content, so that the script that initiated the Sapphire process doesn't matter.  This means that index.php doesn't need to manipulate those variables.
 * [rev:97582] #4929: Add $class argument to DataObjectDecorator::extraStatics()
 * [rev:97489] removed SWFUpload. Refactored Content Editors uploader to use standard uploader.
 * [rev:97478] Security::setDefaultAdmin() no longer writes credentials to any Member database records (created through Security::findAnAdministrator(). This prevents outdated credentials when setDefaultAdmin() code changes after creating the database record (see #4271)
 * [rev:97478] Security::findAnAdministrator() no longer sets 'Email' and 'Password' properties on newly created members. Removed the $username and $password argments from the method.
 * [rev:97475] Moved GSTNumberField from sapphire/forms to new 'formfields_nz' module
 * [rev:97474] Moved BankAccountField from sapphire/forms to new 'formfields_nz' module
 * [rev:97270] Unique_identifier now accepted as the login requirement, allowing alternatives to 'Email'
 * [rev:97207] Deprecated ContentController->LangAttributes(). Use ContentLocale() instead and write attribute names suitable to XHTML/HTML templates directly in the template.
 * [rev:96988] #3600 Inconsistency in File::getURL() which returns an absolute URL, when it should be relative - please use getAbsoluteURL() instead for old behaviour
 * [rev:96988] #3600 Image no longer has an explicit getURL() method, instead it inherits getURL() from File which returns a relative URL
 * [rev:96824] Added capability for batch actions to indicate failure through red checkboxes (from r94868)
 * [rev:96823] Added canView() to CMSBatchAction so that you could hide certain batch actions from some users. (from r94846)
 * [rev:96821] Added applicablePagesHelper to CMSBatchAction to ease the process of creating new applicable page methods.
 * [rev:96819] Allow for an applicablePages($idArray) method to be defined on a CMSBatchAction class. (from r94761)
 * [rev:96810] Added FilesystemPublisher::getExistingStaticCacheFiles(), to help build caching logic methods. (from r91354)
 * [rev:96809] Added numChildrenMethod argument to LeftAndMain::getSiteTreeFor()
 * [rev:96756] Added canDeleteFromLive permission to SiteTree, separate from canPublish (from r93315)
 * [rev:96751] Define VirtualPage::isPublishable() so that people know not to even request publication if it's not allowed. (from r93098)
 * [rev:96749] Added DataObjectDecorator::cacheKeyComponent() to ensure that the cached behind DataObject::get_one() is appropriately specific (from r93095)
 * [rev:96739] Added Hierarchy::numHistoricalChildren() and Versioned::get_including_deleted_query()
 * [rev:96739] Added numChildrenMethod arg to getChildrenAsUL, markPartialTree, markChildren, markingFinished
 * [rev:96734] Don't generate TestOnly DataObjects in the database immediately; instead let test developers specify them in SapphireTest::$extraDataObjects.
 * [rev:96734] Added SapphireTest::resetDBSchema() (from r90054)
 * [rev:96727] Renamed SapphireTest::set_up_once/tear_down_once to setUpOnce/tearDownOnce, and made them instance methods.
 * [rev:96727] Added SapphireTest::$illegalExtensions and SapphireTest::$requiredExtensions for making tests depending on particular extension sets (from r89958)
 * [rev:96725] Moved popupdatetimefields to pop up below the text field instead of next to the icon. (from r89914)
 * [rev:94430] Group::addByGroupName() now creates the group if one does not already exist (from r83010)
 * [rev:94178] Renamed ViewableData->SecurityID() to getSecurityID() in order to get its value loading through Form->loadDataFrom()
 * [rev:94062] Changed cms/javascript/tinymce_ssbuttons plugin name to "ssbuttons" (see r94060)
 * [rev:94062] Changed cms/javascript/tinymce_ssmacron plugin name to "ssmacron" (see r94060)
 * [rev:93785] removed Director::Link(). Use Controller::join_links() instead
 * [rev:93693] removed deprecated RestrictedText fields
 * [rev:93687] removed deprecated LeftAndMain::add_menu_item. Use CMSMenu::add_menu_item()
 * [rev:93685] removed deprecated extend calls (r93632). API CHANGE: removed fieldExists(). Use hasField() (r93633). API CHANGE removed listOfFields() (r93647). API CHANGE: removed Tag() and URL() from Image. Use getTag() and getURL(). BUGFIX: updated Image.php to use getTag() (r93639, r93646). API CHANGE: removed val(). Use XML_val() (r93650). API CHANGE: removed $add_action. Use singlar_name or lang tables (r93658). API CHANGE: removed ConfirmedFormAction (r93674). API CHANGE: removed ajax_render on CTF (r93679).
 * [rev:93660] Removed ComponentSet::removeByFilter() since it's not flexible enough and fixed calls to this from HtmlEditorField::saveInto() to use custom code instead
 * [rev:93640] Removed deprecated static function ContentNegotiator::disable() - it's disabled by default
 * [rev:92878] Refactored hiding of Permissions added in r92428. Added PermissionCheckboxSetField?->setHiddenPermissions() (from r92865)
 * [rev:92428] add the ability to remove some permissions specified by their code in the rendered field html of PermissionChecksetBoxField and full-covered unit tests of this ability.
 * [rev:91612] Replaced BasicAuth::enable() with BasicAuth::protect_entire_site()
 * [rev:91612] BasicAuth::requireLogin() no longer has an option to automatically log you in.  You can call logIn() on the object returned, instead. (from r91603)
 * [rev:91576] Deprecated Security::encrypt_passwords() (merged from r90949)
 * [rev:91576] Deprecated Security::$useSalt, use custom PasswordEncryptor implementation (merged from r90949)
 * [rev:91576] Removed Security::get_encryption_algorithms() (merged from r90949)
 * [rev:91576] MySQL-specific encyrption types 'password' and 'old_password' are no longer included by default. Use PasswordEncryptor_MySQLPassword and PasswordEncryptor_MySQLOldPassword
 * [rev:91576] Built-in number of hashing algorithms has been reduced to 'none', 'md5', 'sha1'. Use PasswordEncryptor::register() and PasswordEncryptor_PHPHash to re-add others. (merged from r90949)
 * [rev:91048] Added Lower and Upper methods to Varchar, Text, and Enum
 * [rev:90963] Allow fieldList arguments to Form::loadDataFrom() and Form::saveInto(), for situations where the data passed only applies to a segment of the form. (from r90872)
 * [rev:90962] Inserting $HiddenFields into a form template will show the input tags of all the hidden fields. (from r90871)


###  Bugfixes

 * [rev:104063] ViewableData->castingClass() cuts off last character of a casting definition if it has bracketed arguments (fixes #5536, thanks ajshort)
 * [rev:104016] SecurityTest tests would fail on sites which had set a non-default unique identifier field for Members
 * [rev:103961] Bypass static caching through static-main.php when GET or POST parameters are set (regression from 2.3 API, fixes #5519, thanks ktauber)
 * [rev:103960] Fixed publication of homepage with '/' URL through StaticPublisher (fixes #5514, thanks ktauber)
 * [rev:103957] Fixed Database->requireTable() for Mysql 4.1 (fixes #5517, thanks gw0)
 * [rev:103936] Fixed double pragma after referer redirection on forms with Form->httpSubmission() (fixes #5509, thanks ktauber)
 * [rev:103933] login BackURL wrong when using nested urls (fixes #5520, thanks ktauber)
 * [rev:103932] Fixed SS_Report::unregister() parameter naming (fixes #5511, thanks ktauber)
 * [rev:103912] Trimming expected output of WebserverRoutingTest (newlines before the "ok" string were causing failures on PHP 5.3)
 * [rev:103910] Disabled MemoryLimitTest for environments where memory_limit can't be freely set (e.g. PHP with suhosin patch)
 * [rev:103851] table and column names now quoted properly
 * [rev:103803] Rebuilding test database for postgresql in SearchFormTest and TranslatableSearchFormTest to avoid stale index information in the database
 * [rev:103745] static publisher for a site that resides in a subfolder of webroot
 * [rev:103734] Fix linkCount .js in AssetAdmin deleteRecord (ticket #5486)
 * [rev:103706] Use correct quoting for BrokenLinksReport (ticket #5474)
 * [rev:103674] #5485 PermissionCheckboxSetField javascript would always uncheck all CMS_ACCESS_* permission checkboxes on initialize event
 * [rev:103620] Fixed ordering by aggregate columns for DataObject::get() calls with joins.
 * [rev:103613] Fixed unlimitedRowCount() for grouped queries
 * [rev:103612] Ensure that group by of many-many queries with extraFields is set correctly.
 * [rev:103591] ModelAsController test failed for projects which do not support nested urls. This fix stores the original configuration and enables 'nested-urls' at the beginning of the tests and reset the state in tearDown.
 * [rev:103588] #5362: Fixed duplicate removal on DataObject:get() with join argument for all databases.
 * [rev:103582] Choosing i18n::default_locale() in Member->populateDefaults() instead of "current locale". This fixes a bug where a new member created through admin/security automatically "inherits" the current locale settings of the admin creating it.
 * [rev:103552] CSSContentParser now reports better errors by using simplexml_load_string() instead of SimpleXMLElement directly
 * [rev:103519] Prevent duplicate HTML IDs in ModelAdmin
 * [rev:103518] Fixed redirection in PageCommentInterface to use Link() instead of URLSegment (fixes 4200, thanks ktauber)
 * [rev:103461] Renamed Nested URLs are automatically redirected to their new location with 301 HTTP status code in ModelAsController/ContentController (fixes #5393, thanks cbarberis)
 * [rev:103451] Fixed CurrencyField->jsValidation() regex escaping (fixes #5462, thanks mobiusnz)
 * [rev:103450] DateField with setConfig('dmyfields') now validates TRUE for empty values (fixes #5458)
 * [rev:103448] Allow EDIT_SITECONFIG permission selection in admin/security (fixes #5459)
 * [rev:103341] Don't show error when adding default SiteConfig records after upgrading a site.
 * [rev:103336] Using try/catch in MemberTableField->saveComplexTableField() similiar to parent implementation, which means trying to save a Member duplicate doesn't end up in a fatal error (fixes #5444)
 * [rev:103255] static publishing now uses the last non-null theme, OR the value defined in StaticPublisher::static_publisher_theme.
 * [rev:103240] r101093 broke casting of values from the failover object. Add lookup to the failover for casting info, and add test
 * [rev:103226] made the invalid password message translatable; disallow new blank password (as it makes it impossible to login); Member::checkPassword now returns ValidationResult - handle that properly (#5420, patch submitted by walec51)
 * [rev:103214] the decorator was not completely removed, which caused trouble for tests running later in the same batch
 * [rev:103183] default sort column now quoted
 * [rev:103182] default sort column now quoted
 * [rev:103127] realtime publishing now enabled by default
 * [rev:103099] Only replace double slashes in SS_HTTPRequest->__construct() for relative- its a failsafe against wrongly formatted URLs like 'admin//assets' instead of 'admin/assets', but breaks absolute URLs with 'http://' prefix
 * [rev:103092] disallow numeric actions - numeric array indexes are incorrectly picked up as allowed actions (#5331)
 * [rev:103083] make the javascript-producing functions behave in the same way. Now they will return a javascript snippet and the caller is responsible for adding it to a FormResponse. Removes the duplication in AJAX response which happened when FormResponse::add has been used before the call to JS helper functions (#5359)
 * [rev:103037] correct mollom field mapping
 * [rev:103012] added optional separator for http_build_query in HTTP:setGetVar(). this fixes sorting columns in ModelAdmin (ticket #5325).
 * [rev:102730] Fixing RquestHandler->checkAccessAction() on PHP 5.2 - ReflectionMethod->class returns inconsisent results in older PHP versions. (see r102003)
 * [rev:102712] Fixed CTF sorting in ModelAdmin results (was failing because of missing 'ResultAssembly' GET parameters
 * [rev:102686] Float should always be not null and default 0 in the database
 * [rev:102545] Using i18n::get_locale() in ContentController->ContentLocale() to ensure the correct locale can be used in templates withouth Translatable enabled (broken in r97207, thanks DesignCity) (from r102544)
 * [rev:102460] #5316 Float and Double should never try to save NULL as the "null" value
 * [rev:102436] #5320 ManyManyComplexTableField::getQuery() now uses T-SQL compatible syntax CASE WHEN instead of IF THEN which works in multiple databases as well
 * [rev:102386] delete from published site never calls canDeleteFromLive(). (via marcus #5364)
 * [rev:102320] fixed invalid HTML output from page comments template
 * [rev:102300] SSViewer now allows cli to do a flush on non-dev environments
 * [rev:102265] Fix Salad tests
 * [rev:102237] exchanged MySQL CONCAT function with ANSI compliant operator
 * [rev:102160] allow HTMLEditorFields to save in SiteConfig, fixes #5246
 * [rev:102156] fallback to the standard authenticator before throwing user_error as in some cases auth  method is not passed back to the login form
 * [rev:102094] Fixed bug with SiteTree::onBeforeWrite() that broke subsites.
 * [rev:102084] #5343: Call DataObject::onBeforeWrite only once for SiteTree
 * [rev:102081] #5337: Allow decoration of DataObject
 * [rev:102074] Fixed SiteTree::page_type_classes() to exclude 'SiteTree' even if on array position 0 - slight difference in return values from Postgres to MySQL (fixes #5336)
 * [rev:102072] Logging in with an invalid email returns no error message (fixes #5332, thanks ajshort)
 * [rev:102038] #5255 LeftAndMain should include the correct editor.css file so typography from user selected theme in SiteConfig is shown in TinyMCE
 * [rev:102026] Fixed SiteTree::page_type_classes() removal of base class (was broken if database driver returned classes in arbitrary order, e.g. in Postgres)
 * [rev:102004] Prevent handling of controller actions which return $this avoid infinite loops in RequestHandler->handleRequest (thanks Hamish!)
 * [rev:101975] Resetting image sidepanel fields when opening the panel instead of inserting an image, to avoid losing focus of TinyMCE in IE. Using getBookmark() in TinyMCE to save the original location. (fixes #5263)
 * [rev:101969] Stop IE6/IE7 from redirecting in admin/assets after deleting multiple folders (fixes #5208)
 * [rev:101958] Checking for existing redirections in FormResponse::respond (fixes #5208)
 * [rev:101956] Fixed "object not found" javascript error  in SecurityAdmin_right.js when changing group nodes (fixes #5179)
 * [rev:101939] Ensure that DataObject IDs are numbers and no string equivalents of numbers - 3 not '3'
 * [rev:101869] Update Salad tests to match behaviour
 * [rev:101867] #4188 simon_w: Let require tags in templates be conditional
 * [rev:101866] Recover if a manifestClassParse file doesn't have the necessary content.
 * [rev:101812] Added allowed_actions to  ContentControllerSearchExtension
 * [rev:101810] #5295: Update CMS site name in LHS via Ajax after siteconfig save.
 * [rev:101807] fixed undefined error in CTFs. BUGFIX: added action class to actions to allow the popup hook to open links
 * [rev:101795] keep ModelAdmin from importing data twice
 * [rev:101794] avoid call to non-object
 * [rev:101793] preserve the port value if given in HTTP::setGetVar (#5280). BUGFIX: allow username only input rather than user:pass combo.
 * [rev:101792] disable function re-enabled
 * [rev:101791] deprecated split function replaced
 * [rev:101758] fix #5320
 * [rev:101747] Always including "Locale" field in Translatable->getCMSFields() regardless of "excluded" page types. Necessary to enable form state serialization for fields like TreeSelectorField on a VirtualPage (fixes #5269)
 * [rev:101739] Versioned->publish() with $createNewVersion=TRUE now increases version number of in-memory object (fixes #5261)
 * [rev:101737] RedirectorPage types shouldn't appear in "Pages with no content" side report in the CMS Pages tab
 * [rev:101724] #5277 Sort of default SiteTree records is now explicitly set to avoid strange ordering set by SiteTree::onBeforeWrite for default records
 * [rev:101719] Only show "Roles" tab in admin/security if user has APPLY_ROLES permissions (fixes #5258)
 * [rev:101711] Don't replace "home/" URLSegment in SiteTree->RelativeLink() if Translatable is enabled and the homepage is not on the root level (nested URLs allows you to have homepages called "en/home" and "ru/home") (fixes #5244)
 * [rev:101668] #5259 RedirectorPage and HtmlEditorField TinyMCE integration now prefixes http:// if no prefix is found
 * [rev:101657] #5245 Sometimes page records will have a NULL ParentID value, it should be a number even if it's 0 (thanks wrossiter!)
 * [rev:101638] #5243 Undefined Convert functions in ViewableData replaced with working versions. Thanks benediktb!
 * [rev:101631] test that the class exists before running subclass tests
 * [rev:101623] put back into the SSNavigator the archived site link (#5251)
 * [rev:101608] Explicitly specify the many_many's join table name in the join's ON match statement in ManyManyComplexTableField
 * [rev:101604] remove the unnecessary DOM manipulation, this is legacy code due to SilverStripeNavigator changes (open #5250)
 * [rev:101603] the function makes an assumption we are working on Draft site, and breaks if we are not. Rewritten to be stage-independent, as get_version (open #5231)
 * [rev:101602] IE does not accept TD element without a table, repacking into DIV (open #5228)
 * [rev:101592] get a object inside transaction block will alway exist
 * [rev:101554] tables and column quoted properly
 * [rev:101493] tables and column quoted properly
 * [rev:101492] results sorted alphabetically for consistency
 * [rev:101491] results sorted alphabetically for consistency
 * [rev:101392] HTTP::setGetVar() returns a relative URL if a relative URL is passed, to make behaviour closer to 2.3
 * [rev:101380] disabling unused file list as feature is still buggy.
 * [rev:101375] Fixed closing `</div>` which should have been a `</td>` for dragfile in AssetTableField
 * [rev:101302] Fixed SiteTree->Content link shortcode parsing introduced in r101093 (#5227)
 * [rev:101267] #5222 Fixed TreeDropdownField not working on FileIFrameField/ImageField
 * [rev:101266] Fixed Folder writing by overloading validate() (was inheriting File->validate() which does extension checks)
 * [rev:101266] Fixed Folder::findOrMake() not to create "new-folder" through File->setName() if using a trailing slash in the path (which causes an empty name). Added FolderTest to verify this.
 * [rev:101264] Checking for existence of "ShowInMenus" property in Folder->liveChildren() and stageChildren() (#5190)
 * [rev:101227] Don't delete index.php after successful installation - in ContentController->deleteinstallfiles(). URL routing might rely on it without mod_rewrite.
 * [rev:101227] Require ADMIN permissions for ContentController->deleteinstallfiles() - together with retaining index.php this removed a vulnerability where unauthenticated users can disrupt mod_rewrite-less URL routing.
 * [rev:101220] TeamComment table added to dataobjects list
 * [rev:101189] Make SS_ReportWrapper::sourceRecords()' arguments optional
 * [rev:101175] Fixed quotes around Folder::hasChildFolders() ParentID column
 * [rev:101173] Don't run click() on all inputs, but input:radio only
 * [rev:101171] Pass correct class to allowPrimaryKeyEditing in yaml fixture
 * [rev:101170] Don't recreate a missing draft page when calling SiteTree::doUnpublish()
 * [rev:101167] #5216 Installer has issues with click handlers applied to the entire li, be more specific and apply it to the label and input instead
 * [rev:101165] Fixed versioning of pages
 * [rev:101155] Prevent failed migrateVersion writes from breaking versioning system in future writes.
 * [rev:101155] MAke site tree pages go green when you save a new draft.
 * [rev:101154] #5214 ViewableData::obj() was creating a DBField without a fieldname argument and caused problems, one example is the version panel of the CMS
 * [rev:101153] Ensure that Versioned works on classes with underscores in the names. (from r100905)
 * [rev:101138] Fixed issues with broekn link tracking
 * [rev:101131] Allow classes to be referred to with casing that differs from their definition.
 * [rev:101129] Fixed FileLinkTrackingTest to cope with the empty alt="" and title="" attributes that are created
 * [rev:101127] Improved reliabilty of broken link tracking.
 * [rev:101127] Don't mark a page as changed on stage if the only thing that has changed is broken link metadata
 * [rev:101116] Flush cache after deleting an item.
 * [rev:101116] Fixed databaseFieldsOnly version of DataObject::getChangedFields()
 * [rev:101112] Fixed bugs with copying custom fields into Virtual pages, generally made virtual pages more robust and performant.
 * [rev:101110] Fixed link rewriting to work on other HTMLText fields (from r99517)
 * [rev:101109] Return true if SiteTree:doUnpublish() succeeds. (from r99515)
 * [rev:101105] Update Object::parse_class_spec() to handle arrays.
 * [rev:101099] call_user_func_array changed to PHP 5.1 compatible notation
 * [rev:101087] #5202 Installer now properly populates database configuration inputs from request after user clicks "Re-check requirements"
 * [rev:101080] Fixed TableListField->print() - was unsetting $cachedSourceItems instead of null'ing it, which breaks later access to the property
 * [rev:101068] #5199 Duplicate file uploads have odd numbering attached to end of file
 * [rev:101061] Fixed Upload and checking for size with files that don't have any extension
 * [rev:101051] Allow files with no extensions by setting File::$allowed_extensions with an empty string
 * [rev:101050] #5188 Upload and Folder don't handle the duplicate naming of files that have no extension
 * [rev:101046] Cookies set to a value other than NULL (effectively unsetting the cookie) will now use the httpOnly parameter by default for better XSS protection (from r101045)
 * [rev:101034] Fix static caching file lookup to match file generation.
 * [rev:101005] Image should pass through the title to Image_Cached so that Image::getTag() can produce a more useful alt attribute instead of just the filename (from r101003)
 * [rev:100998] column and table names now quoted properly
 * [rev:100986] Disable javascript date validation via DateField->jsValidation() if locale is not 'en_NZ" (which is the only format it validates for).
 * [rev:100985] HTMLEditorField->saveInto() can now find images with urlencoded information for resample (e.g. spaces in filenames)
 * [rev:100982] Fixed file-write testing issues in requirements combined file generation
 * [rev:100980] Remove cache for Hierarchy::AllChildren() and Hierarchy::AllChildrenIncludingDeleted(), since they increase memory usage unnecessarily.
 * [rev:100979] Don't make CMS loading slow if the combined javascript files can't be written.
 * [rev:100932] SiteTree::getSiteConfig() should always fall back to using a default if an alternate config wasn't found
 * [rev:100924] Allow DatabaseAdmin to run dev/build in live mode when not Security::is_database_ready(), and avoid broken login due to broken db queries (selecting unknown columns before dev/build) (see #4957)
 * [rev:100921] DataObject::hasValue() is now compatible with parent ViewableData::hasValue() (this also fixes E_STRICT standards in PHP)
 * [rev:100919] RequestHandler::handleRequest is now compatible with Controller::handleRequest in that SS_HTTPRequest is the type hint for the $request parameter
 * [rev:100918] ManifestBuilder::up_children() should be declared as static as it's called statically
 * [rev:100904] Produce XHTML compliant URLs in HTTP::setGetVar() by default (regression from r98373, see #5101)
 * [rev:100896] #5138: DataObjectSet::removeDuplicates() removes objects of different classes with the same ID
 * [rev:100866] #5176 Javascript error in IE for the installer - use "this" instead of e.target which doesn't work
 * [rev:100862] Use "wb" argument in ManifestBuilder fopen() calls for better cross-platform compatibility
 * [rev:100861] #5157 If paths are longer than 255 characters, fopen() produces an "Invalid argument" error, shorten the paths by using basename() instead of realpath() on the manifest filename when producing the cache path in ManifestBuilder
 * [rev:100858] Fixed notice level error with folder ID
 * [rev:100854] fixed file uploading not uploading any files at all
 * [rev:100853] Fixed jQuery.ondemand.js script to work with prototype.js (will probably need to be merged back to trunk for legacy purposes)
 * [rev:100848] Fixed variable declaration order in tabstrip.js (necessary due to changed jquery.livequery behaviour
 * [rev:100825] Added single quote as a valid local-part of an email address as per RFC5322. Other symbols still excluded although in the spec
 * [rev:100795] #5157 strftime() %F format parameter does not work on Windows - use %Y-%m-%d instead
 * [rev:100767] Date::now() supplies wrong string - it misses leading zeroes on hours
 * [rev:100763] added uniqueness id, to prevet multiple VirtuaLage reloads on publish
 * [rev:100755] TreeSelectorField doubles up on concating base_url, doesn't include the security ID (#5164, thanks marcus)
 * [rev:100747] #5099 FileIFrameField fails when using it with a locale different to the default
 * [rev:100727] allow selection of database adpater
 * [rev:100726] misspelled variable
 * [rev:100724] some sections dont have a tree at all, but they still use LeftAndMain as their base class (eg report admin). Added a guard.
 * [rev:100723] Fixed SapphireTest->loginWithPermission() and MemberAuthenticatorTest to use existing Members based on their unique_identifier_field (if existing) to accommodate recent Member->onBeforeWrite() changes (see r100705)
 * [rev:100722] reload page if broken link tracking values changed during a save. Ticket #1363
 * [rev:100721] Unsetting 'ID' parameter in MemberTableField->addtogroup() to avoid confusion between Group and Member records (regression from r100716) (from r100720)
 * [rev:100719] Fixed MemberTableField->addtogroup() to fetch existing Member records by ID or $unique_identifier_field instead of relying on the (now removed) "auto-merging" in Member->onBeforeWrite() (see r100705) (from r100716)
 * [rev:100717] Fixing Member_ProfileForm to validate for existing members via Member_Validator to avoid CMS users to switch to another existing user account by using their email address (from r100704)
 * [rev:100701] moving the ajaxupdatesort JS response code from php to js to get rid of eval. Also disable the "loading" on the moved element when we are done, in case we are repositioning other than the selected item - otherwise the progress indicator is displayed indefinitely.
 * [rev:100699] column names quoted properly
 * [rev:100693] column names quoted properly
 * [rev:100692] column names quoted properly
 * [rev:100691] column names quoted properly
 * [rev:100690] column names quoted properly
 * [rev:100689] column name capitalised
 * [rev:100688] column names quoted properly
 * [rev:100687] column names quoted properly
 * [rev:100686] the default value for decimals are now cast as (doubles)
 * [rev:100657] tables and columns now quoted properly
 * [rev:100632] Fixed SiteTree->MetaTags() to either use `<meta name=>` or `<meta http-equiv=>`, and only using the "http-equiv" attribute for valid HTTP headers (see http://www.w3.org/TR/html4/struct/global.html#edef-META) (from r100631)
 * [rev:100627] DB::getConnect() should be properly declared as a static function
 * [rev:100616] Fixed filemtime() check in Requirements_Backend::process_combined_files() not getting the right path
 * [rev:100614] Proper check for combined file path in Requirements_Backend::process_combined_files()
 * [rev:100560] #4572 Fixed Windows failure on SS_Cli::supports_colour() because posix functions are not supported
 * [rev:100548] If fixture file is NULL don't cause the test framework to break down because of it
 * [rev:100527] Set Member default Locale
 * [rev:100525] get TreeMultiselectField working with an array of items, rather than a relation.
 * [rev:100519] add 'var' to local variable 'constructor' inside of function definition which break IE8 (8.0.6001.18702 +)
 * [rev:100508] wrong constructor function name
 * [rev:100496] replacing calls to deprecated Upload functions - using validator instead (related to r100057)
 * [rev:100466] #5012 BasicAuth should check if there's already a current member logged in before asking for a login/password
 * [rev:100438] GD::setQuality() persistence issue because the GD instance is re-created instead of being cloned - thanks Tjofras!
 * [rev:100417] #5121 Fixed cache flushing for FieldSet when removing fields - thanks paradigmincarnate!
 * [rev:100415] #5136 Ensure $coverage argument to TestRunner::runTests() has a strict check before running coverage tests, as sometimes an SS_HTTPRequest object can be passed into this argument
 * [rev:100407] FormAction input tag attributes were being doubly-escaped.
 * [rev:100406] Fix mismatch with $all_locales and $common_locales (#5096)
 * [rev:100394] #5135 LeftAndMain extra requirements loading for "themedcss" should use Requirements::themedCSS() not Requirements::css() - thanks Hamish!
 * [rev:100393] YamlFixture::writeDataObject() - some databases need special allowance to edit the primary key column - do so by using DB::getConn()->allowPrimaryKeyEditing()
 * [rev:100375] Sam's fix for "Unknown column Group.SubsiteID" with new subsites
 * [rev:100370] use localized prefix to compare group codes rather than hard coded english string. MINOR: updated lang file
 * [rev:100367] PHP 5.1 requires an array rather than a string for call_user_func()
 * [rev:100359] Show Language dropdown in English (#5098)
 * [rev:100335] #5023 AssetAdmin::sync() is now used to sync tasks, as it works when the user only has access to the AssetAdmin controller instead of going to dev/tasks/FilesystemSyncTask which can only be run by administrators or if the site is in dev mode
 * [rev:100116] Fix TestRunner coverage pattern to work as documented (Fixes QA scripts too)
 * [rev:100053] SQL Error is a member is not part of any groups
 * [rev:99993] Setting default $groups in MemberTableField::AddForm() in addition to MemberTableField_Popup::__construct() - this was broken by r99777
 * [rev:99960] #2022: Fixed CMS dropdowns in Opera.
 * [rev:99952] Fix #2138, allow modification of existing images
 * [rev:99951] Fix #2138, notify Image Toolbar on TinyMCE node selection change
 * [rev:99942] action buttons always visible (not need to scroll) ticket 5051
 * [rev:99942] got rid of double scroll
 * [rev:99942] do not show action buttons (delete/save) when showing result list
 * [rev:99887] Use underscores in names of combined .js (#3581)
 * [rev:99854] Quoting keys in JSONDataFormatter to ensure valid JSON (#5119) (from r99853)
 * [rev:99850] Fix #5097, Translatable uses augmentValidURLSegment to check that URLSegment is valid
 * [rev:99843] Respect SilverStripe's cache folder
 * [rev:99818] Handle filename deduping when uploading of double-barrelled extensions and files ending in numbers better.
 * [rev:99816] Fixed the code for the unused file list, although the feature is still disabled.
 * [rev:99789] #5073: Fixed CMS version indicator for alpha and beta versions.
 * [rev:99779] make siteconfig work again
 * [rev:99777] #5087: Show default values in CTF 'add' popups.
 * [rev:99745] #3458: Don't show javascript:mctmp(0) URLs in URL editor
 * [rev:99739] tree selector base URL calculation wrong when field is nested
 * [rev:99738] #4974: Improve accuracy of ManifestBuilder::parse_file() cache, to remove a source of upgrade bugs.
 * [rev:99713] Fixed MemberTableField limiting of , wasnt taking children groups into account (regression from r99684) (from r99706)
 * [rev:99711] Setting  ID explicitly in MemberTableField-> to ensure getCsvQuery() correctly filters (the custom group filter was only implemented in sourceItems() before) (from r99684)
 * [rev:99693] Changed sitetree default selection in LeftAndMain.Tree.js to fire on window.load instead of document.ready() through entwine. We need to ensure behaviour.js bindings are available before
 * [rev:99693] Automatically selecting root node in CMS trees (necessary because now we actually have forms on the root node, and its a valid click target) (from r99605)
 * [rev:99679] really testing deletemarked now.
 * [rev:99667] Fixed bogus HTMLEditorConfig instance when get() is called without a valid identifier (due to NULL database columns) (from r99599)
 * [rev:99655] Fixed TreeMultiselectField/TreeDropdownField saving with 'unchanged' default values from constructor (from r99581)
 * [rev:99647] Fixed TreeMultiselectField->Field() to respect  settings, and give them priority over existing relations through getItems(). This is used in MemberTableField to set default groups for 'add member' popups. (from r98879)
 * [rev:99640] Fixed DataObject->fieldLabels() to respect  flag (from r98748)
 * [rev:99638] Folder::findOrMake() will create the assets/ folder if it's missing
 * [rev:99613] Fixed bug in r99552
 * [rev:99595] Fixed Access tab on SiteConfig
 * [rev:99594] Debugged and simplified Access tab javascript
 * [rev:99587] Show 'Inherit' option for edit and view all the time (since we now have SiteConfig)
 * [rev:99572] Pages that you can't edit should always be grey, even if there are unpublished changes.
 * [rev:99553] Remove buttons from display if you load a CMS page that should have no buttons - reverts bug caused by r96551 and fixes the issue it was trying to solve.
 * [rev:99552] Fixed behaviour's ID selector matching when the ID is inside another context - eg 'body.className #ID'
 * [rev:99522] Image::onBeforeDelete() now calls deleteFormattedImages() so resampled images in the filesystem are cleaned up
 * [rev:99506] use the correct method for retrieving the report ID
 * [rev:99490] tablename and columns quoted properly
 * [rev:99479] Setting ID = -1 on Security/lostpassword to avoid showing toplevel navigation (see #5086)
 * [rev:99465] Correct StaticPublisher filenames, now works with nested URLS
 * [rev:99443] batch_permission_check returns null rather than empty array when user has no permissions
 * [rev:99394] Fixed variable existence checks in setValue() in FormField::__construct() by checking for !== NULL (changed from isset($value) to $value in r99360)
 * [rev:99391] Fixed MoneyField constructor - parent (FormField) constructor calls setValue() already, which needs to happen *after* setting certain field instances
 * [rev:99342] Enforcing creation of temp database in SapphireTest->setUp() to avoid writing to production databases. This check should only kick in for single test case runs, as the temp database connection should be set in a dev/tests/all run after the first db-related test anyway. (see #5034)
 * [rev:99303] Disable some permission caching for now, as it was breaking unit tests (from r98504)
 * [rev:99302] SiteTree::batch_permission_check() doesn't recurse with ID=0 calls
 * [rev:99128] Fix not being able to print/export reports (from r98684)
 * [rev:99125] Fixed cache prepopulation on sitetree load. (from r98651)
 * [rev:99124] Make sure navigation links update when urlsegment is changed (from r98649)
 * [rev:99116] Fix navigator links not opening in new windows. (from r97510)
 * [rev:99115] Fixed bug in r97395 (from r97508)
 * [rev:99101] Take into account tablename with custom columns in get_title_sql (from r97003)
 * [rev:99100] use proper quotes for sep (from r96401)
 * [rev:99089] Only show live link when page has been published (from r97839)
 * [rev:99087] Make sure draft/published links go to the right subsite (from r97747)
 * [rev:99086] Fix navigator links not opening in new windows. (from r97510)
 * [rev:99085] Show a hand icon and better title for the 'share link' piece of the navigator toolbar. (from r97439)
 * [rev:99067] Ensure that ModelAsController::init() can trigger redirections. (from r98702)
 * [rev:99065] Fixed SiteTree_versions version numbers for published virtual pages. (from r98675)
 * [rev:99060] fixed query to get number of unmoderated comments
 * [rev:99052] Generate SiteTree_version records for VirtualPages more reliably. (from r98309)
 * [rev:99050] fix incorrect link in CMS (from r97408)
 * [rev:99049] Make sure CMS link knows when its currently in the CMS (from r97403)
 * [rev:99031] Don't show FailedLoginCount field unless Member::$lock_out_after_incorrect_logins is enabled
 * [rev:99005] Development server list should be retained when user submits installer form and gets redirected back
 * [rev:98957] fix for #5076
 * [rev:98946] the ID should be that of untranslated child (it's the middle segment that's from translated version, not the last one)
 * [rev:98944] testing framework needs to be reset to a clean state after each test: now also nested urls and redirection state will be reverted
 * [rev:98897] Fixed strpos() check in BASE_URL check
 * [rev:98895] Installer now opens if mod_rewrite is disabled. Using index.php instead of rewriting the URL didn't quite work with the new BASE_URL, so we need to take this case into account as well
 * [rev:98869]