#  2.3.2 (2009-06-18)

## Upgrading

### Feature Changes

#### CMS image alignment changes

Image alignment elements have been changed slightly. There are no longer any `<DIV>` elements created with the images
using the insert image toolbar in the CMS.

All of these selectors in your typography.css are affected:

*  div.image.left
*  div.image.right
*  div.image.leftAlone
*  div.image.center

They need to be changed to the following (respectively):

*  img.left
*  img.right
*  img.leftAlone
*  img.center

Here's an example of how the default Blackcandy theme was changed:

[http://open.silverstripe.org/changeset/75917/themes/blackcandy/branches/2.3/blackcandy/css/typography.css](http://open.silverstripe.org/changeset/75917/themes/blackcandy/branches/2.3/blackcandy/css/typography.css)

#### Translatable Datamodel

The datamodel for the Translatable extension was changed from multiple language tables to multiple rows for each
translated record in the original table. We've also introduced the concept of "Translation groups", which means not
every translated record has to exist in a "master language". Please review our updated documentation on how to [enable Translatable](/topics/translation).

If you are upgrading an existing database with existing translations, you'll need to run our [Migration Script](/topics/translation#migrating_from_2.1_datamodel) before using the
database. 

For in-depth discussion of the schema changes and translation groups, please refer to our developer mailinglist:
[1](http://groups.google.com/group/silverstripe-dev/browse_thread/thread/91e26e1f78d3c1b4/bd276dd5bbc56283?lnk=gst&q=translatable#bd276dd5bbc56283)
and
[2](http://groups.google.com/group/silverstripe-dev/browse_thread/thread/575001296360a1cc/e3268963c6d8cef7?lnk=gst&q=translatable#e3268963c6d8cef7).

#### Translatable property selection

It is no longer possible to exclude certain properties on a DataObject from being translatable. This is a limitation by
our database schema choice. See
[discussion](http://groups.google.com/group/silverstripe-dev/browse_thread/thread/2b3df26361d17119/be8f9f08a797bd43?lnk=gst&q=translatable#be8f9f08a797bd43)
on our mailinglist and ticket [#3722](http://open.silverstripe.com/ticket/3722).

#### Translatable URLs

Every page is now forced to have a unique URL, different languages can't be switched by appending a `?lang=xx`
property any longer. Languages don't have to be set in sessions or cookies, as every request is able to determine the
language for the remaining site by inspecting the URL. Unique URLs are enforced because of SEO concerns, problematic
caching on proxies, browser and framework-level, as well as difficult debugging with session states. See
[discussion](http://groups.google.com/group/silverstripe-dev/browse_thread/thread/17908f7318decfac/0c2b2e2a07ea6955?lnk=gst&q=translatable+url#0c2b2e2a07ea6955)
on our mailinglist.

### API Changes

#### Important, but simple, ModelAdmin change

The configuration statics for ModelAdmin have been changed from protected to public, so that `Object::get_static()`
can access them.  In particular the following static variables have been changed.

*  `ModelAdmin::$managed_models`
*  `ModelAdmin::$collection_controller_class`
*  `ModelAdmin::$record_controller_class`
*  `ModelAdmin::$model_importers`
*  `ModelAdmin::$page_length`

Because of this, you will need to change the static definitions in your ModelAdmin subclasses.  For example, you should
change this:

	:::php
	class MyCatalogAdmin extends ModelAdmin {
	   
	  protected static $managed_models = array(
	      'Product',
	      'Category'
	  );
	 
	  ... 
	}


To this:

	:::php
	class MyCatalogAdmin extends ModelAdmin {
	   
	  public static $managed_models = array(
	      'Product',
	      'Category'
	  );
	 
	  ... 
	}



#### Deprecated Translatable::enable()

 * Use ''Object::add_extension('SiteTree','Translatable'')'' instead of `Translatable::enable()`
 * Use ''Object::remove_extension('SiteTree','Translatable'')'' instead of `Translatable::disable()`
*  Use ''Object::has_extension('SiteTree','Translatable'')'' instead of `Translatable::is_enabled()`

#### Deprecated Translatable "lang" methods


##  2.3.2-rc4

###  Bugfixes

 * ![rev:79278] Fixed TranslatableTest->testSavePageInCMS(), needed admin login to edit ViewersGroups field (Merged via: r79282)
 * ![rev:79269] Excluding Access fields on SiteTree from Translatable->updateCMSFields(), as their original values break the javascript logic for showing/hiding the fields (Merged via: r79282)
 * ![rev:79266] Passing locale through to TreeSelectorField ajax calls (Merged via: r79282)
 * ![rev:79240] Marking new TreeMultiSelectField_Readonly with $readonly flag, otherwise breaks CMS saving with Translable enabled etc. (see #4240)

##  2.3.2-rc3

###  Enhancement

 * ![rev:78919] DevelopmentAdmin: Changed dev/build to produce nicer formatting when running from sake/dev/build CLI
 * ![rev:78618] Add HTMLText#FirstSentence based on new HTMLText#Summary

###  API Change

 * ![rev:78632] Added increase_memory_limit_to() for increasing but not decreasing memory limit.
 * ![rev:78618] Added two arguments to HTMLText#Summary. Minimal impact since previously any usage of this function threw an error.

###  Bugfixes

 * ![rev:79208] Don't remove translation groups in Translatable->onBeforeDelete() if the decorated record uses Versioned, as other representations of the record might still exist in other tables (e.g. SiteTree_Live) (see #4219) (Merged via: r79211)
 * ![rev:79194] Writing Locale in Translatable->onBeforeWrite() regardless of the record ID existing (see #4232). This is more in line with Translatable->requireDefaultRecords() which automatically updates all NULL locale values anyway. (Merged via: r79195)
 * ![rev:78920] DevelopmentAdmin: Don't allow dev/reset to be run from CLI, as this could be accidentally run - give a message that the user should run this from their web browser instead
 * ![rev:78732] #4119: Fixed encoding of readonly TextareaFields and unicode in TextareaFields.
 * ![rev:78729] Fixed Translatable->requireDefaultRecords() for non-SiteTree objects (was assuming Versioned to be present) (Merged via: r79195)
 * ![rev:78728] A couple of bugfixes on HTMLText#Summary and HTMLText#FirstSentence so the trickiest tests pass
 * ![rev:78618] Replace HTMLText#Summary with one that works.
 * ![rev:78542] Don't allow the use of get-var ?isDev=1 when security DB isn't available.
 * ![rev:78496] WidgetAreaEditor shouldn't ever call editable segment "NoWidgets" - this is just a placeholder
 * ![rev:78471] Fixed readonly version of TreeMultiselectField
 * ![rev:78470] Get backtrace rather than crazy context stuff shown in dev error messages
 * ![rev:78469] Fix readonly versions of grant fields.
 * ![rev:78452] fixed spelling of spam protector
 * ![rev:78352] modified convertDataObjectWithoutHeader to handle empty relationships.
 * ![rev:78256] Removing operating system limitations for Flash Player checks which determine showing/hiding of upload button (which currently requires exactly FP9 in our version of SWFUpload). See #3679 and #3023 for followup tickets.
 * ![rev:78155] Changing from unset record entry to an empty value shouldn't register as a 'level 2' change
 * ![rev:78118] Using language dropdown to determine locale for partial tree ajax loads, because we can't rely on a page with a hidden "Locale" field being loaded in the CMS. Fixed bug with wrong spelling of "locale" argument. (see #3995). (Merged via: r78119)
 * ![rev:76517] Closing `<link type="alternate">` tags for XHTML compliance on Translatable->MetaTags(). Use ContentNegotiator to transform them back to HTML markup. See #3989 (Merged via: r78167)

##  2.3.2-rc2 Changelog

###  API Change

 * ![rev:77658] Added DataDifferencer, for comparing DataObjects.  Note that it won't be used by the core features until 2.3.3, but is made available here for the cmsworkflow module.
 * ![rev:77385] Removed @deprecated 2.3 JS function ingize() from LeftAndMain.js: Please use ss.i18n instead


###  Bugfixes

 * ![rev:77937] fixed is_array error in TableListField. #4123
 * ![rev:77849] Fixed bugs in previous change to DOD
 * ![rev:77822] Fix edge-case bug with application of decorators
 * ![rev:77766] #4133 Fixed case where ComplexTableField failed to detect a has_many relation from the parent
 * ![rev:77737] fixed #4119 by using htmlentities rather then Convert functions
 * ![rev:77733] #4113: Fixed bugs with template processing in i18nTextCollectorTask.
 * ![rev:77727] #4119 netminds: Fix error page publication for lang to locate replacement.
 * ![rev:77726] a redirection with an external link that has more than one query string variables. Do not convert the link to html entities
 * ![rev:77662] #2328: Show backtrace for uncaught exceptions (merged from r70444)
 * ![rev:77596] fixed clearing issue with IE7
 * ![rev:77553] Removed spurious console.log() functions (merged from r77552)
 * ![rev:77528] missing unmoderated action in CommentAdmin.php
 * ![rev:77461] Ensure that when a page is deleted from stage or live, its descendants are also deleted.

###  Minor changes

 * ![rev:78083] Reverted r78055, it breaks TableListFieldTest and doesn't actually fix the bug it was supposed to (PHP segfaulting)
 * ![rev:78082] Merged from trunk
 * ![rev:78081] Merged from trunk
 * ![rev:77992] Merged from trunk
 * ![rev:77766] Updated tests for ComplexTableField
 * ![rev:77595] fixed layout for SelectionGroup file
 * ![rev:77554] mergeinfo
 * ![rev:77384] Removed cases where GhostPage was being unset from the tests
 * ![rev:77381] Removed unused ReportField_Controller URL rule from cms/_config.php

##  2.3.2-rc1 (changes since 2.3.2-beta1)

###  API Change

 * ![rev:77006] Deprecated Translatable::set_reading_lang(), use Translatable::set_current_locale().
 * ![rev:76853] Deprecated Translatable::current_lang(), use Translatable::get_current_locale() (Merged via: r76855)
 * ![rev:76839] Deprecated Translatable->getTranslatedLangs(), use getTranslatedLocales()
 * ![rev:76723] Added SiteTree::doDeleteFromLive()
 * ![rev:76666] Made batch actions pluggable through CMSBatchActionHandler::register()
 * ![rev:76207] When there are script tags in the body, put requirements script just before them, instead of at the very top of the body.  Since this reduces the cost of the (sometimes necessary) script tags in the body, the notice-level error has been removed.


###  Bugfixes

 * ![rev:77282] WidgetAreaEditor gets it's related WidgetArea using getComponent(), a more robust way of getting the component
 * ![rev:77259] Fixed Debug::friendlyError() to use Translatable::get_current_locale() instead of deprecated Translatable::current_lang()
 * ![rev:77256] Fixed undefined variable $langAvail in Translatable
 * ![rev:77242] Added a missing default english string to ADDITEM translatable entity in TableField.ss
 * ![rev:77140] If CTF doesn't have a parent class (set to false), avoid breakages in ComplexTableField::getFieldsFor()
 * ![rev:77111] #4082 - Translatable CMS fields layout broken in IE6
 * ![rev:77031] Add JavaScript for HtmlEditorField on every CMS page, to avoid issue where loading form with HtmlEditorField via ajax doesn't work because scripts are stripped out.
 * ![rev:77016] TableListField items couldn't be deleted because TableListField_ItemRequest::__construct() didn't call parent::__construct()
 * ![rev:76955] Make requirements combiner work with jQuery
 * ![rev:76949] #4038 If attempting to set a default locale that doesn't exist, throw a warning in Translatable::set_default_locale()
 * ![rev:76948] Fixed case where SiteTree->getCMSFields() is missing a parent page, and thus it results in a non-object
 * ![rev:76930] Fixed potential non-object error in LeftAndMain::callPageMethod()
 * ![rev:76913] Fixed missing tinymce_template bug in ReportAdmin
 * ![rev:76896] Fixed ErrorPage not showing up properly due to a SQL query that was merged from trunk not compatible with 2.3
 * ![rev:76890] #4058 Requirements::process_combined_files() fixed small typo in the output
 * ![rev:76881] #4068 - Fixed spelling mistake in en_US.php
 * ![rev:76875] Fix javascript error in IE caused by Changeset 76845 where reloading a page would trigger a resetChanged before the tinyMCE instance existed
 * ![rev:76872] Using Translatable::set_default_lang() for the deprecated i18n::set_default_lang() - this should trigger lang->locale convertion, and fix issues with running a 2.2->2.3 database schema migration (see #4009) (Merged via: r76873)
 * ![rev:76870] Fixed CMSMain->LangSelector() default language selection (Merged via: r76871)
 * ![rev:76866] Added translation groups for existing entries the first time Translatable is switched on through Translatable->requireDefaultRecords() (see #4051) (Merged via: r76867)
 * ![rev:76852] Fix issue with 'clear' button on CMS SiteTree search
 * ![rev:76841] Fixed tab layout for add form of model admin (Merged via: r77326)
 * ![rev:76765] typo by legacy: ViewersGroup -> ViewerGroups, EditorsGroup -> EditorGroups
 * ![rev:76731] Removed obsolete CMSMain->EditingLang(), not used any longer (see #3997) (Merged via: r76733)
 * ![rev:76730] Fixed selected image hilighting, when inserting images into WYSIWYG, on IE
 * ![rev:76729] Fixed WidgetAreaEditor javascript in IE
 * ![rev:76726] Don't show the upload tab on readonly folders.
 * ![rev:76702] Made TableListField::export() more memory efficient for large exports.
 * ![rev:76655] Limit "show deleted pages" in CMS tree to current language (see #3994) (Merged via: r76656)
 * ![rev:76650] Made SideTabs and SideReports work with Translatable by explicitly passing a "locale" GET parameter (see #4014) (Merged via: r76653)
 * ![rev:76613] Fixed "Translations" tab display in CMS - no more duplication of original language and translated tab - see #4020 (Merged via: r76614)
 * ![rev:76611] Creating a translation of a new page in a new language fails - fixed by adding locale to /createtranslation ajax call (see #4021) (Merged via: r76612)
 * ![rev:76608] Fix getsubtree command in CMS tree to work with Translatable (#3995) (Merged via: r76609)
 * ![rev:76603] Return NULL in Versioned::get_latest_version() if no record was found (fixes #4015) (Merged via: r76605)
 * ![rev:76508] Escaped SiteTree.ID in LinkTracking selection so that show deleted pages would work.
 * ![rev:76457] fixed escaping of code in textarea fields
 * ![rev:76435] fixed treedropdownfield cropping long names off
 * ![rev:76374] Ensure that the return object of File::find() is an instance of Image in HtmlEditorField_readonly::HtmlEditorField_dataValue_processImage()
 * ![rev:76268] Fix modeladmin scrollbars in ie7
 * ![rev:76258] Fixed scenarios where the page is readonly and the expected ParentType elements don't exist causing a JS error (Merged via: r76260)
 * ![rev:76172] Fixed calls to uninherited() that returned no static in some cases, replacing with faster Object::get_static() calls (Merged via: r76205)
 * ![rev:75027] Fixed Locale duplication detection for queries in Translatable->augmentSQL() (Merged via: r76593)
 * ![rev:70325] Altering parent getCMSFields() results in RedirectorPage instead of starting with an empty FieldSet, as this discards any tabs and fields which are not explicitly mentioned in the implementation like the ability to create a translation. (Merged via: r76515)
 * ![rev:70306] Don't require a record to be written (through exists()) when checking Translatable->isTranslation() or Translatable->hasTranslation()


###  Enhancement

 * ![rev:77266] Added databse name to output of dev/build (merged from r77265)
 * ![rev:77265] Added databse name to output of dev/build (Merged via: r77266)
 * ![rev:77264] Added option for putting integers into SS_DATABASE_CHOOSE_NAME in _ss_environment.php, so that a parent/grandparent folder name can be used as the database name (merged from r77261).
 * ![rev:77261] Added option for putting integers into SS_DATABASE_CHOOSE_NAME in _ss_environment.php, so that a parent/grandparent folder name can be used as the database name. (Merged via: r77264)
 * ![rev:76944] Significant speed up for SiteTree Filter
 * ![rev:76847] Add SSMacron plugin for inserting macron characters
 * ![rev:76845] Use new HtmlEditorConfig API to specify options for CMS HtmlEditorField
 * ![rev:76840] Using standard LanguageDropdownField in CMSMain->LangSelector() (Merged via: r76843)
 * ![rev:76839] Added $instance parameter to LanguageDropdownField to call instance-specific canTranslate() on it (optionally) (Merged via: r76842)
 * ![rev:76779] Correct issue with SiteTree filtering not persisting and add drop down for page type and clear button. Part of a re-work of the search system
 * ![rev:76666] Added batch actions for unpublish and delete from published.
 * ![rev:76594] Improved TranslatableTest->testCreateTranslationTranslatesUntranslatedParents() to translate two grandchildren - this used to be an issue in branches/2.3 (see #4016) (Merged via: r76597)
 * ![rev:70306] Adding link back to original page in CMS editform for translations


###  Other

 * ![rev:77326] Merged from trunk
 * ![rev:77071] the sort
 * ![rev:77051] Fix a PHP segfault
 * ![rev:76942] API: Allow specifying any callback to setMarkingFunction, not just a function name.
 * ![rev:76844] API: Move the TinyMCE configuration from a javascript file to a php system, to allow for site specific and section specific html editor options.
 * ![rev:76779] @todo: Tests, speed optimisation, proper connection of filtering with tree control checkboxes
 * ![rev:76260] Merged from trunk
 * ![rev:76205] Merged from trunk
 * ![rev:71917] NOTFORMERGE: Added custom batch actions and a 'show generic/customised' checkbox to the oriwave CMS.  When upgrading to 2.3 or 2.4, we should use this code as a use-case for a new API that lets us customise the CMS interface.  The JavaScript refactoring work we do might want to bear this in mind, to make such customisations easier. (Merged via: r76666)



##  Beta 1 - since 2.3.1

###  New Features

 * ![rev:75153] Allow Title and Navigation Label to be searched separately
 * ![rev:74739] hooks into form field to allow custom error messages. Note does not currently apply to the behaviour / js. Just the PHP validation
 * ![rev:74538] make PasswordField and ConfirmedPasswordField able to either readonly or disabled.
 * ![rev:74503] make PasswordField and ConfirmedPasswordField able to either readonly or disabled.
 * ![rev:74327] added $Var.UpperCase support to DBField
 * ![rev:74326] allow you to disable ?m suffixing of requirements
 * ![rev:74248] optionally allow sorting toDropdownMap() function. Patched from #3829
 * ![rev:73670] added after uploading notify method
 * ![rev:70327] Enabled specifying a language through a hidden field in SearchForm which limits the search to pages in this language (incl. unit tests) (Merged via: r74986)


###  API Change

 * ![rev:75913] Deprecated ModelAsController->get404Page() with using the URLSegment "404" on a normal page type - please use the ErrorPage class instead (Merged via: r75916)
 * ![rev:75742] Deprecated Translatable::get_langs_by_id() - use getTranslations()
 * ![rev:75328] Deprecated Translatable::get_homepage_urlsegment_by_language(), use get_homepage_urlsegment_by_locale() (Merged via: r75685)
 * ![rev:74969] Deprecated DataObjectSet->toDropDownMap() and made it an alias of map(), copying the functionality of toDropDownMap() into map()
 * ![rev:74901] add documentation to changeset r74858.
 * ![rev:74858] BulkLoader::getImportSpec() call DataObject::fieldLables() with $includerelations as false, so that the relations is separated from column fields
 * ![rev:74070] Deprecated Translatable::choose_site_lang(), use choose_site_locale() (Merged via: r74986)
 * ![rev:73951] Removed Translatable::creating_from() - doesn't apply any longer
 * ![rev:73900] Deprecated Object->extInstance(), use getExtensionInstance() instead
 * ![rev:73468] Removed Translatable::get_original() - with the new "translation groups" concept there no longer is an original for a translation
 * ![rev:73466] Deprecated Translatable::set_default_lang(), Translatable::default_lang() (Merged via: r74986)
 * ![rev:73345] Removed CMSMain->switchlanguage() - createTranslation() is sufficient for new, ajax refreshing of CMS state got way too complicated for switching languages, we now just reload the entire CMS with a different ?lang GET parameter (Merged via: r74988)
 * ![rev:73338] Translatable->findOriginalIDs(), Translatable->setOriginalPage(), Translatable->getOriginalPage()
 * ![rev:70307] Removed CMSMain->switchlanguage() (Merged via: r74988)
 * ![rev:70118] Removed obsolete Translatable::table_exists()
 * ![rev:70072] Removed obsolete internal Translatable methods: hasOwnTranslatableFields(), allFieldsInTable()
 * ![rev:69959] Removed Translatable::get_one(), Translatable::write()


###  Bugfixes

 * ![rev:76036] Fixed extraFilter argument for SiteTree::get_by_url() when translatable is enabled
 * ![rev:76019] Unblock blocked requirements when opening a poppup - otherwise
 * ![rev:75984] Removing ParentType and ParentID fields in Translatable->updateCMSFields() as they are causing js problems when set to readonly. These fields should only be set on the original record anyway (at least as long as we don't have a multi-language capable TreeMultiSelectField). (Merged via: r76035)
 * ![rev:75983] Removed URLSegment detection from Translatable->onBeforeWrite() - it was always preceeded by SiteTree->onBeforeWrite() which already alters the URL, so the appending of locale values to disambiguate the URL was pointless (never triggered) (Merged via: r76035)
 * ![rev:75936] Resetting default language in TranslatableTest - this was breaking VirtualPageTest before (Merged via: r75937)
 * ![rev:75926] Fixed undefined var error in VirtualPage (Merged via: r75937)
 * ![rev:75922] Resetting Translatable locale in SearchForm after querying - this was causing side-effects when running TranslatableSearchFormTest in combination with other Translatable tests (Merged via: r75937)
 * ![rev:75920] Ensure that when template content is being parsed by Email::parseVariables(), template path comments don't show
 * ![rev:75919] Ensure that template path comments don't make it into ViewArchivedEmail
 * ![rev:75915] Fixed wrong parameter in ErrorPage::get_static_filepath() (Merged via: r75916)
 * ![rev:75914] Fixing assets filepath in Debug::friendlyError() (Merged via: r75916)
 * ![rev:75873] Automatically publish virtual pages when their source pages are published
 * ![rev:75869] #3970: Make virtual page editing work.
 * ![rev:75831] Checking for existing value on TreeDropdownField->performReadonlyTransformation() - this broke the ReadonlyTransformation on Translatable->updateCMSFields() for the new "ParentID" field in SiteTree->getCMSFields()
 * ![rev:75826] Removing the appended querying for NULL or empty Locale values in Translatable->augmentSQL() - this should no longer be necessary as we set default locales to all records through Translatable->requireDefaultRecords() (Merged via: r75838)
 * ![rev:75791] Fixed ErrorPage::get_filepath_for_errorcode() to work with locale values instead of short language subtags (Merged via: r75838)
 * ![rev:75787] Fixed faulty regex that broke rewritten links to be relative to the base href
 * ![rev:75785] set when ajax is disabled for commenting that we redirect manually down to the comment form
 * ![rev:75782] Unified locale values between i18n::$all_locales and $common_locales - the common locales should be a subset of all locales, without any additional ones as this might cause side-effects with LanguageDropdownField (see #3958) (Merged via: r75783)
 * ![rev:75745] Fixed DBLocaleTest (Merged via: r75746)
 * ![rev:75743] #3959: Fixed auto-setting has many relations on CTF - works mostly like the many-many relation auto setting.
 * ![rev:75733] Allow insertion of object tags (such as youtube vids) into WYSIWYG's HTML view
 * ![rev:75705] Fixed right hand image add/edit form panel sizing
 * ![rev:75675] Fixed i18n::get_locale_from_lang() to return original parameter if it detects a fully qualified locale that shouldn't be converted (Merged via: r75685)
 * ![rev:75654] Fixed PageCommentInterface $this->class being NULL because parent::__construct() wasn't called
 * ![rev:75614] Fixed refactoring of getRecord() so that it can handle currentPage() calls properly.
 * ![rev:75611] Let CMS users open pages deleted from draft; bug introduced by translatable.
 * ![rev:75585] Updated DataObjectSet::map() to use empty string, rather than 0, as the empty value
 * ![rev:75328] Updated enabling mechanism in Translatable->alternateGetByUrl()
 * ![rev:75270] #3740: Fixd duplicate tab highlight in ModelAdmin, by moving back to old tabstrip.js
 * ![rev:75269] #3740: Make tabstrip.js less picky about the URL before the # link
 * ![rev:75263] Fixed HTTPRequest::send_file() to actually output the response, whereas before it did nothing
 * ![rev:75258] Fixed HTTPRequest::send_file() to send the file properly over SSL with Internet Explorer. Without the pragma header, it won't work
 * ![rev:75249] Correctly showing the available languages dropdown in Translatable->getCMSFields() (Merged via: r75685)
 * ![rev:75248] Only force DataObject->forceChange() on fields which aren't already marked as changed (Merged via: r75685)
 * ![rev:75226] Let users open the root folder in Files and Images section
 * ![rev:75223] Disable warning about PastMember cookie if contnet was sent too early.
 * ![rev:75182] Make sure tabs resize correctly when they are loaded
 * ![rev:75180] Make sure tabs are resized correctly on first load
 * ![rev:75161] Disable Geoip if in CLI mode - this fixes the tests from breaking. The geoip command won't be available in CLI context
 * ![rev:75156] Setting Classname and RecordClassname properties on internal $record map when constructing a DataObject without passing $record into it. This ensures that getChangedFields() works on ClassName as well, which is required for Translatable->onBeforeWrite() (Merged via: r75685)
 * ![rev:75151] #3919: Fix DataObject::dbObject() for decorated fields (Merged from r75150)
 * ![rev:75150] #3919: Fix DataObject::dbObject() for decorated fields (Merged via: r75151)
 * ![rev:75126] Fixed incorrect spelling of "$this" variable
 * ![rev:75125] Fixed CSVParser constructor not passing the arguments to the protected variables delimiter and enclosure
 * ![rev:75121] #3681: Added dynamic width style to container div for TinyMCE-inserted images, so if the user resizes, the div width resizes too. Thanks to ajshort for the patch!
 * ![rev:75119] Fix DropdownField to select the correct option when using a map with "0" as an array key - useful for boolean searching using DropdownField
 * ![rev:75116] Fixed alternative database not being reset back to the normal one after TestRunner is finished
 * ![rev:75113] Fixed image editing panel padding in CMS "Insert image" button being squashed
 * ![rev:75096] Allow execution of actions (such as Page's search) on ErrorPage; limit the 404 display to the index() action
 * ![rev:75095] Use rendered page for 404 pages
 * ![rev:75049] Ensure that CheckboxField always returns 1 from the form request data instead of "on" - this was because the value attribute didn't exist on the `<input>` tag
 * ![rev:75046] Make sure that CheckboxField sets it's value as either 1 or 0, so that saveInto() saves the proper boolean value
 * ![rev:75045] Ensure that CheckboxField setValue() always sets it's value as either 1 or 0, even though the request data can come through as "on"
 * ![rev:75039] Fixed case where logging in with a session member ID that didn't exist in the database stopped you from being able to "Log in as someone else"
 * ![rev:75038] #3594: Made WYSIWYG editor 50% larger
 * ![rev:75034] Select correct default data formatter in restfulserver when there's an apparently useful Accept header that doesn't actually match a data formatter{
 * ![rev:75032] Fixed "Log in as someone else" action failure when submitting MemberLoginForm while logged in
 * ![rev:75030] when load a new Page (or other type of form in DataAdmin or GenericAdmin), initTabstripe called additional time for every tabstrip on the page
 * ![rev:75023] Fixed error if clicking the root of a sitetree in the CMS - affected the AssetAdmin and SecurityAdmin sections
 * ![rev:74981] Member::inGroup() returns false instead of an error if group doesn't exist. Ticket #3813 - thanks bgribaudo!
 * ![rev:74980] Fixed ajax deletion of Group records properly - the site tree items didn't disappear immediately after deleting
 * ![rev:74978] Fixed spelling mistake of "getOrientation" method name on Image
 * ![rev:74961] Fixed error if JS/CSS requirements have arguments. Ticket #3860. Thanks simon_w!
 * ![rev:74951] Fixed CMSMainTest->testThatGetCMSFieldsWorksOnEveryPageType() - was comparing a string $class with instanceof() instead of comparing the actually created instance (Merged via: r74988)
 * ![rev:74942] Fixed TranslatableSearchFormTest->setUp() method (Merged via: r74986)
 * ![rev:74927] Clearing Requirements in ScaffoldingComplexTableField, and fixed constructor arguments
 * ![rev:74924] Explicitly destroy TinyMCE instances when loading a new page, in an attempt to reduce memory leaks
 * ![rev:74920] Moving Requirements for AssetTableField, CommentTableField and MemberTableField from __construct() into FieldHolder() and renderWith(), which means inclusion closer to render time, and less side-effects by a previous Requirements::clear(), e.g. in a CTF popup. See r74919
 * ![rev:74919] Moving Requirements for TableField, TableListField, ComplexTableField, ScaffoldComplexTableField and HasManyComplexTableField from __construct() into FieldHolder() and renderWith(), which means inclusion closer to render time, and less side-effects by a previous Requirements::clear(), e.g. in a CTF popup
 * ![rev:74904] Removed unnecessary requirements from ComplexTableField_Popup: LeftAndMain.js, LeftAndMain_right.js, TableField.js, ComplexTableField.js - they will be included by the fields if necessary
 * ![rev:74902] Making sure all input fields inside a newly added TableField row have unique HTML ids. This was causing problems when javascript logic was acting on those (previously ambiguous fields), e.g. when trying to use a jQuery UI datepicker
 * ![rev:74899] If validator doesn't exist on Form, don't attempt to call setForm() on it or you'll get a non-object error
 * ![rev:74879] Removed additional $ sign that isn't supposed to be there that broke GroupTest
 * ![rev:74725] Fixing CurrencyField serverside and javascript validation to accept numbers with leading or trailing spaces
 * ![rev:74721] Fixing NumericField serverside validation to accept numbers with leading or trailing spaces by using trim()
 * ![rev:74657] Fixed NumericField javascript validation to not fail on numbers with trailing or leading whitespace
 * ![rev:74620] Added missing default english text for "No items found" in TableListField.ss
 * ![rev:74489] add more condition before $this->form is used as Caller since $this->form can still not be set yet in a certain circumstance.
 * ![rev:74487] A SoapServer will cache the wsdlFile when it is first initialized and never get updated if the constructor is not explicitly passed in 'cache_wsdl' as WSDL_CACHE_NONE.
 * ![rev:74477] fixed typos in ResetFormAction
 * ![rev:74397] Added missing "Created" and "LastEdited" fields to the MemberTableField export fields
 * ![rev:74391] fixed overflow being hidden
 * ![rev:74322] Allows DataObjectDecorators and other extensions to specify setters (setFoo) in the same manner as the already working Getters (getFoo).
 * ![rev:74303] Allow testing of emails when Email::send_all_emails_to() is set
 * ![rev:74272] fixed issue with greyscale GD - patch from camspiers
 * ![rev:74098] Fixed javascript error in CommentTableField.js where input elements were not being correctly picked up, due to the form HTML change
 * ![rev:74097] Search filter should retain the existing query instead of removing it after each search in MemberTableField and CommentTableField
 * ![rev:74092] Fixed issue with StaticPublisher->onAfterWrite() failing because of incorrect arguments to Versioned::get_by_stage()
 * ![rev:74071] Fixed Form_EditForm_Locale reference in LeftAndMain_right.js (used to be Form_EditForm_Lang) (Merged via: r74988)
 * ![rev:74069] Fixed legacy handling of Translatable::enable(),Translatable::disable() and Translatable::is_enabled() - applying extension to SiteTree instead of Page to avoid datamodel clashes (Merged via: r74986)
 * ![rev:74065] Re-added Translatable->isTranslation() for more friendly deprecation (originally removed in r73338) (Merged via: r74986)
 * ![rev:73900] Unsetting all cached singletons in Object::remove_extension() to avoid outdated extension_instances
 * ![rev:73883] Making $_SINGLETONS a global instead of a static in Core.php so it can be re-used in other places (Merged via: r74986)
 * ![rev:73836] Removed version number from `<meta>` generator tag - opt for security by obscurity in this case (originally committed in r70422 and r71172) (Merged via: r73837)
 * ![rev:73775] fixed cropping of TreeDropdownField popups and Date popups within complextablefield popups
 * ![rev:73758] #3798 ajshort: Let searchcontext be used on sitetree
 * ![rev:73608] fixed choppy gradient (or lack thereof) in the tinymce window
 * ![rev:73603] updated FormTest with fullstop
 * ![rev:73594] Fixed layout of cms rhs area buttons
 * ![rev:73593] Simple toolbar alteration to make toolbar fit at 1024x768
 * ![rev:73533] Fix call to undefined "_12Hour" function (merged from r73523)
 * ![rev:73484] Get installer working with php_short_tags off (Merged r73481-3 from trunk)
 * ![rev:73482] #3758: Fixed config-form.html for use with short_open_tag = off (Merged via: r73484)
 * ![rev:73472] Fixed translatable test execution by making protected methods public (Merged via: r74986)
 * ![rev:73468] Updated MigrateTranslatableTask to new Locale based datamodel (Merged via: r74986)
 * ![rev:73465] Fixed Hierarchy->Children() testing in TranslatableTest - with the new datamodel you can't call Children() in a different language regardless of Translatable::set_reading_lang(), the Children() call has to be made from a parent in the same language (Merged via: r74986)
 * ![rev:73344] Checking for existence of original before trying to get translation in LeftAndMain->currentPage() (Merged via: r74988)
 * ![rev:73343] Changed CSS selector for TranslationTab javascript behaviour to be less specific (Merged via: r74988)
 * ![rev:73342] Removed link to "original page" for a translation - no longer valid
 * ![rev:73341] Disabled auto-excluding of default language from the "available languages" array in LanguageDropdownField - due to the new "translation groups" its possible to have a translation from another language into the default language (Merged via: r74986)
 * ![rev:73339] Disabled "untranslated" CSS class for SiteTree elements - doesn't apply any longer with the new "translation groups" concept (Merged via: r74986)
 * ![rev:73338] Removed bypass in Translatable->AllChildrenIncludingDeleted() (Merged via: r74986)
 * ![rev:73059] Make object cache testing more robust (Merged via: r74986)
 * ![rev:72054] Fixed finding a translated homepage without an explicit URLSegment (e.g. http://mysite.com/?lang=de) - see #3540
 * ![rev:71340] Including Hierarchy->children in flushCache() and renamed to _cache_children. This caused problems in TranslatableTest when re-using the same SiteTree->Children() method with different languages on the same object (even with calling flushCache() inbetween the calls) (Merged via: r74986)
 * ![rev:71297] Only show the LangSelector dropdown if there's multiple languages available on the site (Merged via: r74988)
 * ![rev:71258] Fix translatable being enabled when it shouldn't be (Merged via: r74986)
 * ![rev:70324] Making sure that LeftAndMain->CurrentPage() respects language settings - was returning pages in different language from session after switching between languages in cms (Merged via: r74988)
 * ![rev:70323] Fixed expanded/unexpanded flags on new tree items - was showing expanded styling (plus icon) with newly created pages
 * ![rev:70322] Ensuring that new pages can't be created when in translation mode by disabling the "create..." tree action (Merged via: r74988)
 * ![rev:70318] Reverted special cases for Translatable in Versioned->canBeVersioned() (originally committed in r42119) - was checking for existence of underscores in table names as an indication of the "_lang" suffix, which is no longer needed. It was also a flawed assumption which tripped over classes like TranslatableTest_TestPage (Merged via: r74986)
 * ![rev:70306] Don't require a record to be written (through exists()) when checking Translatable->isTranslation() or Translatable->hasTranslation()
 * ![rev:70214] Falling back to Translatable::current_lang() if no $context object is given, in augmentAllChildrenIncludingDeleted() and AllChildrenIncludingDeleted()
 * ![rev:70138] Disabled assumption that SQLQuery->filtersOnID() should only kick in when exactly one WHERE clause is given - this is very fragile and hard to test. It would return TRUE on $where = "SiteTree.ID = 5", but not on $where = array("Lang = 'de'", "SiteTree.ID = 5") (Merged via: r74986)
 * ![rev:70080] Fix translatable migration not writing records to Live properly (Merged via: r74986)
 * ![rev:69959] Temporarily disabled cookie/session selection in Translatable::choose_site_lang() until we have a good test suite for the side effects.
 * ![rev:60171] Improved DataObject::get_one to avoid PHP segfaults (Merged via: r74986)


###  Enhancement

 * ![rev:75815] Added page location fields in the behaviour tab, as an alternative to drag and drop
 * ![rev:75814] Added page location fields in the behaviour tab, as an alternative to drag and drop
 * ![rev:75793] Running TestRunner tests suites alphabetically through natcasesort() instead of using the (relatively arbitrary) class ordering from ClassInfo::getSubclassesFor() (Merged via: r75838)
 * ![rev:75759] Allow selecting a single field from ComponentSet::getExtraData()
 * ![rev:75742] Added DBLocale class for Translatable extension
 * ![rev:75737] Added 'show deleted pages' function to CMS, with a restore page option.
 * ![rev:75736] Added 'show deleted pages' function to CMS, with a restore page option.
 * ![rev:75678] Adapted MigrateTranslatableTask to new Locale datamodel and fixed some inconsistencies with translation groups, duplicate records etc (Merged via: r75685)
 * ![rev:75677] Added override flag to Translatable::addTranslationGroups()
 * ![rev:75421] Auto-update locale values in Translatable->requireDefaultRecords() with default language when Translatable is first enabled (Merged via: r75685)
 * ![rev:75351] Added nl_NL javascript translations for sapphire, see #3896 - thanks Mad_Clog (Merged via: r75685)
 * ![rev:75349] Added Translatable->MetaTags() to automatically insert `<link rel="alternate" hreflang="...>` tags into the page template (Merged via: r75685)
 * ![rev:75228] #3920: Alllow searching within subfolders in Files and Images section
 * ![rev:75226] #3920: Alllow searching within subfolders in Files and Images section
 * ![rev:75119] Allow "Yes" and "No" english text to be translated
 * ![rev:75037] Added fullscreen button to WYSIWYG toolbar
 * ![rev:75036] #3687: Allow the insertion of iframes (such as google maps snippets) into TinyMCEa
 * ![rev:74941] Using set_up_once() in TranslatableTest and TranslatableSearchFormTest for better test run performance (Merged via: r74986)
 * ![rev:74919] Removed constructor overloading in ScaffoldingComplexTableField, was reconstrcuting its own Requirements (with lots of unnecessary jQuery plugins) which should really be done by the individual form fields and the parent popup class
 * ![rev:74489] add the ability that a SimpleImageField could be disabled.
 * ![rev:74017] Improved deprecated fallbacks in Translatable by auto-converting short language codes to long locales and vice versa through i18n::get_lang_from_locale()/i18n::get_locale_from_lang() (Merged via: r74986)
 * ![rev:73951] Translatable extension is no longer hooked up to SiteTree by default, which should improve performance and memory usage for sites not using Translatable. Please use Object::add_extension('SiteTree','Translatable') in your _config.php instead. Adjusted several classes (Image, ErrorPage, RootURLController) to the new behaviour. (Merged via: r74986)
 * ![rev:73900] Unsetting class caches when using Object::add_extension() to avoid problems with defineMethods etc.
 * ![rev:73884] Added Extension::get_classname_without_arguments() (Merged via: r74986)
 * ![rev:73882] Added DataObjectDecorator->setOwner() (Merged via: r74986)
 * ![rev:73473] Added Object::combined_static(), which gets all values of a static property from each class in the hierarchy (Merged via: r74986)
 * ![rev:73469] Adjusted CMSMain and LeftAndMain to use locales instead of short lang codes when reading and writing translations. See r73468 for details on the underlying Translatable datamodel change (Merged via: r74988)
 * ![rev:73468] Adjusted SearchForm, Debug, ErrorPage, SiteTree to using locales instead of lang codes
 * ![rev:73467] Supporting "Locale-English" and "Locale-Native" as listing arguments in LanguageDropdownField (Merged via: r74986)
 * ![rev:73466] Added Translatable::get_locale_from_lang(), Translatable::get_common_locales(), $common_locales and $likely_subtags in preparation to switch Translatable from using short "lang" codes to proper long locales
 * ![rev:73345] Added CMSMain->IsTranslatableEnabled
 * ![rev:73338] Added check for an existing record in Translatable->createTranslation()
 * ![rev:73059] Added Object::clearCache() to clear a cache
 * ![rev:73036] #3032 ajshort: Use static methods for accessing static data (Merged via: r74986)
 * ![rev:72367] Using IETF/HTTP compatible "long" language code in SiteTree->MetaTags(). This means the default `<meta type="content-language...">` value will be "en-US" instead of "en". The locale can be either set through the Translatable content language, or through i18n::set_locale() (Merged via: r74986)
 * ![rev:72054] Added RootURLController::get_default_homepage_urlsegment() (Merged via: r74986)
 * ![rev:71795] Strip tags before limiting characters when using LimitCharacters() on HTMLText field type
 * ![rev:70326] Added ErrorPage::$static_filepath to flexibly set location of static error pages (defaults to /assets) (Merged via: r74986)
 * ![rev:70319] Disabled Translatab-e>augmentWrite() - was only needed for the blacklist fields implementation which is inactive for the moment
 * ![rev:70308] Removed "Translating mode" status message above edit form - should be clear by the language dropdown above the CMS tree now (Merged via: r74988)
 * ![rev:70307] Simplifying creation logic of new languages in CMS by reloading complete interface, rather than refreshing partial interface, language dropdown etc.
 * ![rev:70306] Adding link back to original page in CMS editform for translations
 * ![rev:70305] Allowing non-default language URLs to be accessed without explicitly specifying the language in GET request (Merged via: r76035)
 * ![rev:70118] Made Translatable constructor arguments optional, as by default all database fields are marked translatable
 * ![rev:70073] Added basic unit tests to new Translatable API
 * ![rev:70072] Added a note about saving a page before creating a translation
 * ![rev:69959] Showing clickable links for Translations in Translatable->updateCMSFields()


###  Other

 * ![rev:76019] HTMLEditorFields won't work
 * ![rev:75915] BUGIFX Changed ErrorPage->publish() to doPublish->doPublish() - the publication of static HTML into the /assets directory was lagging one version behind the actual published content
 * ![rev:75816] Reverted r69824
 * ![rev:75813] Reverted `<div>` being added to images - r69823, r69824
 * ![rev:75812] Reverted r69828
 * ![rev:75784] ENHANCHEMENT: added ability for a form author to set whether user should be redirected back down the the form rather then just back to the old page
 * ![rev:75738] #3927 ENHANCEMENT Added support for many-many auto-setting relations with a standard ComplexTableField
 * ![rev:75703] Merged r75696 from cms/trunk
 * ![rev:75702] Merged r75697 from sapphire/trunk
 * ![rev:75701] Merged r75691 from jsparty/trunk
 * ![rev:75700] Merged r75690 from sapphire/trunk
 * ![rev:75698] Merged r75689 from jsparty/trunk
 * ![rev:75660] Merged from trunk
 * ![rev:75267] Reverted r75263 and r75264
 * ![rev:74988] Merging refactored Translatable from trunk, and related changes to CMSMain
 * ![rev:74986] Merging in refactored Translatable architecture from trunk, including related/required changesets like enhancements to Object static handling (see details below)
 * ![rev:74980] 
 * ![rev:74969] 
 * ![rev:74900] Reverted r74899
 * ![rev:74714] Fix resize being called an additional time for every tabstrip on the page
 * ![rev:74501] Undoing changeset committed in r74490
 * ![rev:74416] fix the bug in Mingle (SC #234):Users reporting a parse error when trying to open grants. also HD(1571).
 * ![rev:74304] Added SiteTree onAfterRevertToLive handler
 * ![rev:74092] 
 * ![rev:73613] Merged r71795 from trunk
 * ![rev:73481] Added a syntax checking test that will use short_tags on and off and asp_tags on (Merged via: r73484)
 * ![rev:73452] Fixed issue with ModelAdmin tab CSS
 * ![rev:71567] 'URLSegment' on line 484 and 494 now escaped (Merged via: r74986)
 * ![rev:70033] Add translation migration task (Merged via: r74986)
 * ![rev:69959] Merged, debugged and enhanced Translatable patches from branches/translatable at r64523, r64523, 64523, thanks wakeless!
 * ![rev:68917] Merged Requirements fix from nestedurls branch (Merged via: r74986)
 * ![rev:68915] Fixed bug in Requirements::disable() (Merged via: r74986)
 * ![rev:68912] Bugfixes for recent staticpublisher imports (Merged via: r74986)
 * ![rev:68911] Bugfix for staticpublisher updates in trunk (Merged via: r74986)
 * ![rev:68900] Static caching merges from dnc branch (Merged via: r74986)
 * ![rev:61495] Fixed bug that was causing phantom pages on DNC - no need to merge, because trunk already has this (Merged via: r74986)
 * ![rev:61493] Fixed bugs with redirector page error message and static publishing - it created blank 'phantom' pages at the top level (Merged via: r74986)
 * ![rev:60015] Set default cache behaviour to uncached.  This is a good new default behaviour and can be merged. Pages that are cacheable should call HTTP::set_cache_age() in their controller init (Merged via: r74986)
 * ![rev:60007] Fixed bug with calling DataObject::flush_and_destory_cache more than once (Merged via: r74986)
