# Installation on Linux, Unix and *nix like Operating Systems

SilverStripe should be able to be installed on any Linux, Unix or *nix like OS as long as the correct server software is installed and configured (referred to a *nix in this document from herein). It is common that web hosting that you may use for your production SilverStripe application will be *nix based, here you may also want to use *nix locally to ensure how you develop locally mimics closely your production environment.

Is important to ensure you check the [Server Requirements](/getting_started/server_requirements) list before acquiring and installing SilverStripe on your *nix server (locally or otherwise).

At a high level you will need a:
* Web server e.g. Apache, Nginx
* Database e.g. MariaDB, Postgres, MySQL
* PHP

##*nix installation guides on the web
There are a number of good step by step guides covering server setups and installing of SilverStripe on the various flavours of *nix systems. 

Note: Many of the following guides simply download SilverStripe as a zipped file. We recommend the use of [Composer](/getting_started/composer/) once you get to the point of installing SilverStripe (though the choice is up to you). Always ensure you get the latest version if you are starting a new project.

###Known (but not exhaustive) list
* [How To Install Silverstripe on Your VPS](https://www.digitalocean.com/community/tutorials/how-to-install-silverstripe-on-your-vps)
* [Running SilverStripe On Nginx (LEMP) On Debian Wheezy/Ubuntu 13.04](http://www.howtoforge.com/running-silverstripe-on-nginx-lemp-on-debian-wheezy-ubuntu-13.04)
* [Setting up nginx, PHP-FPM, and SilverStripe on Fedora 19](http://halkyon.net/blog/setting-up-nginx-php-fpm-and-silverstripe-installation-on-fedora-19/)
* [How to install SilverStripe CMS on a Linux Virtual Server](http://www.rosehosting.com/blog/how-to-install-silverstripe-cms-on-a-linux-virtual-server/)


_If you find further good *nix related installation articles please email these to community+docs@silverstripe.org._