<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('defects', function (Blueprint $table) {
            $table->id();  // Auto-incrementing ID field
            $table->string('defect_name');  // Defect name (string)
            $table->integer('project_id'); // Foreign key to projects table
            $table->string('defect_type');  // Defect type (string)
            $table->text('defect_description')->nullable();  // Defect description (nullable text)
            $table->string('assigned_team')->nullable();  // Assigned team (nullable string)
            $table->integer('estimated_hours')->nullable();  // Estimated hours (nullable integer)
            $table->string('fileupload')->nullable();  // File upload path (nullable string)
            $table->integer('overdue')->nullable();  // Overdue status (default to false)
            $table->string('severity')->nullable();  // Severity of the defect (nullable string)
            $table->string('status')->nullable();  // Defect status (nullable string)
            $table->string('reported_by')->nullable();  // Reported by (nullable string)
            $table->string('assigned_to')->nullable();  // Assigned to (nullable string)
            $table->integer('created_user_id');  // Foreign key to users table (nullable)
            $table->date('start_date')->nullable();  // Start date (nullable date)
            $table->date('end_date')->nullable();  // End date (nullable date)
            $table->timestamps();  // Created at & Updated at timestamps
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('defects');
    }
};
