<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTasksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tasks', function (Blueprint $table) {
            $table->id(); // Auto-incrementing ID column
            $table->string('task_name');
            $table->integer('project_id'); // Foreign key to projects table
            $table->integer('assigned_to'); // Foreign key to users table
            $table->date('due_date');
            $table->enum('task_status', ['pending', 'in-progress', 'completed'])->default('pending');
            $table->enum('priority_status', ['low', 'medium', 'high'])->default('medium');
            $table->date('plan_start_date')->nullable();
            $table->date('plan_end_date')->nullable();
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
            $table->integer('total_hours')->nullable();
            $table->integer('estimate_hours');
            $table->integer('progress')->default(0); // Task progress (percentage)
            $table->text('description')->nullable();
            $table->Integer('creator_id');// Foreign key to users table
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tasks');
    }
}
