<?php

class Project extends Page {
	
	static $has_one = array(
		'MyStudent' => 'Student'
	);
	
	static $many_many = array(
		'Modules' => 'Module'
	);
	
	function getCMSFields() {
		$fields = parent::getCMSFields();
		
		$tablefield = new HasOneComplexTableField(
			$this,
			'MyStudent',
			'Student',
			array(
				'FirstName' => 'First Name',
				'Lastname' => 'Family Name',
				'Nationality' => 'Nationality'
			),
			'getCMSFields_forPopup'
		);
		$tablefield->setOneToOne();
		$tablefield->setAddTitle( 'A Student' );
		
		$fields->addFieldToTab( 'Root.Content.Student', $tablefield );
		
		$modulesTablefield = new ManyManyComplexTableField(
			$this,
			'Modules',
			'Module',
			array(
				'Name' => 'Name'
			),
			'getCMSFields_forPopup'
		);
		$modulesTablefield->setAddTitle( 'A Module' );
		
		$fields->addFieldToTab( 'Root.Content.Modules', $modulesTablefield );
		
		return $fields;
	}
	
}

class Project_Controller extends Page_Controller {
	
}

?>
