<?php

class Mentor extends Page {
	
	static $db = array(
		'FirstName' => 'Text',
		'Lastname' => 'Text',
		'Nationality' => 'Text'
	);
	
	static $has_many = array(
		'Students' => 'Student'
	);
	
	function getCMSFields() {
		$fields = parent::getCMSFields();
		
		$fields->addFieldToTab( 'Root.Content.Main', new TextField( 'FirstName', 'First Name' ) );
		$fields->addFieldToTab( 'Root.Content.Main', new TextField( 'Lastname' ) );
		$fields->addFieldToTab( 'Root.Content.Main', new TextField( 'Nationality' ) );
		
		$tablefield = new HasManyComplexTableField(
			$this,
			'Students',
			'Student',
			array(
				'FirstName' => 'FirstName',
				'Lastname' => 'Family Name',
				'Nationality' => 'Nationality'
			),
			'getCMSFields_forPopup'
		);
		$tablefield->setAddTitle( 'A Student' );
		
		$fields->addFieldToTab( 'Root.Content.Students', $tablefield );
		
		return $fields;
	}
	
	function forTemplate() {
		$template = 'GSOCPerson';
		return $this->renderWith( $template );
	}
	
}

class Mentor_Controller extends Page_Controller {
	
}

?>
